# Documentation

## Getting Started
- [FAQ](FAQ.md)
- [Quickstart](Quickstart.md)
- [Designing with Flecs](DesignWithFlecs.md)
- [Getting Started with Unreal Engine](https://github.com/PreyK/Unreal-Minimum-Viable-Flecs)
- [Unreal-Flecs (Unreal Engine Flecs plugin)](https://github.com/Reddy-dev/Unreal-Flecs)
- [Getting Started with Godot](https://github.com/paulfigiel/godot-flecs-sample)
- [Getting Started with Raylib](https://github.com/kranzky/raylib-flecs-starter-kit)
- [Flecs an Raylib template](https://github.com/aog05/Raylib-and-Flecs-Template)

## Manuals
- [Manual](Manual.md)
- [Entities and Components Manual](EntitiesComponents.md)
- [Query Manual](Queries.md)
- [Query Language Manual](FlecsQueryLanguage.md)
- [Systems Manual](Systems.md)
- [Observers Manual](ObserversManual.md)
- [Prefabs Manual](PrefabsManual.md)
- [Component Traits Manual](ComponentTraits.md)
- [Relationships Manual](Relationships.md)
- [Flecs Script Manual](FlecsScript.md)
- [Flecs Remote API Manual](FlecsRemoteApi.md)
- [v3 Migration Guide](MigrationGuide.md)

## API reference
 - [C API](@ref c)
 - [C++ API](@ref cpp)

## Examples
- [C examples](https://github.com/SanderMertens/flecs/tree/master/examples/c)
- [C++ examples](https://github.com/SanderMertens/flecs/tree/master/examples/cpp)
- [C# examples](https://github.com/BeanCheeseBurrito/Flecs.NET/tree/main/src/Flecs.NET.Examples)
- [Rust examples](https://github.com/Indra-db/Flecs-Rust/tree/main/flecs_ecs/examples/flecs)

## Videos
- [Setting Up The Project (E1)](https://www.youtube.com/watch?v=O632xG7ItL8)
- [Creating Your First World (E2)](https://www.youtube.com/watch?v=ph2FjgNvlO4)
- [Components In Flecs (E3)](https://www.youtube.com/watch?v=4qtdgAN82uo)
- [Tagging Your Creations (E4)](https://www.youtube.com/watch?v=u71cuiyQk-8)
- [Beaty Of Pairs In Flecs (E5)](https://www.youtube.com/watch?v=fJuHMzVC_bE)
- [What is a Prefab? (E6)](https://www.youtube.com/watch?v=qz5eblX8yoc)
- [Some Pointers for C (E7)](https://www.youtube.com/watch?v=0LscDsVy-28)
- [Demistifying Queries Part 1 (E8)](https://www.youtube.com/watch?v=PKvCpUO55yw&t=216s)

(Shoutout to [jellycake222](https://www.youtube.com/@jellycake222) for making the awesome tutorial series <3!)

## Demos
- [Playground (Flecs Script)](https://www.flecs.dev/explorer/?host=flecs_explorer.wasm)
- [Tower Defense (C++)](https://github.com/SanderMertens/tower_defense)
- [City (C)](https://github.com/flecs-hub/city)

## Articles
- [Where are my entities and components](https://ajmmertens.medium.com/building-an-ecs-1-where-are-my-entities-and-components-63d07c7da742)
- [Archetypes and vectorization](https://ajmmertens.medium.com/building-an-ecs-2-archetypes-and-vectorization-fe21690805f9)
- [Storage in pictures](https://ajmmertens.medium.com/building-an-ecs-storage-in-pictures-642b8bfd6e04)
- [Making the most of entity identifiers](https://ajmmertens.medium.com/doing-a-lot-with-a-little-ecs-identifiers-25a72bd2647)
- [Building games in ECS with entity relationships](https://ajmmertens.medium.com/building-games-in-ecs-with-entity-relationships-657275ba2c6c)
- [Why it is time to start thinking of games as databases](https://ajmmertens.medium.com/why-it-is-time-to-start-thinking-of-games-as-databases-e7971da33ac3)
- [A Roadmap to ECS relationships](https://ajmmertens.medium.com/a-roadmap-to-entity-relationships-5b1d11ebb4eb)
- [Why storing state machines in ECS is a bad idea](https://ajmmertens.medium.com/why-storing-state-machines-in-ecs-is-a-bad-idea-742de7a18e59)
- [Why vanilla ECS is not enough](https://ajmmertens.medium.com/why-vanilla-ecs-is-not-enough-d7ed4e3bebe5)
- [ECS: From tool to paradigm](https://ajmmertens.medium.com/ecs-from-tool-to-paradigm-350587cdf216)

## Resources

### Resources provided by the community
Some of these are quite old, and might contain information that is out of date!

- [Extermination Shock Source](https://github.com/Wizard-Of-Chaos/ExShock_code)
- [Bgfx/Imgui module](https://github.com/flecs-hub/flecs-systems-bgfx/tree/bgfx_imgui)
- [Tower defense example](https://gist.github.com/oldmanauz/b4ced44737bf9d248233538fa06a989e)
- [Unreal + Flecs example](https://github.com/PreyK/Unreal-Minimum-Viable-Flecs)
- [Building a space battle with Flecs in UE4](https://twitter.com/ajmmertens/status/1361070033334456320)
- [Flecs + SDL + Web ASM example](https://github.com/HeatXD/flecs_web_demo) ([live demo](https://heatxd.github.io/flecs_web_demo/))
- [Flecs + Raylib example](https://github.com/Lexxicon/FlecsRaylib)
- [Flecs + gunslinger example](https://github.com/MrFrenik/gs_examples/blob/main/ex_demos/flecs/source/main.c)

### Flecs around the web
- [Discord](https://discord.gg/BEzP5Rgrrp)
- [Medium](https://ajmmertens.medium.com)
- [Twitter](https://twitter.com/ajmmertens)
- [Reddit](https://www.reddit.com/r/flecs)
