;; NOTE: Assertions have been generated by update_lit_checks.py --all-items and should not be edited.

;; RUN: foreach %s %t wasm-opt      -all --closed-world --gto --preserve-type-order -S -o - | filecheck %s
;; RUN: foreach %s %t wasm-opt -tnh -all --closed-world --gto --preserve-type-order -S -o - | filecheck %s --check-prefix=T_N_H

;; The descriptor passed in is nullable, so it might trap. We only remove it
;; when traps never happen.
(module
  (rec
    ;; CHECK:      (rec
    ;; CHECK-NEXT:  (type $A (descriptor $B (struct)))
    ;; T_N_H:      (rec
    ;; T_N_H-NEXT:  (type $A (struct))
    (type $A (descriptor $B (struct)))
    ;; CHECK:       (type $B (describes $A (struct)))
    ;; T_N_H:       (type $B (struct))
    (type $B (describes $A (struct)))
  )

  ;; CHECK:      (type $2 (func (param (ref null (exact $B)))))

  ;; CHECK:      (func $test (type $2) (param $nullable (ref null (exact $B)))
  ;; CHECK-NEXT:  (local $A (ref $A))
  ;; CHECK-NEXT:  (local $B (ref $B))
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (struct.new_default $A
  ;; CHECK-NEXT:    (local.get $nullable)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  ;; T_N_H:       (type $2 (func (param (ref null (exact $B)))))

  ;; T_N_H:      (func $test (type $2) (param $nullable (ref null (exact $B)))
  ;; T_N_H-NEXT:  (local $A (ref $A))
  ;; T_N_H-NEXT:  (local $B (ref $B))
  ;; T_N_H-NEXT:  (drop
  ;; T_N_H-NEXT:   (struct.new_default $A)
  ;; T_N_H-NEXT:  )
  ;; T_N_H-NEXT: )
  (func $test (param $nullable (ref null (exact $B)))
    (local $A (ref $A))
    (local $B (ref $B))
    (drop
      (struct.new $A
        (local.get $nullable)
      )
    )
  )
)

;; As above, with the struct.new in the global scope.
(module
  (rec
    ;; CHECK:      (rec
    ;; CHECK-NEXT:  (type $A (descriptor $B (struct)))
    ;; T_N_H:      (rec
    ;; T_N_H-NEXT:  (type $A (struct))
    (type $A (descriptor $B (struct)))
    ;; CHECK:       (type $B (describes $A (struct)))
    ;; T_N_H:       (type $B (struct))
    (type $B (describes $A (struct)))
  )


  ;; CHECK:      (type $2 (func))

  ;; CHECK:      (global $g anyref (struct.new_default $A
  ;; CHECK-NEXT:  (ref.null none)
  ;; CHECK-NEXT: ))
  ;; T_N_H:       (type $2 (func))

  ;; T_N_H:      (global $g anyref (struct.new_default $A))
  (global $g anyref (struct.new $A
    (ref.null $B)
  ))

  ;; CHECK:      (func $test (type $2)
  ;; CHECK-NEXT:  (local $A (ref $A))
  ;; CHECK-NEXT:  (local $B (ref $B))
  ;; CHECK-NEXT: )
  ;; T_N_H:      (func $test (type $2)
  ;; T_N_H-NEXT:  (local $A (ref $A))
  ;; T_N_H-NEXT:  (local $B (ref $B))
  ;; T_N_H-NEXT: )
  (func $test
    (local $A (ref $A))
    (local $B (ref $B))
  )
)

;; $A and $B have descriptors, and the descriptors also subtype:
;;
;;   A -> A.desc
;;        ^
;;   B -> B.desc
;;
;; $B is written a null descriptor, so we cannot optimize it when traps are
;; possible. This means $A.desc must remain a descriptor even as we optimize $A,
;; so we give $A.desc a placeholder describee. With TNH, we can optimize without
;; the placeholder.
;;
;; This tests subtyping of descriptors *without* subtyping of describees.
(module
  (rec
    ;; CHECK:      (rec
    ;; CHECK-NEXT:  (type $A (sub (struct)))
    ;; T_N_H:      (rec
    ;; T_N_H-NEXT:  (type $A (sub (struct)))
    (type $A (sub (descriptor $A.desc (struct))))
    ;; CHECK:       (type $1 (sub (descriptor $A.desc (struct))))

    ;; CHECK:       (type $A.desc (sub (describes $1 (struct))))
    ;; T_N_H:       (type $A.desc (sub (struct)))
    (type $A.desc (sub (describes $A (struct ))))

    ;; CHECK:       (type $B (sub (descriptor $B.desc (struct))))
    ;; T_N_H:       (type $B (sub (struct)))
    (type $B (sub (descriptor $B.desc (struct))))
    ;; CHECK:       (type $B.desc (sub $A.desc (describes $B (struct))))
    ;; T_N_H:       (type $B.desc (sub $A.desc (struct)))
    (type $B.desc (sub $A.desc (describes $B (struct))))
  )

  ;; CHECK:       (type $5 (func))

  ;; CHECK:      (func $test (type $5)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (struct.new_default $B
  ;; CHECK-NEXT:    (ref.null none)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  ;; T_N_H:       (type $4 (func))

  ;; T_N_H:      (func $test (type $4)
  ;; T_N_H-NEXT:  (drop
  ;; T_N_H-NEXT:   (struct.new_default $B)
  ;; T_N_H-NEXT:  )
  ;; T_N_H-NEXT: )
  (func $test
    (drop
      (struct.new_default $B
        (ref.null none)
      )
    )
  )
)

;; A similar situation, but now the thing that stops optimizing $B is not a
;; null descriptor but a use. We cannot optimize even without traps.
;; Subtyping of descriptors *without* subtyping of describees.
;;
;; $A's descriptor can be removed, but $A.desc needs to be given a placeholder
;; describee.
(module
  (rec
    ;; CHECK:      (rec
    ;; CHECK-NEXT:  (type $A (sub (descriptor $A.desc (struct))))
    ;; T_N_H:      (rec
    ;; T_N_H-NEXT:  (type $A (sub (descriptor $A.desc (struct))))
    (type $A (sub (descriptor $A.desc (struct))))
    ;; CHECK:       (type $A.desc (sub (describes $A (struct))))
    ;; T_N_H:       (type $A.desc (sub (describes $A (struct))))
    (type $A.desc (sub (describes $A (struct ))))

    ;; CHECK:       (type $B (sub (struct)))
    ;; T_N_H:       (type $B (sub (struct)))
    (type $B (sub (descriptor $B.desc (struct))))
    ;; CHECK:       (type $3 (sub (descriptor $B.desc (struct))))

    ;; CHECK:       (type $B.desc (sub $A.desc (describes $3 (struct))))
    ;; T_N_H:       (type $3 (sub (descriptor $B.desc (struct))))

    ;; T_N_H:       (type $B.desc (sub $A.desc (describes $3 (struct))))
    (type $B.desc (sub $A.desc (describes $B (struct))))
  )

  ;; CHECK:       (type $5 (func))

  ;; CHECK:      (func $test (type $5)
  ;; CHECK-NEXT:  (local $B (ref $B))
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (ref.get_desc $A
  ;; CHECK-NEXT:    (struct.new_default $A
  ;; CHECK-NEXT:     (struct.new_default $A.desc)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  ;; T_N_H:       (type $5 (func))

  ;; T_N_H:      (func $test (type $5)
  ;; T_N_H-NEXT:  (local $B (ref $B))
  ;; T_N_H-NEXT:  (drop
  ;; T_N_H-NEXT:   (ref.get_desc $A
  ;; T_N_H-NEXT:    (struct.new_default $A
  ;; T_N_H-NEXT:     (struct.new_default $A.desc)
  ;; T_N_H-NEXT:    )
  ;; T_N_H-NEXT:   )
  ;; T_N_H-NEXT:  )
  ;; T_N_H-NEXT: )
  (func $test
    (local $B (ref $B)) ;; keep $B alive
    (drop
      (ref.get_desc $A
        (struct.new $A
          (struct.new $A.desc)
        )
      )
    )
  )
)

;; A chain of descriptors, where we can remove the outer one, but must be
;; careful not to remove nested children.
(module
  (rec
    ;; CHECK:      (rec
    ;; CHECK-NEXT:  (type $A (struct))
    ;; T_N_H:      (rec
    ;; T_N_H-NEXT:  (type $A (struct))
    (type $A (descriptor $B (struct)))
    ;; CHECK:       (type $B (descriptor $C (struct)))
    ;; T_N_H:       (type $B (struct))
    (type $B (describes $A (descriptor $C (struct))))
    ;; CHECK:       (type $C (describes $B (struct)))
    ;; T_N_H:       (type $C (struct))
    (type $C (describes $B (struct)))
  )

  ;; CHECK:       (type $3 (func))

  ;; CHECK:      (global $g anyref (struct.new_default $A))
  ;; T_N_H:       (type $3 (func))

  ;; T_N_H:      (global $g anyref (struct.new_default $A))
  (global $g anyref
    (struct.new $A     ;; The outer struct.new $A is ok to remove,
      (struct.new $B   ;; but the inner struct.new $B is not, due
        (ref.null $C)  ;; to its null descriptor. We keep the inner
      )                ;; one around as a new global later (but not
    )                  ;; if traps cannot happen).
  )

  ;; CHECK:      (global $gto-removed-0 (ref (exact $B)) (struct.new_default $B
  ;; CHECK-NEXT:  (ref.null none)
  ;; CHECK-NEXT: ))

  ;; CHECK:      (func $test (type $3)
  ;; CHECK-NEXT:  (local $A (ref $A))
  ;; CHECK-NEXT:  (local $B (ref $B))
  ;; CHECK-NEXT:  (local $C (ref $C))
  ;; CHECK-NEXT: )
  ;; T_N_H:      (func $test (type $3)
  ;; T_N_H-NEXT:  (local $A (ref $A))
  ;; T_N_H-NEXT:  (local $B (ref $B))
  ;; T_N_H-NEXT:  (local $C (ref $C))
  ;; T_N_H-NEXT: )
  (func $test
    (local $A (ref $A))
    (local $B (ref $B))
    (local $C (ref $C))
  )
)

