
# Test if the Fortran compiler supports OpenMP 4.0 features used in Elmer

message(STATUS "Checking whether ${CMAKE_Fortran_COMPILER} supports OpenMP 4.0")

file(WRITE ${CMAKE_BINARY_DIR}${CMAKE_FILES_DIRECTORY}/CMakeTmp/testFortranOpenMP40.F90
"
#if (_OPENMP >= 201307)
PROGRAM TESTOPENMP40
IMPLICIT NONE
INTEGER, PARAMETER :: N = 1000
REAL :: A(N), B(N), C(N)
A=1
B=1
CALL COMPUTE(N, A, B, C)
WRITE (*,*) C(1), C(N)

CONTAINS

SUBROUTINE COMPUTE(N,X,Y,Z)
IMPLICIT NONE
INTEGER, INTENT(IN) :: N
REAL, INTENT(IN) :: X(N), Y(N)
REAL, INTENT(OUT) :: Z(N)
INTEGER :: I
INTERFACE
SUBROUTINE PLUSV_SUBR(X,Y,Z)
IMPLICIT NONE
REAL,INTENT(IN) :: X,Y
REAL,INTENT(OUT) :: Z
!$OMP DECLARE SIMD NOTINBRANCH
END SUBROUTINE PLUSV_SUBR

FUNCTION PLUSV_FUNC(X,Y) RESULT(Z)
IMPLICIT NONE
REAL,INTENT(IN) :: X,Y
REAL :: Z
!$OMP DECLARE SIMD NOTINBRANCH
END FUNCTION PLUSV_FUNC
END INTERFACE

!$OMP SIMD
DO I=1,N
CALL PLUSV_SUBR(X(I),Y(I),Z(I))
END DO
!$OMP SIMD
DO I=1,N
Z(I)=Z(I)+PLUSV_FUNC(X(I),Y(I))
END DO
END SUBROUTINE COMPUTE
END PROGRAM  TESTOPENMP40

SUBROUTINE PLUSV_SUBR(X,Y,Z)
IMPLICIT NONE
REAL,INTENT(IN) :: X,Y
REAL,INTENT(OUT) :: Z
!$OMP DECLARE SIMD NOTINBRANCH
Z=X+Y
END SUBROUTINE PLUSV_SUBR

FUNCTION PLUSV_FUNC(X,Y) RESULT(Z)
IMPLICIT NONE
REAL,INTENT(IN) :: X,Y
REAL :: Z
!$OMP DECLARE SIMD NOTINBRANCH
Z=X+Y
END FUNCTION PLUSV_FUNC
#else
! Supported OpenMP standard revision < 201307
#error Supported OpenMP standard revision < 201307
#endif
")

try_compile(FC_HAS_OPENMP_40 ${CMAKE_BINARY_DIR}
  ${CMAKE_BINARY_DIR}${CMAKE_FILES_DIRECTORY}/CMakeTmp/testFortranOpenMP40.F90
  OUTPUT_VARIABLE OUTPUT)
if(FC_HAS_OPENMP_40)
  message(STATUS "Checking whether ${CMAKE_Fortran_COMPILER} supports OpenMP 4.0 -- yes")
  set(CMAKE_Fortran_COMPILER_SUPPORTS_OPENMP40 1 CACHE BOOL "")
else(FC_HAS_OPENMP_40)
  message(STATUS "Checking whether ${CMAKE_Fortran_COMPILER} supports OpenMP 4.0 -- no")
  set(CMAKE_Fortran_COMPILER_SUPPORTS_OPENMP40 0 CACHE BOOL "")
endif(FC_HAS_OPENMP_40)
MARK_AS_ADVANCED(CMAKE_Fortran_COMPILER_SUPPORTS_OPENMP40)
