


# Basic Structure of the configure.ac File

Make sure you read the [introduction to the autotools](./pm-autotools-intro) first.
[Here you can find the full autoconf documentation](http://www.gnu.org/software/autoconf/manual/).


## General Concepts

Autoconf works by running the macro expansion program `m4`, using the `configure.ac` file as input.  This file contains *macros* that are expanded (recursively) until, in the end, a pure shell script for `sh` is created.  The `configure.ac` input file can also contain *sh commands*, which will appear literally in the final `configure` script.

Everything in a line following a "`#`" is a *comment*.  Comments are usually copied into the generated `configure` script, unless the line starts with at least two "`#`".

By convention, macro names are capitalized, and they start with *`AC_`* if the macro is an `autoconf ` macro, *`AM_`* if it's an `automake` macro.  We provide additional custom macros for COIN-OR configuration (in the [coin.m4](../tree/master/stable/0.7/coin.m4) file), which start with *`AC_COIN_`*. [In the autoconf documentation](http://www.gnu.org/software/autoconf/manual/) you can find a description of the predefined autoconf macros.

Like subroutines, macros can be written to have parameters and be invoked with arguments for those parameters.  Parameters and arguments are separated by commas.  The *quotation symbols* for `autoconf` are the square brackets "`[`" and "`]`".  If a single argument contains a comma, the argument must be quoted by enclosing it in brackets.  If in doubt, use quotation. If a macro is written to use four parameters, but only two arguments are provided, then the last two parameters are assumed to be unset (equivalent to an argument of `[]`). 


## Beginning of a `configure.ac` file

At the beginning of a `configure.ac` file in COIN-OR you will find something like the following:

```
## Copyright (C) 2011 International Icecream Machines.
# All Rights Reserved.
# This file is distributed under the Eclipse Public License.

## $Id: configure.ac,v 1.2.3.4 2011/04/01 11:11:11 johndoe Exp $

# Author:  John Doe                     IIM    2011-04-01

#############################################################################
#                       Names and other basic things                        #
#############################################################################

AC_PREREQ(2.59)

AC_INIT([SuperSolver],[1.2.1],[http://projects.coin-or.org/SuperSolver])

AC_COPYRIGHT([
Copyright 2011 International Icecream Machines and others.
All Rights Reserved.
This file is part of the open source package COIN-OR which is distributed
under the Eclipse Public License.])

# List one file in the package so that the configure script can test
# whether the package is actually there
AC_CONFIG_SRCDIR(src/SuperSolverMain.cpp)

# Where should everything be installed by default?  Here, we want it
# to be installed directly in 'bin', 'lib', and 'include' subdirectories
# of the directory where configure is run.  The default would be
# /usr/local.
AC_PREFIX_DEFAULT([`pwd`])
```

 * The file should contain the *copyright notice*, information about the *authors*, and state under what *license* the file is made available.  Note the *$Id ...$* string.  This is a [subversion property keyword](./pm-svn-cmds#SubversionProperties), which is expanded to contain information about the file, such as revision number, author and date of the last submission, _etc._, when the file is committed (assuming that the `svn:keywords` property for this file contains "`Id`").

 * The *`AC_PREREQ`* macro specifies the version number of `autoconf` that is required to generate a `configure` script from this input file.  In COIN-OR, we ask people to [use exactly the same versions of all the GNU autotools](./pm-get-autotools), so that we can collectively take care of bug fixes and can avoid the situation where different versions of the autotools generate large differences in the generated configuration files when multiple developers work on a project simultaneously.

 * The *`AC_INIT`* macro takes as arguments the name of the project, its version number, and contact information in case a user wants to get in touch with the developers, _e.g._, in order to report a bug.  The name and version number determine the name of the tarball that will be created by '`make dist`'.

 * The argument of the *`AC_COPYRIGHT`* macro becomes the copyright notice in the generated `configure` script.

 * The *`AC_CONFIG_SRCDIR`* helps the `configure` script to do a sanity check. When the shell commands generated by expanding `AC_CONFIG_SRCDIR` are executed, the `configure` script tests if it is in the correct location with respect to the rest of the package.  As the argument, one provides a file (such as a source file) that belongs to the package.

 * The argument of the *`AC_PREFIX_DEFAULT`* macro determines where the products of the compilation should be installed by a '`make install`' command, unless this location is overwritten by the user by specifying the `--prefix` argument to `configure`.  In COIN-OR, we decided to use as the default location the directory where the `configure` script is run.

 As you can see in the invocation of this macro. it is *possible to give a shell command as an argument for a macro*.  Don't forget that `autoconf` and `automake` only perform macro expansion. Shell commands used as arguments to `autoconf` macros are just text strings to `autoconf`. The shell command will not be executed until the generated `configure` script is executed. *This is a feature! * In this case, the result is that the `configure` script will set the default installation directory according to the output of `pwd` produced when the generated `configure` script is run in the user's environment.


## The Body of the `configure.ac` File

After the initialization described above, `configure.ac` usually contains a number of *macros that will be expanded into the tests* that are to be run by the `configure` script. The content of the body depends on whether this is a [base directory configure.ac](./pm-autotools#BaseDirConfigAc) file or a [project directory configure.ac](./pm-autotools#ProjDirConfigAc) file. In general, one checks for the *availability and names of programs* (such as compilers and other tools), tests for the presence of *header files, libraries, _etc._ *, and sets the values of `autoconf` output variables and [configuration header](./pm-autotools-intro#ConfigurationHeaderFiles) `#define`s.

Autoconf output variables are specified with the macro invocation *`AC_SUBST(VARNAME)`*, where `VARNAME` is the name of the output variable.  The value of the output variable will be the value of the corresponding shell variable in the `configure` script.  Therefore, setting the value of an output variable is done with a shell command like
```
VARNAME="value1 and maybe a few more"
```
*The `sh` shell does not allow spaces before and after the `=` symbol! * 

In order to include a "`#define`" into the configuration header file that the `configure` script is going to create, one uses the *`AC_DEFINE`* and *`AC_DEFINE_UNQUOTED`* macros, see the [autoconf documentation](http://www.gnu.org/software/autoconf/manual/).


## The End of the `configure.ac` File

At the end of the `configure.ac` file, we need to make sure that the *output is written*.  In COIN-OR, the bottom of the file usually looks like this:

```
##############################################################################
#                   Finish up by writing all the output                   #
##############################################################################

# Here list all the files that configure should create (except for the
# configuration header file)
AC_CONFIG_FILES([Makefile
                 examples/Makefile
                 src/Makefile
                 test/Makefile
                 clp.pc.in clp-uninstalled.pc.in])

# Here put the location and name of the configuration header file
AC_CONFIG_HEADER([inc/config_clp.h])

# Finally, we let configure write all the output...
AC_COIN_FINALIZE
```

 * The *`AC_CONFIG_FILES`* macro takes as its single argument a space-separated list of the files that are to be created from the corresponding `.in` template files. These are all the `Makefile`s and maybe some additional files.  In the example shown here, the project installs a _prjct_`.pc` file, and this will also be created from a template. *A template file must exist for each file listed in the argument to `AC_CONFIG_FILES`.*

 * The *`AC_CONFIG_HEADER`* macro takes as its single argument a space-separated list of names of [configuration header](./pm-autotools-intro#ConfigurationHeaderFiles) files that are to be created by `configure`.  For the first file in this list, the template will be created by the autotools utility `autoheader`. For the remaining ones, the project manager has to provide the template files. [Base directory configure.ac](./pm-autotools#BaseDirConfigAc) files don't need this, since they do not gather information for compilation.

 * The *`AC_COIN_FINALIZE`* macro takes care of actually writing the output. Internally, it uses the `AC_OUTPUT` macro, but since additional actions might have to be taken, you should use `AC_COIN_FINALIZE` instead of using `AC_OUTPUT` directly.  `AC_COIN_FINALIZE` also writes the "configuration successful" message before the `configure` script finally stops.