; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -verify-machineinstrs -no-integrated-as < %s \
; RUN:   | FileCheck -check-prefixes=RV32I %s
; RUN: llc -mtriple=riscv64 -verify-machineinstrs -no-integrated-as < %s \
; RUN:   | FileCheck -check-prefixes=RV64I %s
; RUN: llc -mtriple=riscv32 -code-model=medium -verify-machineinstrs -no-integrated-as < %s \
; RUN:   | FileCheck -check-prefixes=RV32I-MEDIUM %s
; RUN: llc -mtriple=riscv64 -code-model=medium -verify-machineinstrs -no-integrated-as < %s \
; RUN:   | FileCheck -check-prefixes=RV64I-MEDIUM %s

@eg = external global [4000 x i32], align 4
@ewg = extern_weak global [4000 x i32], align 4

define void @constraint_m_1(ptr %a) nounwind {
; RV32I-LABEL: constraint_m_1:
; RV32I:       # %bb.0:
; RV32I-NEXT:    #APP
; RV32I-NEXT:    #NO_APP
; RV32I-NEXT:    ret
;
; RV64I-LABEL: constraint_m_1:
; RV64I:       # %bb.0:
; RV64I-NEXT:    #APP
; RV64I-NEXT:    #NO_APP
; RV64I-NEXT:    ret
;
; RV32I-MEDIUM-LABEL: constraint_m_1:
; RV32I-MEDIUM:       # %bb.0:
; RV32I-MEDIUM-NEXT:    #APP
; RV32I-MEDIUM-NEXT:    #NO_APP
; RV32I-MEDIUM-NEXT:    ret
;
; RV64I-MEDIUM-LABEL: constraint_m_1:
; RV64I-MEDIUM:       # %bb.0:
; RV64I-MEDIUM-NEXT:    #APP
; RV64I-MEDIUM-NEXT:    #NO_APP
; RV64I-MEDIUM-NEXT:    ret
  call void asm sideeffect "", "=*m"(ptr elementtype(i32) %a)
  ret void
}

define i32 @constraint_m_2(ptr %a) nounwind {
; RV32I-LABEL: constraint_m_2:
; RV32I:       # %bb.0:
; RV32I-NEXT:    #APP
; RV32I-NEXT:    lw a0, 0(a0)
; RV32I-NEXT:    #NO_APP
; RV32I-NEXT:    ret
;
; RV64I-LABEL: constraint_m_2:
; RV64I:       # %bb.0:
; RV64I-NEXT:    #APP
; RV64I-NEXT:    lw a0, 0(a0)
; RV64I-NEXT:    #NO_APP
; RV64I-NEXT:    ret
;
; RV32I-MEDIUM-LABEL: constraint_m_2:
; RV32I-MEDIUM:       # %bb.0:
; RV32I-MEDIUM-NEXT:    #APP
; RV32I-MEDIUM-NEXT:    lw a0, 0(a0)
; RV32I-MEDIUM-NEXT:    #NO_APP
; RV32I-MEDIUM-NEXT:    ret
;
; RV64I-MEDIUM-LABEL: constraint_m_2:
; RV64I-MEDIUM:       # %bb.0:
; RV64I-MEDIUM-NEXT:    #APP
; RV64I-MEDIUM-NEXT:    lw a0, 0(a0)
; RV64I-MEDIUM-NEXT:    #NO_APP
; RV64I-MEDIUM-NEXT:    ret
  %1 = tail call i32 asm "lw $0, $1", "=r,*m"(ptr elementtype(i32) %a)
  ret i32 %1
}

define i32 @constraint_m_with_offset(ptr %a) nounwind {
; RV32I-LABEL: constraint_m_with_offset:
; RV32I:       # %bb.0:
; RV32I-NEXT:    #APP
; RV32I-NEXT:    lw a0, 4(a0)
; RV32I-NEXT:    #NO_APP
; RV32I-NEXT:    ret
;
; RV64I-LABEL: constraint_m_with_offset:
; RV64I:       # %bb.0:
; RV64I-NEXT:    #APP
; RV64I-NEXT:    lw a0, 4(a0)
; RV64I-NEXT:    #NO_APP
; RV64I-NEXT:    ret
;
; RV32I-MEDIUM-LABEL: constraint_m_with_offset:
; RV32I-MEDIUM:       # %bb.0:
; RV32I-MEDIUM-NEXT:    #APP
; RV32I-MEDIUM-NEXT:    lw a0, 4(a0)
; RV32I-MEDIUM-NEXT:    #NO_APP
; RV32I-MEDIUM-NEXT:    ret
;
; RV64I-MEDIUM-LABEL: constraint_m_with_offset:
; RV64I-MEDIUM:       # %bb.0:
; RV64I-MEDIUM-NEXT:    #APP
; RV64I-MEDIUM-NEXT:    lw a0, 4(a0)
; RV64I-MEDIUM-NEXT:    #NO_APP
; RV64I-MEDIUM-NEXT:    ret
  %1 = getelementptr i32, ptr %a, i32 1
  %2 = tail call i32 asm "lw $0, $1", "=r,*m"(ptr elementtype(i32) %1)
  ret i32 %2
}

define void @constraint_m_with_global_1() nounwind {
; RV32I-LABEL: constraint_m_with_global_1:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, %hi(eg)
; RV32I-NEXT:    #APP
; RV32I-NEXT:    sw zero, %lo(eg)(a0)
; RV32I-NEXT:    #NO_APP
; RV32I-NEXT:    ret
;
; RV64I-LABEL: constraint_m_with_global_1:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a0, %hi(eg)
; RV64I-NEXT:    #APP
; RV64I-NEXT:    sw zero, %lo(eg)(a0)
; RV64I-NEXT:    #NO_APP
; RV64I-NEXT:    ret
;
; RV32I-MEDIUM-LABEL: constraint_m_with_global_1:
; RV32I-MEDIUM:       # %bb.0:
; RV32I-MEDIUM-NEXT:  .Lpcrel_hi0:
; RV32I-MEDIUM-NEXT:    auipc a0, %pcrel_hi(eg)
; RV32I-MEDIUM-NEXT:    addi a0, a0, %pcrel_lo(.Lpcrel_hi0)
; RV32I-MEDIUM-NEXT:    #APP
; RV32I-MEDIUM-NEXT:    sw zero, 0(a0)
; RV32I-MEDIUM-NEXT:    #NO_APP
; RV32I-MEDIUM-NEXT:    ret
;
; RV64I-MEDIUM-LABEL: constraint_m_with_global_1:
; RV64I-MEDIUM:       # %bb.0:
; RV64I-MEDIUM-NEXT:  .Lpcrel_hi0:
; RV64I-MEDIUM-NEXT:    auipc a0, %pcrel_hi(eg)
; RV64I-MEDIUM-NEXT:    addi a0, a0, %pcrel_lo(.Lpcrel_hi0)
; RV64I-MEDIUM-NEXT:    #APP
; RV64I-MEDIUM-NEXT:    sw zero, 0(a0)
; RV64I-MEDIUM-NEXT:    #NO_APP
; RV64I-MEDIUM-NEXT:    ret
  call void asm "sw zero, $0", "=*m"(ptr elementtype(i32) @eg)
  ret void
}

define void @constraint_m_with_global_2() nounwind {
; RV32I-LABEL: constraint_m_with_global_2:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, %hi(eg)
; RV32I-NEXT:    addi a0, a0, %lo(eg)
; RV32I-NEXT:    #APP
; RV32I-NEXT:    sw zero, 4(a0)
; RV32I-NEXT:    #NO_APP
; RV32I-NEXT:    ret
;
; RV64I-LABEL: constraint_m_with_global_2:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a0, %hi(eg)
; RV64I-NEXT:    addi a0, a0, %lo(eg)
; RV64I-NEXT:    #APP
; RV64I-NEXT:    sw zero, 4(a0)
; RV64I-NEXT:    #NO_APP
; RV64I-NEXT:    ret
;
; RV32I-MEDIUM-LABEL: constraint_m_with_global_2:
; RV32I-MEDIUM:       # %bb.0:
; RV32I-MEDIUM-NEXT:  .Lpcrel_hi1:
; RV32I-MEDIUM-NEXT:    auipc a0, %pcrel_hi(eg)
; RV32I-MEDIUM-NEXT:    addi a0, a0, %pcrel_lo(.Lpcrel_hi1)
; RV32I-MEDIUM-NEXT:    #APP
; RV32I-MEDIUM-NEXT:    sw zero, 4(a0)
; RV32I-MEDIUM-NEXT:    #NO_APP
; RV32I-MEDIUM-NEXT:    ret
;
; RV64I-MEDIUM-LABEL: constraint_m_with_global_2:
; RV64I-MEDIUM:       # %bb.0:
; RV64I-MEDIUM-NEXT:  .Lpcrel_hi1:
; RV64I-MEDIUM-NEXT:    auipc a0, %pcrel_hi(eg)
; RV64I-MEDIUM-NEXT:    addi a0, a0, %pcrel_lo(.Lpcrel_hi1)
; RV64I-MEDIUM-NEXT:    #APP
; RV64I-MEDIUM-NEXT:    sw zero, 4(a0)
; RV64I-MEDIUM-NEXT:    #NO_APP
; RV64I-MEDIUM-NEXT:    ret
  call void asm "sw zero, $0", "=*m"(ptr nonnull elementtype(i32) getelementptr inbounds ([400000 x i32], ptr @eg, i32 0, i32 1))
  ret void
}

define void @constraint_m_with_global_3() nounwind {
; RV32I-LABEL: constraint_m_with_global_3:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, %hi(eg+8000)
; RV32I-NEXT:    addi a0, a0, %lo(eg+8000)
; RV32I-NEXT:    #APP
; RV32I-NEXT:    sw zero, 0(a0)
; RV32I-NEXT:    #NO_APP
; RV32I-NEXT:    ret
;
; RV64I-LABEL: constraint_m_with_global_3:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a0, %hi(eg+8000)
; RV64I-NEXT:    addi a0, a0, %lo(eg+8000)
; RV64I-NEXT:    #APP
; RV64I-NEXT:    sw zero, 0(a0)
; RV64I-NEXT:    #NO_APP
; RV64I-NEXT:    ret
;
; RV32I-MEDIUM-LABEL: constraint_m_with_global_3:
; RV32I-MEDIUM:       # %bb.0:
; RV32I-MEDIUM-NEXT:  .Lpcrel_hi2:
; RV32I-MEDIUM-NEXT:    auipc a0, %pcrel_hi(eg+8000)
; RV32I-MEDIUM-NEXT:    addi a0, a0, %pcrel_lo(.Lpcrel_hi2)
; RV32I-MEDIUM-NEXT:    #APP
; RV32I-MEDIUM-NEXT:    sw zero, 0(a0)
; RV32I-MEDIUM-NEXT:    #NO_APP
; RV32I-MEDIUM-NEXT:    ret
;
; RV64I-MEDIUM-LABEL: constraint_m_with_global_3:
; RV64I-MEDIUM:       # %bb.0:
; RV64I-MEDIUM-NEXT:  .Lpcrel_hi2:
; RV64I-MEDIUM-NEXT:    auipc a0, %pcrel_hi(eg+8000)
; RV64I-MEDIUM-NEXT:    addi a0, a0, %pcrel_lo(.Lpcrel_hi2)
; RV64I-MEDIUM-NEXT:    #APP
; RV64I-MEDIUM-NEXT:    sw zero, 0(a0)
; RV64I-MEDIUM-NEXT:    #NO_APP
; RV64I-MEDIUM-NEXT:    ret
  call void asm "sw zero, $0", "=*m"(ptr nonnull elementtype(i32) getelementptr inbounds ([400000 x i32], ptr @eg, i32 0, i32 2000))
  ret void
}

define void @constraint_m_with_extern_weak_global_1() nounwind {
; RV32I-LABEL: constraint_m_with_extern_weak_global_1:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, %hi(ewg)
; RV32I-NEXT:    #APP
; RV32I-NEXT:    sw zero, %lo(ewg)(a0)
; RV32I-NEXT:    #NO_APP
; RV32I-NEXT:    ret
;
; RV64I-LABEL: constraint_m_with_extern_weak_global_1:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a0, %hi(ewg)
; RV64I-NEXT:    #APP
; RV64I-NEXT:    sw zero, %lo(ewg)(a0)
; RV64I-NEXT:    #NO_APP
; RV64I-NEXT:    ret
;
; RV32I-MEDIUM-LABEL: constraint_m_with_extern_weak_global_1:
; RV32I-MEDIUM:       # %bb.0:
; RV32I-MEDIUM-NEXT:  .Lpcrel_hi3:
; RV32I-MEDIUM-NEXT:    auipc a0, %got_pcrel_hi(ewg)
; RV32I-MEDIUM-NEXT:    lw a0, %pcrel_lo(.Lpcrel_hi3)(a0)
; RV32I-MEDIUM-NEXT:    #APP
; RV32I-MEDIUM-NEXT:    sw zero, 0(a0)
; RV32I-MEDIUM-NEXT:    #NO_APP
; RV32I-MEDIUM-NEXT:    ret
;
; RV64I-MEDIUM-LABEL: constraint_m_with_extern_weak_global_1:
; RV64I-MEDIUM:       # %bb.0:
; RV64I-MEDIUM-NEXT:  .Lpcrel_hi3:
; RV64I-MEDIUM-NEXT:    auipc a0, %got_pcrel_hi(ewg)
; RV64I-MEDIUM-NEXT:    ld a0, %pcrel_lo(.Lpcrel_hi3)(a0)
; RV64I-MEDIUM-NEXT:    #APP
; RV64I-MEDIUM-NEXT:    sw zero, 0(a0)
; RV64I-MEDIUM-NEXT:    #NO_APP
; RV64I-MEDIUM-NEXT:    ret
  call void asm "sw zero, $0", "=*m"(ptr elementtype(i32) @ewg)
  ret void
}

define void @constraint_m_with_extern_weak_global_2() nounwind {
; RV32I-LABEL: constraint_m_with_extern_weak_global_2:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, %hi(ewg)
; RV32I-NEXT:    addi a0, a0, %lo(ewg)
; RV32I-NEXT:    #APP
; RV32I-NEXT:    sw zero, 4(a0)
; RV32I-NEXT:    #NO_APP
; RV32I-NEXT:    ret
;
; RV64I-LABEL: constraint_m_with_extern_weak_global_2:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a0, %hi(ewg)
; RV64I-NEXT:    addi a0, a0, %lo(ewg)
; RV64I-NEXT:    #APP
; RV64I-NEXT:    sw zero, 4(a0)
; RV64I-NEXT:    #NO_APP
; RV64I-NEXT:    ret
;
; RV32I-MEDIUM-LABEL: constraint_m_with_extern_weak_global_2:
; RV32I-MEDIUM:       # %bb.0:
; RV32I-MEDIUM-NEXT:  .Lpcrel_hi4:
; RV32I-MEDIUM-NEXT:    auipc a0, %got_pcrel_hi(ewg)
; RV32I-MEDIUM-NEXT:    lw a0, %pcrel_lo(.Lpcrel_hi4)(a0)
; RV32I-MEDIUM-NEXT:    #APP
; RV32I-MEDIUM-NEXT:    sw zero, 4(a0)
; RV32I-MEDIUM-NEXT:    #NO_APP
; RV32I-MEDIUM-NEXT:    ret
;
; RV64I-MEDIUM-LABEL: constraint_m_with_extern_weak_global_2:
; RV64I-MEDIUM:       # %bb.0:
; RV64I-MEDIUM-NEXT:  .Lpcrel_hi4:
; RV64I-MEDIUM-NEXT:    auipc a0, %got_pcrel_hi(ewg)
; RV64I-MEDIUM-NEXT:    ld a0, %pcrel_lo(.Lpcrel_hi4)(a0)
; RV64I-MEDIUM-NEXT:    #APP
; RV64I-MEDIUM-NEXT:    sw zero, 4(a0)
; RV64I-MEDIUM-NEXT:    #NO_APP
; RV64I-MEDIUM-NEXT:    ret
  call void asm "sw zero, $0", "=*m"(ptr nonnull elementtype(i32) getelementptr inbounds ([400000 x i32], ptr @ewg, i32 0, i32 1))
  ret void
}

define void @constraint_m_with_extern_weak_global_3() nounwind {
; RV32I-LABEL: constraint_m_with_extern_weak_global_3:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, %hi(ewg+8000)
; RV32I-NEXT:    addi a0, a0, %lo(ewg+8000)
; RV32I-NEXT:    #APP
; RV32I-NEXT:    sw zero, 0(a0)
; RV32I-NEXT:    #NO_APP
; RV32I-NEXT:    ret
;
; RV64I-LABEL: constraint_m_with_extern_weak_global_3:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a0, %hi(ewg+8000)
; RV64I-NEXT:    addi a0, a0, %lo(ewg+8000)
; RV64I-NEXT:    #APP
; RV64I-NEXT:    sw zero, 0(a0)
; RV64I-NEXT:    #NO_APP
; RV64I-NEXT:    ret
;
; RV32I-MEDIUM-LABEL: constraint_m_with_extern_weak_global_3:
; RV32I-MEDIUM:       # %bb.0:
; RV32I-MEDIUM-NEXT:  .Lpcrel_hi5:
; RV32I-MEDIUM-NEXT:    auipc a0, %got_pcrel_hi(ewg)
; RV32I-MEDIUM-NEXT:    lw a0, %pcrel_lo(.Lpcrel_hi5)(a0)
; RV32I-MEDIUM-NEXT:    lui a1, 2
; RV32I-MEDIUM-NEXT:    addi a1, a1, -192
; RV32I-MEDIUM-NEXT:    add a0, a0, a1
; RV32I-MEDIUM-NEXT:    #APP
; RV32I-MEDIUM-NEXT:    sw zero, 0(a0)
; RV32I-MEDIUM-NEXT:    #NO_APP
; RV32I-MEDIUM-NEXT:    ret
;
; RV64I-MEDIUM-LABEL: constraint_m_with_extern_weak_global_3:
; RV64I-MEDIUM:       # %bb.0:
; RV64I-MEDIUM-NEXT:  .Lpcrel_hi5:
; RV64I-MEDIUM-NEXT:    auipc a0, %got_pcrel_hi(ewg)
; RV64I-MEDIUM-NEXT:    ld a0, %pcrel_lo(.Lpcrel_hi5)(a0)
; RV64I-MEDIUM-NEXT:    lui a1, 2
; RV64I-MEDIUM-NEXT:    addiw a1, a1, -192
; RV64I-MEDIUM-NEXT:    add a0, a0, a1
; RV64I-MEDIUM-NEXT:    #APP
; RV64I-MEDIUM-NEXT:    sw zero, 0(a0)
; RV64I-MEDIUM-NEXT:    #NO_APP
; RV64I-MEDIUM-NEXT:    ret
  call void asm "sw zero, $0", "=*m"(ptr nonnull elementtype(i32) getelementptr inbounds ([400000 x i32], ptr @ewg, i32 0, i32 2000))
  ret void
}

define void @constraint_o_1(ptr %a) nounwind {
; RV32I-LABEL: constraint_o_1:
; RV32I:       # %bb.0:
; RV32I-NEXT:    #APP
; RV32I-NEXT:    #NO_APP
; RV32I-NEXT:    ret
;
; RV64I-LABEL: constraint_o_1:
; RV64I:       # %bb.0:
; RV64I-NEXT:    #APP
; RV64I-NEXT:    #NO_APP
; RV64I-NEXT:    ret
;
; RV32I-MEDIUM-LABEL: constraint_o_1:
; RV32I-MEDIUM:       # %bb.0:
; RV32I-MEDIUM-NEXT:    #APP
; RV32I-MEDIUM-NEXT:    #NO_APP
; RV32I-MEDIUM-NEXT:    ret
;
; RV64I-MEDIUM-LABEL: constraint_o_1:
; RV64I-MEDIUM:       # %bb.0:
; RV64I-MEDIUM-NEXT:    #APP
; RV64I-MEDIUM-NEXT:    #NO_APP
; RV64I-MEDIUM-NEXT:    ret
  call void asm sideeffect "", "=*o"(ptr elementtype(i32) %a)
  ret void
}

define i32 @constraint_o_2(ptr %a) nounwind {
; RV32I-LABEL: constraint_o_2:
; RV32I:       # %bb.0:
; RV32I-NEXT:    #APP
; RV32I-NEXT:    lw a0, 0(a0)
; RV32I-NEXT:    #NO_APP
; RV32I-NEXT:    ret
;
; RV64I-LABEL: constraint_o_2:
; RV64I:       # %bb.0:
; RV64I-NEXT:    #APP
; RV64I-NEXT:    lw a0, 0(a0)
; RV64I-NEXT:    #NO_APP
; RV64I-NEXT:    ret
;
; RV32I-MEDIUM-LABEL: constraint_o_2:
; RV32I-MEDIUM:       # %bb.0:
; RV32I-MEDIUM-NEXT:    #APP
; RV32I-MEDIUM-NEXT:    lw a0, 0(a0)
; RV32I-MEDIUM-NEXT:    #NO_APP
; RV32I-MEDIUM-NEXT:    ret
;
; RV64I-MEDIUM-LABEL: constraint_o_2:
; RV64I-MEDIUM:       # %bb.0:
; RV64I-MEDIUM-NEXT:    #APP
; RV64I-MEDIUM-NEXT:    lw a0, 0(a0)
; RV64I-MEDIUM-NEXT:    #NO_APP
; RV64I-MEDIUM-NEXT:    ret
  %1 = tail call i32 asm "lw $0, $1", "=r,*o"(ptr elementtype(i32) %a)
  ret i32 %1
}

define i32 @constraint_o_with_offset(ptr %a) nounwind {
; RV32I-LABEL: constraint_o_with_offset:
; RV32I:       # %bb.0:
; RV32I-NEXT:    #APP
; RV32I-NEXT:    lw a0, 4(a0)
; RV32I-NEXT:    #NO_APP
; RV32I-NEXT:    ret
;
; RV64I-LABEL: constraint_o_with_offset:
; RV64I:       # %bb.0:
; RV64I-NEXT:    #APP
; RV64I-NEXT:    lw a0, 4(a0)
; RV64I-NEXT:    #NO_APP
; RV64I-NEXT:    ret
;
; RV32I-MEDIUM-LABEL: constraint_o_with_offset:
; RV32I-MEDIUM:       # %bb.0:
; RV32I-MEDIUM-NEXT:    #APP
; RV32I-MEDIUM-NEXT:    lw a0, 4(a0)
; RV32I-MEDIUM-NEXT:    #NO_APP
; RV32I-MEDIUM-NEXT:    ret
;
; RV64I-MEDIUM-LABEL: constraint_o_with_offset:
; RV64I-MEDIUM:       # %bb.0:
; RV64I-MEDIUM-NEXT:    #APP
; RV64I-MEDIUM-NEXT:    lw a0, 4(a0)
; RV64I-MEDIUM-NEXT:    #NO_APP
; RV64I-MEDIUM-NEXT:    ret
  %1 = getelementptr i32, ptr %a, i32 1
  %2 = tail call i32 asm "lw $0, $1", "=r,*o"(ptr elementtype(i32) %1)
  ret i32 %2
}

define void @constraint_o_with_global_1() nounwind {
; RV32I-LABEL: constraint_o_with_global_1:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, %hi(eg)
; RV32I-NEXT:    #APP
; RV32I-NEXT:    sw zero, %lo(eg)(a0)
; RV32I-NEXT:    #NO_APP
; RV32I-NEXT:    ret
;
; RV64I-LABEL: constraint_o_with_global_1:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a0, %hi(eg)
; RV64I-NEXT:    #APP
; RV64I-NEXT:    sw zero, %lo(eg)(a0)
; RV64I-NEXT:    #NO_APP
; RV64I-NEXT:    ret
;
; RV32I-MEDIUM-LABEL: constraint_o_with_global_1:
; RV32I-MEDIUM:       # %bb.0:
; RV32I-MEDIUM-NEXT:  .Lpcrel_hi6:
; RV32I-MEDIUM-NEXT:    auipc a0, %pcrel_hi(eg)
; RV32I-MEDIUM-NEXT:    addi a0, a0, %pcrel_lo(.Lpcrel_hi6)
; RV32I-MEDIUM-NEXT:    #APP
; RV32I-MEDIUM-NEXT:    sw zero, 0(a0)
; RV32I-MEDIUM-NEXT:    #NO_APP
; RV32I-MEDIUM-NEXT:    ret
;
; RV64I-MEDIUM-LABEL: constraint_o_with_global_1:
; RV64I-MEDIUM:       # %bb.0:
; RV64I-MEDIUM-NEXT:  .Lpcrel_hi6:
; RV64I-MEDIUM-NEXT:    auipc a0, %pcrel_hi(eg)
; RV64I-MEDIUM-NEXT:    addi a0, a0, %pcrel_lo(.Lpcrel_hi6)
; RV64I-MEDIUM-NEXT:    #APP
; RV64I-MEDIUM-NEXT:    sw zero, 0(a0)
; RV64I-MEDIUM-NEXT:    #NO_APP
; RV64I-MEDIUM-NEXT:    ret
  call void asm "sw zero, $0", "=*o"(ptr elementtype(i32) @eg)
  ret void
}

define void @constraint_o_with_global_2() nounwind {
; RV32I-LABEL: constraint_o_with_global_2:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, %hi(eg)
; RV32I-NEXT:    addi a0, a0, %lo(eg)
; RV32I-NEXT:    #APP
; RV32I-NEXT:    sw zero, 4(a0)
; RV32I-NEXT:    #NO_APP
; RV32I-NEXT:    ret
;
; RV64I-LABEL: constraint_o_with_global_2:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a0, %hi(eg)
; RV64I-NEXT:    addi a0, a0, %lo(eg)
; RV64I-NEXT:    #APP
; RV64I-NEXT:    sw zero, 4(a0)
; RV64I-NEXT:    #NO_APP
; RV64I-NEXT:    ret
;
; RV32I-MEDIUM-LABEL: constraint_o_with_global_2:
; RV32I-MEDIUM:       # %bb.0:
; RV32I-MEDIUM-NEXT:  .Lpcrel_hi7:
; RV32I-MEDIUM-NEXT:    auipc a0, %pcrel_hi(eg)
; RV32I-MEDIUM-NEXT:    addi a0, a0, %pcrel_lo(.Lpcrel_hi7)
; RV32I-MEDIUM-NEXT:    #APP
; RV32I-MEDIUM-NEXT:    sw zero, 4(a0)
; RV32I-MEDIUM-NEXT:    #NO_APP
; RV32I-MEDIUM-NEXT:    ret
;
; RV64I-MEDIUM-LABEL: constraint_o_with_global_2:
; RV64I-MEDIUM:       # %bb.0:
; RV64I-MEDIUM-NEXT:  .Lpcrel_hi7:
; RV64I-MEDIUM-NEXT:    auipc a0, %pcrel_hi(eg)
; RV64I-MEDIUM-NEXT:    addi a0, a0, %pcrel_lo(.Lpcrel_hi7)
; RV64I-MEDIUM-NEXT:    #APP
; RV64I-MEDIUM-NEXT:    sw zero, 4(a0)
; RV64I-MEDIUM-NEXT:    #NO_APP
; RV64I-MEDIUM-NEXT:    ret
  call void asm "sw zero, $0", "=*o"(ptr nonnull elementtype(i32) getelementptr inbounds ([400000 x i32], ptr @eg, i32 0, i32 1))
  ret void
}

define void @constraint_o_with_global_3() nounwind {
; RV32I-LABEL: constraint_o_with_global_3:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, %hi(eg+8000)
; RV32I-NEXT:    addi a0, a0, %lo(eg+8000)
; RV32I-NEXT:    #APP
; RV32I-NEXT:    sw zero, 0(a0)
; RV32I-NEXT:    #NO_APP
; RV32I-NEXT:    ret
;
; RV64I-LABEL: constraint_o_with_global_3:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a0, %hi(eg+8000)
; RV64I-NEXT:    addi a0, a0, %lo(eg+8000)
; RV64I-NEXT:    #APP
; RV64I-NEXT:    sw zero, 0(a0)
; RV64I-NEXT:    #NO_APP
; RV64I-NEXT:    ret
;
; RV32I-MEDIUM-LABEL: constraint_o_with_global_3:
; RV32I-MEDIUM:       # %bb.0:
; RV32I-MEDIUM-NEXT:  .Lpcrel_hi8:
; RV32I-MEDIUM-NEXT:    auipc a0, %pcrel_hi(eg+8000)
; RV32I-MEDIUM-NEXT:    addi a0, a0, %pcrel_lo(.Lpcrel_hi8)
; RV32I-MEDIUM-NEXT:    #APP
; RV32I-MEDIUM-NEXT:    sw zero, 0(a0)
; RV32I-MEDIUM-NEXT:    #NO_APP
; RV32I-MEDIUM-NEXT:    ret
;
; RV64I-MEDIUM-LABEL: constraint_o_with_global_3:
; RV64I-MEDIUM:       # %bb.0:
; RV64I-MEDIUM-NEXT:  .Lpcrel_hi8:
; RV64I-MEDIUM-NEXT:    auipc a0, %pcrel_hi(eg+8000)
; RV64I-MEDIUM-NEXT:    addi a0, a0, %pcrel_lo(.Lpcrel_hi8)
; RV64I-MEDIUM-NEXT:    #APP
; RV64I-MEDIUM-NEXT:    sw zero, 0(a0)
; RV64I-MEDIUM-NEXT:    #NO_APP
; RV64I-MEDIUM-NEXT:    ret
  call void asm "sw zero, $0", "=*o"(ptr nonnull elementtype(i32) getelementptr inbounds ([400000 x i32], ptr @eg, i32 0, i32 2000))
  ret void
}

define void @constraint_o_with_extern_weak_global_1() nounwind {
; RV32I-LABEL: constraint_o_with_extern_weak_global_1:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, %hi(ewg)
; RV32I-NEXT:    #APP
; RV32I-NEXT:    sw zero, %lo(ewg)(a0)
; RV32I-NEXT:    #NO_APP
; RV32I-NEXT:    ret
;
; RV64I-LABEL: constraint_o_with_extern_weak_global_1:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a0, %hi(ewg)
; RV64I-NEXT:    #APP
; RV64I-NEXT:    sw zero, %lo(ewg)(a0)
; RV64I-NEXT:    #NO_APP
; RV64I-NEXT:    ret
;
; RV32I-MEDIUM-LABEL: constraint_o_with_extern_weak_global_1:
; RV32I-MEDIUM:       # %bb.0:
; RV32I-MEDIUM-NEXT:  .Lpcrel_hi9:
; RV32I-MEDIUM-NEXT:    auipc a0, %got_pcrel_hi(ewg)
; RV32I-MEDIUM-NEXT:    lw a0, %pcrel_lo(.Lpcrel_hi9)(a0)
; RV32I-MEDIUM-NEXT:    #APP
; RV32I-MEDIUM-NEXT:    sw zero, 0(a0)
; RV32I-MEDIUM-NEXT:    #NO_APP
; RV32I-MEDIUM-NEXT:    ret
;
; RV64I-MEDIUM-LABEL: constraint_o_with_extern_weak_global_1:
; RV64I-MEDIUM:       # %bb.0:
; RV64I-MEDIUM-NEXT:  .Lpcrel_hi9:
; RV64I-MEDIUM-NEXT:    auipc a0, %got_pcrel_hi(ewg)
; RV64I-MEDIUM-NEXT:    ld a0, %pcrel_lo(.Lpcrel_hi9)(a0)
; RV64I-MEDIUM-NEXT:    #APP
; RV64I-MEDIUM-NEXT:    sw zero, 0(a0)
; RV64I-MEDIUM-NEXT:    #NO_APP
; RV64I-MEDIUM-NEXT:    ret
  call void asm "sw zero, $0", "=*o"(ptr elementtype(i32) @ewg)
  ret void
}

define void @constraint_o_with_extern_weak_global_2() nounwind {
; RV32I-LABEL: constraint_o_with_extern_weak_global_2:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, %hi(ewg)
; RV32I-NEXT:    addi a0, a0, %lo(ewg)
; RV32I-NEXT:    #APP
; RV32I-NEXT:    sw zero, 4(a0)
; RV32I-NEXT:    #NO_APP
; RV32I-NEXT:    ret
;
; RV64I-LABEL: constraint_o_with_extern_weak_global_2:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a0, %hi(ewg)
; RV64I-NEXT:    addi a0, a0, %lo(ewg)
; RV64I-NEXT:    #APP
; RV64I-NEXT:    sw zero, 4(a0)
; RV64I-NEXT:    #NO_APP
; RV64I-NEXT:    ret
;
; RV32I-MEDIUM-LABEL: constraint_o_with_extern_weak_global_2:
; RV32I-MEDIUM:       # %bb.0:
; RV32I-MEDIUM-NEXT:  .Lpcrel_hi10:
; RV32I-MEDIUM-NEXT:    auipc a0, %got_pcrel_hi(ewg)
; RV32I-MEDIUM-NEXT:    lw a0, %pcrel_lo(.Lpcrel_hi10)(a0)
; RV32I-MEDIUM-NEXT:    #APP
; RV32I-MEDIUM-NEXT:    sw zero, 4(a0)
; RV32I-MEDIUM-NEXT:    #NO_APP
; RV32I-MEDIUM-NEXT:    ret
;
; RV64I-MEDIUM-LABEL: constraint_o_with_extern_weak_global_2:
; RV64I-MEDIUM:       # %bb.0:
; RV64I-MEDIUM-NEXT:  .Lpcrel_hi10:
; RV64I-MEDIUM-NEXT:    auipc a0, %got_pcrel_hi(ewg)
; RV64I-MEDIUM-NEXT:    ld a0, %pcrel_lo(.Lpcrel_hi10)(a0)
; RV64I-MEDIUM-NEXT:    #APP
; RV64I-MEDIUM-NEXT:    sw zero, 4(a0)
; RV64I-MEDIUM-NEXT:    #NO_APP
; RV64I-MEDIUM-NEXT:    ret
  call void asm "sw zero, $0", "=*o"(ptr nonnull elementtype(i32) getelementptr inbounds ([400000 x i32], ptr @ewg, i32 0, i32 1))
  ret void
}

define void @constraint_o_with_extern_weak_global_3() nounwind {
; RV32I-LABEL: constraint_o_with_extern_weak_global_3:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, %hi(ewg+8000)
; RV32I-NEXT:    addi a0, a0, %lo(ewg+8000)
; RV32I-NEXT:    #APP
; RV32I-NEXT:    sw zero, 0(a0)
; RV32I-NEXT:    #NO_APP
; RV32I-NEXT:    ret
;
; RV64I-LABEL: constraint_o_with_extern_weak_global_3:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a0, %hi(ewg+8000)
; RV64I-NEXT:    addi a0, a0, %lo(ewg+8000)
; RV64I-NEXT:    #APP
; RV64I-NEXT:    sw zero, 0(a0)
; RV64I-NEXT:    #NO_APP
; RV64I-NEXT:    ret
;
; RV32I-MEDIUM-LABEL: constraint_o_with_extern_weak_global_3:
; RV32I-MEDIUM:       # %bb.0:
; RV32I-MEDIUM-NEXT:  .Lpcrel_hi11:
; RV32I-MEDIUM-NEXT:    auipc a0, %got_pcrel_hi(ewg)
; RV32I-MEDIUM-NEXT:    lw a0, %pcrel_lo(.Lpcrel_hi11)(a0)
; RV32I-MEDIUM-NEXT:    lui a1, 2
; RV32I-MEDIUM-NEXT:    addi a1, a1, -192
; RV32I-MEDIUM-NEXT:    add a0, a0, a1
; RV32I-MEDIUM-NEXT:    #APP
; RV32I-MEDIUM-NEXT:    sw zero, 0(a0)
; RV32I-MEDIUM-NEXT:    #NO_APP
; RV32I-MEDIUM-NEXT:    ret
;
; RV64I-MEDIUM-LABEL: constraint_o_with_extern_weak_global_3:
; RV64I-MEDIUM:       # %bb.0:
; RV64I-MEDIUM-NEXT:  .Lpcrel_hi11:
; RV64I-MEDIUM-NEXT:    auipc a0, %got_pcrel_hi(ewg)
; RV64I-MEDIUM-NEXT:    ld a0, %pcrel_lo(.Lpcrel_hi11)(a0)
; RV64I-MEDIUM-NEXT:    lui a1, 2
; RV64I-MEDIUM-NEXT:    addiw a1, a1, -192
; RV64I-MEDIUM-NEXT:    add a0, a0, a1
; RV64I-MEDIUM-NEXT:    #APP
; RV64I-MEDIUM-NEXT:    sw zero, 0(a0)
; RV64I-MEDIUM-NEXT:    #NO_APP
; RV64I-MEDIUM-NEXT:    ret
  call void asm "sw zero, $0", "=*o"(ptr nonnull elementtype(i32) getelementptr inbounds ([400000 x i32], ptr @ewg, i32 0, i32 2000))
  ret void
}

define void @constraint_A(ptr %a) nounwind {
; RV32I-LABEL: constraint_A:
; RV32I:       # %bb.0:
; RV32I-NEXT:    #APP
; RV32I-NEXT:    sb s0, 0(a0)
; RV32I-NEXT:    #NO_APP
; RV32I-NEXT:    #APP
; RV32I-NEXT:    lb s1, 0(a0)
; RV32I-NEXT:    #NO_APP
; RV32I-NEXT:    ret
;
; RV64I-LABEL: constraint_A:
; RV64I:       # %bb.0:
; RV64I-NEXT:    #APP
; RV64I-NEXT:    sb s0, 0(a0)
; RV64I-NEXT:    #NO_APP
; RV64I-NEXT:    #APP
; RV64I-NEXT:    lb s1, 0(a0)
; RV64I-NEXT:    #NO_APP
; RV64I-NEXT:    ret
;
; RV32I-MEDIUM-LABEL: constraint_A:
; RV32I-MEDIUM:       # %bb.0:
; RV32I-MEDIUM-NEXT:    #APP
; RV32I-MEDIUM-NEXT:    sb s0, 0(a0)
; RV32I-MEDIUM-NEXT:    #NO_APP
; RV32I-MEDIUM-NEXT:    #APP
; RV32I-MEDIUM-NEXT:    lb s1, 0(a0)
; RV32I-MEDIUM-NEXT:    #NO_APP
; RV32I-MEDIUM-NEXT:    ret
;
; RV64I-MEDIUM-LABEL: constraint_A:
; RV64I-MEDIUM:       # %bb.0:
; RV64I-MEDIUM-NEXT:    #APP
; RV64I-MEDIUM-NEXT:    sb s0, 0(a0)
; RV64I-MEDIUM-NEXT:    #NO_APP
; RV64I-MEDIUM-NEXT:    #APP
; RV64I-MEDIUM-NEXT:    lb s1, 0(a0)
; RV64I-MEDIUM-NEXT:    #NO_APP
; RV64I-MEDIUM-NEXT:    ret
  tail call void asm sideeffect "sb s0, $0", "*A"(ptr elementtype(i8) %a)
  tail call void asm sideeffect "lb s1, $0", "*A"(ptr elementtype(i8) %a)
  ret void
}

define i32 @constraint_A_with_offset(ptr %a) nounwind {
; RV32I-LABEL: constraint_A_with_offset:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi a0, a0, 4
; RV32I-NEXT:    #APP
; RV32I-NEXT:    lw a0, 0(a0)
; RV32I-NEXT:    #NO_APP
; RV32I-NEXT:    ret
;
; RV64I-LABEL: constraint_A_with_offset:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi a0, a0, 4
; RV64I-NEXT:    #APP
; RV64I-NEXT:    lw a0, 0(a0)
; RV64I-NEXT:    #NO_APP
; RV64I-NEXT:    ret
;
; RV32I-MEDIUM-LABEL: constraint_A_with_offset:
; RV32I-MEDIUM:       # %bb.0:
; RV32I-MEDIUM-NEXT:    addi a0, a0, 4
; RV32I-MEDIUM-NEXT:    #APP
; RV32I-MEDIUM-NEXT:    lw a0, 0(a0)
; RV32I-MEDIUM-NEXT:    #NO_APP
; RV32I-MEDIUM-NEXT:    ret
;
; RV64I-MEDIUM-LABEL: constraint_A_with_offset:
; RV64I-MEDIUM:       # %bb.0:
; RV64I-MEDIUM-NEXT:    addi a0, a0, 4
; RV64I-MEDIUM-NEXT:    #APP
; RV64I-MEDIUM-NEXT:    lw a0, 0(a0)
; RV64I-MEDIUM-NEXT:    #NO_APP
; RV64I-MEDIUM-NEXT:    ret
  %1 = getelementptr i32, ptr %a, i32 1
  %2 = tail call i32 asm "lw $0, $1", "=r,*A"(ptr elementtype(i32) %1)
  ret i32 %2
}
