; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py
; RUN: opt -disable-output "-passes=print<scalar-evolution>" %s 2>&1 | FileCheck %s

target triple = "x86_64-unknown-linux-gnu"

define void @test_and(i16 %in) {
; CHECK-LABEL: 'test_and'
; CHECK-NEXT:  Classifying expressions for: @test_and
; CHECK-NEXT:    %_tmp25.i = phi i16 [ %in, %bb2 ], [ %_tmp6.i, %bb1.i ]
; CHECK-NEXT:    --> {%in,+,1}<nsw><%bb1.i> U: full-set S: full-set Exits: 1 LoopDispositions: { %bb1.i: Computable, %bb2: Variant }
; CHECK-NEXT:    %_tmp6.i = add nsw i16 %_tmp25.i, 1
; CHECK-NEXT:    --> {(1 + %in),+,1}<nsw><%bb1.i> U: full-set S: full-set Exits: 2 LoopDispositions: { %bb1.i: Computable, %bb2: Variant }
; CHECK-NEXT:    %or.cond = and i1 %_tmp10.i, %exitcond.i
; CHECK-NEXT:    --> (%_tmp10.i umin %exitcond.i) U: full-set S: full-set Exits: true LoopDispositions: { %bb1.i: Variant, %bb2: Variant }
; CHECK-NEXT:  Determining loop execution counts for: @test_and
; CHECK-NEXT:  Loop %bb1.i: backedge-taken count is (1 + (-1 * %in))
; CHECK-NEXT:  Loop %bb1.i: constant max backedge-taken count is -1
; CHECK-NEXT:  Loop %bb1.i: symbolic max backedge-taken count is (1 + (-1 * %in))
; CHECK-NEXT:  Loop %bb1.i: Predicated backedge-taken count is (1 + (-1 * %in))
; CHECK-NEXT:   Predicates:
; CHECK:       Loop %bb1.i: Trip multiple is 1
; CHECK-NEXT:  Loop %bb2: <multiple exits> Unpredictable backedge-taken count.
; CHECK-NEXT:  Loop %bb2: Unpredictable constant max backedge-taken count.
; CHECK-NEXT:  Loop %bb2: Unpredictable symbolic max backedge-taken count.
; CHECK-NEXT:  Loop %bb2: Unpredictable predicated backedge-taken count.
;
  br label %bb2

bb2:                                              ; preds = %bb1.i, %bb2, %0
  %_tmp44.i = icmp slt i16 %in, 2
  br i1 %_tmp44.i, label %bb1.i, label %bb2

bb1.i:                                            ; preds = %bb1.i, %bb2
  %_tmp25.i = phi i16 [ %in, %bb2 ], [ %_tmp6.i, %bb1.i ]
  %_tmp6.i = add nsw i16 %_tmp25.i, 1
  %_tmp10.i = icmp sge i16 %_tmp6.i, 2
  %exitcond.i = icmp eq i16 %_tmp6.i, 2
  %or.cond = and i1 %_tmp10.i, %exitcond.i
  br i1 %or.cond, label %bb2, label %bb1.i
}

define void @test_or() {
; CHECK-LABEL: 'test_or'
; CHECK-NEXT:  Classifying expressions for: @test_or
; CHECK-NEXT:    %indvars.iv = phi i64 [ -1, %BB ], [ -1, %0 ]
; CHECK-NEXT:    --> -1 U: [-1,0) S: [-1,0) Exits: -1 LoopDispositions: { %BB: Invariant }
; CHECK-NEXT:    %sum.01 = phi i32 [ %2, %BB ], [ undef, %0 ]
; CHECK-NEXT:    --> {undef,+,-1}<%BB> U: full-set S: full-set Exits: 0 LoopDispositions: { %BB: Computable }
; CHECK-NEXT:    %1 = trunc i64 %indvars.iv to i32
; CHECK-NEXT:    --> -1 U: [-1,0) S: [-1,0) Exits: -1 LoopDispositions: { %BB: Invariant }
; CHECK-NEXT:    %2 = add nsw i32 %1, %sum.01
; CHECK-NEXT:    --> {(-1 + undef),+,-1}<%BB> U: full-set S: full-set Exits: -1 LoopDispositions: { %BB: Computable }
; CHECK-NEXT:    %B3 = add i32 %1, %2
; CHECK-NEXT:    --> {(-2 + undef),+,-1}<%BB> U: full-set S: full-set Exits: -2 LoopDispositions: { %BB: Computable }
; CHECK-NEXT:    %B = or i1 %C5, %C11
; CHECK-NEXT:    --> (%C11 umax %C5) U: full-set S: full-set Exits: false LoopDispositions: { %BB: Variant }
; CHECK-NEXT:  Determining loop execution counts for: @test_or
; CHECK-NEXT:  Loop %BB: backedge-taken count is undef
; CHECK-NEXT:  Loop %BB: constant max backedge-taken count is -1
; CHECK-NEXT:  Loop %BB: symbolic max backedge-taken count is undef
; CHECK-NEXT:  Loop %BB: Predicated backedge-taken count is undef
; CHECK-NEXT:   Predicates:
; CHECK:       Loop %BB: Trip multiple is 1
;
  %C10 = icmp slt i1 undef, undef
  br i1 %C10, label %BB, label %exit

BB:                                               ; preds = %BB, %0
  %indvars.iv = phi i64 [ -1, %BB ], [ -1, %0 ]
  %sum.01 = phi i32 [ %2, %BB ], [ undef, %0 ]
  %1 = trunc i64 %indvars.iv to i32
  %2 = add nsw i32 %1, %sum.01
  %B3 = add i32 %1, %2
  %C11 = icmp ult i32 %2, %1
  %C5 = icmp sle i32 %1, %B3
  %B = or i1 %C5, %C11
  br i1 %B, label %BB, label %exit

exit:                                      ; preds = %BB, %0
  ret void
}
