#ifndef _CEGOAVLINDEXMANAGER_H_INCLUDED_
#define _CEGOAVLINDEXMANAGER_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoAVLIndexManager.h
// ------------------
// Cego AVL index manager class definition
//                                                         
// Design and Implementation by Bjoern Lemke               
//     
// (C)opyright 2000-2019 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoIndexManager
// 
// Description: The IndexManager class implements the Cego binary index trees.
//              Cego index trees are binary trees and are fully balanced after each
//              insert and delete operation. 
//              
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// base includes
#include <lfcbase/Chain.h>
#include <lfcbase/ListT.h>

// cego includes
#include "CegoDataType.h"
#include "CegoField.h"
#include "CegoDataPointer.h"
#include "CegoSystemObject.h"
#include "CegoAVLIndexEntry.h"
#include "CegoTableManager.h"

class CegoAVLIndexManager {

public:
    
    CegoAVLIndexManager(CegoTableManager* pTM);
    ~CegoAVLIndexManager();
         
    void insertNativeIndexTable( CegoTableObject& ioe, 
				 const CegoDataPointer& sysEntry,
				 const CegoDataPointer& dp, 
				 char* idxPtr, 
				 int idxLen, 
				 unsigned long long tid, 		       
				 bool insertAtLastPage,
				 CegoDataPointer& ritp);
    
    void insertIndexTable(CegoTableObject& ioe, 
			  const CegoDataPointer& sysEntry,
			  const CegoDataPointer& ritp, 
			  bool isUnique, 
			  const CegoDataPointer& dp, 
			  char* idxPtr,
			  int idxLen, 
			  unsigned long long tid, 
			  bool insertAtLastPage, 
			  bool allowWrite = false);

    void deleteIndexTable(int tabSetId, 
			  const Chain& tableName, 
			  CegoObject::ObjectType tabType,
			  const Chain& indexName,
			  CegoObject::ObjectType idxType,
			  const ListT<CegoField>& schema,
			  const CegoDataPointer& ddp,
			  char* idxPtr, 
			  int idxLen,
			  bool allowWrite = false);

    char checkIndex(int tabSetId, const Chain& indexName, CegoObject::ObjectType idxType);

private:

    enum TupleOrder { GT, LT , EQU, EQU_NULL };

    CegoTableManager* _pTM;
    Logger* _pLogger;

    TupleOrder compIndexValue(const ListT<CegoField>& schema, char* p1, char* p2);
    
    void getSubTreeHeight(int tabSetId, CegoBufferPool::FixMode fixMode, const CegoAVLIndexEntry& pe, char& leftHeigtht, char& rightHeight);
    void propagateDecrease(int tabSetId, CegoDataPointer itp, CegoBufferPool::FixMode fixMode);
    CegoDataPointer rebalanceNode(int tabSetId, CegoDataPointer itp, CegoBufferPool::FixMode fixMode);
    CegoDataPointer rotateRR(int tabSetId, const CegoDataPointer& ptp, CegoBufferPool::FixMode fixMode);        
    CegoDataPointer rotateRL(int tabSetId, const CegoDataPointer& ptp, CegoBufferPool::FixMode fixMode);    
    CegoDataPointer rotateLL(int tabSetId, const CegoDataPointer& ptp, CegoBufferPool::FixMode fixMode);
    CegoDataPointer rotateLR(int tabSetId, const CegoDataPointer& ptp, CegoBufferPool::FixMode fixMode);    

    char recursiveIndexNodeCheck(int tabSetId, const CegoDataPointer& dp);

    CegoDataPointer searchDataPointer(int tabSetId, const CegoDataPointer& ddp, const CegoDataPointer& rdp, CegoBufferPool::FixMode fixMode);

    unsigned int _lockId;
    
    unsigned long _modId;
};

#endif
