//
// File: Cego.cc
// This code was produced by the dragon parser generator
//
#include "Cego.h"
#include <lfcbase/Exception.h>
#include <lfcbase/StackT.h>

Cego::ScannerStateEntry::ScannerStateEntry()
{
}

Cego::ScannerStateEntry::ScannerStateEntry(int state, ScannerStateType type)
{
   _state = state;
   _type = type;
}

Cego::ScannerStateEntry& Cego::ScannerStateEntry::operator = (const Cego::ScannerStateEntry& s)
{
   _state = s._state;
   _type = s._type;
   return(*this);
}

bool Cego::ScannerStateEntry::operator == (const Cego::ScannerStateEntry& s)
{
   if ( _state == s._state )
      return true;
   return false;
}

Cego::ScannerStateType Cego::ScannerStateEntry::getType()
{
   return _type;
}
int Cego::ScannerStateEntry::getState()
{
   return _state;
}


Cego::ScannerTransEntry::ScannerTransEntry()
{
}

Cego::ScannerTransEntry::ScannerTransEntry(int state, char c)
{
   _state = state;
   _c = c;
}

Cego::ScannerTransEntry::ScannerTransEntry(int state, char c, int fstate)
{
   _state = state;
   _c = c;
   _fstate = fstate;
}

Cego::ScannerTransEntry& Cego::ScannerTransEntry::operator = (const Cego::ScannerTransEntry& s)
{
   _state = s._state;
   _c = s._c;
   _fstate = s._fstate;
   return(*this);
}

bool Cego::ScannerTransEntry::operator == (const Cego::ScannerTransEntry& s)
{
   if ( _state == s._state && _c == s._c)
      return true;
   return false;
}

int Cego::ScannerTransEntry::getFState()
{
   return _fstate;
}


Cego::Scanner::Scanner()
{
}


Cego::Scanner::Scanner(Token t)
{
   _token = t;
}

Cego::Token Cego::Scanner::getToken()
{
   return _token;
}

void Cego::Scanner::addState(ScannerStateEntry s)
{
   _stateList.Insert(s);
}

void Cego::Scanner::addTransition(ScannerTransEntry t)
{
   _transList.Insert(t);
}

bool Cego::Scanner::checkPattern(const Chain& p)
{
   unsigned long state = 0;
   ScannerStateEntry* pS = _stateList.First();
   while (pS)
   {
      if (pS->getType() == START || pS->getType() == ANY)
      {
         state = pS->getState();
         pS = 0;
      }
      else
      {
         pS = _stateList.Next();
      }
   }
   unsigned long i = 0;
   ScannerTransEntry* pT = 
   _transList.Find(ScannerTransEntry(state, p[i]));
   while (pT)
   {
      ScannerStateEntry* pS = _stateList.Find(ScannerStateEntry(pT->getFState())); 
      if (pS)
      {
         if ( ( i == p.length()-2 ) && ( pS->getType() == FINAL || pS->getType() == ANY))
         {
            return true;
         }
         else
         {
            state = pT->getFState();
         }
      }
      else
      {
         return false;
      }
      i++;
      pT = _transList.Find(ScannerTransEntry(state, p[i]));
   }
   return false;
}
Cego::StackEntry::StackEntry()
{
   _symbol = NONE;
}

Cego::StackEntry::StackEntry(Symbol symbol, int num, int state, Chain tval)
{
   _symbol=symbol;
   _num=num;
   _state=state;
   _tval=tval;
}

Cego::StackEntry& Cego::StackEntry::operator = (const Cego::StackEntry& se)
{
   _symbol=se._symbol;
   _num=se._num;
   _state=se._state;
   _tval=se._tval;
   return(*this);
}

int Cego::StackEntry::getState()
{
   return _state;
}
Cego::Symbol Cego::StackEntry::getSymbol()
{
   return _symbol;
}
Chain& Cego::StackEntry::getTval()
{
   return _tval;
}

Cego::ActionEntry::ActionEntry()
{
   _action=NULLACTION;
}

Cego::ActionEntry::ActionEntry(Action action , int num)
{
   _action=action;
   _num=num;
}

bool Cego::ActionEntry::operator == (const Cego::ActionEntry& ae)
{
   if (_action == ae._action && _num == ae._num)
      return true;
   return false;
}

Cego::ActionEntry& Cego::ActionEntry::operator = (const Cego::ActionEntry& ae)
{
   _action=ae._action;
   _num=ae._num;
   return(*this);
}

Cego::Action Cego::ActionEntry::getAction()
{
   return _action;
}

int Cego::ActionEntry::getNum()
{
   return _num;
}

Cego::ProdEntry::ProdEntry()
{
}

Cego::ProdEntry::ProdEntry(int id)
{
   _id = id;
}

Cego::ProdEntry::ProdEntry(int id, Production prod, int numSymbol)
{
   _id = id;
   _prod = prod;
   _numSymbol = numSymbol;
}

bool Cego::ProdEntry::operator == (const Cego::ProdEntry& pe)
{
   if (_id == pe._id)
      return true;
   return false;
}

Cego::ProdEntry& Cego::ProdEntry::operator = (const Cego::ProdEntry& pe)
{
   _id = pe._id;
   _prod = pe._prod;
   _numSymbol = pe._numSymbol;
   return(*this);
}


int Cego::ProdEntry::getId()
{
   return _id;
}

Cego::Production Cego::ProdEntry::getProd()
{
   return _prod;
}

int Cego::ProdEntry::getNumSymbol()
{
   return _numSymbol;
}
void Cego::loadScanner()
{
   Scanner s0(ADD);
   s0.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s0.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s0.addState(ScannerStateEntry(2 ,START));
   s0.addState(ScannerStateEntry(3 ,FINAL));
   s0.addTransition(ScannerTransEntry(0 ,'D' ,1));
   s0.addTransition(ScannerTransEntry(0 ,'d' ,1));
   s0.addTransition(ScannerTransEntry(1 ,'D' ,3));
   s0.addTransition(ScannerTransEntry(1 ,'d' ,3));
   s0.addTransition(ScannerTransEntry(2 ,'A' ,0));
   s0.addTransition(ScannerTransEntry(2 ,'a' ,0));
   _scannerList.Insert(s0);

   Scanner s1(AFTER);
   s1.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s1.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s1.addState(ScannerStateEntry(2 ,START));
   s1.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s1.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s1.addState(ScannerStateEntry(5 ,FINAL));
   s1.addTransition(ScannerTransEntry(0 ,'F' ,1));
   s1.addTransition(ScannerTransEntry(0 ,'f' ,1));
   s1.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s1.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s1.addTransition(ScannerTransEntry(2 ,'A' ,0));
   s1.addTransition(ScannerTransEntry(2 ,'a' ,0));
   s1.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s1.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s1.addTransition(ScannerTransEntry(4 ,'R' ,5));
   s1.addTransition(ScannerTransEntry(4 ,'r' ,5));
   _scannerList.Insert(s1);

   Scanner s2(ALIAS);
   s2.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s2.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s2.addState(ScannerStateEntry(2 ,START));
   s2.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s2.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s2.addState(ScannerStateEntry(5 ,FINAL));
   s2.addTransition(ScannerTransEntry(0 ,'L' ,1));
   s2.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s2.addTransition(ScannerTransEntry(1 ,'I' ,3));
   s2.addTransition(ScannerTransEntry(1 ,'i' ,3));
   s2.addTransition(ScannerTransEntry(2 ,'A' ,0));
   s2.addTransition(ScannerTransEntry(2 ,'a' ,0));
   s2.addTransition(ScannerTransEntry(3 ,'A' ,4));
   s2.addTransition(ScannerTransEntry(3 ,'a' ,4));
   s2.addTransition(ScannerTransEntry(4 ,'S' ,5));
   s2.addTransition(ScannerTransEntry(4 ,'s' ,5));
   _scannerList.Insert(s2);

   Scanner s3(AND);
   s3.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s3.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s3.addState(ScannerStateEntry(2 ,START));
   s3.addState(ScannerStateEntry(3 ,FINAL));
   s3.addTransition(ScannerTransEntry(0 ,'N' ,1));
   s3.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s3.addTransition(ScannerTransEntry(1 ,'D' ,3));
   s3.addTransition(ScannerTransEntry(1 ,'d' ,3));
   s3.addTransition(ScannerTransEntry(2 ,'A' ,0));
   s3.addTransition(ScannerTransEntry(2 ,'a' ,0));
   _scannerList.Insert(s3);

   Scanner s4(ALL);
   s4.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s4.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s4.addState(ScannerStateEntry(2 ,START));
   s4.addState(ScannerStateEntry(3 ,FINAL));
   s4.addTransition(ScannerTransEntry(0 ,'L' ,1));
   s4.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s4.addTransition(ScannerTransEntry(1 ,'L' ,3));
   s4.addTransition(ScannerTransEntry(1 ,'l' ,3));
   s4.addTransition(ScannerTransEntry(2 ,'A' ,0));
   s4.addTransition(ScannerTransEntry(2 ,'a' ,0));
   _scannerList.Insert(s4);

   Scanner s5(ALTER);
   s5.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s5.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s5.addState(ScannerStateEntry(2 ,START));
   s5.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s5.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s5.addState(ScannerStateEntry(5 ,FINAL));
   s5.addTransition(ScannerTransEntry(0 ,'L' ,1));
   s5.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s5.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s5.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s5.addTransition(ScannerTransEntry(2 ,'A' ,0));
   s5.addTransition(ScannerTransEntry(2 ,'a' ,0));
   s5.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s5.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s5.addTransition(ScannerTransEntry(4 ,'R' ,5));
   s5.addTransition(ScannerTransEntry(4 ,'r' ,5));
   _scannerList.Insert(s5);

   Scanner s6(APPEND);
   s6.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s6.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s6.addState(ScannerStateEntry(2 ,START));
   s6.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s6.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s6.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s6.addState(ScannerStateEntry(6 ,FINAL));
   s6.addTransition(ScannerTransEntry(0 ,'P' ,1));
   s6.addTransition(ScannerTransEntry(0 ,'p' ,1));
   s6.addTransition(ScannerTransEntry(1 ,'P' ,3));
   s6.addTransition(ScannerTransEntry(1 ,'p' ,3));
   s6.addTransition(ScannerTransEntry(2 ,'A' ,0));
   s6.addTransition(ScannerTransEntry(2 ,'a' ,0));
   s6.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s6.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s6.addTransition(ScannerTransEntry(4 ,'N' ,5));
   s6.addTransition(ScannerTransEntry(4 ,'n' ,5));
   s6.addTransition(ScannerTransEntry(5 ,'D' ,6));
   s6.addTransition(ScannerTransEntry(5 ,'d' ,6));
   _scannerList.Insert(s6);

   Scanner s7(AS);
   s7.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s7.addState(ScannerStateEntry(1 ,FINAL));
   s7.addState(ScannerStateEntry(2 ,START));
   s7.addTransition(ScannerTransEntry(0 ,'S' ,1));
   s7.addTransition(ScannerTransEntry(0 ,'s' ,1));
   s7.addTransition(ScannerTransEntry(2 ,'A' ,0));
   s7.addTransition(ScannerTransEntry(2 ,'a' ,0));
   _scannerList.Insert(s7);

   Scanner s8(ASC);
   s8.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s8.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s8.addState(ScannerStateEntry(2 ,START));
   s8.addState(ScannerStateEntry(3 ,FINAL));
   s8.addTransition(ScannerTransEntry(0 ,'S' ,1));
   s8.addTransition(ScannerTransEntry(0 ,'s' ,1));
   s8.addTransition(ScannerTransEntry(1 ,'C' ,3));
   s8.addTransition(ScannerTransEntry(1 ,'c' ,3));
   s8.addTransition(ScannerTransEntry(2 ,'A' ,0));
   s8.addTransition(ScannerTransEntry(2 ,'a' ,0));
   _scannerList.Insert(s8);

   Scanner s9(ASC2INT);
   s9.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s9.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s9.addState(ScannerStateEntry(2 ,START));
   s9.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s9.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s9.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s9.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s9.addState(ScannerStateEntry(7 ,FINAL));
   s9.addTransition(ScannerTransEntry(0 ,'S' ,1));
   s9.addTransition(ScannerTransEntry(0 ,'s' ,1));
   s9.addTransition(ScannerTransEntry(1 ,'C' ,3));
   s9.addTransition(ScannerTransEntry(1 ,'c' ,3));
   s9.addTransition(ScannerTransEntry(2 ,'A' ,0));
   s9.addTransition(ScannerTransEntry(2 ,'a' ,0));
   s9.addTransition(ScannerTransEntry(3 ,'2' ,4));
   s9.addTransition(ScannerTransEntry(4 ,'I' ,5));
   s9.addTransition(ScannerTransEntry(4 ,'i' ,5));
   s9.addTransition(ScannerTransEntry(5 ,'N' ,6));
   s9.addTransition(ScannerTransEntry(5 ,'n' ,6));
   s9.addTransition(ScannerTransEntry(6 ,'T' ,7));
   s9.addTransition(ScannerTransEntry(6 ,'t' ,7));
   _scannerList.Insert(s9);

   Scanner s10(AUTHORIZE);
   s10.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s10.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s10.addState(ScannerStateEntry(2 ,START));
   s10.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s10.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s10.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s10.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s10.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s10.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s10.addState(ScannerStateEntry(9 ,FINAL));
   s10.addTransition(ScannerTransEntry(0 ,'U' ,1));
   s10.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s10.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s10.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s10.addTransition(ScannerTransEntry(2 ,'A' ,0));
   s10.addTransition(ScannerTransEntry(2 ,'a' ,0));
   s10.addTransition(ScannerTransEntry(3 ,'H' ,4));
   s10.addTransition(ScannerTransEntry(3 ,'h' ,4));
   s10.addTransition(ScannerTransEntry(4 ,'O' ,5));
   s10.addTransition(ScannerTransEntry(4 ,'o' ,5));
   s10.addTransition(ScannerTransEntry(5 ,'R' ,6));
   s10.addTransition(ScannerTransEntry(5 ,'r' ,6));
   s10.addTransition(ScannerTransEntry(6 ,'I' ,7));
   s10.addTransition(ScannerTransEntry(6 ,'i' ,7));
   s10.addTransition(ScannerTransEntry(7 ,'Z' ,8));
   s10.addTransition(ScannerTransEntry(7 ,'z' ,8));
   s10.addTransition(ScannerTransEntry(8 ,'E' ,9));
   s10.addTransition(ScannerTransEntry(8 ,'e' ,9));
   _scannerList.Insert(s10);

   Scanner s11(AUTOCOMMIT);
   s11.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s11.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s11.addState(ScannerStateEntry(2 ,START));
   s11.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s11.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s11.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s11.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s11.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s11.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s11.addState(ScannerStateEntry(9 ,INTERMEDIATE));
   s11.addState(ScannerStateEntry(10 ,FINAL));
   s11.addTransition(ScannerTransEntry(0 ,'U' ,1));
   s11.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s11.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s11.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s11.addTransition(ScannerTransEntry(2 ,'A' ,0));
   s11.addTransition(ScannerTransEntry(2 ,'a' ,0));
   s11.addTransition(ScannerTransEntry(3 ,'O' ,4));
   s11.addTransition(ScannerTransEntry(3 ,'o' ,4));
   s11.addTransition(ScannerTransEntry(4 ,'C' ,5));
   s11.addTransition(ScannerTransEntry(4 ,'c' ,5));
   s11.addTransition(ScannerTransEntry(5 ,'O' ,6));
   s11.addTransition(ScannerTransEntry(5 ,'o' ,6));
   s11.addTransition(ScannerTransEntry(6 ,'M' ,7));
   s11.addTransition(ScannerTransEntry(6 ,'m' ,7));
   s11.addTransition(ScannerTransEntry(7 ,'M' ,8));
   s11.addTransition(ScannerTransEntry(7 ,'m' ,8));
   s11.addTransition(ScannerTransEntry(8 ,'I' ,9));
   s11.addTransition(ScannerTransEntry(8 ,'i' ,9));
   s11.addTransition(ScannerTransEntry(9 ,'T' ,10));
   s11.addTransition(ScannerTransEntry(9 ,'t' ,10));
   _scannerList.Insert(s11);

   Scanner s12(AVG);
   s12.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s12.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s12.addState(ScannerStateEntry(2 ,START));
   s12.addState(ScannerStateEntry(3 ,FINAL));
   s12.addTransition(ScannerTransEntry(0 ,'V' ,1));
   s12.addTransition(ScannerTransEntry(0 ,'v' ,1));
   s12.addTransition(ScannerTransEntry(1 ,'G' ,3));
   s12.addTransition(ScannerTransEntry(1 ,'g' ,3));
   s12.addTransition(ScannerTransEntry(2 ,'A' ,0));
   s12.addTransition(ScannerTransEntry(2 ,'a' ,0));
   _scannerList.Insert(s12);

   Scanner s13(AVLTREE);
   s13.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s13.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s13.addState(ScannerStateEntry(2 ,START));
   s13.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s13.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s13.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s13.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s13.addState(ScannerStateEntry(7 ,FINAL));
   s13.addTransition(ScannerTransEntry(0 ,'V' ,1));
   s13.addTransition(ScannerTransEntry(0 ,'v' ,1));
   s13.addTransition(ScannerTransEntry(1 ,'L' ,3));
   s13.addTransition(ScannerTransEntry(1 ,'l' ,3));
   s13.addTransition(ScannerTransEntry(2 ,'A' ,0));
   s13.addTransition(ScannerTransEntry(2 ,'a' ,0));
   s13.addTransition(ScannerTransEntry(3 ,'T' ,4));
   s13.addTransition(ScannerTransEntry(3 ,'t' ,4));
   s13.addTransition(ScannerTransEntry(4 ,'R' ,5));
   s13.addTransition(ScannerTransEntry(4 ,'r' ,5));
   s13.addTransition(ScannerTransEntry(5 ,'E' ,6));
   s13.addTransition(ScannerTransEntry(5 ,'e' ,6));
   s13.addTransition(ScannerTransEntry(6 ,'E' ,7));
   s13.addTransition(ScannerTransEntry(6 ,'e' ,7));
   _scannerList.Insert(s13);

   Scanner s14(BEFORE);
   s14.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s14.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s14.addState(ScannerStateEntry(2 ,START));
   s14.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s14.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s14.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s14.addState(ScannerStateEntry(6 ,FINAL));
   s14.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s14.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s14.addTransition(ScannerTransEntry(1 ,'F' ,3));
   s14.addTransition(ScannerTransEntry(1 ,'f' ,3));
   s14.addTransition(ScannerTransEntry(2 ,'B' ,0));
   s14.addTransition(ScannerTransEntry(2 ,'b' ,0));
   s14.addTransition(ScannerTransEntry(3 ,'O' ,4));
   s14.addTransition(ScannerTransEntry(3 ,'o' ,4));
   s14.addTransition(ScannerTransEntry(4 ,'R' ,5));
   s14.addTransition(ScannerTransEntry(4 ,'r' ,5));
   s14.addTransition(ScannerTransEntry(5 ,'E' ,6));
   s14.addTransition(ScannerTransEntry(5 ,'e' ,6));
   _scannerList.Insert(s14);

   Scanner s15(BEGIN);
   s15.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s15.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s15.addState(ScannerStateEntry(2 ,START));
   s15.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s15.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s15.addState(ScannerStateEntry(5 ,FINAL));
   s15.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s15.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s15.addTransition(ScannerTransEntry(1 ,'G' ,3));
   s15.addTransition(ScannerTransEntry(1 ,'g' ,3));
   s15.addTransition(ScannerTransEntry(2 ,'B' ,0));
   s15.addTransition(ScannerTransEntry(2 ,'b' ,0));
   s15.addTransition(ScannerTransEntry(3 ,'I' ,4));
   s15.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s15.addTransition(ScannerTransEntry(4 ,'N' ,5));
   s15.addTransition(ScannerTransEntry(4 ,'n' ,5));
   _scannerList.Insert(s15);

   Scanner s16(BETWEEN);
   s16.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s16.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s16.addState(ScannerStateEntry(2 ,START));
   s16.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s16.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s16.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s16.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s16.addState(ScannerStateEntry(7 ,FINAL));
   s16.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s16.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s16.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s16.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s16.addTransition(ScannerTransEntry(2 ,'B' ,0));
   s16.addTransition(ScannerTransEntry(2 ,'b' ,0));
   s16.addTransition(ScannerTransEntry(3 ,'W' ,4));
   s16.addTransition(ScannerTransEntry(3 ,'w' ,4));
   s16.addTransition(ScannerTransEntry(4 ,'E' ,5));
   s16.addTransition(ScannerTransEntry(4 ,'e' ,5));
   s16.addTransition(ScannerTransEntry(5 ,'E' ,6));
   s16.addTransition(ScannerTransEntry(5 ,'e' ,6));
   s16.addTransition(ScannerTransEntry(6 ,'N' ,7));
   s16.addTransition(ScannerTransEntry(6 ,'n' ,7));
   _scannerList.Insert(s16);

   Scanner s17(BIGINT);
   s17.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s17.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s17.addState(ScannerStateEntry(2 ,START));
   s17.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s17.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s17.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s17.addState(ScannerStateEntry(6 ,FINAL));
   s17.addTransition(ScannerTransEntry(0 ,'I' ,1));
   s17.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s17.addTransition(ScannerTransEntry(1 ,'G' ,3));
   s17.addTransition(ScannerTransEntry(1 ,'g' ,3));
   s17.addTransition(ScannerTransEntry(2 ,'B' ,0));
   s17.addTransition(ScannerTransEntry(2 ,'b' ,0));
   s17.addTransition(ScannerTransEntry(3 ,'I' ,4));
   s17.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s17.addTransition(ScannerTransEntry(4 ,'N' ,5));
   s17.addTransition(ScannerTransEntry(4 ,'n' ,5));
   s17.addTransition(ScannerTransEntry(5 ,'T' ,6));
   s17.addTransition(ScannerTransEntry(5 ,'t' ,6));
   _scannerList.Insert(s17);

   Scanner s18(BITAND);
   s18.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s18.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s18.addState(ScannerStateEntry(2 ,START));
   s18.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s18.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s18.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s18.addState(ScannerStateEntry(6 ,FINAL));
   s18.addTransition(ScannerTransEntry(0 ,'I' ,1));
   s18.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s18.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s18.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s18.addTransition(ScannerTransEntry(2 ,'B' ,0));
   s18.addTransition(ScannerTransEntry(2 ,'b' ,0));
   s18.addTransition(ScannerTransEntry(3 ,'A' ,4));
   s18.addTransition(ScannerTransEntry(3 ,'a' ,4));
   s18.addTransition(ScannerTransEntry(4 ,'N' ,5));
   s18.addTransition(ScannerTransEntry(4 ,'n' ,5));
   s18.addTransition(ScannerTransEntry(5 ,'D' ,6));
   s18.addTransition(ScannerTransEntry(5 ,'d' ,6));
   _scannerList.Insert(s18);

   Scanner s19(BITOR);
   s19.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s19.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s19.addState(ScannerStateEntry(2 ,START));
   s19.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s19.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s19.addState(ScannerStateEntry(5 ,FINAL));
   s19.addTransition(ScannerTransEntry(0 ,'I' ,1));
   s19.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s19.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s19.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s19.addTransition(ScannerTransEntry(2 ,'B' ,0));
   s19.addTransition(ScannerTransEntry(2 ,'b' ,0));
   s19.addTransition(ScannerTransEntry(3 ,'O' ,4));
   s19.addTransition(ScannerTransEntry(3 ,'o' ,4));
   s19.addTransition(ScannerTransEntry(4 ,'R' ,5));
   s19.addTransition(ScannerTransEntry(4 ,'r' ,5));
   _scannerList.Insert(s19);

   Scanner s20(BITXOR);
   s20.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s20.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s20.addState(ScannerStateEntry(2 ,START));
   s20.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s20.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s20.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s20.addState(ScannerStateEntry(6 ,FINAL));
   s20.addTransition(ScannerTransEntry(0 ,'I' ,1));
   s20.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s20.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s20.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s20.addTransition(ScannerTransEntry(2 ,'B' ,0));
   s20.addTransition(ScannerTransEntry(2 ,'b' ,0));
   s20.addTransition(ScannerTransEntry(3 ,'X' ,4));
   s20.addTransition(ScannerTransEntry(3 ,'x' ,4));
   s20.addTransition(ScannerTransEntry(4 ,'O' ,5));
   s20.addTransition(ScannerTransEntry(4 ,'o' ,5));
   s20.addTransition(ScannerTransEntry(5 ,'R' ,6));
   s20.addTransition(ScannerTransEntry(5 ,'r' ,6));
   _scannerList.Insert(s20);

   Scanner s21(BLOB);
   s21.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s21.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s21.addState(ScannerStateEntry(2 ,START));
   s21.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s21.addState(ScannerStateEntry(4 ,FINAL));
   s21.addTransition(ScannerTransEntry(0 ,'L' ,1));
   s21.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s21.addTransition(ScannerTransEntry(1 ,'O' ,3));
   s21.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s21.addTransition(ScannerTransEntry(2 ,'B' ,0));
   s21.addTransition(ScannerTransEntry(2 ,'b' ,0));
   s21.addTransition(ScannerTransEntry(3 ,'B' ,4));
   s21.addTransition(ScannerTransEntry(3 ,'b' ,4));
   _scannerList.Insert(s21);

   Scanner s22(BLOBSIZE);
   s22.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s22.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s22.addState(ScannerStateEntry(2 ,START));
   s22.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s22.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s22.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s22.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s22.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s22.addState(ScannerStateEntry(8 ,FINAL));
   s22.addTransition(ScannerTransEntry(0 ,'L' ,1));
   s22.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s22.addTransition(ScannerTransEntry(1 ,'O' ,3));
   s22.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s22.addTransition(ScannerTransEntry(2 ,'B' ,0));
   s22.addTransition(ScannerTransEntry(2 ,'b' ,0));
   s22.addTransition(ScannerTransEntry(3 ,'B' ,4));
   s22.addTransition(ScannerTransEntry(3 ,'b' ,4));
   s22.addTransition(ScannerTransEntry(4 ,'S' ,5));
   s22.addTransition(ScannerTransEntry(4 ,'s' ,5));
   s22.addTransition(ScannerTransEntry(5 ,'I' ,6));
   s22.addTransition(ScannerTransEntry(5 ,'i' ,6));
   s22.addTransition(ScannerTransEntry(6 ,'Z' ,7));
   s22.addTransition(ScannerTransEntry(6 ,'z' ,7));
   s22.addTransition(ScannerTransEntry(7 ,'E' ,8));
   s22.addTransition(ScannerTransEntry(7 ,'e' ,8));
   _scannerList.Insert(s22);

   Scanner s23(BLOBREF);
   s23.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s23.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s23.addState(ScannerStateEntry(2 ,START));
   s23.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s23.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s23.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s23.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s23.addState(ScannerStateEntry(7 ,FINAL));
   s23.addTransition(ScannerTransEntry(0 ,'L' ,1));
   s23.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s23.addTransition(ScannerTransEntry(1 ,'O' ,3));
   s23.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s23.addTransition(ScannerTransEntry(2 ,'B' ,0));
   s23.addTransition(ScannerTransEntry(2 ,'b' ,0));
   s23.addTransition(ScannerTransEntry(3 ,'B' ,4));
   s23.addTransition(ScannerTransEntry(3 ,'b' ,4));
   s23.addTransition(ScannerTransEntry(4 ,'R' ,5));
   s23.addTransition(ScannerTransEntry(4 ,'r' ,5));
   s23.addTransition(ScannerTransEntry(5 ,'E' ,6));
   s23.addTransition(ScannerTransEntry(5 ,'e' ,6));
   s23.addTransition(ScannerTransEntry(6 ,'F' ,7));
   s23.addTransition(ScannerTransEntry(6 ,'f' ,7));
   _scannerList.Insert(s23);

   Scanner s24(BOOL);
   s24.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s24.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s24.addState(ScannerStateEntry(2 ,START));
   s24.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s24.addState(ScannerStateEntry(4 ,FINAL));
   s24.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s24.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s24.addTransition(ScannerTransEntry(1 ,'O' ,3));
   s24.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s24.addTransition(ScannerTransEntry(2 ,'B' ,0));
   s24.addTransition(ScannerTransEntry(2 ,'b' ,0));
   s24.addTransition(ScannerTransEntry(3 ,'L' ,4));
   s24.addTransition(ScannerTransEntry(3 ,'l' ,4));
   _scannerList.Insert(s24);

   Scanner s25(BTREE);
   s25.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s25.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s25.addState(ScannerStateEntry(2 ,START));
   s25.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s25.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s25.addState(ScannerStateEntry(5 ,FINAL));
   s25.addTransition(ScannerTransEntry(0 ,'T' ,1));
   s25.addTransition(ScannerTransEntry(0 ,'t' ,1));
   s25.addTransition(ScannerTransEntry(1 ,'R' ,3));
   s25.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s25.addTransition(ScannerTransEntry(2 ,'B' ,0));
   s25.addTransition(ScannerTransEntry(2 ,'b' ,0));
   s25.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s25.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s25.addTransition(ScannerTransEntry(4 ,'E' ,5));
   s25.addTransition(ScannerTransEntry(4 ,'e' ,5));
   _scannerList.Insert(s25);

   Scanner s26(BY);
   s26.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s26.addState(ScannerStateEntry(1 ,FINAL));
   s26.addState(ScannerStateEntry(2 ,START));
   s26.addTransition(ScannerTransEntry(0 ,'Y' ,1));
   s26.addTransition(ScannerTransEntry(0 ,'y' ,1));
   s26.addTransition(ScannerTransEntry(2 ,'B' ,0));
   s26.addTransition(ScannerTransEntry(2 ,'b' ,0));
   _scannerList.Insert(s26);

   Scanner s27(CACHED);
   s27.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s27.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s27.addState(ScannerStateEntry(2 ,START));
   s27.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s27.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s27.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s27.addState(ScannerStateEntry(6 ,FINAL));
   s27.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s27.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s27.addTransition(ScannerTransEntry(1 ,'C' ,3));
   s27.addTransition(ScannerTransEntry(1 ,'c' ,3));
   s27.addTransition(ScannerTransEntry(2 ,'C' ,0));
   s27.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s27.addTransition(ScannerTransEntry(3 ,'H' ,4));
   s27.addTransition(ScannerTransEntry(3 ,'h' ,4));
   s27.addTransition(ScannerTransEntry(4 ,'E' ,5));
   s27.addTransition(ScannerTransEntry(4 ,'e' ,5));
   s27.addTransition(ScannerTransEntry(5 ,'D' ,6));
   s27.addTransition(ScannerTransEntry(5 ,'d' ,6));
   _scannerList.Insert(s27);

   Scanner s28(CALL);
   s28.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s28.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s28.addState(ScannerStateEntry(2 ,START));
   s28.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s28.addState(ScannerStateEntry(4 ,FINAL));
   s28.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s28.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s28.addTransition(ScannerTransEntry(1 ,'L' ,3));
   s28.addTransition(ScannerTransEntry(1 ,'l' ,3));
   s28.addTransition(ScannerTransEntry(2 ,'C' ,0));
   s28.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s28.addTransition(ScannerTransEntry(3 ,'L' ,4));
   s28.addTransition(ScannerTransEntry(3 ,'l' ,4));
   _scannerList.Insert(s28);

   Scanner s29(CASE);
   s29.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s29.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s29.addState(ScannerStateEntry(2 ,START));
   s29.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s29.addState(ScannerStateEntry(4 ,FINAL));
   s29.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s29.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s29.addTransition(ScannerTransEntry(1 ,'S' ,3));
   s29.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s29.addTransition(ScannerTransEntry(2 ,'C' ,0));
   s29.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s29.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s29.addTransition(ScannerTransEntry(3 ,'e' ,4));
   _scannerList.Insert(s29);

   Scanner s30(CHECK);
   s30.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s30.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s30.addState(ScannerStateEntry(2 ,START));
   s30.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s30.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s30.addState(ScannerStateEntry(5 ,FINAL));
   s30.addTransition(ScannerTransEntry(0 ,'H' ,1));
   s30.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s30.addTransition(ScannerTransEntry(1 ,'E' ,3));
   s30.addTransition(ScannerTransEntry(1 ,'e' ,3));
   s30.addTransition(ScannerTransEntry(2 ,'C' ,0));
   s30.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s30.addTransition(ScannerTransEntry(3 ,'C' ,4));
   s30.addTransition(ScannerTransEntry(3 ,'c' ,4));
   s30.addTransition(ScannerTransEntry(4 ,'K' ,5));
   s30.addTransition(ScannerTransEntry(4 ,'k' ,5));
   _scannerList.Insert(s30);

   Scanner s31(CLOB);
   s31.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s31.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s31.addState(ScannerStateEntry(2 ,START));
   s31.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s31.addState(ScannerStateEntry(4 ,FINAL));
   s31.addTransition(ScannerTransEntry(0 ,'L' ,1));
   s31.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s31.addTransition(ScannerTransEntry(1 ,'O' ,3));
   s31.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s31.addTransition(ScannerTransEntry(2 ,'C' ,0));
   s31.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s31.addTransition(ScannerTransEntry(3 ,'B' ,4));
   s31.addTransition(ScannerTransEntry(3 ,'b' ,4));
   _scannerList.Insert(s31);

   Scanner s32(CLOBSIZE);
   s32.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s32.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s32.addState(ScannerStateEntry(2 ,START));
   s32.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s32.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s32.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s32.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s32.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s32.addState(ScannerStateEntry(8 ,FINAL));
   s32.addTransition(ScannerTransEntry(0 ,'L' ,1));
   s32.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s32.addTransition(ScannerTransEntry(1 ,'O' ,3));
   s32.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s32.addTransition(ScannerTransEntry(2 ,'C' ,0));
   s32.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s32.addTransition(ScannerTransEntry(3 ,'B' ,4));
   s32.addTransition(ScannerTransEntry(3 ,'b' ,4));
   s32.addTransition(ScannerTransEntry(4 ,'S' ,5));
   s32.addTransition(ScannerTransEntry(4 ,'s' ,5));
   s32.addTransition(ScannerTransEntry(5 ,'I' ,6));
   s32.addTransition(ScannerTransEntry(5 ,'i' ,6));
   s32.addTransition(ScannerTransEntry(6 ,'Z' ,7));
   s32.addTransition(ScannerTransEntry(6 ,'z' ,7));
   s32.addTransition(ScannerTransEntry(7 ,'E' ,8));
   s32.addTransition(ScannerTransEntry(7 ,'e' ,8));
   _scannerList.Insert(s32);

   Scanner s33(CLOBREF);
   s33.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s33.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s33.addState(ScannerStateEntry(2 ,START));
   s33.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s33.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s33.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s33.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s33.addState(ScannerStateEntry(7 ,FINAL));
   s33.addTransition(ScannerTransEntry(0 ,'L' ,1));
   s33.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s33.addTransition(ScannerTransEntry(1 ,'O' ,3));
   s33.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s33.addTransition(ScannerTransEntry(2 ,'C' ,0));
   s33.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s33.addTransition(ScannerTransEntry(3 ,'B' ,4));
   s33.addTransition(ScannerTransEntry(3 ,'b' ,4));
   s33.addTransition(ScannerTransEntry(4 ,'R' ,5));
   s33.addTransition(ScannerTransEntry(4 ,'r' ,5));
   s33.addTransition(ScannerTransEntry(5 ,'E' ,6));
   s33.addTransition(ScannerTransEntry(5 ,'e' ,6));
   s33.addTransition(ScannerTransEntry(6 ,'F' ,7));
   s33.addTransition(ScannerTransEntry(6 ,'f' ,7));
   _scannerList.Insert(s33);

   Scanner s34(CLOB2STR);
   s34.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s34.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s34.addState(ScannerStateEntry(2 ,START));
   s34.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s34.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s34.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s34.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s34.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s34.addState(ScannerStateEntry(8 ,FINAL));
   s34.addTransition(ScannerTransEntry(0 ,'L' ,1));
   s34.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s34.addTransition(ScannerTransEntry(1 ,'O' ,3));
   s34.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s34.addTransition(ScannerTransEntry(2 ,'C' ,0));
   s34.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s34.addTransition(ScannerTransEntry(3 ,'B' ,4));
   s34.addTransition(ScannerTransEntry(3 ,'b' ,4));
   s34.addTransition(ScannerTransEntry(4 ,'2' ,5));
   s34.addTransition(ScannerTransEntry(5 ,'S' ,6));
   s34.addTransition(ScannerTransEntry(5 ,'s' ,6));
   s34.addTransition(ScannerTransEntry(6 ,'T' ,7));
   s34.addTransition(ScannerTransEntry(6 ,'t' ,7));
   s34.addTransition(ScannerTransEntry(7 ,'R' ,8));
   s34.addTransition(ScannerTransEntry(7 ,'r' ,8));
   _scannerList.Insert(s34);

   Scanner s35(CLOSE);
   s35.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s35.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s35.addState(ScannerStateEntry(2 ,START));
   s35.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s35.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s35.addState(ScannerStateEntry(5 ,FINAL));
   s35.addTransition(ScannerTransEntry(0 ,'L' ,1));
   s35.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s35.addTransition(ScannerTransEntry(1 ,'O' ,3));
   s35.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s35.addTransition(ScannerTransEntry(2 ,'C' ,0));
   s35.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s35.addTransition(ScannerTransEntry(3 ,'S' ,4));
   s35.addTransition(ScannerTransEntry(3 ,'s' ,4));
   s35.addTransition(ScannerTransEntry(4 ,'E' ,5));
   s35.addTransition(ScannerTransEntry(4 ,'e' ,5));
   _scannerList.Insert(s35);

   Scanner s36(COMMIT);
   s36.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s36.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s36.addState(ScannerStateEntry(2 ,START));
   s36.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s36.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s36.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s36.addState(ScannerStateEntry(6 ,FINAL));
   s36.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s36.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s36.addTransition(ScannerTransEntry(1 ,'M' ,3));
   s36.addTransition(ScannerTransEntry(1 ,'m' ,3));
   s36.addTransition(ScannerTransEntry(2 ,'C' ,0));
   s36.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s36.addTransition(ScannerTransEntry(3 ,'M' ,4));
   s36.addTransition(ScannerTransEntry(3 ,'m' ,4));
   s36.addTransition(ScannerTransEntry(4 ,'I' ,5));
   s36.addTransition(ScannerTransEntry(4 ,'i' ,5));
   s36.addTransition(ScannerTransEntry(5 ,'T' ,6));
   s36.addTransition(ScannerTransEntry(5 ,'t' ,6));
   _scannerList.Insert(s36);

   Scanner s37(COLUMN);
   s37.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s37.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s37.addState(ScannerStateEntry(2 ,START));
   s37.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s37.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s37.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s37.addState(ScannerStateEntry(6 ,FINAL));
   s37.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s37.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s37.addTransition(ScannerTransEntry(1 ,'L' ,3));
   s37.addTransition(ScannerTransEntry(1 ,'l' ,3));
   s37.addTransition(ScannerTransEntry(2 ,'C' ,0));
   s37.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s37.addTransition(ScannerTransEntry(3 ,'U' ,4));
   s37.addTransition(ScannerTransEntry(3 ,'u' ,4));
   s37.addTransition(ScannerTransEntry(4 ,'M' ,5));
   s37.addTransition(ScannerTransEntry(4 ,'m' ,5));
   s37.addTransition(ScannerTransEntry(5 ,'N' ,6));
   s37.addTransition(ScannerTransEntry(5 ,'n' ,6));
   _scannerList.Insert(s37);

   Scanner s38(CONSTRAINT);
   s38.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s38.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s38.addState(ScannerStateEntry(2 ,START));
   s38.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s38.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s38.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s38.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s38.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s38.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s38.addState(ScannerStateEntry(9 ,INTERMEDIATE));
   s38.addState(ScannerStateEntry(10 ,FINAL));
   s38.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s38.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s38.addTransition(ScannerTransEntry(1 ,'N' ,3));
   s38.addTransition(ScannerTransEntry(1 ,'n' ,3));
   s38.addTransition(ScannerTransEntry(2 ,'C' ,0));
   s38.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s38.addTransition(ScannerTransEntry(3 ,'S' ,4));
   s38.addTransition(ScannerTransEntry(3 ,'s' ,4));
   s38.addTransition(ScannerTransEntry(4 ,'T' ,5));
   s38.addTransition(ScannerTransEntry(4 ,'t' ,5));
   s38.addTransition(ScannerTransEntry(5 ,'R' ,6));
   s38.addTransition(ScannerTransEntry(5 ,'r' ,6));
   s38.addTransition(ScannerTransEntry(6 ,'A' ,7));
   s38.addTransition(ScannerTransEntry(6 ,'a' ,7));
   s38.addTransition(ScannerTransEntry(7 ,'I' ,8));
   s38.addTransition(ScannerTransEntry(7 ,'i' ,8));
   s38.addTransition(ScannerTransEntry(8 ,'N' ,9));
   s38.addTransition(ScannerTransEntry(8 ,'n' ,9));
   s38.addTransition(ScannerTransEntry(9 ,'T' ,10));
   s38.addTransition(ScannerTransEntry(9 ,'t' ,10));
   _scannerList.Insert(s38);

   Scanner s39(COUNT);
   s39.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s39.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s39.addState(ScannerStateEntry(2 ,START));
   s39.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s39.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s39.addState(ScannerStateEntry(5 ,FINAL));
   s39.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s39.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s39.addTransition(ScannerTransEntry(1 ,'U' ,3));
   s39.addTransition(ScannerTransEntry(1 ,'u' ,3));
   s39.addTransition(ScannerTransEntry(2 ,'C' ,0));
   s39.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s39.addTransition(ScannerTransEntry(3 ,'N' ,4));
   s39.addTransition(ScannerTransEntry(3 ,'n' ,4));
   s39.addTransition(ScannerTransEntry(4 ,'T' ,5));
   s39.addTransition(ScannerTransEntry(4 ,'t' ,5));
   _scannerList.Insert(s39);

   Scanner s40(COUNTER);
   s40.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s40.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s40.addState(ScannerStateEntry(2 ,START));
   s40.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s40.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s40.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s40.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s40.addState(ScannerStateEntry(7 ,FINAL));
   s40.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s40.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s40.addTransition(ScannerTransEntry(1 ,'U' ,3));
   s40.addTransition(ScannerTransEntry(1 ,'u' ,3));
   s40.addTransition(ScannerTransEntry(2 ,'C' ,0));
   s40.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s40.addTransition(ScannerTransEntry(3 ,'N' ,4));
   s40.addTransition(ScannerTransEntry(3 ,'n' ,4));
   s40.addTransition(ScannerTransEntry(4 ,'T' ,5));
   s40.addTransition(ScannerTransEntry(4 ,'t' ,5));
   s40.addTransition(ScannerTransEntry(5 ,'E' ,6));
   s40.addTransition(ScannerTransEntry(5 ,'e' ,6));
   s40.addTransition(ScannerTransEntry(6 ,'R' ,7));
   s40.addTransition(ScannerTransEntry(6 ,'r' ,7));
   _scannerList.Insert(s40);

   Scanner s41(CREATE);
   s41.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s41.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s41.addState(ScannerStateEntry(2 ,START));
   s41.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s41.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s41.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s41.addState(ScannerStateEntry(6 ,FINAL));
   s41.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s41.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s41.addTransition(ScannerTransEntry(1 ,'E' ,3));
   s41.addTransition(ScannerTransEntry(1 ,'e' ,3));
   s41.addTransition(ScannerTransEntry(2 ,'C' ,0));
   s41.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s41.addTransition(ScannerTransEntry(3 ,'A' ,4));
   s41.addTransition(ScannerTransEntry(3 ,'a' ,4));
   s41.addTransition(ScannerTransEntry(4 ,'T' ,5));
   s41.addTransition(ScannerTransEntry(4 ,'t' ,5));
   s41.addTransition(ScannerTransEntry(5 ,'E' ,6));
   s41.addTransition(ScannerTransEntry(5 ,'e' ,6));
   _scannerList.Insert(s41);

   Scanner s42(CURSOR);
   s42.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s42.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s42.addState(ScannerStateEntry(2 ,START));
   s42.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s42.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s42.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s42.addState(ScannerStateEntry(6 ,FINAL));
   s42.addTransition(ScannerTransEntry(0 ,'U' ,1));
   s42.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s42.addTransition(ScannerTransEntry(1 ,'R' ,3));
   s42.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s42.addTransition(ScannerTransEntry(2 ,'C' ,0));
   s42.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s42.addTransition(ScannerTransEntry(3 ,'S' ,4));
   s42.addTransition(ScannerTransEntry(3 ,'s' ,4));
   s42.addTransition(ScannerTransEntry(4 ,'O' ,5));
   s42.addTransition(ScannerTransEntry(4 ,'o' ,5));
   s42.addTransition(ScannerTransEntry(5 ,'R' ,6));
   s42.addTransition(ScannerTransEntry(5 ,'r' ,6));
   _scannerList.Insert(s42);

   Scanner s43(DATE);
   s43.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s43.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s43.addState(ScannerStateEntry(2 ,START));
   s43.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s43.addState(ScannerStateEntry(4 ,FINAL));
   s43.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s43.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s43.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s43.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s43.addTransition(ScannerTransEntry(2 ,'D' ,0));
   s43.addTransition(ScannerTransEntry(2 ,'d' ,0));
   s43.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s43.addTransition(ScannerTransEntry(3 ,'e' ,4));
   _scannerList.Insert(s43);

   Scanner s44(DATE2STR);
   s44.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s44.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s44.addState(ScannerStateEntry(2 ,START));
   s44.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s44.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s44.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s44.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s44.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s44.addState(ScannerStateEntry(8 ,FINAL));
   s44.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s44.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s44.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s44.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s44.addTransition(ScannerTransEntry(2 ,'D' ,0));
   s44.addTransition(ScannerTransEntry(2 ,'d' ,0));
   s44.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s44.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s44.addTransition(ScannerTransEntry(4 ,'2' ,5));
   s44.addTransition(ScannerTransEntry(5 ,'S' ,6));
   s44.addTransition(ScannerTransEntry(5 ,'s' ,6));
   s44.addTransition(ScannerTransEntry(6 ,'T' ,7));
   s44.addTransition(ScannerTransEntry(6 ,'t' ,7));
   s44.addTransition(ScannerTransEntry(7 ,'R' ,8));
   s44.addTransition(ScannerTransEntry(7 ,'r' ,8));
   _scannerList.Insert(s44);

   Scanner s45(DATE2LONG);
   s45.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s45.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s45.addState(ScannerStateEntry(2 ,START));
   s45.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s45.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s45.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s45.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s45.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s45.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s45.addState(ScannerStateEntry(9 ,FINAL));
   s45.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s45.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s45.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s45.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s45.addTransition(ScannerTransEntry(2 ,'D' ,0));
   s45.addTransition(ScannerTransEntry(2 ,'d' ,0));
   s45.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s45.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s45.addTransition(ScannerTransEntry(4 ,'2' ,5));
   s45.addTransition(ScannerTransEntry(5 ,'L' ,6));
   s45.addTransition(ScannerTransEntry(5 ,'l' ,6));
   s45.addTransition(ScannerTransEntry(6 ,'O' ,7));
   s45.addTransition(ScannerTransEntry(6 ,'o' ,7));
   s45.addTransition(ScannerTransEntry(7 ,'N' ,8));
   s45.addTransition(ScannerTransEntry(7 ,'n' ,8));
   s45.addTransition(ScannerTransEntry(8 ,'G' ,9));
   s45.addTransition(ScannerTransEntry(8 ,'g' ,9));
   _scannerList.Insert(s45);

   Scanner s46(DATETIME);
   s46.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s46.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s46.addState(ScannerStateEntry(2 ,START));
   s46.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s46.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s46.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s46.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s46.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s46.addState(ScannerStateEntry(8 ,FINAL));
   s46.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s46.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s46.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s46.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s46.addTransition(ScannerTransEntry(2 ,'D' ,0));
   s46.addTransition(ScannerTransEntry(2 ,'d' ,0));
   s46.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s46.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s46.addTransition(ScannerTransEntry(4 ,'T' ,5));
   s46.addTransition(ScannerTransEntry(4 ,'t' ,5));
   s46.addTransition(ScannerTransEntry(5 ,'I' ,6));
   s46.addTransition(ScannerTransEntry(5 ,'i' ,6));
   s46.addTransition(ScannerTransEntry(6 ,'M' ,7));
   s46.addTransition(ScannerTransEntry(6 ,'m' ,7));
   s46.addTransition(ScannerTransEntry(7 ,'E' ,8));
   s46.addTransition(ScannerTransEntry(7 ,'e' ,8));
   _scannerList.Insert(s46);

   Scanner s47(DECIMAL);
   s47.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s47.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s47.addState(ScannerStateEntry(2 ,START));
   s47.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s47.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s47.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s47.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s47.addState(ScannerStateEntry(7 ,FINAL));
   s47.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s47.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s47.addTransition(ScannerTransEntry(1 ,'C' ,3));
   s47.addTransition(ScannerTransEntry(1 ,'c' ,3));
   s47.addTransition(ScannerTransEntry(2 ,'D' ,0));
   s47.addTransition(ScannerTransEntry(2 ,'d' ,0));
   s47.addTransition(ScannerTransEntry(3 ,'I' ,4));
   s47.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s47.addTransition(ScannerTransEntry(4 ,'M' ,5));
   s47.addTransition(ScannerTransEntry(4 ,'m' ,5));
   s47.addTransition(ScannerTransEntry(5 ,'A' ,6));
   s47.addTransition(ScannerTransEntry(5 ,'a' ,6));
   s47.addTransition(ScannerTransEntry(6 ,'L' ,7));
   s47.addTransition(ScannerTransEntry(6 ,'l' ,7));
   _scannerList.Insert(s47);

   Scanner s48(DEFAULT);
   s48.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s48.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s48.addState(ScannerStateEntry(2 ,START));
   s48.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s48.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s48.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s48.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s48.addState(ScannerStateEntry(7 ,FINAL));
   s48.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s48.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s48.addTransition(ScannerTransEntry(1 ,'F' ,3));
   s48.addTransition(ScannerTransEntry(1 ,'f' ,3));
   s48.addTransition(ScannerTransEntry(2 ,'D' ,0));
   s48.addTransition(ScannerTransEntry(2 ,'d' ,0));
   s48.addTransition(ScannerTransEntry(3 ,'A' ,4));
   s48.addTransition(ScannerTransEntry(3 ,'a' ,4));
   s48.addTransition(ScannerTransEntry(4 ,'U' ,5));
   s48.addTransition(ScannerTransEntry(4 ,'u' ,5));
   s48.addTransition(ScannerTransEntry(5 ,'L' ,6));
   s48.addTransition(ScannerTransEntry(5 ,'l' ,6));
   s48.addTransition(ScannerTransEntry(6 ,'T' ,7));
   s48.addTransition(ScannerTransEntry(6 ,'t' ,7));
   _scannerList.Insert(s48);

   Scanner s49(DELETETOK);
   s49.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s49.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s49.addState(ScannerStateEntry(2 ,START));
   s49.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s49.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s49.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s49.addState(ScannerStateEntry(6 ,FINAL));
   s49.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s49.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s49.addTransition(ScannerTransEntry(1 ,'L' ,3));
   s49.addTransition(ScannerTransEntry(1 ,'l' ,3));
   s49.addTransition(ScannerTransEntry(2 ,'D' ,0));
   s49.addTransition(ScannerTransEntry(2 ,'d' ,0));
   s49.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s49.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s49.addTransition(ScannerTransEntry(4 ,'T' ,5));
   s49.addTransition(ScannerTransEntry(4 ,'t' ,5));
   s49.addTransition(ScannerTransEntry(5 ,'E' ,6));
   s49.addTransition(ScannerTransEntry(5 ,'e' ,6));
   _scannerList.Insert(s49);

   Scanner s50(DESC);
   s50.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s50.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s50.addState(ScannerStateEntry(2 ,START));
   s50.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s50.addState(ScannerStateEntry(4 ,FINAL));
   s50.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s50.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s50.addTransition(ScannerTransEntry(1 ,'S' ,3));
   s50.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s50.addTransition(ScannerTransEntry(2 ,'D' ,0));
   s50.addTransition(ScannerTransEntry(2 ,'d' ,0));
   s50.addTransition(ScannerTransEntry(3 ,'C' ,4));
   s50.addTransition(ScannerTransEntry(3 ,'c' ,4));
   _scannerList.Insert(s50);

   Scanner s51(DISTINCT);
   s51.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s51.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s51.addState(ScannerStateEntry(2 ,START));
   s51.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s51.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s51.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s51.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s51.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s51.addState(ScannerStateEntry(8 ,FINAL));
   s51.addTransition(ScannerTransEntry(0 ,'I' ,1));
   s51.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s51.addTransition(ScannerTransEntry(1 ,'S' ,3));
   s51.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s51.addTransition(ScannerTransEntry(2 ,'D' ,0));
   s51.addTransition(ScannerTransEntry(2 ,'d' ,0));
   s51.addTransition(ScannerTransEntry(3 ,'T' ,4));
   s51.addTransition(ScannerTransEntry(3 ,'t' ,4));
   s51.addTransition(ScannerTransEntry(4 ,'I' ,5));
   s51.addTransition(ScannerTransEntry(4 ,'i' ,5));
   s51.addTransition(ScannerTransEntry(5 ,'N' ,6));
   s51.addTransition(ScannerTransEntry(5 ,'n' ,6));
   s51.addTransition(ScannerTransEntry(6 ,'C' ,7));
   s51.addTransition(ScannerTransEntry(6 ,'c' ,7));
   s51.addTransition(ScannerTransEntry(7 ,'T' ,8));
   s51.addTransition(ScannerTransEntry(7 ,'t' ,8));
   _scannerList.Insert(s51);

   Scanner s52(DIV);
   s52.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s52.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s52.addState(ScannerStateEntry(2 ,START));
   s52.addState(ScannerStateEntry(3 ,FINAL));
   s52.addTransition(ScannerTransEntry(0 ,'I' ,1));
   s52.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s52.addTransition(ScannerTransEntry(1 ,'V' ,3));
   s52.addTransition(ScannerTransEntry(1 ,'v' ,3));
   s52.addTransition(ScannerTransEntry(2 ,'D' ,0));
   s52.addTransition(ScannerTransEntry(2 ,'d' ,0));
   _scannerList.Insert(s52);

   Scanner s53(DOUBLE);
   s53.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s53.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s53.addState(ScannerStateEntry(2 ,START));
   s53.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s53.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s53.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s53.addState(ScannerStateEntry(6 ,FINAL));
   s53.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s53.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s53.addTransition(ScannerTransEntry(1 ,'U' ,3));
   s53.addTransition(ScannerTransEntry(1 ,'u' ,3));
   s53.addTransition(ScannerTransEntry(2 ,'D' ,0));
   s53.addTransition(ScannerTransEntry(2 ,'d' ,0));
   s53.addTransition(ScannerTransEntry(3 ,'B' ,4));
   s53.addTransition(ScannerTransEntry(3 ,'b' ,4));
   s53.addTransition(ScannerTransEntry(4 ,'L' ,5));
   s53.addTransition(ScannerTransEntry(4 ,'l' ,5));
   s53.addTransition(ScannerTransEntry(5 ,'E' ,6));
   s53.addTransition(ScannerTransEntry(5 ,'e' ,6));
   _scannerList.Insert(s53);

   Scanner s54(DROP);
   s54.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s54.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s54.addState(ScannerStateEntry(2 ,START));
   s54.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s54.addState(ScannerStateEntry(4 ,FINAL));
   s54.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s54.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s54.addTransition(ScannerTransEntry(1 ,'O' ,3));
   s54.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s54.addTransition(ScannerTransEntry(2 ,'D' ,0));
   s54.addTransition(ScannerTransEntry(2 ,'d' ,0));
   s54.addTransition(ScannerTransEntry(3 ,'P' ,4));
   s54.addTransition(ScannerTransEntry(3 ,'p' ,4));
   _scannerList.Insert(s54);

   Scanner s55(ELSE);
   s55.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s55.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s55.addState(ScannerStateEntry(2 ,START));
   s55.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s55.addState(ScannerStateEntry(4 ,FINAL));
   s55.addTransition(ScannerTransEntry(0 ,'L' ,1));
   s55.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s55.addTransition(ScannerTransEntry(1 ,'S' ,3));
   s55.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s55.addTransition(ScannerTransEntry(2 ,'E' ,0));
   s55.addTransition(ScannerTransEntry(2 ,'e' ,0));
   s55.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s55.addTransition(ScannerTransEntry(3 ,'e' ,4));
   _scannerList.Insert(s55);

   Scanner s56(ELSIF);
   s56.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s56.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s56.addState(ScannerStateEntry(2 ,START));
   s56.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s56.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s56.addState(ScannerStateEntry(5 ,FINAL));
   s56.addTransition(ScannerTransEntry(0 ,'L' ,1));
   s56.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s56.addTransition(ScannerTransEntry(1 ,'S' ,3));
   s56.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s56.addTransition(ScannerTransEntry(2 ,'E' ,0));
   s56.addTransition(ScannerTransEntry(2 ,'e' ,0));
   s56.addTransition(ScannerTransEntry(3 ,'I' ,4));
   s56.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s56.addTransition(ScannerTransEntry(4 ,'F' ,5));
   s56.addTransition(ScannerTransEntry(4 ,'f' ,5));
   _scannerList.Insert(s56);

   Scanner s57(END_TOKEN);
   s57.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s57.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s57.addState(ScannerStateEntry(2 ,START));
   s57.addState(ScannerStateEntry(3 ,FINAL));
   s57.addTransition(ScannerTransEntry(0 ,'N' ,1));
   s57.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s57.addTransition(ScannerTransEntry(1 ,'D' ,3));
   s57.addTransition(ScannerTransEntry(1 ,'d' ,3));
   s57.addTransition(ScannerTransEntry(2 ,'E' ,0));
   s57.addTransition(ScannerTransEntry(2 ,'e' ,0));
   _scannerList.Insert(s57);

   Scanner s58(EXCEPTION);
   s58.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s58.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s58.addState(ScannerStateEntry(2 ,START));
   s58.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s58.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s58.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s58.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s58.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s58.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s58.addState(ScannerStateEntry(9 ,FINAL));
   s58.addTransition(ScannerTransEntry(0 ,'X' ,1));
   s58.addTransition(ScannerTransEntry(0 ,'x' ,1));
   s58.addTransition(ScannerTransEntry(1 ,'C' ,3));
   s58.addTransition(ScannerTransEntry(1 ,'c' ,3));
   s58.addTransition(ScannerTransEntry(2 ,'E' ,0));
   s58.addTransition(ScannerTransEntry(2 ,'e' ,0));
   s58.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s58.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s58.addTransition(ScannerTransEntry(4 ,'P' ,5));
   s58.addTransition(ScannerTransEntry(4 ,'p' ,5));
   s58.addTransition(ScannerTransEntry(5 ,'T' ,6));
   s58.addTransition(ScannerTransEntry(5 ,'t' ,6));
   s58.addTransition(ScannerTransEntry(6 ,'I' ,7));
   s58.addTransition(ScannerTransEntry(6 ,'i' ,7));
   s58.addTransition(ScannerTransEntry(7 ,'O' ,8));
   s58.addTransition(ScannerTransEntry(7 ,'o' ,8));
   s58.addTransition(ScannerTransEntry(8 ,'N' ,9));
   s58.addTransition(ScannerTransEntry(8 ,'n' ,9));
   _scannerList.Insert(s58);

   Scanner s59(EXISTS);
   s59.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s59.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s59.addState(ScannerStateEntry(2 ,START));
   s59.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s59.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s59.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s59.addState(ScannerStateEntry(6 ,FINAL));
   s59.addTransition(ScannerTransEntry(0 ,'X' ,1));
   s59.addTransition(ScannerTransEntry(0 ,'x' ,1));
   s59.addTransition(ScannerTransEntry(1 ,'I' ,3));
   s59.addTransition(ScannerTransEntry(1 ,'i' ,3));
   s59.addTransition(ScannerTransEntry(2 ,'E' ,0));
   s59.addTransition(ScannerTransEntry(2 ,'e' ,0));
   s59.addTransition(ScannerTransEntry(3 ,'S' ,4));
   s59.addTransition(ScannerTransEntry(3 ,'s' ,4));
   s59.addTransition(ScannerTransEntry(4 ,'T' ,5));
   s59.addTransition(ScannerTransEntry(4 ,'t' ,5));
   s59.addTransition(ScannerTransEntry(5 ,'S' ,6));
   s59.addTransition(ScannerTransEntry(5 ,'s' ,6));
   _scannerList.Insert(s59);

   Scanner s60(FALSEVAL);
   s60.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s60.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s60.addState(ScannerStateEntry(2 ,START));
   s60.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s60.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s60.addState(ScannerStateEntry(5 ,FINAL));
   s60.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s60.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s60.addTransition(ScannerTransEntry(1 ,'L' ,3));
   s60.addTransition(ScannerTransEntry(1 ,'l' ,3));
   s60.addTransition(ScannerTransEntry(2 ,'F' ,0));
   s60.addTransition(ScannerTransEntry(2 ,'f' ,0));
   s60.addTransition(ScannerTransEntry(3 ,'S' ,4));
   s60.addTransition(ScannerTransEntry(3 ,'s' ,4));
   s60.addTransition(ScannerTransEntry(4 ,'E' ,5));
   s60.addTransition(ScannerTransEntry(4 ,'e' ,5));
   _scannerList.Insert(s60);

   Scanner s61(FETCH);
   s61.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s61.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s61.addState(ScannerStateEntry(2 ,START));
   s61.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s61.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s61.addState(ScannerStateEntry(5 ,FINAL));
   s61.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s61.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s61.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s61.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s61.addTransition(ScannerTransEntry(2 ,'F' ,0));
   s61.addTransition(ScannerTransEntry(2 ,'f' ,0));
   s61.addTransition(ScannerTransEntry(3 ,'C' ,4));
   s61.addTransition(ScannerTransEntry(3 ,'c' ,4));
   s61.addTransition(ScannerTransEntry(4 ,'H' ,5));
   s61.addTransition(ScannerTransEntry(4 ,'h' ,5));
   _scannerList.Insert(s61);

   Scanner s62(FIRST);
   s62.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s62.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s62.addState(ScannerStateEntry(2 ,START));
   s62.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s62.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s62.addState(ScannerStateEntry(5 ,FINAL));
   s62.addTransition(ScannerTransEntry(0 ,'I' ,1));
   s62.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s62.addTransition(ScannerTransEntry(1 ,'R' ,3));
   s62.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s62.addTransition(ScannerTransEntry(2 ,'F' ,0));
   s62.addTransition(ScannerTransEntry(2 ,'f' ,0));
   s62.addTransition(ScannerTransEntry(3 ,'S' ,4));
   s62.addTransition(ScannerTransEntry(3 ,'s' ,4));
   s62.addTransition(ScannerTransEntry(4 ,'T' ,5));
   s62.addTransition(ScannerTransEntry(4 ,'t' ,5));
   _scannerList.Insert(s62);

   Scanner s63(FIXED);
   s63.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s63.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s63.addState(ScannerStateEntry(2 ,START));
   s63.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s63.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s63.addState(ScannerStateEntry(5 ,FINAL));
   s63.addTransition(ScannerTransEntry(0 ,'I' ,1));
   s63.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s63.addTransition(ScannerTransEntry(1 ,'X' ,3));
   s63.addTransition(ScannerTransEntry(1 ,'x' ,3));
   s63.addTransition(ScannerTransEntry(2 ,'F' ,0));
   s63.addTransition(ScannerTransEntry(2 ,'f' ,0));
   s63.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s63.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s63.addTransition(ScannerTransEntry(4 ,'D' ,5));
   s63.addTransition(ScannerTransEntry(4 ,'d' ,5));
   _scannerList.Insert(s63);

   Scanner s64(FLOAT);
   s64.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s64.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s64.addState(ScannerStateEntry(2 ,START));
   s64.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s64.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s64.addState(ScannerStateEntry(5 ,FINAL));
   s64.addTransition(ScannerTransEntry(0 ,'L' ,1));
   s64.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s64.addTransition(ScannerTransEntry(1 ,'O' ,3));
   s64.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s64.addTransition(ScannerTransEntry(2 ,'F' ,0));
   s64.addTransition(ScannerTransEntry(2 ,'f' ,0));
   s64.addTransition(ScannerTransEntry(3 ,'A' ,4));
   s64.addTransition(ScannerTransEntry(3 ,'a' ,4));
   s64.addTransition(ScannerTransEntry(4 ,'T' ,5));
   s64.addTransition(ScannerTransEntry(4 ,'t' ,5));
   _scannerList.Insert(s64);

   Scanner s65(FOR);
   s65.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s65.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s65.addState(ScannerStateEntry(2 ,START));
   s65.addState(ScannerStateEntry(3 ,FINAL));
   s65.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s65.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s65.addTransition(ScannerTransEntry(1 ,'R' ,3));
   s65.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s65.addTransition(ScannerTransEntry(2 ,'F' ,0));
   s65.addTransition(ScannerTransEntry(2 ,'f' ,0));
   _scannerList.Insert(s65);

   Scanner s66(FOREIGN);
   s66.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s66.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s66.addState(ScannerStateEntry(2 ,START));
   s66.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s66.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s66.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s66.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s66.addState(ScannerStateEntry(7 ,FINAL));
   s66.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s66.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s66.addTransition(ScannerTransEntry(1 ,'R' ,3));
   s66.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s66.addTransition(ScannerTransEntry(2 ,'F' ,0));
   s66.addTransition(ScannerTransEntry(2 ,'f' ,0));
   s66.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s66.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s66.addTransition(ScannerTransEntry(4 ,'I' ,5));
   s66.addTransition(ScannerTransEntry(4 ,'i' ,5));
   s66.addTransition(ScannerTransEntry(5 ,'G' ,6));
   s66.addTransition(ScannerTransEntry(5 ,'g' ,6));
   s66.addTransition(ScannerTransEntry(6 ,'N' ,7));
   s66.addTransition(ScannerTransEntry(6 ,'n' ,7));
   _scannerList.Insert(s66);

   Scanner s67(FROM);
   s67.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s67.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s67.addState(ScannerStateEntry(2 ,START));
   s67.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s67.addState(ScannerStateEntry(4 ,FINAL));
   s67.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s67.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s67.addTransition(ScannerTransEntry(1 ,'O' ,3));
   s67.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s67.addTransition(ScannerTransEntry(2 ,'F' ,0));
   s67.addTransition(ScannerTransEntry(2 ,'f' ,0));
   s67.addTransition(ScannerTransEntry(3 ,'M' ,4));
   s67.addTransition(ScannerTransEntry(3 ,'m' ,4));
   _scannerList.Insert(s67);

   Scanner s68(GETPOS);
   s68.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s68.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s68.addState(ScannerStateEntry(2 ,START));
   s68.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s68.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s68.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s68.addState(ScannerStateEntry(6 ,FINAL));
   s68.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s68.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s68.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s68.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s68.addTransition(ScannerTransEntry(2 ,'G' ,0));
   s68.addTransition(ScannerTransEntry(2 ,'g' ,0));
   s68.addTransition(ScannerTransEntry(3 ,'P' ,4));
   s68.addTransition(ScannerTransEntry(3 ,'p' ,4));
   s68.addTransition(ScannerTransEntry(4 ,'O' ,5));
   s68.addTransition(ScannerTransEntry(4 ,'o' ,5));
   s68.addTransition(ScannerTransEntry(5 ,'S' ,6));
   s68.addTransition(ScannerTransEntry(5 ,'s' ,6));
   _scannerList.Insert(s68);

   Scanner s69(GROUP);
   s69.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s69.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s69.addState(ScannerStateEntry(2 ,START));
   s69.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s69.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s69.addState(ScannerStateEntry(5 ,FINAL));
   s69.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s69.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s69.addTransition(ScannerTransEntry(1 ,'O' ,3));
   s69.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s69.addTransition(ScannerTransEntry(2 ,'G' ,0));
   s69.addTransition(ScannerTransEntry(2 ,'g' ,0));
   s69.addTransition(ScannerTransEntry(3 ,'U' ,4));
   s69.addTransition(ScannerTransEntry(3 ,'u' ,4));
   s69.addTransition(ScannerTransEntry(4 ,'P' ,5));
   s69.addTransition(ScannerTransEntry(4 ,'p' ,5));
   _scannerList.Insert(s69);

   Scanner s70(HAVING);
   s70.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s70.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s70.addState(ScannerStateEntry(2 ,START));
   s70.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s70.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s70.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s70.addState(ScannerStateEntry(6 ,FINAL));
   s70.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s70.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s70.addTransition(ScannerTransEntry(1 ,'V' ,3));
   s70.addTransition(ScannerTransEntry(1 ,'v' ,3));
   s70.addTransition(ScannerTransEntry(2 ,'H' ,0));
   s70.addTransition(ScannerTransEntry(2 ,'h' ,0));
   s70.addTransition(ScannerTransEntry(3 ,'I' ,4));
   s70.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s70.addTransition(ScannerTransEntry(4 ,'N' ,5));
   s70.addTransition(ScannerTransEntry(4 ,'n' ,5));
   s70.addTransition(ScannerTransEntry(5 ,'G' ,6));
   s70.addTransition(ScannerTransEntry(5 ,'g' ,6));
   _scannerList.Insert(s70);

   Scanner s71(IDENTIFIED);
   s71.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s71.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s71.addState(ScannerStateEntry(2 ,START));
   s71.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s71.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s71.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s71.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s71.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s71.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s71.addState(ScannerStateEntry(9 ,INTERMEDIATE));
   s71.addState(ScannerStateEntry(10 ,FINAL));
   s71.addTransition(ScannerTransEntry(0 ,'D' ,1));
   s71.addTransition(ScannerTransEntry(0 ,'d' ,1));
   s71.addTransition(ScannerTransEntry(1 ,'E' ,3));
   s71.addTransition(ScannerTransEntry(1 ,'e' ,3));
   s71.addTransition(ScannerTransEntry(2 ,'I' ,0));
   s71.addTransition(ScannerTransEntry(2 ,'i' ,0));
   s71.addTransition(ScannerTransEntry(3 ,'N' ,4));
   s71.addTransition(ScannerTransEntry(3 ,'n' ,4));
   s71.addTransition(ScannerTransEntry(4 ,'T' ,5));
   s71.addTransition(ScannerTransEntry(4 ,'t' ,5));
   s71.addTransition(ScannerTransEntry(5 ,'I' ,6));
   s71.addTransition(ScannerTransEntry(5 ,'i' ,6));
   s71.addTransition(ScannerTransEntry(6 ,'F' ,7));
   s71.addTransition(ScannerTransEntry(6 ,'f' ,7));
   s71.addTransition(ScannerTransEntry(7 ,'I' ,8));
   s71.addTransition(ScannerTransEntry(7 ,'i' ,8));
   s71.addTransition(ScannerTransEntry(8 ,'E' ,9));
   s71.addTransition(ScannerTransEntry(8 ,'e' ,9));
   s71.addTransition(ScannerTransEntry(9 ,'D' ,10));
   s71.addTransition(ScannerTransEntry(9 ,'d' ,10));
   _scannerList.Insert(s71);

   Scanner s72(IF);
   s72.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s72.addState(ScannerStateEntry(1 ,FINAL));
   s72.addState(ScannerStateEntry(2 ,START));
   s72.addTransition(ScannerTransEntry(0 ,'F' ,1));
   s72.addTransition(ScannerTransEntry(0 ,'f' ,1));
   s72.addTransition(ScannerTransEntry(2 ,'I' ,0));
   s72.addTransition(ScannerTransEntry(2 ,'i' ,0));
   _scannerList.Insert(s72);

   Scanner s73(INDEX);
   s73.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s73.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s73.addState(ScannerStateEntry(2 ,START));
   s73.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s73.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s73.addState(ScannerStateEntry(5 ,FINAL));
   s73.addTransition(ScannerTransEntry(0 ,'N' ,1));
   s73.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s73.addTransition(ScannerTransEntry(1 ,'D' ,3));
   s73.addTransition(ScannerTransEntry(1 ,'d' ,3));
   s73.addTransition(ScannerTransEntry(2 ,'I' ,0));
   s73.addTransition(ScannerTransEntry(2 ,'i' ,0));
   s73.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s73.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s73.addTransition(ScannerTransEntry(4 ,'X' ,5));
   s73.addTransition(ScannerTransEntry(4 ,'x' ,5));
   _scannerList.Insert(s73);

   Scanner s74(INTOK);
   s74.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s74.addState(ScannerStateEntry(1 ,FINAL));
   s74.addState(ScannerStateEntry(2 ,START));
   s74.addTransition(ScannerTransEntry(0 ,'N' ,1));
   s74.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s74.addTransition(ScannerTransEntry(2 ,'I' ,0));
   s74.addTransition(ScannerTransEntry(2 ,'i' ,0));
   _scannerList.Insert(s74);

   Scanner s75(INNER);
   s75.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s75.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s75.addState(ScannerStateEntry(2 ,START));
   s75.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s75.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s75.addState(ScannerStateEntry(5 ,FINAL));
   s75.addTransition(ScannerTransEntry(0 ,'N' ,1));
   s75.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s75.addTransition(ScannerTransEntry(1 ,'N' ,3));
   s75.addTransition(ScannerTransEntry(1 ,'n' ,3));
   s75.addTransition(ScannerTransEntry(2 ,'I' ,0));
   s75.addTransition(ScannerTransEntry(2 ,'i' ,0));
   s75.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s75.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s75.addTransition(ScannerTransEntry(4 ,'R' ,5));
   s75.addTransition(ScannerTransEntry(4 ,'r' ,5));
   _scannerList.Insert(s75);

   Scanner s76(INT);
   s76.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s76.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s76.addState(ScannerStateEntry(2 ,START));
   s76.addState(ScannerStateEntry(3 ,FINAL));
   s76.addTransition(ScannerTransEntry(0 ,'N' ,1));
   s76.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s76.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s76.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s76.addTransition(ScannerTransEntry(2 ,'I' ,0));
   s76.addTransition(ScannerTransEntry(2 ,'i' ,0));
   _scannerList.Insert(s76);

   Scanner s77(INTO);
   s77.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s77.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s77.addState(ScannerStateEntry(2 ,START));
   s77.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s77.addState(ScannerStateEntry(4 ,FINAL));
   s77.addTransition(ScannerTransEntry(0 ,'N' ,1));
   s77.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s77.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s77.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s77.addTransition(ScannerTransEntry(2 ,'I' ,0));
   s77.addTransition(ScannerTransEntry(2 ,'i' ,0));
   s77.addTransition(ScannerTransEntry(3 ,'O' ,4));
   s77.addTransition(ScannerTransEntry(3 ,'o' ,4));
   _scannerList.Insert(s77);

   Scanner s78(LONG2DATE);
   s78.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s78.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s78.addState(ScannerStateEntry(2 ,START));
   s78.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s78.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s78.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s78.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s78.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s78.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s78.addState(ScannerStateEntry(9 ,FINAL));
   s78.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s78.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s78.addTransition(ScannerTransEntry(1 ,'N' ,3));
   s78.addTransition(ScannerTransEntry(1 ,'n' ,3));
   s78.addTransition(ScannerTransEntry(2 ,'L' ,0));
   s78.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s78.addTransition(ScannerTransEntry(3 ,'G' ,4));
   s78.addTransition(ScannerTransEntry(3 ,'g' ,4));
   s78.addTransition(ScannerTransEntry(4 ,'2' ,5));
   s78.addTransition(ScannerTransEntry(5 ,'D' ,6));
   s78.addTransition(ScannerTransEntry(5 ,'d' ,6));
   s78.addTransition(ScannerTransEntry(6 ,'A' ,7));
   s78.addTransition(ScannerTransEntry(6 ,'a' ,7));
   s78.addTransition(ScannerTransEntry(7 ,'T' ,8));
   s78.addTransition(ScannerTransEntry(7 ,'t' ,8));
   s78.addTransition(ScannerTransEntry(8 ,'E' ,9));
   s78.addTransition(ScannerTransEntry(8 ,'e' ,9));
   _scannerList.Insert(s78);

   Scanner s79(NEWDATE);
   s79.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s79.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s79.addState(ScannerStateEntry(2 ,START));
   s79.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s79.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s79.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s79.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s79.addState(ScannerStateEntry(7 ,FINAL));
   s79.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s79.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s79.addTransition(ScannerTransEntry(1 ,'W' ,3));
   s79.addTransition(ScannerTransEntry(1 ,'w' ,3));
   s79.addTransition(ScannerTransEntry(2 ,'N' ,0));
   s79.addTransition(ScannerTransEntry(2 ,'n' ,0));
   s79.addTransition(ScannerTransEntry(3 ,'D' ,4));
   s79.addTransition(ScannerTransEntry(3 ,'d' ,4));
   s79.addTransition(ScannerTransEntry(4 ,'A' ,5));
   s79.addTransition(ScannerTransEntry(4 ,'a' ,5));
   s79.addTransition(ScannerTransEntry(5 ,'T' ,6));
   s79.addTransition(ScannerTransEntry(5 ,'t' ,6));
   s79.addTransition(ScannerTransEntry(6 ,'E' ,7));
   s79.addTransition(ScannerTransEntry(6 ,'e' ,7));
   _scannerList.Insert(s79);

   Scanner s80(INSERT);
   s80.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s80.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s80.addState(ScannerStateEntry(2 ,START));
   s80.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s80.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s80.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s80.addState(ScannerStateEntry(6 ,FINAL));
   s80.addTransition(ScannerTransEntry(0 ,'N' ,1));
   s80.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s80.addTransition(ScannerTransEntry(1 ,'S' ,3));
   s80.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s80.addTransition(ScannerTransEntry(2 ,'I' ,0));
   s80.addTransition(ScannerTransEntry(2 ,'i' ,0));
   s80.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s80.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s80.addTransition(ScannerTransEntry(4 ,'R' ,5));
   s80.addTransition(ScannerTransEntry(4 ,'r' ,5));
   s80.addTransition(ScannerTransEntry(5 ,'T' ,6));
   s80.addTransition(ScannerTransEntry(5 ,'t' ,6));
   _scannerList.Insert(s80);

   Scanner s81(INT2ASC);
   s81.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s81.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s81.addState(ScannerStateEntry(2 ,START));
   s81.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s81.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s81.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s81.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s81.addState(ScannerStateEntry(7 ,FINAL));
   s81.addTransition(ScannerTransEntry(0 ,'N' ,1));
   s81.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s81.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s81.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s81.addTransition(ScannerTransEntry(2 ,'I' ,0));
   s81.addTransition(ScannerTransEntry(2 ,'i' ,0));
   s81.addTransition(ScannerTransEntry(3 ,'2' ,4));
   s81.addTransition(ScannerTransEntry(4 ,'A' ,5));
   s81.addTransition(ScannerTransEntry(4 ,'a' ,5));
   s81.addTransition(ScannerTransEntry(5 ,'C' ,6));
   s81.addTransition(ScannerTransEntry(5 ,'s' ,6));
   s81.addTransition(ScannerTransEntry(6 ,'C' ,7));
   s81.addTransition(ScannerTransEntry(6 ,'c' ,7));
   _scannerList.Insert(s81);

   Scanner s82(IS);
   s82.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s82.addState(ScannerStateEntry(1 ,FINAL));
   s82.addState(ScannerStateEntry(2 ,START));
   s82.addTransition(ScannerTransEntry(0 ,'S' ,1));
   s82.addTransition(ScannerTransEntry(0 ,'s' ,1));
   s82.addTransition(ScannerTransEntry(2 ,'I' ,0));
   s82.addTransition(ScannerTransEntry(2 ,'i' ,0));
   _scannerList.Insert(s82);

   Scanner s83(ISOLATION);
   s83.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s83.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s83.addState(ScannerStateEntry(2 ,START));
   s83.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s83.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s83.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s83.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s83.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s83.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s83.addState(ScannerStateEntry(9 ,FINAL));
   s83.addTransition(ScannerTransEntry(0 ,'S' ,1));
   s83.addTransition(ScannerTransEntry(0 ,'s' ,1));
   s83.addTransition(ScannerTransEntry(1 ,'O' ,3));
   s83.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s83.addTransition(ScannerTransEntry(2 ,'I' ,0));
   s83.addTransition(ScannerTransEntry(2 ,'i' ,0));
   s83.addTransition(ScannerTransEntry(3 ,'L' ,4));
   s83.addTransition(ScannerTransEntry(3 ,'l' ,4));
   s83.addTransition(ScannerTransEntry(4 ,'A' ,5));
   s83.addTransition(ScannerTransEntry(4 ,'a' ,5));
   s83.addTransition(ScannerTransEntry(5 ,'T' ,6));
   s83.addTransition(ScannerTransEntry(5 ,'t' ,6));
   s83.addTransition(ScannerTransEntry(6 ,'I' ,7));
   s83.addTransition(ScannerTransEntry(6 ,'i' ,7));
   s83.addTransition(ScannerTransEntry(7 ,'O' ,8));
   s83.addTransition(ScannerTransEntry(7 ,'o' ,8));
   s83.addTransition(ScannerTransEntry(8 ,'N' ,9));
   s83.addTransition(ScannerTransEntry(8 ,'n' ,9));
   _scannerList.Insert(s83);

   Scanner s84(JDBC);
   s84.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s84.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s84.addState(ScannerStateEntry(2 ,START));
   s84.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s84.addState(ScannerStateEntry(4 ,FINAL));
   s84.addTransition(ScannerTransEntry(0 ,'D' ,1));
   s84.addTransition(ScannerTransEntry(0 ,'d' ,1));
   s84.addTransition(ScannerTransEntry(1 ,'B' ,3));
   s84.addTransition(ScannerTransEntry(1 ,'b' ,3));
   s84.addTransition(ScannerTransEntry(2 ,'J' ,0));
   s84.addTransition(ScannerTransEntry(2 ,'j' ,0));
   s84.addTransition(ScannerTransEntry(3 ,'C' ,4));
   s84.addTransition(ScannerTransEntry(3 ,'c' ,4));
   _scannerList.Insert(s84);

   Scanner s85(JOIN);
   s85.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s85.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s85.addState(ScannerStateEntry(2 ,START));
   s85.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s85.addState(ScannerStateEntry(4 ,FINAL));
   s85.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s85.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s85.addTransition(ScannerTransEntry(1 ,'I' ,3));
   s85.addTransition(ScannerTransEntry(1 ,'i' ,3));
   s85.addTransition(ScannerTransEntry(2 ,'J' ,0));
   s85.addTransition(ScannerTransEntry(2 ,'j' ,0));
   s85.addTransition(ScannerTransEntry(3 ,'N' ,4));
   s85.addTransition(ScannerTransEntry(3 ,'n' ,4));
   _scannerList.Insert(s85);

   Scanner s86(KEY);
   s86.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s86.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s86.addState(ScannerStateEntry(2 ,START));
   s86.addState(ScannerStateEntry(3 ,FINAL));
   s86.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s86.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s86.addTransition(ScannerTransEntry(1 ,'Y' ,3));
   s86.addTransition(ScannerTransEntry(1 ,'y' ,3));
   s86.addTransition(ScannerTransEntry(2 ,'K' ,0));
   s86.addTransition(ScannerTransEntry(2 ,'k' ,0));
   _scannerList.Insert(s86);

   Scanner s87(LEFT);
   s87.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s87.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s87.addState(ScannerStateEntry(2 ,START));
   s87.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s87.addState(ScannerStateEntry(4 ,FINAL));
   s87.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s87.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s87.addTransition(ScannerTransEntry(1 ,'F' ,3));
   s87.addTransition(ScannerTransEntry(1 ,'f' ,3));
   s87.addTransition(ScannerTransEntry(2 ,'L' ,0));
   s87.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s87.addTransition(ScannerTransEntry(3 ,'T' ,4));
   s87.addTransition(ScannerTransEntry(3 ,'t' ,4));
   _scannerList.Insert(s87);

   Scanner s88(LENGTH);
   s88.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s88.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s88.addState(ScannerStateEntry(2 ,START));
   s88.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s88.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s88.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s88.addState(ScannerStateEntry(6 ,FINAL));
   s88.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s88.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s88.addTransition(ScannerTransEntry(1 ,'N' ,3));
   s88.addTransition(ScannerTransEntry(1 ,'n' ,3));
   s88.addTransition(ScannerTransEntry(2 ,'L' ,0));
   s88.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s88.addTransition(ScannerTransEntry(3 ,'G' ,4));
   s88.addTransition(ScannerTransEntry(3 ,'g' ,4));
   s88.addTransition(ScannerTransEntry(4 ,'T' ,5));
   s88.addTransition(ScannerTransEntry(4 ,'t' ,5));
   s88.addTransition(ScannerTransEntry(5 ,'H' ,6));
   s88.addTransition(ScannerTransEntry(5 ,'h' ,6));
   _scannerList.Insert(s88);

   Scanner s89(LIKE);
   s89.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s89.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s89.addState(ScannerStateEntry(2 ,START));
   s89.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s89.addState(ScannerStateEntry(4 ,FINAL));
   s89.addTransition(ScannerTransEntry(0 ,'I' ,1));
   s89.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s89.addTransition(ScannerTransEntry(1 ,'K' ,3));
   s89.addTransition(ScannerTransEntry(1 ,'k' ,3));
   s89.addTransition(ScannerTransEntry(2 ,'L' ,0));
   s89.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s89.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s89.addTransition(ScannerTransEntry(3 ,'e' ,4));
   _scannerList.Insert(s89);

   Scanner s90(LIST);
   s90.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s90.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s90.addState(ScannerStateEntry(2 ,START));
   s90.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s90.addState(ScannerStateEntry(4 ,FINAL));
   s90.addTransition(ScannerTransEntry(0 ,'I' ,1));
   s90.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s90.addTransition(ScannerTransEntry(1 ,'S' ,3));
   s90.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s90.addTransition(ScannerTransEntry(2 ,'L' ,0));
   s90.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s90.addTransition(ScannerTransEntry(3 ,'T' ,4));
   s90.addTransition(ScannerTransEntry(3 ,'t' ,4));
   _scannerList.Insert(s90);

   Scanner s91(LDIV);
   s91.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s91.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s91.addState(ScannerStateEntry(2 ,START));
   s91.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s91.addState(ScannerStateEntry(4 ,FINAL));
   s91.addTransition(ScannerTransEntry(0 ,'D' ,1));
   s91.addTransition(ScannerTransEntry(0 ,'d' ,1));
   s91.addTransition(ScannerTransEntry(1 ,'I' ,3));
   s91.addTransition(ScannerTransEntry(1 ,'i' ,3));
   s91.addTransition(ScannerTransEntry(2 ,'L' ,0));
   s91.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s91.addTransition(ScannerTransEntry(3 ,'V' ,4));
   s91.addTransition(ScannerTransEntry(3 ,'v' ,4));
   _scannerList.Insert(s91);

   Scanner s92(LMOD);
   s92.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s92.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s92.addState(ScannerStateEntry(2 ,START));
   s92.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s92.addState(ScannerStateEntry(4 ,FINAL));
   s92.addTransition(ScannerTransEntry(0 ,'M' ,1));
   s92.addTransition(ScannerTransEntry(0 ,'m' ,1));
   s92.addTransition(ScannerTransEntry(1 ,'O' ,3));
   s92.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s92.addTransition(ScannerTransEntry(2 ,'L' ,0));
   s92.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s92.addTransition(ScannerTransEntry(3 ,'D' ,4));
   s92.addTransition(ScannerTransEntry(3 ,'d' ,4));
   _scannerList.Insert(s92);

   Scanner s93(LOAD);
   s93.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s93.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s93.addState(ScannerStateEntry(2 ,START));
   s93.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s93.addState(ScannerStateEntry(4 ,FINAL));
   s93.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s93.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s93.addTransition(ScannerTransEntry(1 ,'A' ,3));
   s93.addTransition(ScannerTransEntry(1 ,'a' ,3));
   s93.addTransition(ScannerTransEntry(2 ,'L' ,0));
   s93.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s93.addTransition(ScannerTransEntry(3 ,'D' ,4));
   s93.addTransition(ScannerTransEntry(3 ,'d' ,4));
   _scannerList.Insert(s93);

   Scanner s94(LOCK);
   s94.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s94.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s94.addState(ScannerStateEntry(2 ,START));
   s94.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s94.addState(ScannerStateEntry(4 ,FINAL));
   s94.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s94.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s94.addTransition(ScannerTransEntry(1 ,'C' ,3));
   s94.addTransition(ScannerTransEntry(1 ,'c' ,3));
   s94.addTransition(ScannerTransEntry(2 ,'L' ,0));
   s94.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s94.addTransition(ScannerTransEntry(3 ,'K' ,4));
   s94.addTransition(ScannerTransEntry(3 ,'k' ,4));
   _scannerList.Insert(s94);

   Scanner s95(UNLOCK);
   s95.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s95.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s95.addState(ScannerStateEntry(2 ,START));
   s95.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s95.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s95.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s95.addState(ScannerStateEntry(6 ,FINAL));
   s95.addTransition(ScannerTransEntry(0 ,'N' ,1));
   s95.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s95.addTransition(ScannerTransEntry(1 ,'L' ,3));
   s95.addTransition(ScannerTransEntry(1 ,'l' ,3));
   s95.addTransition(ScannerTransEntry(2 ,'U' ,0));
   s95.addTransition(ScannerTransEntry(2 ,'u' ,0));
   s95.addTransition(ScannerTransEntry(3 ,'O' ,4));
   s95.addTransition(ScannerTransEntry(3 ,'o' ,4));
   s95.addTransition(ScannerTransEntry(4 ,'C' ,5));
   s95.addTransition(ScannerTransEntry(4 ,'c' ,5));
   s95.addTransition(ScannerTransEntry(5 ,'K' ,6));
   s95.addTransition(ScannerTransEntry(5 ,'k' ,6));
   _scannerList.Insert(s95);

   Scanner s96(LONG);
   s96.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s96.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s96.addState(ScannerStateEntry(2 ,START));
   s96.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s96.addState(ScannerStateEntry(4 ,FINAL));
   s96.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s96.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s96.addTransition(ScannerTransEntry(1 ,'N' ,3));
   s96.addTransition(ScannerTransEntry(1 ,'n' ,3));
   s96.addTransition(ScannerTransEntry(2 ,'L' ,0));
   s96.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s96.addTransition(ScannerTransEntry(3 ,'G' ,4));
   s96.addTransition(ScannerTransEntry(3 ,'g' ,4));
   _scannerList.Insert(s96);

   Scanner s97(LOWER);
   s97.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s97.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s97.addState(ScannerStateEntry(2 ,START));
   s97.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s97.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s97.addState(ScannerStateEntry(5 ,FINAL));
   s97.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s97.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s97.addTransition(ScannerTransEntry(1 ,'W' ,3));
   s97.addTransition(ScannerTransEntry(1 ,'w' ,3));
   s97.addTransition(ScannerTransEntry(2 ,'L' ,0));
   s97.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s97.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s97.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s97.addTransition(ScannerTransEntry(4 ,'R' ,5));
   s97.addTransition(ScannerTransEntry(4 ,'r' ,5));
   _scannerList.Insert(s97);

   Scanner s98(LTRIM);
   s98.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s98.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s98.addState(ScannerStateEntry(2 ,START));
   s98.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s98.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s98.addState(ScannerStateEntry(5 ,FINAL));
   s98.addTransition(ScannerTransEntry(0 ,'T' ,1));
   s98.addTransition(ScannerTransEntry(0 ,'t' ,1));
   s98.addTransition(ScannerTransEntry(1 ,'R' ,3));
   s98.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s98.addTransition(ScannerTransEntry(2 ,'L' ,0));
   s98.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s98.addTransition(ScannerTransEntry(3 ,'I' ,4));
   s98.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s98.addTransition(ScannerTransEntry(4 ,'M' ,5));
   s98.addTransition(ScannerTransEntry(4 ,'m' ,5));
   _scannerList.Insert(s98);

   Scanner s99(MIN);
   s99.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s99.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s99.addState(ScannerStateEntry(2 ,START));
   s99.addState(ScannerStateEntry(3 ,FINAL));
   s99.addTransition(ScannerTransEntry(0 ,'I' ,1));
   s99.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s99.addTransition(ScannerTransEntry(1 ,'N' ,3));
   s99.addTransition(ScannerTransEntry(1 ,'n' ,3));
   s99.addTransition(ScannerTransEntry(2 ,'M' ,0));
   s99.addTransition(ScannerTransEntry(2 ,'m' ,0));
   _scannerList.Insert(s99);

   Scanner s100(MAX);
   s100.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s100.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s100.addState(ScannerStateEntry(2 ,START));
   s100.addState(ScannerStateEntry(3 ,FINAL));
   s100.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s100.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s100.addTransition(ScannerTransEntry(1 ,'X' ,3));
   s100.addTransition(ScannerTransEntry(1 ,'x' ,3));
   s100.addTransition(ScannerTransEntry(2 ,'M' ,0));
   s100.addTransition(ScannerTransEntry(2 ,'m' ,0));
   _scannerList.Insert(s100);

   Scanner s101(MOD);
   s101.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s101.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s101.addState(ScannerStateEntry(2 ,START));
   s101.addState(ScannerStateEntry(3 ,FINAL));
   s101.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s101.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s101.addTransition(ScannerTransEntry(1 ,'D' ,3));
   s101.addTransition(ScannerTransEntry(1 ,'d' ,3));
   s101.addTransition(ScannerTransEntry(2 ,'M' ,0));
   s101.addTransition(ScannerTransEntry(2 ,'m' ,0));
   _scannerList.Insert(s101);

   Scanner s102(MODIFY);
   s102.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s102.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s102.addState(ScannerStateEntry(2 ,START));
   s102.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s102.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s102.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s102.addState(ScannerStateEntry(6 ,FINAL));
   s102.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s102.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s102.addTransition(ScannerTransEntry(1 ,'D' ,3));
   s102.addTransition(ScannerTransEntry(1 ,'d' ,3));
   s102.addTransition(ScannerTransEntry(2 ,'M' ,0));
   s102.addTransition(ScannerTransEntry(2 ,'m' ,0));
   s102.addTransition(ScannerTransEntry(3 ,'I' ,4));
   s102.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s102.addTransition(ScannerTransEntry(4 ,'F' ,5));
   s102.addTransition(ScannerTransEntry(4 ,'f' ,5));
   s102.addTransition(ScannerTransEntry(5 ,'Y' ,6));
   s102.addTransition(ScannerTransEntry(5 ,'y' ,6));
   _scannerList.Insert(s102);

   Scanner s103(NEXTCOUNT);
   s103.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s103.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s103.addState(ScannerStateEntry(2 ,START));
   s103.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s103.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s103.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s103.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s103.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s103.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s103.addState(ScannerStateEntry(9 ,FINAL));
   s103.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s103.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s103.addTransition(ScannerTransEntry(1 ,'X' ,3));
   s103.addTransition(ScannerTransEntry(1 ,'x' ,3));
   s103.addTransition(ScannerTransEntry(2 ,'N' ,0));
   s103.addTransition(ScannerTransEntry(2 ,'n' ,0));
   s103.addTransition(ScannerTransEntry(3 ,'T' ,4));
   s103.addTransition(ScannerTransEntry(3 ,'t' ,4));
   s103.addTransition(ScannerTransEntry(4 ,'C' ,5));
   s103.addTransition(ScannerTransEntry(4 ,'c' ,5));
   s103.addTransition(ScannerTransEntry(5 ,'O' ,6));
   s103.addTransition(ScannerTransEntry(5 ,'o' ,6));
   s103.addTransition(ScannerTransEntry(6 ,'U' ,7));
   s103.addTransition(ScannerTransEntry(6 ,'u' ,7));
   s103.addTransition(ScannerTransEntry(7 ,'N' ,8));
   s103.addTransition(ScannerTransEntry(7 ,'n' ,8));
   s103.addTransition(ScannerTransEntry(8 ,'T' ,9));
   s103.addTransition(ScannerTransEntry(8 ,'t' ,9));
   _scannerList.Insert(s103);

   Scanner s104(NOOP);
   s104.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s104.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s104.addState(ScannerStateEntry(2 ,START));
   s104.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s104.addState(ScannerStateEntry(4 ,FINAL));
   s104.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s104.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s104.addTransition(ScannerTransEntry(1 ,'O' ,3));
   s104.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s104.addTransition(ScannerTransEntry(2 ,'N' ,0));
   s104.addTransition(ScannerTransEntry(2 ,'n' ,0));
   s104.addTransition(ScannerTransEntry(3 ,'P' ,4));
   s104.addTransition(ScannerTransEntry(3 ,'p' ,4));
   _scannerList.Insert(s104);

   Scanner s105(NOT);
   s105.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s105.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s105.addState(ScannerStateEntry(2 ,START));
   s105.addState(ScannerStateEntry(3 ,FINAL));
   s105.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s105.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s105.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s105.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s105.addTransition(ScannerTransEntry(2 ,'N' ,0));
   s105.addTransition(ScannerTransEntry(2 ,'n' ,0));
   _scannerList.Insert(s105);

   Scanner s106(NULLTOKEN);
   s106.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s106.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s106.addState(ScannerStateEntry(2 ,START));
   s106.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s106.addState(ScannerStateEntry(4 ,FINAL));
   s106.addTransition(ScannerTransEntry(0 ,'U' ,1));
   s106.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s106.addTransition(ScannerTransEntry(1 ,'L' ,3));
   s106.addTransition(ScannerTransEntry(1 ,'l' ,3));
   s106.addTransition(ScannerTransEntry(2 ,'N' ,0));
   s106.addTransition(ScannerTransEntry(2 ,'n' ,0));
   s106.addTransition(ScannerTransEntry(3 ,'L' ,4));
   s106.addTransition(ScannerTransEntry(3 ,'l' ,4));
   _scannerList.Insert(s106);

   Scanner s107(OFF);
   s107.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s107.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s107.addState(ScannerStateEntry(2 ,START));
   s107.addState(ScannerStateEntry(3 ,FINAL));
   s107.addTransition(ScannerTransEntry(0 ,'F' ,1));
   s107.addTransition(ScannerTransEntry(0 ,'f' ,1));
   s107.addTransition(ScannerTransEntry(1 ,'F' ,3));
   s107.addTransition(ScannerTransEntry(1 ,'f' ,3));
   s107.addTransition(ScannerTransEntry(2 ,'O' ,0));
   s107.addTransition(ScannerTransEntry(2 ,'o' ,0));
   _scannerList.Insert(s107);

   Scanner s108(ON);
   s108.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s108.addState(ScannerStateEntry(1 ,FINAL));
   s108.addState(ScannerStateEntry(2 ,START));
   s108.addTransition(ScannerTransEntry(0 ,'N' ,1));
   s108.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s108.addTransition(ScannerTransEntry(2 ,'O' ,0));
   s108.addTransition(ScannerTransEntry(2 ,'o' ,0));
   _scannerList.Insert(s108);

   Scanner s109(OUTTOK);
   s109.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s109.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s109.addState(ScannerStateEntry(2 ,START));
   s109.addState(ScannerStateEntry(3 ,FINAL));
   s109.addTransition(ScannerTransEntry(0 ,'U' ,1));
   s109.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s109.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s109.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s109.addTransition(ScannerTransEntry(2 ,'O' ,0));
   s109.addTransition(ScannerTransEntry(2 ,'o' ,0));
   _scannerList.Insert(s109);

   Scanner s110(OUTER);
   s110.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s110.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s110.addState(ScannerStateEntry(2 ,START));
   s110.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s110.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s110.addState(ScannerStateEntry(5 ,FINAL));
   s110.addTransition(ScannerTransEntry(0 ,'U' ,1));
   s110.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s110.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s110.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s110.addTransition(ScannerTransEntry(2 ,'O' ,0));
   s110.addTransition(ScannerTransEntry(2 ,'o' ,0));
   s110.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s110.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s110.addTransition(ScannerTransEntry(4 ,'R' ,5));
   s110.addTransition(ScannerTransEntry(4 ,'r' ,5));
   _scannerList.Insert(s110);

   Scanner s111(OR);
   s111.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s111.addState(ScannerStateEntry(1 ,FINAL));
   s111.addState(ScannerStateEntry(2 ,START));
   s111.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s111.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s111.addTransition(ScannerTransEntry(2 ,'O' ,0));
   s111.addTransition(ScannerTransEntry(2 ,'o' ,0));
   _scannerList.Insert(s111);

   Scanner s112(ORDER);
   s112.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s112.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s112.addState(ScannerStateEntry(2 ,START));
   s112.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s112.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s112.addState(ScannerStateEntry(5 ,FINAL));
   s112.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s112.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s112.addTransition(ScannerTransEntry(1 ,'D' ,3));
   s112.addTransition(ScannerTransEntry(1 ,'d' ,3));
   s112.addTransition(ScannerTransEntry(2 ,'O' ,0));
   s112.addTransition(ScannerTransEntry(2 ,'o' ,0));
   s112.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s112.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s112.addTransition(ScannerTransEntry(4 ,'R' ,5));
   s112.addTransition(ScannerTransEntry(4 ,'r' ,5));
   _scannerList.Insert(s112);

   Scanner s113(PLAN);
   s113.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s113.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s113.addState(ScannerStateEntry(2 ,START));
   s113.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s113.addState(ScannerStateEntry(4 ,FINAL));
   s113.addTransition(ScannerTransEntry(0 ,'L' ,1));
   s113.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s113.addTransition(ScannerTransEntry(1 ,'A' ,3));
   s113.addTransition(ScannerTransEntry(1 ,'a' ,3));
   s113.addTransition(ScannerTransEntry(2 ,'P' ,0));
   s113.addTransition(ScannerTransEntry(2 ,'p' ,0));
   s113.addTransition(ScannerTransEntry(3 ,'N' ,4));
   s113.addTransition(ScannerTransEntry(3 ,'n' ,4));
   _scannerList.Insert(s113);

   Scanner s114(POOL);
   s114.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s114.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s114.addState(ScannerStateEntry(2 ,START));
   s114.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s114.addState(ScannerStateEntry(4 ,FINAL));
   s114.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s114.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s114.addTransition(ScannerTransEntry(1 ,'O' ,3));
   s114.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s114.addTransition(ScannerTransEntry(2 ,'P' ,0));
   s114.addTransition(ScannerTransEntry(2 ,'p' ,0));
   s114.addTransition(ScannerTransEntry(3 ,'L' ,4));
   s114.addTransition(ScannerTransEntry(3 ,'l' ,4));
   _scannerList.Insert(s114);

   Scanner s115(POWER);
   s115.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s115.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s115.addState(ScannerStateEntry(2 ,START));
   s115.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s115.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s115.addState(ScannerStateEntry(5 ,FINAL));
   s115.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s115.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s115.addTransition(ScannerTransEntry(1 ,'W' ,3));
   s115.addTransition(ScannerTransEntry(1 ,'w' ,3));
   s115.addTransition(ScannerTransEntry(2 ,'P' ,0));
   s115.addTransition(ScannerTransEntry(2 ,'p' ,0));
   s115.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s115.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s115.addTransition(ScannerTransEntry(4 ,'R' ,5));
   s115.addTransition(ScannerTransEntry(4 ,'r' ,5));
   _scannerList.Insert(s115);

   Scanner s116(PRIMARY);
   s116.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s116.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s116.addState(ScannerStateEntry(2 ,START));
   s116.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s116.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s116.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s116.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s116.addState(ScannerStateEntry(7 ,FINAL));
   s116.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s116.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s116.addTransition(ScannerTransEntry(1 ,'I' ,3));
   s116.addTransition(ScannerTransEntry(1 ,'i' ,3));
   s116.addTransition(ScannerTransEntry(2 ,'P' ,0));
   s116.addTransition(ScannerTransEntry(2 ,'p' ,0));
   s116.addTransition(ScannerTransEntry(3 ,'M' ,4));
   s116.addTransition(ScannerTransEntry(3 ,'m' ,4));
   s116.addTransition(ScannerTransEntry(4 ,'A' ,5));
   s116.addTransition(ScannerTransEntry(4 ,'a' ,5));
   s116.addTransition(ScannerTransEntry(5 ,'R' ,6));
   s116.addTransition(ScannerTransEntry(5 ,'r' ,6));
   s116.addTransition(ScannerTransEntry(6 ,'Y' ,7));
   s116.addTransition(ScannerTransEntry(6 ,'y' ,7));
   _scannerList.Insert(s116);

   Scanner s117(PRINT);
   s117.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s117.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s117.addState(ScannerStateEntry(2 ,START));
   s117.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s117.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s117.addState(ScannerStateEntry(5 ,FINAL));
   s117.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s117.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s117.addTransition(ScannerTransEntry(1 ,'I' ,3));
   s117.addTransition(ScannerTransEntry(1 ,'i' ,3));
   s117.addTransition(ScannerTransEntry(2 ,'P' ,0));
   s117.addTransition(ScannerTransEntry(2 ,'p' ,0));
   s117.addTransition(ScannerTransEntry(3 ,'N' ,4));
   s117.addTransition(ScannerTransEntry(3 ,'n' ,4));
   s117.addTransition(ScannerTransEntry(4 ,'T' ,5));
   s117.addTransition(ScannerTransEntry(4 ,'t' ,5));
   _scannerList.Insert(s117);

   Scanner s118(PROCEDURE);
   s118.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s118.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s118.addState(ScannerStateEntry(2 ,START));
   s118.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s118.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s118.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s118.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s118.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s118.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s118.addState(ScannerStateEntry(9 ,FINAL));
   s118.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s118.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s118.addTransition(ScannerTransEntry(1 ,'O' ,3));
   s118.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s118.addTransition(ScannerTransEntry(2 ,'P' ,0));
   s118.addTransition(ScannerTransEntry(2 ,'p' ,0));
   s118.addTransition(ScannerTransEntry(3 ,'C' ,4));
   s118.addTransition(ScannerTransEntry(3 ,'c' ,4));
   s118.addTransition(ScannerTransEntry(4 ,'E' ,5));
   s118.addTransition(ScannerTransEntry(4 ,'e' ,5));
   s118.addTransition(ScannerTransEntry(5 ,'D' ,6));
   s118.addTransition(ScannerTransEntry(5 ,'d' ,6));
   s118.addTransition(ScannerTransEntry(6 ,'U' ,7));
   s118.addTransition(ScannerTransEntry(6 ,'u' ,7));
   s118.addTransition(ScannerTransEntry(7 ,'R' ,8));
   s118.addTransition(ScannerTransEntry(7 ,'r' ,8));
   s118.addTransition(ScannerTransEntry(8 ,'E' ,9));
   s118.addTransition(ScannerTransEntry(8 ,'e' ,9));
   _scannerList.Insert(s118);

   Scanner s119(QUIT);
   s119.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s119.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s119.addState(ScannerStateEntry(2 ,START));
   s119.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s119.addState(ScannerStateEntry(4 ,FINAL));
   s119.addTransition(ScannerTransEntry(0 ,'U' ,1));
   s119.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s119.addTransition(ScannerTransEntry(1 ,'I' ,3));
   s119.addTransition(ScannerTransEntry(1 ,'i' ,3));
   s119.addTransition(ScannerTransEntry(2 ,'Q' ,0));
   s119.addTransition(ScannerTransEntry(2 ,'q' ,0));
   s119.addTransition(ScannerTransEntry(3 ,'T' ,4));
   s119.addTransition(ScannerTransEntry(3 ,'t' ,4));
   _scannerList.Insert(s119);

   Scanner s120(RANDSTR);
   s120.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s120.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s120.addState(ScannerStateEntry(2 ,START));
   s120.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s120.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s120.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s120.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s120.addState(ScannerStateEntry(7 ,FINAL));
   s120.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s120.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s120.addTransition(ScannerTransEntry(1 ,'N' ,3));
   s120.addTransition(ScannerTransEntry(1 ,'n' ,3));
   s120.addTransition(ScannerTransEntry(2 ,'R' ,0));
   s120.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s120.addTransition(ScannerTransEntry(3 ,'D' ,4));
   s120.addTransition(ScannerTransEntry(3 ,'d' ,4));
   s120.addTransition(ScannerTransEntry(4 ,'S' ,5));
   s120.addTransition(ScannerTransEntry(4 ,'s' ,5));
   s120.addTransition(ScannerTransEntry(5 ,'T' ,6));
   s120.addTransition(ScannerTransEntry(5 ,'t' ,6));
   s120.addTransition(ScannerTransEntry(6 ,'R' ,7));
   s120.addTransition(ScannerTransEntry(6 ,'r' ,7));
   _scannerList.Insert(s120);

   Scanner s121(RANDINT);
   s121.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s121.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s121.addState(ScannerStateEntry(2 ,START));
   s121.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s121.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s121.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s121.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s121.addState(ScannerStateEntry(7 ,FINAL));
   s121.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s121.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s121.addTransition(ScannerTransEntry(1 ,'N' ,3));
   s121.addTransition(ScannerTransEntry(1 ,'n' ,3));
   s121.addTransition(ScannerTransEntry(2 ,'R' ,0));
   s121.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s121.addTransition(ScannerTransEntry(3 ,'D' ,4));
   s121.addTransition(ScannerTransEntry(3 ,'d' ,4));
   s121.addTransition(ScannerTransEntry(4 ,'I' ,5));
   s121.addTransition(ScannerTransEntry(4 ,'i' ,5));
   s121.addTransition(ScannerTransEntry(5 ,'N' ,6));
   s121.addTransition(ScannerTransEntry(5 ,'n' ,6));
   s121.addTransition(ScannerTransEntry(6 ,'T' ,7));
   s121.addTransition(ScannerTransEntry(6 ,'t' ,7));
   _scannerList.Insert(s121);

   Scanner s122(RBSEG);
   s122.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s122.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s122.addState(ScannerStateEntry(2 ,START));
   s122.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s122.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s122.addState(ScannerStateEntry(5 ,FINAL));
   s122.addTransition(ScannerTransEntry(0 ,'B' ,1));
   s122.addTransition(ScannerTransEntry(0 ,'b' ,1));
   s122.addTransition(ScannerTransEntry(1 ,'S' ,3));
   s122.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s122.addTransition(ScannerTransEntry(2 ,'R' ,0));
   s122.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s122.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s122.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s122.addTransition(ScannerTransEntry(4 ,'G' ,5));
   s122.addTransition(ScannerTransEntry(4 ,'g' ,5));
   _scannerList.Insert(s122);

   Scanner s123(REFERENCES);
   s123.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s123.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s123.addState(ScannerStateEntry(2 ,START));
   s123.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s123.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s123.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s123.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s123.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s123.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s123.addState(ScannerStateEntry(9 ,INTERMEDIATE));
   s123.addState(ScannerStateEntry(10 ,FINAL));
   s123.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s123.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s123.addTransition(ScannerTransEntry(1 ,'F' ,3));
   s123.addTransition(ScannerTransEntry(1 ,'f' ,3));
   s123.addTransition(ScannerTransEntry(2 ,'R' ,0));
   s123.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s123.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s123.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s123.addTransition(ScannerTransEntry(4 ,'R' ,5));
   s123.addTransition(ScannerTransEntry(4 ,'r' ,5));
   s123.addTransition(ScannerTransEntry(5 ,'E' ,6));
   s123.addTransition(ScannerTransEntry(5 ,'e' ,6));
   s123.addTransition(ScannerTransEntry(6 ,'N' ,7));
   s123.addTransition(ScannerTransEntry(6 ,'n' ,7));
   s123.addTransition(ScannerTransEntry(7 ,'C' ,8));
   s123.addTransition(ScannerTransEntry(7 ,'c' ,8));
   s123.addTransition(ScannerTransEntry(8 ,'E' ,9));
   s123.addTransition(ScannerTransEntry(8 ,'e' ,9));
   s123.addTransition(ScannerTransEntry(9 ,'S' ,10));
   s123.addTransition(ScannerTransEntry(9 ,'s' ,10));
   _scannerList.Insert(s123);

   Scanner s124(RENAME);
   s124.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s124.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s124.addState(ScannerStateEntry(2 ,START));
   s124.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s124.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s124.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s124.addState(ScannerStateEntry(6 ,FINAL));
   s124.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s124.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s124.addTransition(ScannerTransEntry(1 ,'N' ,3));
   s124.addTransition(ScannerTransEntry(1 ,'n' ,3));
   s124.addTransition(ScannerTransEntry(2 ,'R' ,0));
   s124.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s124.addTransition(ScannerTransEntry(3 ,'A' ,4));
   s124.addTransition(ScannerTransEntry(3 ,'a' ,4));
   s124.addTransition(ScannerTransEntry(4 ,'M' ,5));
   s124.addTransition(ScannerTransEntry(4 ,'m' ,5));
   s124.addTransition(ScannerTransEntry(5 ,'E' ,6));
   s124.addTransition(ScannerTransEntry(5 ,'e' ,6));
   _scannerList.Insert(s124);

   Scanner s125(REORGANIZE);
   s125.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s125.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s125.addState(ScannerStateEntry(2 ,START));
   s125.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s125.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s125.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s125.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s125.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s125.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s125.addState(ScannerStateEntry(9 ,INTERMEDIATE));
   s125.addState(ScannerStateEntry(10 ,FINAL));
   s125.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s125.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s125.addTransition(ScannerTransEntry(1 ,'O' ,3));
   s125.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s125.addTransition(ScannerTransEntry(2 ,'R' ,0));
   s125.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s125.addTransition(ScannerTransEntry(3 ,'R' ,4));
   s125.addTransition(ScannerTransEntry(3 ,'r' ,4));
   s125.addTransition(ScannerTransEntry(4 ,'G' ,5));
   s125.addTransition(ScannerTransEntry(4 ,'g' ,5));
   s125.addTransition(ScannerTransEntry(5 ,'A' ,6));
   s125.addTransition(ScannerTransEntry(5 ,'a' ,6));
   s125.addTransition(ScannerTransEntry(6 ,'N' ,7));
   s125.addTransition(ScannerTransEntry(6 ,'n' ,7));
   s125.addTransition(ScannerTransEntry(7 ,'I' ,8));
   s125.addTransition(ScannerTransEntry(7 ,'i' ,8));
   s125.addTransition(ScannerTransEntry(8 ,'Z' ,9));
   s125.addTransition(ScannerTransEntry(8 ,'z' ,9));
   s125.addTransition(ScannerTransEntry(9 ,'E' ,10));
   s125.addTransition(ScannerTransEntry(9 ,'e' ,10));
   _scannerList.Insert(s125);

   Scanner s126(RETURNTOKEN);
   s126.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s126.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s126.addState(ScannerStateEntry(2 ,START));
   s126.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s126.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s126.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s126.addState(ScannerStateEntry(6 ,FINAL));
   s126.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s126.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s126.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s126.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s126.addTransition(ScannerTransEntry(2 ,'R' ,0));
   s126.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s126.addTransition(ScannerTransEntry(3 ,'U' ,4));
   s126.addTransition(ScannerTransEntry(3 ,'u' ,4));
   s126.addTransition(ScannerTransEntry(4 ,'R' ,5));
   s126.addTransition(ScannerTransEntry(4 ,'r' ,5));
   s126.addTransition(ScannerTransEntry(5 ,'N' ,6));
   s126.addTransition(ScannerTransEntry(5 ,'n' ,6));
   _scannerList.Insert(s126);

   Scanner s127(REMOVE);
   s127.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s127.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s127.addState(ScannerStateEntry(2 ,START));
   s127.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s127.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s127.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s127.addState(ScannerStateEntry(6 ,FINAL));
   s127.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s127.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s127.addTransition(ScannerTransEntry(1 ,'M' ,3));
   s127.addTransition(ScannerTransEntry(1 ,'m' ,3));
   s127.addTransition(ScannerTransEntry(2 ,'R' ,0));
   s127.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s127.addTransition(ScannerTransEntry(3 ,'O' ,4));
   s127.addTransition(ScannerTransEntry(3 ,'o' ,4));
   s127.addTransition(ScannerTransEntry(4 ,'V' ,5));
   s127.addTransition(ScannerTransEntry(4 ,'v' ,5));
   s127.addTransition(ScannerTransEntry(5 ,'E' ,6));
   s127.addTransition(ScannerTransEntry(5 ,'e' ,6));
   _scannerList.Insert(s127);

   Scanner s128(REPLACE);
   s128.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s128.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s128.addState(ScannerStateEntry(2 ,START));
   s128.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s128.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s128.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s128.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s128.addState(ScannerStateEntry(7 ,FINAL));
   s128.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s128.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s128.addTransition(ScannerTransEntry(1 ,'P' ,3));
   s128.addTransition(ScannerTransEntry(1 ,'p' ,3));
   s128.addTransition(ScannerTransEntry(2 ,'R' ,0));
   s128.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s128.addTransition(ScannerTransEntry(3 ,'L' ,4));
   s128.addTransition(ScannerTransEntry(3 ,'l' ,4));
   s128.addTransition(ScannerTransEntry(4 ,'A' ,5));
   s128.addTransition(ScannerTransEntry(4 ,'a' ,5));
   s128.addTransition(ScannerTransEntry(5 ,'C' ,6));
   s128.addTransition(ScannerTransEntry(5 ,'c' ,6));
   s128.addTransition(ScannerTransEntry(6 ,'E' ,7));
   s128.addTransition(ScannerTransEntry(6 ,'e' ,7));
   _scannerList.Insert(s128);

   Scanner s129(RIGHT);
   s129.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s129.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s129.addState(ScannerStateEntry(2 ,START));
   s129.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s129.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s129.addState(ScannerStateEntry(5 ,FINAL));
   s129.addTransition(ScannerTransEntry(0 ,'I' ,1));
   s129.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s129.addTransition(ScannerTransEntry(1 ,'G' ,3));
   s129.addTransition(ScannerTransEntry(1 ,'g' ,3));
   s129.addTransition(ScannerTransEntry(2 ,'R' ,0));
   s129.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s129.addTransition(ScannerTransEntry(3 ,'H' ,4));
   s129.addTransition(ScannerTransEntry(3 ,'h' ,4));
   s129.addTransition(ScannerTransEntry(4 ,'T' ,5));
   s129.addTransition(ScannerTransEntry(4 ,'t' ,5));
   _scannerList.Insert(s129);

   Scanner s130(ROLLBACK);
   s130.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s130.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s130.addState(ScannerStateEntry(2 ,START));
   s130.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s130.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s130.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s130.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s130.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s130.addState(ScannerStateEntry(8 ,FINAL));
   s130.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s130.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s130.addTransition(ScannerTransEntry(1 ,'L' ,3));
   s130.addTransition(ScannerTransEntry(1 ,'l' ,3));
   s130.addTransition(ScannerTransEntry(2 ,'R' ,0));
   s130.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s130.addTransition(ScannerTransEntry(3 ,'L' ,4));
   s130.addTransition(ScannerTransEntry(3 ,'l' ,4));
   s130.addTransition(ScannerTransEntry(4 ,'B' ,5));
   s130.addTransition(ScannerTransEntry(4 ,'b' ,5));
   s130.addTransition(ScannerTransEntry(5 ,'A' ,6));
   s130.addTransition(ScannerTransEntry(5 ,'a' ,6));
   s130.addTransition(ScannerTransEntry(6 ,'C' ,7));
   s130.addTransition(ScannerTransEntry(6 ,'c' ,7));
   s130.addTransition(ScannerTransEntry(7 ,'K' ,8));
   s130.addTransition(ScannerTransEntry(7 ,'k' ,8));
   _scannerList.Insert(s130);

   Scanner s131(ROUND);
   s131.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s131.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s131.addState(ScannerStateEntry(2 ,START));
   s131.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s131.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s131.addState(ScannerStateEntry(5 ,FINAL));
   s131.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s131.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s131.addTransition(ScannerTransEntry(1 ,'U' ,3));
   s131.addTransition(ScannerTransEntry(1 ,'u' ,3));
   s131.addTransition(ScannerTransEntry(2 ,'R' ,0));
   s131.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s131.addTransition(ScannerTransEntry(3 ,'N' ,4));
   s131.addTransition(ScannerTransEntry(3 ,'n' ,4));
   s131.addTransition(ScannerTransEntry(4 ,'D' ,5));
   s131.addTransition(ScannerTransEntry(4 ,'d' ,5));
   _scannerList.Insert(s131);

   Scanner s132(ROWLIMIT);
   s132.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s132.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s132.addState(ScannerStateEntry(2 ,START));
   s132.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s132.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s132.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s132.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s132.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s132.addState(ScannerStateEntry(8 ,FINAL));
   s132.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s132.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s132.addTransition(ScannerTransEntry(1 ,'W' ,3));
   s132.addTransition(ScannerTransEntry(1 ,'w' ,3));
   s132.addTransition(ScannerTransEntry(2 ,'R' ,0));
   s132.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s132.addTransition(ScannerTransEntry(3 ,'L' ,4));
   s132.addTransition(ScannerTransEntry(3 ,'l' ,4));
   s132.addTransition(ScannerTransEntry(4 ,'I' ,5));
   s132.addTransition(ScannerTransEntry(4 ,'i' ,5));
   s132.addTransition(ScannerTransEntry(5 ,'M' ,6));
   s132.addTransition(ScannerTransEntry(5 ,'m' ,6));
   s132.addTransition(ScannerTransEntry(6 ,'I' ,7));
   s132.addTransition(ScannerTransEntry(6 ,'i' ,7));
   s132.addTransition(ScannerTransEntry(7 ,'T' ,8));
   s132.addTransition(ScannerTransEntry(7 ,'t' ,8));
   _scannerList.Insert(s132);

   Scanner s133(RTRIM);
   s133.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s133.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s133.addState(ScannerStateEntry(2 ,START));
   s133.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s133.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s133.addState(ScannerStateEntry(5 ,FINAL));
   s133.addTransition(ScannerTransEntry(0 ,'T' ,1));
   s133.addTransition(ScannerTransEntry(0 ,'t' ,1));
   s133.addTransition(ScannerTransEntry(1 ,'R' ,3));
   s133.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s133.addTransition(ScannerTransEntry(2 ,'R' ,0));
   s133.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s133.addTransition(ScannerTransEntry(3 ,'I' ,4));
   s133.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s133.addTransition(ScannerTransEntry(4 ,'M' ,5));
   s133.addTransition(ScannerTransEntry(4 ,'m' ,5));
   _scannerList.Insert(s133);

   Scanner s134(SELECT);
   s134.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s134.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s134.addState(ScannerStateEntry(2 ,START));
   s134.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s134.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s134.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s134.addState(ScannerStateEntry(6 ,FINAL));
   s134.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s134.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s134.addTransition(ScannerTransEntry(1 ,'L' ,3));
   s134.addTransition(ScannerTransEntry(1 ,'l' ,3));
   s134.addTransition(ScannerTransEntry(2 ,'S' ,0));
   s134.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s134.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s134.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s134.addTransition(ScannerTransEntry(4 ,'C' ,5));
   s134.addTransition(ScannerTransEntry(4 ,'c' ,5));
   s134.addTransition(ScannerTransEntry(5 ,'T' ,6));
   s134.addTransition(ScannerTransEntry(5 ,'t' ,6));
   _scannerList.Insert(s134);

   Scanner s135(SET);
   s135.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s135.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s135.addState(ScannerStateEntry(2 ,START));
   s135.addState(ScannerStateEntry(3 ,FINAL));
   s135.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s135.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s135.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s135.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s135.addTransition(ScannerTransEntry(2 ,'S' ,0));
   s135.addTransition(ScannerTransEntry(2 ,'s' ,0));
   _scannerList.Insert(s135);

   Scanner s136(SETCOUNT);
   s136.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s136.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s136.addState(ScannerStateEntry(2 ,START));
   s136.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s136.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s136.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s136.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s136.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s136.addState(ScannerStateEntry(8 ,FINAL));
   s136.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s136.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s136.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s136.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s136.addTransition(ScannerTransEntry(2 ,'S' ,0));
   s136.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s136.addTransition(ScannerTransEntry(3 ,'C' ,4));
   s136.addTransition(ScannerTransEntry(3 ,'c' ,4));
   s136.addTransition(ScannerTransEntry(4 ,'O' ,5));
   s136.addTransition(ScannerTransEntry(4 ,'o' ,5));
   s136.addTransition(ScannerTransEntry(5 ,'U' ,6));
   s136.addTransition(ScannerTransEntry(5 ,'u' ,6));
   s136.addTransition(ScannerTransEntry(6 ,'N' ,7));
   s136.addTransition(ScannerTransEntry(6 ,'n' ,7));
   s136.addTransition(ScannerTransEntry(7 ,'T' ,8));
   s136.addTransition(ScannerTransEntry(7 ,'t' ,8));
   _scannerList.Insert(s136);

   Scanner s137(SHOW);
   s137.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s137.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s137.addState(ScannerStateEntry(2 ,START));
   s137.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s137.addState(ScannerStateEntry(4 ,FINAL));
   s137.addTransition(ScannerTransEntry(0 ,'H' ,1));
   s137.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s137.addTransition(ScannerTransEntry(1 ,'O' ,3));
   s137.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s137.addTransition(ScannerTransEntry(2 ,'S' ,0));
   s137.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s137.addTransition(ScannerTransEntry(3 ,'W' ,4));
   s137.addTransition(ScannerTransEntry(3 ,'w' ,4));
   _scannerList.Insert(s137);

   Scanner s138(SMALLINT);
   s138.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s138.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s138.addState(ScannerStateEntry(2 ,START));
   s138.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s138.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s138.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s138.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s138.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s138.addState(ScannerStateEntry(8 ,FINAL));
   s138.addTransition(ScannerTransEntry(0 ,'M' ,1));
   s138.addTransition(ScannerTransEntry(0 ,'m' ,1));
   s138.addTransition(ScannerTransEntry(1 ,'A' ,3));
   s138.addTransition(ScannerTransEntry(1 ,'a' ,3));
   s138.addTransition(ScannerTransEntry(2 ,'S' ,0));
   s138.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s138.addTransition(ScannerTransEntry(3 ,'L' ,4));
   s138.addTransition(ScannerTransEntry(3 ,'l' ,4));
   s138.addTransition(ScannerTransEntry(4 ,'L' ,5));
   s138.addTransition(ScannerTransEntry(4 ,'l' ,5));
   s138.addTransition(ScannerTransEntry(5 ,'I' ,6));
   s138.addTransition(ScannerTransEntry(5 ,'i' ,6));
   s138.addTransition(ScannerTransEntry(6 ,'N' ,7));
   s138.addTransition(ScannerTransEntry(6 ,'n' ,7));
   s138.addTransition(ScannerTransEntry(7 ,'T' ,8));
   s138.addTransition(ScannerTransEntry(7 ,'t' ,8));
   _scannerList.Insert(s138);

   Scanner s139(START_TOKEN);
   s139.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s139.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s139.addState(ScannerStateEntry(2 ,START));
   s139.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s139.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s139.addState(ScannerStateEntry(5 ,FINAL));
   s139.addTransition(ScannerTransEntry(0 ,'T' ,1));
   s139.addTransition(ScannerTransEntry(0 ,'t' ,1));
   s139.addTransition(ScannerTransEntry(1 ,'A' ,3));
   s139.addTransition(ScannerTransEntry(1 ,'a' ,3));
   s139.addTransition(ScannerTransEntry(2 ,'S' ,0));
   s139.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s139.addTransition(ScannerTransEntry(3 ,'R' ,4));
   s139.addTransition(ScannerTransEntry(3 ,'r' ,4));
   s139.addTransition(ScannerTransEntry(4 ,'T' ,5));
   s139.addTransition(ScannerTransEntry(4 ,'t' ,5));
   _scannerList.Insert(s139);

   Scanner s140(STRING);
   s140.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s140.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s140.addState(ScannerStateEntry(2 ,START));
   s140.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s140.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s140.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s140.addState(ScannerStateEntry(6 ,FINAL));
   s140.addTransition(ScannerTransEntry(0 ,'T' ,1));
   s140.addTransition(ScannerTransEntry(0 ,'t' ,1));
   s140.addTransition(ScannerTransEntry(1 ,'R' ,3));
   s140.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s140.addTransition(ScannerTransEntry(2 ,'S' ,0));
   s140.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s140.addTransition(ScannerTransEntry(3 ,'I' ,4));
   s140.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s140.addTransition(ScannerTransEntry(4 ,'N' ,5));
   s140.addTransition(ScannerTransEntry(4 ,'n' ,5));
   s140.addTransition(ScannerTransEntry(5 ,'G' ,6));
   s140.addTransition(ScannerTransEntry(5 ,'g' ,6));
   _scannerList.Insert(s140);

   Scanner s141(SUBSTR);
   s141.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s141.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s141.addState(ScannerStateEntry(2 ,START));
   s141.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s141.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s141.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s141.addState(ScannerStateEntry(6 ,FINAL));
   s141.addTransition(ScannerTransEntry(0 ,'U' ,1));
   s141.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s141.addTransition(ScannerTransEntry(1 ,'B' ,3));
   s141.addTransition(ScannerTransEntry(1 ,'b' ,3));
   s141.addTransition(ScannerTransEntry(2 ,'S' ,0));
   s141.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s141.addTransition(ScannerTransEntry(3 ,'S' ,4));
   s141.addTransition(ScannerTransEntry(3 ,'s' ,4));
   s141.addTransition(ScannerTransEntry(4 ,'T' ,5));
   s141.addTransition(ScannerTransEntry(4 ,'t' ,5));
   s141.addTransition(ScannerTransEntry(5 ,'R' ,6));
   s141.addTransition(ScannerTransEntry(5 ,'r' ,6));
   _scannerList.Insert(s141);

   Scanner s142(SUM);
   s142.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s142.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s142.addState(ScannerStateEntry(2 ,START));
   s142.addState(ScannerStateEntry(3 ,FINAL));
   s142.addTransition(ScannerTransEntry(0 ,'U' ,1));
   s142.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s142.addTransition(ScannerTransEntry(1 ,'M' ,3));
   s142.addTransition(ScannerTransEntry(1 ,'m' ,3));
   s142.addTransition(ScannerTransEntry(2 ,'S' ,0));
   s142.addTransition(ScannerTransEntry(2 ,'s' ,0));
   _scannerList.Insert(s142);

   Scanner s143(SYNC);
   s143.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s143.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s143.addState(ScannerStateEntry(2 ,START));
   s143.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s143.addState(ScannerStateEntry(4 ,FINAL));
   s143.addTransition(ScannerTransEntry(0 ,'Y' ,1));
   s143.addTransition(ScannerTransEntry(0 ,'y' ,1));
   s143.addTransition(ScannerTransEntry(1 ,'N' ,3));
   s143.addTransition(ScannerTransEntry(1 ,'n' ,3));
   s143.addTransition(ScannerTransEntry(2 ,'S' ,0));
   s143.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s143.addTransition(ScannerTransEntry(3 ,'C' ,4));
   s143.addTransition(ScannerTransEntry(3 ,'c' ,4));
   _scannerList.Insert(s143);

   Scanner s144(SYSDATE);
   s144.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s144.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s144.addState(ScannerStateEntry(2 ,START));
   s144.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s144.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s144.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s144.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s144.addState(ScannerStateEntry(7 ,FINAL));
   s144.addTransition(ScannerTransEntry(0 ,'Y' ,1));
   s144.addTransition(ScannerTransEntry(0 ,'y' ,1));
   s144.addTransition(ScannerTransEntry(1 ,'S' ,3));
   s144.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s144.addTransition(ScannerTransEntry(2 ,'S' ,0));
   s144.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s144.addTransition(ScannerTransEntry(3 ,'D' ,4));
   s144.addTransition(ScannerTransEntry(3 ,'d' ,4));
   s144.addTransition(ScannerTransEntry(4 ,'A' ,5));
   s144.addTransition(ScannerTransEntry(4 ,'a' ,5));
   s144.addTransition(ScannerTransEntry(5 ,'T' ,6));
   s144.addTransition(ScannerTransEntry(5 ,'t' ,6));
   s144.addTransition(ScannerTransEntry(6 ,'E' ,7));
   s144.addTransition(ScannerTransEntry(6 ,'e' ,7));
   _scannerList.Insert(s144);

   Scanner s145(SYSTEMSPACE);
   s145.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s145.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s145.addState(ScannerStateEntry(2 ,START));
   s145.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s145.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s145.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s145.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s145.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s145.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s145.addState(ScannerStateEntry(9 ,INTERMEDIATE));
   s145.addState(ScannerStateEntry(10 ,INTERMEDIATE));
   s145.addState(ScannerStateEntry(11 ,FINAL));
   s145.addTransition(ScannerTransEntry(0 ,'Y' ,1));
   s145.addTransition(ScannerTransEntry(0 ,'y' ,1));
   s145.addTransition(ScannerTransEntry(1 ,'S' ,3));
   s145.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s145.addTransition(ScannerTransEntry(2 ,'S' ,0));
   s145.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s145.addTransition(ScannerTransEntry(3 ,'T' ,4));
   s145.addTransition(ScannerTransEntry(3 ,'t' ,4));
   s145.addTransition(ScannerTransEntry(4 ,'E' ,5));
   s145.addTransition(ScannerTransEntry(4 ,'e' ,5));
   s145.addTransition(ScannerTransEntry(5 ,'M' ,6));
   s145.addTransition(ScannerTransEntry(5 ,'m' ,6));
   s145.addTransition(ScannerTransEntry(6 ,'S' ,7));
   s145.addTransition(ScannerTransEntry(6 ,'s' ,7));
   s145.addTransition(ScannerTransEntry(7 ,'P' ,8));
   s145.addTransition(ScannerTransEntry(7 ,'p' ,8));
   s145.addTransition(ScannerTransEntry(8 ,'A' ,9));
   s145.addTransition(ScannerTransEntry(8 ,'a' ,9));
   s145.addTransition(ScannerTransEntry(9 ,'C' ,10));
   s145.addTransition(ScannerTransEntry(9 ,'c' ,10));
   s145.addTransition(ScannerTransEntry(10 ,'E' ,11));
   s145.addTransition(ScannerTransEntry(10 ,'e' ,11));
   _scannerList.Insert(s145);

   Scanner s146(SYSOBJ);
   s146.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s146.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s146.addState(ScannerStateEntry(2 ,START));
   s146.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s146.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s146.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s146.addState(ScannerStateEntry(6 ,FINAL));
   s146.addTransition(ScannerTransEntry(0 ,'Y' ,1));
   s146.addTransition(ScannerTransEntry(0 ,'y' ,1));
   s146.addTransition(ScannerTransEntry(1 ,'S' ,3));
   s146.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s146.addTransition(ScannerTransEntry(2 ,'S' ,0));
   s146.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s146.addTransition(ScannerTransEntry(3 ,'O' ,4));
   s146.addTransition(ScannerTransEntry(3 ,'o' ,4));
   s146.addTransition(ScannerTransEntry(4 ,'B' ,5));
   s146.addTransition(ScannerTransEntry(4 ,'b' ,5));
   s146.addTransition(ScannerTransEntry(5 ,'J' ,6));
   s146.addTransition(ScannerTransEntry(5 ,'j' ,6));
   _scannerList.Insert(s146);

   Scanner s147(TABLEINFO);
   s147.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s147.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s147.addState(ScannerStateEntry(2 ,START));
   s147.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s147.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s147.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s147.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s147.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s147.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s147.addState(ScannerStateEntry(9 ,FINAL));
   s147.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s147.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s147.addTransition(ScannerTransEntry(1 ,'B' ,3));
   s147.addTransition(ScannerTransEntry(1 ,'b' ,3));
   s147.addTransition(ScannerTransEntry(2 ,'T' ,0));
   s147.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s147.addTransition(ScannerTransEntry(3 ,'L' ,4));
   s147.addTransition(ScannerTransEntry(3 ,'l' ,4));
   s147.addTransition(ScannerTransEntry(4 ,'E' ,5));
   s147.addTransition(ScannerTransEntry(4 ,'e' ,5));
   s147.addTransition(ScannerTransEntry(5 ,'I' ,6));
   s147.addTransition(ScannerTransEntry(5 ,'i' ,6));
   s147.addTransition(ScannerTransEntry(6 ,'N' ,7));
   s147.addTransition(ScannerTransEntry(6 ,'n' ,7));
   s147.addTransition(ScannerTransEntry(7 ,'F' ,8));
   s147.addTransition(ScannerTransEntry(7 ,'f' ,8));
   s147.addTransition(ScannerTransEntry(8 ,'O' ,9));
   s147.addTransition(ScannerTransEntry(8 ,'o' ,9));
   _scannerList.Insert(s147);

   Scanner s148(TABLESIZE);
   s148.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s148.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s148.addState(ScannerStateEntry(2 ,START));
   s148.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s148.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s148.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s148.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s148.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s148.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s148.addState(ScannerStateEntry(9 ,FINAL));
   s148.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s148.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s148.addTransition(ScannerTransEntry(1 ,'B' ,3));
   s148.addTransition(ScannerTransEntry(1 ,'b' ,3));
   s148.addTransition(ScannerTransEntry(2 ,'T' ,0));
   s148.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s148.addTransition(ScannerTransEntry(3 ,'L' ,4));
   s148.addTransition(ScannerTransEntry(3 ,'l' ,4));
   s148.addTransition(ScannerTransEntry(4 ,'E' ,5));
   s148.addTransition(ScannerTransEntry(4 ,'e' ,5));
   s148.addTransition(ScannerTransEntry(5 ,'S' ,6));
   s148.addTransition(ScannerTransEntry(5 ,'s' ,6));
   s148.addTransition(ScannerTransEntry(6 ,'I' ,7));
   s148.addTransition(ScannerTransEntry(6 ,'i' ,7));
   s148.addTransition(ScannerTransEntry(7 ,'Z' ,8));
   s148.addTransition(ScannerTransEntry(7 ,'z' ,8));
   s148.addTransition(ScannerTransEntry(8 ,'E' ,9));
   s148.addTransition(ScannerTransEntry(8 ,'e' ,9));
   _scannerList.Insert(s148);

   Scanner s149(TABLE);
   s149.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s149.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s149.addState(ScannerStateEntry(2 ,START));
   s149.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s149.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s149.addState(ScannerStateEntry(5 ,FINAL));
   s149.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s149.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s149.addTransition(ScannerTransEntry(1 ,'B' ,3));
   s149.addTransition(ScannerTransEntry(1 ,'b' ,3));
   s149.addTransition(ScannerTransEntry(2 ,'T' ,0));
   s149.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s149.addTransition(ScannerTransEntry(3 ,'L' ,4));
   s149.addTransition(ScannerTransEntry(3 ,'l' ,4));
   s149.addTransition(ScannerTransEntry(4 ,'E' ,5));
   s149.addTransition(ScannerTransEntry(4 ,'e' ,5));
   _scannerList.Insert(s149);

   Scanner s150(TABLESET);
   s150.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s150.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s150.addState(ScannerStateEntry(2 ,START));
   s150.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s150.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s150.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s150.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s150.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s150.addState(ScannerStateEntry(8 ,FINAL));
   s150.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s150.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s150.addTransition(ScannerTransEntry(1 ,'B' ,3));
   s150.addTransition(ScannerTransEntry(1 ,'b' ,3));
   s150.addTransition(ScannerTransEntry(2 ,'T' ,0));
   s150.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s150.addTransition(ScannerTransEntry(3 ,'L' ,4));
   s150.addTransition(ScannerTransEntry(3 ,'l' ,4));
   s150.addTransition(ScannerTransEntry(4 ,'E' ,5));
   s150.addTransition(ScannerTransEntry(4 ,'e' ,5));
   s150.addTransition(ScannerTransEntry(5 ,'S' ,6));
   s150.addTransition(ScannerTransEntry(5 ,'s' ,6));
   s150.addTransition(ScannerTransEntry(6 ,'E' ,7));
   s150.addTransition(ScannerTransEntry(6 ,'e' ,7));
   s150.addTransition(ScannerTransEntry(7 ,'T' ,8));
   s150.addTransition(ScannerTransEntry(7 ,'t' ,8));
   _scannerList.Insert(s150);

   Scanner s151(THEN);
   s151.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s151.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s151.addState(ScannerStateEntry(2 ,START));
   s151.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s151.addState(ScannerStateEntry(4 ,FINAL));
   s151.addTransition(ScannerTransEntry(0 ,'H' ,1));
   s151.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s151.addTransition(ScannerTransEntry(1 ,'E' ,3));
   s151.addTransition(ScannerTransEntry(1 ,'e' ,3));
   s151.addTransition(ScannerTransEntry(2 ,'T' ,0));
   s151.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s151.addTransition(ScannerTransEntry(3 ,'N' ,4));
   s151.addTransition(ScannerTransEntry(3 ,'n' ,4));
   _scannerList.Insert(s151);

   Scanner s152(THROW);
   s152.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s152.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s152.addState(ScannerStateEntry(2 ,START));
   s152.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s152.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s152.addState(ScannerStateEntry(5 ,FINAL));
   s152.addTransition(ScannerTransEntry(0 ,'H' ,1));
   s152.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s152.addTransition(ScannerTransEntry(1 ,'R' ,3));
   s152.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s152.addTransition(ScannerTransEntry(2 ,'T' ,0));
   s152.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s152.addTransition(ScannerTransEntry(3 ,'O' ,4));
   s152.addTransition(ScannerTransEntry(3 ,'o' ,4));
   s152.addTransition(ScannerTransEntry(4 ,'W' ,5));
   s152.addTransition(ScannerTransEntry(4 ,'w' ,5));
   _scannerList.Insert(s152);

   Scanner s153(TINYINT);
   s153.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s153.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s153.addState(ScannerStateEntry(2 ,START));
   s153.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s153.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s153.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s153.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s153.addState(ScannerStateEntry(7 ,FINAL));
   s153.addTransition(ScannerTransEntry(0 ,'I' ,1));
   s153.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s153.addTransition(ScannerTransEntry(1 ,'N' ,3));
   s153.addTransition(ScannerTransEntry(1 ,'n' ,3));
   s153.addTransition(ScannerTransEntry(2 ,'T' ,0));
   s153.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s153.addTransition(ScannerTransEntry(3 ,'Y' ,4));
   s153.addTransition(ScannerTransEntry(3 ,'y' ,4));
   s153.addTransition(ScannerTransEntry(4 ,'I' ,5));
   s153.addTransition(ScannerTransEntry(4 ,'i' ,5));
   s153.addTransition(ScannerTransEntry(5 ,'N' ,6));
   s153.addTransition(ScannerTransEntry(5 ,'n' ,6));
   s153.addTransition(ScannerTransEntry(6 ,'T' ,7));
   s153.addTransition(ScannerTransEntry(6 ,'t' ,7));
   _scannerList.Insert(s153);

   Scanner s154(TMPOBJ);
   s154.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s154.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s154.addState(ScannerStateEntry(2 ,START));
   s154.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s154.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s154.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s154.addState(ScannerStateEntry(6 ,FINAL));
   s154.addTransition(ScannerTransEntry(0 ,'M' ,1));
   s154.addTransition(ScannerTransEntry(0 ,'m' ,1));
   s154.addTransition(ScannerTransEntry(1 ,'P' ,3));
   s154.addTransition(ScannerTransEntry(1 ,'p' ,3));
   s154.addTransition(ScannerTransEntry(2 ,'T' ,0));
   s154.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s154.addTransition(ScannerTransEntry(3 ,'O' ,4));
   s154.addTransition(ScannerTransEntry(3 ,'o' ,4));
   s154.addTransition(ScannerTransEntry(4 ,'B' ,5));
   s154.addTransition(ScannerTransEntry(4 ,'b' ,5));
   s154.addTransition(ScannerTransEntry(5 ,'J' ,6));
   s154.addTransition(ScannerTransEntry(5 ,'j' ,6));
   _scannerList.Insert(s154);

   Scanner s155(TRANSACTION);
   s155.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s155.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s155.addState(ScannerStateEntry(2 ,START));
   s155.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s155.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s155.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s155.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s155.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s155.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s155.addState(ScannerStateEntry(9 ,INTERMEDIATE));
   s155.addState(ScannerStateEntry(10 ,INTERMEDIATE));
   s155.addState(ScannerStateEntry(11 ,FINAL));
   s155.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s155.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s155.addTransition(ScannerTransEntry(1 ,'A' ,3));
   s155.addTransition(ScannerTransEntry(1 ,'a' ,3));
   s155.addTransition(ScannerTransEntry(2 ,'T' ,0));
   s155.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s155.addTransition(ScannerTransEntry(3 ,'N' ,4));
   s155.addTransition(ScannerTransEntry(3 ,'n' ,4));
   s155.addTransition(ScannerTransEntry(4 ,'S' ,5));
   s155.addTransition(ScannerTransEntry(4 ,'s' ,5));
   s155.addTransition(ScannerTransEntry(5 ,'A' ,6));
   s155.addTransition(ScannerTransEntry(5 ,'a' ,6));
   s155.addTransition(ScannerTransEntry(6 ,'C' ,7));
   s155.addTransition(ScannerTransEntry(6 ,'c' ,7));
   s155.addTransition(ScannerTransEntry(7 ,'T' ,8));
   s155.addTransition(ScannerTransEntry(7 ,'t' ,8));
   s155.addTransition(ScannerTransEntry(8 ,'I' ,9));
   s155.addTransition(ScannerTransEntry(8 ,'i' ,9));
   s155.addTransition(ScannerTransEntry(9 ,'O' ,10));
   s155.addTransition(ScannerTransEntry(9 ,'o' ,10));
   s155.addTransition(ScannerTransEntry(10 ,'N' ,11));
   s155.addTransition(ScannerTransEntry(10 ,'n' ,11));
   _scannerList.Insert(s155);

   Scanner s156(TRIGGER);
   s156.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s156.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s156.addState(ScannerStateEntry(2 ,START));
   s156.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s156.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s156.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s156.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s156.addState(ScannerStateEntry(7 ,FINAL));
   s156.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s156.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s156.addTransition(ScannerTransEntry(1 ,'I' ,3));
   s156.addTransition(ScannerTransEntry(1 ,'i' ,3));
   s156.addTransition(ScannerTransEntry(2 ,'T' ,0));
   s156.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s156.addTransition(ScannerTransEntry(3 ,'G' ,4));
   s156.addTransition(ScannerTransEntry(3 ,'g' ,4));
   s156.addTransition(ScannerTransEntry(4 ,'G' ,5));
   s156.addTransition(ScannerTransEntry(4 ,'g' ,5));
   s156.addTransition(ScannerTransEntry(5 ,'E' ,6));
   s156.addTransition(ScannerTransEntry(5 ,'e' ,6));
   s156.addTransition(ScannerTransEntry(6 ,'R' ,7));
   s156.addTransition(ScannerTransEntry(6 ,'r' ,7));
   _scannerList.Insert(s156);

   Scanner s157(TUPLEINFO);
   s157.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s157.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s157.addState(ScannerStateEntry(2 ,START));
   s157.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s157.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s157.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s157.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s157.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s157.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s157.addState(ScannerStateEntry(9 ,FINAL));
   s157.addTransition(ScannerTransEntry(0 ,'U' ,1));
   s157.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s157.addTransition(ScannerTransEntry(1 ,'P' ,3));
   s157.addTransition(ScannerTransEntry(1 ,'p' ,3));
   s157.addTransition(ScannerTransEntry(2 ,'T' ,0));
   s157.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s157.addTransition(ScannerTransEntry(3 ,'L' ,4));
   s157.addTransition(ScannerTransEntry(3 ,'l' ,4));
   s157.addTransition(ScannerTransEntry(4 ,'E' ,5));
   s157.addTransition(ScannerTransEntry(4 ,'e' ,5));
   s157.addTransition(ScannerTransEntry(5 ,'I' ,6));
   s157.addTransition(ScannerTransEntry(5 ,'i' ,6));
   s157.addTransition(ScannerTransEntry(6 ,'N' ,7));
   s157.addTransition(ScannerTransEntry(6 ,'n' ,7));
   s157.addTransition(ScannerTransEntry(7 ,'F' ,8));
   s157.addTransition(ScannerTransEntry(7 ,'f' ,8));
   s157.addTransition(ScannerTransEntry(8 ,'O' ,9));
   s157.addTransition(ScannerTransEntry(8 ,'o' ,9));
   _scannerList.Insert(s157);

   Scanner s158(STR2INT);
   s158.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s158.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s158.addState(ScannerStateEntry(2 ,START));
   s158.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s158.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s158.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s158.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s158.addState(ScannerStateEntry(7 ,FINAL));
   s158.addTransition(ScannerTransEntry(0 ,'T' ,1));
   s158.addTransition(ScannerTransEntry(0 ,'t' ,1));
   s158.addTransition(ScannerTransEntry(1 ,'R' ,3));
   s158.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s158.addTransition(ScannerTransEntry(2 ,'S' ,0));
   s158.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s158.addTransition(ScannerTransEntry(3 ,'2' ,4));
   s158.addTransition(ScannerTransEntry(4 ,'I' ,5));
   s158.addTransition(ScannerTransEntry(4 ,'i' ,5));
   s158.addTransition(ScannerTransEntry(5 ,'N' ,6));
   s158.addTransition(ScannerTransEntry(5 ,'n' ,6));
   s158.addTransition(ScannerTransEntry(6 ,'T' ,7));
   s158.addTransition(ScannerTransEntry(6 ,'t' ,7));
   _scannerList.Insert(s158);

   Scanner s159(STR2LONG);
   s159.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s159.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s159.addState(ScannerStateEntry(2 ,START));
   s159.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s159.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s159.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s159.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s159.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s159.addState(ScannerStateEntry(8 ,FINAL));
   s159.addTransition(ScannerTransEntry(0 ,'T' ,1));
   s159.addTransition(ScannerTransEntry(0 ,'t' ,1));
   s159.addTransition(ScannerTransEntry(1 ,'R' ,3));
   s159.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s159.addTransition(ScannerTransEntry(2 ,'S' ,0));
   s159.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s159.addTransition(ScannerTransEntry(3 ,'2' ,4));
   s159.addTransition(ScannerTransEntry(4 ,'L' ,5));
   s159.addTransition(ScannerTransEntry(4 ,'l' ,5));
   s159.addTransition(ScannerTransEntry(5 ,'O' ,6));
   s159.addTransition(ScannerTransEntry(5 ,'o' ,6));
   s159.addTransition(ScannerTransEntry(6 ,'N' ,7));
   s159.addTransition(ScannerTransEntry(6 ,'n' ,7));
   s159.addTransition(ScannerTransEntry(7 ,'G' ,8));
   s159.addTransition(ScannerTransEntry(7 ,'g' ,8));
   _scannerList.Insert(s159);

   Scanner s160(STR2DATE);
   s160.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s160.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s160.addState(ScannerStateEntry(2 ,START));
   s160.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s160.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s160.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s160.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s160.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s160.addState(ScannerStateEntry(8 ,FINAL));
   s160.addTransition(ScannerTransEntry(0 ,'T' ,1));
   s160.addTransition(ScannerTransEntry(0 ,'t' ,1));
   s160.addTransition(ScannerTransEntry(1 ,'R' ,3));
   s160.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s160.addTransition(ScannerTransEntry(2 ,'S' ,0));
   s160.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s160.addTransition(ScannerTransEntry(3 ,'2' ,4));
   s160.addTransition(ScannerTransEntry(4 ,'D' ,5));
   s160.addTransition(ScannerTransEntry(4 ,'d' ,5));
   s160.addTransition(ScannerTransEntry(5 ,'A' ,6));
   s160.addTransition(ScannerTransEntry(5 ,'a' ,6));
   s160.addTransition(ScannerTransEntry(6 ,'T' ,7));
   s160.addTransition(ScannerTransEntry(6 ,'t' ,7));
   s160.addTransition(ScannerTransEntry(7 ,'E' ,8));
   s160.addTransition(ScannerTransEntry(7 ,'e' ,8));
   _scannerList.Insert(s160);

   Scanner s161(TO);
   s161.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s161.addState(ScannerStateEntry(1 ,FINAL));
   s161.addState(ScannerStateEntry(2 ,START));
   s161.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s161.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s161.addTransition(ScannerTransEntry(2 ,'T' ,0));
   s161.addTransition(ScannerTransEntry(2 ,'t' ,0));
   _scannerList.Insert(s161);

   Scanner s162(TRIM);
   s162.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s162.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s162.addState(ScannerStateEntry(2 ,START));
   s162.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s162.addState(ScannerStateEntry(4 ,FINAL));
   s162.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s162.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s162.addTransition(ScannerTransEntry(1 ,'I' ,3));
   s162.addTransition(ScannerTransEntry(1 ,'i' ,3));
   s162.addTransition(ScannerTransEntry(2 ,'T' ,0));
   s162.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s162.addTransition(ScannerTransEntry(3 ,'M' ,4));
   s162.addTransition(ScannerTransEntry(3 ,'m' ,4));
   _scannerList.Insert(s162);

   Scanner s163(TRUEVAL);
   s163.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s163.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s163.addState(ScannerStateEntry(2 ,START));
   s163.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s163.addState(ScannerStateEntry(4 ,FINAL));
   s163.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s163.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s163.addTransition(ScannerTransEntry(1 ,'U' ,3));
   s163.addTransition(ScannerTransEntry(1 ,'u' ,3));
   s163.addTransition(ScannerTransEntry(2 ,'T' ,0));
   s163.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s163.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s163.addTransition(ScannerTransEntry(3 ,'e' ,4));
   _scannerList.Insert(s163);

   Scanner s164(TRUNC);
   s164.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s164.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s164.addState(ScannerStateEntry(2 ,START));
   s164.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s164.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s164.addState(ScannerStateEntry(5 ,FINAL));
   s164.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s164.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s164.addTransition(ScannerTransEntry(1 ,'U' ,3));
   s164.addTransition(ScannerTransEntry(1 ,'u' ,3));
   s164.addTransition(ScannerTransEntry(2 ,'T' ,0));
   s164.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s164.addTransition(ScannerTransEntry(3 ,'N' ,4));
   s164.addTransition(ScannerTransEntry(3 ,'n' ,4));
   s164.addTransition(ScannerTransEntry(4 ,'C' ,5));
   s164.addTransition(ScannerTransEntry(4 ,'c' ,5));
   _scannerList.Insert(s164);

   Scanner s165(TRUNCATE);
   s165.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s165.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s165.addState(ScannerStateEntry(2 ,START));
   s165.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s165.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s165.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s165.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s165.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s165.addState(ScannerStateEntry(8 ,FINAL));
   s165.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s165.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s165.addTransition(ScannerTransEntry(1 ,'U' ,3));
   s165.addTransition(ScannerTransEntry(1 ,'u' ,3));
   s165.addTransition(ScannerTransEntry(2 ,'T' ,0));
   s165.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s165.addTransition(ScannerTransEntry(3 ,'N' ,4));
   s165.addTransition(ScannerTransEntry(3 ,'n' ,4));
   s165.addTransition(ScannerTransEntry(4 ,'C' ,5));
   s165.addTransition(ScannerTransEntry(4 ,'c' ,5));
   s165.addTransition(ScannerTransEntry(5 ,'A' ,6));
   s165.addTransition(ScannerTransEntry(5 ,'a' ,6));
   s165.addTransition(ScannerTransEntry(6 ,'T' ,7));
   s165.addTransition(ScannerTransEntry(6 ,'t' ,7));
   s165.addTransition(ScannerTransEntry(7 ,'E' ,8));
   s165.addTransition(ScannerTransEntry(7 ,'e' ,8));
   _scannerList.Insert(s165);

   Scanner s166(UNION);
   s166.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s166.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s166.addState(ScannerStateEntry(2 ,START));
   s166.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s166.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s166.addState(ScannerStateEntry(5 ,FINAL));
   s166.addTransition(ScannerTransEntry(0 ,'N' ,1));
   s166.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s166.addTransition(ScannerTransEntry(1 ,'I' ,3));
   s166.addTransition(ScannerTransEntry(1 ,'i' ,3));
   s166.addTransition(ScannerTransEntry(2 ,'U' ,0));
   s166.addTransition(ScannerTransEntry(2 ,'u' ,0));
   s166.addTransition(ScannerTransEntry(3 ,'O' ,4));
   s166.addTransition(ScannerTransEntry(3 ,'o' ,4));
   s166.addTransition(ScannerTransEntry(4 ,'N' ,5));
   s166.addTransition(ScannerTransEntry(4 ,'n' ,5));
   _scannerList.Insert(s166);

   Scanner s167(UNIQUE);
   s167.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s167.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s167.addState(ScannerStateEntry(2 ,START));
   s167.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s167.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s167.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s167.addState(ScannerStateEntry(6 ,FINAL));
   s167.addTransition(ScannerTransEntry(0 ,'N' ,1));
   s167.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s167.addTransition(ScannerTransEntry(1 ,'I' ,3));
   s167.addTransition(ScannerTransEntry(1 ,'i' ,3));
   s167.addTransition(ScannerTransEntry(2 ,'U' ,0));
   s167.addTransition(ScannerTransEntry(2 ,'u' ,0));
   s167.addTransition(ScannerTransEntry(3 ,'Q' ,4));
   s167.addTransition(ScannerTransEntry(3 ,'q' ,4));
   s167.addTransition(ScannerTransEntry(4 ,'U' ,5));
   s167.addTransition(ScannerTransEntry(4 ,'u' ,5));
   s167.addTransition(ScannerTransEntry(5 ,'E' ,6));
   s167.addTransition(ScannerTransEntry(5 ,'e' ,6));
   _scannerList.Insert(s167);

   Scanner s168(UPDATE);
   s168.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s168.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s168.addState(ScannerStateEntry(2 ,START));
   s168.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s168.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s168.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s168.addState(ScannerStateEntry(6 ,FINAL));
   s168.addTransition(ScannerTransEntry(0 ,'P' ,1));
   s168.addTransition(ScannerTransEntry(0 ,'p' ,1));
   s168.addTransition(ScannerTransEntry(1 ,'D' ,3));
   s168.addTransition(ScannerTransEntry(1 ,'d' ,3));
   s168.addTransition(ScannerTransEntry(2 ,'U' ,0));
   s168.addTransition(ScannerTransEntry(2 ,'u' ,0));
   s168.addTransition(ScannerTransEntry(3 ,'A' ,4));
   s168.addTransition(ScannerTransEntry(3 ,'a' ,4));
   s168.addTransition(ScannerTransEntry(4 ,'T' ,5));
   s168.addTransition(ScannerTransEntry(4 ,'t' ,5));
   s168.addTransition(ScannerTransEntry(5 ,'E' ,6));
   s168.addTransition(ScannerTransEntry(5 ,'e' ,6));
   _scannerList.Insert(s168);

   Scanner s169(UPTIME);
   s169.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s169.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s169.addState(ScannerStateEntry(2 ,START));
   s169.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s169.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s169.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s169.addState(ScannerStateEntry(6 ,FINAL));
   s169.addTransition(ScannerTransEntry(0 ,'P' ,1));
   s169.addTransition(ScannerTransEntry(0 ,'p' ,1));
   s169.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s169.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s169.addTransition(ScannerTransEntry(2 ,'U' ,0));
   s169.addTransition(ScannerTransEntry(2 ,'u' ,0));
   s169.addTransition(ScannerTransEntry(3 ,'I' ,4));
   s169.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s169.addTransition(ScannerTransEntry(4 ,'M' ,5));
   s169.addTransition(ScannerTransEntry(4 ,'m' ,5));
   s169.addTransition(ScannerTransEntry(5 ,'E' ,6));
   s169.addTransition(ScannerTransEntry(5 ,'e' ,6));
   _scannerList.Insert(s169);

   Scanner s170(UPPER);
   s170.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s170.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s170.addState(ScannerStateEntry(2 ,START));
   s170.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s170.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s170.addState(ScannerStateEntry(5 ,FINAL));
   s170.addTransition(ScannerTransEntry(0 ,'P' ,1));
   s170.addTransition(ScannerTransEntry(0 ,'p' ,1));
   s170.addTransition(ScannerTransEntry(1 ,'P' ,3));
   s170.addTransition(ScannerTransEntry(1 ,'p' ,3));
   s170.addTransition(ScannerTransEntry(2 ,'U' ,0));
   s170.addTransition(ScannerTransEntry(2 ,'u' ,0));
   s170.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s170.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s170.addTransition(ScannerTransEntry(4 ,'R' ,5));
   s170.addTransition(ScannerTransEntry(4 ,'r' ,5));
   _scannerList.Insert(s170);

   Scanner s171(VAR);
   s171.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s171.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s171.addState(ScannerStateEntry(2 ,START));
   s171.addState(ScannerStateEntry(3 ,FINAL));
   s171.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s171.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s171.addTransition(ScannerTransEntry(1 ,'R' ,3));
   s171.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s171.addTransition(ScannerTransEntry(2 ,'V' ,0));
   s171.addTransition(ScannerTransEntry(2 ,'v' ,0));
   _scannerList.Insert(s171);

   Scanner s172(VALUES);
   s172.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s172.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s172.addState(ScannerStateEntry(2 ,START));
   s172.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s172.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s172.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s172.addState(ScannerStateEntry(6 ,FINAL));
   s172.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s172.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s172.addTransition(ScannerTransEntry(1 ,'L' ,3));
   s172.addTransition(ScannerTransEntry(1 ,'l' ,3));
   s172.addTransition(ScannerTransEntry(2 ,'V' ,0));
   s172.addTransition(ScannerTransEntry(2 ,'v' ,0));
   s172.addTransition(ScannerTransEntry(3 ,'U' ,4));
   s172.addTransition(ScannerTransEntry(3 ,'u' ,4));
   s172.addTransition(ScannerTransEntry(4 ,'E' ,5));
   s172.addTransition(ScannerTransEntry(4 ,'e' ,5));
   s172.addTransition(ScannerTransEntry(5 ,'S' ,6));
   s172.addTransition(ScannerTransEntry(5 ,'s' ,6));
   _scannerList.Insert(s172);

   Scanner s173(VIEW);
   s173.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s173.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s173.addState(ScannerStateEntry(2 ,START));
   s173.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s173.addState(ScannerStateEntry(4 ,FINAL));
   s173.addTransition(ScannerTransEntry(0 ,'I' ,1));
   s173.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s173.addTransition(ScannerTransEntry(1 ,'E' ,3));
   s173.addTransition(ScannerTransEntry(1 ,'e' ,3));
   s173.addTransition(ScannerTransEntry(2 ,'V' ,0));
   s173.addTransition(ScannerTransEntry(2 ,'v' ,0));
   s173.addTransition(ScannerTransEntry(3 ,'W' ,4));
   s173.addTransition(ScannerTransEntry(3 ,'w' ,4));
   _scannerList.Insert(s173);

   Scanner s174(WHEN);
   s174.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s174.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s174.addState(ScannerStateEntry(2 ,START));
   s174.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s174.addState(ScannerStateEntry(4 ,FINAL));
   s174.addTransition(ScannerTransEntry(0 ,'H' ,1));
   s174.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s174.addTransition(ScannerTransEntry(1 ,'E' ,3));
   s174.addTransition(ScannerTransEntry(1 ,'e' ,3));
   s174.addTransition(ScannerTransEntry(2 ,'W' ,0));
   s174.addTransition(ScannerTransEntry(2 ,'w' ,0));
   s174.addTransition(ScannerTransEntry(3 ,'N' ,4));
   s174.addTransition(ScannerTransEntry(3 ,'n' ,4));
   _scannerList.Insert(s174);

   Scanner s175(WHERE);
   s175.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s175.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s175.addState(ScannerStateEntry(2 ,START));
   s175.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s175.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s175.addState(ScannerStateEntry(5 ,FINAL));
   s175.addTransition(ScannerTransEntry(0 ,'H' ,1));
   s175.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s175.addTransition(ScannerTransEntry(1 ,'E' ,3));
   s175.addTransition(ScannerTransEntry(1 ,'e' ,3));
   s175.addTransition(ScannerTransEntry(2 ,'W' ,0));
   s175.addTransition(ScannerTransEntry(2 ,'w' ,0));
   s175.addTransition(ScannerTransEntry(3 ,'R' ,4));
   s175.addTransition(ScannerTransEntry(3 ,'r' ,4));
   s175.addTransition(ScannerTransEntry(4 ,'E' ,5));
   s175.addTransition(ScannerTransEntry(4 ,'e' ,5));
   _scannerList.Insert(s175);

   Scanner s176(WHILE);
   s176.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s176.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s176.addState(ScannerStateEntry(2 ,START));
   s176.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s176.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s176.addState(ScannerStateEntry(5 ,FINAL));
   s176.addTransition(ScannerTransEntry(0 ,'H' ,1));
   s176.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s176.addTransition(ScannerTransEntry(1 ,'I' ,3));
   s176.addTransition(ScannerTransEntry(1 ,'i' ,3));
   s176.addTransition(ScannerTransEntry(2 ,'W' ,0));
   s176.addTransition(ScannerTransEntry(2 ,'w' ,0));
   s176.addTransition(ScannerTransEntry(3 ,'L' ,4));
   s176.addTransition(ScannerTransEntry(3 ,'l' ,4));
   s176.addTransition(ScannerTransEntry(4 ,'E' ,5));
   s176.addTransition(ScannerTransEntry(4 ,'e' ,5));
   _scannerList.Insert(s176);

   Scanner s177(CONCAT);
   s177.addState(ScannerStateEntry(0 ,START));
   s177.addState(ScannerStateEntry(1 ,FINAL));
   s177.addTransition(ScannerTransEntry(0 ,'|' ,1));
   _scannerList.Insert(s177);

   Scanner s178(EQU);
   s178.addState(ScannerStateEntry(0 ,START));
   s178.addState(ScannerStateEntry(1 ,FINAL));
   s178.addTransition(ScannerTransEntry(0 ,'=' ,1));
   _scannerList.Insert(s178);

   Scanner s179(KSEP);
   s179.addState(ScannerStateEntry(0 ,START));
   s179.addState(ScannerStateEntry(1 ,FINAL));
   s179.addTransition(ScannerTransEntry(0 ,',' ,1));
   _scannerList.Insert(s179);

   Scanner s180(LB);
   s180.addState(ScannerStateEntry(0 ,START));
   s180.addState(ScannerStateEntry(1 ,FINAL));
   s180.addTransition(ScannerTransEntry(0 ,'(' ,1));
   _scannerList.Insert(s180);

   Scanner s181(LT);
   s181.addState(ScannerStateEntry(0 ,START));
   s181.addState(ScannerStateEntry(1 ,FINAL));
   s181.addTransition(ScannerTransEntry(0 ,'<' ,1));
   _scannerList.Insert(s181);

   Scanner s182(MT);
   s182.addState(ScannerStateEntry(0 ,START));
   s182.addState(ScannerStateEntry(1 ,FINAL));
   s182.addTransition(ScannerTransEntry(0 ,'>' ,1));
   _scannerList.Insert(s182);

   Scanner s183(NEGATION);
   s183.addState(ScannerStateEntry(0 ,START));
   s183.addState(ScannerStateEntry(1 ,FINAL));
   s183.addTransition(ScannerTransEntry(0 ,'!' ,1));
   _scannerList.Insert(s183);

   Scanner s184(RB);
   s184.addState(ScannerStateEntry(0 ,START));
   s184.addState(ScannerStateEntry(1 ,FINAL));
   s184.addTransition(ScannerTransEntry(0 ,')' ,1));
   _scannerList.Insert(s184);

   Scanner s185(LAB);
   s185.addState(ScannerStateEntry(0 ,START));
   s185.addState(ScannerStateEntry(1 ,FINAL));
   s185.addTransition(ScannerTransEntry(0 ,'[' ,1));
   _scannerList.Insert(s185);

   Scanner s186(RAB);
   s186.addState(ScannerStateEntry(0 ,START));
   s186.addState(ScannerStateEntry(1 ,FINAL));
   s186.addTransition(ScannerTransEntry(0 ,']' ,1));
   _scannerList.Insert(s186);

   Scanner s187(SEMICOLON);
   s187.addState(ScannerStateEntry(0 ,START));
   s187.addState(ScannerStateEntry(1 ,FINAL));
   s187.addTransition(ScannerTransEntry(0 ,';' ,1));
   _scannerList.Insert(s187);

   Scanner s188(STAR);
   s188.addState(ScannerStateEntry(0 ,START));
   s188.addState(ScannerStateEntry(1 ,FINAL));
   s188.addTransition(ScannerTransEntry(0 ,'*' ,1));
   _scannerList.Insert(s188);

   Scanner s189(DIVISION);
   s189.addState(ScannerStateEntry(0 ,START));
   s189.addState(ScannerStateEntry(1 ,FINAL));
   s189.addTransition(ScannerTransEntry(0 ,'/' ,1));
   _scannerList.Insert(s189);

   Scanner s190(MINUS);
   s190.addState(ScannerStateEntry(0 ,START));
   s190.addState(ScannerStateEntry(1 ,FINAL));
   s190.addTransition(ScannerTransEntry(0 ,'-' ,1));
   _scannerList.Insert(s190);

   Scanner s191(PLUS);
   s191.addState(ScannerStateEntry(0 ,START));
   s191.addState(ScannerStateEntry(1 ,FINAL));
   s191.addTransition(ScannerTransEntry(0 ,'+' ,1));
   _scannerList.Insert(s191);

   Scanner s192(INTVAL);
   s192.addState(ScannerStateEntry(0 ,START));
   s192.addState(ScannerStateEntry(1 ,FINAL));
   s192.addState(ScannerStateEntry(2 ,FINAL));
   s192.addTransition(ScannerTransEntry(0 ,'1' ,1));
   s192.addTransition(ScannerTransEntry(0 ,'2' ,1));
   s192.addTransition(ScannerTransEntry(0 ,'3' ,1));
   s192.addTransition(ScannerTransEntry(0 ,'4' ,1));
   s192.addTransition(ScannerTransEntry(0 ,'5' ,1));
   s192.addTransition(ScannerTransEntry(0 ,'6' ,1));
   s192.addTransition(ScannerTransEntry(0 ,'7' ,1));
   s192.addTransition(ScannerTransEntry(0 ,'8' ,1));
   s192.addTransition(ScannerTransEntry(0 ,'9' ,1));
   s192.addTransition(ScannerTransEntry(0 ,'0' ,2));
   s192.addTransition(ScannerTransEntry(1 ,'0' ,1));
   s192.addTransition(ScannerTransEntry(1 ,'1' ,1));
   s192.addTransition(ScannerTransEntry(1 ,'2' ,1));
   s192.addTransition(ScannerTransEntry(1 ,'3' ,1));
   s192.addTransition(ScannerTransEntry(1 ,'4' ,1));
   s192.addTransition(ScannerTransEntry(1 ,'5' ,1));
   s192.addTransition(ScannerTransEntry(1 ,'6' ,1));
   s192.addTransition(ScannerTransEntry(1 ,'7' ,1));
   s192.addTransition(ScannerTransEntry(1 ,'8' ,1));
   s192.addTransition(ScannerTransEntry(1 ,'9' ,1));
   _scannerList.Insert(s192);

   Scanner s193(FLOATVAL);
   s193.addState(ScannerStateEntry(0 ,START));
   s193.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s193.addState(ScannerStateEntry(2 ,INTERMEDIATE));
   s193.addState(ScannerStateEntry(3 ,FINAL));
   s193.addTransition(ScannerTransEntry(0 ,'1' ,1));
   s193.addTransition(ScannerTransEntry(0 ,'2' ,1));
   s193.addTransition(ScannerTransEntry(0 ,'3' ,1));
   s193.addTransition(ScannerTransEntry(0 ,'4' ,1));
   s193.addTransition(ScannerTransEntry(0 ,'5' ,1));
   s193.addTransition(ScannerTransEntry(0 ,'6' ,1));
   s193.addTransition(ScannerTransEntry(0 ,'7' ,1));
   s193.addTransition(ScannerTransEntry(0 ,'8' ,1));
   s193.addTransition(ScannerTransEntry(0 ,'9' ,1));
   s193.addTransition(ScannerTransEntry(0 ,'0' ,2));
   s193.addTransition(ScannerTransEntry(1 ,'0' ,1));
   s193.addTransition(ScannerTransEntry(1 ,'1' ,1));
   s193.addTransition(ScannerTransEntry(1 ,'2' ,1));
   s193.addTransition(ScannerTransEntry(1 ,'3' ,1));
   s193.addTransition(ScannerTransEntry(1 ,'4' ,1));
   s193.addTransition(ScannerTransEntry(1 ,'5' ,1));
   s193.addTransition(ScannerTransEntry(1 ,'6' ,1));
   s193.addTransition(ScannerTransEntry(1 ,'7' ,1));
   s193.addTransition(ScannerTransEntry(1 ,'8' ,1));
   s193.addTransition(ScannerTransEntry(1 ,'9' ,1));
   s193.addTransition(ScannerTransEntry(1 ,'.' ,3));
   s193.addTransition(ScannerTransEntry(2 ,'.' ,3));
   s193.addTransition(ScannerTransEntry(3 ,'0' ,3));
   s193.addTransition(ScannerTransEntry(3 ,'1' ,3));
   s193.addTransition(ScannerTransEntry(3 ,'2' ,3));
   s193.addTransition(ScannerTransEntry(3 ,'3' ,3));
   s193.addTransition(ScannerTransEntry(3 ,'4' ,3));
   s193.addTransition(ScannerTransEntry(3 ,'5' ,3));
   s193.addTransition(ScannerTransEntry(3 ,'6' ,3));
   s193.addTransition(ScannerTransEntry(3 ,'7' ,3));
   s193.addTransition(ScannerTransEntry(3 ,'8' ,3));
   s193.addTransition(ScannerTransEntry(3 ,'9' ,3));
   _scannerList.Insert(s193);

   Scanner s194(IDENTIFIER);
   s194.addState(ScannerStateEntry(0 ,START));
   s194.addState(ScannerStateEntry(1 ,FINAL));
   s194.addTransition(ScannerTransEntry(0 ,'$' ,1));
   s194.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s194.addTransition(ScannerTransEntry(0 ,'B' ,1));
   s194.addTransition(ScannerTransEntry(0 ,'C' ,1));
   s194.addTransition(ScannerTransEntry(0 ,'D' ,1));
   s194.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s194.addTransition(ScannerTransEntry(0 ,'F' ,1));
   s194.addTransition(ScannerTransEntry(0 ,'G' ,1));
   s194.addTransition(ScannerTransEntry(0 ,'H' ,1));
   s194.addTransition(ScannerTransEntry(0 ,'I' ,1));
   s194.addTransition(ScannerTransEntry(0 ,'J' ,1));
   s194.addTransition(ScannerTransEntry(0 ,'K' ,1));
   s194.addTransition(ScannerTransEntry(0 ,'L' ,1));
   s194.addTransition(ScannerTransEntry(0 ,'M' ,1));
   s194.addTransition(ScannerTransEntry(0 ,'N' ,1));
   s194.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s194.addTransition(ScannerTransEntry(0 ,'P' ,1));
   s194.addTransition(ScannerTransEntry(0 ,'Q' ,1));
   s194.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s194.addTransition(ScannerTransEntry(0 ,'S' ,1));
   s194.addTransition(ScannerTransEntry(0 ,'T' ,1));
   s194.addTransition(ScannerTransEntry(0 ,'U' ,1));
   s194.addTransition(ScannerTransEntry(0 ,'V' ,1));
   s194.addTransition(ScannerTransEntry(0 ,'W' ,1));
   s194.addTransition(ScannerTransEntry(0 ,'X' ,1));
   s194.addTransition(ScannerTransEntry(0 ,'Y' ,1));
   s194.addTransition(ScannerTransEntry(0 ,'Z' ,1));
   s194.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s194.addTransition(ScannerTransEntry(0 ,'b' ,1));
   s194.addTransition(ScannerTransEntry(0 ,'c' ,1));
   s194.addTransition(ScannerTransEntry(0 ,'d' ,1));
   s194.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s194.addTransition(ScannerTransEntry(0 ,'f' ,1));
   s194.addTransition(ScannerTransEntry(0 ,'g' ,1));
   s194.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s194.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s194.addTransition(ScannerTransEntry(0 ,'j' ,1));
   s194.addTransition(ScannerTransEntry(0 ,'k' ,1));
   s194.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s194.addTransition(ScannerTransEntry(0 ,'m' ,1));
   s194.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s194.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s194.addTransition(ScannerTransEntry(0 ,'p' ,1));
   s194.addTransition(ScannerTransEntry(0 ,'q' ,1));
   s194.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s194.addTransition(ScannerTransEntry(0 ,'s' ,1));
   s194.addTransition(ScannerTransEntry(0 ,'t' ,1));
   s194.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s194.addTransition(ScannerTransEntry(0 ,'v' ,1));
   s194.addTransition(ScannerTransEntry(0 ,'w' ,1));
   s194.addTransition(ScannerTransEntry(0 ,'x' ,1));
   s194.addTransition(ScannerTransEntry(0 ,'y' ,1));
   s194.addTransition(ScannerTransEntry(0 ,'z' ,1));
   s194.addTransition(ScannerTransEntry(1 ,'0' ,1));
   s194.addTransition(ScannerTransEntry(1 ,'1' ,1));
   s194.addTransition(ScannerTransEntry(1 ,'2' ,1));
   s194.addTransition(ScannerTransEntry(1 ,'3' ,1));
   s194.addTransition(ScannerTransEntry(1 ,'4' ,1));
   s194.addTransition(ScannerTransEntry(1 ,'5' ,1));
   s194.addTransition(ScannerTransEntry(1 ,'6' ,1));
   s194.addTransition(ScannerTransEntry(1 ,'7' ,1));
   s194.addTransition(ScannerTransEntry(1 ,'8' ,1));
   s194.addTransition(ScannerTransEntry(1 ,'9' ,1));
   s194.addTransition(ScannerTransEntry(1 ,'A' ,1));
   s194.addTransition(ScannerTransEntry(1 ,'B' ,1));
   s194.addTransition(ScannerTransEntry(1 ,'C' ,1));
   s194.addTransition(ScannerTransEntry(1 ,'D' ,1));
   s194.addTransition(ScannerTransEntry(1 ,'E' ,1));
   s194.addTransition(ScannerTransEntry(1 ,'F' ,1));
   s194.addTransition(ScannerTransEntry(1 ,'G' ,1));
   s194.addTransition(ScannerTransEntry(1 ,'H' ,1));
   s194.addTransition(ScannerTransEntry(1 ,'I' ,1));
   s194.addTransition(ScannerTransEntry(1 ,'J' ,1));
   s194.addTransition(ScannerTransEntry(1 ,'K' ,1));
   s194.addTransition(ScannerTransEntry(1 ,'L' ,1));
   s194.addTransition(ScannerTransEntry(1 ,'M' ,1));
   s194.addTransition(ScannerTransEntry(1 ,'N' ,1));
   s194.addTransition(ScannerTransEntry(1 ,'O' ,1));
   s194.addTransition(ScannerTransEntry(1 ,'P' ,1));
   s194.addTransition(ScannerTransEntry(1 ,'Q' ,1));
   s194.addTransition(ScannerTransEntry(1 ,'R' ,1));
   s194.addTransition(ScannerTransEntry(1 ,'S' ,1));
   s194.addTransition(ScannerTransEntry(1 ,'T' ,1));
   s194.addTransition(ScannerTransEntry(1 ,'U' ,1));
   s194.addTransition(ScannerTransEntry(1 ,'V' ,1));
   s194.addTransition(ScannerTransEntry(1 ,'W' ,1));
   s194.addTransition(ScannerTransEntry(1 ,'X' ,1));
   s194.addTransition(ScannerTransEntry(1 ,'Y' ,1));
   s194.addTransition(ScannerTransEntry(1 ,'Z' ,1));
   s194.addTransition(ScannerTransEntry(1 ,'_' ,1));
   s194.addTransition(ScannerTransEntry(1 ,'a' ,1));
   s194.addTransition(ScannerTransEntry(1 ,'b' ,1));
   s194.addTransition(ScannerTransEntry(1 ,'c' ,1));
   s194.addTransition(ScannerTransEntry(1 ,'d' ,1));
   s194.addTransition(ScannerTransEntry(1 ,'e' ,1));
   s194.addTransition(ScannerTransEntry(1 ,'f' ,1));
   s194.addTransition(ScannerTransEntry(1 ,'g' ,1));
   s194.addTransition(ScannerTransEntry(1 ,'h' ,1));
   s194.addTransition(ScannerTransEntry(1 ,'i' ,1));
   s194.addTransition(ScannerTransEntry(1 ,'j' ,1));
   s194.addTransition(ScannerTransEntry(1 ,'k' ,1));
   s194.addTransition(ScannerTransEntry(1 ,'l' ,1));
   s194.addTransition(ScannerTransEntry(1 ,'m' ,1));
   s194.addTransition(ScannerTransEntry(1 ,'n' ,1));
   s194.addTransition(ScannerTransEntry(1 ,'o' ,1));
   s194.addTransition(ScannerTransEntry(1 ,'p' ,1));
   s194.addTransition(ScannerTransEntry(1 ,'q' ,1));
   s194.addTransition(ScannerTransEntry(1 ,'r' ,1));
   s194.addTransition(ScannerTransEntry(1 ,'s' ,1));
   s194.addTransition(ScannerTransEntry(1 ,'t' ,1));
   s194.addTransition(ScannerTransEntry(1 ,'u' ,1));
   s194.addTransition(ScannerTransEntry(1 ,'v' ,1));
   s194.addTransition(ScannerTransEntry(1 ,'w' ,1));
   s194.addTransition(ScannerTransEntry(1 ,'x' ,1));
   s194.addTransition(ScannerTransEntry(1 ,'y' ,1));
   s194.addTransition(ScannerTransEntry(1 ,'z' ,1));
   _scannerList.Insert(s194);

   Scanner s195(VARREF);
   s195.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s195.addState(ScannerStateEntry(1 ,FINAL));
   s195.addState(ScannerStateEntry(2 ,START));
   s195.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'B' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'C' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'D' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'F' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'G' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'H' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'I' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'J' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'K' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'L' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'M' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'N' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'P' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'Q' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'S' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'T' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'U' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'V' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'W' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'X' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'Y' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'Z' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'b' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'c' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'d' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'f' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'g' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'j' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'k' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'m' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'p' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'q' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'s' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'t' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'v' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'w' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'x' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'y' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'z' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'0' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'1' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'2' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'3' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'4' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'5' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'6' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'7' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'8' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'9' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'A' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'B' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'C' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'D' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'E' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'F' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'G' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'H' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'I' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'J' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'K' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'L' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'M' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'N' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'O' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'P' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'Q' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'R' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'S' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'T' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'U' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'V' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'W' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'X' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'Y' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'Z' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'_' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'a' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'b' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'c' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'d' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'e' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'f' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'g' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'h' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'i' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'j' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'k' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'l' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'m' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'n' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'o' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'p' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'q' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'r' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'s' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'t' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'u' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'v' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'w' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'x' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'y' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'z' ,1));
   s195.addTransition(ScannerTransEntry(2 ,':' ,0));
   _scannerList.Insert(s195);

   Scanner s196(QUALIFIEDOBJ);
   s196.addState(ScannerStateEntry(0 ,START));
   s196.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s196.addState(ScannerStateEntry(2 ,INTERMEDIATE));
   s196.addState(ScannerStateEntry(3 ,FINAL));
   s196.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'B' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'C' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'D' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'F' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'G' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'H' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'I' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'J' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'K' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'L' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'M' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'N' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'P' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'Q' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'S' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'T' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'U' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'V' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'W' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'X' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'Y' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'Z' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'b' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'c' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'d' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'f' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'g' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'j' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'k' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'m' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'p' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'q' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'s' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'t' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'v' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'w' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'x' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'y' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'z' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'0' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'1' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'2' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'3' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'4' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'5' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'6' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'7' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'8' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'9' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'A' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'B' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'C' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'D' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'E' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'F' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'G' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'H' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'I' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'J' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'K' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'L' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'M' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'N' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'O' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'P' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'Q' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'R' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'S' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'T' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'U' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'V' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'W' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'X' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'Y' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'Z' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'_' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'a' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'b' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'c' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'d' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'e' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'f' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'g' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'h' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'i' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'j' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'k' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'l' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'m' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'n' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'o' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'p' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'q' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'r' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'s' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'t' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'u' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'v' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'w' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'x' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'y' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'z' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'.' ,2));
   s196.addTransition(ScannerTransEntry(2 ,'$' ,3));
   s196.addTransition(ScannerTransEntry(2 ,'A' ,3));
   s196.addTransition(ScannerTransEntry(2 ,'B' ,3));
   s196.addTransition(ScannerTransEntry(2 ,'C' ,3));
   s196.addTransition(ScannerTransEntry(2 ,'D' ,3));
   s196.addTransition(ScannerTransEntry(2 ,'E' ,3));
   s196.addTransition(ScannerTransEntry(2 ,'F' ,3));
   s196.addTransition(ScannerTransEntry(2 ,'G' ,3));
   s196.addTransition(ScannerTransEntry(2 ,'H' ,3));
   s196.addTransition(ScannerTransEntry(2 ,'I' ,3));
   s196.addTransition(ScannerTransEntry(2 ,'J' ,3));
   s196.addTransition(ScannerTransEntry(2 ,'K' ,3));
   s196.addTransition(ScannerTransEntry(2 ,'L' ,3));
   s196.addTransition(ScannerTransEntry(2 ,'M' ,3));
   s196.addTransition(ScannerTransEntry(2 ,'N' ,3));
   s196.addTransition(ScannerTransEntry(2 ,'O' ,3));
   s196.addTransition(ScannerTransEntry(2 ,'P' ,3));
   s196.addTransition(ScannerTransEntry(2 ,'Q' ,3));
   s196.addTransition(ScannerTransEntry(2 ,'R' ,3));
   s196.addTransition(ScannerTransEntry(2 ,'S' ,3));
   s196.addTransition(ScannerTransEntry(2 ,'T' ,3));
   s196.addTransition(ScannerTransEntry(2 ,'U' ,3));
   s196.addTransition(ScannerTransEntry(2 ,'V' ,3));
   s196.addTransition(ScannerTransEntry(2 ,'W' ,3));
   s196.addTransition(ScannerTransEntry(2 ,'X' ,3));
   s196.addTransition(ScannerTransEntry(2 ,'Y' ,3));
   s196.addTransition(ScannerTransEntry(2 ,'Z' ,3));
   s196.addTransition(ScannerTransEntry(2 ,'a' ,3));
   s196.addTransition(ScannerTransEntry(2 ,'b' ,3));
   s196.addTransition(ScannerTransEntry(2 ,'c' ,3));
   s196.addTransition(ScannerTransEntry(2 ,'d' ,3));
   s196.addTransition(ScannerTransEntry(2 ,'e' ,3));
   s196.addTransition(ScannerTransEntry(2 ,'f' ,3));
   s196.addTransition(ScannerTransEntry(2 ,'g' ,3));
   s196.addTransition(ScannerTransEntry(2 ,'h' ,3));
   s196.addTransition(ScannerTransEntry(2 ,'i' ,3));
   s196.addTransition(ScannerTransEntry(2 ,'j' ,3));
   s196.addTransition(ScannerTransEntry(2 ,'k' ,3));
   s196.addTransition(ScannerTransEntry(2 ,'l' ,3));
   s196.addTransition(ScannerTransEntry(2 ,'m' ,3));
   s196.addTransition(ScannerTransEntry(2 ,'n' ,3));
   s196.addTransition(ScannerTransEntry(2 ,'o' ,3));
   s196.addTransition(ScannerTransEntry(2 ,'p' ,3));
   s196.addTransition(ScannerTransEntry(2 ,'q' ,3));
   s196.addTransition(ScannerTransEntry(2 ,'r' ,3));
   s196.addTransition(ScannerTransEntry(2 ,'s' ,3));
   s196.addTransition(ScannerTransEntry(2 ,'t' ,3));
   s196.addTransition(ScannerTransEntry(2 ,'u' ,3));
   s196.addTransition(ScannerTransEntry(2 ,'v' ,3));
   s196.addTransition(ScannerTransEntry(2 ,'w' ,3));
   s196.addTransition(ScannerTransEntry(2 ,'x' ,3));
   s196.addTransition(ScannerTransEntry(2 ,'y' ,3));
   s196.addTransition(ScannerTransEntry(2 ,'z' ,3));
   s196.addTransition(ScannerTransEntry(3 ,'0' ,3));
   s196.addTransition(ScannerTransEntry(3 ,'1' ,3));
   s196.addTransition(ScannerTransEntry(3 ,'2' ,3));
   s196.addTransition(ScannerTransEntry(3 ,'3' ,3));
   s196.addTransition(ScannerTransEntry(3 ,'4' ,3));
   s196.addTransition(ScannerTransEntry(3 ,'5' ,3));
   s196.addTransition(ScannerTransEntry(3 ,'6' ,3));
   s196.addTransition(ScannerTransEntry(3 ,'7' ,3));
   s196.addTransition(ScannerTransEntry(3 ,'8' ,3));
   s196.addTransition(ScannerTransEntry(3 ,'9' ,3));
   s196.addTransition(ScannerTransEntry(3 ,'A' ,3));
   s196.addTransition(ScannerTransEntry(3 ,'B' ,3));
   s196.addTransition(ScannerTransEntry(3 ,'C' ,3));
   s196.addTransition(ScannerTransEntry(3 ,'D' ,3));
   s196.addTransition(ScannerTransEntry(3 ,'E' ,3));
   s196.addTransition(ScannerTransEntry(3 ,'F' ,3));
   s196.addTransition(ScannerTransEntry(3 ,'G' ,3));
   s196.addTransition(ScannerTransEntry(3 ,'H' ,3));
   s196.addTransition(ScannerTransEntry(3 ,'I' ,3));
   s196.addTransition(ScannerTransEntry(3 ,'J' ,3));
   s196.addTransition(ScannerTransEntry(3 ,'K' ,3));
   s196.addTransition(ScannerTransEntry(3 ,'L' ,3));
   s196.addTransition(ScannerTransEntry(3 ,'M' ,3));
   s196.addTransition(ScannerTransEntry(3 ,'N' ,3));
   s196.addTransition(ScannerTransEntry(3 ,'O' ,3));
   s196.addTransition(ScannerTransEntry(3 ,'P' ,3));
   s196.addTransition(ScannerTransEntry(3 ,'Q' ,3));
   s196.addTransition(ScannerTransEntry(3 ,'R' ,3));
   s196.addTransition(ScannerTransEntry(3 ,'S' ,3));
   s196.addTransition(ScannerTransEntry(3 ,'T' ,3));
   s196.addTransition(ScannerTransEntry(3 ,'U' ,3));
   s196.addTransition(ScannerTransEntry(3 ,'V' ,3));
   s196.addTransition(ScannerTransEntry(3 ,'W' ,3));
   s196.addTransition(ScannerTransEntry(3 ,'X' ,3));
   s196.addTransition(ScannerTransEntry(3 ,'Y' ,3));
   s196.addTransition(ScannerTransEntry(3 ,'Z' ,3));
   s196.addTransition(ScannerTransEntry(3 ,'_' ,3));
   s196.addTransition(ScannerTransEntry(3 ,'a' ,3));
   s196.addTransition(ScannerTransEntry(3 ,'b' ,3));
   s196.addTransition(ScannerTransEntry(3 ,'c' ,3));
   s196.addTransition(ScannerTransEntry(3 ,'d' ,3));
   s196.addTransition(ScannerTransEntry(3 ,'e' ,3));
   s196.addTransition(ScannerTransEntry(3 ,'f' ,3));
   s196.addTransition(ScannerTransEntry(3 ,'g' ,3));
   s196.addTransition(ScannerTransEntry(3 ,'h' ,3));
   s196.addTransition(ScannerTransEntry(3 ,'i' ,3));
   s196.addTransition(ScannerTransEntry(3 ,'j' ,3));
   s196.addTransition(ScannerTransEntry(3 ,'k' ,3));
   s196.addTransition(ScannerTransEntry(3 ,'l' ,3));
   s196.addTransition(ScannerTransEntry(3 ,'m' ,3));
   s196.addTransition(ScannerTransEntry(3 ,'n' ,3));
   s196.addTransition(ScannerTransEntry(3 ,'o' ,3));
   s196.addTransition(ScannerTransEntry(3 ,'p' ,3));
   s196.addTransition(ScannerTransEntry(3 ,'q' ,3));
   s196.addTransition(ScannerTransEntry(3 ,'r' ,3));
   s196.addTransition(ScannerTransEntry(3 ,'s' ,3));
   s196.addTransition(ScannerTransEntry(3 ,'t' ,3));
   s196.addTransition(ScannerTransEntry(3 ,'u' ,3));
   s196.addTransition(ScannerTransEntry(3 ,'v' ,3));
   s196.addTransition(ScannerTransEntry(3 ,'w' ,3));
   s196.addTransition(ScannerTransEntry(3 ,'x' ,3));
   s196.addTransition(ScannerTransEntry(3 ,'y' ,3));
   s196.addTransition(ScannerTransEntry(3 ,'z' ,3));
   _scannerList.Insert(s196);

   Scanner s197(QUALIFIEDPRE);
   s197.addState(ScannerStateEntry(0 ,START));
   s197.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s197.addState(ScannerStateEntry(2 ,FINAL));
   s197.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'B' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'C' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'D' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'F' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'G' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'H' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'I' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'J' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'K' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'L' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'M' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'N' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'P' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'Q' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'S' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'T' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'U' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'V' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'W' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'X' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'Y' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'Z' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'b' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'c' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'d' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'f' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'g' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'j' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'k' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'m' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'p' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'q' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'s' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'t' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'v' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'w' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'x' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'y' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'z' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'0' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'1' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'2' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'3' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'4' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'5' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'6' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'7' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'8' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'9' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'A' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'B' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'C' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'D' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'E' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'F' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'G' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'H' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'I' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'J' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'K' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'L' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'M' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'N' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'O' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'P' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'Q' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'R' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'S' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'T' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'U' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'V' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'W' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'X' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'Y' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'Z' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'_' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'a' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'b' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'c' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'d' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'e' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'f' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'g' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'h' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'i' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'j' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'k' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'l' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'m' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'n' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'o' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'p' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'q' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'r' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'s' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'t' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'u' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'v' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'w' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'x' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'y' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'z' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'.' ,2));
   _scannerList.Insert(s197);

   Scanner s198(QUALIFIEDTS);
   s198.addState(ScannerStateEntry(0 ,START));
   s198.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s198.addState(ScannerStateEntry(2 ,INTERMEDIATE));
   s198.addState(ScannerStateEntry(3 ,FINAL));
   s198.addTransition(ScannerTransEntry(0 ,'$' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'B' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'C' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'D' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'F' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'G' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'H' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'I' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'J' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'K' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'L' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'M' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'N' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'P' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'Q' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'S' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'T' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'U' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'V' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'W' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'X' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'Y' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'Z' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'b' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'c' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'d' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'f' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'g' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'j' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'k' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'m' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'p' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'q' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'s' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'t' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'v' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'w' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'x' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'y' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'z' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'0' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'1' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'2' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'3' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'4' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'5' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'6' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'7' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'8' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'9' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'A' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'B' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'C' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'D' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'E' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'F' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'G' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'H' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'I' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'J' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'K' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'L' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'M' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'N' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'O' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'P' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'Q' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'R' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'S' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'T' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'U' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'V' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'W' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'X' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'Y' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'Z' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'_' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'a' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'b' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'c' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'d' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'e' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'f' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'g' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'h' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'i' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'j' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'k' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'l' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'m' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'n' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'o' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'p' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'q' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'r' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'s' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'t' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'u' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'v' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'w' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'x' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'y' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'z' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'@' ,2));
   s198.addTransition(ScannerTransEntry(2 ,'A' ,3));
   s198.addTransition(ScannerTransEntry(2 ,'B' ,3));
   s198.addTransition(ScannerTransEntry(2 ,'C' ,3));
   s198.addTransition(ScannerTransEntry(2 ,'D' ,3));
   s198.addTransition(ScannerTransEntry(2 ,'E' ,3));
   s198.addTransition(ScannerTransEntry(2 ,'F' ,3));
   s198.addTransition(ScannerTransEntry(2 ,'G' ,3));
   s198.addTransition(ScannerTransEntry(2 ,'H' ,3));
   s198.addTransition(ScannerTransEntry(2 ,'I' ,3));
   s198.addTransition(ScannerTransEntry(2 ,'J' ,3));
   s198.addTransition(ScannerTransEntry(2 ,'K' ,3));
   s198.addTransition(ScannerTransEntry(2 ,'L' ,3));
   s198.addTransition(ScannerTransEntry(2 ,'M' ,3));
   s198.addTransition(ScannerTransEntry(2 ,'N' ,3));
   s198.addTransition(ScannerTransEntry(2 ,'O' ,3));
   s198.addTransition(ScannerTransEntry(2 ,'P' ,3));
   s198.addTransition(ScannerTransEntry(2 ,'Q' ,3));
   s198.addTransition(ScannerTransEntry(2 ,'R' ,3));
   s198.addTransition(ScannerTransEntry(2 ,'S' ,3));
   s198.addTransition(ScannerTransEntry(2 ,'T' ,3));
   s198.addTransition(ScannerTransEntry(2 ,'U' ,3));
   s198.addTransition(ScannerTransEntry(2 ,'V' ,3));
   s198.addTransition(ScannerTransEntry(2 ,'W' ,3));
   s198.addTransition(ScannerTransEntry(2 ,'X' ,3));
   s198.addTransition(ScannerTransEntry(2 ,'Y' ,3));
   s198.addTransition(ScannerTransEntry(2 ,'Z' ,3));
   s198.addTransition(ScannerTransEntry(2 ,'a' ,3));
   s198.addTransition(ScannerTransEntry(2 ,'b' ,3));
   s198.addTransition(ScannerTransEntry(2 ,'c' ,3));
   s198.addTransition(ScannerTransEntry(2 ,'d' ,3));
   s198.addTransition(ScannerTransEntry(2 ,'e' ,3));
   s198.addTransition(ScannerTransEntry(2 ,'f' ,3));
   s198.addTransition(ScannerTransEntry(2 ,'g' ,3));
   s198.addTransition(ScannerTransEntry(2 ,'h' ,3));
   s198.addTransition(ScannerTransEntry(2 ,'i' ,3));
   s198.addTransition(ScannerTransEntry(2 ,'j' ,3));
   s198.addTransition(ScannerTransEntry(2 ,'k' ,3));
   s198.addTransition(ScannerTransEntry(2 ,'l' ,3));
   s198.addTransition(ScannerTransEntry(2 ,'m' ,3));
   s198.addTransition(ScannerTransEntry(2 ,'n' ,3));
   s198.addTransition(ScannerTransEntry(2 ,'o' ,3));
   s198.addTransition(ScannerTransEntry(2 ,'p' ,3));
   s198.addTransition(ScannerTransEntry(2 ,'q' ,3));
   s198.addTransition(ScannerTransEntry(2 ,'r' ,3));
   s198.addTransition(ScannerTransEntry(2 ,'s' ,3));
   s198.addTransition(ScannerTransEntry(2 ,'t' ,3));
   s198.addTransition(ScannerTransEntry(2 ,'u' ,3));
   s198.addTransition(ScannerTransEntry(2 ,'v' ,3));
   s198.addTransition(ScannerTransEntry(2 ,'w' ,3));
   s198.addTransition(ScannerTransEntry(2 ,'x' ,3));
   s198.addTransition(ScannerTransEntry(2 ,'y' ,3));
   s198.addTransition(ScannerTransEntry(2 ,'z' ,3));
   s198.addTransition(ScannerTransEntry(3 ,'0' ,3));
   s198.addTransition(ScannerTransEntry(3 ,'1' ,3));
   s198.addTransition(ScannerTransEntry(3 ,'2' ,3));
   s198.addTransition(ScannerTransEntry(3 ,'3' ,3));
   s198.addTransition(ScannerTransEntry(3 ,'4' ,3));
   s198.addTransition(ScannerTransEntry(3 ,'5' ,3));
   s198.addTransition(ScannerTransEntry(3 ,'6' ,3));
   s198.addTransition(ScannerTransEntry(3 ,'7' ,3));
   s198.addTransition(ScannerTransEntry(3 ,'8' ,3));
   s198.addTransition(ScannerTransEntry(3 ,'9' ,3));
   s198.addTransition(ScannerTransEntry(3 ,'A' ,3));
   s198.addTransition(ScannerTransEntry(3 ,'B' ,3));
   s198.addTransition(ScannerTransEntry(3 ,'C' ,3));
   s198.addTransition(ScannerTransEntry(3 ,'D' ,3));
   s198.addTransition(ScannerTransEntry(3 ,'E' ,3));
   s198.addTransition(ScannerTransEntry(3 ,'F' ,3));
   s198.addTransition(ScannerTransEntry(3 ,'G' ,3));
   s198.addTransition(ScannerTransEntry(3 ,'H' ,3));
   s198.addTransition(ScannerTransEntry(3 ,'I' ,3));
   s198.addTransition(ScannerTransEntry(3 ,'J' ,3));
   s198.addTransition(ScannerTransEntry(3 ,'K' ,3));
   s198.addTransition(ScannerTransEntry(3 ,'L' ,3));
   s198.addTransition(ScannerTransEntry(3 ,'M' ,3));
   s198.addTransition(ScannerTransEntry(3 ,'N' ,3));
   s198.addTransition(ScannerTransEntry(3 ,'O' ,3));
   s198.addTransition(ScannerTransEntry(3 ,'P' ,3));
   s198.addTransition(ScannerTransEntry(3 ,'Q' ,3));
   s198.addTransition(ScannerTransEntry(3 ,'R' ,3));
   s198.addTransition(ScannerTransEntry(3 ,'S' ,3));
   s198.addTransition(ScannerTransEntry(3 ,'T' ,3));
   s198.addTransition(ScannerTransEntry(3 ,'U' ,3));
   s198.addTransition(ScannerTransEntry(3 ,'V' ,3));
   s198.addTransition(ScannerTransEntry(3 ,'W' ,3));
   s198.addTransition(ScannerTransEntry(3 ,'X' ,3));
   s198.addTransition(ScannerTransEntry(3 ,'Y' ,3));
   s198.addTransition(ScannerTransEntry(3 ,'Z' ,3));
   s198.addTransition(ScannerTransEntry(3 ,'_' ,3));
   s198.addTransition(ScannerTransEntry(3 ,'a' ,3));
   s198.addTransition(ScannerTransEntry(3 ,'b' ,3));
   s198.addTransition(ScannerTransEntry(3 ,'c' ,3));
   s198.addTransition(ScannerTransEntry(3 ,'d' ,3));
   s198.addTransition(ScannerTransEntry(3 ,'e' ,3));
   s198.addTransition(ScannerTransEntry(3 ,'f' ,3));
   s198.addTransition(ScannerTransEntry(3 ,'g' ,3));
   s198.addTransition(ScannerTransEntry(3 ,'h' ,3));
   s198.addTransition(ScannerTransEntry(3 ,'i' ,3));
   s198.addTransition(ScannerTransEntry(3 ,'j' ,3));
   s198.addTransition(ScannerTransEntry(3 ,'k' ,3));
   s198.addTransition(ScannerTransEntry(3 ,'l' ,3));
   s198.addTransition(ScannerTransEntry(3 ,'m' ,3));
   s198.addTransition(ScannerTransEntry(3 ,'n' ,3));
   s198.addTransition(ScannerTransEntry(3 ,'o' ,3));
   s198.addTransition(ScannerTransEntry(3 ,'p' ,3));
   s198.addTransition(ScannerTransEntry(3 ,'q' ,3));
   s198.addTransition(ScannerTransEntry(3 ,'r' ,3));
   s198.addTransition(ScannerTransEntry(3 ,'s' ,3));
   s198.addTransition(ScannerTransEntry(3 ,'t' ,3));
   s198.addTransition(ScannerTransEntry(3 ,'u' ,3));
   s198.addTransition(ScannerTransEntry(3 ,'v' ,3));
   s198.addTransition(ScannerTransEntry(3 ,'w' ,3));
   s198.addTransition(ScannerTransEntry(3 ,'x' ,3));
   s198.addTransition(ScannerTransEntry(3 ,'y' ,3));
   s198.addTransition(ScannerTransEntry(3 ,'z' ,3));
   _scannerList.Insert(s198);

}
void Cego::loadParser0()
{
   _actionMap[964][SEMICOLON] = ActionEntry(REDUCE, 85);
   _actionMap[963][RB] = ActionEntry(SHIFT, 964);
   _actionMap[962][IDENTIFIER] = ActionEntry(SHIFT, 826);
   _jumpMap[962][SimpleAttr] = 825;
   _jumpMap[962][SimpleAttrList] = 963;
   _actionMap[959][LB] = ActionEntry(SHIFT, 962);
   _actionMap[960][ROWLIMIT] = ActionEntry(REDUCE, 276);
   _actionMap[960][UNION] = ActionEntry(REDUCE, 276);
   _actionMap[960][ENDTOKEN] = ActionEntry(REDUCE, 276);
   _actionMap[960][RB] = ActionEntry(REDUCE, 276);
   _actionMap[960][SEMICOLON] = ActionEntry(REDUCE, 276);
   _actionMap[960][KSEP] = ActionEntry(REDUCE, 276);
   _actionMap[961][PLUS] = ActionEntry(SHIFT, 275);
   _actionMap[961][MINUS] = ActionEntry(SHIFT, 274);
   _actionMap[961][CONCAT] = ActionEntry(SHIFT, 273);
   _actionMap[961][ORDER] = ActionEntry(REDUCE, 270);
   _actionMap[961][ROWLIMIT] = ActionEntry(REDUCE, 270);
   _actionMap[961][UNION] = ActionEntry(REDUCE, 270);
   _actionMap[961][ENDTOKEN] = ActionEntry(REDUCE, 270);
   _actionMap[961][RB] = ActionEntry(REDUCE, 270);
   _actionMap[961][SEMICOLON] = ActionEntry(REDUCE, 270);
   _actionMap[955][IDENTIFIER] = ActionEntry(SHIFT, 959);
   _actionMap[956][SEMICOLON] = ActionEntry(REDUCE, 97);
   _actionMap[956][RB] = ActionEntry(REDUCE, 97);
   _actionMap[957][PLUS] = ActionEntry(SHIFT, 275);
   _actionMap[957][MINUS] = ActionEntry(SHIFT, 274);
   _actionMap[957][CONCAT] = ActionEntry(SHIFT, 273);
   _actionMap[957][ASC] = ActionEntry(SHIFT, 948);
   _actionMap[957][ROWLIMIT] = ActionEntry(REDUCE, 281);
   _actionMap[957][DESC] = ActionEntry(SHIFT, 949);
   _actionMap[957][UNION] = ActionEntry(REDUCE, 281);
   _actionMap[957][ENDTOKEN] = ActionEntry(REDUCE, 281);
   _actionMap[957][RB] = ActionEntry(REDUCE, 281);
   _actionMap[957][SEMICOLON] = ActionEntry(REDUCE, 281);
   _actionMap[957][KSEP] = ActionEntry(REDUCE, 281);
   _jumpMap[957][DefaultOrderOpt] = 947;
   _jumpMap[957][OrderingOpt] = 960;
   _actionMap[958][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[958][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[958][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[958][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[958][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[958][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[958][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[958][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[958][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[958][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[958][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[958][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[958][NEWDATE] = ActionEntry(SHIFT, 145);
}
void Cego::loadParser1()
{
   _actionMap[958][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[958][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[958][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[958][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[958][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[958][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[958][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[958][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[958][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[958][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[958][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[958][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[958][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[958][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[958][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[958][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[958][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[958][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[958][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[958][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[958][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[958][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[958][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[958][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[958][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[958][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[958][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[958][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[958][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[958][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[958][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[958][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[958][LB] = ActionEntry(SHIFT, 176);
   _actionMap[958][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[958][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[958][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[958][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[958][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[958][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[958][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[958][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[958][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[958][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[958][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[958][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[958][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[958][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[958][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[958][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[958][MAX] = ActionEntry(SHIFT, 154);
}
void Cego::loadParser2()
{
   _jumpMap[958][ObjSpec] = 121;
   _jumpMap[958][Constant] = 120;
   _jumpMap[958][SignedFloat] = 119;
   _jumpMap[958][SignedInt] = 118;
   _jumpMap[958][Attribute] = 117;
   _jumpMap[958][Function] = 116;
   _jumpMap[958][CasePrepare] = 115;
   _jumpMap[958][CaseClause] = 114;
   _jumpMap[958][Factor] = 113;
   _jumpMap[958][Term] = 112;
   _jumpMap[958][Expr] = 961;
   _actionMap[941][REFERENCES] = ActionEntry(SHIFT, 955);
   _actionMap[942][ELSE] = ActionEntry(REDUCE, 145);
   _actionMap[942][ELSIF] = ActionEntry(REDUCE, 145);
   _actionMap[942][EXCEPTION] = ActionEntry(REDUCE, 145);
   _actionMap[942][END_TOKEN] = ActionEntry(REDUCE, 145);
   _actionMap[942][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[942][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[942][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[942][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[942][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[942][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[942][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[942][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[942][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[942][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[942][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[942][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[942][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[942][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[942][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[942][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[942][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[942][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[942][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[942][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[942][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[942][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[942][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[942][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[942][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[942][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[942][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[942][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[942][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[942][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[942][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[942][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[942][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[942][BITOR] = ActionEntry(SHIFT, 126);
}
void Cego::loadParser3()
{
   _actionMap[942][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[942][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[942][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[942][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[942][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[942][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[942][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[942][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[942][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[942][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[942][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[942][LB] = ActionEntry(SHIFT, 176);
   _actionMap[942][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[942][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[942][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[942][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[942][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[942][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[942][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[942][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[942][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[942][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[942][VARREF] = ActionEntry(SHIFT, 410);
   _actionMap[942][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[942][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[942][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[942][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[942][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[942][MAX] = ActionEntry(SHIFT, 154);
   _actionMap[942][IF] = ActionEntry(SHIFT, 404);
   _actionMap[942][BEGIN] = ActionEntry(SHIFT, 401);
   _actionMap[942][UNLOCK] = ActionEntry(SHIFT, 28);
   _actionMap[942][LOCK] = ActionEntry(SHIFT, 27);
   _actionMap[942][ROLLBACK] = ActionEntry(SHIFT, 33);
   _actionMap[942][COMMIT] = ActionEntry(SHIFT, 18);
   _actionMap[942][START_TOKEN] = ActionEntry(SHIFT, 37);
   _actionMap[942][UPDATE] = ActionEntry(SHIFT, 43);
   _actionMap[942][DELETETOK] = ActionEntry(SHIFT, 20);
   _actionMap[942][INSERT] = ActionEntry(SHIFT, 23);
   _actionMap[942][VAR] = ActionEntry(SHIFT, 408);
   _actionMap[942][CURSOR] = ActionEntry(SHIFT, 403);
   _actionMap[942][CLOSE] = ActionEntry(SHIFT, 402);
   _actionMap[942][NOOP] = ActionEntry(SHIFT, 405);
   _actionMap[942][THROW] = ActionEntry(SHIFT, 407);
   _actionMap[942][RETURNTOKEN] = ActionEntry(SHIFT, 406);
   _actionMap[942][WHILE] = ActionEntry(SHIFT, 409);
   _jumpMap[942][ObjSpec] = 121;
   _jumpMap[942][Constant] = 120;
   _jumpMap[942][SignedFloat] = 119;
   _jumpMap[942][SignedInt] = 118;
}
void Cego::loadParser4()
{
   _jumpMap[942][Attribute] = 117;
   _jumpMap[942][Function] = 116;
   _jumpMap[942][DeleteStatement] = 400;
   _jumpMap[942][UpdateStatement] = 399;
   _jumpMap[942][InsertStatement] = 398;
   _jumpMap[942][UnlockStatement] = 397;
   _jumpMap[942][LockStatement] = 396;
   _jumpMap[942][RollbackStatement] = 395;
   _jumpMap[942][CommitStatement] = 394;
   _jumpMap[942][StartStatement] = 393;
   _jumpMap[942][CasePrepare] = 115;
   _jumpMap[942][CaseClause] = 114;
   _jumpMap[942][Factor] = 113;
   _jumpMap[942][Term] = 112;
   _jumpMap[942][Expr] = 392;
   _jumpMap[942][ProcStatement] = 542;
   _jumpMap[942][ProcIfPart] = 390;
   _jumpMap[942][ProcBlockStart] = 389;
   _actionMap[943][RB] = ActionEntry(REDUCE, 394);
   _actionMap[944][SEMICOLON] = ActionEntry(REDUCE, 64);
   _actionMap[945][SELECT] = ActionEntry(SHIFT, 34);
   _jumpMap[945][SelectStatement] = 956;
   _actionMap[946][ROWLIMIT] = ActionEntry(REDUCE, 277);
   _actionMap[946][UNION] = ActionEntry(REDUCE, 277);
   _actionMap[946][ENDTOKEN] = ActionEntry(REDUCE, 277);
   _actionMap[946][RB] = ActionEntry(REDUCE, 277);
   _actionMap[946][SEMICOLON] = ActionEntry(REDUCE, 277);
   _actionMap[946][KSEP] = ActionEntry(REDUCE, 277);
   _actionMap[947][ROWLIMIT] = ActionEntry(REDUCE, 278);
   _actionMap[947][UNION] = ActionEntry(REDUCE, 278);
   _actionMap[947][ENDTOKEN] = ActionEntry(REDUCE, 278);
   _actionMap[947][RB] = ActionEntry(REDUCE, 278);
   _actionMap[947][SEMICOLON] = ActionEntry(REDUCE, 278);
   _actionMap[947][KSEP] = ActionEntry(REDUCE, 278);
   _actionMap[948][ROWLIMIT] = ActionEntry(REDUCE, 280);
   _actionMap[948][UNION] = ActionEntry(REDUCE, 280);
   _actionMap[948][ENDTOKEN] = ActionEntry(REDUCE, 280);
   _actionMap[948][RB] = ActionEntry(REDUCE, 280);
   _actionMap[948][SEMICOLON] = ActionEntry(REDUCE, 280);
   _actionMap[948][KSEP] = ActionEntry(REDUCE, 280);
   _actionMap[949][ROWLIMIT] = ActionEntry(REDUCE, 279);
   _actionMap[949][UNION] = ActionEntry(REDUCE, 279);
   _actionMap[949][ENDTOKEN] = ActionEntry(REDUCE, 279);
   _actionMap[949][RB] = ActionEntry(REDUCE, 279);
   _actionMap[949][SEMICOLON] = ActionEntry(REDUCE, 279);
   _actionMap[949][KSEP] = ActionEntry(REDUCE, 279);
   _actionMap[950][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[950][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[950][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[950][INT2ASC] = ActionEntry(SHIFT, 146);
}
void Cego::loadParser5()
{
   _actionMap[950][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[950][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[950][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[950][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[950][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[950][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[950][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[950][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[950][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[950][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[950][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[950][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[950][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[950][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[950][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[950][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[950][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[950][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[950][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[950][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[950][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[950][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[950][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[950][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[950][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[950][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[950][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[950][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[950][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[950][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[950][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[950][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[950][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[950][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[950][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[950][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[950][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[950][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[950][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[950][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[950][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[950][LB] = ActionEntry(SHIFT, 176);
   _actionMap[950][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[950][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[950][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[950][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[950][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[950][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[950][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[950][CLOB] = ActionEntry(SHIFT, 132);
}
void Cego::loadParser6()
{
   _actionMap[950][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[950][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[950][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[950][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[950][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[950][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[950][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[950][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[950][MAX] = ActionEntry(SHIFT, 154);
   _jumpMap[950][ObjSpec] = 121;
   _jumpMap[950][Constant] = 120;
   _jumpMap[950][SignedFloat] = 119;
   _jumpMap[950][SignedInt] = 118;
   _jumpMap[950][Attribute] = 117;
   _jumpMap[950][Function] = 116;
   _jumpMap[950][CasePrepare] = 115;
   _jumpMap[950][CaseClause] = 114;
   _jumpMap[950][Factor] = 113;
   _jumpMap[950][Term] = 112;
   _jumpMap[950][Expr] = 957;
   _actionMap[951][PLUS] = ActionEntry(SHIFT, 275);
   _actionMap[951][MINUS] = ActionEntry(SHIFT, 274);
   _actionMap[951][CONCAT] = ActionEntry(SHIFT, 273);
   _actionMap[951][EQU] = ActionEntry(SHIFT, 595);
   _actionMap[951][NEGATION] = ActionEntry(SHIFT, 598);
   _actionMap[951][LT] = ActionEntry(SHIFT, 596);
   _actionMap[951][MT] = ActionEntry(SHIFT, 597);
   _jumpMap[951][Comparison] = 958;
   _actionMap[952][KSEP] = ActionEntry(REDUCE, 268);
   _actionMap[952][HAVING] = ActionEntry(REDUCE, 268);
   _actionMap[952][ORDER] = ActionEntry(REDUCE, 268);
   _actionMap[952][ROWLIMIT] = ActionEntry(REDUCE, 268);
   _actionMap[952][UNION] = ActionEntry(REDUCE, 268);
   _actionMap[952][ENDTOKEN] = ActionEntry(REDUCE, 268);
   _actionMap[952][RB] = ActionEntry(REDUCE, 268);
   _actionMap[952][SEMICOLON] = ActionEntry(REDUCE, 268);
   _actionMap[953][AND] = ActionEntry(SHIFT, 599);
   _actionMap[953][OR] = ActionEntry(SHIFT, 600);
   _actionMap[953][LEFT] = ActionEntry(REDUCE, 252);
   _actionMap[953][RIGHT] = ActionEntry(REDUCE, 252);
   _actionMap[953][INNER] = ActionEntry(REDUCE, 252);
   _actionMap[953][JOIN] = ActionEntry(REDUCE, 252);
   _actionMap[953][RETURNTOKEN] = ActionEntry(REDUCE, 252);
   _actionMap[953][SEMICOLON] = ActionEntry(REDUCE, 252);
   _actionMap[953][RB] = ActionEntry(REDUCE, 252);
   _actionMap[953][ENDTOKEN] = ActionEntry(REDUCE, 252);
   _actionMap[953][UNION] = ActionEntry(REDUCE, 252);
   _actionMap[953][ROWLIMIT] = ActionEntry(REDUCE, 252);
   _actionMap[953][ORDER] = ActionEntry(REDUCE, 252);
   _actionMap[953][GROUP] = ActionEntry(REDUCE, 252);
}
void Cego::loadParser7()
{
   _actionMap[953][WHERE] = ActionEntry(REDUCE, 252);
   _actionMap[954][AND] = ActionEntry(SHIFT, 599);
   _actionMap[954][OR] = ActionEntry(SHIFT, 600);
   _actionMap[954][LEFT] = ActionEntry(REDUCE, 254);
   _actionMap[954][RIGHT] = ActionEntry(REDUCE, 254);
   _actionMap[954][INNER] = ActionEntry(REDUCE, 254);
   _actionMap[954][JOIN] = ActionEntry(REDUCE, 254);
   _actionMap[954][RETURNTOKEN] = ActionEntry(REDUCE, 254);
   _actionMap[954][SEMICOLON] = ActionEntry(REDUCE, 254);
   _actionMap[954][RB] = ActionEntry(REDUCE, 254);
   _actionMap[954][ENDTOKEN] = ActionEntry(REDUCE, 254);
   _actionMap[954][UNION] = ActionEntry(REDUCE, 254);
   _actionMap[954][ROWLIMIT] = ActionEntry(REDUCE, 254);
   _actionMap[954][ORDER] = ActionEntry(REDUCE, 254);
   _actionMap[954][GROUP] = ActionEntry(REDUCE, 254);
   _actionMap[954][WHERE] = ActionEntry(REDUCE, 254);
   _actionMap[911][RB] = ActionEntry(SHIFT, 941);
   _actionMap[912][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[912][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[912][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[912][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[912][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[912][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[912][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[912][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[912][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[912][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[912][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[912][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[912][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[912][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[912][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[912][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[912][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[912][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[912][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[912][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[912][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[912][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[912][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[912][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[912][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[912][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[912][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[912][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[912][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[912][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[912][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[912][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[912][BITAND] = ActionEntry(SHIFT, 125);
}
void Cego::loadParser8()
{
   _actionMap[912][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[912][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[912][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[912][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[912][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[912][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[912][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[912][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[912][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[912][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[912][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[912][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[912][LB] = ActionEntry(SHIFT, 176);
   _actionMap[912][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[912][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[912][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[912][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[912][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[912][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[912][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[912][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[912][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[912][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[912][VARREF] = ActionEntry(SHIFT, 410);
   _actionMap[912][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[912][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[912][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[912][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[912][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[912][MAX] = ActionEntry(SHIFT, 154);
   _actionMap[912][IF] = ActionEntry(SHIFT, 404);
   _actionMap[912][BEGIN] = ActionEntry(SHIFT, 401);
   _actionMap[912][UNLOCK] = ActionEntry(SHIFT, 28);
   _actionMap[912][LOCK] = ActionEntry(SHIFT, 27);
   _actionMap[912][ROLLBACK] = ActionEntry(SHIFT, 33);
   _actionMap[912][COMMIT] = ActionEntry(SHIFT, 18);
   _actionMap[912][START_TOKEN] = ActionEntry(SHIFT, 37);
   _actionMap[912][UPDATE] = ActionEntry(SHIFT, 43);
   _actionMap[912][DELETETOK] = ActionEntry(SHIFT, 20);
   _actionMap[912][INSERT] = ActionEntry(SHIFT, 23);
   _actionMap[912][VAR] = ActionEntry(SHIFT, 408);
   _actionMap[912][CURSOR] = ActionEntry(SHIFT, 403);
   _actionMap[912][CLOSE] = ActionEntry(SHIFT, 402);
   _actionMap[912][NOOP] = ActionEntry(SHIFT, 405);
   _actionMap[912][THROW] = ActionEntry(SHIFT, 407);
   _actionMap[912][RETURNTOKEN] = ActionEntry(SHIFT, 406);
   _actionMap[912][WHILE] = ActionEntry(SHIFT, 409);
   _jumpMap[912][ObjSpec] = 121;
   _jumpMap[912][Constant] = 120;
   _jumpMap[912][SignedFloat] = 119;
}
void Cego::loadParser9()
{
   _jumpMap[912][SignedInt] = 118;
   _jumpMap[912][Attribute] = 117;
   _jumpMap[912][Function] = 116;
   _jumpMap[912][DeleteStatement] = 400;
   _jumpMap[912][UpdateStatement] = 399;
   _jumpMap[912][InsertStatement] = 398;
   _jumpMap[912][UnlockStatement] = 397;
   _jumpMap[912][LockStatement] = 396;
   _jumpMap[912][RollbackStatement] = 395;
   _jumpMap[912][CommitStatement] = 394;
   _jumpMap[912][StartStatement] = 393;
   _jumpMap[912][CasePrepare] = 115;
   _jumpMap[912][CaseClause] = 114;
   _jumpMap[912][Factor] = 113;
   _jumpMap[912][Term] = 112;
   _jumpMap[912][Expr] = 392;
   _jumpMap[912][ProcStatement] = 391;
   _jumpMap[912][ProcIfPart] = 390;
   _jumpMap[912][ProcBlockStart] = 389;
   _jumpMap[912][ProcStatementList] = 942;
   _actionMap[913][BEGIN] = ActionEntry(REDUCE, 384);
   _actionMap[913][EQU] = ActionEntry(REDUCE, 384);
   _actionMap[913][DEFAULT] = ActionEntry(REDUCE, 384);
   _actionMap[913][NULLTOKEN] = ActionEntry(REDUCE, 384);
   _actionMap[913][NOT] = ActionEntry(REDUCE, 384);
   _actionMap[913][KSEP] = ActionEntry(REDUCE, 384);
   _actionMap[913][SEMICOLON] = ActionEntry(REDUCE, 384);
   _actionMap[913][RB] = ActionEntry(REDUCE, 384);
   _actionMap[914][BEGIN] = ActionEntry(REDUCE, 389);
   _actionMap[914][EQU] = ActionEntry(REDUCE, 389);
   _actionMap[914][DEFAULT] = ActionEntry(REDUCE, 389);
   _actionMap[914][NULLTOKEN] = ActionEntry(REDUCE, 389);
   _actionMap[914][NOT] = ActionEntry(REDUCE, 389);
   _actionMap[914][KSEP] = ActionEntry(REDUCE, 389);
   _actionMap[914][SEMICOLON] = ActionEntry(REDUCE, 389);
   _actionMap[914][RB] = ActionEntry(REDUCE, 389);
   _actionMap[915][BEGIN] = ActionEntry(REDUCE, 390);
   _actionMap[915][EQU] = ActionEntry(REDUCE, 390);
   _actionMap[915][DEFAULT] = ActionEntry(REDUCE, 390);
   _actionMap[915][NULLTOKEN] = ActionEntry(REDUCE, 390);
   _actionMap[915][NOT] = ActionEntry(REDUCE, 390);
   _actionMap[915][KSEP] = ActionEntry(REDUCE, 390);
   _actionMap[915][SEMICOLON] = ActionEntry(REDUCE, 390);
   _actionMap[915][RB] = ActionEntry(REDUCE, 390);
   _actionMap[916][INTVAL] = ActionEntry(SHIFT, 943);
   _actionMap[917][BEGIN] = ActionEntry(REDUCE, 381);
   _actionMap[917][EQU] = ActionEntry(REDUCE, 381);
   _actionMap[917][DEFAULT] = ActionEntry(REDUCE, 381);
   _actionMap[917][NULLTOKEN] = ActionEntry(REDUCE, 381);
   _actionMap[917][NOT] = ActionEntry(REDUCE, 381);
}
void Cego::loadParser10()
{
   _actionMap[917][KSEP] = ActionEntry(REDUCE, 381);
   _actionMap[917][SEMICOLON] = ActionEntry(REDUCE, 381);
   _actionMap[917][RB] = ActionEntry(REDUCE, 381);
   _actionMap[918][CACHED] = ActionEntry(SHIFT, 922);
   _actionMap[918][SEMICOLON] = ActionEntry(REDUCE, 66);
   _jumpMap[918][CachedOpt] = 944;
   _actionMap[919][KSEP] = ActionEntry(REDUCE, 68);
   _actionMap[919][RB] = ActionEntry(REDUCE, 68);
   _actionMap[920][KSEP] = ActionEntry(REDUCE, 70);
   _actionMap[920][RB] = ActionEntry(REDUCE, 70);
   _actionMap[921][SEMICOLON] = ActionEntry(REDUCE, 63);
   _actionMap[922][SEMICOLON] = ActionEntry(REDUCE, 65);
   _actionMap[923][RB] = ActionEntry(REDUCE, 210);
   _actionMap[924][SEMICOLON] = ActionEntry(REDUCE, 204);
   _actionMap[924][KSEP] = ActionEntry(REDUCE, 204);
   _actionMap[924][RB] = ActionEntry(REDUCE, 204);
   _actionMap[925][LEFT] = ActionEntry(REDUCE, 370);
   _actionMap[925][RIGHT] = ActionEntry(REDUCE, 370);
   _actionMap[925][INNER] = ActionEntry(REDUCE, 370);
   _actionMap[925][JOIN] = ActionEntry(REDUCE, 370);
   _actionMap[925][RETURNTOKEN] = ActionEntry(REDUCE, 370);
   _actionMap[925][SEMICOLON] = ActionEntry(REDUCE, 370);
   _actionMap[925][ENDTOKEN] = ActionEntry(REDUCE, 370);
   _actionMap[925][UNION] = ActionEntry(REDUCE, 370);
   _actionMap[925][ROWLIMIT] = ActionEntry(REDUCE, 370);
   _actionMap[925][ORDER] = ActionEntry(REDUCE, 370);
   _actionMap[925][GROUP] = ActionEntry(REDUCE, 370);
   _actionMap[925][WHERE] = ActionEntry(REDUCE, 370);
   _actionMap[925][THEN] = ActionEntry(REDUCE, 370);
   _actionMap[925][AND] = ActionEntry(REDUCE, 370);
   _actionMap[925][OR] = ActionEntry(REDUCE, 370);
   _actionMap[925][RB] = ActionEntry(REDUCE, 370);
   _actionMap[926][LEFT] = ActionEntry(REDUCE, 368);
   _actionMap[926][RIGHT] = ActionEntry(REDUCE, 368);
   _actionMap[926][INNER] = ActionEntry(REDUCE, 368);
   _actionMap[926][JOIN] = ActionEntry(REDUCE, 368);
   _actionMap[926][RETURNTOKEN] = ActionEntry(REDUCE, 368);
   _actionMap[926][SEMICOLON] = ActionEntry(REDUCE, 368);
   _actionMap[926][ENDTOKEN] = ActionEntry(REDUCE, 368);
   _actionMap[926][UNION] = ActionEntry(REDUCE, 368);
   _actionMap[926][ROWLIMIT] = ActionEntry(REDUCE, 368);
   _actionMap[926][ORDER] = ActionEntry(REDUCE, 368);
   _actionMap[926][GROUP] = ActionEntry(REDUCE, 368);
   _actionMap[926][WHERE] = ActionEntry(REDUCE, 368);
   _actionMap[926][THEN] = ActionEntry(REDUCE, 368);
   _actionMap[926][AND] = ActionEntry(REDUCE, 368);
   _actionMap[926][OR] = ActionEntry(REDUCE, 368);
   _actionMap[926][RB] = ActionEntry(REDUCE, 368);
   _actionMap[927][SEMICOLON] = ActionEntry(REDUCE, 237);
   _actionMap[927][RB] = ActionEntry(REDUCE, 237);
}
void Cego::loadParser11()
{
   _actionMap[928][ALL] = ActionEntry(SHIFT, 945);
   _actionMap[929][UNION] = ActionEntry(REDUCE, 285);
   _actionMap[929][ENDTOKEN] = ActionEntry(REDUCE, 285);
   _actionMap[929][RB] = ActionEntry(REDUCE, 285);
   _actionMap[929][SEMICOLON] = ActionEntry(REDUCE, 285);
   _actionMap[930][PLUS] = ActionEntry(SHIFT, 275);
   _actionMap[930][MINUS] = ActionEntry(SHIFT, 274);
   _actionMap[930][CONCAT] = ActionEntry(SHIFT, 273);
   _actionMap[930][ASC] = ActionEntry(SHIFT, 948);
   _actionMap[930][ROWLIMIT] = ActionEntry(REDUCE, 281);
   _actionMap[930][DESC] = ActionEntry(SHIFT, 949);
   _actionMap[930][UNION] = ActionEntry(REDUCE, 281);
   _actionMap[930][ENDTOKEN] = ActionEntry(REDUCE, 281);
   _actionMap[930][RB] = ActionEntry(REDUCE, 281);
   _actionMap[930][SEMICOLON] = ActionEntry(REDUCE, 281);
   _actionMap[930][KSEP] = ActionEntry(REDUCE, 281);
   _jumpMap[930][DefaultOrderOpt] = 947;
   _jumpMap[930][OrderingOpt] = 946;
   _actionMap[931][KSEP] = ActionEntry(SHIFT, 950);
   _actionMap[931][ROWLIMIT] = ActionEntry(REDUCE, 273);
   _actionMap[931][UNION] = ActionEntry(REDUCE, 273);
   _actionMap[931][ENDTOKEN] = ActionEntry(REDUCE, 273);
   _actionMap[931][RB] = ActionEntry(REDUCE, 273);
   _actionMap[931][SEMICOLON] = ActionEntry(REDUCE, 273);
   _actionMap[932][ORDER] = ActionEntry(REDUCE, 265);
   _actionMap[932][ROWLIMIT] = ActionEntry(REDUCE, 265);
   _actionMap[932][UNION] = ActionEntry(REDUCE, 265);
   _actionMap[932][ENDTOKEN] = ActionEntry(REDUCE, 265);
   _actionMap[932][RB] = ActionEntry(REDUCE, 265);
   _actionMap[932][SEMICOLON] = ActionEntry(REDUCE, 265);
   _actionMap[933][ORDER] = ActionEntry(REDUCE, 271);
   _actionMap[933][ROWLIMIT] = ActionEntry(REDUCE, 271);
   _actionMap[933][UNION] = ActionEntry(REDUCE, 271);
   _actionMap[933][ENDTOKEN] = ActionEntry(REDUCE, 271);
   _actionMap[933][RB] = ActionEntry(REDUCE, 271);
   _actionMap[933][SEMICOLON] = ActionEntry(REDUCE, 271);
   _actionMap[934][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[934][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[934][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[934][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[934][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[934][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[934][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[934][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[934][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[934][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[934][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[934][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[934][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[934][LOWER] = ActionEntry(SHIFT, 151);
}
void Cego::loadParser12()
{
   _actionMap[934][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[934][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[934][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[934][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[934][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[934][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[934][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[934][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[934][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[934][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[934][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[934][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[934][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[934][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[934][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[934][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[934][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[934][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[934][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[934][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[934][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[934][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[934][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[934][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[934][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[934][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[934][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[934][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[934][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[934][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[934][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[934][LB] = ActionEntry(SHIFT, 176);
   _actionMap[934][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[934][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[934][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[934][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[934][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[934][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[934][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[934][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[934][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[934][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[934][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[934][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[934][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[934][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[934][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[934][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[934][MAX] = ActionEntry(SHIFT, 154);
   _jumpMap[934][ObjSpec] = 121;
}
void Cego::loadParser13()
{
   _jumpMap[934][Constant] = 120;
   _jumpMap[934][SignedFloat] = 119;
   _jumpMap[934][SignedInt] = 118;
   _jumpMap[934][Attribute] = 117;
   _jumpMap[934][Function] = 116;
   _jumpMap[934][CasePrepare] = 115;
   _jumpMap[934][CaseClause] = 114;
   _jumpMap[934][Factor] = 113;
   _jumpMap[934][Term] = 112;
   _jumpMap[934][Expr] = 951;
   _actionMap[935][IDENTIFIER] = ActionEntry(SHIFT, 903);
   _actionMap[935][QUALIFIEDOBJ] = ActionEntry(SHIFT, 904);
   _actionMap[935][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _jumpMap[935][Attribute] = 952;
   _actionMap[936][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[936][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[936][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[936][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[936][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[936][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[936][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[936][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[936][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[936][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[936][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[936][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[936][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[936][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[936][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[936][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[936][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[936][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[936][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[936][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[936][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[936][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[936][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[936][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[936][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[936][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[936][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[936][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[936][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[936][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[936][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[936][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[936][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[936][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[936][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[936][BLOBSIZE] = ActionEntry(SHIFT, 129);
}
void Cego::loadParser14()
{
   _actionMap[936][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[936][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[936][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[936][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[936][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[936][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[936][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[936][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[936][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[936][LB] = ActionEntry(SHIFT, 445);
   _actionMap[936][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[936][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[936][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[936][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[936][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[936][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[936][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[936][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[936][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[936][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[936][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[936][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[936][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[936][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[936][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[936][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[936][MAX] = ActionEntry(SHIFT, 154);
   _actionMap[936][EXISTS] = ActionEntry(SHIFT, 443);
   _actionMap[936][NOT] = ActionEntry(SHIFT, 444);
   _jumpMap[936][ObjSpec] = 121;
   _jumpMap[936][Constant] = 120;
   _jumpMap[936][SignedFloat] = 119;
   _jumpMap[936][SignedInt] = 118;
   _jumpMap[936][Attribute] = 117;
   _jumpMap[936][QueryPredicate] = 442;
   _jumpMap[936][QueryCondition] = 953;
   _jumpMap[936][Function] = 116;
   _jumpMap[936][CasePrepare] = 115;
   _jumpMap[936][CaseClause] = 114;
   _jumpMap[936][Factor] = 113;
   _jumpMap[936][Term] = 112;
   _jumpMap[936][Expr] = 440;
   _actionMap[937][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[937][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[937][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[937][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[937][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[937][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[937][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[937][LTRIM] = ActionEntry(SHIFT, 152);
}
void Cego::loadParser15()
{
   _actionMap[937][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[937][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[937][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[937][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[937][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[937][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[937][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[937][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[937][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[937][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[937][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[937][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[937][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[937][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[937][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[937][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[937][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[937][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[937][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[937][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[937][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[937][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[937][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[937][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[937][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[937][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[937][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[937][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[937][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[937][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[937][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[937][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[937][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[937][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[937][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[937][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[937][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[937][LB] = ActionEntry(SHIFT, 445);
   _actionMap[937][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[937][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[937][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[937][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[937][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[937][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[937][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[937][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[937][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[937][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[937][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[937][FETCH] = ActionEntry(SHIFT, 142);
}
void Cego::loadParser16()
{
   _actionMap[937][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[937][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[937][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[937][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[937][MAX] = ActionEntry(SHIFT, 154);
   _actionMap[937][EXISTS] = ActionEntry(SHIFT, 443);
   _actionMap[937][NOT] = ActionEntry(SHIFT, 444);
   _jumpMap[937][ObjSpec] = 121;
   _jumpMap[937][Constant] = 120;
   _jumpMap[937][SignedFloat] = 119;
   _jumpMap[937][SignedInt] = 118;
   _jumpMap[937][Attribute] = 117;
   _jumpMap[937][QueryPredicate] = 442;
   _jumpMap[937][QueryCondition] = 954;
   _jumpMap[937][Function] = 116;
   _jumpMap[937][CasePrepare] = 115;
   _jumpMap[937][CaseClause] = 114;
   _jumpMap[937][Factor] = 113;
   _jumpMap[937][Term] = 112;
   _jumpMap[937][Expr] = 440;
   _actionMap[938][SEMICOLON] = ActionEntry(REDUCE, 295);
   _actionMap[938][KSEP] = ActionEntry(REDUCE, 295);
   _actionMap[939][KSEP] = ActionEntry(SHIFT, 908);
   _actionMap[939][SEMICOLON] = ActionEntry(REDUCE, 292);
   _actionMap[940][PLUS] = ActionEntry(SHIFT, 275);
   _actionMap[940][MINUS] = ActionEntry(SHIFT, 274);
   _actionMap[940][CONCAT] = ActionEntry(SHIFT, 273);
   _actionMap[940][SEMICOLON] = ActionEntry(REDUCE, 297);
   _actionMap[940][KSEP] = ActionEntry(REDUCE, 297);
   _actionMap[863][AND] = ActionEntry(SHIFT, 599);
   _actionMap[863][OR] = ActionEntry(SHIFT, 600);
   _actionMap[863][SEMICOLON] = ActionEntry(REDUCE, 86);
   _actionMap[864][IDENTIFIER] = ActionEntry(SHIFT, 826);
   _jumpMap[864][SimpleAttr] = 825;
   _jumpMap[864][SimpleAttrList] = 911;
   _actionMap[865][SEMICOLON] = ActionEntry(REDUCE, 307);
   _actionMap[865][KSEP] = ActionEntry(REDUCE, 307);
   _actionMap[866][LONG] = ActionEntry(SHIFT, 336);
   _actionMap[866][BIGINT] = ActionEntry(SHIFT, 332);
   _actionMap[866][SMALLINT] = ActionEntry(SHIFT, 337);
   _actionMap[866][TINYINT] = ActionEntry(SHIFT, 338);
   _actionMap[866][DOUBLE] = ActionEntry(SHIFT, 334);
   _actionMap[866][DECIMAL] = ActionEntry(SHIFT, 333);
   _actionMap[866][FIXED] = ActionEntry(SHIFT, 335);
   _actionMap[867][SEMICOLON] = ActionEntry(REDUCE, 308);
   _actionMap[867][KSEP] = ActionEntry(REDUCE, 308);
   _actionMap[868][THEN] = ActionEntry(SHIFT, 912);
   _actionMap[869][THEN] = ActionEntry(REDUCE, 150);
   _actionMap[870][END_TOKEN] = ActionEntry(REDUCE, 155);
   _actionMap[870][ELSE] = ActionEntry(REDUCE, 155);
}
void Cego::loadParser17()
{
   _actionMap[870][ELSIF] = ActionEntry(REDUCE, 155);
   _actionMap[871][BEGIN] = ActionEntry(REDUCE, 169);
   _actionMap[871][THEN] = ActionEntry(REDUCE, 169);
   _actionMap[871][OR] = ActionEntry(REDUCE, 169);
   _actionMap[871][AND] = ActionEntry(REDUCE, 169);
   _actionMap[871][RB] = ActionEntry(REDUCE, 169);
   _actionMap[872][PLUS] = ActionEntry(SHIFT, 275);
   _actionMap[872][MINUS] = ActionEntry(SHIFT, 274);
   _actionMap[872][CONCAT] = ActionEntry(SHIFT, 273);
   _actionMap[872][SEMICOLON] = ActionEntry(REDUCE, 127);
   _actionMap[873][RB] = ActionEntry(SHIFT, 913);
   _actionMap[874][RB] = ActionEntry(SHIFT, 914);
   _actionMap[875][RB] = ActionEntry(SHIFT, 915);
   _actionMap[876][RB] = ActionEntry(REDUCE, 393);
   _actionMap[876][KSEP] = ActionEntry(SHIFT, 916);
   _actionMap[877][RB] = ActionEntry(SHIFT, 917);
   _actionMap[878][SEMICOLON] = ActionEntry(REDUCE, 161);
   _actionMap[879][RB] = ActionEntry(SHIFT, 918);
   _actionMap[880][IDENTIFIER] = ActionEntry(SHIFT, 823);
   _jumpMap[880][AliasAttr] = 919;
   _actionMap[881][SEMICOLON] = ActionEntry(REDUCE, 67);
   _actionMap[882][IDENTIFIER] = ActionEntry(SHIFT, 920);
   _actionMap[883][CACHED] = ActionEntry(SHIFT, 922);
   _actionMap[883][SEMICOLON] = ActionEntry(REDUCE, 66);
   _jumpMap[883][CachedOpt] = 921;
   _actionMap[884][IDENTIFIER] = ActionEntry(SHIFT, 826);
   _jumpMap[884][SimpleAttr] = 825;
   _jumpMap[884][SimpleAttrList] = 923;
   _actionMap[885][SEMICOLON] = ActionEntry(REDUCE, 202);
   _actionMap[885][KSEP] = ActionEntry(REDUCE, 202);
   _actionMap[885][RB] = ActionEntry(REDUCE, 202);
   _actionMap[886][SEMICOLON] = ActionEntry(REDUCE, 205);
   _actionMap[886][KSEP] = ActionEntry(REDUCE, 205);
   _actionMap[886][RB] = ActionEntry(REDUCE, 205);
   _actionMap[887][NULLTOKEN] = ActionEntry(SHIFT, 924);
   _actionMap[888][SEMICOLON] = ActionEntry(REDUCE, 203);
   _actionMap[888][KSEP] = ActionEntry(REDUCE, 203);
   _actionMap[888][RB] = ActionEntry(REDUCE, 203);
   _actionMap[889][NULLTOKEN] = ActionEntry(REDUCE, 207);
   _actionMap[889][NOT] = ActionEntry(REDUCE, 207);
   _actionMap[889][KSEP] = ActionEntry(REDUCE, 207);
   _actionMap[889][SEMICOLON] = ActionEntry(REDUCE, 207);
   _actionMap[889][RB] = ActionEntry(REDUCE, 207);
   _actionMap[890][PLUS] = ActionEntry(SHIFT, 275);
   _actionMap[890][MINUS] = ActionEntry(SHIFT, 274);
   _actionMap[890][CONCAT] = ActionEntry(SHIFT, 273);
   _actionMap[890][KSEP] = ActionEntry(REDUCE, 234);
   _actionMap[890][RB] = ActionEntry(REDUCE, 234);
   _actionMap[891][PLUS] = ActionEntry(SHIFT, 275);
   _actionMap[891][MINUS] = ActionEntry(SHIFT, 274);
}
void Cego::loadParser18()
{
   _actionMap[891][CONCAT] = ActionEntry(SHIFT, 273);
   _actionMap[891][LEFT] = ActionEntry(REDUCE, 372);
   _actionMap[891][RIGHT] = ActionEntry(REDUCE, 372);
   _actionMap[891][INNER] = ActionEntry(REDUCE, 372);
   _actionMap[891][JOIN] = ActionEntry(REDUCE, 372);
   _actionMap[891][RETURNTOKEN] = ActionEntry(REDUCE, 372);
   _actionMap[891][SEMICOLON] = ActionEntry(REDUCE, 372);
   _actionMap[891][ENDTOKEN] = ActionEntry(REDUCE, 372);
   _actionMap[891][UNION] = ActionEntry(REDUCE, 372);
   _actionMap[891][ROWLIMIT] = ActionEntry(REDUCE, 372);
   _actionMap[891][ORDER] = ActionEntry(REDUCE, 372);
   _actionMap[891][GROUP] = ActionEntry(REDUCE, 372);
   _actionMap[891][WHERE] = ActionEntry(REDUCE, 372);
   _actionMap[891][THEN] = ActionEntry(REDUCE, 372);
   _actionMap[891][AND] = ActionEntry(REDUCE, 372);
   _actionMap[891][OR] = ActionEntry(REDUCE, 372);
   _actionMap[891][RB] = ActionEntry(REDUCE, 372);
   _actionMap[892][LEFT] = ActionEntry(REDUCE, 369);
   _actionMap[892][RIGHT] = ActionEntry(REDUCE, 369);
   _actionMap[892][INNER] = ActionEntry(REDUCE, 369);
   _actionMap[892][JOIN] = ActionEntry(REDUCE, 369);
   _actionMap[892][RETURNTOKEN] = ActionEntry(REDUCE, 369);
   _actionMap[892][SEMICOLON] = ActionEntry(REDUCE, 369);
   _actionMap[892][ENDTOKEN] = ActionEntry(REDUCE, 369);
   _actionMap[892][UNION] = ActionEntry(REDUCE, 369);
   _actionMap[892][ROWLIMIT] = ActionEntry(REDUCE, 369);
   _actionMap[892][ORDER] = ActionEntry(REDUCE, 369);
   _actionMap[892][GROUP] = ActionEntry(REDUCE, 369);
   _actionMap[892][WHERE] = ActionEntry(REDUCE, 369);
   _actionMap[892][THEN] = ActionEntry(REDUCE, 369);
   _actionMap[892][AND] = ActionEntry(REDUCE, 369);
   _actionMap[892][OR] = ActionEntry(REDUCE, 369);
   _actionMap[892][RB] = ActionEntry(REDUCE, 369);
   _actionMap[893][LEFT] = ActionEntry(REDUCE, 367);
   _actionMap[893][RIGHT] = ActionEntry(REDUCE, 367);
   _actionMap[893][INNER] = ActionEntry(REDUCE, 367);
   _actionMap[893][JOIN] = ActionEntry(REDUCE, 367);
   _actionMap[893][RETURNTOKEN] = ActionEntry(REDUCE, 367);
   _actionMap[893][SEMICOLON] = ActionEntry(REDUCE, 367);
   _actionMap[893][ENDTOKEN] = ActionEntry(REDUCE, 367);
   _actionMap[893][UNION] = ActionEntry(REDUCE, 367);
   _actionMap[893][ROWLIMIT] = ActionEntry(REDUCE, 367);
   _actionMap[893][ORDER] = ActionEntry(REDUCE, 367);
   _actionMap[893][GROUP] = ActionEntry(REDUCE, 367);
   _actionMap[893][WHERE] = ActionEntry(REDUCE, 367);
   _actionMap[893][THEN] = ActionEntry(REDUCE, 367);
   _actionMap[893][AND] = ActionEntry(REDUCE, 367);
   _actionMap[893][OR] = ActionEntry(REDUCE, 367);
   _actionMap[893][RB] = ActionEntry(REDUCE, 367);
   _actionMap[894][RB] = ActionEntry(SHIFT, 925);
}
void Cego::loadParser19()
{
   _actionMap[895][RB] = ActionEntry(SHIFT, 926);
   _actionMap[895][KSEP] = ActionEntry(SHIFT, 606);
   _actionMap[896][KSEP] = ActionEntry(REDUCE, 196);
   _actionMap[896][RB] = ActionEntry(REDUCE, 196);
   _actionMap[897][UNION] = ActionEntry(SHIFT, 928);
   _actionMap[897][SEMICOLON] = ActionEntry(REDUCE, 98);
   _actionMap[897][RB] = ActionEntry(REDUCE, 98);
   _jumpMap[897][UnionAllOpt] = 927;
   _actionMap[898][UNION] = ActionEntry(REDUCE, 286);
   _actionMap[898][ENDTOKEN] = ActionEntry(REDUCE, 286);
   _actionMap[898][RB] = ActionEntry(REDUCE, 286);
   _actionMap[898][SEMICOLON] = ActionEntry(REDUCE, 286);
   _actionMap[899][INTVAL] = ActionEntry(SHIFT, 929);
   _actionMap[900][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[900][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[900][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[900][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[900][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[900][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[900][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[900][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[900][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[900][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[900][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[900][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[900][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[900][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[900][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[900][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[900][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[900][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[900][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[900][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[900][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[900][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[900][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[900][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[900][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[900][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[900][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[900][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[900][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[900][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[900][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[900][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[900][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[900][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[900][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[900][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[900][BLOBREF] = ActionEntry(SHIFT, 130);
}
void Cego::loadParser20()
{
   _actionMap[900][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[900][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[900][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[900][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[900][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[900][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[900][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[900][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[900][LB] = ActionEntry(SHIFT, 176);
   _actionMap[900][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[900][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[900][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[900][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[900][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[900][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[900][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[900][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[900][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[900][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[900][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[900][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[900][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[900][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[900][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[900][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[900][MAX] = ActionEntry(SHIFT, 154);
   _jumpMap[900][ObjSpec] = 121;
   _jumpMap[900][Constant] = 120;
   _jumpMap[900][SignedFloat] = 119;
   _jumpMap[900][SignedInt] = 118;
   _jumpMap[900][Attribute] = 117;
   _jumpMap[900][Function] = 116;
   _jumpMap[900][OrderingList] = 931;
   _jumpMap[900][CasePrepare] = 115;
   _jumpMap[900][CaseClause] = 114;
   _jumpMap[900][Factor] = 113;
   _jumpMap[900][Term] = 112;
   _jumpMap[900][Expr] = 930;
   _actionMap[901][KSEP] = ActionEntry(SHIFT, 935);
   _actionMap[901][ORDER] = ActionEntry(REDUCE, 272);
   _actionMap[901][HAVING] = ActionEntry(SHIFT, 934);
   _actionMap[901][ROWLIMIT] = ActionEntry(REDUCE, 272);
   _actionMap[901][UNION] = ActionEntry(REDUCE, 272);
   _actionMap[901][ENDTOKEN] = ActionEntry(REDUCE, 272);
   _actionMap[901][RB] = ActionEntry(REDUCE, 272);
   _actionMap[901][SEMICOLON] = ActionEntry(REDUCE, 272);
   _jumpMap[901][NoHaving] = 933;
   _jumpMap[901][HavingClause] = 932;
   _actionMap[902][KSEP] = ActionEntry(REDUCE, 269);
   _actionMap[902][HAVING] = ActionEntry(REDUCE, 269);
}
void Cego::loadParser21()
{
   _actionMap[902][ORDER] = ActionEntry(REDUCE, 269);
   _actionMap[902][ROWLIMIT] = ActionEntry(REDUCE, 269);
   _actionMap[902][UNION] = ActionEntry(REDUCE, 269);
   _actionMap[902][ENDTOKEN] = ActionEntry(REDUCE, 269);
   _actionMap[902][RB] = ActionEntry(REDUCE, 269);
   _actionMap[902][SEMICOLON] = ActionEntry(REDUCE, 269);
   _actionMap[903][KSEP] = ActionEntry(REDUCE, 401);
   _actionMap[903][HAVING] = ActionEntry(REDUCE, 401);
   _actionMap[903][ORDER] = ActionEntry(REDUCE, 401);
   _actionMap[903][ROWLIMIT] = ActionEntry(REDUCE, 401);
   _actionMap[903][UNION] = ActionEntry(REDUCE, 401);
   _actionMap[903][ENDTOKEN] = ActionEntry(REDUCE, 401);
   _actionMap[903][RB] = ActionEntry(REDUCE, 401);
   _actionMap[903][SEMICOLON] = ActionEntry(REDUCE, 401);
   _actionMap[904][KSEP] = ActionEntry(REDUCE, 402);
   _actionMap[904][HAVING] = ActionEntry(REDUCE, 402);
   _actionMap[904][ORDER] = ActionEntry(REDUCE, 402);
   _actionMap[904][ROWLIMIT] = ActionEntry(REDUCE, 402);
   _actionMap[904][UNION] = ActionEntry(REDUCE, 402);
   _actionMap[904][ENDTOKEN] = ActionEntry(REDUCE, 402);
   _actionMap[904][RB] = ActionEntry(REDUCE, 402);
   _actionMap[904][SEMICOLON] = ActionEntry(REDUCE, 402);
   _actionMap[905][AND] = ActionEntry(SHIFT, 599);
   _actionMap[905][OR] = ActionEntry(SHIFT, 600);
   _actionMap[905][LEFT] = ActionEntry(REDUCE, 250);
   _actionMap[905][RIGHT] = ActionEntry(REDUCE, 250);
   _actionMap[905][INNER] = ActionEntry(REDUCE, 250);
   _actionMap[905][JOIN] = ActionEntry(REDUCE, 250);
   _actionMap[905][RETURNTOKEN] = ActionEntry(REDUCE, 250);
   _actionMap[905][SEMICOLON] = ActionEntry(REDUCE, 250);
   _actionMap[905][RB] = ActionEntry(REDUCE, 250);
   _actionMap[905][ENDTOKEN] = ActionEntry(REDUCE, 250);
   _actionMap[905][UNION] = ActionEntry(REDUCE, 250);
   _actionMap[905][ROWLIMIT] = ActionEntry(REDUCE, 250);
   _actionMap[905][ORDER] = ActionEntry(REDUCE, 250);
   _actionMap[905][GROUP] = ActionEntry(REDUCE, 250);
   _actionMap[905][WHERE] = ActionEntry(REDUCE, 250);
   _actionMap[906][ON] = ActionEntry(SHIFT, 936);
   _actionMap[906][LEFT] = ActionEntry(REDUCE, 251);
   _actionMap[906][RIGHT] = ActionEntry(REDUCE, 251);
   _actionMap[906][INNER] = ActionEntry(REDUCE, 251);
   _actionMap[906][JOIN] = ActionEntry(REDUCE, 251);
   _actionMap[906][RETURNTOKEN] = ActionEntry(REDUCE, 251);
   _actionMap[906][SEMICOLON] = ActionEntry(REDUCE, 251);
   _actionMap[906][RB] = ActionEntry(REDUCE, 251);
   _actionMap[906][ENDTOKEN] = ActionEntry(REDUCE, 251);
   _actionMap[906][UNION] = ActionEntry(REDUCE, 251);
   _actionMap[906][ROWLIMIT] = ActionEntry(REDUCE, 251);
   _actionMap[906][ORDER] = ActionEntry(REDUCE, 251);
   _actionMap[906][GROUP] = ActionEntry(REDUCE, 251);
}
void Cego::loadParser22()
{
   _actionMap[906][WHERE] = ActionEntry(REDUCE, 251);
   _actionMap[907][ON] = ActionEntry(SHIFT, 937);
   _actionMap[907][LEFT] = ActionEntry(REDUCE, 253);
   _actionMap[907][RIGHT] = ActionEntry(REDUCE, 253);
   _actionMap[907][INNER] = ActionEntry(REDUCE, 253);
   _actionMap[907][JOIN] = ActionEntry(REDUCE, 253);
   _actionMap[907][RETURNTOKEN] = ActionEntry(REDUCE, 253);
   _actionMap[907][SEMICOLON] = ActionEntry(REDUCE, 253);
   _actionMap[907][RB] = ActionEntry(REDUCE, 253);
   _actionMap[907][ENDTOKEN] = ActionEntry(REDUCE, 253);
   _actionMap[907][UNION] = ActionEntry(REDUCE, 253);
   _actionMap[907][ROWLIMIT] = ActionEntry(REDUCE, 253);
   _actionMap[907][ORDER] = ActionEntry(REDUCE, 253);
   _actionMap[907][GROUP] = ActionEntry(REDUCE, 253);
   _actionMap[907][WHERE] = ActionEntry(REDUCE, 253);
   _actionMap[908][VARREF] = ActionEntry(SHIFT, 862);
   _jumpMap[908][ReturnVar] = 938;
   _actionMap[909][VARREF] = ActionEntry(SHIFT, 862);
   _jumpMap[909][ReturnVar] = 860;
   _jumpMap[909][ReturnVarList] = 939;
   _actionMap[910][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[910][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[910][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[910][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[910][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[910][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[910][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[910][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[910][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[910][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[910][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[910][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[910][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[910][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[910][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[910][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[910][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[910][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[910][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[910][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[910][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[910][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[910][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[910][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[910][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[910][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[910][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[910][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[910][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[910][LMOD] = ActionEntry(SHIFT, 150);
}
void Cego::loadParser23()
{
   _actionMap[910][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[910][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[910][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[910][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[910][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[910][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[910][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[910][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[910][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[910][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[910][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[910][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[910][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[910][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[910][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[910][LB] = ActionEntry(SHIFT, 176);
   _actionMap[910][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[910][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[910][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[910][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[910][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[910][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[910][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[910][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[910][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[910][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[910][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[910][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[910][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[910][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[910][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[910][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[910][MAX] = ActionEntry(SHIFT, 154);
   _jumpMap[910][ObjSpec] = 121;
   _jumpMap[910][Constant] = 120;
   _jumpMap[910][SignedFloat] = 119;
   _jumpMap[910][SignedInt] = 118;
   _jumpMap[910][Attribute] = 117;
   _jumpMap[910][Function] = 116;
   _jumpMap[910][CasePrepare] = 115;
   _jumpMap[910][CaseClause] = 114;
   _jumpMap[910][Factor] = 113;
   _jumpMap[910][Term] = 112;
   _jumpMap[910][Expr] = 940;
   _actionMap[796][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[796][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[796][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[796][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[796][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[796][TRIM] = ActionEntry(SHIFT, 172);
}
void Cego::loadParser24()
{
   _actionMap[796][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[796][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[796][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[796][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[796][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[796][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[796][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[796][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[796][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[796][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[796][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[796][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[796][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[796][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[796][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[796][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[796][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[796][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[796][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[796][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[796][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[796][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[796][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[796][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[796][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[796][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[796][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[796][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[796][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[796][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[796][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[796][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[796][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[796][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[796][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[796][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[796][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[796][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[796][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[796][LB] = ActionEntry(SHIFT, 445);
   _actionMap[796][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[796][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[796][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[796][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[796][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[796][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[796][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[796][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[796][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[796][CASE] = ActionEntry(SHIFT, 131);
}
void Cego::loadParser25()
{
   _actionMap[796][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[796][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[796][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[796][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[796][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[796][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[796][MAX] = ActionEntry(SHIFT, 154);
   _actionMap[796][EXISTS] = ActionEntry(SHIFT, 443);
   _actionMap[796][NOT] = ActionEntry(SHIFT, 444);
   _jumpMap[796][ObjSpec] = 121;
   _jumpMap[796][Constant] = 120;
   _jumpMap[796][SignedFloat] = 119;
   _jumpMap[796][SignedInt] = 118;
   _jumpMap[796][Attribute] = 117;
   _jumpMap[796][QueryPredicate] = 442;
   _jumpMap[796][QueryCondition] = 863;
   _jumpMap[796][Function] = 116;
   _jumpMap[796][CasePrepare] = 115;
   _jumpMap[796][CaseClause] = 114;
   _jumpMap[796][Factor] = 113;
   _jumpMap[796][Term] = 112;
   _jumpMap[796][Expr] = 440;
   _actionMap[797][LB] = ActionEntry(SHIFT, 864);
   _actionMap[798][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[798][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[798][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[798][LB] = ActionEntry(SHIFT, 866);
   _actionMap[798][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[798][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[798][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[798][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[798][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[798][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[798][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[798][CLOB] = ActionEntry(SHIFT, 132);
   _jumpMap[798][Constant] = 865;
   _jumpMap[798][SignedFloat] = 119;
   _jumpMap[798][SignedInt] = 118;
   _actionMap[799][IDENTIFIER] = ActionEntry(SHIFT, 867);
   _actionMap[800][SEMICOLON] = ActionEntry(REDUCE, 36);
   _actionMap[801][IDENTIFIER] = ActionEntry(SHIFT, 869);
   _jumpMap[801][ProcExceptionType] = 868;
   _actionMap[802][END_TOKEN] = ActionEntry(REDUCE, 156);
   _actionMap[803][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[803][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[803][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[803][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[803][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[803][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[803][RTRIM] = ActionEntry(SHIFT, 164);
}
void Cego::loadParser26()
{
   _actionMap[803][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[803][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[803][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[803][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[803][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[803][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[803][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[803][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[803][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[803][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[803][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[803][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[803][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[803][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[803][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[803][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[803][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[803][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[803][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[803][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[803][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[803][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[803][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[803][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[803][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[803][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[803][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[803][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[803][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[803][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[803][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[803][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[803][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[803][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[803][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[803][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[803][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[803][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[803][LB] = ActionEntry(SHIFT, 176);
   _actionMap[803][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[803][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[803][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[803][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[803][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[803][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[803][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[803][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[803][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[803][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[803][VARREF] = ActionEntry(SHIFT, 410);
}
void Cego::loadParser27()
{
   _actionMap[803][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[803][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[803][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[803][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[803][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[803][MAX] = ActionEntry(SHIFT, 154);
   _actionMap[803][IF] = ActionEntry(SHIFT, 404);
   _actionMap[803][BEGIN] = ActionEntry(SHIFT, 401);
   _actionMap[803][UNLOCK] = ActionEntry(SHIFT, 28);
   _actionMap[803][LOCK] = ActionEntry(SHIFT, 27);
   _actionMap[803][ROLLBACK] = ActionEntry(SHIFT, 33);
   _actionMap[803][COMMIT] = ActionEntry(SHIFT, 18);
   _actionMap[803][START_TOKEN] = ActionEntry(SHIFT, 37);
   _actionMap[803][UPDATE] = ActionEntry(SHIFT, 43);
   _actionMap[803][DELETETOK] = ActionEntry(SHIFT, 20);
   _actionMap[803][INSERT] = ActionEntry(SHIFT, 23);
   _actionMap[803][VAR] = ActionEntry(SHIFT, 408);
   _actionMap[803][CURSOR] = ActionEntry(SHIFT, 403);
   _actionMap[803][CLOSE] = ActionEntry(SHIFT, 402);
   _actionMap[803][NOOP] = ActionEntry(SHIFT, 405);
   _actionMap[803][THROW] = ActionEntry(SHIFT, 407);
   _actionMap[803][RETURNTOKEN] = ActionEntry(SHIFT, 406);
   _actionMap[803][WHILE] = ActionEntry(SHIFT, 409);
   _jumpMap[803][ObjSpec] = 121;
   _jumpMap[803][Constant] = 120;
   _jumpMap[803][SignedFloat] = 119;
   _jumpMap[803][SignedInt] = 118;
   _jumpMap[803][Attribute] = 117;
   _jumpMap[803][Function] = 116;
   _jumpMap[803][DeleteStatement] = 400;
   _jumpMap[803][UpdateStatement] = 399;
   _jumpMap[803][InsertStatement] = 398;
   _jumpMap[803][UnlockStatement] = 397;
   _jumpMap[803][LockStatement] = 396;
   _jumpMap[803][RollbackStatement] = 395;
   _jumpMap[803][CommitStatement] = 394;
   _jumpMap[803][StartStatement] = 393;
   _jumpMap[803][CasePrepare] = 115;
   _jumpMap[803][CaseClause] = 114;
   _jumpMap[803][Factor] = 113;
   _jumpMap[803][Term] = 112;
   _jumpMap[803][Expr] = 392;
   _jumpMap[803][ProcStatement] = 391;
   _jumpMap[803][ProcIfPart] = 390;
   _jumpMap[803][ProcBlockStart] = 389;
   _jumpMap[803][ProcStatementList] = 388;
   _jumpMap[803][ProcStmtBlock] = 870;
   _actionMap[804][SEMICOLON] = ActionEntry(REDUCE, 122);
   _actionMap[805][END_TOKEN] = ActionEntry(REDUCE, 152);
   _actionMap[805][ELSE] = ActionEntry(REDUCE, 152);
}
void Cego::loadParser28()
{
   _actionMap[805][ELSIF] = ActionEntry(REDUCE, 152);
   _actionMap[806][BEGIN] = ActionEntry(REDUCE, 164);
   _actionMap[806][RB] = ActionEntry(REDUCE, 164);
   _actionMap[806][AND] = ActionEntry(REDUCE, 164);
   _actionMap[806][OR] = ActionEntry(REDUCE, 164);
   _actionMap[806][THEN] = ActionEntry(REDUCE, 164);
   _actionMap[807][BEGIN] = ActionEntry(REDUCE, 163);
   _actionMap[807][RB] = ActionEntry(REDUCE, 163);
   _actionMap[807][AND] = ActionEntry(REDUCE, 163);
   _actionMap[807][OR] = ActionEntry(REDUCE, 163);
   _actionMap[807][THEN] = ActionEntry(REDUCE, 163);
   _actionMap[808][PLUS] = ActionEntry(SHIFT, 275);
   _actionMap[808][MINUS] = ActionEntry(SHIFT, 274);
   _actionMap[808][CONCAT] = ActionEntry(SHIFT, 273);
   _actionMap[808][BEGIN] = ActionEntry(REDUCE, 167);
   _actionMap[808][THEN] = ActionEntry(REDUCE, 167);
   _actionMap[808][OR] = ActionEntry(REDUCE, 167);
   _actionMap[808][AND] = ActionEntry(REDUCE, 167);
   _actionMap[808][RB] = ActionEntry(REDUCE, 167);
   _actionMap[809][NULLTOKEN] = ActionEntry(SHIFT, 871);
   _actionMap[810][BEGIN] = ActionEntry(REDUCE, 168);
   _actionMap[810][THEN] = ActionEntry(REDUCE, 168);
   _actionMap[810][OR] = ActionEntry(REDUCE, 168);
   _actionMap[810][AND] = ActionEntry(REDUCE, 168);
   _actionMap[810][RB] = ActionEntry(REDUCE, 168);
   _actionMap[811][BEGIN] = ActionEntry(REDUCE, 166);
   _actionMap[811][RB] = ActionEntry(REDUCE, 166);
   _actionMap[811][AND] = ActionEntry(REDUCE, 166);
   _actionMap[811][OR] = ActionEntry(REDUCE, 166);
   _actionMap[811][THEN] = ActionEntry(REDUCE, 166);
   _actionMap[812][SEMICOLON] = ActionEntry(REDUCE, 121);
   _actionMap[813][SEMICOLON] = ActionEntry(REDUCE, 128);
   _actionMap[814][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[814][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[814][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[814][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[814][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[814][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[814][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[814][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[814][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[814][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[814][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[814][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[814][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[814][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[814][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[814][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[814][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[814][GETPOS] = ActionEntry(SHIFT, 143);
}
void Cego::loadParser29()
{
   _actionMap[814][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[814][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[814][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[814][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[814][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[814][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[814][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[814][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[814][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[814][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[814][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[814][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[814][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[814][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[814][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[814][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[814][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[814][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[814][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[814][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[814][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[814][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[814][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[814][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[814][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[814][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[814][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[814][LB] = ActionEntry(SHIFT, 176);
   _actionMap[814][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[814][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[814][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[814][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[814][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[814][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[814][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[814][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[814][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[814][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[814][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[814][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[814][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[814][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[814][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[814][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[814][MAX] = ActionEntry(SHIFT, 154);
   _jumpMap[814][ObjSpec] = 121;
   _jumpMap[814][Constant] = 120;
   _jumpMap[814][SignedFloat] = 119;
   _jumpMap[814][SignedInt] = 118;
   _jumpMap[814][Attribute] = 117;
}
void Cego::loadParser30()
{
   _jumpMap[814][Function] = 116;
   _jumpMap[814][CasePrepare] = 115;
   _jumpMap[814][CaseClause] = 114;
   _jumpMap[814][Factor] = 113;
   _jumpMap[814][Term] = 112;
   _jumpMap[814][Expr] = 872;
   _actionMap[815][INTVAL] = ActionEntry(SHIFT, 873);
   _actionMap[816][INTVAL] = ActionEntry(SHIFT, 874);
   _actionMap[817][INTVAL] = ActionEntry(SHIFT, 876);
   _jumpMap[817][DecimalDim] = 875;
   _actionMap[818][INTVAL] = ActionEntry(SHIFT, 877);
   _actionMap[819][END_TOKEN] = ActionEntry(SHIFT, 878);
   _actionMap[820][IDENTIFIER] = ActionEntry(SHIFT, 826);
   _jumpMap[820][SimpleAttr] = 825;
   _jumpMap[820][SimpleAttrList] = 879;
   _actionMap[821][RB] = ActionEntry(SHIFT, 881);
   _actionMap[821][KSEP] = ActionEntry(SHIFT, 880);
   _actionMap[822][KSEP] = ActionEntry(REDUCE, 69);
   _actionMap[822][RB] = ActionEntry(REDUCE, 69);
   _actionMap[823][AS] = ActionEntry(SHIFT, 882);
   _actionMap[824][RB] = ActionEntry(SHIFT, 883);
   _actionMap[825][KSEP] = ActionEntry(SHIFT, 884);
   _actionMap[825][RB] = ActionEntry(REDUCE, 211);
   _actionMap[826][RB] = ActionEntry(REDUCE, 212);
   _actionMap[826][KSEP] = ActionEntry(REDUCE, 212);
   _actionMap[827][KSEP] = ActionEntry(REDUCE, 114);
   _actionMap[827][RB] = ActionEntry(REDUCE, 114);
   _actionMap[828][BEGIN] = ActionEntry(REDUCE, 110);
   _actionMap[829][KSEP] = ActionEntry(REDUCE, 116);
   _actionMap[829][RB] = ActionEntry(REDUCE, 116);
   _actionMap[830][KSEP] = ActionEntry(REDUCE, 117);
   _actionMap[830][RB] = ActionEntry(REDUCE, 117);
   _actionMap[831][KSEP] = ActionEntry(REDUCE, 198);
   _actionMap[831][RB] = ActionEntry(REDUCE, 198);
   _actionMap[832][SEMICOLON] = ActionEntry(REDUCE, 206);
   _actionMap[832][NULLTOKEN] = ActionEntry(SHIFT, 888);
   _actionMap[832][NOT] = ActionEntry(SHIFT, 887);
   _actionMap[832][KSEP] = ActionEntry(REDUCE, 206);
   _actionMap[832][RB] = ActionEntry(REDUCE, 206);
   _jumpMap[832][DefaultNullOpt] = 886;
   _jumpMap[832][NullOpt] = 885;
   _actionMap[833][NULLTOKEN] = ActionEntry(REDUCE, 208);
   _actionMap[833][NOT] = ActionEntry(REDUCE, 208);
   _actionMap[833][KSEP] = ActionEntry(REDUCE, 208);
   _actionMap[833][SEMICOLON] = ActionEntry(REDUCE, 208);
   _actionMap[833][RB] = ActionEntry(REDUCE, 208);
   _actionMap[834][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[834][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[834][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[834][LB] = ActionEntry(SHIFT, 866);
}
void Cego::loadParser31()
{
   _actionMap[834][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[834][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[834][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[834][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[834][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[834][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[834][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[834][CLOB] = ActionEntry(SHIFT, 132);
   _jumpMap[834][Constant] = 889;
   _jumpMap[834][SignedFloat] = 119;
   _jumpMap[834][SignedInt] = 118;
   _actionMap[835][BEGIN] = ActionEntry(REDUCE, 100);
   _actionMap[836][OR] = ActionEntry(REDUCE, 103);
   _actionMap[836][ON] = ActionEntry(REDUCE, 103);
   _actionMap[837][SEMICOLON] = ActionEntry(REDUCE, 229);
   _actionMap[837][KSEP] = ActionEntry(REDUCE, 229);
   _actionMap[838][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[838][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[838][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[838][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[838][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[838][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[838][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[838][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[838][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[838][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[838][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[838][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[838][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[838][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[838][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[838][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[838][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[838][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[838][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[838][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[838][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[838][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[838][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[838][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[838][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[838][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[838][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[838][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[838][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[838][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[838][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[838][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[838][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[838][BITOR] = ActionEntry(SHIFT, 126);
}
void Cego::loadParser32()
{
   _actionMap[838][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[838][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[838][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[838][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[838][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[838][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[838][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[838][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[838][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[838][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[838][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[838][LB] = ActionEntry(SHIFT, 176);
   _actionMap[838][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[838][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[838][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[838][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[838][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[838][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[838][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[838][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[838][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[838][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[838][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[838][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[838][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[838][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[838][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[838][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[838][MAX] = ActionEntry(SHIFT, 154);
   _jumpMap[838][ObjSpec] = 121;
   _jumpMap[838][Constant] = 120;
   _jumpMap[838][SignedFloat] = 119;
   _jumpMap[838][SignedInt] = 118;
   _jumpMap[838][Attribute] = 117;
   _jumpMap[838][Function] = 116;
   _jumpMap[838][CasePrepare] = 115;
   _jumpMap[838][CaseClause] = 114;
   _jumpMap[838][Factor] = 113;
   _jumpMap[838][Term] = 112;
   _jumpMap[838][Expr] = 890;
   _actionMap[839][SEMICOLON] = ActionEntry(REDUCE, 231);
   _actionMap[839][KSEP] = ActionEntry(REDUCE, 231);
   _actionMap[840][KSEP] = ActionEntry(REDUCE, 232);
   _actionMap[840][RB] = ActionEntry(REDUCE, 232);
   _actionMap[841][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[841][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[841][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[841][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[841][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[841][TRIM] = ActionEntry(SHIFT, 172);
}
void Cego::loadParser33()
{
   _actionMap[841][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[841][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[841][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[841][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[841][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[841][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[841][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[841][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[841][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[841][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[841][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[841][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[841][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[841][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[841][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[841][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[841][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[841][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[841][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[841][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[841][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[841][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[841][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[841][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[841][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[841][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[841][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[841][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[841][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[841][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[841][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[841][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[841][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[841][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[841][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[841][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[841][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[841][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[841][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[841][LB] = ActionEntry(SHIFT, 176);
   _actionMap[841][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[841][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[841][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[841][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[841][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[841][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[841][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[841][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[841][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[841][CASE] = ActionEntry(SHIFT, 131);
}
void Cego::loadParser34()
{
   _actionMap[841][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[841][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[841][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[841][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[841][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[841][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[841][MAX] = ActionEntry(SHIFT, 154);
   _jumpMap[841][ObjSpec] = 121;
   _jumpMap[841][Constant] = 120;
   _jumpMap[841][SignedFloat] = 119;
   _jumpMap[841][SignedInt] = 118;
   _jumpMap[841][Attribute] = 117;
   _jumpMap[841][Function] = 116;
   _jumpMap[841][CasePrepare] = 115;
   _jumpMap[841][CaseClause] = 114;
   _jumpMap[841][Factor] = 113;
   _jumpMap[841][Term] = 112;
   _jumpMap[841][Expr] = 891;
   _actionMap[842][RB] = ActionEntry(SHIFT, 892);
   _actionMap[843][RB] = ActionEntry(SHIFT, 893);
   _actionMap[843][KSEP] = ActionEntry(SHIFT, 606);
   _actionMap[844][LEFT] = ActionEntry(REDUCE, 374);
   _actionMap[844][RIGHT] = ActionEntry(REDUCE, 374);
   _actionMap[844][INNER] = ActionEntry(REDUCE, 374);
   _actionMap[844][JOIN] = ActionEntry(REDUCE, 374);
   _actionMap[844][RETURNTOKEN] = ActionEntry(REDUCE, 374);
   _actionMap[844][SEMICOLON] = ActionEntry(REDUCE, 374);
   _actionMap[844][ENDTOKEN] = ActionEntry(REDUCE, 374);
   _actionMap[844][UNION] = ActionEntry(REDUCE, 374);
   _actionMap[844][ROWLIMIT] = ActionEntry(REDUCE, 374);
   _actionMap[844][ORDER] = ActionEntry(REDUCE, 374);
   _actionMap[844][GROUP] = ActionEntry(REDUCE, 374);
   _actionMap[844][WHERE] = ActionEntry(REDUCE, 374);
   _actionMap[844][THEN] = ActionEntry(REDUCE, 374);
   _actionMap[844][AND] = ActionEntry(REDUCE, 374);
   _actionMap[844][OR] = ActionEntry(REDUCE, 374);
   _actionMap[844][RB] = ActionEntry(REDUCE, 374);
   _actionMap[845][SELECT] = ActionEntry(SHIFT, 34);
   _actionMap[845][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[845][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[845][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[845][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[845][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[845][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[845][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[845][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[845][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[845][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[845][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[845][LONG2DATE] = ActionEntry(SHIFT, 144);
}
void Cego::loadParser35()
{
   _actionMap[845][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[845][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[845][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[845][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[845][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[845][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[845][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[845][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[845][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[845][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[845][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[845][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[845][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[845][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[845][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[845][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[845][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[845][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[845][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[845][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[845][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[845][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[845][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[845][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[845][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[845][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[845][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[845][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[845][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[845][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[845][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[845][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[845][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[845][LB] = ActionEntry(SHIFT, 176);
   _actionMap[845][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[845][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[845][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[845][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[845][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[845][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[845][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[845][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[845][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[845][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[845][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[845][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[845][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[845][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[845][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[845][MIN] = ActionEntry(SHIFT, 153);
}
void Cego::loadParser36()
{
   _actionMap[845][MAX] = ActionEntry(SHIFT, 154);
   _jumpMap[845][ObjSpec] = 121;
   _jumpMap[845][Constant] = 120;
   _jumpMap[845][SignedFloat] = 119;
   _jumpMap[845][SignedInt] = 118;
   _jumpMap[845][Attribute] = 117;
   _jumpMap[845][ExpressionList] = 895;
   _jumpMap[845][Function] = 116;
   _jumpMap[845][SelectStatement] = 894;
   _jumpMap[845][CasePrepare] = 115;
   _jumpMap[845][CaseClause] = 114;
   _jumpMap[845][Factor] = 113;
   _jumpMap[845][Term] = 112;
   _jumpMap[845][Expr] = 446;
   _actionMap[846][LEFT] = ActionEntry(REDUCE, 376);
   _actionMap[846][RIGHT] = ActionEntry(REDUCE, 376);
   _actionMap[846][INNER] = ActionEntry(REDUCE, 376);
   _actionMap[846][JOIN] = ActionEntry(REDUCE, 376);
   _actionMap[846][RETURNTOKEN] = ActionEntry(REDUCE, 376);
   _actionMap[846][SEMICOLON] = ActionEntry(REDUCE, 376);
   _actionMap[846][ENDTOKEN] = ActionEntry(REDUCE, 376);
   _actionMap[846][UNION] = ActionEntry(REDUCE, 376);
   _actionMap[846][ROWLIMIT] = ActionEntry(REDUCE, 376);
   _actionMap[846][ORDER] = ActionEntry(REDUCE, 376);
   _actionMap[846][GROUP] = ActionEntry(REDUCE, 376);
   _actionMap[846][WHERE] = ActionEntry(REDUCE, 376);
   _actionMap[846][THEN] = ActionEntry(REDUCE, 376);
   _actionMap[846][AND] = ActionEntry(REDUCE, 376);
   _actionMap[846][OR] = ActionEntry(REDUCE, 376);
   _actionMap[846][RB] = ActionEntry(REDUCE, 376);
   _actionMap[847][LEFT] = ActionEntry(REDUCE, 366);
   _actionMap[847][RIGHT] = ActionEntry(REDUCE, 366);
   _actionMap[847][INNER] = ActionEntry(REDUCE, 366);
   _actionMap[847][JOIN] = ActionEntry(REDUCE, 366);
   _actionMap[847][RETURNTOKEN] = ActionEntry(REDUCE, 366);
   _actionMap[847][SEMICOLON] = ActionEntry(REDUCE, 366);
   _actionMap[847][ENDTOKEN] = ActionEntry(REDUCE, 366);
   _actionMap[847][UNION] = ActionEntry(REDUCE, 366);
   _actionMap[847][ROWLIMIT] = ActionEntry(REDUCE, 366);
   _actionMap[847][ORDER] = ActionEntry(REDUCE, 366);
   _actionMap[847][GROUP] = ActionEntry(REDUCE, 366);
   _actionMap[847][WHERE] = ActionEntry(REDUCE, 366);
   _actionMap[847][THEN] = ActionEntry(REDUCE, 366);
   _actionMap[847][RB] = ActionEntry(REDUCE, 366);
   _actionMap[847][AND] = ActionEntry(REDUCE, 366);
   _actionMap[847][OR] = ActionEntry(REDUCE, 366);
   _actionMap[848][WHEN] = ActionEntry(REDUCE, 418);
   _actionMap[848][ELSE] = ActionEntry(REDUCE, 418);
   _actionMap[848][LEFT] = ActionEntry(REDUCE, 418);
   _actionMap[848][RIGHT] = ActionEntry(REDUCE, 418);
}
void Cego::loadParser37()
{
   _actionMap[848][INNER] = ActionEntry(REDUCE, 418);
   _actionMap[848][JOIN] = ActionEntry(REDUCE, 418);
   _actionMap[848][RETURNTOKEN] = ActionEntry(REDUCE, 418);
   _actionMap[848][ORDER] = ActionEntry(REDUCE, 418);
   _actionMap[848][GROUP] = ActionEntry(REDUCE, 418);
   _actionMap[848][WHERE] = ActionEntry(REDUCE, 418);
   _actionMap[848][NULLTOKEN] = ActionEntry(REDUCE, 418);
   _actionMap[848][FROM] = ActionEntry(REDUCE, 418);
   _actionMap[848][AS] = ActionEntry(REDUCE, 418);
   _actionMap[848][END_TOKEN] = ActionEntry(REDUCE, 418);
   _actionMap[848][BEGIN] = ActionEntry(REDUCE, 418);
   _actionMap[848][THEN] = ActionEntry(REDUCE, 418);
   _actionMap[848][OR] = ActionEntry(REDUCE, 418);
   _actionMap[848][AND] = ActionEntry(REDUCE, 418);
   _actionMap[848][INTOK] = ActionEntry(REDUCE, 418);
   _actionMap[848][NOT] = ActionEntry(REDUCE, 418);
   _actionMap[848][BETWEEN] = ActionEntry(REDUCE, 418);
   _actionMap[848][IS] = ActionEntry(REDUCE, 418);
   _actionMap[848][LIKE] = ActionEntry(REDUCE, 418);
   _actionMap[848][MT] = ActionEntry(REDUCE, 418);
   _actionMap[848][LT] = ActionEntry(REDUCE, 418);
   _actionMap[848][NEGATION] = ActionEntry(REDUCE, 418);
   _actionMap[848][EQU] = ActionEntry(REDUCE, 418);
   _actionMap[848][RB] = ActionEntry(REDUCE, 418);
   _actionMap[848][ENDTOKEN] = ActionEntry(REDUCE, 418);
   _actionMap[848][UNION] = ActionEntry(REDUCE, 418);
   _actionMap[848][ROWLIMIT] = ActionEntry(REDUCE, 418);
   _actionMap[848][KSEP] = ActionEntry(REDUCE, 418);
   _actionMap[848][ASC] = ActionEntry(REDUCE, 418);
   _actionMap[848][DESC] = ActionEntry(REDUCE, 418);
   _actionMap[848][SEMICOLON] = ActionEntry(REDUCE, 418);
   _actionMap[848][PLUS] = ActionEntry(REDUCE, 418);
   _actionMap[848][MINUS] = ActionEntry(REDUCE, 418);
   _actionMap[848][DIVISION] = ActionEntry(REDUCE, 418);
   _actionMap[848][STAR] = ActionEntry(REDUCE, 418);
   _actionMap[848][CONCAT] = ActionEntry(REDUCE, 418);
   _actionMap[849][VARREF] = ActionEntry(SHIFT, 896);
   _actionMap[850][WHEN] = ActionEntry(REDUCE, 179);
   _actionMap[850][ELSE] = ActionEntry(REDUCE, 179);
   _actionMap[850][LEFT] = ActionEntry(REDUCE, 179);
   _actionMap[850][RIGHT] = ActionEntry(REDUCE, 179);
   _actionMap[850][INNER] = ActionEntry(REDUCE, 179);
   _actionMap[850][JOIN] = ActionEntry(REDUCE, 179);
   _actionMap[850][RETURNTOKEN] = ActionEntry(REDUCE, 179);
   _actionMap[850][ORDER] = ActionEntry(REDUCE, 179);
   _actionMap[850][GROUP] = ActionEntry(REDUCE, 179);
   _actionMap[850][WHERE] = ActionEntry(REDUCE, 179);
   _actionMap[850][AS] = ActionEntry(REDUCE, 179);
   _actionMap[850][FROM] = ActionEntry(REDUCE, 179);
   _actionMap[850][END_TOKEN] = ActionEntry(REDUCE, 179);
}
void Cego::loadParser38()
{
   _actionMap[850][BEGIN] = ActionEntry(REDUCE, 179);
   _actionMap[850][THEN] = ActionEntry(REDUCE, 179);
   _actionMap[850][OR] = ActionEntry(REDUCE, 179);
   _actionMap[850][AND] = ActionEntry(REDUCE, 179);
   _actionMap[850][LIKE] = ActionEntry(REDUCE, 179);
   _actionMap[850][IS] = ActionEntry(REDUCE, 179);
   _actionMap[850][BETWEEN] = ActionEntry(REDUCE, 179);
   _actionMap[850][NOT] = ActionEntry(REDUCE, 179);
   _actionMap[850][INTOK] = ActionEntry(REDUCE, 179);
   _actionMap[850][EQU] = ActionEntry(REDUCE, 179);
   _actionMap[850][NEGATION] = ActionEntry(REDUCE, 179);
   _actionMap[850][LT] = ActionEntry(REDUCE, 179);
   _actionMap[850][MT] = ActionEntry(REDUCE, 179);
   _actionMap[850][DESC] = ActionEntry(REDUCE, 179);
   _actionMap[850][ASC] = ActionEntry(REDUCE, 179);
   _actionMap[850][KSEP] = ActionEntry(REDUCE, 179);
   _actionMap[850][ROWLIMIT] = ActionEntry(REDUCE, 179);
   _actionMap[850][UNION] = ActionEntry(REDUCE, 179);
   _actionMap[850][ENDTOKEN] = ActionEntry(REDUCE, 179);
   _actionMap[850][RB] = ActionEntry(REDUCE, 179);
   _actionMap[850][SEMICOLON] = ActionEntry(REDUCE, 179);
   _actionMap[850][CONCAT] = ActionEntry(REDUCE, 179);
   _actionMap[850][STAR] = ActionEntry(REDUCE, 179);
   _actionMap[850][DIVISION] = ActionEntry(REDUCE, 179);
   _actionMap[850][MINUS] = ActionEntry(REDUCE, 179);
   _actionMap[850][PLUS] = ActionEntry(REDUCE, 179);
   _actionMap[851][WHEN] = ActionEntry(REDUCE, 355);
   _actionMap[851][ELSE] = ActionEntry(REDUCE, 355);
   _actionMap[851][LEFT] = ActionEntry(REDUCE, 355);
   _actionMap[851][RIGHT] = ActionEntry(REDUCE, 355);
   _actionMap[851][INNER] = ActionEntry(REDUCE, 355);
   _actionMap[851][JOIN] = ActionEntry(REDUCE, 355);
   _actionMap[851][RETURNTOKEN] = ActionEntry(REDUCE, 355);
   _actionMap[851][ORDER] = ActionEntry(REDUCE, 355);
   _actionMap[851][GROUP] = ActionEntry(REDUCE, 355);
   _actionMap[851][WHERE] = ActionEntry(REDUCE, 355);
   _actionMap[851][FROM] = ActionEntry(REDUCE, 355);
   _actionMap[851][AS] = ActionEntry(REDUCE, 355);
   _actionMap[851][END_TOKEN] = ActionEntry(REDUCE, 355);
   _actionMap[851][BEGIN] = ActionEntry(REDUCE, 355);
   _actionMap[851][THEN] = ActionEntry(REDUCE, 355);
   _actionMap[851][OR] = ActionEntry(REDUCE, 355);
   _actionMap[851][AND] = ActionEntry(REDUCE, 355);
   _actionMap[851][INTOK] = ActionEntry(REDUCE, 355);
   _actionMap[851][NOT] = ActionEntry(REDUCE, 355);
   _actionMap[851][BETWEEN] = ActionEntry(REDUCE, 355);
   _actionMap[851][IS] = ActionEntry(REDUCE, 355);
   _actionMap[851][LIKE] = ActionEntry(REDUCE, 355);
   _actionMap[851][MT] = ActionEntry(REDUCE, 355);
   _actionMap[851][LT] = ActionEntry(REDUCE, 355);
}
void Cego::loadParser39()
{
   _actionMap[851][NEGATION] = ActionEntry(REDUCE, 355);
   _actionMap[851][EQU] = ActionEntry(REDUCE, 355);
   _actionMap[851][RB] = ActionEntry(REDUCE, 355);
   _actionMap[851][ENDTOKEN] = ActionEntry(REDUCE, 355);
   _actionMap[851][UNION] = ActionEntry(REDUCE, 355);
   _actionMap[851][ROWLIMIT] = ActionEntry(REDUCE, 355);
   _actionMap[851][KSEP] = ActionEntry(REDUCE, 355);
   _actionMap[851][ASC] = ActionEntry(REDUCE, 355);
   _actionMap[851][DESC] = ActionEntry(REDUCE, 355);
   _actionMap[851][SEMICOLON] = ActionEntry(REDUCE, 355);
   _actionMap[851][PLUS] = ActionEntry(REDUCE, 355);
   _actionMap[851][MINUS] = ActionEntry(REDUCE, 355);
   _actionMap[851][DIVISION] = ActionEntry(REDUCE, 355);
   _actionMap[851][STAR] = ActionEntry(REDUCE, 355);
   _actionMap[851][CONCAT] = ActionEntry(REDUCE, 355);
   _actionMap[852][SEMICOLON] = ActionEntry(REDUCE, 287);
   _actionMap[852][RB] = ActionEntry(REDUCE, 287);
   _actionMap[852][ENDTOKEN] = ActionEntry(REDUCE, 287);
   _actionMap[852][UNION] = ActionEntry(REDUCE, 287);
   _actionMap[852][ROWLIMIT] = ActionEntry(SHIFT, 899);
   _jumpMap[852][NoLimit] = 898;
   _jumpMap[852][LimitOpt] = 897;
   _actionMap[853][ROWLIMIT] = ActionEntry(REDUCE, 274);
   _actionMap[853][UNION] = ActionEntry(REDUCE, 274);
   _actionMap[853][ENDTOKEN] = ActionEntry(REDUCE, 274);
   _actionMap[853][RB] = ActionEntry(REDUCE, 274);
   _actionMap[853][SEMICOLON] = ActionEntry(REDUCE, 274);
   _actionMap[854][BY] = ActionEntry(SHIFT, 900);
   _actionMap[855][IDENTIFIER] = ActionEntry(SHIFT, 903);
   _actionMap[855][QUALIFIEDOBJ] = ActionEntry(SHIFT, 904);
   _actionMap[855][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _jumpMap[855][Attribute] = 902;
   _jumpMap[855][GroupList] = 901;
   _actionMap[856][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[856][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[856][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[856][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[856][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[856][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[856][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[856][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[856][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[856][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[856][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[856][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[856][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[856][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[856][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[856][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[856][RIGHT] = ActionEntry(SHIFT, 162);
}
void Cego::loadParser40()
{
   _actionMap[856][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[856][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[856][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[856][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[856][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[856][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[856][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[856][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[856][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[856][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[856][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[856][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[856][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[856][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[856][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[856][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[856][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[856][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[856][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[856][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[856][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[856][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[856][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[856][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[856][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[856][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[856][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[856][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[856][LB] = ActionEntry(SHIFT, 445);
   _actionMap[856][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[856][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[856][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[856][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[856][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[856][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[856][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[856][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[856][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[856][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[856][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[856][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[856][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[856][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[856][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[856][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[856][MAX] = ActionEntry(SHIFT, 154);
   _actionMap[856][EXISTS] = ActionEntry(SHIFT, 443);
   _actionMap[856][NOT] = ActionEntry(SHIFT, 444);
   _jumpMap[856][ObjSpec] = 121;
   _jumpMap[856][Constant] = 120;
}
void Cego::loadParser41()
{
   _jumpMap[856][SignedFloat] = 119;
   _jumpMap[856][SignedInt] = 118;
   _jumpMap[856][Attribute] = 117;
   _jumpMap[856][QueryPredicate] = 442;
   _jumpMap[856][QueryCondition] = 905;
   _jumpMap[856][Function] = 116;
   _jumpMap[856][CasePrepare] = 115;
   _jumpMap[856][CaseClause] = 114;
   _jumpMap[856][Factor] = 113;
   _jumpMap[856][Term] = 112;
   _jumpMap[856][Expr] = 440;
   _actionMap[857][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[857][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[857][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[857][ObjSpec] = 520;
   _jumpMap[857][JoinTable] = 906;
   _jumpMap[857][Table] = 783;
   _actionMap[858][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[858][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[858][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[858][ObjSpec] = 520;
   _jumpMap[858][JoinTable] = 907;
   _jumpMap[858][Table] = 783;
   _actionMap[859][KSEP] = ActionEntry(SHIFT, 908);
   _actionMap[859][SEMICOLON] = ActionEntry(REDUCE, 293);
   _actionMap[860][SEMICOLON] = ActionEntry(REDUCE, 296);
   _actionMap[860][KSEP] = ActionEntry(REDUCE, 296);
   _actionMap[861][FIRST] = ActionEntry(SHIFT, 909);
   _actionMap[862][EQU] = ActionEntry(SHIFT, 910);
   _actionMap[691][SEMICOLON] = ActionEntry(REDUCE, 302);
   _actionMap[692][COLUMN] = ActionEntry(SHIFT, 533);
   _actionMap[693][ON] = ActionEntry(SHIFT, 796);
   _actionMap[694][SEMICOLON] = ActionEntry(REDUCE, 305);
   _actionMap[694][KSEP] = ActionEntry(REDUCE, 305);
   _actionMap[695][IDENTIFIER] = ActionEntry(SHIFT, 797);
   _actionMap[696][SEMICOLON] = ActionEntry(REDUCE, 304);
   _actionMap[696][KSEP] = ActionEntry(REDUCE, 304);
   _actionMap[697][SEMICOLON] = ActionEntry(REDUCE, 306);
   _actionMap[697][KSEP] = ActionEntry(REDUCE, 306);
   _actionMap[698][DEFAULT] = ActionEntry(SHIFT, 798);
   _actionMap[698][INT] = ActionEntry(SHIFT, 731);
   _actionMap[698][LONG] = ActionEntry(SHIFT, 732);
   _actionMap[698][STRING] = ActionEntry(SHIFT, 734);
   _actionMap[698][DATETIME] = ActionEntry(SHIFT, 726);
   _actionMap[698][BOOL] = ActionEntry(SHIFT, 724);
   _actionMap[698][BIGINT] = ActionEntry(SHIFT, 722);
   _actionMap[698][FLOAT] = ActionEntry(SHIFT, 730);
   _actionMap[698][DOUBLE] = ActionEntry(SHIFT, 728);
   _actionMap[698][SMALLINT] = ActionEntry(SHIFT, 733);
   _actionMap[698][TINYINT] = ActionEntry(SHIFT, 735);
}
void Cego::loadParser42()
{
   _actionMap[698][DECIMAL] = ActionEntry(SHIFT, 727);
   _actionMap[698][FIXED] = ActionEntry(SHIFT, 729);
   _actionMap[698][BLOB] = ActionEntry(SHIFT, 723);
   _actionMap[698][CLOB] = ActionEntry(SHIFT, 725);
   _jumpMap[698][DataTypeProd] = 749;
   _actionMap[699][TO] = ActionEntry(SHIFT, 799);
   _actionMap[700][IDENTIFIER] = ActionEntry(SHIFT, 800);
   _actionMap[701][PLUS] = ActionEntry(SHIFT, 275);
   _actionMap[701][MINUS] = ActionEntry(SHIFT, 274);
   _actionMap[701][CONCAT] = ActionEntry(SHIFT, 273);
   _actionMap[701][KSEP] = ActionEntry(REDUCE, 148);
   _actionMap[701][RB] = ActionEntry(REDUCE, 148);
   _actionMap[702][ELSE] = ActionEntry(REDUCE, 143);
   _actionMap[702][ELSIF] = ActionEntry(REDUCE, 143);
   _actionMap[702][EXCEPTION] = ActionEntry(REDUCE, 143);
   _actionMap[702][END_TOKEN] = ActionEntry(REDUCE, 143);
   _actionMap[703][WHEN] = ActionEntry(SHIFT, 801);
   _actionMap[704][EXCEPTION] = ActionEntry(REDUCE, 119);
   _actionMap[704][END_TOKEN] = ActionEntry(REDUCE, 119);
   _actionMap[704][ELSE] = ActionEntry(REDUCE, 119);
   _actionMap[704][ELSIF] = ActionEntry(REDUCE, 119);
   _actionMap[704][VAR] = ActionEntry(REDUCE, 119);
   _actionMap[704][CURSOR] = ActionEntry(REDUCE, 119);
   _actionMap[704][CLOSE] = ActionEntry(REDUCE, 119);
   _actionMap[704][VARREF] = ActionEntry(REDUCE, 119);
   _actionMap[704][NOOP] = ActionEntry(REDUCE, 119);
   _actionMap[704][THROW] = ActionEntry(REDUCE, 119);
   _actionMap[704][RETURNTOKEN] = ActionEntry(REDUCE, 119);
   _actionMap[704][WHILE] = ActionEntry(REDUCE, 119);
   _actionMap[704][IF] = ActionEntry(REDUCE, 119);
   _actionMap[704][BEGIN] = ActionEntry(REDUCE, 119);
   _actionMap[704][UNLOCK] = ActionEntry(REDUCE, 119);
   _actionMap[704][LOCK] = ActionEntry(REDUCE, 119);
   _actionMap[704][ROLLBACK] = ActionEntry(REDUCE, 119);
   _actionMap[704][COMMIT] = ActionEntry(REDUCE, 119);
   _actionMap[704][START_TOKEN] = ActionEntry(REDUCE, 119);
   _actionMap[704][UPDATE] = ActionEntry(REDUCE, 119);
   _actionMap[704][DELETETOK] = ActionEntry(REDUCE, 119);
   _actionMap[704][INSERT] = ActionEntry(REDUCE, 119);
   _actionMap[704][FETCH] = ActionEntry(REDUCE, 119);
   _actionMap[704][LB] = ActionEntry(REDUCE, 119);
   _actionMap[704][COUNT] = ActionEntry(REDUCE, 119);
   _actionMap[704][SUM] = ActionEntry(REDUCE, 119);
   _actionMap[704][AVG] = ActionEntry(REDUCE, 119);
   _actionMap[704][MIN] = ActionEntry(REDUCE, 119);
   _actionMap[704][MAX] = ActionEntry(REDUCE, 119);
   _actionMap[704][CASE] = ActionEntry(REDUCE, 119);
   _actionMap[704][INT2ASC] = ActionEntry(REDUCE, 119);
   _actionMap[704][ASC2INT] = ActionEntry(REDUCE, 119);
   _actionMap[704][TRIM] = ActionEntry(REDUCE, 119);
}
void Cego::loadParser43()
{
   _actionMap[704][RTRIM] = ActionEntry(REDUCE, 119);
   _actionMap[704][LTRIM] = ActionEntry(REDUCE, 119);
   _actionMap[704][ROUND] = ActionEntry(REDUCE, 119);
   _actionMap[704][DATE2STR] = ActionEntry(REDUCE, 119);
   _actionMap[704][DATE2LONG] = ActionEntry(REDUCE, 119);
   _actionMap[704][LONG2DATE] = ActionEntry(REDUCE, 119);
   _actionMap[704][NEWDATE] = ActionEntry(REDUCE, 119);
   _actionMap[704][LOWER] = ActionEntry(REDUCE, 119);
   _actionMap[704][UPPER] = ActionEntry(REDUCE, 119);
   _actionMap[704][LEFT] = ActionEntry(REDUCE, 119);
   _actionMap[704][RIGHT] = ActionEntry(REDUCE, 119);
   _actionMap[704][GETPOS] = ActionEntry(REDUCE, 119);
   _actionMap[704][SUBSTR] = ActionEntry(REDUCE, 119);
   _actionMap[704][REPLACE] = ActionEntry(REDUCE, 119);
   _actionMap[704][LENGTH] = ActionEntry(REDUCE, 119);
   _actionMap[704][TRUNC] = ActionEntry(REDUCE, 119);
   _actionMap[704][STR2INT] = ActionEntry(REDUCE, 119);
   _actionMap[704][STR2LONG] = ActionEntry(REDUCE, 119);
   _actionMap[704][STR2DATE] = ActionEntry(REDUCE, 119);
   _actionMap[704][RANDSTR] = ActionEntry(REDUCE, 119);
   _actionMap[704][RANDINT] = ActionEntry(REDUCE, 119);
   _actionMap[704][MOD] = ActionEntry(REDUCE, 119);
   _actionMap[704][DIV] = ActionEntry(REDUCE, 119);
   _actionMap[704][LMOD] = ActionEntry(REDUCE, 119);
   _actionMap[704][LDIV] = ActionEntry(REDUCE, 119);
   _actionMap[704][POWER] = ActionEntry(REDUCE, 119);
   _actionMap[704][BITAND] = ActionEntry(REDUCE, 119);
   _actionMap[704][BITOR] = ActionEntry(REDUCE, 119);
   _actionMap[704][BITXOR] = ActionEntry(REDUCE, 119);
   _actionMap[704][BLOBSIZE] = ActionEntry(REDUCE, 119);
   _actionMap[704][BLOBREF] = ActionEntry(REDUCE, 119);
   _actionMap[704][CLOBSIZE] = ActionEntry(REDUCE, 119);
   _actionMap[704][CLOBREF] = ActionEntry(REDUCE, 119);
   _actionMap[704][CLOB2STR] = ActionEntry(REDUCE, 119);
   _actionMap[704][NEXTCOUNT] = ActionEntry(REDUCE, 119);
   _actionMap[704][SETCOUNT] = ActionEntry(REDUCE, 119);
   _actionMap[704][IDENTIFIER] = ActionEntry(REDUCE, 119);
   _actionMap[704][QUALIFIEDOBJ] = ActionEntry(REDUCE, 119);
   _actionMap[704][QUALIFIEDTS] = ActionEntry(REDUCE, 119);
   _actionMap[704][QUALIFIEDPRE] = ActionEntry(REDUCE, 119);
   _actionMap[704][STRINGVAL] = ActionEntry(REDUCE, 119);
   _actionMap[704][DATE] = ActionEntry(REDUCE, 119);
   _actionMap[704][SYSDATE] = ActionEntry(REDUCE, 119);
   _actionMap[704][NULLTOKEN] = ActionEntry(REDUCE, 119);
   _actionMap[704][TRUEVAL] = ActionEntry(REDUCE, 119);
   _actionMap[704][FALSEVAL] = ActionEntry(REDUCE, 119);
   _actionMap[704][BLOB] = ActionEntry(REDUCE, 119);
   _actionMap[704][CLOB] = ActionEntry(REDUCE, 119);
   _actionMap[704][FLOATVAL] = ActionEntry(REDUCE, 119);
   _actionMap[704][MINUS] = ActionEntry(REDUCE, 119);
}
void Cego::loadParser44()
{
   _actionMap[704][INTVAL] = ActionEntry(REDUCE, 119);
   _actionMap[705][SEMICOLON] = ActionEntry(REDUCE, 141);
   _actionMap[706][END_TOKEN] = ActionEntry(SHIFT, 709);
   _actionMap[707][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[707][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[707][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[707][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[707][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[707][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[707][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[707][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[707][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[707][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[707][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[707][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[707][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[707][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[707][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[707][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[707][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[707][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[707][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[707][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[707][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[707][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[707][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[707][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[707][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[707][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[707][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[707][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[707][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[707][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[707][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[707][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[707][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[707][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[707][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[707][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[707][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[707][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[707][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[707][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[707][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[707][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[707][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[707][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[707][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[707][LB] = ActionEntry(SHIFT, 176);
   _actionMap[707][STRINGVAL] = ActionEntry(SHIFT, 122);
}
void Cego::loadParser45()
{
   _actionMap[707][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[707][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[707][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[707][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[707][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[707][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[707][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[707][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[707][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[707][VARREF] = ActionEntry(SHIFT, 410);
   _actionMap[707][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[707][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[707][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[707][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[707][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[707][MAX] = ActionEntry(SHIFT, 154);
   _actionMap[707][IF] = ActionEntry(SHIFT, 404);
   _actionMap[707][BEGIN] = ActionEntry(SHIFT, 401);
   _actionMap[707][UNLOCK] = ActionEntry(SHIFT, 28);
   _actionMap[707][LOCK] = ActionEntry(SHIFT, 27);
   _actionMap[707][ROLLBACK] = ActionEntry(SHIFT, 33);
   _actionMap[707][COMMIT] = ActionEntry(SHIFT, 18);
   _actionMap[707][START_TOKEN] = ActionEntry(SHIFT, 37);
   _actionMap[707][UPDATE] = ActionEntry(SHIFT, 43);
   _actionMap[707][DELETETOK] = ActionEntry(SHIFT, 20);
   _actionMap[707][INSERT] = ActionEntry(SHIFT, 23);
   _actionMap[707][VAR] = ActionEntry(SHIFT, 408);
   _actionMap[707][CURSOR] = ActionEntry(SHIFT, 403);
   _actionMap[707][CLOSE] = ActionEntry(SHIFT, 402);
   _actionMap[707][NOOP] = ActionEntry(SHIFT, 405);
   _actionMap[707][THROW] = ActionEntry(SHIFT, 407);
   _actionMap[707][RETURNTOKEN] = ActionEntry(SHIFT, 406);
   _actionMap[707][WHILE] = ActionEntry(SHIFT, 409);
   _jumpMap[707][ObjSpec] = 121;
   _jumpMap[707][Constant] = 120;
   _jumpMap[707][SignedFloat] = 119;
   _jumpMap[707][SignedInt] = 118;
   _jumpMap[707][Attribute] = 117;
   _jumpMap[707][Function] = 116;
   _jumpMap[707][DeleteStatement] = 400;
   _jumpMap[707][UpdateStatement] = 399;
   _jumpMap[707][InsertStatement] = 398;
   _jumpMap[707][UnlockStatement] = 397;
   _jumpMap[707][LockStatement] = 396;
   _jumpMap[707][RollbackStatement] = 395;
   _jumpMap[707][CommitStatement] = 394;
   _jumpMap[707][StartStatement] = 393;
   _jumpMap[707][CasePrepare] = 115;
   _jumpMap[707][CaseClause] = 114;
   _jumpMap[707][Factor] = 113;
}
void Cego::loadParser46()
{
   _jumpMap[707][Term] = 112;
   _jumpMap[707][Expr] = 392;
   _jumpMap[707][ProcStatement] = 391;
   _jumpMap[707][ProcIfPart] = 390;
   _jumpMap[707][ProcBlockStart] = 389;
   _jumpMap[707][ProcStatementList] = 388;
   _jumpMap[707][ProcStmtBlock] = 802;
   _actionMap[708][VAR] = ActionEntry(REDUCE, 158);
   _actionMap[708][CURSOR] = ActionEntry(REDUCE, 158);
   _actionMap[708][CLOSE] = ActionEntry(REDUCE, 158);
   _actionMap[708][VARREF] = ActionEntry(REDUCE, 158);
   _actionMap[708][NOOP] = ActionEntry(REDUCE, 158);
   _actionMap[708][THROW] = ActionEntry(REDUCE, 158);
   _actionMap[708][RETURNTOKEN] = ActionEntry(REDUCE, 158);
   _actionMap[708][WHILE] = ActionEntry(REDUCE, 158);
   _actionMap[708][IF] = ActionEntry(REDUCE, 158);
   _actionMap[708][BEGIN] = ActionEntry(REDUCE, 158);
   _actionMap[708][UNLOCK] = ActionEntry(REDUCE, 158);
   _actionMap[708][LOCK] = ActionEntry(REDUCE, 158);
   _actionMap[708][ROLLBACK] = ActionEntry(REDUCE, 158);
   _actionMap[708][COMMIT] = ActionEntry(REDUCE, 158);
   _actionMap[708][START_TOKEN] = ActionEntry(REDUCE, 158);
   _actionMap[708][UPDATE] = ActionEntry(REDUCE, 158);
   _actionMap[708][DELETETOK] = ActionEntry(REDUCE, 158);
   _actionMap[708][INSERT] = ActionEntry(REDUCE, 158);
   _actionMap[708][FETCH] = ActionEntry(REDUCE, 158);
   _actionMap[708][LB] = ActionEntry(REDUCE, 158);
   _actionMap[708][COUNT] = ActionEntry(REDUCE, 158);
   _actionMap[708][SUM] = ActionEntry(REDUCE, 158);
   _actionMap[708][AVG] = ActionEntry(REDUCE, 158);
   _actionMap[708][MIN] = ActionEntry(REDUCE, 158);
   _actionMap[708][MAX] = ActionEntry(REDUCE, 158);
   _actionMap[708][CASE] = ActionEntry(REDUCE, 158);
   _actionMap[708][INT2ASC] = ActionEntry(REDUCE, 158);
   _actionMap[708][ASC2INT] = ActionEntry(REDUCE, 158);
   _actionMap[708][TRIM] = ActionEntry(REDUCE, 158);
   _actionMap[708][RTRIM] = ActionEntry(REDUCE, 158);
   _actionMap[708][LTRIM] = ActionEntry(REDUCE, 158);
   _actionMap[708][ROUND] = ActionEntry(REDUCE, 158);
   _actionMap[708][DATE2STR] = ActionEntry(REDUCE, 158);
   _actionMap[708][DATE2LONG] = ActionEntry(REDUCE, 158);
   _actionMap[708][LONG2DATE] = ActionEntry(REDUCE, 158);
   _actionMap[708][NEWDATE] = ActionEntry(REDUCE, 158);
   _actionMap[708][LOWER] = ActionEntry(REDUCE, 158);
   _actionMap[708][UPPER] = ActionEntry(REDUCE, 158);
   _actionMap[708][LEFT] = ActionEntry(REDUCE, 158);
   _actionMap[708][RIGHT] = ActionEntry(REDUCE, 158);
   _actionMap[708][GETPOS] = ActionEntry(REDUCE, 158);
   _actionMap[708][SUBSTR] = ActionEntry(REDUCE, 158);
   _actionMap[708][REPLACE] = ActionEntry(REDUCE, 158);
}
void Cego::loadParser47()
{
   _actionMap[708][LENGTH] = ActionEntry(REDUCE, 158);
   _actionMap[708][TRUNC] = ActionEntry(REDUCE, 158);
   _actionMap[708][STR2INT] = ActionEntry(REDUCE, 158);
   _actionMap[708][STR2LONG] = ActionEntry(REDUCE, 158);
   _actionMap[708][STR2DATE] = ActionEntry(REDUCE, 158);
   _actionMap[708][RANDSTR] = ActionEntry(REDUCE, 158);
   _actionMap[708][RANDINT] = ActionEntry(REDUCE, 158);
   _actionMap[708][MOD] = ActionEntry(REDUCE, 158);
   _actionMap[708][DIV] = ActionEntry(REDUCE, 158);
   _actionMap[708][LMOD] = ActionEntry(REDUCE, 158);
   _actionMap[708][LDIV] = ActionEntry(REDUCE, 158);
   _actionMap[708][POWER] = ActionEntry(REDUCE, 158);
   _actionMap[708][BITAND] = ActionEntry(REDUCE, 158);
   _actionMap[708][BITOR] = ActionEntry(REDUCE, 158);
   _actionMap[708][BITXOR] = ActionEntry(REDUCE, 158);
   _actionMap[708][BLOBSIZE] = ActionEntry(REDUCE, 158);
   _actionMap[708][BLOBREF] = ActionEntry(REDUCE, 158);
   _actionMap[708][CLOBSIZE] = ActionEntry(REDUCE, 158);
   _actionMap[708][CLOBREF] = ActionEntry(REDUCE, 158);
   _actionMap[708][CLOB2STR] = ActionEntry(REDUCE, 158);
   _actionMap[708][NEXTCOUNT] = ActionEntry(REDUCE, 158);
   _actionMap[708][SETCOUNT] = ActionEntry(REDUCE, 158);
   _actionMap[708][IDENTIFIER] = ActionEntry(REDUCE, 158);
   _actionMap[708][QUALIFIEDOBJ] = ActionEntry(REDUCE, 158);
   _actionMap[708][QUALIFIEDTS] = ActionEntry(REDUCE, 158);
   _actionMap[708][QUALIFIEDPRE] = ActionEntry(REDUCE, 158);
   _actionMap[708][STRINGVAL] = ActionEntry(REDUCE, 158);
   _actionMap[708][DATE] = ActionEntry(REDUCE, 158);
   _actionMap[708][SYSDATE] = ActionEntry(REDUCE, 158);
   _actionMap[708][NULLTOKEN] = ActionEntry(REDUCE, 158);
   _actionMap[708][TRUEVAL] = ActionEntry(REDUCE, 158);
   _actionMap[708][FALSEVAL] = ActionEntry(REDUCE, 158);
   _actionMap[708][BLOB] = ActionEntry(REDUCE, 158);
   _actionMap[708][CLOB] = ActionEntry(REDUCE, 158);
   _actionMap[708][FLOATVAL] = ActionEntry(REDUCE, 158);
   _actionMap[708][MINUS] = ActionEntry(REDUCE, 158);
   _actionMap[708][INTVAL] = ActionEntry(REDUCE, 158);
   _actionMap[709][SEMICOLON] = ActionEntry(REDUCE, 151);
   _actionMap[710][END_TOKEN] = ActionEntry(REDUCE, 153);
   _actionMap[710][ELSE] = ActionEntry(REDUCE, 153);
   _actionMap[711][THEN] = ActionEntry(SHIFT, 803);
   _actionMap[712][OR] = ActionEntry(SHIFT, 716);
   _actionMap[712][AND] = ActionEntry(SHIFT, 715);
   _actionMap[712][THEN] = ActionEntry(REDUCE, 160);
   _actionMap[713][SELECT] = ActionEntry(SHIFT, 34);
   _jumpMap[713][SelectStatement] = 804;
   _actionMap[714][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[714][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[714][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[714][INT2ASC] = ActionEntry(SHIFT, 146);
}
void Cego::loadParser48()
{
   _actionMap[714][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[714][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[714][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[714][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[714][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[714][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[714][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[714][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[714][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[714][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[714][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[714][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[714][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[714][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[714][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[714][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[714][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[714][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[714][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[714][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[714][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[714][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[714][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[714][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[714][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[714][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[714][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[714][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[714][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[714][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[714][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[714][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[714][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[714][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[714][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[714][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[714][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[714][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[714][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[714][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[714][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[714][LB] = ActionEntry(SHIFT, 176);
   _actionMap[714][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[714][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[714][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[714][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[714][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[714][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[714][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[714][CLOB] = ActionEntry(SHIFT, 132);
}
void Cego::loadParser49()
{
   _actionMap[714][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[714][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[714][VARREF] = ActionEntry(SHIFT, 410);
   _actionMap[714][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[714][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[714][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[714][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[714][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[714][MAX] = ActionEntry(SHIFT, 154);
   _actionMap[714][IF] = ActionEntry(SHIFT, 404);
   _actionMap[714][BEGIN] = ActionEntry(SHIFT, 401);
   _actionMap[714][UNLOCK] = ActionEntry(SHIFT, 28);
   _actionMap[714][LOCK] = ActionEntry(SHIFT, 27);
   _actionMap[714][ROLLBACK] = ActionEntry(SHIFT, 33);
   _actionMap[714][COMMIT] = ActionEntry(SHIFT, 18);
   _actionMap[714][START_TOKEN] = ActionEntry(SHIFT, 37);
   _actionMap[714][UPDATE] = ActionEntry(SHIFT, 43);
   _actionMap[714][DELETETOK] = ActionEntry(SHIFT, 20);
   _actionMap[714][INSERT] = ActionEntry(SHIFT, 23);
   _actionMap[714][VAR] = ActionEntry(SHIFT, 408);
   _actionMap[714][CURSOR] = ActionEntry(SHIFT, 403);
   _actionMap[714][CLOSE] = ActionEntry(SHIFT, 402);
   _actionMap[714][NOOP] = ActionEntry(SHIFT, 405);
   _actionMap[714][THROW] = ActionEntry(SHIFT, 407);
   _actionMap[714][RETURNTOKEN] = ActionEntry(SHIFT, 406);
   _actionMap[714][WHILE] = ActionEntry(SHIFT, 409);
   _jumpMap[714][ObjSpec] = 121;
   _jumpMap[714][Constant] = 120;
   _jumpMap[714][SignedFloat] = 119;
   _jumpMap[714][SignedInt] = 118;
   _jumpMap[714][Attribute] = 117;
   _jumpMap[714][Function] = 116;
   _jumpMap[714][DeleteStatement] = 400;
   _jumpMap[714][UpdateStatement] = 399;
   _jumpMap[714][InsertStatement] = 398;
   _jumpMap[714][UnlockStatement] = 397;
   _jumpMap[714][LockStatement] = 396;
   _jumpMap[714][RollbackStatement] = 395;
   _jumpMap[714][CommitStatement] = 394;
   _jumpMap[714][StartStatement] = 393;
   _jumpMap[714][CasePrepare] = 115;
   _jumpMap[714][CaseClause] = 114;
   _jumpMap[714][Factor] = 113;
   _jumpMap[714][Term] = 112;
   _jumpMap[714][Expr] = 392;
   _jumpMap[714][ProcStatement] = 391;
   _jumpMap[714][ProcIfPart] = 390;
   _jumpMap[714][ProcBlockStart] = 389;
   _jumpMap[714][ProcStatementList] = 388;
   _jumpMap[714][ProcStmtBlock] = 805;
}
void Cego::loadParser50()
{
   _actionMap[715][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[715][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[715][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[715][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[715][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[715][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[715][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[715][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[715][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[715][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[715][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[715][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[715][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[715][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[715][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[715][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[715][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[715][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[715][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[715][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[715][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[715][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[715][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[715][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[715][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[715][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[715][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[715][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[715][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[715][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[715][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[715][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[715][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[715][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[715][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[715][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[715][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[715][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[715][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[715][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[715][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[715][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[715][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[715][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[715][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[715][LB] = ActionEntry(SHIFT, 554);
   _actionMap[715][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[715][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[715][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[715][NULLTOKEN] = ActionEntry(SHIFT, 157);
}
void Cego::loadParser51()
{
   _actionMap[715][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[715][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[715][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[715][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[715][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[715][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[715][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[715][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[715][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[715][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[715][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[715][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[715][MAX] = ActionEntry(SHIFT, 154);
   _jumpMap[715][ObjSpec] = 121;
   _jumpMap[715][Constant] = 120;
   _jumpMap[715][SignedFloat] = 119;
   _jumpMap[715][SignedInt] = 118;
   _jumpMap[715][Attribute] = 117;
   _jumpMap[715][Function] = 116;
   _jumpMap[715][CasePrepare] = 115;
   _jumpMap[715][CaseClause] = 114;
   _jumpMap[715][Factor] = 113;
   _jumpMap[715][Term] = 112;
   _jumpMap[715][Expr] = 553;
   _jumpMap[715][ProcPredicate] = 806;
   _actionMap[716][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[716][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[716][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[716][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[716][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[716][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[716][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[716][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[716][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[716][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[716][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[716][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[716][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[716][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[716][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[716][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[716][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[716][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[716][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[716][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[716][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[716][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[716][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[716][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[716][STR2DATE] = ActionEntry(SHIFT, 171);
}
void Cego::loadParser52()
{
   _actionMap[716][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[716][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[716][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[716][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[716][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[716][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[716][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[716][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[716][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[716][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[716][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[716][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[716][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[716][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[716][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[716][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[716][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[716][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[716][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[716][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[716][LB] = ActionEntry(SHIFT, 554);
   _actionMap[716][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[716][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[716][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[716][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[716][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[716][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[716][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[716][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[716][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[716][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[716][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[716][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[716][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[716][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[716][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[716][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[716][MAX] = ActionEntry(SHIFT, 154);
   _jumpMap[716][ObjSpec] = 121;
   _jumpMap[716][Constant] = 120;
   _jumpMap[716][SignedFloat] = 119;
   _jumpMap[716][SignedInt] = 118;
   _jumpMap[716][Attribute] = 117;
   _jumpMap[716][Function] = 116;
   _jumpMap[716][CasePrepare] = 115;
   _jumpMap[716][CaseClause] = 114;
   _jumpMap[716][Factor] = 113;
   _jumpMap[716][Term] = 112;
   _jumpMap[716][Expr] = 553;
   _jumpMap[716][ProcPredicate] = 807;
}
void Cego::loadParser53()
{
   _actionMap[717][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[717][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[717][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[717][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[717][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[717][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[717][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[717][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[717][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[717][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[717][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[717][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[717][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[717][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[717][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[717][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[717][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[717][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[717][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[717][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[717][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[717][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[717][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[717][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[717][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[717][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[717][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[717][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[717][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[717][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[717][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[717][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[717][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[717][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[717][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[717][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[717][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[717][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[717][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[717][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[717][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[717][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[717][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[717][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[717][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[717][LB] = ActionEntry(SHIFT, 176);
   _actionMap[717][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[717][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[717][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[717][NULLTOKEN] = ActionEntry(SHIFT, 157);
}
void Cego::loadParser54()
{
   _actionMap[717][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[717][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[717][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[717][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[717][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[717][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[717][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[717][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[717][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[717][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[717][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[717][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[717][MAX] = ActionEntry(SHIFT, 154);
   _jumpMap[717][ObjSpec] = 121;
   _jumpMap[717][Constant] = 120;
   _jumpMap[717][SignedFloat] = 119;
   _jumpMap[717][SignedInt] = 118;
   _jumpMap[717][Attribute] = 117;
   _jumpMap[717][Function] = 116;
   _jumpMap[717][CasePrepare] = 115;
   _jumpMap[717][CaseClause] = 114;
   _jumpMap[717][Factor] = 113;
   _jumpMap[717][Term] = 112;
   _jumpMap[717][Expr] = 808;
   _actionMap[718][NOT] = ActionEntry(SHIFT, 809);
   _actionMap[718][NULLTOKEN] = ActionEntry(SHIFT, 810);
   _actionMap[719][RB] = ActionEntry(SHIFT, 811);
   _actionMap[719][OR] = ActionEntry(SHIFT, 716);
   _actionMap[719][AND] = ActionEntry(SHIFT, 715);
   _actionMap[720][RB] = ActionEntry(SHIFT, 499);
   _actionMap[720][PLUS] = ActionEntry(SHIFT, 275);
   _actionMap[720][MINUS] = ActionEntry(SHIFT, 274);
   _actionMap[720][CONCAT] = ActionEntry(SHIFT, 273);
   _actionMap[720][IS] = ActionEntry(SHIFT, 718);
   _actionMap[720][EQU] = ActionEntry(SHIFT, 595);
   _actionMap[720][NEGATION] = ActionEntry(SHIFT, 598);
   _actionMap[720][LT] = ActionEntry(SHIFT, 596);
   _actionMap[720][MT] = ActionEntry(SHIFT, 597);
   _jumpMap[720][Comparison] = 717;
   _actionMap[721][SEMICOLON] = ActionEntry(REDUCE, 129);
   _actionMap[721][EQU] = ActionEntry(SHIFT, 814);
   _jumpMap[721][ProcNoAssignment] = 813;
   _jumpMap[721][ProcInitialAssignment] = 812;
   _actionMap[722][LB] = ActionEntry(SHIFT, 815);
   _actionMap[723][BEGIN] = ActionEntry(REDUCE, 391);
   _actionMap[723][EQU] = ActionEntry(REDUCE, 391);
   _actionMap[723][DEFAULT] = ActionEntry(REDUCE, 391);
   _actionMap[723][NULLTOKEN] = ActionEntry(REDUCE, 391);
   _actionMap[723][NOT] = ActionEntry(REDUCE, 391);
   _actionMap[723][KSEP] = ActionEntry(REDUCE, 391);
}
void Cego::loadParser55()
{
   _actionMap[723][SEMICOLON] = ActionEntry(REDUCE, 391);
   _actionMap[723][RB] = ActionEntry(REDUCE, 391);
   _actionMap[724][BEGIN] = ActionEntry(REDUCE, 383);
   _actionMap[724][EQU] = ActionEntry(REDUCE, 383);
   _actionMap[724][DEFAULT] = ActionEntry(REDUCE, 383);
   _actionMap[724][NULLTOKEN] = ActionEntry(REDUCE, 383);
   _actionMap[724][NOT] = ActionEntry(REDUCE, 383);
   _actionMap[724][KSEP] = ActionEntry(REDUCE, 383);
   _actionMap[724][SEMICOLON] = ActionEntry(REDUCE, 383);
   _actionMap[724][RB] = ActionEntry(REDUCE, 383);
   _actionMap[725][BEGIN] = ActionEntry(REDUCE, 392);
   _actionMap[725][EQU] = ActionEntry(REDUCE, 392);
   _actionMap[725][DEFAULT] = ActionEntry(REDUCE, 392);
   _actionMap[725][NULLTOKEN] = ActionEntry(REDUCE, 392);
   _actionMap[725][NOT] = ActionEntry(REDUCE, 392);
   _actionMap[725][KSEP] = ActionEntry(REDUCE, 392);
   _actionMap[725][SEMICOLON] = ActionEntry(REDUCE, 392);
   _actionMap[725][RB] = ActionEntry(REDUCE, 392);
   _actionMap[726][BEGIN] = ActionEntry(REDUCE, 382);
   _actionMap[726][EQU] = ActionEntry(REDUCE, 382);
   _actionMap[726][DEFAULT] = ActionEntry(REDUCE, 382);
   _actionMap[726][NULLTOKEN] = ActionEntry(REDUCE, 382);
   _actionMap[726][NOT] = ActionEntry(REDUCE, 382);
   _actionMap[726][KSEP] = ActionEntry(REDUCE, 382);
   _actionMap[726][SEMICOLON] = ActionEntry(REDUCE, 382);
   _actionMap[726][RB] = ActionEntry(REDUCE, 382);
   _actionMap[727][LB] = ActionEntry(SHIFT, 816);
   _actionMap[728][BEGIN] = ActionEntry(REDUCE, 386);
   _actionMap[728][EQU] = ActionEntry(REDUCE, 386);
   _actionMap[728][DEFAULT] = ActionEntry(REDUCE, 386);
   _actionMap[728][NULLTOKEN] = ActionEntry(REDUCE, 386);
   _actionMap[728][NOT] = ActionEntry(REDUCE, 386);
   _actionMap[728][KSEP] = ActionEntry(REDUCE, 386);
   _actionMap[728][SEMICOLON] = ActionEntry(REDUCE, 386);
   _actionMap[728][RB] = ActionEntry(REDUCE, 386);
   _actionMap[729][LB] = ActionEntry(SHIFT, 817);
   _actionMap[730][BEGIN] = ActionEntry(REDUCE, 385);
   _actionMap[730][EQU] = ActionEntry(REDUCE, 385);
   _actionMap[730][DEFAULT] = ActionEntry(REDUCE, 385);
   _actionMap[730][NULLTOKEN] = ActionEntry(REDUCE, 385);
   _actionMap[730][NOT] = ActionEntry(REDUCE, 385);
   _actionMap[730][KSEP] = ActionEntry(REDUCE, 385);
   _actionMap[730][SEMICOLON] = ActionEntry(REDUCE, 385);
   _actionMap[730][RB] = ActionEntry(REDUCE, 385);
   _actionMap[731][BEGIN] = ActionEntry(REDUCE, 379);
   _actionMap[731][EQU] = ActionEntry(REDUCE, 379);
   _actionMap[731][DEFAULT] = ActionEntry(REDUCE, 379);
   _actionMap[731][NULLTOKEN] = ActionEntry(REDUCE, 379);
   _actionMap[731][NOT] = ActionEntry(REDUCE, 379);
   _actionMap[731][KSEP] = ActionEntry(REDUCE, 379);
}
void Cego::loadParser56()
{
   _actionMap[731][SEMICOLON] = ActionEntry(REDUCE, 379);
   _actionMap[731][RB] = ActionEntry(REDUCE, 379);
   _actionMap[732][BEGIN] = ActionEntry(REDUCE, 380);
   _actionMap[732][EQU] = ActionEntry(REDUCE, 380);
   _actionMap[732][DEFAULT] = ActionEntry(REDUCE, 380);
   _actionMap[732][NULLTOKEN] = ActionEntry(REDUCE, 380);
   _actionMap[732][NOT] = ActionEntry(REDUCE, 380);
   _actionMap[732][KSEP] = ActionEntry(REDUCE, 380);
   _actionMap[732][SEMICOLON] = ActionEntry(REDUCE, 380);
   _actionMap[732][RB] = ActionEntry(REDUCE, 380);
   _actionMap[733][BEGIN] = ActionEntry(REDUCE, 387);
   _actionMap[733][EQU] = ActionEntry(REDUCE, 387);
   _actionMap[733][DEFAULT] = ActionEntry(REDUCE, 387);
   _actionMap[733][NULLTOKEN] = ActionEntry(REDUCE, 387);
   _actionMap[733][NOT] = ActionEntry(REDUCE, 387);
   _actionMap[733][KSEP] = ActionEntry(REDUCE, 387);
   _actionMap[733][SEMICOLON] = ActionEntry(REDUCE, 387);
   _actionMap[733][RB] = ActionEntry(REDUCE, 387);
   _actionMap[734][LB] = ActionEntry(SHIFT, 818);
   _actionMap[735][BEGIN] = ActionEntry(REDUCE, 388);
   _actionMap[735][EQU] = ActionEntry(REDUCE, 388);
   _actionMap[735][DEFAULT] = ActionEntry(REDUCE, 388);
   _actionMap[735][NULLTOKEN] = ActionEntry(REDUCE, 388);
   _actionMap[735][NOT] = ActionEntry(REDUCE, 388);
   _actionMap[735][KSEP] = ActionEntry(REDUCE, 388);
   _actionMap[735][SEMICOLON] = ActionEntry(REDUCE, 388);
   _actionMap[735][RB] = ActionEntry(REDUCE, 388);
   _actionMap[736][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[736][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[736][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[736][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[736][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[736][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[736][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[736][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[736][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[736][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[736][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[736][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[736][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[736][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[736][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[736][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[736][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[736][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[736][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[736][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[736][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[736][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[736][STR2INT] = ActionEntry(SHIFT, 169);
}
void Cego::loadParser57()
{
   _actionMap[736][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[736][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[736][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[736][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[736][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[736][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[736][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[736][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[736][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[736][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[736][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[736][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[736][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[736][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[736][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[736][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[736][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[736][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[736][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[736][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[736][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[736][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[736][LB] = ActionEntry(SHIFT, 176);
   _actionMap[736][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[736][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[736][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[736][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[736][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[736][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[736][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[736][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[736][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[736][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[736][VARREF] = ActionEntry(SHIFT, 410);
   _actionMap[736][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[736][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[736][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[736][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[736][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[736][MAX] = ActionEntry(SHIFT, 154);
   _actionMap[736][IF] = ActionEntry(SHIFT, 404);
   _actionMap[736][BEGIN] = ActionEntry(SHIFT, 401);
   _actionMap[736][UNLOCK] = ActionEntry(SHIFT, 28);
   _actionMap[736][LOCK] = ActionEntry(SHIFT, 27);
   _actionMap[736][ROLLBACK] = ActionEntry(SHIFT, 33);
   _actionMap[736][COMMIT] = ActionEntry(SHIFT, 18);
   _actionMap[736][START_TOKEN] = ActionEntry(SHIFT, 37);
   _actionMap[736][UPDATE] = ActionEntry(SHIFT, 43);
   _actionMap[736][DELETETOK] = ActionEntry(SHIFT, 20);
   _actionMap[736][INSERT] = ActionEntry(SHIFT, 23);
}
void Cego::loadParser58()
{
   _actionMap[736][VAR] = ActionEntry(SHIFT, 408);
   _actionMap[736][CURSOR] = ActionEntry(SHIFT, 403);
   _actionMap[736][CLOSE] = ActionEntry(SHIFT, 402);
   _actionMap[736][NOOP] = ActionEntry(SHIFT, 405);
   _actionMap[736][THROW] = ActionEntry(SHIFT, 407);
   _actionMap[736][RETURNTOKEN] = ActionEntry(SHIFT, 406);
   _actionMap[736][WHILE] = ActionEntry(SHIFT, 409);
   _jumpMap[736][ObjSpec] = 121;
   _jumpMap[736][Constant] = 120;
   _jumpMap[736][SignedFloat] = 119;
   _jumpMap[736][SignedInt] = 118;
   _jumpMap[736][Attribute] = 117;
   _jumpMap[736][Function] = 116;
   _jumpMap[736][DeleteStatement] = 400;
   _jumpMap[736][UpdateStatement] = 399;
   _jumpMap[736][InsertStatement] = 398;
   _jumpMap[736][UnlockStatement] = 397;
   _jumpMap[736][LockStatement] = 396;
   _jumpMap[736][RollbackStatement] = 395;
   _jumpMap[736][CommitStatement] = 394;
   _jumpMap[736][StartStatement] = 393;
   _jumpMap[736][CasePrepare] = 115;
   _jumpMap[736][CaseClause] = 114;
   _jumpMap[736][Factor] = 113;
   _jumpMap[736][Term] = 112;
   _jumpMap[736][Expr] = 392;
   _jumpMap[736][ProcStatement] = 391;
   _jumpMap[736][ProcIfPart] = 390;
   _jumpMap[736][ProcBlockStart] = 389;
   _jumpMap[736][ProcStatementList] = 388;
   _jumpMap[736][ProcStmtBlock] = 819;
   _actionMap[737][PLUS] = ActionEntry(SHIFT, 275);
   _actionMap[737][MINUS] = ActionEntry(SHIFT, 274);
   _actionMap[737][CONCAT] = ActionEntry(SHIFT, 273);
   _actionMap[737][SEMICOLON] = ActionEntry(REDUCE, 124);
   _actionMap[738][LB] = ActionEntry(SHIFT, 820);
   _actionMap[739][IDENTIFIER] = ActionEntry(SHIFT, 823);
   _jumpMap[739][AliasAttr] = 822;
   _jumpMap[739][AliasAttrList] = 821;
   _actionMap[740][IDENTIFIER] = ActionEntry(SHIFT, 826);
   _jumpMap[740][SimpleAttr] = 825;
   _jumpMap[740][SimpleAttrList] = 824;
   _actionMap[741][IDENTIFIER] = ActionEntry(SHIFT, 569);
   _jumpMap[741][ProcArg] = 827;
   _actionMap[742][BEGIN] = ActionEntry(REDUCE, 108);
   _actionMap[743][INT] = ActionEntry(SHIFT, 731);
   _actionMap[743][LONG] = ActionEntry(SHIFT, 732);
   _actionMap[743][STRING] = ActionEntry(SHIFT, 734);
   _actionMap[743][DATETIME] = ActionEntry(SHIFT, 726);
   _actionMap[743][BOOL] = ActionEntry(SHIFT, 724);
}
void Cego::loadParser59()
{
   _actionMap[743][BIGINT] = ActionEntry(SHIFT, 722);
   _actionMap[743][FLOAT] = ActionEntry(SHIFT, 730);
   _actionMap[743][DOUBLE] = ActionEntry(SHIFT, 728);
   _actionMap[743][SMALLINT] = ActionEntry(SHIFT, 733);
   _actionMap[743][TINYINT] = ActionEntry(SHIFT, 735);
   _actionMap[743][DECIMAL] = ActionEntry(SHIFT, 727);
   _actionMap[743][FIXED] = ActionEntry(SHIFT, 729);
   _actionMap[743][BLOB] = ActionEntry(SHIFT, 723);
   _actionMap[743][CLOB] = ActionEntry(SHIFT, 725);
   _jumpMap[743][DataTypeProd] = 828;
   _actionMap[744][INT] = ActionEntry(SHIFT, 731);
   _actionMap[744][LONG] = ActionEntry(SHIFT, 732);
   _actionMap[744][STRING] = ActionEntry(SHIFT, 734);
   _actionMap[744][DATETIME] = ActionEntry(SHIFT, 726);
   _actionMap[744][BOOL] = ActionEntry(SHIFT, 724);
   _actionMap[744][BIGINT] = ActionEntry(SHIFT, 722);
   _actionMap[744][FLOAT] = ActionEntry(SHIFT, 730);
   _actionMap[744][DOUBLE] = ActionEntry(SHIFT, 728);
   _actionMap[744][SMALLINT] = ActionEntry(SHIFT, 733);
   _actionMap[744][TINYINT] = ActionEntry(SHIFT, 735);
   _actionMap[744][DECIMAL] = ActionEntry(SHIFT, 727);
   _actionMap[744][FIXED] = ActionEntry(SHIFT, 729);
   _actionMap[744][BLOB] = ActionEntry(SHIFT, 723);
   _actionMap[744][CLOB] = ActionEntry(SHIFT, 725);
   _jumpMap[744][DataTypeProd] = 829;
   _actionMap[745][INT] = ActionEntry(SHIFT, 731);
   _actionMap[745][LONG] = ActionEntry(SHIFT, 732);
   _actionMap[745][STRING] = ActionEntry(SHIFT, 734);
   _actionMap[745][DATETIME] = ActionEntry(SHIFT, 726);
   _actionMap[745][BOOL] = ActionEntry(SHIFT, 724);
   _actionMap[745][BIGINT] = ActionEntry(SHIFT, 722);
   _actionMap[745][FLOAT] = ActionEntry(SHIFT, 730);
   _actionMap[745][DOUBLE] = ActionEntry(SHIFT, 728);
   _actionMap[745][SMALLINT] = ActionEntry(SHIFT, 733);
   _actionMap[745][TINYINT] = ActionEntry(SHIFT, 735);
   _actionMap[745][DECIMAL] = ActionEntry(SHIFT, 727);
   _actionMap[745][FIXED] = ActionEntry(SHIFT, 729);
   _actionMap[745][BLOB] = ActionEntry(SHIFT, 723);
   _actionMap[745][CLOB] = ActionEntry(SHIFT, 725);
   _jumpMap[745][DataTypeProd] = 830;
   _actionMap[746][IDENTIFIER] = ActionEntry(SHIFT, 574);
   _actionMap[746][PRIMARY] = ActionEntry(SHIFT, 573);
   _jumpMap[746][ColumnDesc] = 572;
   _jumpMap[746][KeyColumn] = 831;
   _actionMap[747][SEMICOLON] = ActionEntry(REDUCE, 62);
   _actionMap[748][KSEP] = ActionEntry(REDUCE, 200);
   _actionMap[748][RB] = ActionEntry(REDUCE, 200);
   _actionMap[749][RB] = ActionEntry(REDUCE, 209);
   _actionMap[749][SEMICOLON] = ActionEntry(REDUCE, 209);
   _actionMap[749][KSEP] = ActionEntry(REDUCE, 209);
}
void Cego::loadParser60()
{
   _actionMap[749][NOT] = ActionEntry(REDUCE, 209);
   _actionMap[749][NULLTOKEN] = ActionEntry(REDUCE, 209);
   _actionMap[749][DEFAULT] = ActionEntry(SHIFT, 834);
   _jumpMap[749][DefaultDefOpt] = 833;
   _jumpMap[749][DefaultOpt] = 832;
   _actionMap[750][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[750][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[750][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[750][ObjSpec] = 835;
   _actionMap[751][INSERT] = ActionEntry(SHIFT, 578);
   _actionMap[751][UPDATE] = ActionEntry(SHIFT, 579);
   _actionMap[751][DELETETOK] = ActionEntry(SHIFT, 577);
   _jumpMap[751][TriggerOp] = 836;
   _actionMap[752][LB] = ActionEntry(SHIFT, 584);
   _jumpMap[752][InsertValueSpec] = 837;
   _actionMap[753][PLUS] = ActionEntry(SHIFT, 275);
   _actionMap[753][MINUS] = ActionEntry(SHIFT, 274);
   _actionMap[753][CONCAT] = ActionEntry(SHIFT, 273);
   _actionMap[753][KSEP] = ActionEntry(REDUCE, 235);
   _actionMap[753][RB] = ActionEntry(REDUCE, 235);
   _actionMap[754][RB] = ActionEntry(SHIFT, 839);
   _actionMap[754][KSEP] = ActionEntry(SHIFT, 838);
   _actionMap[755][IDENTIFIER] = ActionEntry(SHIFT, 840);
   _actionMap[756][SELECT] = ActionEntry(REDUCE, 226);
   _actionMap[756][VALUES] = ActionEntry(REDUCE, 226);
   _actionMap[757][WHEN] = ActionEntry(REDUCE, 191);
   _actionMap[757][ELSE] = ActionEntry(REDUCE, 191);
   _actionMap[757][LEFT] = ActionEntry(REDUCE, 191);
   _actionMap[757][RIGHT] = ActionEntry(REDUCE, 191);
   _actionMap[757][INNER] = ActionEntry(REDUCE, 191);
   _actionMap[757][JOIN] = ActionEntry(REDUCE, 191);
   _actionMap[757][RETURNTOKEN] = ActionEntry(REDUCE, 191);
   _actionMap[757][ORDER] = ActionEntry(REDUCE, 191);
   _actionMap[757][GROUP] = ActionEntry(REDUCE, 191);
   _actionMap[757][WHERE] = ActionEntry(REDUCE, 191);
   _actionMap[757][BEGIN] = ActionEntry(REDUCE, 191);
   _actionMap[757][THEN] = ActionEntry(REDUCE, 191);
   _actionMap[757][OR] = ActionEntry(REDUCE, 191);
   _actionMap[757][FROM] = ActionEntry(REDUCE, 191);
   _actionMap[757][AS] = ActionEntry(REDUCE, 191);
   _actionMap[757][END_TOKEN] = ActionEntry(REDUCE, 191);
   _actionMap[757][AND] = ActionEntry(REDUCE, 191);
   _actionMap[757][INTOK] = ActionEntry(REDUCE, 191);
   _actionMap[757][NOT] = ActionEntry(REDUCE, 191);
   _actionMap[757][BETWEEN] = ActionEntry(REDUCE, 191);
   _actionMap[757][IS] = ActionEntry(REDUCE, 191);
   _actionMap[757][LIKE] = ActionEntry(REDUCE, 191);
   _actionMap[757][MT] = ActionEntry(REDUCE, 191);
   _actionMap[757][LT] = ActionEntry(REDUCE, 191);
   _actionMap[757][NEGATION] = ActionEntry(REDUCE, 191);
}
void Cego::loadParser61()
{
   _actionMap[757][EQU] = ActionEntry(REDUCE, 191);
   _actionMap[757][RB] = ActionEntry(REDUCE, 191);
   _actionMap[757][ENDTOKEN] = ActionEntry(REDUCE, 191);
   _actionMap[757][UNION] = ActionEntry(REDUCE, 191);
   _actionMap[757][ROWLIMIT] = ActionEntry(REDUCE, 191);
   _actionMap[757][KSEP] = ActionEntry(REDUCE, 191);
   _actionMap[757][ASC] = ActionEntry(REDUCE, 191);
   _actionMap[757][DESC] = ActionEntry(REDUCE, 191);
   _actionMap[757][SEMICOLON] = ActionEntry(REDUCE, 191);
   _actionMap[757][PLUS] = ActionEntry(REDUCE, 191);
   _actionMap[757][MINUS] = ActionEntry(REDUCE, 191);
   _actionMap[757][DIVISION] = ActionEntry(REDUCE, 191);
   _actionMap[757][STAR] = ActionEntry(REDUCE, 191);
   _actionMap[757][CONCAT] = ActionEntry(REDUCE, 191);
   _actionMap[758][PLUS] = ActionEntry(SHIFT, 275);
   _actionMap[758][MINUS] = ActionEntry(SHIFT, 274);
   _actionMap[758][CONCAT] = ActionEntry(SHIFT, 273);
   _actionMap[758][LEFT] = ActionEntry(REDUCE, 371);
   _actionMap[758][RIGHT] = ActionEntry(REDUCE, 371);
   _actionMap[758][INNER] = ActionEntry(REDUCE, 371);
   _actionMap[758][JOIN] = ActionEntry(REDUCE, 371);
   _actionMap[758][RETURNTOKEN] = ActionEntry(REDUCE, 371);
   _actionMap[758][SEMICOLON] = ActionEntry(REDUCE, 371);
   _actionMap[758][ENDTOKEN] = ActionEntry(REDUCE, 371);
   _actionMap[758][UNION] = ActionEntry(REDUCE, 371);
   _actionMap[758][ROWLIMIT] = ActionEntry(REDUCE, 371);
   _actionMap[758][ORDER] = ActionEntry(REDUCE, 371);
   _actionMap[758][GROUP] = ActionEntry(REDUCE, 371);
   _actionMap[758][WHERE] = ActionEntry(REDUCE, 371);
   _actionMap[758][THEN] = ActionEntry(REDUCE, 371);
   _actionMap[758][AND] = ActionEntry(REDUCE, 371);
   _actionMap[758][OR] = ActionEntry(REDUCE, 371);
   _actionMap[758][RB] = ActionEntry(REDUCE, 371);
   _actionMap[759][AND] = ActionEntry(SHIFT, 841);
   _actionMap[759][PLUS] = ActionEntry(SHIFT, 275);
   _actionMap[759][MINUS] = ActionEntry(SHIFT, 274);
   _actionMap[759][CONCAT] = ActionEntry(SHIFT, 273);
   _actionMap[760][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[760][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[760][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[760][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[760][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[760][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[760][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[760][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[760][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[760][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[760][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[760][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[760][NEWDATE] = ActionEntry(SHIFT, 145);
}
void Cego::loadParser62()
{
   _actionMap[760][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[760][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[760][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[760][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[760][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[760][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[760][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[760][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[760][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[760][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[760][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[760][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[760][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[760][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[760][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[760][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[760][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[760][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[760][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[760][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[760][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[760][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[760][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[760][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[760][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[760][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[760][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[760][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[760][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[760][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[760][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[760][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[760][LB] = ActionEntry(SHIFT, 176);
   _actionMap[760][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[760][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[760][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[760][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[760][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[760][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[760][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[760][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[760][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[760][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[760][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[760][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[760][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[760][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[760][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[760][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[760][MAX] = ActionEntry(SHIFT, 154);
}
void Cego::loadParser63()
{
   _actionMap[760][SELECT] = ActionEntry(SHIFT, 34);
   _jumpMap[760][ObjSpec] = 121;
   _jumpMap[760][Constant] = 120;
   _jumpMap[760][SignedFloat] = 119;
   _jumpMap[760][SignedInt] = 118;
   _jumpMap[760][Attribute] = 117;
   _jumpMap[760][ExpressionList] = 843;
   _jumpMap[760][Function] = 116;
   _jumpMap[760][SelectStatement] = 842;
   _jumpMap[760][CasePrepare] = 115;
   _jumpMap[760][CaseClause] = 114;
   _jumpMap[760][Factor] = 113;
   _jumpMap[760][Term] = 112;
   _jumpMap[760][Expr] = 446;
   _actionMap[761][NULLTOKEN] = ActionEntry(SHIFT, 844);
   _actionMap[762][LEFT] = ActionEntry(REDUCE, 373);
   _actionMap[762][RIGHT] = ActionEntry(REDUCE, 373);
   _actionMap[762][INNER] = ActionEntry(REDUCE, 373);
   _actionMap[762][JOIN] = ActionEntry(REDUCE, 373);
   _actionMap[762][RETURNTOKEN] = ActionEntry(REDUCE, 373);
   _actionMap[762][SEMICOLON] = ActionEntry(REDUCE, 373);
   _actionMap[762][ENDTOKEN] = ActionEntry(REDUCE, 373);
   _actionMap[762][UNION] = ActionEntry(REDUCE, 373);
   _actionMap[762][ROWLIMIT] = ActionEntry(REDUCE, 373);
   _actionMap[762][ORDER] = ActionEntry(REDUCE, 373);
   _actionMap[762][GROUP] = ActionEntry(REDUCE, 373);
   _actionMap[762][WHERE] = ActionEntry(REDUCE, 373);
   _actionMap[762][THEN] = ActionEntry(REDUCE, 373);
   _actionMap[762][AND] = ActionEntry(REDUCE, 373);
   _actionMap[762][OR] = ActionEntry(REDUCE, 373);
   _actionMap[762][RB] = ActionEntry(REDUCE, 373);
   _actionMap[763][LEFT] = ActionEntry(REDUCE, 375);
   _actionMap[763][RIGHT] = ActionEntry(REDUCE, 375);
   _actionMap[763][INNER] = ActionEntry(REDUCE, 375);
   _actionMap[763][JOIN] = ActionEntry(REDUCE, 375);
   _actionMap[763][RETURNTOKEN] = ActionEntry(REDUCE, 375);
   _actionMap[763][SEMICOLON] = ActionEntry(REDUCE, 375);
   _actionMap[763][ENDTOKEN] = ActionEntry(REDUCE, 375);
   _actionMap[763][UNION] = ActionEntry(REDUCE, 375);
   _actionMap[763][ROWLIMIT] = ActionEntry(REDUCE, 375);
   _actionMap[763][ORDER] = ActionEntry(REDUCE, 375);
   _actionMap[763][GROUP] = ActionEntry(REDUCE, 375);
   _actionMap[763][WHERE] = ActionEntry(REDUCE, 375);
   _actionMap[763][THEN] = ActionEntry(REDUCE, 375);
   _actionMap[763][AND] = ActionEntry(REDUCE, 375);
   _actionMap[763][OR] = ActionEntry(REDUCE, 375);
   _actionMap[763][RB] = ActionEntry(REDUCE, 375);
   _actionMap[764][LB] = ActionEntry(SHIFT, 845);
   _actionMap[765][STRINGVAL] = ActionEntry(SHIFT, 846);
   _actionMap[766][VARREF] = ActionEntry(REDUCE, 399);
}
void Cego::loadParser64()
{
   _actionMap[766][FETCH] = ActionEntry(REDUCE, 399);
   _actionMap[766][LB] = ActionEntry(REDUCE, 399);
   _actionMap[766][COUNT] = ActionEntry(REDUCE, 399);
   _actionMap[766][SUM] = ActionEntry(REDUCE, 399);
   _actionMap[766][AVG] = ActionEntry(REDUCE, 399);
   _actionMap[766][MIN] = ActionEntry(REDUCE, 399);
   _actionMap[766][MAX] = ActionEntry(REDUCE, 399);
   _actionMap[766][CASE] = ActionEntry(REDUCE, 399);
   _actionMap[766][INT2ASC] = ActionEntry(REDUCE, 399);
   _actionMap[766][ASC2INT] = ActionEntry(REDUCE, 399);
   _actionMap[766][TRIM] = ActionEntry(REDUCE, 399);
   _actionMap[766][RTRIM] = ActionEntry(REDUCE, 399);
   _actionMap[766][LTRIM] = ActionEntry(REDUCE, 399);
   _actionMap[766][ROUND] = ActionEntry(REDUCE, 399);
   _actionMap[766][DATE2STR] = ActionEntry(REDUCE, 399);
   _actionMap[766][DATE2LONG] = ActionEntry(REDUCE, 399);
   _actionMap[766][LONG2DATE] = ActionEntry(REDUCE, 399);
   _actionMap[766][NEWDATE] = ActionEntry(REDUCE, 399);
   _actionMap[766][LOWER] = ActionEntry(REDUCE, 399);
   _actionMap[766][UPPER] = ActionEntry(REDUCE, 399);
   _actionMap[766][LEFT] = ActionEntry(REDUCE, 399);
   _actionMap[766][RIGHT] = ActionEntry(REDUCE, 399);
   _actionMap[766][GETPOS] = ActionEntry(REDUCE, 399);
   _actionMap[766][SUBSTR] = ActionEntry(REDUCE, 399);
   _actionMap[766][REPLACE] = ActionEntry(REDUCE, 399);
   _actionMap[766][LENGTH] = ActionEntry(REDUCE, 399);
   _actionMap[766][TRUNC] = ActionEntry(REDUCE, 399);
   _actionMap[766][STR2INT] = ActionEntry(REDUCE, 399);
   _actionMap[766][STR2LONG] = ActionEntry(REDUCE, 399);
   _actionMap[766][STR2DATE] = ActionEntry(REDUCE, 399);
   _actionMap[766][RANDSTR] = ActionEntry(REDUCE, 399);
   _actionMap[766][RANDINT] = ActionEntry(REDUCE, 399);
   _actionMap[766][MOD] = ActionEntry(REDUCE, 399);
   _actionMap[766][DIV] = ActionEntry(REDUCE, 399);
   _actionMap[766][LMOD] = ActionEntry(REDUCE, 399);
   _actionMap[766][LDIV] = ActionEntry(REDUCE, 399);
   _actionMap[766][POWER] = ActionEntry(REDUCE, 399);
   _actionMap[766][BITAND] = ActionEntry(REDUCE, 399);
   _actionMap[766][BITOR] = ActionEntry(REDUCE, 399);
   _actionMap[766][BITXOR] = ActionEntry(REDUCE, 399);
   _actionMap[766][BLOBSIZE] = ActionEntry(REDUCE, 399);
   _actionMap[766][BLOBREF] = ActionEntry(REDUCE, 399);
   _actionMap[766][CLOBSIZE] = ActionEntry(REDUCE, 399);
   _actionMap[766][CLOBREF] = ActionEntry(REDUCE, 399);
   _actionMap[766][CLOB2STR] = ActionEntry(REDUCE, 399);
   _actionMap[766][NEXTCOUNT] = ActionEntry(REDUCE, 399);
   _actionMap[766][SETCOUNT] = ActionEntry(REDUCE, 399);
   _actionMap[766][IDENTIFIER] = ActionEntry(REDUCE, 399);
   _actionMap[766][QUALIFIEDOBJ] = ActionEntry(REDUCE, 399);
   _actionMap[766][QUALIFIEDTS] = ActionEntry(REDUCE, 399);
}
void Cego::loadParser65()
{
   _actionMap[766][QUALIFIEDPRE] = ActionEntry(REDUCE, 399);
   _actionMap[766][STRINGVAL] = ActionEntry(REDUCE, 399);
   _actionMap[766][DATE] = ActionEntry(REDUCE, 399);
   _actionMap[766][SYSDATE] = ActionEntry(REDUCE, 399);
   _actionMap[766][NULLTOKEN] = ActionEntry(REDUCE, 399);
   _actionMap[766][TRUEVAL] = ActionEntry(REDUCE, 399);
   _actionMap[766][FALSEVAL] = ActionEntry(REDUCE, 399);
   _actionMap[766][BLOB] = ActionEntry(REDUCE, 399);
   _actionMap[766][CLOB] = ActionEntry(REDUCE, 399);
   _actionMap[766][FLOATVAL] = ActionEntry(REDUCE, 399);
   _actionMap[766][MINUS] = ActionEntry(REDUCE, 399);
   _actionMap[766][INTVAL] = ActionEntry(REDUCE, 399);
   _actionMap[767][VARREF] = ActionEntry(REDUCE, 400);
   _actionMap[767][FETCH] = ActionEntry(REDUCE, 400);
   _actionMap[767][LB] = ActionEntry(REDUCE, 400);
   _actionMap[767][COUNT] = ActionEntry(REDUCE, 400);
   _actionMap[767][SUM] = ActionEntry(REDUCE, 400);
   _actionMap[767][AVG] = ActionEntry(REDUCE, 400);
   _actionMap[767][MIN] = ActionEntry(REDUCE, 400);
   _actionMap[767][MAX] = ActionEntry(REDUCE, 400);
   _actionMap[767][CASE] = ActionEntry(REDUCE, 400);
   _actionMap[767][INT2ASC] = ActionEntry(REDUCE, 400);
   _actionMap[767][ASC2INT] = ActionEntry(REDUCE, 400);
   _actionMap[767][TRIM] = ActionEntry(REDUCE, 400);
   _actionMap[767][RTRIM] = ActionEntry(REDUCE, 400);
   _actionMap[767][LTRIM] = ActionEntry(REDUCE, 400);
   _actionMap[767][ROUND] = ActionEntry(REDUCE, 400);
   _actionMap[767][DATE2STR] = ActionEntry(REDUCE, 400);
   _actionMap[767][DATE2LONG] = ActionEntry(REDUCE, 400);
   _actionMap[767][LONG2DATE] = ActionEntry(REDUCE, 400);
   _actionMap[767][NEWDATE] = ActionEntry(REDUCE, 400);
   _actionMap[767][LOWER] = ActionEntry(REDUCE, 400);
   _actionMap[767][UPPER] = ActionEntry(REDUCE, 400);
   _actionMap[767][LEFT] = ActionEntry(REDUCE, 400);
   _actionMap[767][RIGHT] = ActionEntry(REDUCE, 400);
   _actionMap[767][GETPOS] = ActionEntry(REDUCE, 400);
   _actionMap[767][SUBSTR] = ActionEntry(REDUCE, 400);
   _actionMap[767][REPLACE] = ActionEntry(REDUCE, 400);
   _actionMap[767][LENGTH] = ActionEntry(REDUCE, 400);
   _actionMap[767][TRUNC] = ActionEntry(REDUCE, 400);
   _actionMap[767][STR2INT] = ActionEntry(REDUCE, 400);
   _actionMap[767][STR2LONG] = ActionEntry(REDUCE, 400);
   _actionMap[767][STR2DATE] = ActionEntry(REDUCE, 400);
   _actionMap[767][RANDSTR] = ActionEntry(REDUCE, 400);
   _actionMap[767][RANDINT] = ActionEntry(REDUCE, 400);
   _actionMap[767][MOD] = ActionEntry(REDUCE, 400);
   _actionMap[767][DIV] = ActionEntry(REDUCE, 400);
   _actionMap[767][LMOD] = ActionEntry(REDUCE, 400);
   _actionMap[767][LDIV] = ActionEntry(REDUCE, 400);
   _actionMap[767][POWER] = ActionEntry(REDUCE, 400);
}
void Cego::loadParser66()
{
   _actionMap[767][BITAND] = ActionEntry(REDUCE, 400);
   _actionMap[767][BITOR] = ActionEntry(REDUCE, 400);
   _actionMap[767][BITXOR] = ActionEntry(REDUCE, 400);
   _actionMap[767][BLOBSIZE] = ActionEntry(REDUCE, 400);
   _actionMap[767][BLOBREF] = ActionEntry(REDUCE, 400);
   _actionMap[767][CLOBSIZE] = ActionEntry(REDUCE, 400);
   _actionMap[767][CLOBREF] = ActionEntry(REDUCE, 400);
   _actionMap[767][CLOB2STR] = ActionEntry(REDUCE, 400);
   _actionMap[767][NEXTCOUNT] = ActionEntry(REDUCE, 400);
   _actionMap[767][SETCOUNT] = ActionEntry(REDUCE, 400);
   _actionMap[767][IDENTIFIER] = ActionEntry(REDUCE, 400);
   _actionMap[767][QUALIFIEDOBJ] = ActionEntry(REDUCE, 400);
   _actionMap[767][QUALIFIEDTS] = ActionEntry(REDUCE, 400);
   _actionMap[767][QUALIFIEDPRE] = ActionEntry(REDUCE, 400);
   _actionMap[767][STRINGVAL] = ActionEntry(REDUCE, 400);
   _actionMap[767][DATE] = ActionEntry(REDUCE, 400);
   _actionMap[767][SYSDATE] = ActionEntry(REDUCE, 400);
   _actionMap[767][NULLTOKEN] = ActionEntry(REDUCE, 400);
   _actionMap[767][TRUEVAL] = ActionEntry(REDUCE, 400);
   _actionMap[767][FALSEVAL] = ActionEntry(REDUCE, 400);
   _actionMap[767][BLOB] = ActionEntry(REDUCE, 400);
   _actionMap[767][CLOB] = ActionEntry(REDUCE, 400);
   _actionMap[767][FLOATVAL] = ActionEntry(REDUCE, 400);
   _actionMap[767][MINUS] = ActionEntry(REDUCE, 400);
   _actionMap[767][INTVAL] = ActionEntry(REDUCE, 400);
   _actionMap[768][VARREF] = ActionEntry(REDUCE, 396);
   _actionMap[768][FETCH] = ActionEntry(REDUCE, 396);
   _actionMap[768][LB] = ActionEntry(REDUCE, 396);
   _actionMap[768][COUNT] = ActionEntry(REDUCE, 396);
   _actionMap[768][SUM] = ActionEntry(REDUCE, 396);
   _actionMap[768][AVG] = ActionEntry(REDUCE, 396);
   _actionMap[768][MIN] = ActionEntry(REDUCE, 396);
   _actionMap[768][MAX] = ActionEntry(REDUCE, 396);
   _actionMap[768][CASE] = ActionEntry(REDUCE, 396);
   _actionMap[768][INT2ASC] = ActionEntry(REDUCE, 396);
   _actionMap[768][ASC2INT] = ActionEntry(REDUCE, 396);
   _actionMap[768][TRIM] = ActionEntry(REDUCE, 396);
   _actionMap[768][RTRIM] = ActionEntry(REDUCE, 396);
   _actionMap[768][LTRIM] = ActionEntry(REDUCE, 396);
   _actionMap[768][ROUND] = ActionEntry(REDUCE, 396);
   _actionMap[768][DATE2STR] = ActionEntry(REDUCE, 396);
   _actionMap[768][DATE2LONG] = ActionEntry(REDUCE, 396);
   _actionMap[768][LONG2DATE] = ActionEntry(REDUCE, 396);
   _actionMap[768][NEWDATE] = ActionEntry(REDUCE, 396);
   _actionMap[768][LOWER] = ActionEntry(REDUCE, 396);
   _actionMap[768][UPPER] = ActionEntry(REDUCE, 396);
   _actionMap[768][LEFT] = ActionEntry(REDUCE, 396);
   _actionMap[768][RIGHT] = ActionEntry(REDUCE, 396);
   _actionMap[768][GETPOS] = ActionEntry(REDUCE, 396);
   _actionMap[768][SUBSTR] = ActionEntry(REDUCE, 396);
}
void Cego::loadParser67()
{
   _actionMap[768][REPLACE] = ActionEntry(REDUCE, 396);
   _actionMap[768][LENGTH] = ActionEntry(REDUCE, 396);
   _actionMap[768][TRUNC] = ActionEntry(REDUCE, 396);
   _actionMap[768][STR2INT] = ActionEntry(REDUCE, 396);
   _actionMap[768][STR2LONG] = ActionEntry(REDUCE, 396);
   _actionMap[768][STR2DATE] = ActionEntry(REDUCE, 396);
   _actionMap[768][RANDSTR] = ActionEntry(REDUCE, 396);
   _actionMap[768][RANDINT] = ActionEntry(REDUCE, 396);
   _actionMap[768][MOD] = ActionEntry(REDUCE, 396);
   _actionMap[768][DIV] = ActionEntry(REDUCE, 396);
   _actionMap[768][LMOD] = ActionEntry(REDUCE, 396);
   _actionMap[768][LDIV] = ActionEntry(REDUCE, 396);
   _actionMap[768][POWER] = ActionEntry(REDUCE, 396);
   _actionMap[768][BITAND] = ActionEntry(REDUCE, 396);
   _actionMap[768][BITOR] = ActionEntry(REDUCE, 396);
   _actionMap[768][BITXOR] = ActionEntry(REDUCE, 396);
   _actionMap[768][BLOBSIZE] = ActionEntry(REDUCE, 396);
   _actionMap[768][BLOBREF] = ActionEntry(REDUCE, 396);
   _actionMap[768][CLOBSIZE] = ActionEntry(REDUCE, 396);
   _actionMap[768][CLOBREF] = ActionEntry(REDUCE, 396);
   _actionMap[768][CLOB2STR] = ActionEntry(REDUCE, 396);
   _actionMap[768][NEXTCOUNT] = ActionEntry(REDUCE, 396);
   _actionMap[768][SETCOUNT] = ActionEntry(REDUCE, 396);
   _actionMap[768][IDENTIFIER] = ActionEntry(REDUCE, 396);
   _actionMap[768][QUALIFIEDOBJ] = ActionEntry(REDUCE, 396);
   _actionMap[768][QUALIFIEDTS] = ActionEntry(REDUCE, 396);
   _actionMap[768][QUALIFIEDPRE] = ActionEntry(REDUCE, 396);
   _actionMap[768][STRINGVAL] = ActionEntry(REDUCE, 396);
   _actionMap[768][DATE] = ActionEntry(REDUCE, 396);
   _actionMap[768][SYSDATE] = ActionEntry(REDUCE, 396);
   _actionMap[768][NULLTOKEN] = ActionEntry(REDUCE, 396);
   _actionMap[768][TRUEVAL] = ActionEntry(REDUCE, 396);
   _actionMap[768][FALSEVAL] = ActionEntry(REDUCE, 396);
   _actionMap[768][BLOB] = ActionEntry(REDUCE, 396);
   _actionMap[768][CLOB] = ActionEntry(REDUCE, 396);
   _actionMap[768][FLOATVAL] = ActionEntry(REDUCE, 396);
   _actionMap[768][MINUS] = ActionEntry(REDUCE, 396);
   _actionMap[768][INTVAL] = ActionEntry(REDUCE, 396);
   _actionMap[769][LEFT] = ActionEntry(REDUCE, 363);
   _actionMap[769][RIGHT] = ActionEntry(REDUCE, 363);
   _actionMap[769][INNER] = ActionEntry(REDUCE, 363);
   _actionMap[769][JOIN] = ActionEntry(REDUCE, 363);
   _actionMap[769][RETURNTOKEN] = ActionEntry(REDUCE, 363);
   _actionMap[769][SEMICOLON] = ActionEntry(REDUCE, 363);
   _actionMap[769][ENDTOKEN] = ActionEntry(REDUCE, 363);
   _actionMap[769][UNION] = ActionEntry(REDUCE, 363);
   _actionMap[769][ROWLIMIT] = ActionEntry(REDUCE, 363);
   _actionMap[769][ORDER] = ActionEntry(REDUCE, 363);
   _actionMap[769][GROUP] = ActionEntry(REDUCE, 363);
   _actionMap[769][WHERE] = ActionEntry(REDUCE, 363);
}
void Cego::loadParser68()
{
   _actionMap[769][THEN] = ActionEntry(REDUCE, 363);
   _actionMap[769][RB] = ActionEntry(REDUCE, 363);
   _actionMap[769][OR] = ActionEntry(REDUCE, 363);
   _actionMap[769][AND] = ActionEntry(REDUCE, 363);
   _actionMap[770][LEFT] = ActionEntry(REDUCE, 364);
   _actionMap[770][RIGHT] = ActionEntry(REDUCE, 364);
   _actionMap[770][INNER] = ActionEntry(REDUCE, 364);
   _actionMap[770][JOIN] = ActionEntry(REDUCE, 364);
   _actionMap[770][RETURNTOKEN] = ActionEntry(REDUCE, 364);
   _actionMap[770][SEMICOLON] = ActionEntry(REDUCE, 364);
   _actionMap[770][ENDTOKEN] = ActionEntry(REDUCE, 364);
   _actionMap[770][UNION] = ActionEntry(REDUCE, 364);
   _actionMap[770][ROWLIMIT] = ActionEntry(REDUCE, 364);
   _actionMap[770][ORDER] = ActionEntry(REDUCE, 364);
   _actionMap[770][GROUP] = ActionEntry(REDUCE, 364);
   _actionMap[770][WHERE] = ActionEntry(REDUCE, 364);
   _actionMap[770][THEN] = ActionEntry(REDUCE, 364);
   _actionMap[770][RB] = ActionEntry(REDUCE, 364);
   _actionMap[770][OR] = ActionEntry(REDUCE, 364);
   _actionMap[770][AND] = ActionEntry(REDUCE, 364);
   _actionMap[771][PLUS] = ActionEntry(SHIFT, 275);
   _actionMap[771][MINUS] = ActionEntry(SHIFT, 274);
   _actionMap[771][CONCAT] = ActionEntry(SHIFT, 273);
   _actionMap[771][WHEN] = ActionEntry(REDUCE, 194);
   _actionMap[771][ELSE] = ActionEntry(REDUCE, 194);
   _actionMap[772][RB] = ActionEntry(SHIFT, 847);
   _actionMap[773][THEN] = ActionEntry(REDUCE, 377);
   _actionMap[773][LEFT] = ActionEntry(REDUCE, 377);
   _actionMap[773][RIGHT] = ActionEntry(REDUCE, 377);
   _actionMap[773][INNER] = ActionEntry(REDUCE, 377);
   _actionMap[773][JOIN] = ActionEntry(REDUCE, 377);
   _actionMap[773][RETURNTOKEN] = ActionEntry(REDUCE, 377);
   _actionMap[773][SEMICOLON] = ActionEntry(REDUCE, 377);
   _actionMap[773][RB] = ActionEntry(REDUCE, 377);
   _actionMap[773][ENDTOKEN] = ActionEntry(REDUCE, 377);
   _actionMap[773][UNION] = ActionEntry(REDUCE, 377);
   _actionMap[773][ROWLIMIT] = ActionEntry(REDUCE, 377);
   _actionMap[773][ORDER] = ActionEntry(REDUCE, 377);
   _actionMap[773][GROUP] = ActionEntry(REDUCE, 377);
   _actionMap[773][WHERE] = ActionEntry(REDUCE, 377);
   _actionMap[773][AND] = ActionEntry(REDUCE, 377);
   _actionMap[773][OR] = ActionEntry(REDUCE, 377);
   _actionMap[774][PLUS] = ActionEntry(SHIFT, 275);
   _actionMap[774][MINUS] = ActionEntry(SHIFT, 274);
   _actionMap[774][CONCAT] = ActionEntry(SHIFT, 273);
   _actionMap[774][KSEP] = ActionEntry(REDUCE, 358);
   _actionMap[774][RB] = ActionEntry(REDUCE, 358);
   _actionMap[775][RB] = ActionEntry(SHIFT, 848);
   _actionMap[776][RB] = ActionEntry(REDUCE, 426);
   _actionMap[777][RB] = ActionEntry(SHIFT, 850);
}
void Cego::loadParser69()
{
   _actionMap[777][KSEP] = ActionEntry(SHIFT, 849);
   _actionMap[778][KSEP] = ActionEntry(REDUCE, 197);
   _actionMap[778][RB] = ActionEntry(REDUCE, 197);
   _actionMap[779][RB] = ActionEntry(SHIFT, 851);
   _actionMap[779][PLUS] = ActionEntry(SHIFT, 275);
   _actionMap[779][MINUS] = ActionEntry(SHIFT, 274);
   _actionMap[779][CONCAT] = ActionEntry(SHIFT, 273);
   _actionMap[780][SEMICOLON] = ActionEntry(REDUCE, 275);
   _actionMap[780][RB] = ActionEntry(REDUCE, 275);
   _actionMap[780][ENDTOKEN] = ActionEntry(REDUCE, 275);
   _actionMap[780][UNION] = ActionEntry(REDUCE, 275);
   _actionMap[780][ROWLIMIT] = ActionEntry(REDUCE, 275);
   _actionMap[780][ORDER] = ActionEntry(SHIFT, 854);
   _jumpMap[780][NoOrdering] = 853;
   _jumpMap[780][OrderingClause] = 852;
   _actionMap[781][ORDER] = ActionEntry(REDUCE, 266);
   _actionMap[781][ROWLIMIT] = ActionEntry(REDUCE, 266);
   _actionMap[781][UNION] = ActionEntry(REDUCE, 266);
   _actionMap[781][ENDTOKEN] = ActionEntry(REDUCE, 266);
   _actionMap[781][RB] = ActionEntry(REDUCE, 266);
   _actionMap[781][SEMICOLON] = ActionEntry(REDUCE, 266);
   _actionMap[782][BY] = ActionEntry(SHIFT, 855);
   _actionMap[783][LEFT] = ActionEntry(REDUCE, 261);
   _actionMap[783][RIGHT] = ActionEntry(REDUCE, 261);
   _actionMap[783][INNER] = ActionEntry(REDUCE, 261);
   _actionMap[783][JOIN] = ActionEntry(REDUCE, 261);
   _actionMap[783][RETURNTOKEN] = ActionEntry(REDUCE, 261);
   _actionMap[783][SEMICOLON] = ActionEntry(REDUCE, 261);
   _actionMap[783][RB] = ActionEntry(REDUCE, 261);
   _actionMap[783][ENDTOKEN] = ActionEntry(REDUCE, 261);
   _actionMap[783][UNION] = ActionEntry(REDUCE, 261);
   _actionMap[783][ROWLIMIT] = ActionEntry(REDUCE, 261);
   _actionMap[783][ORDER] = ActionEntry(REDUCE, 261);
   _actionMap[783][GROUP] = ActionEntry(REDUCE, 261);
   _actionMap[783][WHERE] = ActionEntry(REDUCE, 261);
   _actionMap[783][ON] = ActionEntry(REDUCE, 261);
   _actionMap[784][ON] = ActionEntry(SHIFT, 856);
   _actionMap[784][LEFT] = ActionEntry(REDUCE, 249);
   _actionMap[784][RIGHT] = ActionEntry(REDUCE, 249);
   _actionMap[784][INNER] = ActionEntry(REDUCE, 249);
   _actionMap[784][JOIN] = ActionEntry(REDUCE, 249);
   _actionMap[784][RETURNTOKEN] = ActionEntry(REDUCE, 249);
   _actionMap[784][SEMICOLON] = ActionEntry(REDUCE, 249);
   _actionMap[784][RB] = ActionEntry(REDUCE, 249);
   _actionMap[784][ENDTOKEN] = ActionEntry(REDUCE, 249);
   _actionMap[784][UNION] = ActionEntry(REDUCE, 249);
   _actionMap[784][ROWLIMIT] = ActionEntry(REDUCE, 249);
   _actionMap[784][ORDER] = ActionEntry(REDUCE, 249);
   _actionMap[784][GROUP] = ActionEntry(REDUCE, 249);
   _actionMap[784][WHERE] = ActionEntry(REDUCE, 249);
}
void Cego::loadParser70()
{
   _actionMap[785][IDENTIFIER] = ActionEntry(REDUCE, 255);
   _actionMap[785][QUALIFIEDOBJ] = ActionEntry(REDUCE, 255);
   _actionMap[785][QUALIFIEDTS] = ActionEntry(REDUCE, 255);
   _actionMap[786][JOIN] = ActionEntry(SHIFT, 857);
   _actionMap[787][JOIN] = ActionEntry(SHIFT, 858);
   _actionMap[788][RETURNTOKEN] = ActionEntry(REDUCE, 257);
   _actionMap[788][SEMICOLON] = ActionEntry(REDUCE, 257);
   _actionMap[788][RB] = ActionEntry(REDUCE, 257);
   _actionMap[788][ENDTOKEN] = ActionEntry(REDUCE, 257);
   _actionMap[788][UNION] = ActionEntry(REDUCE, 257);
   _actionMap[788][ROWLIMIT] = ActionEntry(REDUCE, 257);
   _actionMap[788][ORDER] = ActionEntry(REDUCE, 257);
   _actionMap[788][GROUP] = ActionEntry(REDUCE, 257);
   _actionMap[788][WHERE] = ActionEntry(REDUCE, 257);
   _actionMap[789][KSEP] = ActionEntry(SHIFT, 682);
   _actionMap[789][RETURNTOKEN] = ActionEntry(REDUCE, 258);
   _actionMap[789][SEMICOLON] = ActionEntry(REDUCE, 258);
   _actionMap[789][RB] = ActionEntry(REDUCE, 258);
   _actionMap[789][ENDTOKEN] = ActionEntry(REDUCE, 258);
   _actionMap[789][UNION] = ActionEntry(REDUCE, 258);
   _actionMap[789][ROWLIMIT] = ActionEntry(REDUCE, 258);
   _actionMap[789][ORDER] = ActionEntry(REDUCE, 258);
   _actionMap[789][GROUP] = ActionEntry(REDUCE, 258);
   _actionMap[789][WHERE] = ActionEntry(REDUCE, 258);
   _actionMap[790][SEMICOLON] = ActionEntry(REDUCE, 288);
   _actionMap[791][ON] = ActionEntry(SHIFT, 861);
   _actionMap[791][VARREF] = ActionEntry(SHIFT, 862);
   _jumpMap[791][ReturnVar] = 860;
   _jumpMap[791][ReturnVarList] = 859;
   _actionMap[792][KSEP] = ActionEntry(REDUCE, 289);
   _actionMap[792][WHERE] = ActionEntry(REDUCE, 289);
   _actionMap[792][GROUP] = ActionEntry(REDUCE, 289);
   _actionMap[792][ORDER] = ActionEntry(REDUCE, 289);
   _actionMap[792][ROWLIMIT] = ActionEntry(REDUCE, 289);
   _actionMap[792][UNION] = ActionEntry(REDUCE, 289);
   _actionMap[792][ENDTOKEN] = ActionEntry(REDUCE, 289);
   _actionMap[792][RB] = ActionEntry(REDUCE, 289);
   _actionMap[792][SEMICOLON] = ActionEntry(REDUCE, 289);
   _actionMap[792][RETURNTOKEN] = ActionEntry(REDUCE, 289);
   _actionMap[793][PLUS] = ActionEntry(SHIFT, 275);
   _actionMap[793][MINUS] = ActionEntry(SHIFT, 274);
   _actionMap[793][CONCAT] = ActionEntry(SHIFT, 273);
   _actionMap[793][KSEP] = ActionEntry(REDUCE, 291);
   _actionMap[793][WHERE] = ActionEntry(REDUCE, 291);
   _actionMap[793][GROUP] = ActionEntry(REDUCE, 291);
   _actionMap[793][ORDER] = ActionEntry(REDUCE, 291);
   _actionMap[793][ROWLIMIT] = ActionEntry(REDUCE, 291);
   _actionMap[793][UNION] = ActionEntry(REDUCE, 291);
   _actionMap[793][ENDTOKEN] = ActionEntry(REDUCE, 291);
   _actionMap[793][RB] = ActionEntry(REDUCE, 291);
}
void Cego::loadParser71()
{
   _actionMap[793][SEMICOLON] = ActionEntry(REDUCE, 291);
   _actionMap[793][RETURNTOKEN] = ActionEntry(REDUCE, 291);
   _actionMap[794][RB] = ActionEntry(SHIFT, 795);
   _actionMap[795][SEMICOLON] = ActionEntry(REDUCE, 61);
   _actionMap[531][DROP] = ActionEntry(SHIFT, 379);
   _actionMap[531][ADD] = ActionEntry(SHIFT, 692);
   _actionMap[531][MODIFY] = ActionEntry(SHIFT, 380);
   _actionMap[531][RENAME] = ActionEntry(SHIFT, 381);
   _jumpMap[531][AlterOption] = 377;
   _jumpMap[531][AlterList] = 691;
   _actionMap[532][IDENTIFIER] = ActionEntry(SHIFT, 693);
   _actionMap[533][IDENTIFIER] = ActionEntry(SHIFT, 574);
   _jumpMap[533][ColumnDesc] = 694;
   _actionMap[534][KEY] = ActionEntry(SHIFT, 695);
   _actionMap[535][IDENTIFIER] = ActionEntry(SHIFT, 696);
   _actionMap[536][IDENTIFIER] = ActionEntry(SHIFT, 698);
   _jumpMap[536][ColumnDesc] = 697;
   _actionMap[537][IDENTIFIER] = ActionEntry(SHIFT, 699);
   _actionMap[538][FOR] = ActionEntry(SHIFT, 700);
   _actionMap[539][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[539][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[539][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[539][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[539][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[539][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[539][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[539][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[539][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[539][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[539][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[539][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[539][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[539][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[539][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[539][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[539][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[539][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[539][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[539][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[539][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[539][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[539][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[539][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[539][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[539][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[539][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[539][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[539][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[539][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[539][LDIV] = ActionEntry(SHIFT, 149);
}
void Cego::loadParser72()
{
   _actionMap[539][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[539][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[539][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[539][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[539][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[539][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[539][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[539][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[539][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[539][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[539][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[539][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[539][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[539][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[539][LB] = ActionEntry(SHIFT, 176);
   _actionMap[539][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[539][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[539][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[539][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[539][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[539][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[539][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[539][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[539][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[539][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[539][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[539][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[539][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[539][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[539][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[539][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[539][MAX] = ActionEntry(SHIFT, 154);
   _jumpMap[539][ObjSpec] = 121;
   _jumpMap[539][Constant] = 120;
   _jumpMap[539][SignedFloat] = 119;
   _jumpMap[539][SignedInt] = 118;
   _jumpMap[539][Attribute] = 117;
   _jumpMap[539][Function] = 116;
   _jumpMap[539][CasePrepare] = 115;
   _jumpMap[539][CaseClause] = 114;
   _jumpMap[539][Factor] = 113;
   _jumpMap[539][Term] = 112;
   _jumpMap[539][Expr] = 701;
   _actionMap[540][SEMICOLON] = ActionEntry(REDUCE, 99);
   _actionMap[541][ELSE] = ActionEntry(REDUCE, 118);
   _actionMap[541][ELSIF] = ActionEntry(REDUCE, 118);
   _actionMap[541][END_TOKEN] = ActionEntry(REDUCE, 118);
   _actionMap[541][EXCEPTION] = ActionEntry(SHIFT, 703);
   _jumpMap[541][ProcExceptionStmt] = 702;
   _actionMap[542][SEMICOLON] = ActionEntry(SHIFT, 704);
}
void Cego::loadParser73()
{
   _actionMap[543][END_TOKEN] = ActionEntry(SHIFT, 705);
   _actionMap[544][ELSE] = ActionEntry(SHIFT, 708);
   _actionMap[544][END_TOKEN] = ActionEntry(REDUCE, 157);
   _jumpMap[544][ProcElsePart] = 707;
   _jumpMap[544][ProcElseOpt] = 706;
   _actionMap[545][ELSIF] = ActionEntry(SHIFT, 546);
   _actionMap[545][END_TOKEN] = ActionEntry(REDUCE, 154);
   _actionMap[545][ELSE] = ActionEntry(REDUCE, 154);
   _jumpMap[545][ProcElsIfOpt] = 545;
   _jumpMap[545][ProcElsIfList] = 710;
   _actionMap[546][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[546][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[546][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[546][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[546][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[546][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[546][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[546][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[546][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[546][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[546][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[546][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[546][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[546][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[546][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[546][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[546][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[546][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[546][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[546][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[546][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[546][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[546][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[546][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[546][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[546][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[546][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[546][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[546][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[546][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[546][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[546][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[546][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[546][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[546][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[546][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[546][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[546][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[546][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[546][CLOB2STR] = ActionEntry(SHIFT, 135);
}
void Cego::loadParser74()
{
   _actionMap[546][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[546][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[546][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[546][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[546][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[546][LB] = ActionEntry(SHIFT, 554);
   _actionMap[546][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[546][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[546][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[546][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[546][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[546][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[546][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[546][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[546][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[546][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[546][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[546][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[546][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[546][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[546][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[546][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[546][MAX] = ActionEntry(SHIFT, 154);
   _jumpMap[546][ObjSpec] = 121;
   _jumpMap[546][Constant] = 120;
   _jumpMap[546][SignedFloat] = 119;
   _jumpMap[546][SignedInt] = 118;
   _jumpMap[546][Attribute] = 117;
   _jumpMap[546][Function] = 116;
   _jumpMap[546][CasePrepare] = 115;
   _jumpMap[546][CaseClause] = 114;
   _jumpMap[546][Factor] = 113;
   _jumpMap[546][Term] = 112;
   _jumpMap[546][Expr] = 553;
   _jumpMap[546][ProcPredicate] = 552;
   _jumpMap[546][ProcCondition] = 712;
   _jumpMap[546][ProcElsIfCondition] = 711;
   _actionMap[547][EXCEPTION] = ActionEntry(REDUCE, 120);
   _actionMap[547][END_TOKEN] = ActionEntry(REDUCE, 120);
   _actionMap[547][ELSE] = ActionEntry(REDUCE, 120);
   _actionMap[547][ELSIF] = ActionEntry(REDUCE, 120);
   _actionMap[547][VAR] = ActionEntry(REDUCE, 120);
   _actionMap[547][CURSOR] = ActionEntry(REDUCE, 120);
   _actionMap[547][CLOSE] = ActionEntry(REDUCE, 120);
   _actionMap[547][VARREF] = ActionEntry(REDUCE, 120);
   _actionMap[547][NOOP] = ActionEntry(REDUCE, 120);
   _actionMap[547][THROW] = ActionEntry(REDUCE, 120);
   _actionMap[547][RETURNTOKEN] = ActionEntry(REDUCE, 120);
   _actionMap[547][WHILE] = ActionEntry(REDUCE, 120);
   _actionMap[547][IF] = ActionEntry(REDUCE, 120);
}
void Cego::loadParser75()
{
   _actionMap[547][BEGIN] = ActionEntry(REDUCE, 120);
   _actionMap[547][UNLOCK] = ActionEntry(REDUCE, 120);
   _actionMap[547][LOCK] = ActionEntry(REDUCE, 120);
   _actionMap[547][ROLLBACK] = ActionEntry(REDUCE, 120);
   _actionMap[547][COMMIT] = ActionEntry(REDUCE, 120);
   _actionMap[547][START_TOKEN] = ActionEntry(REDUCE, 120);
   _actionMap[547][UPDATE] = ActionEntry(REDUCE, 120);
   _actionMap[547][DELETETOK] = ActionEntry(REDUCE, 120);
   _actionMap[547][INSERT] = ActionEntry(REDUCE, 120);
   _actionMap[547][FETCH] = ActionEntry(REDUCE, 120);
   _actionMap[547][LB] = ActionEntry(REDUCE, 120);
   _actionMap[547][COUNT] = ActionEntry(REDUCE, 120);
   _actionMap[547][SUM] = ActionEntry(REDUCE, 120);
   _actionMap[547][AVG] = ActionEntry(REDUCE, 120);
   _actionMap[547][MIN] = ActionEntry(REDUCE, 120);
   _actionMap[547][MAX] = ActionEntry(REDUCE, 120);
   _actionMap[547][CASE] = ActionEntry(REDUCE, 120);
   _actionMap[547][INT2ASC] = ActionEntry(REDUCE, 120);
   _actionMap[547][ASC2INT] = ActionEntry(REDUCE, 120);
   _actionMap[547][TRIM] = ActionEntry(REDUCE, 120);
   _actionMap[547][RTRIM] = ActionEntry(REDUCE, 120);
   _actionMap[547][LTRIM] = ActionEntry(REDUCE, 120);
   _actionMap[547][ROUND] = ActionEntry(REDUCE, 120);
   _actionMap[547][DATE2STR] = ActionEntry(REDUCE, 120);
   _actionMap[547][DATE2LONG] = ActionEntry(REDUCE, 120);
   _actionMap[547][LONG2DATE] = ActionEntry(REDUCE, 120);
   _actionMap[547][NEWDATE] = ActionEntry(REDUCE, 120);
   _actionMap[547][LOWER] = ActionEntry(REDUCE, 120);
   _actionMap[547][UPPER] = ActionEntry(REDUCE, 120);
   _actionMap[547][LEFT] = ActionEntry(REDUCE, 120);
   _actionMap[547][RIGHT] = ActionEntry(REDUCE, 120);
   _actionMap[547][GETPOS] = ActionEntry(REDUCE, 120);
   _actionMap[547][SUBSTR] = ActionEntry(REDUCE, 120);
   _actionMap[547][REPLACE] = ActionEntry(REDUCE, 120);
   _actionMap[547][LENGTH] = ActionEntry(REDUCE, 120);
   _actionMap[547][TRUNC] = ActionEntry(REDUCE, 120);
   _actionMap[547][STR2INT] = ActionEntry(REDUCE, 120);
   _actionMap[547][STR2LONG] = ActionEntry(REDUCE, 120);
   _actionMap[547][STR2DATE] = ActionEntry(REDUCE, 120);
   _actionMap[547][RANDSTR] = ActionEntry(REDUCE, 120);
   _actionMap[547][RANDINT] = ActionEntry(REDUCE, 120);
   _actionMap[547][MOD] = ActionEntry(REDUCE, 120);
   _actionMap[547][DIV] = ActionEntry(REDUCE, 120);
   _actionMap[547][LMOD] = ActionEntry(REDUCE, 120);
   _actionMap[547][LDIV] = ActionEntry(REDUCE, 120);
   _actionMap[547][POWER] = ActionEntry(REDUCE, 120);
   _actionMap[547][BITAND] = ActionEntry(REDUCE, 120);
   _actionMap[547][BITOR] = ActionEntry(REDUCE, 120);
   _actionMap[547][BITXOR] = ActionEntry(REDUCE, 120);
   _actionMap[547][BLOBSIZE] = ActionEntry(REDUCE, 120);
}
void Cego::loadParser76()
{
   _actionMap[547][BLOBREF] = ActionEntry(REDUCE, 120);
   _actionMap[547][CLOBSIZE] = ActionEntry(REDUCE, 120);
   _actionMap[547][CLOBREF] = ActionEntry(REDUCE, 120);
   _actionMap[547][CLOB2STR] = ActionEntry(REDUCE, 120);
   _actionMap[547][NEXTCOUNT] = ActionEntry(REDUCE, 120);
   _actionMap[547][SETCOUNT] = ActionEntry(REDUCE, 120);
   _actionMap[547][IDENTIFIER] = ActionEntry(REDUCE, 120);
   _actionMap[547][QUALIFIEDOBJ] = ActionEntry(REDUCE, 120);
   _actionMap[547][QUALIFIEDTS] = ActionEntry(REDUCE, 120);
   _actionMap[547][QUALIFIEDPRE] = ActionEntry(REDUCE, 120);
   _actionMap[547][STRINGVAL] = ActionEntry(REDUCE, 120);
   _actionMap[547][DATE] = ActionEntry(REDUCE, 120);
   _actionMap[547][SYSDATE] = ActionEntry(REDUCE, 120);
   _actionMap[547][NULLTOKEN] = ActionEntry(REDUCE, 120);
   _actionMap[547][TRUEVAL] = ActionEntry(REDUCE, 120);
   _actionMap[547][FALSEVAL] = ActionEntry(REDUCE, 120);
   _actionMap[547][BLOB] = ActionEntry(REDUCE, 120);
   _actionMap[547][CLOB] = ActionEntry(REDUCE, 120);
   _actionMap[547][FLOATVAL] = ActionEntry(REDUCE, 120);
   _actionMap[547][MINUS] = ActionEntry(REDUCE, 120);
   _actionMap[547][INTVAL] = ActionEntry(REDUCE, 120);
   _actionMap[548][SEMICOLON] = ActionEntry(REDUCE, 123);
   _actionMap[549][AS] = ActionEntry(SHIFT, 713);
   _actionMap[550][THEN] = ActionEntry(SHIFT, 714);
   _actionMap[551][OR] = ActionEntry(SHIFT, 716);
   _actionMap[551][AND] = ActionEntry(SHIFT, 715);
   _actionMap[551][THEN] = ActionEntry(REDUCE, 159);
   _actionMap[552][BEGIN] = ActionEntry(REDUCE, 165);
   _actionMap[552][RB] = ActionEntry(REDUCE, 165);
   _actionMap[552][AND] = ActionEntry(REDUCE, 165);
   _actionMap[552][OR] = ActionEntry(REDUCE, 165);
   _actionMap[552][THEN] = ActionEntry(REDUCE, 165);
   _actionMap[553][IS] = ActionEntry(SHIFT, 718);
   _actionMap[553][PLUS] = ActionEntry(SHIFT, 275);
   _actionMap[553][MINUS] = ActionEntry(SHIFT, 274);
   _actionMap[553][CONCAT] = ActionEntry(SHIFT, 273);
   _actionMap[553][EQU] = ActionEntry(SHIFT, 595);
   _actionMap[553][NEGATION] = ActionEntry(SHIFT, 598);
   _actionMap[553][LT] = ActionEntry(SHIFT, 596);
   _actionMap[553][MT] = ActionEntry(SHIFT, 597);
   _jumpMap[553][Comparison] = 717;
   _actionMap[554][LONG] = ActionEntry(SHIFT, 336);
   _actionMap[554][BIGINT] = ActionEntry(SHIFT, 332);
   _actionMap[554][SMALLINT] = ActionEntry(SHIFT, 337);
   _actionMap[554][TINYINT] = ActionEntry(SHIFT, 338);
   _actionMap[554][DOUBLE] = ActionEntry(SHIFT, 334);
   _actionMap[554][DECIMAL] = ActionEntry(SHIFT, 333);
   _actionMap[554][FIXED] = ActionEntry(SHIFT, 335);
   _actionMap[554][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[554][MINUS] = ActionEntry(SHIFT, 177);
}
void Cego::loadParser77()
{
   _actionMap[554][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[554][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[554][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[554][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[554][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[554][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[554][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[554][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[554][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[554][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[554][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[554][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[554][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[554][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[554][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[554][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[554][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[554][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[554][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[554][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[554][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[554][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[554][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[554][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[554][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[554][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[554][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[554][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[554][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[554][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[554][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[554][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[554][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[554][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[554][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[554][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[554][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[554][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[554][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[554][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[554][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[554][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[554][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[554][LB] = ActionEntry(SHIFT, 554);
   _actionMap[554][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[554][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[554][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[554][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[554][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[554][FALSEVAL] = ActionEntry(SHIFT, 141);
}
void Cego::loadParser78()
{
   _actionMap[554][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[554][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[554][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[554][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[554][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[554][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[554][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[554][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[554][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[554][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[554][MAX] = ActionEntry(SHIFT, 154);
   _actionMap[554][SELECT] = ActionEntry(SHIFT, 34);
   _jumpMap[554][ObjSpec] = 121;
   _jumpMap[554][Constant] = 120;
   _jumpMap[554][SignedFloat] = 119;
   _jumpMap[554][SignedInt] = 118;
   _jumpMap[554][Attribute] = 117;
   _jumpMap[554][Function] = 116;
   _jumpMap[554][SelectStatement] = 331;
   _jumpMap[554][CasePrepare] = 115;
   _jumpMap[554][CaseClause] = 114;
   _jumpMap[554][Factor] = 113;
   _jumpMap[554][Term] = 112;
   _jumpMap[554][Expr] = 720;
   _jumpMap[554][ProcPredicate] = 552;
   _jumpMap[554][ProcCondition] = 719;
   _actionMap[555][PLUS] = ActionEntry(SHIFT, 275);
   _actionMap[555][MINUS] = ActionEntry(SHIFT, 274);
   _actionMap[555][CONCAT] = ActionEntry(SHIFT, 273);
   _actionMap[555][SEMICOLON] = ActionEntry(REDUCE, 140);
   _actionMap[556][PLUS] = ActionEntry(SHIFT, 275);
   _actionMap[556][MINUS] = ActionEntry(SHIFT, 274);
   _actionMap[556][CONCAT] = ActionEntry(SHIFT, 273);
   _actionMap[556][SEMICOLON] = ActionEntry(REDUCE, 130);
   _actionMap[557][INT] = ActionEntry(SHIFT, 731);
   _actionMap[557][LONG] = ActionEntry(SHIFT, 732);
   _actionMap[557][STRING] = ActionEntry(SHIFT, 734);
   _actionMap[557][DATETIME] = ActionEntry(SHIFT, 726);
   _actionMap[557][BOOL] = ActionEntry(SHIFT, 724);
   _actionMap[557][BIGINT] = ActionEntry(SHIFT, 722);
   _actionMap[557][FLOAT] = ActionEntry(SHIFT, 730);
   _actionMap[557][DOUBLE] = ActionEntry(SHIFT, 728);
   _actionMap[557][SMALLINT] = ActionEntry(SHIFT, 733);
   _actionMap[557][TINYINT] = ActionEntry(SHIFT, 735);
   _actionMap[557][DECIMAL] = ActionEntry(SHIFT, 727);
   _actionMap[557][FIXED] = ActionEntry(SHIFT, 729);
   _actionMap[557][BLOB] = ActionEntry(SHIFT, 723);
   _actionMap[557][CLOB] = ActionEntry(SHIFT, 725);
   _jumpMap[557][DataTypeProd] = 721;
   _actionMap[558][BEGIN] = ActionEntry(SHIFT, 736);
}
void Cego::loadParser79()
{
   _actionMap[559][OR] = ActionEntry(SHIFT, 716);
   _actionMap[559][AND] = ActionEntry(SHIFT, 715);
   _actionMap[559][BEGIN] = ActionEntry(REDUCE, 162);
   _actionMap[560][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[560][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[560][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[560][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[560][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[560][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[560][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[560][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[560][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[560][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[560][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[560][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[560][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[560][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[560][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[560][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[560][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[560][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[560][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[560][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[560][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[560][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[560][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[560][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[560][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[560][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[560][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[560][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[560][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[560][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[560][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[560][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[560][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[560][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[560][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[560][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[560][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[560][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[560][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[560][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[560][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[560][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[560][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[560][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[560][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[560][LB] = ActionEntry(SHIFT, 176);
   _actionMap[560][STRINGVAL] = ActionEntry(SHIFT, 122);
}
void Cego::loadParser80()
{
   _actionMap[560][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[560][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[560][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[560][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[560][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[560][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[560][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[560][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[560][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[560][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[560][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[560][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[560][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[560][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[560][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[560][MAX] = ActionEntry(SHIFT, 154);
   _jumpMap[560][ObjSpec] = 121;
   _jumpMap[560][Constant] = 120;
   _jumpMap[560][SignedFloat] = 119;
   _jumpMap[560][SignedInt] = 118;
   _jumpMap[560][Attribute] = 117;
   _jumpMap[560][Function] = 116;
   _jumpMap[560][CasePrepare] = 115;
   _jumpMap[560][CaseClause] = 114;
   _jumpMap[560][Factor] = 113;
   _jumpMap[560][Term] = 112;
   _jumpMap[560][Expr] = 737;
   _actionMap[561][SEMICOLON] = ActionEntry(REDUCE, 109);
   _actionMap[562][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[562][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[562][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[562][ObjSpec] = 738;
   _actionMap[563][LB] = ActionEntry(SHIFT, 739);
   _actionMap[564][LB] = ActionEntry(SHIFT, 740);
   _actionMap[565][RB] = ActionEntry(SHIFT, 568);
   _actionMap[566][KSEP] = ActionEntry(SHIFT, 741);
   _actionMap[566][RB] = ActionEntry(REDUCE, 112);
   _actionMap[567][KSEP] = ActionEntry(REDUCE, 115);
   _actionMap[567][RB] = ActionEntry(REDUCE, 115);
   _actionMap[568][RETURNTOKEN] = ActionEntry(SHIFT, 743);
   _actionMap[568][BEGIN] = ActionEntry(REDUCE, 111);
   _jumpMap[568][ReturnOpt] = 742;
   _actionMap[569][INTOK] = ActionEntry(SHIFT, 744);
   _actionMap[569][OUTTOK] = ActionEntry(SHIFT, 745);
   _actionMap[570][RB] = ActionEntry(SHIFT, 747);
   _actionMap[570][KSEP] = ActionEntry(SHIFT, 746);
   _actionMap[571][KSEP] = ActionEntry(REDUCE, 199);
   _actionMap[571][RB] = ActionEntry(REDUCE, 199);
   _actionMap[572][KSEP] = ActionEntry(REDUCE, 201);
   _actionMap[572][RB] = ActionEntry(REDUCE, 201);
}
void Cego::loadParser81()
{
   _actionMap[573][IDENTIFIER] = ActionEntry(SHIFT, 574);
   _jumpMap[573][ColumnDesc] = 748;
   _actionMap[574][INT] = ActionEntry(SHIFT, 731);
   _actionMap[574][LONG] = ActionEntry(SHIFT, 732);
   _actionMap[574][STRING] = ActionEntry(SHIFT, 734);
   _actionMap[574][DATETIME] = ActionEntry(SHIFT, 726);
   _actionMap[574][BOOL] = ActionEntry(SHIFT, 724);
   _actionMap[574][BIGINT] = ActionEntry(SHIFT, 722);
   _actionMap[574][FLOAT] = ActionEntry(SHIFT, 730);
   _actionMap[574][DOUBLE] = ActionEntry(SHIFT, 728);
   _actionMap[574][SMALLINT] = ActionEntry(SHIFT, 733);
   _actionMap[574][TINYINT] = ActionEntry(SHIFT, 735);
   _actionMap[574][DECIMAL] = ActionEntry(SHIFT, 727);
   _actionMap[574][FIXED] = ActionEntry(SHIFT, 729);
   _actionMap[574][BLOB] = ActionEntry(SHIFT, 723);
   _actionMap[574][CLOB] = ActionEntry(SHIFT, 725);
   _jumpMap[574][DataTypeProd] = 749;
   _actionMap[575][ON] = ActionEntry(SHIFT, 750);
   _actionMap[575][OR] = ActionEntry(SHIFT, 751);
   _actionMap[576][OR] = ActionEntry(REDUCE, 104);
   _actionMap[576][ON] = ActionEntry(REDUCE, 104);
   _actionMap[577][OR] = ActionEntry(REDUCE, 107);
   _actionMap[577][ON] = ActionEntry(REDUCE, 107);
   _actionMap[578][OR] = ActionEntry(REDUCE, 105);
   _actionMap[578][ON] = ActionEntry(REDUCE, 105);
   _actionMap[579][OR] = ActionEntry(REDUCE, 106);
   _actionMap[579][ON] = ActionEntry(REDUCE, 106);
   _actionMap[580][SEMICOLON] = ActionEntry(REDUCE, 56);
   _actionMap[581][AND] = ActionEntry(SHIFT, 599);
   _actionMap[581][OR] = ActionEntry(SHIFT, 600);
   _actionMap[581][RETURNTOKEN] = ActionEntry(REDUCE, 360);
   _actionMap[581][GROUP] = ActionEntry(REDUCE, 360);
   _actionMap[581][ORDER] = ActionEntry(REDUCE, 360);
   _actionMap[581][ROWLIMIT] = ActionEntry(REDUCE, 360);
   _actionMap[581][UNION] = ActionEntry(REDUCE, 360);
   _actionMap[581][ENDTOKEN] = ActionEntry(REDUCE, 360);
   _actionMap[581][RB] = ActionEntry(REDUCE, 360);
   _actionMap[581][SEMICOLON] = ActionEntry(REDUCE, 360);
   _actionMap[582][KSEP] = ActionEntry(SHIFT, 752);
   _actionMap[582][SEMICOLON] = ActionEntry(REDUCE, 224);
   _actionMap[583][SEMICOLON] = ActionEntry(REDUCE, 230);
   _actionMap[583][KSEP] = ActionEntry(REDUCE, 230);
   _actionMap[584][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[584][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[584][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[584][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[584][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[584][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[584][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[584][LTRIM] = ActionEntry(SHIFT, 152);
}
void Cego::loadParser82()
{
   _actionMap[584][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[584][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[584][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[584][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[584][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[584][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[584][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[584][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[584][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[584][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[584][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[584][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[584][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[584][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[584][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[584][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[584][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[584][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[584][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[584][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[584][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[584][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[584][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[584][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[584][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[584][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[584][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[584][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[584][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[584][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[584][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[584][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[584][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[584][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[584][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[584][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[584][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[584][LB] = ActionEntry(SHIFT, 176);
   _actionMap[584][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[584][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[584][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[584][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[584][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[584][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[584][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[584][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[584][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[584][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[584][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[584][FETCH] = ActionEntry(SHIFT, 142);
}
void Cego::loadParser83()
{
   _actionMap[584][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[584][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[584][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[584][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[584][MAX] = ActionEntry(SHIFT, 154);
   _jumpMap[584][ObjSpec] = 121;
   _jumpMap[584][Constant] = 120;
   _jumpMap[584][SignedFloat] = 119;
   _jumpMap[584][SignedInt] = 118;
   _jumpMap[584][Attribute] = 117;
   _jumpMap[584][Function] = 116;
   _jumpMap[584][InsertValueList] = 754;
   _jumpMap[584][CasePrepare] = 115;
   _jumpMap[584][CaseClause] = 114;
   _jumpMap[584][Factor] = 113;
   _jumpMap[584][Term] = 112;
   _jumpMap[584][Expr] = 753;
   _actionMap[585][RB] = ActionEntry(SHIFT, 756);
   _actionMap[585][KSEP] = ActionEntry(SHIFT, 755);
   _actionMap[586][KSEP] = ActionEntry(REDUCE, 233);
   _actionMap[586][RB] = ActionEntry(REDUCE, 233);
   _actionMap[587][SEMICOLON] = ActionEntry(REDUCE, 57);
   _actionMap[588][END_TOKEN] = ActionEntry(SHIFT, 757);
   _actionMap[588][PLUS] = ActionEntry(SHIFT, 275);
   _actionMap[588][MINUS] = ActionEntry(SHIFT, 274);
   _actionMap[588][CONCAT] = ActionEntry(SHIFT, 273);
   _actionMap[589][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[589][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[589][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[589][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[589][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[589][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[589][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[589][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[589][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[589][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[589][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[589][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[589][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[589][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[589][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[589][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[589][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[589][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[589][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[589][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[589][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[589][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[589][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[589][STR2LONG] = ActionEntry(SHIFT, 170);
}
void Cego::loadParser84()
{
   _actionMap[589][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[589][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[589][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[589][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[589][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[589][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[589][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[589][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[589][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[589][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[589][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[589][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[589][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[589][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[589][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[589][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[589][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[589][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[589][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[589][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[589][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[589][LB] = ActionEntry(SHIFT, 176);
   _actionMap[589][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[589][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[589][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[589][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[589][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[589][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[589][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[589][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[589][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[589][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[589][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[589][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[589][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[589][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[589][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[589][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[589][MAX] = ActionEntry(SHIFT, 154);
   _jumpMap[589][ObjSpec] = 121;
   _jumpMap[589][Constant] = 120;
   _jumpMap[589][SignedFloat] = 119;
   _jumpMap[589][SignedInt] = 118;
   _jumpMap[589][Attribute] = 117;
   _jumpMap[589][Function] = 116;
   _jumpMap[589][CasePrepare] = 115;
   _jumpMap[589][CaseClause] = 114;
   _jumpMap[589][Factor] = 113;
   _jumpMap[589][Term] = 112;
   _jumpMap[589][Expr] = 758;
}
void Cego::loadParser85()
{
   _actionMap[590][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[590][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[590][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[590][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[590][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[590][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[590][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[590][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[590][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[590][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[590][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[590][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[590][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[590][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[590][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[590][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[590][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[590][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[590][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[590][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[590][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[590][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[590][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[590][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[590][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[590][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[590][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[590][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[590][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[590][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[590][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[590][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[590][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[590][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[590][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[590][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[590][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[590][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[590][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[590][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[590][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[590][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[590][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[590][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[590][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[590][LB] = ActionEntry(SHIFT, 176);
   _actionMap[590][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[590][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[590][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[590][NULLTOKEN] = ActionEntry(SHIFT, 157);
}
void Cego::loadParser86()
{
   _actionMap[590][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[590][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[590][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[590][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[590][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[590][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[590][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[590][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[590][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[590][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[590][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[590][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[590][MAX] = ActionEntry(SHIFT, 154);
   _jumpMap[590][ObjSpec] = 121;
   _jumpMap[590][Constant] = 120;
   _jumpMap[590][SignedFloat] = 119;
   _jumpMap[590][SignedInt] = 118;
   _jumpMap[590][Attribute] = 117;
   _jumpMap[590][Function] = 116;
   _jumpMap[590][CasePrepare] = 115;
   _jumpMap[590][CaseClause] = 114;
   _jumpMap[590][Factor] = 113;
   _jumpMap[590][Term] = 112;
   _jumpMap[590][Expr] = 759;
   _actionMap[591][LB] = ActionEntry(SHIFT, 760);
   _actionMap[592][NOT] = ActionEntry(SHIFT, 761);
   _actionMap[592][NULLTOKEN] = ActionEntry(SHIFT, 762);
   _actionMap[593][STRINGVAL] = ActionEntry(SHIFT, 763);
   _actionMap[594][LIKE] = ActionEntry(SHIFT, 765);
   _actionMap[594][INTOK] = ActionEntry(SHIFT, 764);
   _actionMap[595][VARREF] = ActionEntry(REDUCE, 395);
   _actionMap[595][FETCH] = ActionEntry(REDUCE, 395);
   _actionMap[595][LB] = ActionEntry(REDUCE, 395);
   _actionMap[595][COUNT] = ActionEntry(REDUCE, 395);
   _actionMap[595][SUM] = ActionEntry(REDUCE, 395);
   _actionMap[595][AVG] = ActionEntry(REDUCE, 395);
   _actionMap[595][MIN] = ActionEntry(REDUCE, 395);
   _actionMap[595][MAX] = ActionEntry(REDUCE, 395);
   _actionMap[595][CASE] = ActionEntry(REDUCE, 395);
   _actionMap[595][INT2ASC] = ActionEntry(REDUCE, 395);
   _actionMap[595][ASC2INT] = ActionEntry(REDUCE, 395);
   _actionMap[595][TRIM] = ActionEntry(REDUCE, 395);
   _actionMap[595][RTRIM] = ActionEntry(REDUCE, 395);
   _actionMap[595][LTRIM] = ActionEntry(REDUCE, 395);
   _actionMap[595][ROUND] = ActionEntry(REDUCE, 395);
   _actionMap[595][DATE2STR] = ActionEntry(REDUCE, 395);
   _actionMap[595][DATE2LONG] = ActionEntry(REDUCE, 395);
   _actionMap[595][LONG2DATE] = ActionEntry(REDUCE, 395);
   _actionMap[595][NEWDATE] = ActionEntry(REDUCE, 395);
   _actionMap[595][LOWER] = ActionEntry(REDUCE, 395);
}
void Cego::loadParser87()
{
   _actionMap[595][UPPER] = ActionEntry(REDUCE, 395);
   _actionMap[595][LEFT] = ActionEntry(REDUCE, 395);
   _actionMap[595][RIGHT] = ActionEntry(REDUCE, 395);
   _actionMap[595][GETPOS] = ActionEntry(REDUCE, 395);
   _actionMap[595][SUBSTR] = ActionEntry(REDUCE, 395);
   _actionMap[595][REPLACE] = ActionEntry(REDUCE, 395);
   _actionMap[595][LENGTH] = ActionEntry(REDUCE, 395);
   _actionMap[595][TRUNC] = ActionEntry(REDUCE, 395);
   _actionMap[595][STR2INT] = ActionEntry(REDUCE, 395);
   _actionMap[595][STR2LONG] = ActionEntry(REDUCE, 395);
   _actionMap[595][STR2DATE] = ActionEntry(REDUCE, 395);
   _actionMap[595][RANDSTR] = ActionEntry(REDUCE, 395);
   _actionMap[595][RANDINT] = ActionEntry(REDUCE, 395);
   _actionMap[595][MOD] = ActionEntry(REDUCE, 395);
   _actionMap[595][DIV] = ActionEntry(REDUCE, 395);
   _actionMap[595][LMOD] = ActionEntry(REDUCE, 395);
   _actionMap[595][LDIV] = ActionEntry(REDUCE, 395);
   _actionMap[595][POWER] = ActionEntry(REDUCE, 395);
   _actionMap[595][BITAND] = ActionEntry(REDUCE, 395);
   _actionMap[595][BITOR] = ActionEntry(REDUCE, 395);
   _actionMap[595][BITXOR] = ActionEntry(REDUCE, 395);
   _actionMap[595][BLOBSIZE] = ActionEntry(REDUCE, 395);
   _actionMap[595][BLOBREF] = ActionEntry(REDUCE, 395);
   _actionMap[595][CLOBSIZE] = ActionEntry(REDUCE, 395);
   _actionMap[595][CLOBREF] = ActionEntry(REDUCE, 395);
   _actionMap[595][CLOB2STR] = ActionEntry(REDUCE, 395);
   _actionMap[595][NEXTCOUNT] = ActionEntry(REDUCE, 395);
   _actionMap[595][SETCOUNT] = ActionEntry(REDUCE, 395);
   _actionMap[595][IDENTIFIER] = ActionEntry(REDUCE, 395);
   _actionMap[595][QUALIFIEDOBJ] = ActionEntry(REDUCE, 395);
   _actionMap[595][QUALIFIEDTS] = ActionEntry(REDUCE, 395);
   _actionMap[595][QUALIFIEDPRE] = ActionEntry(REDUCE, 395);
   _actionMap[595][STRINGVAL] = ActionEntry(REDUCE, 395);
   _actionMap[595][DATE] = ActionEntry(REDUCE, 395);
   _actionMap[595][SYSDATE] = ActionEntry(REDUCE, 395);
   _actionMap[595][NULLTOKEN] = ActionEntry(REDUCE, 395);
   _actionMap[595][TRUEVAL] = ActionEntry(REDUCE, 395);
   _actionMap[595][FALSEVAL] = ActionEntry(REDUCE, 395);
   _actionMap[595][BLOB] = ActionEntry(REDUCE, 395);
   _actionMap[595][CLOB] = ActionEntry(REDUCE, 395);
   _actionMap[595][FLOATVAL] = ActionEntry(REDUCE, 395);
   _actionMap[595][MINUS] = ActionEntry(REDUCE, 395);
   _actionMap[595][INTVAL] = ActionEntry(REDUCE, 395);
   _actionMap[596][VARREF] = ActionEntry(REDUCE, 397);
   _actionMap[596][FETCH] = ActionEntry(REDUCE, 397);
   _actionMap[596][LB] = ActionEntry(REDUCE, 397);
   _actionMap[596][COUNT] = ActionEntry(REDUCE, 397);
   _actionMap[596][SUM] = ActionEntry(REDUCE, 397);
   _actionMap[596][AVG] = ActionEntry(REDUCE, 397);
   _actionMap[596][MIN] = ActionEntry(REDUCE, 397);
}
void Cego::loadParser88()
{
   _actionMap[596][MAX] = ActionEntry(REDUCE, 397);
   _actionMap[596][CASE] = ActionEntry(REDUCE, 397);
   _actionMap[596][INT2ASC] = ActionEntry(REDUCE, 397);
   _actionMap[596][ASC2INT] = ActionEntry(REDUCE, 397);
   _actionMap[596][TRIM] = ActionEntry(REDUCE, 397);
   _actionMap[596][RTRIM] = ActionEntry(REDUCE, 397);
   _actionMap[596][LTRIM] = ActionEntry(REDUCE, 397);
   _actionMap[596][ROUND] = ActionEntry(REDUCE, 397);
   _actionMap[596][DATE2STR] = ActionEntry(REDUCE, 397);
   _actionMap[596][DATE2LONG] = ActionEntry(REDUCE, 397);
   _actionMap[596][LONG2DATE] = ActionEntry(REDUCE, 397);
   _actionMap[596][NEWDATE] = ActionEntry(REDUCE, 397);
   _actionMap[596][LOWER] = ActionEntry(REDUCE, 397);
   _actionMap[596][UPPER] = ActionEntry(REDUCE, 397);
   _actionMap[596][LEFT] = ActionEntry(REDUCE, 397);
   _actionMap[596][RIGHT] = ActionEntry(REDUCE, 397);
   _actionMap[596][GETPOS] = ActionEntry(REDUCE, 397);
   _actionMap[596][SUBSTR] = ActionEntry(REDUCE, 397);
   _actionMap[596][REPLACE] = ActionEntry(REDUCE, 397);
   _actionMap[596][LENGTH] = ActionEntry(REDUCE, 397);
   _actionMap[596][TRUNC] = ActionEntry(REDUCE, 397);
   _actionMap[596][STR2INT] = ActionEntry(REDUCE, 397);
   _actionMap[596][STR2LONG] = ActionEntry(REDUCE, 397);
   _actionMap[596][STR2DATE] = ActionEntry(REDUCE, 397);
   _actionMap[596][RANDSTR] = ActionEntry(REDUCE, 397);
   _actionMap[596][RANDINT] = ActionEntry(REDUCE, 397);
   _actionMap[596][MOD] = ActionEntry(REDUCE, 397);
   _actionMap[596][DIV] = ActionEntry(REDUCE, 397);
   _actionMap[596][LMOD] = ActionEntry(REDUCE, 397);
   _actionMap[596][LDIV] = ActionEntry(REDUCE, 397);
   _actionMap[596][POWER] = ActionEntry(REDUCE, 397);
   _actionMap[596][BITAND] = ActionEntry(REDUCE, 397);
   _actionMap[596][BITOR] = ActionEntry(REDUCE, 397);
   _actionMap[596][BITXOR] = ActionEntry(REDUCE, 397);
   _actionMap[596][BLOBSIZE] = ActionEntry(REDUCE, 397);
   _actionMap[596][BLOBREF] = ActionEntry(REDUCE, 397);
   _actionMap[596][CLOBSIZE] = ActionEntry(REDUCE, 397);
   _actionMap[596][CLOBREF] = ActionEntry(REDUCE, 397);
   _actionMap[596][CLOB2STR] = ActionEntry(REDUCE, 397);
   _actionMap[596][NEXTCOUNT] = ActionEntry(REDUCE, 397);
   _actionMap[596][SETCOUNT] = ActionEntry(REDUCE, 397);
   _actionMap[596][IDENTIFIER] = ActionEntry(REDUCE, 397);
   _actionMap[596][QUALIFIEDOBJ] = ActionEntry(REDUCE, 397);
   _actionMap[596][QUALIFIEDTS] = ActionEntry(REDUCE, 397);
   _actionMap[596][QUALIFIEDPRE] = ActionEntry(REDUCE, 397);
   _actionMap[596][STRINGVAL] = ActionEntry(REDUCE, 397);
   _actionMap[596][DATE] = ActionEntry(REDUCE, 397);
   _actionMap[596][SYSDATE] = ActionEntry(REDUCE, 397);
   _actionMap[596][NULLTOKEN] = ActionEntry(REDUCE, 397);
   _actionMap[596][TRUEVAL] = ActionEntry(REDUCE, 397);
}
void Cego::loadParser89()
{
   _actionMap[596][FALSEVAL] = ActionEntry(REDUCE, 397);
   _actionMap[596][BLOB] = ActionEntry(REDUCE, 397);
   _actionMap[596][CLOB] = ActionEntry(REDUCE, 397);
   _actionMap[596][FLOATVAL] = ActionEntry(REDUCE, 397);
   _actionMap[596][MINUS] = ActionEntry(REDUCE, 397);
   _actionMap[596][INTVAL] = ActionEntry(REDUCE, 397);
   _actionMap[596][EQU] = ActionEntry(SHIFT, 766);
   _actionMap[597][VARREF] = ActionEntry(REDUCE, 398);
   _actionMap[597][FETCH] = ActionEntry(REDUCE, 398);
   _actionMap[597][LB] = ActionEntry(REDUCE, 398);
   _actionMap[597][COUNT] = ActionEntry(REDUCE, 398);
   _actionMap[597][SUM] = ActionEntry(REDUCE, 398);
   _actionMap[597][AVG] = ActionEntry(REDUCE, 398);
   _actionMap[597][MIN] = ActionEntry(REDUCE, 398);
   _actionMap[597][MAX] = ActionEntry(REDUCE, 398);
   _actionMap[597][CASE] = ActionEntry(REDUCE, 398);
   _actionMap[597][INT2ASC] = ActionEntry(REDUCE, 398);
   _actionMap[597][ASC2INT] = ActionEntry(REDUCE, 398);
   _actionMap[597][TRIM] = ActionEntry(REDUCE, 398);
   _actionMap[597][RTRIM] = ActionEntry(REDUCE, 398);
   _actionMap[597][LTRIM] = ActionEntry(REDUCE, 398);
   _actionMap[597][ROUND] = ActionEntry(REDUCE, 398);
   _actionMap[597][DATE2STR] = ActionEntry(REDUCE, 398);
   _actionMap[597][DATE2LONG] = ActionEntry(REDUCE, 398);
   _actionMap[597][LONG2DATE] = ActionEntry(REDUCE, 398);
   _actionMap[597][NEWDATE] = ActionEntry(REDUCE, 398);
   _actionMap[597][LOWER] = ActionEntry(REDUCE, 398);
   _actionMap[597][UPPER] = ActionEntry(REDUCE, 398);
   _actionMap[597][LEFT] = ActionEntry(REDUCE, 398);
   _actionMap[597][RIGHT] = ActionEntry(REDUCE, 398);
   _actionMap[597][GETPOS] = ActionEntry(REDUCE, 398);
   _actionMap[597][SUBSTR] = ActionEntry(REDUCE, 398);
   _actionMap[597][REPLACE] = ActionEntry(REDUCE, 398);
   _actionMap[597][LENGTH] = ActionEntry(REDUCE, 398);
   _actionMap[597][TRUNC] = ActionEntry(REDUCE, 398);
   _actionMap[597][STR2INT] = ActionEntry(REDUCE, 398);
   _actionMap[597][STR2LONG] = ActionEntry(REDUCE, 398);
   _actionMap[597][STR2DATE] = ActionEntry(REDUCE, 398);
   _actionMap[597][RANDSTR] = ActionEntry(REDUCE, 398);
   _actionMap[597][RANDINT] = ActionEntry(REDUCE, 398);
   _actionMap[597][MOD] = ActionEntry(REDUCE, 398);
   _actionMap[597][DIV] = ActionEntry(REDUCE, 398);
   _actionMap[597][LMOD] = ActionEntry(REDUCE, 398);
   _actionMap[597][LDIV] = ActionEntry(REDUCE, 398);
   _actionMap[597][POWER] = ActionEntry(REDUCE, 398);
   _actionMap[597][BITAND] = ActionEntry(REDUCE, 398);
   _actionMap[597][BITOR] = ActionEntry(REDUCE, 398);
   _actionMap[597][BITXOR] = ActionEntry(REDUCE, 398);
   _actionMap[597][BLOBSIZE] = ActionEntry(REDUCE, 398);
   _actionMap[597][BLOBREF] = ActionEntry(REDUCE, 398);
}
void Cego::loadParser90()
{
   _actionMap[597][CLOBSIZE] = ActionEntry(REDUCE, 398);
   _actionMap[597][CLOBREF] = ActionEntry(REDUCE, 398);
   _actionMap[597][CLOB2STR] = ActionEntry(REDUCE, 398);
   _actionMap[597][NEXTCOUNT] = ActionEntry(REDUCE, 398);
   _actionMap[597][SETCOUNT] = ActionEntry(REDUCE, 398);
   _actionMap[597][IDENTIFIER] = ActionEntry(REDUCE, 398);
   _actionMap[597][QUALIFIEDOBJ] = ActionEntry(REDUCE, 398);
   _actionMap[597][QUALIFIEDTS] = ActionEntry(REDUCE, 398);
   _actionMap[597][QUALIFIEDPRE] = ActionEntry(REDUCE, 398);
   _actionMap[597][STRINGVAL] = ActionEntry(REDUCE, 398);
   _actionMap[597][DATE] = ActionEntry(REDUCE, 398);
   _actionMap[597][SYSDATE] = ActionEntry(REDUCE, 398);
   _actionMap[597][NULLTOKEN] = ActionEntry(REDUCE, 398);
   _actionMap[597][TRUEVAL] = ActionEntry(REDUCE, 398);
   _actionMap[597][FALSEVAL] = ActionEntry(REDUCE, 398);
   _actionMap[597][BLOB] = ActionEntry(REDUCE, 398);
   _actionMap[597][CLOB] = ActionEntry(REDUCE, 398);
   _actionMap[597][FLOATVAL] = ActionEntry(REDUCE, 398);
   _actionMap[597][MINUS] = ActionEntry(REDUCE, 398);
   _actionMap[597][INTVAL] = ActionEntry(REDUCE, 398);
   _actionMap[597][EQU] = ActionEntry(SHIFT, 767);
   _actionMap[598][EQU] = ActionEntry(SHIFT, 768);
   _actionMap[599][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[599][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[599][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[599][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[599][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[599][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[599][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[599][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[599][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[599][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[599][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[599][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[599][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[599][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[599][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[599][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[599][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[599][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[599][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[599][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[599][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[599][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[599][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[599][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[599][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[599][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[599][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[599][MOD] = ActionEntry(SHIFT, 155);
}
void Cego::loadParser91()
{
   _actionMap[599][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[599][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[599][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[599][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[599][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[599][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[599][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[599][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[599][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[599][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[599][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[599][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[599][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[599][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[599][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[599][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[599][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[599][LB] = ActionEntry(SHIFT, 445);
   _actionMap[599][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[599][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[599][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[599][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[599][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[599][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[599][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[599][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[599][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[599][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[599][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[599][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[599][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[599][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[599][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[599][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[599][MAX] = ActionEntry(SHIFT, 154);
   _actionMap[599][EXISTS] = ActionEntry(SHIFT, 443);
   _actionMap[599][NOT] = ActionEntry(SHIFT, 444);
   _jumpMap[599][ObjSpec] = 121;
   _jumpMap[599][Constant] = 120;
   _jumpMap[599][SignedFloat] = 119;
   _jumpMap[599][SignedInt] = 118;
   _jumpMap[599][Attribute] = 117;
   _jumpMap[599][QueryPredicate] = 769;
   _jumpMap[599][Function] = 116;
   _jumpMap[599][CasePrepare] = 115;
   _jumpMap[599][CaseClause] = 114;
   _jumpMap[599][Factor] = 113;
   _jumpMap[599][Term] = 112;
   _jumpMap[599][Expr] = 440;
   _actionMap[600][FLOATVAL] = ActionEntry(SHIFT, 179);
}
void Cego::loadParser92()
{
   _actionMap[600][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[600][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[600][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[600][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[600][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[600][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[600][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[600][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[600][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[600][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[600][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[600][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[600][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[600][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[600][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[600][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[600][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[600][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[600][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[600][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[600][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[600][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[600][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[600][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[600][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[600][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[600][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[600][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[600][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[600][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[600][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[600][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[600][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[600][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[600][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[600][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[600][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[600][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[600][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[600][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[600][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[600][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[600][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[600][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[600][LB] = ActionEntry(SHIFT, 445);
   _actionMap[600][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[600][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[600][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[600][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[600][TRUEVAL] = ActionEntry(SHIFT, 173);
}
void Cego::loadParser93()
{
   _actionMap[600][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[600][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[600][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[600][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[600][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[600][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[600][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[600][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[600][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[600][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[600][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[600][MAX] = ActionEntry(SHIFT, 154);
   _actionMap[600][EXISTS] = ActionEntry(SHIFT, 443);
   _actionMap[600][NOT] = ActionEntry(SHIFT, 444);
   _jumpMap[600][ObjSpec] = 121;
   _jumpMap[600][Constant] = 120;
   _jumpMap[600][SignedFloat] = 119;
   _jumpMap[600][SignedInt] = 118;
   _jumpMap[600][Attribute] = 117;
   _jumpMap[600][QueryPredicate] = 770;
   _jumpMap[600][Function] = 116;
   _jumpMap[600][CasePrepare] = 115;
   _jumpMap[600][CaseClause] = 114;
   _jumpMap[600][Factor] = 113;
   _jumpMap[600][Term] = 112;
   _jumpMap[600][Expr] = 440;
   _actionMap[601][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[601][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[601][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[601][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[601][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[601][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[601][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[601][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[601][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[601][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[601][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[601][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[601][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[601][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[601][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[601][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[601][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[601][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[601][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[601][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[601][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[601][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[601][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[601][STR2LONG] = ActionEntry(SHIFT, 170);
}
void Cego::loadParser94()
{
   _actionMap[601][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[601][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[601][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[601][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[601][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[601][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[601][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[601][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[601][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[601][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[601][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[601][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[601][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[601][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[601][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[601][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[601][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[601][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[601][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[601][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[601][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[601][LB] = ActionEntry(SHIFT, 176);
   _actionMap[601][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[601][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[601][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[601][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[601][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[601][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[601][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[601][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[601][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[601][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[601][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[601][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[601][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[601][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[601][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[601][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[601][MAX] = ActionEntry(SHIFT, 154);
   _jumpMap[601][ObjSpec] = 121;
   _jumpMap[601][Constant] = 120;
   _jumpMap[601][SignedFloat] = 119;
   _jumpMap[601][SignedInt] = 118;
   _jumpMap[601][Attribute] = 117;
   _jumpMap[601][Function] = 116;
   _jumpMap[601][CasePrepare] = 115;
   _jumpMap[601][CaseClause] = 114;
   _jumpMap[601][Factor] = 113;
   _jumpMap[601][Term] = 112;
   _jumpMap[601][Expr] = 771;
}
void Cego::loadParser95()
{
   _actionMap[602][SELECT] = ActionEntry(SHIFT, 34);
   _jumpMap[602][SelectStatement] = 772;
   _actionMap[603][LEFT] = ActionEntry(REDUCE, 378);
   _actionMap[603][RIGHT] = ActionEntry(REDUCE, 378);
   _actionMap[603][INNER] = ActionEntry(REDUCE, 378);
   _actionMap[603][JOIN] = ActionEntry(REDUCE, 378);
   _actionMap[603][RETURNTOKEN] = ActionEntry(REDUCE, 378);
   _actionMap[603][SEMICOLON] = ActionEntry(REDUCE, 378);
   _actionMap[603][ENDTOKEN] = ActionEntry(REDUCE, 378);
   _actionMap[603][UNION] = ActionEntry(REDUCE, 378);
   _actionMap[603][ROWLIMIT] = ActionEntry(REDUCE, 378);
   _actionMap[603][ORDER] = ActionEntry(REDUCE, 378);
   _actionMap[603][GROUP] = ActionEntry(REDUCE, 378);
   _actionMap[603][WHERE] = ActionEntry(REDUCE, 378);
   _actionMap[603][THEN] = ActionEntry(REDUCE, 378);
   _actionMap[603][RB] = ActionEntry(REDUCE, 378);
   _actionMap[603][AND] = ActionEntry(REDUCE, 378);
   _actionMap[603][OR] = ActionEntry(REDUCE, 378);
   _actionMap[604][RB] = ActionEntry(SHIFT, 499);
   _actionMap[604][PLUS] = ActionEntry(SHIFT, 275);
   _actionMap[604][MINUS] = ActionEntry(SHIFT, 274);
   _actionMap[604][CONCAT] = ActionEntry(SHIFT, 273);
   _actionMap[604][INTOK] = ActionEntry(SHIFT, 591);
   _actionMap[604][NOT] = ActionEntry(SHIFT, 594);
   _actionMap[604][BETWEEN] = ActionEntry(SHIFT, 590);
   _actionMap[604][IS] = ActionEntry(SHIFT, 592);
   _actionMap[604][LIKE] = ActionEntry(SHIFT, 593);
   _actionMap[604][EQU] = ActionEntry(SHIFT, 595);
   _actionMap[604][NEGATION] = ActionEntry(SHIFT, 598);
   _actionMap[604][LT] = ActionEntry(SHIFT, 596);
   _actionMap[604][MT] = ActionEntry(SHIFT, 597);
   _jumpMap[604][Comparison] = 589;
   _actionMap[605][RB] = ActionEntry(SHIFT, 773);
   _actionMap[605][AND] = ActionEntry(SHIFT, 599);
   _actionMap[605][OR] = ActionEntry(SHIFT, 600);
   _actionMap[606][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[606][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[606][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[606][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[606][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[606][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[606][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[606][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[606][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[606][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[606][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[606][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[606][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[606][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[606][UPPER] = ActionEntry(SHIFT, 175);
}
void Cego::loadParser96()
{
   _actionMap[606][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[606][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[606][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[606][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[606][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[606][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[606][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[606][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[606][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[606][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[606][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[606][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[606][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[606][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[606][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[606][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[606][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[606][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[606][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[606][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[606][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[606][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[606][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[606][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[606][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[606][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[606][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[606][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[606][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[606][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[606][LB] = ActionEntry(SHIFT, 176);
   _actionMap[606][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[606][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[606][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[606][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[606][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[606][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[606][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[606][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[606][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[606][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[606][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[606][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[606][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[606][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[606][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[606][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[606][MAX] = ActionEntry(SHIFT, 154);
   _jumpMap[606][ObjSpec] = 121;
   _jumpMap[606][Constant] = 120;
}
void Cego::loadParser97()
{
   _jumpMap[606][SignedFloat] = 119;
   _jumpMap[606][SignedInt] = 118;
   _jumpMap[606][Attribute] = 117;
   _jumpMap[606][Function] = 116;
   _jumpMap[606][CasePrepare] = 115;
   _jumpMap[606][CaseClause] = 114;
   _jumpMap[606][Factor] = 113;
   _jumpMap[606][Term] = 112;
   _jumpMap[606][Expr] = 774;
   _actionMap[607][WHEN] = ActionEntry(REDUCE, 356);
   _actionMap[607][ELSE] = ActionEntry(REDUCE, 356);
   _actionMap[607][LEFT] = ActionEntry(REDUCE, 356);
   _actionMap[607][RIGHT] = ActionEntry(REDUCE, 356);
   _actionMap[607][INNER] = ActionEntry(REDUCE, 356);
   _actionMap[607][JOIN] = ActionEntry(REDUCE, 356);
   _actionMap[607][RETURNTOKEN] = ActionEntry(REDUCE, 356);
   _actionMap[607][ORDER] = ActionEntry(REDUCE, 356);
   _actionMap[607][GROUP] = ActionEntry(REDUCE, 356);
   _actionMap[607][WHERE] = ActionEntry(REDUCE, 356);
   _actionMap[607][FROM] = ActionEntry(REDUCE, 356);
   _actionMap[607][AS] = ActionEntry(REDUCE, 356);
   _actionMap[607][END_TOKEN] = ActionEntry(REDUCE, 356);
   _actionMap[607][BEGIN] = ActionEntry(REDUCE, 356);
   _actionMap[607][THEN] = ActionEntry(REDUCE, 356);
   _actionMap[607][OR] = ActionEntry(REDUCE, 356);
   _actionMap[607][AND] = ActionEntry(REDUCE, 356);
   _actionMap[607][INTOK] = ActionEntry(REDUCE, 356);
   _actionMap[607][NOT] = ActionEntry(REDUCE, 356);
   _actionMap[607][BETWEEN] = ActionEntry(REDUCE, 356);
   _actionMap[607][IS] = ActionEntry(REDUCE, 356);
   _actionMap[607][LIKE] = ActionEntry(REDUCE, 356);
   _actionMap[607][MT] = ActionEntry(REDUCE, 356);
   _actionMap[607][LT] = ActionEntry(REDUCE, 356);
   _actionMap[607][NEGATION] = ActionEntry(REDUCE, 356);
   _actionMap[607][EQU] = ActionEntry(REDUCE, 356);
   _actionMap[607][RB] = ActionEntry(REDUCE, 356);
   _actionMap[607][ENDTOKEN] = ActionEntry(REDUCE, 356);
   _actionMap[607][UNION] = ActionEntry(REDUCE, 356);
   _actionMap[607][ROWLIMIT] = ActionEntry(REDUCE, 356);
   _actionMap[607][KSEP] = ActionEntry(REDUCE, 356);
   _actionMap[607][ASC] = ActionEntry(REDUCE, 356);
   _actionMap[607][DESC] = ActionEntry(REDUCE, 356);
   _actionMap[607][SEMICOLON] = ActionEntry(REDUCE, 356);
   _actionMap[607][PLUS] = ActionEntry(REDUCE, 356);
   _actionMap[607][MINUS] = ActionEntry(REDUCE, 356);
   _actionMap[607][DIVISION] = ActionEntry(REDUCE, 356);
   _actionMap[607][STAR] = ActionEntry(REDUCE, 356);
   _actionMap[607][CONCAT] = ActionEntry(REDUCE, 356);
   _actionMap[608][WHEN] = ActionEntry(REDUCE, 318);
   _actionMap[608][ELSE] = ActionEntry(REDUCE, 318);
}
void Cego::loadParser98()
{
   _actionMap[608][LEFT] = ActionEntry(REDUCE, 318);
   _actionMap[608][RIGHT] = ActionEntry(REDUCE, 318);
   _actionMap[608][INNER] = ActionEntry(REDUCE, 318);
   _actionMap[608][JOIN] = ActionEntry(REDUCE, 318);
   _actionMap[608][RETURNTOKEN] = ActionEntry(REDUCE, 318);
   _actionMap[608][ORDER] = ActionEntry(REDUCE, 318);
   _actionMap[608][GROUP] = ActionEntry(REDUCE, 318);
   _actionMap[608][WHERE] = ActionEntry(REDUCE, 318);
   _actionMap[608][FROM] = ActionEntry(REDUCE, 318);
   _actionMap[608][AS] = ActionEntry(REDUCE, 318);
   _actionMap[608][END_TOKEN] = ActionEntry(REDUCE, 318);
   _actionMap[608][BEGIN] = ActionEntry(REDUCE, 318);
   _actionMap[608][THEN] = ActionEntry(REDUCE, 318);
   _actionMap[608][OR] = ActionEntry(REDUCE, 318);
   _actionMap[608][AND] = ActionEntry(REDUCE, 318);
   _actionMap[608][INTOK] = ActionEntry(REDUCE, 318);
   _actionMap[608][NOT] = ActionEntry(REDUCE, 318);
   _actionMap[608][BETWEEN] = ActionEntry(REDUCE, 318);
   _actionMap[608][IS] = ActionEntry(REDUCE, 318);
   _actionMap[608][LIKE] = ActionEntry(REDUCE, 318);
   _actionMap[608][MT] = ActionEntry(REDUCE, 318);
   _actionMap[608][LT] = ActionEntry(REDUCE, 318);
   _actionMap[608][NEGATION] = ActionEntry(REDUCE, 318);
   _actionMap[608][EQU] = ActionEntry(REDUCE, 318);
   _actionMap[608][RB] = ActionEntry(REDUCE, 318);
   _actionMap[608][ENDTOKEN] = ActionEntry(REDUCE, 318);
   _actionMap[608][UNION] = ActionEntry(REDUCE, 318);
   _actionMap[608][ROWLIMIT] = ActionEntry(REDUCE, 318);
   _actionMap[608][KSEP] = ActionEntry(REDUCE, 318);
   _actionMap[608][ASC] = ActionEntry(REDUCE, 318);
   _actionMap[608][DESC] = ActionEntry(REDUCE, 318);
   _actionMap[608][SEMICOLON] = ActionEntry(REDUCE, 318);
   _actionMap[608][PLUS] = ActionEntry(REDUCE, 318);
   _actionMap[608][MINUS] = ActionEntry(REDUCE, 318);
   _actionMap[608][DIVISION] = ActionEntry(REDUCE, 318);
   _actionMap[608][STAR] = ActionEntry(REDUCE, 318);
   _actionMap[608][CONCAT] = ActionEntry(REDUCE, 318);
   _actionMap[609][WHEN] = ActionEntry(REDUCE, 187);
   _actionMap[609][ELSE] = ActionEntry(REDUCE, 187);
   _actionMap[609][LEFT] = ActionEntry(REDUCE, 187);
   _actionMap[609][RIGHT] = ActionEntry(REDUCE, 187);
   _actionMap[609][INNER] = ActionEntry(REDUCE, 187);
   _actionMap[609][JOIN] = ActionEntry(REDUCE, 187);
   _actionMap[609][RETURNTOKEN] = ActionEntry(REDUCE, 187);
   _actionMap[609][ORDER] = ActionEntry(REDUCE, 187);
   _actionMap[609][GROUP] = ActionEntry(REDUCE, 187);
   _actionMap[609][WHERE] = ActionEntry(REDUCE, 187);
   _actionMap[609][AS] = ActionEntry(REDUCE, 187);
   _actionMap[609][FROM] = ActionEntry(REDUCE, 187);
   _actionMap[609][END_TOKEN] = ActionEntry(REDUCE, 187);
}
void Cego::loadParser99()
{
   _actionMap[609][BEGIN] = ActionEntry(REDUCE, 187);
   _actionMap[609][THEN] = ActionEntry(REDUCE, 187);
   _actionMap[609][OR] = ActionEntry(REDUCE, 187);
   _actionMap[609][AND] = ActionEntry(REDUCE, 187);
   _actionMap[609][LIKE] = ActionEntry(REDUCE, 187);
   _actionMap[609][IS] = ActionEntry(REDUCE, 187);
   _actionMap[609][BETWEEN] = ActionEntry(REDUCE, 187);
   _actionMap[609][NOT] = ActionEntry(REDUCE, 187);
   _actionMap[609][INTOK] = ActionEntry(REDUCE, 187);
   _actionMap[609][EQU] = ActionEntry(REDUCE, 187);
   _actionMap[609][NEGATION] = ActionEntry(REDUCE, 187);
   _actionMap[609][LT] = ActionEntry(REDUCE, 187);
   _actionMap[609][MT] = ActionEntry(REDUCE, 187);
   _actionMap[609][DESC] = ActionEntry(REDUCE, 187);
   _actionMap[609][ASC] = ActionEntry(REDUCE, 187);
   _actionMap[609][KSEP] = ActionEntry(REDUCE, 187);
   _actionMap[609][ROWLIMIT] = ActionEntry(REDUCE, 187);
   _actionMap[609][UNION] = ActionEntry(REDUCE, 187);
   _actionMap[609][ENDTOKEN] = ActionEntry(REDUCE, 187);
   _actionMap[609][RB] = ActionEntry(REDUCE, 187);
   _actionMap[609][SEMICOLON] = ActionEntry(REDUCE, 187);
   _actionMap[609][CONCAT] = ActionEntry(REDUCE, 187);
   _actionMap[609][STAR] = ActionEntry(REDUCE, 187);
   _actionMap[609][DIVISION] = ActionEntry(REDUCE, 187);
   _actionMap[609][MINUS] = ActionEntry(REDUCE, 187);
   _actionMap[609][PLUS] = ActionEntry(REDUCE, 187);
   _actionMap[610][WHEN] = ActionEntry(REDUCE, 346);
   _actionMap[610][ELSE] = ActionEntry(REDUCE, 346);
   _actionMap[610][LEFT] = ActionEntry(REDUCE, 346);
   _actionMap[610][RIGHT] = ActionEntry(REDUCE, 346);
   _actionMap[610][INNER] = ActionEntry(REDUCE, 346);
   _actionMap[610][JOIN] = ActionEntry(REDUCE, 346);
   _actionMap[610][RETURNTOKEN] = ActionEntry(REDUCE, 346);
   _actionMap[610][ORDER] = ActionEntry(REDUCE, 346);
   _actionMap[610][GROUP] = ActionEntry(REDUCE, 346);
   _actionMap[610][WHERE] = ActionEntry(REDUCE, 346);
   _actionMap[610][FROM] = ActionEntry(REDUCE, 346);
   _actionMap[610][AS] = ActionEntry(REDUCE, 346);
   _actionMap[610][END_TOKEN] = ActionEntry(REDUCE, 346);
   _actionMap[610][BEGIN] = ActionEntry(REDUCE, 346);
   _actionMap[610][THEN] = ActionEntry(REDUCE, 346);
   _actionMap[610][OR] = ActionEntry(REDUCE, 346);
   _actionMap[610][AND] = ActionEntry(REDUCE, 346);
   _actionMap[610][INTOK] = ActionEntry(REDUCE, 346);
   _actionMap[610][NOT] = ActionEntry(REDUCE, 346);
   _actionMap[610][BETWEEN] = ActionEntry(REDUCE, 346);
   _actionMap[610][IS] = ActionEntry(REDUCE, 346);
   _actionMap[610][LIKE] = ActionEntry(REDUCE, 346);
   _actionMap[610][MT] = ActionEntry(REDUCE, 346);
   _actionMap[610][LT] = ActionEntry(REDUCE, 346);
}
void Cego::loadParser100()
{
   _actionMap[610][NEGATION] = ActionEntry(REDUCE, 346);
   _actionMap[610][EQU] = ActionEntry(REDUCE, 346);
   _actionMap[610][RB] = ActionEntry(REDUCE, 346);
   _actionMap[610][ENDTOKEN] = ActionEntry(REDUCE, 346);
   _actionMap[610][UNION] = ActionEntry(REDUCE, 346);
   _actionMap[610][ROWLIMIT] = ActionEntry(REDUCE, 346);
   _actionMap[610][KSEP] = ActionEntry(REDUCE, 346);
   _actionMap[610][ASC] = ActionEntry(REDUCE, 346);
   _actionMap[610][DESC] = ActionEntry(REDUCE, 346);
   _actionMap[610][SEMICOLON] = ActionEntry(REDUCE, 346);
   _actionMap[610][PLUS] = ActionEntry(REDUCE, 346);
   _actionMap[610][MINUS] = ActionEntry(REDUCE, 346);
   _actionMap[610][DIVISION] = ActionEntry(REDUCE, 346);
   _actionMap[610][STAR] = ActionEntry(REDUCE, 346);
   _actionMap[610][CONCAT] = ActionEntry(REDUCE, 346);
   _actionMap[611][WHEN] = ActionEntry(REDUCE, 347);
   _actionMap[611][ELSE] = ActionEntry(REDUCE, 347);
   _actionMap[611][LEFT] = ActionEntry(REDUCE, 347);
   _actionMap[611][RIGHT] = ActionEntry(REDUCE, 347);
   _actionMap[611][INNER] = ActionEntry(REDUCE, 347);
   _actionMap[611][JOIN] = ActionEntry(REDUCE, 347);
   _actionMap[611][RETURNTOKEN] = ActionEntry(REDUCE, 347);
   _actionMap[611][ORDER] = ActionEntry(REDUCE, 347);
   _actionMap[611][GROUP] = ActionEntry(REDUCE, 347);
   _actionMap[611][WHERE] = ActionEntry(REDUCE, 347);
   _actionMap[611][FROM] = ActionEntry(REDUCE, 347);
   _actionMap[611][AS] = ActionEntry(REDUCE, 347);
   _actionMap[611][END_TOKEN] = ActionEntry(REDUCE, 347);
   _actionMap[611][BEGIN] = ActionEntry(REDUCE, 347);
   _actionMap[611][THEN] = ActionEntry(REDUCE, 347);
   _actionMap[611][OR] = ActionEntry(REDUCE, 347);
   _actionMap[611][AND] = ActionEntry(REDUCE, 347);
   _actionMap[611][INTOK] = ActionEntry(REDUCE, 347);
   _actionMap[611][NOT] = ActionEntry(REDUCE, 347);
   _actionMap[611][BETWEEN] = ActionEntry(REDUCE, 347);
   _actionMap[611][IS] = ActionEntry(REDUCE, 347);
   _actionMap[611][LIKE] = ActionEntry(REDUCE, 347);
   _actionMap[611][MT] = ActionEntry(REDUCE, 347);
   _actionMap[611][LT] = ActionEntry(REDUCE, 347);
   _actionMap[611][NEGATION] = ActionEntry(REDUCE, 347);
   _actionMap[611][EQU] = ActionEntry(REDUCE, 347);
   _actionMap[611][RB] = ActionEntry(REDUCE, 347);
   _actionMap[611][ENDTOKEN] = ActionEntry(REDUCE, 347);
   _actionMap[611][UNION] = ActionEntry(REDUCE, 347);
   _actionMap[611][ROWLIMIT] = ActionEntry(REDUCE, 347);
   _actionMap[611][KSEP] = ActionEntry(REDUCE, 347);
   _actionMap[611][ASC] = ActionEntry(REDUCE, 347);
   _actionMap[611][DESC] = ActionEntry(REDUCE, 347);
   _actionMap[611][SEMICOLON] = ActionEntry(REDUCE, 347);
   _actionMap[611][PLUS] = ActionEntry(REDUCE, 347);
}
void Cego::loadParser101()
{
   _actionMap[611][MINUS] = ActionEntry(REDUCE, 347);
   _actionMap[611][DIVISION] = ActionEntry(REDUCE, 347);
   _actionMap[611][STAR] = ActionEntry(REDUCE, 347);
   _actionMap[611][CONCAT] = ActionEntry(REDUCE, 347);
   _actionMap[612][WHEN] = ActionEntry(REDUCE, 348);
   _actionMap[612][ELSE] = ActionEntry(REDUCE, 348);
   _actionMap[612][LEFT] = ActionEntry(REDUCE, 348);
   _actionMap[612][RIGHT] = ActionEntry(REDUCE, 348);
   _actionMap[612][INNER] = ActionEntry(REDUCE, 348);
   _actionMap[612][JOIN] = ActionEntry(REDUCE, 348);
   _actionMap[612][RETURNTOKEN] = ActionEntry(REDUCE, 348);
   _actionMap[612][ORDER] = ActionEntry(REDUCE, 348);
   _actionMap[612][GROUP] = ActionEntry(REDUCE, 348);
   _actionMap[612][WHERE] = ActionEntry(REDUCE, 348);
   _actionMap[612][FROM] = ActionEntry(REDUCE, 348);
   _actionMap[612][AS] = ActionEntry(REDUCE, 348);
   _actionMap[612][END_TOKEN] = ActionEntry(REDUCE, 348);
   _actionMap[612][BEGIN] = ActionEntry(REDUCE, 348);
   _actionMap[612][THEN] = ActionEntry(REDUCE, 348);
   _actionMap[612][OR] = ActionEntry(REDUCE, 348);
   _actionMap[612][AND] = ActionEntry(REDUCE, 348);
   _actionMap[612][INTOK] = ActionEntry(REDUCE, 348);
   _actionMap[612][NOT] = ActionEntry(REDUCE, 348);
   _actionMap[612][BETWEEN] = ActionEntry(REDUCE, 348);
   _actionMap[612][IS] = ActionEntry(REDUCE, 348);
   _actionMap[612][LIKE] = ActionEntry(REDUCE, 348);
   _actionMap[612][MT] = ActionEntry(REDUCE, 348);
   _actionMap[612][LT] = ActionEntry(REDUCE, 348);
   _actionMap[612][NEGATION] = ActionEntry(REDUCE, 348);
   _actionMap[612][EQU] = ActionEntry(REDUCE, 348);
   _actionMap[612][RB] = ActionEntry(REDUCE, 348);
   _actionMap[612][ENDTOKEN] = ActionEntry(REDUCE, 348);
   _actionMap[612][UNION] = ActionEntry(REDUCE, 348);
   _actionMap[612][ROWLIMIT] = ActionEntry(REDUCE, 348);
   _actionMap[612][KSEP] = ActionEntry(REDUCE, 348);
   _actionMap[612][ASC] = ActionEntry(REDUCE, 348);
   _actionMap[612][DESC] = ActionEntry(REDUCE, 348);
   _actionMap[612][SEMICOLON] = ActionEntry(REDUCE, 348);
   _actionMap[612][PLUS] = ActionEntry(REDUCE, 348);
   _actionMap[612][MINUS] = ActionEntry(REDUCE, 348);
   _actionMap[612][DIVISION] = ActionEntry(REDUCE, 348);
   _actionMap[612][STAR] = ActionEntry(REDUCE, 348);
   _actionMap[612][CONCAT] = ActionEntry(REDUCE, 348);
   _actionMap[613][WHEN] = ActionEntry(REDUCE, 423);
   _actionMap[613][ELSE] = ActionEntry(REDUCE, 423);
   _actionMap[613][LEFT] = ActionEntry(REDUCE, 423);
   _actionMap[613][RIGHT] = ActionEntry(REDUCE, 423);
   _actionMap[613][INNER] = ActionEntry(REDUCE, 423);
   _actionMap[613][JOIN] = ActionEntry(REDUCE, 423);
   _actionMap[613][RETURNTOKEN] = ActionEntry(REDUCE, 423);
}
void Cego::loadParser102()
{
   _actionMap[613][ORDER] = ActionEntry(REDUCE, 423);
   _actionMap[613][GROUP] = ActionEntry(REDUCE, 423);
   _actionMap[613][WHERE] = ActionEntry(REDUCE, 423);
   _actionMap[613][NULLTOKEN] = ActionEntry(REDUCE, 423);
   _actionMap[613][FROM] = ActionEntry(REDUCE, 423);
   _actionMap[613][AS] = ActionEntry(REDUCE, 423);
   _actionMap[613][END_TOKEN] = ActionEntry(REDUCE, 423);
   _actionMap[613][BEGIN] = ActionEntry(REDUCE, 423);
   _actionMap[613][THEN] = ActionEntry(REDUCE, 423);
   _actionMap[613][OR] = ActionEntry(REDUCE, 423);
   _actionMap[613][AND] = ActionEntry(REDUCE, 423);
   _actionMap[613][INTOK] = ActionEntry(REDUCE, 423);
   _actionMap[613][NOT] = ActionEntry(REDUCE, 423);
   _actionMap[613][BETWEEN] = ActionEntry(REDUCE, 423);
   _actionMap[613][IS] = ActionEntry(REDUCE, 423);
   _actionMap[613][LIKE] = ActionEntry(REDUCE, 423);
   _actionMap[613][MT] = ActionEntry(REDUCE, 423);
   _actionMap[613][LT] = ActionEntry(REDUCE, 423);
   _actionMap[613][NEGATION] = ActionEntry(REDUCE, 423);
   _actionMap[613][EQU] = ActionEntry(REDUCE, 423);
   _actionMap[613][RB] = ActionEntry(REDUCE, 423);
   _actionMap[613][ENDTOKEN] = ActionEntry(REDUCE, 423);
   _actionMap[613][UNION] = ActionEntry(REDUCE, 423);
   _actionMap[613][ROWLIMIT] = ActionEntry(REDUCE, 423);
   _actionMap[613][KSEP] = ActionEntry(REDUCE, 423);
   _actionMap[613][ASC] = ActionEntry(REDUCE, 423);
   _actionMap[613][DESC] = ActionEntry(REDUCE, 423);
   _actionMap[613][SEMICOLON] = ActionEntry(REDUCE, 423);
   _actionMap[613][PLUS] = ActionEntry(REDUCE, 423);
   _actionMap[613][MINUS] = ActionEntry(REDUCE, 423);
   _actionMap[613][DIVISION] = ActionEntry(REDUCE, 423);
   _actionMap[613][STAR] = ActionEntry(REDUCE, 423);
   _actionMap[613][CONCAT] = ActionEntry(REDUCE, 423);
   _actionMap[614][WHEN] = ActionEntry(REDUCE, 349);
   _actionMap[614][ELSE] = ActionEntry(REDUCE, 349);
   _actionMap[614][LEFT] = ActionEntry(REDUCE, 349);
   _actionMap[614][RIGHT] = ActionEntry(REDUCE, 349);
   _actionMap[614][INNER] = ActionEntry(REDUCE, 349);
   _actionMap[614][JOIN] = ActionEntry(REDUCE, 349);
   _actionMap[614][RETURNTOKEN] = ActionEntry(REDUCE, 349);
   _actionMap[614][ORDER] = ActionEntry(REDUCE, 349);
   _actionMap[614][GROUP] = ActionEntry(REDUCE, 349);
   _actionMap[614][WHERE] = ActionEntry(REDUCE, 349);
   _actionMap[614][FROM] = ActionEntry(REDUCE, 349);
   _actionMap[614][AS] = ActionEntry(REDUCE, 349);
   _actionMap[614][END_TOKEN] = ActionEntry(REDUCE, 349);
   _actionMap[614][BEGIN] = ActionEntry(REDUCE, 349);
   _actionMap[614][THEN] = ActionEntry(REDUCE, 349);
   _actionMap[614][OR] = ActionEntry(REDUCE, 349);
   _actionMap[614][AND] = ActionEntry(REDUCE, 349);
}
void Cego::loadParser103()
{
   _actionMap[614][INTOK] = ActionEntry(REDUCE, 349);
   _actionMap[614][NOT] = ActionEntry(REDUCE, 349);
   _actionMap[614][BETWEEN] = ActionEntry(REDUCE, 349);
   _actionMap[614][IS] = ActionEntry(REDUCE, 349);
   _actionMap[614][LIKE] = ActionEntry(REDUCE, 349);
   _actionMap[614][MT] = ActionEntry(REDUCE, 349);
   _actionMap[614][LT] = ActionEntry(REDUCE, 349);
   _actionMap[614][NEGATION] = ActionEntry(REDUCE, 349);
   _actionMap[614][EQU] = ActionEntry(REDUCE, 349);
   _actionMap[614][RB] = ActionEntry(REDUCE, 349);
   _actionMap[614][ENDTOKEN] = ActionEntry(REDUCE, 349);
   _actionMap[614][UNION] = ActionEntry(REDUCE, 349);
   _actionMap[614][ROWLIMIT] = ActionEntry(REDUCE, 349);
   _actionMap[614][KSEP] = ActionEntry(REDUCE, 349);
   _actionMap[614][ASC] = ActionEntry(REDUCE, 349);
   _actionMap[614][DESC] = ActionEntry(REDUCE, 349);
   _actionMap[614][SEMICOLON] = ActionEntry(REDUCE, 349);
   _actionMap[614][PLUS] = ActionEntry(REDUCE, 349);
   _actionMap[614][MINUS] = ActionEntry(REDUCE, 349);
   _actionMap[614][DIVISION] = ActionEntry(REDUCE, 349);
   _actionMap[614][STAR] = ActionEntry(REDUCE, 349);
   _actionMap[614][CONCAT] = ActionEntry(REDUCE, 349);
   _actionMap[615][WHEN] = ActionEntry(REDUCE, 350);
   _actionMap[615][ELSE] = ActionEntry(REDUCE, 350);
   _actionMap[615][LEFT] = ActionEntry(REDUCE, 350);
   _actionMap[615][RIGHT] = ActionEntry(REDUCE, 350);
   _actionMap[615][INNER] = ActionEntry(REDUCE, 350);
   _actionMap[615][JOIN] = ActionEntry(REDUCE, 350);
   _actionMap[615][RETURNTOKEN] = ActionEntry(REDUCE, 350);
   _actionMap[615][ORDER] = ActionEntry(REDUCE, 350);
   _actionMap[615][GROUP] = ActionEntry(REDUCE, 350);
   _actionMap[615][WHERE] = ActionEntry(REDUCE, 350);
   _actionMap[615][FROM] = ActionEntry(REDUCE, 350);
   _actionMap[615][AS] = ActionEntry(REDUCE, 350);
   _actionMap[615][END_TOKEN] = ActionEntry(REDUCE, 350);
   _actionMap[615][BEGIN] = ActionEntry(REDUCE, 350);
   _actionMap[615][THEN] = ActionEntry(REDUCE, 350);
   _actionMap[615][OR] = ActionEntry(REDUCE, 350);
   _actionMap[615][AND] = ActionEntry(REDUCE, 350);
   _actionMap[615][INTOK] = ActionEntry(REDUCE, 350);
   _actionMap[615][NOT] = ActionEntry(REDUCE, 350);
   _actionMap[615][BETWEEN] = ActionEntry(REDUCE, 350);
   _actionMap[615][IS] = ActionEntry(REDUCE, 350);
   _actionMap[615][LIKE] = ActionEntry(REDUCE, 350);
   _actionMap[615][MT] = ActionEntry(REDUCE, 350);
   _actionMap[615][LT] = ActionEntry(REDUCE, 350);
   _actionMap[615][NEGATION] = ActionEntry(REDUCE, 350);
   _actionMap[615][EQU] = ActionEntry(REDUCE, 350);
   _actionMap[615][RB] = ActionEntry(REDUCE, 350);
   _actionMap[615][ENDTOKEN] = ActionEntry(REDUCE, 350);
}
void Cego::loadParser104()
{
   _actionMap[615][UNION] = ActionEntry(REDUCE, 350);
   _actionMap[615][ROWLIMIT] = ActionEntry(REDUCE, 350);
   _actionMap[615][KSEP] = ActionEntry(REDUCE, 350);
   _actionMap[615][ASC] = ActionEntry(REDUCE, 350);
   _actionMap[615][DESC] = ActionEntry(REDUCE, 350);
   _actionMap[615][SEMICOLON] = ActionEntry(REDUCE, 350);
   _actionMap[615][PLUS] = ActionEntry(REDUCE, 350);
   _actionMap[615][MINUS] = ActionEntry(REDUCE, 350);
   _actionMap[615][DIVISION] = ActionEntry(REDUCE, 350);
   _actionMap[615][STAR] = ActionEntry(REDUCE, 350);
   _actionMap[615][CONCAT] = ActionEntry(REDUCE, 350);
   _actionMap[616][WHEN] = ActionEntry(REDUCE, 424);
   _actionMap[616][ELSE] = ActionEntry(REDUCE, 424);
   _actionMap[616][LEFT] = ActionEntry(REDUCE, 424);
   _actionMap[616][RIGHT] = ActionEntry(REDUCE, 424);
   _actionMap[616][INNER] = ActionEntry(REDUCE, 424);
   _actionMap[616][JOIN] = ActionEntry(REDUCE, 424);
   _actionMap[616][RETURNTOKEN] = ActionEntry(REDUCE, 424);
   _actionMap[616][ORDER] = ActionEntry(REDUCE, 424);
   _actionMap[616][GROUP] = ActionEntry(REDUCE, 424);
   _actionMap[616][WHERE] = ActionEntry(REDUCE, 424);
   _actionMap[616][NULLTOKEN] = ActionEntry(REDUCE, 424);
   _actionMap[616][FROM] = ActionEntry(REDUCE, 424);
   _actionMap[616][AS] = ActionEntry(REDUCE, 424);
   _actionMap[616][END_TOKEN] = ActionEntry(REDUCE, 424);
   _actionMap[616][BEGIN] = ActionEntry(REDUCE, 424);
   _actionMap[616][THEN] = ActionEntry(REDUCE, 424);
   _actionMap[616][OR] = ActionEntry(REDUCE, 424);
   _actionMap[616][AND] = ActionEntry(REDUCE, 424);
   _actionMap[616][INTOK] = ActionEntry(REDUCE, 424);
   _actionMap[616][NOT] = ActionEntry(REDUCE, 424);
   _actionMap[616][BETWEEN] = ActionEntry(REDUCE, 424);
   _actionMap[616][IS] = ActionEntry(REDUCE, 424);
   _actionMap[616][LIKE] = ActionEntry(REDUCE, 424);
   _actionMap[616][MT] = ActionEntry(REDUCE, 424);
   _actionMap[616][LT] = ActionEntry(REDUCE, 424);
   _actionMap[616][NEGATION] = ActionEntry(REDUCE, 424);
   _actionMap[616][EQU] = ActionEntry(REDUCE, 424);
   _actionMap[616][RB] = ActionEntry(REDUCE, 424);
   _actionMap[616][ENDTOKEN] = ActionEntry(REDUCE, 424);
   _actionMap[616][UNION] = ActionEntry(REDUCE, 424);
   _actionMap[616][ROWLIMIT] = ActionEntry(REDUCE, 424);
   _actionMap[616][KSEP] = ActionEntry(REDUCE, 424);
   _actionMap[616][ASC] = ActionEntry(REDUCE, 424);
   _actionMap[616][DESC] = ActionEntry(REDUCE, 424);
   _actionMap[616][SEMICOLON] = ActionEntry(REDUCE, 424);
   _actionMap[616][PLUS] = ActionEntry(REDUCE, 424);
   _actionMap[616][MINUS] = ActionEntry(REDUCE, 424);
   _actionMap[616][DIVISION] = ActionEntry(REDUCE, 424);
   _actionMap[616][STAR] = ActionEntry(REDUCE, 424);
}
void Cego::loadParser105()
{
   _actionMap[616][CONCAT] = ActionEntry(REDUCE, 424);
   _actionMap[617][WHEN] = ActionEntry(REDUCE, 351);
   _actionMap[617][ELSE] = ActionEntry(REDUCE, 351);
   _actionMap[617][LEFT] = ActionEntry(REDUCE, 351);
   _actionMap[617][RIGHT] = ActionEntry(REDUCE, 351);
   _actionMap[617][INNER] = ActionEntry(REDUCE, 351);
   _actionMap[617][JOIN] = ActionEntry(REDUCE, 351);
   _actionMap[617][RETURNTOKEN] = ActionEntry(REDUCE, 351);
   _actionMap[617][ORDER] = ActionEntry(REDUCE, 351);
   _actionMap[617][GROUP] = ActionEntry(REDUCE, 351);
   _actionMap[617][WHERE] = ActionEntry(REDUCE, 351);
   _actionMap[617][FROM] = ActionEntry(REDUCE, 351);
   _actionMap[617][AS] = ActionEntry(REDUCE, 351);
   _actionMap[617][END_TOKEN] = ActionEntry(REDUCE, 351);
   _actionMap[617][BEGIN] = ActionEntry(REDUCE, 351);
   _actionMap[617][THEN] = ActionEntry(REDUCE, 351);
   _actionMap[617][OR] = ActionEntry(REDUCE, 351);
   _actionMap[617][AND] = ActionEntry(REDUCE, 351);
   _actionMap[617][INTOK] = ActionEntry(REDUCE, 351);
   _actionMap[617][NOT] = ActionEntry(REDUCE, 351);
   _actionMap[617][BETWEEN] = ActionEntry(REDUCE, 351);
   _actionMap[617][IS] = ActionEntry(REDUCE, 351);
   _actionMap[617][LIKE] = ActionEntry(REDUCE, 351);
   _actionMap[617][MT] = ActionEntry(REDUCE, 351);
   _actionMap[617][LT] = ActionEntry(REDUCE, 351);
   _actionMap[617][NEGATION] = ActionEntry(REDUCE, 351);
   _actionMap[617][EQU] = ActionEntry(REDUCE, 351);
   _actionMap[617][RB] = ActionEntry(REDUCE, 351);
   _actionMap[617][ENDTOKEN] = ActionEntry(REDUCE, 351);
   _actionMap[617][UNION] = ActionEntry(REDUCE, 351);
   _actionMap[617][ROWLIMIT] = ActionEntry(REDUCE, 351);
   _actionMap[617][KSEP] = ActionEntry(REDUCE, 351);
   _actionMap[617][ASC] = ActionEntry(REDUCE, 351);
   _actionMap[617][DESC] = ActionEntry(REDUCE, 351);
   _actionMap[617][SEMICOLON] = ActionEntry(REDUCE, 351);
   _actionMap[617][PLUS] = ActionEntry(REDUCE, 351);
   _actionMap[617][MINUS] = ActionEntry(REDUCE, 351);
   _actionMap[617][DIVISION] = ActionEntry(REDUCE, 351);
   _actionMap[617][STAR] = ActionEntry(REDUCE, 351);
   _actionMap[617][CONCAT] = ActionEntry(REDUCE, 351);
   _actionMap[618][WHEN] = ActionEntry(REDUCE, 352);
   _actionMap[618][ELSE] = ActionEntry(REDUCE, 352);
   _actionMap[618][LEFT] = ActionEntry(REDUCE, 352);
   _actionMap[618][RIGHT] = ActionEntry(REDUCE, 352);
   _actionMap[618][INNER] = ActionEntry(REDUCE, 352);
   _actionMap[618][JOIN] = ActionEntry(REDUCE, 352);
   _actionMap[618][RETURNTOKEN] = ActionEntry(REDUCE, 352);
   _actionMap[618][ORDER] = ActionEntry(REDUCE, 352);
   _actionMap[618][GROUP] = ActionEntry(REDUCE, 352);
   _actionMap[618][WHERE] = ActionEntry(REDUCE, 352);
}
void Cego::loadParser106()
{
   _actionMap[618][FROM] = ActionEntry(REDUCE, 352);
   _actionMap[618][AS] = ActionEntry(REDUCE, 352);
   _actionMap[618][END_TOKEN] = ActionEntry(REDUCE, 352);
   _actionMap[618][BEGIN] = ActionEntry(REDUCE, 352);
   _actionMap[618][THEN] = ActionEntry(REDUCE, 352);
   _actionMap[618][OR] = ActionEntry(REDUCE, 352);
   _actionMap[618][AND] = ActionEntry(REDUCE, 352);
   _actionMap[618][INTOK] = ActionEntry(REDUCE, 352);
   _actionMap[618][NOT] = ActionEntry(REDUCE, 352);
   _actionMap[618][BETWEEN] = ActionEntry(REDUCE, 352);
   _actionMap[618][IS] = ActionEntry(REDUCE, 352);
   _actionMap[618][LIKE] = ActionEntry(REDUCE, 352);
   _actionMap[618][MT] = ActionEntry(REDUCE, 352);
   _actionMap[618][LT] = ActionEntry(REDUCE, 352);
   _actionMap[618][NEGATION] = ActionEntry(REDUCE, 352);
   _actionMap[618][EQU] = ActionEntry(REDUCE, 352);
   _actionMap[618][RB] = ActionEntry(REDUCE, 352);
   _actionMap[618][ENDTOKEN] = ActionEntry(REDUCE, 352);
   _actionMap[618][UNION] = ActionEntry(REDUCE, 352);
   _actionMap[618][ROWLIMIT] = ActionEntry(REDUCE, 352);
   _actionMap[618][KSEP] = ActionEntry(REDUCE, 352);
   _actionMap[618][ASC] = ActionEntry(REDUCE, 352);
   _actionMap[618][DESC] = ActionEntry(REDUCE, 352);
   _actionMap[618][SEMICOLON] = ActionEntry(REDUCE, 352);
   _actionMap[618][PLUS] = ActionEntry(REDUCE, 352);
   _actionMap[618][MINUS] = ActionEntry(REDUCE, 352);
   _actionMap[618][DIVISION] = ActionEntry(REDUCE, 352);
   _actionMap[618][STAR] = ActionEntry(REDUCE, 352);
   _actionMap[618][CONCAT] = ActionEntry(REDUCE, 352);
   _actionMap[619][WHEN] = ActionEntry(REDUCE, 353);
   _actionMap[619][ELSE] = ActionEntry(REDUCE, 353);
   _actionMap[619][LEFT] = ActionEntry(REDUCE, 353);
   _actionMap[619][RIGHT] = ActionEntry(REDUCE, 353);
   _actionMap[619][INNER] = ActionEntry(REDUCE, 353);
   _actionMap[619][JOIN] = ActionEntry(REDUCE, 353);
   _actionMap[619][RETURNTOKEN] = ActionEntry(REDUCE, 353);
   _actionMap[619][ORDER] = ActionEntry(REDUCE, 353);
   _actionMap[619][GROUP] = ActionEntry(REDUCE, 353);
   _actionMap[619][WHERE] = ActionEntry(REDUCE, 353);
   _actionMap[619][FROM] = ActionEntry(REDUCE, 353);
   _actionMap[619][AS] = ActionEntry(REDUCE, 353);
   _actionMap[619][END_TOKEN] = ActionEntry(REDUCE, 353);
   _actionMap[619][BEGIN] = ActionEntry(REDUCE, 353);
   _actionMap[619][THEN] = ActionEntry(REDUCE, 353);
   _actionMap[619][OR] = ActionEntry(REDUCE, 353);
   _actionMap[619][AND] = ActionEntry(REDUCE, 353);
   _actionMap[619][INTOK] = ActionEntry(REDUCE, 353);
   _actionMap[619][NOT] = ActionEntry(REDUCE, 353);
   _actionMap[619][BETWEEN] = ActionEntry(REDUCE, 353);
   _actionMap[619][IS] = ActionEntry(REDUCE, 353);
}
void Cego::loadParser107()
{
   _actionMap[619][LIKE] = ActionEntry(REDUCE, 353);
   _actionMap[619][MT] = ActionEntry(REDUCE, 353);
   _actionMap[619][LT] = ActionEntry(REDUCE, 353);
   _actionMap[619][NEGATION] = ActionEntry(REDUCE, 353);
   _actionMap[619][EQU] = ActionEntry(REDUCE, 353);
   _actionMap[619][RB] = ActionEntry(REDUCE, 353);
   _actionMap[619][ENDTOKEN] = ActionEntry(REDUCE, 353);
   _actionMap[619][UNION] = ActionEntry(REDUCE, 353);
   _actionMap[619][ROWLIMIT] = ActionEntry(REDUCE, 353);
   _actionMap[619][KSEP] = ActionEntry(REDUCE, 353);
   _actionMap[619][ASC] = ActionEntry(REDUCE, 353);
   _actionMap[619][DESC] = ActionEntry(REDUCE, 353);
   _actionMap[619][SEMICOLON] = ActionEntry(REDUCE, 353);
   _actionMap[619][PLUS] = ActionEntry(REDUCE, 353);
   _actionMap[619][MINUS] = ActionEntry(REDUCE, 353);
   _actionMap[619][DIVISION] = ActionEntry(REDUCE, 353);
   _actionMap[619][STAR] = ActionEntry(REDUCE, 353);
   _actionMap[619][CONCAT] = ActionEntry(REDUCE, 353);
   _actionMap[620][WHEN] = ActionEntry(REDUCE, 188);
   _actionMap[620][ELSE] = ActionEntry(REDUCE, 188);
   _actionMap[620][LEFT] = ActionEntry(REDUCE, 188);
   _actionMap[620][RIGHT] = ActionEntry(REDUCE, 188);
   _actionMap[620][INNER] = ActionEntry(REDUCE, 188);
   _actionMap[620][JOIN] = ActionEntry(REDUCE, 188);
   _actionMap[620][RETURNTOKEN] = ActionEntry(REDUCE, 188);
   _actionMap[620][ORDER] = ActionEntry(REDUCE, 188);
   _actionMap[620][GROUP] = ActionEntry(REDUCE, 188);
   _actionMap[620][WHERE] = ActionEntry(REDUCE, 188);
   _actionMap[620][AS] = ActionEntry(REDUCE, 188);
   _actionMap[620][FROM] = ActionEntry(REDUCE, 188);
   _actionMap[620][END_TOKEN] = ActionEntry(REDUCE, 188);
   _actionMap[620][BEGIN] = ActionEntry(REDUCE, 188);
   _actionMap[620][THEN] = ActionEntry(REDUCE, 188);
   _actionMap[620][OR] = ActionEntry(REDUCE, 188);
   _actionMap[620][AND] = ActionEntry(REDUCE, 188);
   _actionMap[620][LIKE] = ActionEntry(REDUCE, 188);
   _actionMap[620][IS] = ActionEntry(REDUCE, 188);
   _actionMap[620][BETWEEN] = ActionEntry(REDUCE, 188);
   _actionMap[620][NOT] = ActionEntry(REDUCE, 188);
   _actionMap[620][INTOK] = ActionEntry(REDUCE, 188);
   _actionMap[620][EQU] = ActionEntry(REDUCE, 188);
   _actionMap[620][NEGATION] = ActionEntry(REDUCE, 188);
   _actionMap[620][LT] = ActionEntry(REDUCE, 188);
   _actionMap[620][MT] = ActionEntry(REDUCE, 188);
   _actionMap[620][DESC] = ActionEntry(REDUCE, 188);
   _actionMap[620][ASC] = ActionEntry(REDUCE, 188);
   _actionMap[620][KSEP] = ActionEntry(REDUCE, 188);
   _actionMap[620][ROWLIMIT] = ActionEntry(REDUCE, 188);
   _actionMap[620][UNION] = ActionEntry(REDUCE, 188);
   _actionMap[620][ENDTOKEN] = ActionEntry(REDUCE, 188);
}
void Cego::loadParser108()
{
   _actionMap[620][RB] = ActionEntry(REDUCE, 188);
   _actionMap[620][SEMICOLON] = ActionEntry(REDUCE, 188);
   _actionMap[620][CONCAT] = ActionEntry(REDUCE, 188);
   _actionMap[620][STAR] = ActionEntry(REDUCE, 188);
   _actionMap[620][DIVISION] = ActionEntry(REDUCE, 188);
   _actionMap[620][MINUS] = ActionEntry(REDUCE, 188);
   _actionMap[620][PLUS] = ActionEntry(REDUCE, 188);
   _actionMap[621][WHEN] = ActionEntry(REDUCE, 185);
   _actionMap[621][ELSE] = ActionEntry(REDUCE, 185);
   _actionMap[621][LEFT] = ActionEntry(REDUCE, 185);
   _actionMap[621][RIGHT] = ActionEntry(REDUCE, 185);
   _actionMap[621][INNER] = ActionEntry(REDUCE, 185);
   _actionMap[621][JOIN] = ActionEntry(REDUCE, 185);
   _actionMap[621][RETURNTOKEN] = ActionEntry(REDUCE, 185);
   _actionMap[621][ORDER] = ActionEntry(REDUCE, 185);
   _actionMap[621][GROUP] = ActionEntry(REDUCE, 185);
   _actionMap[621][WHERE] = ActionEntry(REDUCE, 185);
   _actionMap[621][AS] = ActionEntry(REDUCE, 185);
   _actionMap[621][FROM] = ActionEntry(REDUCE, 185);
   _actionMap[621][END_TOKEN] = ActionEntry(REDUCE, 185);
   _actionMap[621][BEGIN] = ActionEntry(REDUCE, 185);
   _actionMap[621][THEN] = ActionEntry(REDUCE, 185);
   _actionMap[621][OR] = ActionEntry(REDUCE, 185);
   _actionMap[621][AND] = ActionEntry(REDUCE, 185);
   _actionMap[621][LIKE] = ActionEntry(REDUCE, 185);
   _actionMap[621][IS] = ActionEntry(REDUCE, 185);
   _actionMap[621][BETWEEN] = ActionEntry(REDUCE, 185);
   _actionMap[621][NOT] = ActionEntry(REDUCE, 185);
   _actionMap[621][INTOK] = ActionEntry(REDUCE, 185);
   _actionMap[621][EQU] = ActionEntry(REDUCE, 185);
   _actionMap[621][NEGATION] = ActionEntry(REDUCE, 185);
   _actionMap[621][LT] = ActionEntry(REDUCE, 185);
   _actionMap[621][MT] = ActionEntry(REDUCE, 185);
   _actionMap[621][DESC] = ActionEntry(REDUCE, 185);
   _actionMap[621][ASC] = ActionEntry(REDUCE, 185);
   _actionMap[621][KSEP] = ActionEntry(REDUCE, 185);
   _actionMap[621][ROWLIMIT] = ActionEntry(REDUCE, 185);
   _actionMap[621][UNION] = ActionEntry(REDUCE, 185);
   _actionMap[621][ENDTOKEN] = ActionEntry(REDUCE, 185);
   _actionMap[621][RB] = ActionEntry(REDUCE, 185);
   _actionMap[621][SEMICOLON] = ActionEntry(REDUCE, 185);
   _actionMap[621][CONCAT] = ActionEntry(REDUCE, 185);
   _actionMap[621][STAR] = ActionEntry(REDUCE, 185);
   _actionMap[621][DIVISION] = ActionEntry(REDUCE, 185);
   _actionMap[621][MINUS] = ActionEntry(REDUCE, 185);
   _actionMap[621][PLUS] = ActionEntry(REDUCE, 185);
   _actionMap[622][STRINGVAL] = ActionEntry(SHIFT, 776);
   _jumpMap[622][DateValue] = 775;
   _actionMap[623][WHEN] = ActionEntry(REDUCE, 323);
   _actionMap[623][ELSE] = ActionEntry(REDUCE, 323);
}
void Cego::loadParser109()
{
   _actionMap[623][LEFT] = ActionEntry(REDUCE, 323);
   _actionMap[623][RIGHT] = ActionEntry(REDUCE, 323);
   _actionMap[623][INNER] = ActionEntry(REDUCE, 323);
   _actionMap[623][JOIN] = ActionEntry(REDUCE, 323);
   _actionMap[623][RETURNTOKEN] = ActionEntry(REDUCE, 323);
   _actionMap[623][ORDER] = ActionEntry(REDUCE, 323);
   _actionMap[623][GROUP] = ActionEntry(REDUCE, 323);
   _actionMap[623][WHERE] = ActionEntry(REDUCE, 323);
   _actionMap[623][FROM] = ActionEntry(REDUCE, 323);
   _actionMap[623][AS] = ActionEntry(REDUCE, 323);
   _actionMap[623][END_TOKEN] = ActionEntry(REDUCE, 323);
   _actionMap[623][BEGIN] = ActionEntry(REDUCE, 323);
   _actionMap[623][THEN] = ActionEntry(REDUCE, 323);
   _actionMap[623][OR] = ActionEntry(REDUCE, 323);
   _actionMap[623][AND] = ActionEntry(REDUCE, 323);
   _actionMap[623][INTOK] = ActionEntry(REDUCE, 323);
   _actionMap[623][NOT] = ActionEntry(REDUCE, 323);
   _actionMap[623][BETWEEN] = ActionEntry(REDUCE, 323);
   _actionMap[623][IS] = ActionEntry(REDUCE, 323);
   _actionMap[623][LIKE] = ActionEntry(REDUCE, 323);
   _actionMap[623][MT] = ActionEntry(REDUCE, 323);
   _actionMap[623][LT] = ActionEntry(REDUCE, 323);
   _actionMap[623][NEGATION] = ActionEntry(REDUCE, 323);
   _actionMap[623][EQU] = ActionEntry(REDUCE, 323);
   _actionMap[623][RB] = ActionEntry(REDUCE, 323);
   _actionMap[623][ENDTOKEN] = ActionEntry(REDUCE, 323);
   _actionMap[623][UNION] = ActionEntry(REDUCE, 323);
   _actionMap[623][ROWLIMIT] = ActionEntry(REDUCE, 323);
   _actionMap[623][KSEP] = ActionEntry(REDUCE, 323);
   _actionMap[623][ASC] = ActionEntry(REDUCE, 323);
   _actionMap[623][DESC] = ActionEntry(REDUCE, 323);
   _actionMap[623][SEMICOLON] = ActionEntry(REDUCE, 323);
   _actionMap[623][PLUS] = ActionEntry(REDUCE, 323);
   _actionMap[623][MINUS] = ActionEntry(REDUCE, 323);
   _actionMap[623][DIVISION] = ActionEntry(REDUCE, 323);
   _actionMap[623][STAR] = ActionEntry(REDUCE, 323);
   _actionMap[623][CONCAT] = ActionEntry(REDUCE, 323);
   _actionMap[624][WHEN] = ActionEntry(REDUCE, 324);
   _actionMap[624][ELSE] = ActionEntry(REDUCE, 324);
   _actionMap[624][LEFT] = ActionEntry(REDUCE, 324);
   _actionMap[624][RIGHT] = ActionEntry(REDUCE, 324);
   _actionMap[624][INNER] = ActionEntry(REDUCE, 324);
   _actionMap[624][JOIN] = ActionEntry(REDUCE, 324);
   _actionMap[624][RETURNTOKEN] = ActionEntry(REDUCE, 324);
   _actionMap[624][ORDER] = ActionEntry(REDUCE, 324);
   _actionMap[624][GROUP] = ActionEntry(REDUCE, 324);
   _actionMap[624][WHERE] = ActionEntry(REDUCE, 324);
   _actionMap[624][FROM] = ActionEntry(REDUCE, 324);
   _actionMap[624][AS] = ActionEntry(REDUCE, 324);
   _actionMap[624][END_TOKEN] = ActionEntry(REDUCE, 324);
}
void Cego::loadParser110()
{
   _actionMap[624][BEGIN] = ActionEntry(REDUCE, 324);
   _actionMap[624][THEN] = ActionEntry(REDUCE, 324);
   _actionMap[624][OR] = ActionEntry(REDUCE, 324);
   _actionMap[624][AND] = ActionEntry(REDUCE, 324);
   _actionMap[624][INTOK] = ActionEntry(REDUCE, 324);
   _actionMap[624][NOT] = ActionEntry(REDUCE, 324);
   _actionMap[624][BETWEEN] = ActionEntry(REDUCE, 324);
   _actionMap[624][IS] = ActionEntry(REDUCE, 324);
   _actionMap[624][LIKE] = ActionEntry(REDUCE, 324);
   _actionMap[624][MT] = ActionEntry(REDUCE, 324);
   _actionMap[624][LT] = ActionEntry(REDUCE, 324);
   _actionMap[624][NEGATION] = ActionEntry(REDUCE, 324);
   _actionMap[624][EQU] = ActionEntry(REDUCE, 324);
   _actionMap[624][RB] = ActionEntry(REDUCE, 324);
   _actionMap[624][ENDTOKEN] = ActionEntry(REDUCE, 324);
   _actionMap[624][UNION] = ActionEntry(REDUCE, 324);
   _actionMap[624][ROWLIMIT] = ActionEntry(REDUCE, 324);
   _actionMap[624][KSEP] = ActionEntry(REDUCE, 324);
   _actionMap[624][ASC] = ActionEntry(REDUCE, 324);
   _actionMap[624][DESC] = ActionEntry(REDUCE, 324);
   _actionMap[624][SEMICOLON] = ActionEntry(REDUCE, 324);
   _actionMap[624][PLUS] = ActionEntry(REDUCE, 324);
   _actionMap[624][MINUS] = ActionEntry(REDUCE, 324);
   _actionMap[624][DIVISION] = ActionEntry(REDUCE, 324);
   _actionMap[624][STAR] = ActionEntry(REDUCE, 324);
   _actionMap[624][CONCAT] = ActionEntry(REDUCE, 324);
   _actionMap[625][WHEN] = ActionEntry(REDUCE, 342);
   _actionMap[625][ELSE] = ActionEntry(REDUCE, 342);
   _actionMap[625][LEFT] = ActionEntry(REDUCE, 342);
   _actionMap[625][RIGHT] = ActionEntry(REDUCE, 342);
   _actionMap[625][INNER] = ActionEntry(REDUCE, 342);
   _actionMap[625][JOIN] = ActionEntry(REDUCE, 342);
   _actionMap[625][RETURNTOKEN] = ActionEntry(REDUCE, 342);
   _actionMap[625][ORDER] = ActionEntry(REDUCE, 342);
   _actionMap[625][GROUP] = ActionEntry(REDUCE, 342);
   _actionMap[625][WHERE] = ActionEntry(REDUCE, 342);
   _actionMap[625][FROM] = ActionEntry(REDUCE, 342);
   _actionMap[625][AS] = ActionEntry(REDUCE, 342);
   _actionMap[625][END_TOKEN] = ActionEntry(REDUCE, 342);
   _actionMap[625][BEGIN] = ActionEntry(REDUCE, 342);
   _actionMap[625][THEN] = ActionEntry(REDUCE, 342);
   _actionMap[625][OR] = ActionEntry(REDUCE, 342);
   _actionMap[625][AND] = ActionEntry(REDUCE, 342);
   _actionMap[625][INTOK] = ActionEntry(REDUCE, 342);
   _actionMap[625][NOT] = ActionEntry(REDUCE, 342);
   _actionMap[625][BETWEEN] = ActionEntry(REDUCE, 342);
   _actionMap[625][IS] = ActionEntry(REDUCE, 342);
   _actionMap[625][LIKE] = ActionEntry(REDUCE, 342);
   _actionMap[625][MT] = ActionEntry(REDUCE, 342);
   _actionMap[625][LT] = ActionEntry(REDUCE, 342);
}
void Cego::loadParser111()
{
   _actionMap[625][NEGATION] = ActionEntry(REDUCE, 342);
   _actionMap[625][EQU] = ActionEntry(REDUCE, 342);
   _actionMap[625][RB] = ActionEntry(REDUCE, 342);
   _actionMap[625][ENDTOKEN] = ActionEntry(REDUCE, 342);
   _actionMap[625][UNION] = ActionEntry(REDUCE, 342);
   _actionMap[625][ROWLIMIT] = ActionEntry(REDUCE, 342);
   _actionMap[625][KSEP] = ActionEntry(REDUCE, 342);
   _actionMap[625][ASC] = ActionEntry(REDUCE, 342);
   _actionMap[625][DESC] = ActionEntry(REDUCE, 342);
   _actionMap[625][SEMICOLON] = ActionEntry(REDUCE, 342);
   _actionMap[625][PLUS] = ActionEntry(REDUCE, 342);
   _actionMap[625][MINUS] = ActionEntry(REDUCE, 342);
   _actionMap[625][DIVISION] = ActionEntry(REDUCE, 342);
   _actionMap[625][STAR] = ActionEntry(REDUCE, 342);
   _actionMap[625][CONCAT] = ActionEntry(REDUCE, 342);
   _actionMap[626][VARREF] = ActionEntry(SHIFT, 778);
   _jumpMap[626][FetchArgList] = 777;
   _actionMap[627][WHEN] = ActionEntry(REDUCE, 331);
   _actionMap[627][ELSE] = ActionEntry(REDUCE, 331);
   _actionMap[627][LEFT] = ActionEntry(REDUCE, 331);
   _actionMap[627][RIGHT] = ActionEntry(REDUCE, 331);
   _actionMap[627][INNER] = ActionEntry(REDUCE, 331);
   _actionMap[627][JOIN] = ActionEntry(REDUCE, 331);
   _actionMap[627][RETURNTOKEN] = ActionEntry(REDUCE, 331);
   _actionMap[627][ORDER] = ActionEntry(REDUCE, 331);
   _actionMap[627][GROUP] = ActionEntry(REDUCE, 331);
   _actionMap[627][WHERE] = ActionEntry(REDUCE, 331);
   _actionMap[627][FROM] = ActionEntry(REDUCE, 331);
   _actionMap[627][AS] = ActionEntry(REDUCE, 331);
   _actionMap[627][END_TOKEN] = ActionEntry(REDUCE, 331);
   _actionMap[627][BEGIN] = ActionEntry(REDUCE, 331);
   _actionMap[627][THEN] = ActionEntry(REDUCE, 331);
   _actionMap[627][OR] = ActionEntry(REDUCE, 331);
   _actionMap[627][AND] = ActionEntry(REDUCE, 331);
   _actionMap[627][INTOK] = ActionEntry(REDUCE, 331);
   _actionMap[627][NOT] = ActionEntry(REDUCE, 331);
   _actionMap[627][BETWEEN] = ActionEntry(REDUCE, 331);
   _actionMap[627][IS] = ActionEntry(REDUCE, 331);
   _actionMap[627][LIKE] = ActionEntry(REDUCE, 331);
   _actionMap[627][MT] = ActionEntry(REDUCE, 331);
   _actionMap[627][LT] = ActionEntry(REDUCE, 331);
   _actionMap[627][NEGATION] = ActionEntry(REDUCE, 331);
   _actionMap[627][EQU] = ActionEntry(REDUCE, 331);
   _actionMap[627][RB] = ActionEntry(REDUCE, 331);
   _actionMap[627][ENDTOKEN] = ActionEntry(REDUCE, 331);
   _actionMap[627][UNION] = ActionEntry(REDUCE, 331);
   _actionMap[627][ROWLIMIT] = ActionEntry(REDUCE, 331);
   _actionMap[627][KSEP] = ActionEntry(REDUCE, 331);
   _actionMap[627][ASC] = ActionEntry(REDUCE, 331);
   _actionMap[627][DESC] = ActionEntry(REDUCE, 331);
}
void Cego::loadParser112()
{
   _actionMap[627][SEMICOLON] = ActionEntry(REDUCE, 331);
   _actionMap[627][PLUS] = ActionEntry(REDUCE, 331);
   _actionMap[627][MINUS] = ActionEntry(REDUCE, 331);
   _actionMap[627][DIVISION] = ActionEntry(REDUCE, 331);
   _actionMap[627][STAR] = ActionEntry(REDUCE, 331);
   _actionMap[627][CONCAT] = ActionEntry(REDUCE, 331);
   _actionMap[628][WHEN] = ActionEntry(REDUCE, 325);
   _actionMap[628][ELSE] = ActionEntry(REDUCE, 325);
   _actionMap[628][LEFT] = ActionEntry(REDUCE, 325);
   _actionMap[628][RIGHT] = ActionEntry(REDUCE, 325);
   _actionMap[628][INNER] = ActionEntry(REDUCE, 325);
   _actionMap[628][JOIN] = ActionEntry(REDUCE, 325);
   _actionMap[628][RETURNTOKEN] = ActionEntry(REDUCE, 325);
   _actionMap[628][ORDER] = ActionEntry(REDUCE, 325);
   _actionMap[628][GROUP] = ActionEntry(REDUCE, 325);
   _actionMap[628][WHERE] = ActionEntry(REDUCE, 325);
   _actionMap[628][FROM] = ActionEntry(REDUCE, 325);
   _actionMap[628][AS] = ActionEntry(REDUCE, 325);
   _actionMap[628][END_TOKEN] = ActionEntry(REDUCE, 325);
   _actionMap[628][BEGIN] = ActionEntry(REDUCE, 325);
   _actionMap[628][THEN] = ActionEntry(REDUCE, 325);
   _actionMap[628][OR] = ActionEntry(REDUCE, 325);
   _actionMap[628][AND] = ActionEntry(REDUCE, 325);
   _actionMap[628][INTOK] = ActionEntry(REDUCE, 325);
   _actionMap[628][NOT] = ActionEntry(REDUCE, 325);
   _actionMap[628][BETWEEN] = ActionEntry(REDUCE, 325);
   _actionMap[628][IS] = ActionEntry(REDUCE, 325);
   _actionMap[628][LIKE] = ActionEntry(REDUCE, 325);
   _actionMap[628][MT] = ActionEntry(REDUCE, 325);
   _actionMap[628][LT] = ActionEntry(REDUCE, 325);
   _actionMap[628][NEGATION] = ActionEntry(REDUCE, 325);
   _actionMap[628][EQU] = ActionEntry(REDUCE, 325);
   _actionMap[628][RB] = ActionEntry(REDUCE, 325);
   _actionMap[628][ENDTOKEN] = ActionEntry(REDUCE, 325);
   _actionMap[628][UNION] = ActionEntry(REDUCE, 325);
   _actionMap[628][ROWLIMIT] = ActionEntry(REDUCE, 325);
   _actionMap[628][KSEP] = ActionEntry(REDUCE, 325);
   _actionMap[628][ASC] = ActionEntry(REDUCE, 325);
   _actionMap[628][DESC] = ActionEntry(REDUCE, 325);
   _actionMap[628][SEMICOLON] = ActionEntry(REDUCE, 325);
   _actionMap[628][PLUS] = ActionEntry(REDUCE, 325);
   _actionMap[628][MINUS] = ActionEntry(REDUCE, 325);
   _actionMap[628][DIVISION] = ActionEntry(REDUCE, 325);
   _actionMap[628][STAR] = ActionEntry(REDUCE, 325);
   _actionMap[628][CONCAT] = ActionEntry(REDUCE, 325);
   _actionMap[629][WHEN] = ActionEntry(REDUCE, 326);
   _actionMap[629][ELSE] = ActionEntry(REDUCE, 326);
   _actionMap[629][LEFT] = ActionEntry(REDUCE, 326);
   _actionMap[629][RIGHT] = ActionEntry(REDUCE, 326);
   _actionMap[629][INNER] = ActionEntry(REDUCE, 326);
}
void Cego::loadParser113()
{
   _actionMap[629][JOIN] = ActionEntry(REDUCE, 326);
   _actionMap[629][RETURNTOKEN] = ActionEntry(REDUCE, 326);
   _actionMap[629][ORDER] = ActionEntry(REDUCE, 326);
   _actionMap[629][GROUP] = ActionEntry(REDUCE, 326);
   _actionMap[629][WHERE] = ActionEntry(REDUCE, 326);
   _actionMap[629][FROM] = ActionEntry(REDUCE, 326);
   _actionMap[629][AS] = ActionEntry(REDUCE, 326);
   _actionMap[629][END_TOKEN] = ActionEntry(REDUCE, 326);
   _actionMap[629][BEGIN] = ActionEntry(REDUCE, 326);
   _actionMap[629][THEN] = ActionEntry(REDUCE, 326);
   _actionMap[629][OR] = ActionEntry(REDUCE, 326);
   _actionMap[629][AND] = ActionEntry(REDUCE, 326);
   _actionMap[629][INTOK] = ActionEntry(REDUCE, 326);
   _actionMap[629][NOT] = ActionEntry(REDUCE, 326);
   _actionMap[629][BETWEEN] = ActionEntry(REDUCE, 326);
   _actionMap[629][IS] = ActionEntry(REDUCE, 326);
   _actionMap[629][LIKE] = ActionEntry(REDUCE, 326);
   _actionMap[629][MT] = ActionEntry(REDUCE, 326);
   _actionMap[629][LT] = ActionEntry(REDUCE, 326);
   _actionMap[629][NEGATION] = ActionEntry(REDUCE, 326);
   _actionMap[629][EQU] = ActionEntry(REDUCE, 326);
   _actionMap[629][RB] = ActionEntry(REDUCE, 326);
   _actionMap[629][ENDTOKEN] = ActionEntry(REDUCE, 326);
   _actionMap[629][UNION] = ActionEntry(REDUCE, 326);
   _actionMap[629][ROWLIMIT] = ActionEntry(REDUCE, 326);
   _actionMap[629][KSEP] = ActionEntry(REDUCE, 326);
   _actionMap[629][ASC] = ActionEntry(REDUCE, 326);
   _actionMap[629][DESC] = ActionEntry(REDUCE, 326);
   _actionMap[629][SEMICOLON] = ActionEntry(REDUCE, 326);
   _actionMap[629][PLUS] = ActionEntry(REDUCE, 326);
   _actionMap[629][MINUS] = ActionEntry(REDUCE, 326);
   _actionMap[629][DIVISION] = ActionEntry(REDUCE, 326);
   _actionMap[629][STAR] = ActionEntry(REDUCE, 326);
   _actionMap[629][CONCAT] = ActionEntry(REDUCE, 326);
   _actionMap[630][WHEN] = ActionEntry(REDUCE, 317);
   _actionMap[630][ELSE] = ActionEntry(REDUCE, 317);
   _actionMap[630][LEFT] = ActionEntry(REDUCE, 317);
   _actionMap[630][RIGHT] = ActionEntry(REDUCE, 317);
   _actionMap[630][INNER] = ActionEntry(REDUCE, 317);
   _actionMap[630][JOIN] = ActionEntry(REDUCE, 317);
   _actionMap[630][RETURNTOKEN] = ActionEntry(REDUCE, 317);
   _actionMap[630][ORDER] = ActionEntry(REDUCE, 317);
   _actionMap[630][GROUP] = ActionEntry(REDUCE, 317);
   _actionMap[630][WHERE] = ActionEntry(REDUCE, 317);
   _actionMap[630][FROM] = ActionEntry(REDUCE, 317);
   _actionMap[630][AS] = ActionEntry(REDUCE, 317);
   _actionMap[630][END_TOKEN] = ActionEntry(REDUCE, 317);
   _actionMap[630][BEGIN] = ActionEntry(REDUCE, 317);
   _actionMap[630][THEN] = ActionEntry(REDUCE, 317);
   _actionMap[630][OR] = ActionEntry(REDUCE, 317);
}
void Cego::loadParser114()
{
   _actionMap[630][AND] = ActionEntry(REDUCE, 317);
   _actionMap[630][INTOK] = ActionEntry(REDUCE, 317);
   _actionMap[630][NOT] = ActionEntry(REDUCE, 317);
   _actionMap[630][BETWEEN] = ActionEntry(REDUCE, 317);
   _actionMap[630][IS] = ActionEntry(REDUCE, 317);
   _actionMap[630][LIKE] = ActionEntry(REDUCE, 317);
   _actionMap[630][MT] = ActionEntry(REDUCE, 317);
   _actionMap[630][LT] = ActionEntry(REDUCE, 317);
   _actionMap[630][NEGATION] = ActionEntry(REDUCE, 317);
   _actionMap[630][EQU] = ActionEntry(REDUCE, 317);
   _actionMap[630][RB] = ActionEntry(REDUCE, 317);
   _actionMap[630][ENDTOKEN] = ActionEntry(REDUCE, 317);
   _actionMap[630][UNION] = ActionEntry(REDUCE, 317);
   _actionMap[630][ROWLIMIT] = ActionEntry(REDUCE, 317);
   _actionMap[630][KSEP] = ActionEntry(REDUCE, 317);
   _actionMap[630][ASC] = ActionEntry(REDUCE, 317);
   _actionMap[630][DESC] = ActionEntry(REDUCE, 317);
   _actionMap[630][SEMICOLON] = ActionEntry(REDUCE, 317);
   _actionMap[630][PLUS] = ActionEntry(REDUCE, 317);
   _actionMap[630][MINUS] = ActionEntry(REDUCE, 317);
   _actionMap[630][DIVISION] = ActionEntry(REDUCE, 317);
   _actionMap[630][STAR] = ActionEntry(REDUCE, 317);
   _actionMap[630][CONCAT] = ActionEntry(REDUCE, 317);
   _actionMap[631][WHEN] = ActionEntry(REDUCE, 329);
   _actionMap[631][ELSE] = ActionEntry(REDUCE, 329);
   _actionMap[631][LEFT] = ActionEntry(REDUCE, 329);
   _actionMap[631][RIGHT] = ActionEntry(REDUCE, 329);
   _actionMap[631][INNER] = ActionEntry(REDUCE, 329);
   _actionMap[631][JOIN] = ActionEntry(REDUCE, 329);
   _actionMap[631][RETURNTOKEN] = ActionEntry(REDUCE, 329);
   _actionMap[631][ORDER] = ActionEntry(REDUCE, 329);
   _actionMap[631][GROUP] = ActionEntry(REDUCE, 329);
   _actionMap[631][WHERE] = ActionEntry(REDUCE, 329);
   _actionMap[631][FROM] = ActionEntry(REDUCE, 329);
   _actionMap[631][AS] = ActionEntry(REDUCE, 329);
   _actionMap[631][END_TOKEN] = ActionEntry(REDUCE, 329);
   _actionMap[631][BEGIN] = ActionEntry(REDUCE, 329);
   _actionMap[631][THEN] = ActionEntry(REDUCE, 329);
   _actionMap[631][OR] = ActionEntry(REDUCE, 329);
   _actionMap[631][AND] = ActionEntry(REDUCE, 329);
   _actionMap[631][INTOK] = ActionEntry(REDUCE, 329);
   _actionMap[631][NOT] = ActionEntry(REDUCE, 329);
   _actionMap[631][BETWEEN] = ActionEntry(REDUCE, 329);
   _actionMap[631][IS] = ActionEntry(REDUCE, 329);
   _actionMap[631][LIKE] = ActionEntry(REDUCE, 329);
   _actionMap[631][MT] = ActionEntry(REDUCE, 329);
   _actionMap[631][LT] = ActionEntry(REDUCE, 329);
   _actionMap[631][NEGATION] = ActionEntry(REDUCE, 329);
   _actionMap[631][EQU] = ActionEntry(REDUCE, 329);
   _actionMap[631][RB] = ActionEntry(REDUCE, 329);
}
void Cego::loadParser115()
{
   _actionMap[631][ENDTOKEN] = ActionEntry(REDUCE, 329);
   _actionMap[631][UNION] = ActionEntry(REDUCE, 329);
   _actionMap[631][ROWLIMIT] = ActionEntry(REDUCE, 329);
   _actionMap[631][KSEP] = ActionEntry(REDUCE, 329);
   _actionMap[631][ASC] = ActionEntry(REDUCE, 329);
   _actionMap[631][DESC] = ActionEntry(REDUCE, 329);
   _actionMap[631][SEMICOLON] = ActionEntry(REDUCE, 329);
   _actionMap[631][PLUS] = ActionEntry(REDUCE, 329);
   _actionMap[631][MINUS] = ActionEntry(REDUCE, 329);
   _actionMap[631][DIVISION] = ActionEntry(REDUCE, 329);
   _actionMap[631][STAR] = ActionEntry(REDUCE, 329);
   _actionMap[631][CONCAT] = ActionEntry(REDUCE, 329);
   _actionMap[632][WHEN] = ActionEntry(REDUCE, 334);
   _actionMap[632][ELSE] = ActionEntry(REDUCE, 334);
   _actionMap[632][LEFT] = ActionEntry(REDUCE, 334);
   _actionMap[632][RIGHT] = ActionEntry(REDUCE, 334);
   _actionMap[632][INNER] = ActionEntry(REDUCE, 334);
   _actionMap[632][JOIN] = ActionEntry(REDUCE, 334);
   _actionMap[632][RETURNTOKEN] = ActionEntry(REDUCE, 334);
   _actionMap[632][ORDER] = ActionEntry(REDUCE, 334);
   _actionMap[632][GROUP] = ActionEntry(REDUCE, 334);
   _actionMap[632][WHERE] = ActionEntry(REDUCE, 334);
   _actionMap[632][FROM] = ActionEntry(REDUCE, 334);
   _actionMap[632][AS] = ActionEntry(REDUCE, 334);
   _actionMap[632][END_TOKEN] = ActionEntry(REDUCE, 334);
   _actionMap[632][BEGIN] = ActionEntry(REDUCE, 334);
   _actionMap[632][THEN] = ActionEntry(REDUCE, 334);
   _actionMap[632][OR] = ActionEntry(REDUCE, 334);
   _actionMap[632][AND] = ActionEntry(REDUCE, 334);
   _actionMap[632][INTOK] = ActionEntry(REDUCE, 334);
   _actionMap[632][NOT] = ActionEntry(REDUCE, 334);
   _actionMap[632][BETWEEN] = ActionEntry(REDUCE, 334);
   _actionMap[632][IS] = ActionEntry(REDUCE, 334);
   _actionMap[632][LIKE] = ActionEntry(REDUCE, 334);
   _actionMap[632][MT] = ActionEntry(REDUCE, 334);
   _actionMap[632][LT] = ActionEntry(REDUCE, 334);
   _actionMap[632][NEGATION] = ActionEntry(REDUCE, 334);
   _actionMap[632][EQU] = ActionEntry(REDUCE, 334);
   _actionMap[632][RB] = ActionEntry(REDUCE, 334);
   _actionMap[632][ENDTOKEN] = ActionEntry(REDUCE, 334);
   _actionMap[632][UNION] = ActionEntry(REDUCE, 334);
   _actionMap[632][ROWLIMIT] = ActionEntry(REDUCE, 334);
   _actionMap[632][KSEP] = ActionEntry(REDUCE, 334);
   _actionMap[632][ASC] = ActionEntry(REDUCE, 334);
   _actionMap[632][DESC] = ActionEntry(REDUCE, 334);
   _actionMap[632][SEMICOLON] = ActionEntry(REDUCE, 334);
   _actionMap[632][PLUS] = ActionEntry(REDUCE, 334);
   _actionMap[632][MINUS] = ActionEntry(REDUCE, 334);
   _actionMap[632][DIVISION] = ActionEntry(REDUCE, 334);
   _actionMap[632][STAR] = ActionEntry(REDUCE, 334);
}
void Cego::loadParser116()
{
   _actionMap[632][CONCAT] = ActionEntry(REDUCE, 334);
   _actionMap[633][WHEN] = ActionEntry(REDUCE, 344);
   _actionMap[633][ELSE] = ActionEntry(REDUCE, 344);
   _actionMap[633][LEFT] = ActionEntry(REDUCE, 344);
   _actionMap[633][RIGHT] = ActionEntry(REDUCE, 344);
   _actionMap[633][INNER] = ActionEntry(REDUCE, 344);
   _actionMap[633][JOIN] = ActionEntry(REDUCE, 344);
   _actionMap[633][RETURNTOKEN] = ActionEntry(REDUCE, 344);
   _actionMap[633][ORDER] = ActionEntry(REDUCE, 344);
   _actionMap[633][GROUP] = ActionEntry(REDUCE, 344);
   _actionMap[633][WHERE] = ActionEntry(REDUCE, 344);
   _actionMap[633][FROM] = ActionEntry(REDUCE, 344);
   _actionMap[633][AS] = ActionEntry(REDUCE, 344);
   _actionMap[633][END_TOKEN] = ActionEntry(REDUCE, 344);
   _actionMap[633][BEGIN] = ActionEntry(REDUCE, 344);
   _actionMap[633][THEN] = ActionEntry(REDUCE, 344);
   _actionMap[633][OR] = ActionEntry(REDUCE, 344);
   _actionMap[633][AND] = ActionEntry(REDUCE, 344);
   _actionMap[633][INTOK] = ActionEntry(REDUCE, 344);
   _actionMap[633][NOT] = ActionEntry(REDUCE, 344);
   _actionMap[633][BETWEEN] = ActionEntry(REDUCE, 344);
   _actionMap[633][IS] = ActionEntry(REDUCE, 344);
   _actionMap[633][LIKE] = ActionEntry(REDUCE, 344);
   _actionMap[633][MT] = ActionEntry(REDUCE, 344);
   _actionMap[633][LT] = ActionEntry(REDUCE, 344);
   _actionMap[633][NEGATION] = ActionEntry(REDUCE, 344);
   _actionMap[633][EQU] = ActionEntry(REDUCE, 344);
   _actionMap[633][RB] = ActionEntry(REDUCE, 344);
   _actionMap[633][ENDTOKEN] = ActionEntry(REDUCE, 344);
   _actionMap[633][UNION] = ActionEntry(REDUCE, 344);
   _actionMap[633][ROWLIMIT] = ActionEntry(REDUCE, 344);
   _actionMap[633][KSEP] = ActionEntry(REDUCE, 344);
   _actionMap[633][ASC] = ActionEntry(REDUCE, 344);
   _actionMap[633][DESC] = ActionEntry(REDUCE, 344);
   _actionMap[633][SEMICOLON] = ActionEntry(REDUCE, 344);
   _actionMap[633][PLUS] = ActionEntry(REDUCE, 344);
   _actionMap[633][MINUS] = ActionEntry(REDUCE, 344);
   _actionMap[633][DIVISION] = ActionEntry(REDUCE, 344);
   _actionMap[633][STAR] = ActionEntry(REDUCE, 344);
   _actionMap[633][CONCAT] = ActionEntry(REDUCE, 344);
   _actionMap[634][WHEN] = ActionEntry(REDUCE, 343);
   _actionMap[634][ELSE] = ActionEntry(REDUCE, 343);
   _actionMap[634][LEFT] = ActionEntry(REDUCE, 343);
   _actionMap[634][RIGHT] = ActionEntry(REDUCE, 343);
   _actionMap[634][INNER] = ActionEntry(REDUCE, 343);
   _actionMap[634][JOIN] = ActionEntry(REDUCE, 343);
   _actionMap[634][RETURNTOKEN] = ActionEntry(REDUCE, 343);
   _actionMap[634][ORDER] = ActionEntry(REDUCE, 343);
   _actionMap[634][GROUP] = ActionEntry(REDUCE, 343);
   _actionMap[634][WHERE] = ActionEntry(REDUCE, 343);
}
void Cego::loadParser117()
{
   _actionMap[634][FROM] = ActionEntry(REDUCE, 343);
   _actionMap[634][AS] = ActionEntry(REDUCE, 343);
   _actionMap[634][END_TOKEN] = ActionEntry(REDUCE, 343);
   _actionMap[634][BEGIN] = ActionEntry(REDUCE, 343);
   _actionMap[634][THEN] = ActionEntry(REDUCE, 343);
   _actionMap[634][OR] = ActionEntry(REDUCE, 343);
   _actionMap[634][AND] = ActionEntry(REDUCE, 343);
   _actionMap[634][INTOK] = ActionEntry(REDUCE, 343);
   _actionMap[634][NOT] = ActionEntry(REDUCE, 343);
   _actionMap[634][BETWEEN] = ActionEntry(REDUCE, 343);
   _actionMap[634][IS] = ActionEntry(REDUCE, 343);
   _actionMap[634][LIKE] = ActionEntry(REDUCE, 343);
   _actionMap[634][MT] = ActionEntry(REDUCE, 343);
   _actionMap[634][LT] = ActionEntry(REDUCE, 343);
   _actionMap[634][NEGATION] = ActionEntry(REDUCE, 343);
   _actionMap[634][EQU] = ActionEntry(REDUCE, 343);
   _actionMap[634][RB] = ActionEntry(REDUCE, 343);
   _actionMap[634][ENDTOKEN] = ActionEntry(REDUCE, 343);
   _actionMap[634][UNION] = ActionEntry(REDUCE, 343);
   _actionMap[634][ROWLIMIT] = ActionEntry(REDUCE, 343);
   _actionMap[634][KSEP] = ActionEntry(REDUCE, 343);
   _actionMap[634][ASC] = ActionEntry(REDUCE, 343);
   _actionMap[634][DESC] = ActionEntry(REDUCE, 343);
   _actionMap[634][SEMICOLON] = ActionEntry(REDUCE, 343);
   _actionMap[634][PLUS] = ActionEntry(REDUCE, 343);
   _actionMap[634][MINUS] = ActionEntry(REDUCE, 343);
   _actionMap[634][DIVISION] = ActionEntry(REDUCE, 343);
   _actionMap[634][STAR] = ActionEntry(REDUCE, 343);
   _actionMap[634][CONCAT] = ActionEntry(REDUCE, 343);
   _actionMap[635][WHEN] = ActionEntry(REDUCE, 327);
   _actionMap[635][ELSE] = ActionEntry(REDUCE, 327);
   _actionMap[635][LEFT] = ActionEntry(REDUCE, 327);
   _actionMap[635][RIGHT] = ActionEntry(REDUCE, 327);
   _actionMap[635][INNER] = ActionEntry(REDUCE, 327);
   _actionMap[635][JOIN] = ActionEntry(REDUCE, 327);
   _actionMap[635][RETURNTOKEN] = ActionEntry(REDUCE, 327);
   _actionMap[635][ORDER] = ActionEntry(REDUCE, 327);
   _actionMap[635][GROUP] = ActionEntry(REDUCE, 327);
   _actionMap[635][WHERE] = ActionEntry(REDUCE, 327);
   _actionMap[635][FROM] = ActionEntry(REDUCE, 327);
   _actionMap[635][AS] = ActionEntry(REDUCE, 327);
   _actionMap[635][END_TOKEN] = ActionEntry(REDUCE, 327);
   _actionMap[635][BEGIN] = ActionEntry(REDUCE, 327);
   _actionMap[635][THEN] = ActionEntry(REDUCE, 327);
   _actionMap[635][OR] = ActionEntry(REDUCE, 327);
   _actionMap[635][AND] = ActionEntry(REDUCE, 327);
   _actionMap[635][INTOK] = ActionEntry(REDUCE, 327);
   _actionMap[635][NOT] = ActionEntry(REDUCE, 327);
   _actionMap[635][BETWEEN] = ActionEntry(REDUCE, 327);
   _actionMap[635][IS] = ActionEntry(REDUCE, 327);
}
void Cego::loadParser118()
{
   _actionMap[635][LIKE] = ActionEntry(REDUCE, 327);
   _actionMap[635][MT] = ActionEntry(REDUCE, 327);
   _actionMap[635][LT] = ActionEntry(REDUCE, 327);
   _actionMap[635][NEGATION] = ActionEntry(REDUCE, 327);
   _actionMap[635][EQU] = ActionEntry(REDUCE, 327);
   _actionMap[635][RB] = ActionEntry(REDUCE, 327);
   _actionMap[635][ENDTOKEN] = ActionEntry(REDUCE, 327);
   _actionMap[635][UNION] = ActionEntry(REDUCE, 327);
   _actionMap[635][ROWLIMIT] = ActionEntry(REDUCE, 327);
   _actionMap[635][KSEP] = ActionEntry(REDUCE, 327);
   _actionMap[635][ASC] = ActionEntry(REDUCE, 327);
   _actionMap[635][DESC] = ActionEntry(REDUCE, 327);
   _actionMap[635][SEMICOLON] = ActionEntry(REDUCE, 327);
   _actionMap[635][PLUS] = ActionEntry(REDUCE, 327);
   _actionMap[635][MINUS] = ActionEntry(REDUCE, 327);
   _actionMap[635][DIVISION] = ActionEntry(REDUCE, 327);
   _actionMap[635][STAR] = ActionEntry(REDUCE, 327);
   _actionMap[635][CONCAT] = ActionEntry(REDUCE, 327);
   _actionMap[636][WHEN] = ActionEntry(REDUCE, 321);
   _actionMap[636][ELSE] = ActionEntry(REDUCE, 321);
   _actionMap[636][LEFT] = ActionEntry(REDUCE, 321);
   _actionMap[636][RIGHT] = ActionEntry(REDUCE, 321);
   _actionMap[636][INNER] = ActionEntry(REDUCE, 321);
   _actionMap[636][JOIN] = ActionEntry(REDUCE, 321);
   _actionMap[636][RETURNTOKEN] = ActionEntry(REDUCE, 321);
   _actionMap[636][ORDER] = ActionEntry(REDUCE, 321);
   _actionMap[636][GROUP] = ActionEntry(REDUCE, 321);
   _actionMap[636][WHERE] = ActionEntry(REDUCE, 321);
   _actionMap[636][FROM] = ActionEntry(REDUCE, 321);
   _actionMap[636][AS] = ActionEntry(REDUCE, 321);
   _actionMap[636][END_TOKEN] = ActionEntry(REDUCE, 321);
   _actionMap[636][BEGIN] = ActionEntry(REDUCE, 321);
   _actionMap[636][THEN] = ActionEntry(REDUCE, 321);
   _actionMap[636][OR] = ActionEntry(REDUCE, 321);
   _actionMap[636][AND] = ActionEntry(REDUCE, 321);
   _actionMap[636][INTOK] = ActionEntry(REDUCE, 321);
   _actionMap[636][NOT] = ActionEntry(REDUCE, 321);
   _actionMap[636][BETWEEN] = ActionEntry(REDUCE, 321);
   _actionMap[636][IS] = ActionEntry(REDUCE, 321);
   _actionMap[636][LIKE] = ActionEntry(REDUCE, 321);
   _actionMap[636][MT] = ActionEntry(REDUCE, 321);
   _actionMap[636][LT] = ActionEntry(REDUCE, 321);
   _actionMap[636][NEGATION] = ActionEntry(REDUCE, 321);
   _actionMap[636][EQU] = ActionEntry(REDUCE, 321);
   _actionMap[636][RB] = ActionEntry(REDUCE, 321);
   _actionMap[636][ENDTOKEN] = ActionEntry(REDUCE, 321);
   _actionMap[636][UNION] = ActionEntry(REDUCE, 321);
   _actionMap[636][ROWLIMIT] = ActionEntry(REDUCE, 321);
   _actionMap[636][KSEP] = ActionEntry(REDUCE, 321);
   _actionMap[636][ASC] = ActionEntry(REDUCE, 321);
}
void Cego::loadParser119()
{
   _actionMap[636][DESC] = ActionEntry(REDUCE, 321);
   _actionMap[636][SEMICOLON] = ActionEntry(REDUCE, 321);
   _actionMap[636][PLUS] = ActionEntry(REDUCE, 321);
   _actionMap[636][MINUS] = ActionEntry(REDUCE, 321);
   _actionMap[636][DIVISION] = ActionEntry(REDUCE, 321);
   _actionMap[636][STAR] = ActionEntry(REDUCE, 321);
   _actionMap[636][CONCAT] = ActionEntry(REDUCE, 321);
   _actionMap[637][WHEN] = ActionEntry(REDUCE, 189);
   _actionMap[637][ELSE] = ActionEntry(REDUCE, 189);
   _actionMap[637][LEFT] = ActionEntry(REDUCE, 189);
   _actionMap[637][RIGHT] = ActionEntry(REDUCE, 189);
   _actionMap[637][INNER] = ActionEntry(REDUCE, 189);
   _actionMap[637][JOIN] = ActionEntry(REDUCE, 189);
   _actionMap[637][RETURNTOKEN] = ActionEntry(REDUCE, 189);
   _actionMap[637][ORDER] = ActionEntry(REDUCE, 189);
   _actionMap[637][GROUP] = ActionEntry(REDUCE, 189);
   _actionMap[637][WHERE] = ActionEntry(REDUCE, 189);
   _actionMap[637][AS] = ActionEntry(REDUCE, 189);
   _actionMap[637][FROM] = ActionEntry(REDUCE, 189);
   _actionMap[637][END_TOKEN] = ActionEntry(REDUCE, 189);
   _actionMap[637][BEGIN] = ActionEntry(REDUCE, 189);
   _actionMap[637][THEN] = ActionEntry(REDUCE, 189);
   _actionMap[637][OR] = ActionEntry(REDUCE, 189);
   _actionMap[637][AND] = ActionEntry(REDUCE, 189);
   _actionMap[637][LIKE] = ActionEntry(REDUCE, 189);
   _actionMap[637][IS] = ActionEntry(REDUCE, 189);
   _actionMap[637][BETWEEN] = ActionEntry(REDUCE, 189);
   _actionMap[637][NOT] = ActionEntry(REDUCE, 189);
   _actionMap[637][INTOK] = ActionEntry(REDUCE, 189);
   _actionMap[637][EQU] = ActionEntry(REDUCE, 189);
   _actionMap[637][NEGATION] = ActionEntry(REDUCE, 189);
   _actionMap[637][LT] = ActionEntry(REDUCE, 189);
   _actionMap[637][MT] = ActionEntry(REDUCE, 189);
   _actionMap[637][DESC] = ActionEntry(REDUCE, 189);
   _actionMap[637][ASC] = ActionEntry(REDUCE, 189);
   _actionMap[637][KSEP] = ActionEntry(REDUCE, 189);
   _actionMap[637][ROWLIMIT] = ActionEntry(REDUCE, 189);
   _actionMap[637][UNION] = ActionEntry(REDUCE, 189);
   _actionMap[637][ENDTOKEN] = ActionEntry(REDUCE, 189);
   _actionMap[637][RB] = ActionEntry(REDUCE, 189);
   _actionMap[637][SEMICOLON] = ActionEntry(REDUCE, 189);
   _actionMap[637][CONCAT] = ActionEntry(REDUCE, 189);
   _actionMap[637][STAR] = ActionEntry(REDUCE, 189);
   _actionMap[637][DIVISION] = ActionEntry(REDUCE, 189);
   _actionMap[637][MINUS] = ActionEntry(REDUCE, 189);
   _actionMap[637][PLUS] = ActionEntry(REDUCE, 189);
   _actionMap[638][WHEN] = ActionEntry(REDUCE, 190);
   _actionMap[638][ELSE] = ActionEntry(REDUCE, 190);
   _actionMap[638][LEFT] = ActionEntry(REDUCE, 190);
   _actionMap[638][RIGHT] = ActionEntry(REDUCE, 190);
}
void Cego::loadParser120()
{
   _actionMap[638][INNER] = ActionEntry(REDUCE, 190);
   _actionMap[638][JOIN] = ActionEntry(REDUCE, 190);
   _actionMap[638][RETURNTOKEN] = ActionEntry(REDUCE, 190);
   _actionMap[638][ORDER] = ActionEntry(REDUCE, 190);
   _actionMap[638][GROUP] = ActionEntry(REDUCE, 190);
   _actionMap[638][WHERE] = ActionEntry(REDUCE, 190);
   _actionMap[638][AS] = ActionEntry(REDUCE, 190);
   _actionMap[638][FROM] = ActionEntry(REDUCE, 190);
   _actionMap[638][END_TOKEN] = ActionEntry(REDUCE, 190);
   _actionMap[638][BEGIN] = ActionEntry(REDUCE, 190);
   _actionMap[638][THEN] = ActionEntry(REDUCE, 190);
   _actionMap[638][OR] = ActionEntry(REDUCE, 190);
   _actionMap[638][AND] = ActionEntry(REDUCE, 190);
   _actionMap[638][LIKE] = ActionEntry(REDUCE, 190);
   _actionMap[638][IS] = ActionEntry(REDUCE, 190);
   _actionMap[638][BETWEEN] = ActionEntry(REDUCE, 190);
   _actionMap[638][NOT] = ActionEntry(REDUCE, 190);
   _actionMap[638][INTOK] = ActionEntry(REDUCE, 190);
   _actionMap[638][EQU] = ActionEntry(REDUCE, 190);
   _actionMap[638][NEGATION] = ActionEntry(REDUCE, 190);
   _actionMap[638][LT] = ActionEntry(REDUCE, 190);
   _actionMap[638][MT] = ActionEntry(REDUCE, 190);
   _actionMap[638][DESC] = ActionEntry(REDUCE, 190);
   _actionMap[638][ASC] = ActionEntry(REDUCE, 190);
   _actionMap[638][KSEP] = ActionEntry(REDUCE, 190);
   _actionMap[638][ROWLIMIT] = ActionEntry(REDUCE, 190);
   _actionMap[638][UNION] = ActionEntry(REDUCE, 190);
   _actionMap[638][ENDTOKEN] = ActionEntry(REDUCE, 190);
   _actionMap[638][RB] = ActionEntry(REDUCE, 190);
   _actionMap[638][SEMICOLON] = ActionEntry(REDUCE, 190);
   _actionMap[638][CONCAT] = ActionEntry(REDUCE, 190);
   _actionMap[638][STAR] = ActionEntry(REDUCE, 190);
   _actionMap[638][DIVISION] = ActionEntry(REDUCE, 190);
   _actionMap[638][MINUS] = ActionEntry(REDUCE, 190);
   _actionMap[638][PLUS] = ActionEntry(REDUCE, 190);
   _actionMap[639][WHEN] = ActionEntry(REDUCE, 341);
   _actionMap[639][ELSE] = ActionEntry(REDUCE, 341);
   _actionMap[639][LEFT] = ActionEntry(REDUCE, 341);
   _actionMap[639][RIGHT] = ActionEntry(REDUCE, 341);
   _actionMap[639][INNER] = ActionEntry(REDUCE, 341);
   _actionMap[639][JOIN] = ActionEntry(REDUCE, 341);
   _actionMap[639][RETURNTOKEN] = ActionEntry(REDUCE, 341);
   _actionMap[639][ORDER] = ActionEntry(REDUCE, 341);
   _actionMap[639][GROUP] = ActionEntry(REDUCE, 341);
   _actionMap[639][WHERE] = ActionEntry(REDUCE, 341);
   _actionMap[639][FROM] = ActionEntry(REDUCE, 341);
   _actionMap[639][AS] = ActionEntry(REDUCE, 341);
   _actionMap[639][END_TOKEN] = ActionEntry(REDUCE, 341);
   _actionMap[639][BEGIN] = ActionEntry(REDUCE, 341);
   _actionMap[639][THEN] = ActionEntry(REDUCE, 341);
}
void Cego::loadParser121()
{
   _actionMap[639][OR] = ActionEntry(REDUCE, 341);
   _actionMap[639][AND] = ActionEntry(REDUCE, 341);
   _actionMap[639][INTOK] = ActionEntry(REDUCE, 341);
   _actionMap[639][NOT] = ActionEntry(REDUCE, 341);
   _actionMap[639][BETWEEN] = ActionEntry(REDUCE, 341);
   _actionMap[639][IS] = ActionEntry(REDUCE, 341);
   _actionMap[639][LIKE] = ActionEntry(REDUCE, 341);
   _actionMap[639][MT] = ActionEntry(REDUCE, 341);
   _actionMap[639][LT] = ActionEntry(REDUCE, 341);
   _actionMap[639][NEGATION] = ActionEntry(REDUCE, 341);
   _actionMap[639][EQU] = ActionEntry(REDUCE, 341);
   _actionMap[639][RB] = ActionEntry(REDUCE, 341);
   _actionMap[639][ENDTOKEN] = ActionEntry(REDUCE, 341);
   _actionMap[639][UNION] = ActionEntry(REDUCE, 341);
   _actionMap[639][ROWLIMIT] = ActionEntry(REDUCE, 341);
   _actionMap[639][KSEP] = ActionEntry(REDUCE, 341);
   _actionMap[639][ASC] = ActionEntry(REDUCE, 341);
   _actionMap[639][DESC] = ActionEntry(REDUCE, 341);
   _actionMap[639][SEMICOLON] = ActionEntry(REDUCE, 341);
   _actionMap[639][PLUS] = ActionEntry(REDUCE, 341);
   _actionMap[639][MINUS] = ActionEntry(REDUCE, 341);
   _actionMap[639][DIVISION] = ActionEntry(REDUCE, 341);
   _actionMap[639][STAR] = ActionEntry(REDUCE, 341);
   _actionMap[639][CONCAT] = ActionEntry(REDUCE, 341);
   _actionMap[640][WHEN] = ActionEntry(REDUCE, 354);
   _actionMap[640][ELSE] = ActionEntry(REDUCE, 354);
   _actionMap[640][LEFT] = ActionEntry(REDUCE, 354);
   _actionMap[640][RIGHT] = ActionEntry(REDUCE, 354);
   _actionMap[640][INNER] = ActionEntry(REDUCE, 354);
   _actionMap[640][JOIN] = ActionEntry(REDUCE, 354);
   _actionMap[640][RETURNTOKEN] = ActionEntry(REDUCE, 354);
   _actionMap[640][ORDER] = ActionEntry(REDUCE, 354);
   _actionMap[640][GROUP] = ActionEntry(REDUCE, 354);
   _actionMap[640][WHERE] = ActionEntry(REDUCE, 354);
   _actionMap[640][FROM] = ActionEntry(REDUCE, 354);
   _actionMap[640][AS] = ActionEntry(REDUCE, 354);
   _actionMap[640][END_TOKEN] = ActionEntry(REDUCE, 354);
   _actionMap[640][BEGIN] = ActionEntry(REDUCE, 354);
   _actionMap[640][THEN] = ActionEntry(REDUCE, 354);
   _actionMap[640][OR] = ActionEntry(REDUCE, 354);
   _actionMap[640][AND] = ActionEntry(REDUCE, 354);
   _actionMap[640][INTOK] = ActionEntry(REDUCE, 354);
   _actionMap[640][NOT] = ActionEntry(REDUCE, 354);
   _actionMap[640][BETWEEN] = ActionEntry(REDUCE, 354);
   _actionMap[640][IS] = ActionEntry(REDUCE, 354);
   _actionMap[640][LIKE] = ActionEntry(REDUCE, 354);
   _actionMap[640][MT] = ActionEntry(REDUCE, 354);
   _actionMap[640][LT] = ActionEntry(REDUCE, 354);
   _actionMap[640][NEGATION] = ActionEntry(REDUCE, 354);
   _actionMap[640][EQU] = ActionEntry(REDUCE, 354);
}
void Cego::loadParser122()
{
   _actionMap[640][RB] = ActionEntry(REDUCE, 354);
   _actionMap[640][ENDTOKEN] = ActionEntry(REDUCE, 354);
   _actionMap[640][UNION] = ActionEntry(REDUCE, 354);
   _actionMap[640][ROWLIMIT] = ActionEntry(REDUCE, 354);
   _actionMap[640][KSEP] = ActionEntry(REDUCE, 354);
   _actionMap[640][ASC] = ActionEntry(REDUCE, 354);
   _actionMap[640][DESC] = ActionEntry(REDUCE, 354);
   _actionMap[640][SEMICOLON] = ActionEntry(REDUCE, 354);
   _actionMap[640][PLUS] = ActionEntry(REDUCE, 354);
   _actionMap[640][MINUS] = ActionEntry(REDUCE, 354);
   _actionMap[640][DIVISION] = ActionEntry(REDUCE, 354);
   _actionMap[640][STAR] = ActionEntry(REDUCE, 354);
   _actionMap[640][CONCAT] = ActionEntry(REDUCE, 354);
   _actionMap[641][WHEN] = ActionEntry(REDUCE, 345);
   _actionMap[641][ELSE] = ActionEntry(REDUCE, 345);
   _actionMap[641][LEFT] = ActionEntry(REDUCE, 345);
   _actionMap[641][RIGHT] = ActionEntry(REDUCE, 345);
   _actionMap[641][INNER] = ActionEntry(REDUCE, 345);
   _actionMap[641][JOIN] = ActionEntry(REDUCE, 345);
   _actionMap[641][RETURNTOKEN] = ActionEntry(REDUCE, 345);
   _actionMap[641][ORDER] = ActionEntry(REDUCE, 345);
   _actionMap[641][GROUP] = ActionEntry(REDUCE, 345);
   _actionMap[641][WHERE] = ActionEntry(REDUCE, 345);
   _actionMap[641][FROM] = ActionEntry(REDUCE, 345);
   _actionMap[641][AS] = ActionEntry(REDUCE, 345);
   _actionMap[641][END_TOKEN] = ActionEntry(REDUCE, 345);
   _actionMap[641][BEGIN] = ActionEntry(REDUCE, 345);
   _actionMap[641][THEN] = ActionEntry(REDUCE, 345);
   _actionMap[641][OR] = ActionEntry(REDUCE, 345);
   _actionMap[641][AND] = ActionEntry(REDUCE, 345);
   _actionMap[641][INTOK] = ActionEntry(REDUCE, 345);
   _actionMap[641][NOT] = ActionEntry(REDUCE, 345);
   _actionMap[641][BETWEEN] = ActionEntry(REDUCE, 345);
   _actionMap[641][IS] = ActionEntry(REDUCE, 345);
   _actionMap[641][LIKE] = ActionEntry(REDUCE, 345);
   _actionMap[641][MT] = ActionEntry(REDUCE, 345);
   _actionMap[641][LT] = ActionEntry(REDUCE, 345);
   _actionMap[641][NEGATION] = ActionEntry(REDUCE, 345);
   _actionMap[641][EQU] = ActionEntry(REDUCE, 345);
   _actionMap[641][RB] = ActionEntry(REDUCE, 345);
   _actionMap[641][ENDTOKEN] = ActionEntry(REDUCE, 345);
   _actionMap[641][UNION] = ActionEntry(REDUCE, 345);
   _actionMap[641][ROWLIMIT] = ActionEntry(REDUCE, 345);
   _actionMap[641][KSEP] = ActionEntry(REDUCE, 345);
   _actionMap[641][ASC] = ActionEntry(REDUCE, 345);
   _actionMap[641][DESC] = ActionEntry(REDUCE, 345);
   _actionMap[641][SEMICOLON] = ActionEntry(REDUCE, 345);
   _actionMap[641][PLUS] = ActionEntry(REDUCE, 345);
   _actionMap[641][MINUS] = ActionEntry(REDUCE, 345);
   _actionMap[641][DIVISION] = ActionEntry(REDUCE, 345);
}
void Cego::loadParser123()
{
   _actionMap[641][STAR] = ActionEntry(REDUCE, 345);
   _actionMap[641][CONCAT] = ActionEntry(REDUCE, 345);
   _actionMap[642][WHEN] = ActionEntry(REDUCE, 339);
   _actionMap[642][ELSE] = ActionEntry(REDUCE, 339);
   _actionMap[642][LEFT] = ActionEntry(REDUCE, 339);
   _actionMap[642][RIGHT] = ActionEntry(REDUCE, 339);
   _actionMap[642][INNER] = ActionEntry(REDUCE, 339);
   _actionMap[642][JOIN] = ActionEntry(REDUCE, 339);
   _actionMap[642][RETURNTOKEN] = ActionEntry(REDUCE, 339);
   _actionMap[642][ORDER] = ActionEntry(REDUCE, 339);
   _actionMap[642][GROUP] = ActionEntry(REDUCE, 339);
   _actionMap[642][WHERE] = ActionEntry(REDUCE, 339);
   _actionMap[642][FROM] = ActionEntry(REDUCE, 339);
   _actionMap[642][AS] = ActionEntry(REDUCE, 339);
   _actionMap[642][END_TOKEN] = ActionEntry(REDUCE, 339);
   _actionMap[642][BEGIN] = ActionEntry(REDUCE, 339);
   _actionMap[642][THEN] = ActionEntry(REDUCE, 339);
   _actionMap[642][OR] = ActionEntry(REDUCE, 339);
   _actionMap[642][AND] = ActionEntry(REDUCE, 339);
   _actionMap[642][INTOK] = ActionEntry(REDUCE, 339);
   _actionMap[642][NOT] = ActionEntry(REDUCE, 339);
   _actionMap[642][BETWEEN] = ActionEntry(REDUCE, 339);
   _actionMap[642][IS] = ActionEntry(REDUCE, 339);
   _actionMap[642][LIKE] = ActionEntry(REDUCE, 339);
   _actionMap[642][MT] = ActionEntry(REDUCE, 339);
   _actionMap[642][LT] = ActionEntry(REDUCE, 339);
   _actionMap[642][NEGATION] = ActionEntry(REDUCE, 339);
   _actionMap[642][EQU] = ActionEntry(REDUCE, 339);
   _actionMap[642][RB] = ActionEntry(REDUCE, 339);
   _actionMap[642][ENDTOKEN] = ActionEntry(REDUCE, 339);
   _actionMap[642][UNION] = ActionEntry(REDUCE, 339);
   _actionMap[642][ROWLIMIT] = ActionEntry(REDUCE, 339);
   _actionMap[642][KSEP] = ActionEntry(REDUCE, 339);
   _actionMap[642][ASC] = ActionEntry(REDUCE, 339);
   _actionMap[642][DESC] = ActionEntry(REDUCE, 339);
   _actionMap[642][SEMICOLON] = ActionEntry(REDUCE, 339);
   _actionMap[642][PLUS] = ActionEntry(REDUCE, 339);
   _actionMap[642][MINUS] = ActionEntry(REDUCE, 339);
   _actionMap[642][DIVISION] = ActionEntry(REDUCE, 339);
   _actionMap[642][STAR] = ActionEntry(REDUCE, 339);
   _actionMap[642][CONCAT] = ActionEntry(REDUCE, 339);
   _actionMap[643][WHEN] = ActionEntry(REDUCE, 340);
   _actionMap[643][ELSE] = ActionEntry(REDUCE, 340);
   _actionMap[643][LEFT] = ActionEntry(REDUCE, 340);
   _actionMap[643][RIGHT] = ActionEntry(REDUCE, 340);
   _actionMap[643][INNER] = ActionEntry(REDUCE, 340);
   _actionMap[643][JOIN] = ActionEntry(REDUCE, 340);
   _actionMap[643][RETURNTOKEN] = ActionEntry(REDUCE, 340);
   _actionMap[643][ORDER] = ActionEntry(REDUCE, 340);
   _actionMap[643][GROUP] = ActionEntry(REDUCE, 340);
}
void Cego::loadParser124()
{
   _actionMap[643][WHERE] = ActionEntry(REDUCE, 340);
   _actionMap[643][FROM] = ActionEntry(REDUCE, 340);
   _actionMap[643][AS] = ActionEntry(REDUCE, 340);
   _actionMap[643][END_TOKEN] = ActionEntry(REDUCE, 340);
   _actionMap[643][BEGIN] = ActionEntry(REDUCE, 340);
   _actionMap[643][THEN] = ActionEntry(REDUCE, 340);
   _actionMap[643][OR] = ActionEntry(REDUCE, 340);
   _actionMap[643][AND] = ActionEntry(REDUCE, 340);
   _actionMap[643][INTOK] = ActionEntry(REDUCE, 340);
   _actionMap[643][NOT] = ActionEntry(REDUCE, 340);
   _actionMap[643][BETWEEN] = ActionEntry(REDUCE, 340);
   _actionMap[643][IS] = ActionEntry(REDUCE, 340);
   _actionMap[643][LIKE] = ActionEntry(REDUCE, 340);
   _actionMap[643][MT] = ActionEntry(REDUCE, 340);
   _actionMap[643][LT] = ActionEntry(REDUCE, 340);
   _actionMap[643][NEGATION] = ActionEntry(REDUCE, 340);
   _actionMap[643][EQU] = ActionEntry(REDUCE, 340);
   _actionMap[643][RB] = ActionEntry(REDUCE, 340);
   _actionMap[643][ENDTOKEN] = ActionEntry(REDUCE, 340);
   _actionMap[643][UNION] = ActionEntry(REDUCE, 340);
   _actionMap[643][ROWLIMIT] = ActionEntry(REDUCE, 340);
   _actionMap[643][KSEP] = ActionEntry(REDUCE, 340);
   _actionMap[643][ASC] = ActionEntry(REDUCE, 340);
   _actionMap[643][DESC] = ActionEntry(REDUCE, 340);
   _actionMap[643][SEMICOLON] = ActionEntry(REDUCE, 340);
   _actionMap[643][PLUS] = ActionEntry(REDUCE, 340);
   _actionMap[643][MINUS] = ActionEntry(REDUCE, 340);
   _actionMap[643][DIVISION] = ActionEntry(REDUCE, 340);
   _actionMap[643][STAR] = ActionEntry(REDUCE, 340);
   _actionMap[643][CONCAT] = ActionEntry(REDUCE, 340);
   _actionMap[644][WHEN] = ActionEntry(REDUCE, 333);
   _actionMap[644][ELSE] = ActionEntry(REDUCE, 333);
   _actionMap[644][LEFT] = ActionEntry(REDUCE, 333);
   _actionMap[644][RIGHT] = ActionEntry(REDUCE, 333);
   _actionMap[644][INNER] = ActionEntry(REDUCE, 333);
   _actionMap[644][JOIN] = ActionEntry(REDUCE, 333);
   _actionMap[644][RETURNTOKEN] = ActionEntry(REDUCE, 333);
   _actionMap[644][ORDER] = ActionEntry(REDUCE, 333);
   _actionMap[644][GROUP] = ActionEntry(REDUCE, 333);
   _actionMap[644][WHERE] = ActionEntry(REDUCE, 333);
   _actionMap[644][FROM] = ActionEntry(REDUCE, 333);
   _actionMap[644][AS] = ActionEntry(REDUCE, 333);
   _actionMap[644][END_TOKEN] = ActionEntry(REDUCE, 333);
   _actionMap[644][BEGIN] = ActionEntry(REDUCE, 333);
   _actionMap[644][THEN] = ActionEntry(REDUCE, 333);
   _actionMap[644][OR] = ActionEntry(REDUCE, 333);
   _actionMap[644][AND] = ActionEntry(REDUCE, 333);
   _actionMap[644][INTOK] = ActionEntry(REDUCE, 333);
   _actionMap[644][NOT] = ActionEntry(REDUCE, 333);
   _actionMap[644][BETWEEN] = ActionEntry(REDUCE, 333);
}
void Cego::loadParser125()
{
   _actionMap[644][IS] = ActionEntry(REDUCE, 333);
   _actionMap[644][LIKE] = ActionEntry(REDUCE, 333);
   _actionMap[644][MT] = ActionEntry(REDUCE, 333);
   _actionMap[644][LT] = ActionEntry(REDUCE, 333);
   _actionMap[644][NEGATION] = ActionEntry(REDUCE, 333);
   _actionMap[644][EQU] = ActionEntry(REDUCE, 333);
   _actionMap[644][RB] = ActionEntry(REDUCE, 333);
   _actionMap[644][ENDTOKEN] = ActionEntry(REDUCE, 333);
   _actionMap[644][UNION] = ActionEntry(REDUCE, 333);
   _actionMap[644][ROWLIMIT] = ActionEntry(REDUCE, 333);
   _actionMap[644][KSEP] = ActionEntry(REDUCE, 333);
   _actionMap[644][ASC] = ActionEntry(REDUCE, 333);
   _actionMap[644][DESC] = ActionEntry(REDUCE, 333);
   _actionMap[644][SEMICOLON] = ActionEntry(REDUCE, 333);
   _actionMap[644][PLUS] = ActionEntry(REDUCE, 333);
   _actionMap[644][MINUS] = ActionEntry(REDUCE, 333);
   _actionMap[644][DIVISION] = ActionEntry(REDUCE, 333);
   _actionMap[644][STAR] = ActionEntry(REDUCE, 333);
   _actionMap[644][CONCAT] = ActionEntry(REDUCE, 333);
   _actionMap[645][WHEN] = ActionEntry(REDUCE, 330);
   _actionMap[645][ELSE] = ActionEntry(REDUCE, 330);
   _actionMap[645][LEFT] = ActionEntry(REDUCE, 330);
   _actionMap[645][RIGHT] = ActionEntry(REDUCE, 330);
   _actionMap[645][INNER] = ActionEntry(REDUCE, 330);
   _actionMap[645][JOIN] = ActionEntry(REDUCE, 330);
   _actionMap[645][RETURNTOKEN] = ActionEntry(REDUCE, 330);
   _actionMap[645][ORDER] = ActionEntry(REDUCE, 330);
   _actionMap[645][GROUP] = ActionEntry(REDUCE, 330);
   _actionMap[645][WHERE] = ActionEntry(REDUCE, 330);
   _actionMap[645][FROM] = ActionEntry(REDUCE, 330);
   _actionMap[645][AS] = ActionEntry(REDUCE, 330);
   _actionMap[645][END_TOKEN] = ActionEntry(REDUCE, 330);
   _actionMap[645][BEGIN] = ActionEntry(REDUCE, 330);
   _actionMap[645][THEN] = ActionEntry(REDUCE, 330);
   _actionMap[645][OR] = ActionEntry(REDUCE, 330);
   _actionMap[645][AND] = ActionEntry(REDUCE, 330);
   _actionMap[645][INTOK] = ActionEntry(REDUCE, 330);
   _actionMap[645][NOT] = ActionEntry(REDUCE, 330);
   _actionMap[645][BETWEEN] = ActionEntry(REDUCE, 330);
   _actionMap[645][IS] = ActionEntry(REDUCE, 330);
   _actionMap[645][LIKE] = ActionEntry(REDUCE, 330);
   _actionMap[645][MT] = ActionEntry(REDUCE, 330);
   _actionMap[645][LT] = ActionEntry(REDUCE, 330);
   _actionMap[645][NEGATION] = ActionEntry(REDUCE, 330);
   _actionMap[645][EQU] = ActionEntry(REDUCE, 330);
   _actionMap[645][RB] = ActionEntry(REDUCE, 330);
   _actionMap[645][ENDTOKEN] = ActionEntry(REDUCE, 330);
   _actionMap[645][UNION] = ActionEntry(REDUCE, 330);
   _actionMap[645][ROWLIMIT] = ActionEntry(REDUCE, 330);
   _actionMap[645][KSEP] = ActionEntry(REDUCE, 330);
}
void Cego::loadParser126()
{
   _actionMap[645][ASC] = ActionEntry(REDUCE, 330);
   _actionMap[645][DESC] = ActionEntry(REDUCE, 330);
   _actionMap[645][SEMICOLON] = ActionEntry(REDUCE, 330);
   _actionMap[645][PLUS] = ActionEntry(REDUCE, 330);
   _actionMap[645][MINUS] = ActionEntry(REDUCE, 330);
   _actionMap[645][DIVISION] = ActionEntry(REDUCE, 330);
   _actionMap[645][STAR] = ActionEntry(REDUCE, 330);
   _actionMap[645][CONCAT] = ActionEntry(REDUCE, 330);
   _actionMap[646][WHEN] = ActionEntry(REDUCE, 322);
   _actionMap[646][ELSE] = ActionEntry(REDUCE, 322);
   _actionMap[646][LEFT] = ActionEntry(REDUCE, 322);
   _actionMap[646][RIGHT] = ActionEntry(REDUCE, 322);
   _actionMap[646][INNER] = ActionEntry(REDUCE, 322);
   _actionMap[646][JOIN] = ActionEntry(REDUCE, 322);
   _actionMap[646][RETURNTOKEN] = ActionEntry(REDUCE, 322);
   _actionMap[646][ORDER] = ActionEntry(REDUCE, 322);
   _actionMap[646][GROUP] = ActionEntry(REDUCE, 322);
   _actionMap[646][WHERE] = ActionEntry(REDUCE, 322);
   _actionMap[646][FROM] = ActionEntry(REDUCE, 322);
   _actionMap[646][AS] = ActionEntry(REDUCE, 322);
   _actionMap[646][END_TOKEN] = ActionEntry(REDUCE, 322);
   _actionMap[646][BEGIN] = ActionEntry(REDUCE, 322);
   _actionMap[646][THEN] = ActionEntry(REDUCE, 322);
   _actionMap[646][OR] = ActionEntry(REDUCE, 322);
   _actionMap[646][AND] = ActionEntry(REDUCE, 322);
   _actionMap[646][INTOK] = ActionEntry(REDUCE, 322);
   _actionMap[646][NOT] = ActionEntry(REDUCE, 322);
   _actionMap[646][BETWEEN] = ActionEntry(REDUCE, 322);
   _actionMap[646][IS] = ActionEntry(REDUCE, 322);
   _actionMap[646][LIKE] = ActionEntry(REDUCE, 322);
   _actionMap[646][MT] = ActionEntry(REDUCE, 322);
   _actionMap[646][LT] = ActionEntry(REDUCE, 322);
   _actionMap[646][NEGATION] = ActionEntry(REDUCE, 322);
   _actionMap[646][EQU] = ActionEntry(REDUCE, 322);
   _actionMap[646][RB] = ActionEntry(REDUCE, 322);
   _actionMap[646][ENDTOKEN] = ActionEntry(REDUCE, 322);
   _actionMap[646][UNION] = ActionEntry(REDUCE, 322);
   _actionMap[646][ROWLIMIT] = ActionEntry(REDUCE, 322);
   _actionMap[646][KSEP] = ActionEntry(REDUCE, 322);
   _actionMap[646][ASC] = ActionEntry(REDUCE, 322);
   _actionMap[646][DESC] = ActionEntry(REDUCE, 322);
   _actionMap[646][SEMICOLON] = ActionEntry(REDUCE, 322);
   _actionMap[646][PLUS] = ActionEntry(REDUCE, 322);
   _actionMap[646][MINUS] = ActionEntry(REDUCE, 322);
   _actionMap[646][DIVISION] = ActionEntry(REDUCE, 322);
   _actionMap[646][STAR] = ActionEntry(REDUCE, 322);
   _actionMap[646][CONCAT] = ActionEntry(REDUCE, 322);
   _actionMap[647][WHEN] = ActionEntry(REDUCE, 320);
   _actionMap[647][ELSE] = ActionEntry(REDUCE, 320);
   _actionMap[647][LEFT] = ActionEntry(REDUCE, 320);
}
void Cego::loadParser127()
{
   _actionMap[647][RIGHT] = ActionEntry(REDUCE, 320);
   _actionMap[647][INNER] = ActionEntry(REDUCE, 320);
   _actionMap[647][JOIN] = ActionEntry(REDUCE, 320);
   _actionMap[647][RETURNTOKEN] = ActionEntry(REDUCE, 320);
   _actionMap[647][ORDER] = ActionEntry(REDUCE, 320);
   _actionMap[647][GROUP] = ActionEntry(REDUCE, 320);
   _actionMap[647][WHERE] = ActionEntry(REDUCE, 320);
   _actionMap[647][FROM] = ActionEntry(REDUCE, 320);
   _actionMap[647][AS] = ActionEntry(REDUCE, 320);
   _actionMap[647][END_TOKEN] = ActionEntry(REDUCE, 320);
   _actionMap[647][BEGIN] = ActionEntry(REDUCE, 320);
   _actionMap[647][THEN] = ActionEntry(REDUCE, 320);
   _actionMap[647][OR] = ActionEntry(REDUCE, 320);
   _actionMap[647][AND] = ActionEntry(REDUCE, 320);
   _actionMap[647][INTOK] = ActionEntry(REDUCE, 320);
   _actionMap[647][NOT] = ActionEntry(REDUCE, 320);
   _actionMap[647][BETWEEN] = ActionEntry(REDUCE, 320);
   _actionMap[647][IS] = ActionEntry(REDUCE, 320);
   _actionMap[647][LIKE] = ActionEntry(REDUCE, 320);
   _actionMap[647][MT] = ActionEntry(REDUCE, 320);
   _actionMap[647][LT] = ActionEntry(REDUCE, 320);
   _actionMap[647][NEGATION] = ActionEntry(REDUCE, 320);
   _actionMap[647][EQU] = ActionEntry(REDUCE, 320);
   _actionMap[647][RB] = ActionEntry(REDUCE, 320);
   _actionMap[647][ENDTOKEN] = ActionEntry(REDUCE, 320);
   _actionMap[647][UNION] = ActionEntry(REDUCE, 320);
   _actionMap[647][ROWLIMIT] = ActionEntry(REDUCE, 320);
   _actionMap[647][KSEP] = ActionEntry(REDUCE, 320);
   _actionMap[647][ASC] = ActionEntry(REDUCE, 320);
   _actionMap[647][DESC] = ActionEntry(REDUCE, 320);
   _actionMap[647][SEMICOLON] = ActionEntry(REDUCE, 320);
   _actionMap[647][PLUS] = ActionEntry(REDUCE, 320);
   _actionMap[647][MINUS] = ActionEntry(REDUCE, 320);
   _actionMap[647][DIVISION] = ActionEntry(REDUCE, 320);
   _actionMap[647][STAR] = ActionEntry(REDUCE, 320);
   _actionMap[647][CONCAT] = ActionEntry(REDUCE, 320);
   _actionMap[648][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[648][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[648][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[648][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[648][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[648][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[648][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[648][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[648][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[648][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[648][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[648][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[648][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[648][LOWER] = ActionEntry(SHIFT, 151);
}
void Cego::loadParser128()
{
   _actionMap[648][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[648][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[648][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[648][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[648][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[648][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[648][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[648][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[648][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[648][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[648][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[648][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[648][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[648][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[648][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[648][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[648][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[648][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[648][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[648][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[648][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[648][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[648][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[648][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[648][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[648][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[648][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[648][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[648][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[648][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[648][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[648][LB] = ActionEntry(SHIFT, 176);
   _actionMap[648][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[648][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[648][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[648][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[648][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[648][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[648][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[648][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[648][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[648][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[648][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[648][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[648][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[648][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[648][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[648][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[648][MAX] = ActionEntry(SHIFT, 154);
   _jumpMap[648][ObjSpec] = 121;
}
void Cego::loadParser129()
{
   _jumpMap[648][Constant] = 120;
   _jumpMap[648][SignedFloat] = 119;
   _jumpMap[648][SignedInt] = 118;
   _jumpMap[648][Attribute] = 117;
   _jumpMap[648][Function] = 116;
   _jumpMap[648][CasePrepare] = 115;
   _jumpMap[648][CaseClause] = 114;
   _jumpMap[648][Factor] = 113;
   _jumpMap[648][Term] = 112;
   _jumpMap[648][Expr] = 779;
   _actionMap[649][WHEN] = ActionEntry(REDUCE, 332);
   _actionMap[649][ELSE] = ActionEntry(REDUCE, 332);
   _actionMap[649][LEFT] = ActionEntry(REDUCE, 332);
   _actionMap[649][RIGHT] = ActionEntry(REDUCE, 332);
   _actionMap[649][INNER] = ActionEntry(REDUCE, 332);
   _actionMap[649][JOIN] = ActionEntry(REDUCE, 332);
   _actionMap[649][RETURNTOKEN] = ActionEntry(REDUCE, 332);
   _actionMap[649][ORDER] = ActionEntry(REDUCE, 332);
   _actionMap[649][GROUP] = ActionEntry(REDUCE, 332);
   _actionMap[649][WHERE] = ActionEntry(REDUCE, 332);
   _actionMap[649][FROM] = ActionEntry(REDUCE, 332);
   _actionMap[649][AS] = ActionEntry(REDUCE, 332);
   _actionMap[649][END_TOKEN] = ActionEntry(REDUCE, 332);
   _actionMap[649][BEGIN] = ActionEntry(REDUCE, 332);
   _actionMap[649][THEN] = ActionEntry(REDUCE, 332);
   _actionMap[649][OR] = ActionEntry(REDUCE, 332);
   _actionMap[649][AND] = ActionEntry(REDUCE, 332);
   _actionMap[649][INTOK] = ActionEntry(REDUCE, 332);
   _actionMap[649][NOT] = ActionEntry(REDUCE, 332);
   _actionMap[649][BETWEEN] = ActionEntry(REDUCE, 332);
   _actionMap[649][IS] = ActionEntry(REDUCE, 332);
   _actionMap[649][LIKE] = ActionEntry(REDUCE, 332);
   _actionMap[649][MT] = ActionEntry(REDUCE, 332);
   _actionMap[649][LT] = ActionEntry(REDUCE, 332);
   _actionMap[649][NEGATION] = ActionEntry(REDUCE, 332);
   _actionMap[649][EQU] = ActionEntry(REDUCE, 332);
   _actionMap[649][RB] = ActionEntry(REDUCE, 332);
   _actionMap[649][ENDTOKEN] = ActionEntry(REDUCE, 332);
   _actionMap[649][UNION] = ActionEntry(REDUCE, 332);
   _actionMap[649][ROWLIMIT] = ActionEntry(REDUCE, 332);
   _actionMap[649][KSEP] = ActionEntry(REDUCE, 332);
   _actionMap[649][ASC] = ActionEntry(REDUCE, 332);
   _actionMap[649][DESC] = ActionEntry(REDUCE, 332);
   _actionMap[649][SEMICOLON] = ActionEntry(REDUCE, 332);
   _actionMap[649][PLUS] = ActionEntry(REDUCE, 332);
   _actionMap[649][MINUS] = ActionEntry(REDUCE, 332);
   _actionMap[649][DIVISION] = ActionEntry(REDUCE, 332);
   _actionMap[649][STAR] = ActionEntry(REDUCE, 332);
   _actionMap[649][CONCAT] = ActionEntry(REDUCE, 332);
   _actionMap[650][WHEN] = ActionEntry(REDUCE, 186);
}
void Cego::loadParser130()
{
   _actionMap[650][ELSE] = ActionEntry(REDUCE, 186);
   _actionMap[650][LEFT] = ActionEntry(REDUCE, 186);
   _actionMap[650][RIGHT] = ActionEntry(REDUCE, 186);
   _actionMap[650][INNER] = ActionEntry(REDUCE, 186);
   _actionMap[650][JOIN] = ActionEntry(REDUCE, 186);
   _actionMap[650][RETURNTOKEN] = ActionEntry(REDUCE, 186);
   _actionMap[650][ORDER] = ActionEntry(REDUCE, 186);
   _actionMap[650][GROUP] = ActionEntry(REDUCE, 186);
   _actionMap[650][WHERE] = ActionEntry(REDUCE, 186);
   _actionMap[650][AS] = ActionEntry(REDUCE, 186);
   _actionMap[650][FROM] = ActionEntry(REDUCE, 186);
   _actionMap[650][END_TOKEN] = ActionEntry(REDUCE, 186);
   _actionMap[650][BEGIN] = ActionEntry(REDUCE, 186);
   _actionMap[650][THEN] = ActionEntry(REDUCE, 186);
   _actionMap[650][OR] = ActionEntry(REDUCE, 186);
   _actionMap[650][AND] = ActionEntry(REDUCE, 186);
   _actionMap[650][LIKE] = ActionEntry(REDUCE, 186);
   _actionMap[650][IS] = ActionEntry(REDUCE, 186);
   _actionMap[650][BETWEEN] = ActionEntry(REDUCE, 186);
   _actionMap[650][NOT] = ActionEntry(REDUCE, 186);
   _actionMap[650][INTOK] = ActionEntry(REDUCE, 186);
   _actionMap[650][EQU] = ActionEntry(REDUCE, 186);
   _actionMap[650][NEGATION] = ActionEntry(REDUCE, 186);
   _actionMap[650][LT] = ActionEntry(REDUCE, 186);
   _actionMap[650][MT] = ActionEntry(REDUCE, 186);
   _actionMap[650][DESC] = ActionEntry(REDUCE, 186);
   _actionMap[650][ASC] = ActionEntry(REDUCE, 186);
   _actionMap[650][KSEP] = ActionEntry(REDUCE, 186);
   _actionMap[650][ROWLIMIT] = ActionEntry(REDUCE, 186);
   _actionMap[650][UNION] = ActionEntry(REDUCE, 186);
   _actionMap[650][ENDTOKEN] = ActionEntry(REDUCE, 186);
   _actionMap[650][RB] = ActionEntry(REDUCE, 186);
   _actionMap[650][SEMICOLON] = ActionEntry(REDUCE, 186);
   _actionMap[650][CONCAT] = ActionEntry(REDUCE, 186);
   _actionMap[650][STAR] = ActionEntry(REDUCE, 186);
   _actionMap[650][DIVISION] = ActionEntry(REDUCE, 186);
   _actionMap[650][MINUS] = ActionEntry(REDUCE, 186);
   _actionMap[650][PLUS] = ActionEntry(REDUCE, 186);
   _actionMap[651][WHEN] = ActionEntry(REDUCE, 336);
   _actionMap[651][ELSE] = ActionEntry(REDUCE, 336);
   _actionMap[651][LEFT] = ActionEntry(REDUCE, 336);
   _actionMap[651][RIGHT] = ActionEntry(REDUCE, 336);
   _actionMap[651][INNER] = ActionEntry(REDUCE, 336);
   _actionMap[651][JOIN] = ActionEntry(REDUCE, 336);
   _actionMap[651][RETURNTOKEN] = ActionEntry(REDUCE, 336);
   _actionMap[651][ORDER] = ActionEntry(REDUCE, 336);
   _actionMap[651][GROUP] = ActionEntry(REDUCE, 336);
   _actionMap[651][WHERE] = ActionEntry(REDUCE, 336);
   _actionMap[651][FROM] = ActionEntry(REDUCE, 336);
   _actionMap[651][AS] = ActionEntry(REDUCE, 336);
}
void Cego::loadParser131()
{
   _actionMap[651][END_TOKEN] = ActionEntry(REDUCE, 336);
   _actionMap[651][BEGIN] = ActionEntry(REDUCE, 336);
   _actionMap[651][THEN] = ActionEntry(REDUCE, 336);
   _actionMap[651][OR] = ActionEntry(REDUCE, 336);
   _actionMap[651][AND] = ActionEntry(REDUCE, 336);
   _actionMap[651][INTOK] = ActionEntry(REDUCE, 336);
   _actionMap[651][NOT] = ActionEntry(REDUCE, 336);
   _actionMap[651][BETWEEN] = ActionEntry(REDUCE, 336);
   _actionMap[651][IS] = ActionEntry(REDUCE, 336);
   _actionMap[651][LIKE] = ActionEntry(REDUCE, 336);
   _actionMap[651][MT] = ActionEntry(REDUCE, 336);
   _actionMap[651][LT] = ActionEntry(REDUCE, 336);
   _actionMap[651][NEGATION] = ActionEntry(REDUCE, 336);
   _actionMap[651][EQU] = ActionEntry(REDUCE, 336);
   _actionMap[651][RB] = ActionEntry(REDUCE, 336);
   _actionMap[651][ENDTOKEN] = ActionEntry(REDUCE, 336);
   _actionMap[651][UNION] = ActionEntry(REDUCE, 336);
   _actionMap[651][ROWLIMIT] = ActionEntry(REDUCE, 336);
   _actionMap[651][KSEP] = ActionEntry(REDUCE, 336);
   _actionMap[651][ASC] = ActionEntry(REDUCE, 336);
   _actionMap[651][DESC] = ActionEntry(REDUCE, 336);
   _actionMap[651][SEMICOLON] = ActionEntry(REDUCE, 336);
   _actionMap[651][PLUS] = ActionEntry(REDUCE, 336);
   _actionMap[651][MINUS] = ActionEntry(REDUCE, 336);
   _actionMap[651][DIVISION] = ActionEntry(REDUCE, 336);
   _actionMap[651][STAR] = ActionEntry(REDUCE, 336);
   _actionMap[651][CONCAT] = ActionEntry(REDUCE, 336);
   _actionMap[652][WHEN] = ActionEntry(REDUCE, 337);
   _actionMap[652][ELSE] = ActionEntry(REDUCE, 337);
   _actionMap[652][LEFT] = ActionEntry(REDUCE, 337);
   _actionMap[652][RIGHT] = ActionEntry(REDUCE, 337);
   _actionMap[652][INNER] = ActionEntry(REDUCE, 337);
   _actionMap[652][JOIN] = ActionEntry(REDUCE, 337);
   _actionMap[652][RETURNTOKEN] = ActionEntry(REDUCE, 337);
   _actionMap[652][ORDER] = ActionEntry(REDUCE, 337);
   _actionMap[652][GROUP] = ActionEntry(REDUCE, 337);
   _actionMap[652][WHERE] = ActionEntry(REDUCE, 337);
   _actionMap[652][FROM] = ActionEntry(REDUCE, 337);
   _actionMap[652][AS] = ActionEntry(REDUCE, 337);
   _actionMap[652][END_TOKEN] = ActionEntry(REDUCE, 337);
   _actionMap[652][BEGIN] = ActionEntry(REDUCE, 337);
   _actionMap[652][THEN] = ActionEntry(REDUCE, 337);
   _actionMap[652][OR] = ActionEntry(REDUCE, 337);
   _actionMap[652][AND] = ActionEntry(REDUCE, 337);
   _actionMap[652][INTOK] = ActionEntry(REDUCE, 337);
   _actionMap[652][NOT] = ActionEntry(REDUCE, 337);
   _actionMap[652][BETWEEN] = ActionEntry(REDUCE, 337);
   _actionMap[652][IS] = ActionEntry(REDUCE, 337);
   _actionMap[652][LIKE] = ActionEntry(REDUCE, 337);
   _actionMap[652][MT] = ActionEntry(REDUCE, 337);
}
void Cego::loadParser132()
{
   _actionMap[652][LT] = ActionEntry(REDUCE, 337);
   _actionMap[652][NEGATION] = ActionEntry(REDUCE, 337);
   _actionMap[652][EQU] = ActionEntry(REDUCE, 337);
   _actionMap[652][RB] = ActionEntry(REDUCE, 337);
   _actionMap[652][ENDTOKEN] = ActionEntry(REDUCE, 337);
   _actionMap[652][UNION] = ActionEntry(REDUCE, 337);
   _actionMap[652][ROWLIMIT] = ActionEntry(REDUCE, 337);
   _actionMap[652][KSEP] = ActionEntry(REDUCE, 337);
   _actionMap[652][ASC] = ActionEntry(REDUCE, 337);
   _actionMap[652][DESC] = ActionEntry(REDUCE, 337);
   _actionMap[652][SEMICOLON] = ActionEntry(REDUCE, 337);
   _actionMap[652][PLUS] = ActionEntry(REDUCE, 337);
   _actionMap[652][MINUS] = ActionEntry(REDUCE, 337);
   _actionMap[652][DIVISION] = ActionEntry(REDUCE, 337);
   _actionMap[652][STAR] = ActionEntry(REDUCE, 337);
   _actionMap[652][CONCAT] = ActionEntry(REDUCE, 337);
   _actionMap[653][WHEN] = ActionEntry(REDUCE, 338);
   _actionMap[653][ELSE] = ActionEntry(REDUCE, 338);
   _actionMap[653][LEFT] = ActionEntry(REDUCE, 338);
   _actionMap[653][RIGHT] = ActionEntry(REDUCE, 338);
   _actionMap[653][INNER] = ActionEntry(REDUCE, 338);
   _actionMap[653][JOIN] = ActionEntry(REDUCE, 338);
   _actionMap[653][RETURNTOKEN] = ActionEntry(REDUCE, 338);
   _actionMap[653][ORDER] = ActionEntry(REDUCE, 338);
   _actionMap[653][GROUP] = ActionEntry(REDUCE, 338);
   _actionMap[653][WHERE] = ActionEntry(REDUCE, 338);
   _actionMap[653][FROM] = ActionEntry(REDUCE, 338);
   _actionMap[653][AS] = ActionEntry(REDUCE, 338);
   _actionMap[653][END_TOKEN] = ActionEntry(REDUCE, 338);
   _actionMap[653][BEGIN] = ActionEntry(REDUCE, 338);
   _actionMap[653][THEN] = ActionEntry(REDUCE, 338);
   _actionMap[653][OR] = ActionEntry(REDUCE, 338);
   _actionMap[653][AND] = ActionEntry(REDUCE, 338);
   _actionMap[653][INTOK] = ActionEntry(REDUCE, 338);
   _actionMap[653][NOT] = ActionEntry(REDUCE, 338);
   _actionMap[653][BETWEEN] = ActionEntry(REDUCE, 338);
   _actionMap[653][IS] = ActionEntry(REDUCE, 338);
   _actionMap[653][LIKE] = ActionEntry(REDUCE, 338);
   _actionMap[653][MT] = ActionEntry(REDUCE, 338);
   _actionMap[653][LT] = ActionEntry(REDUCE, 338);
   _actionMap[653][NEGATION] = ActionEntry(REDUCE, 338);
   _actionMap[653][EQU] = ActionEntry(REDUCE, 338);
   _actionMap[653][RB] = ActionEntry(REDUCE, 338);
   _actionMap[653][ENDTOKEN] = ActionEntry(REDUCE, 338);
   _actionMap[653][UNION] = ActionEntry(REDUCE, 338);
   _actionMap[653][ROWLIMIT] = ActionEntry(REDUCE, 338);
   _actionMap[653][KSEP] = ActionEntry(REDUCE, 338);
   _actionMap[653][ASC] = ActionEntry(REDUCE, 338);
   _actionMap[653][DESC] = ActionEntry(REDUCE, 338);
   _actionMap[653][SEMICOLON] = ActionEntry(REDUCE, 338);
}
void Cego::loadParser133()
{
   _actionMap[653][PLUS] = ActionEntry(REDUCE, 338);
   _actionMap[653][MINUS] = ActionEntry(REDUCE, 338);
   _actionMap[653][DIVISION] = ActionEntry(REDUCE, 338);
   _actionMap[653][STAR] = ActionEntry(REDUCE, 338);
   _actionMap[653][CONCAT] = ActionEntry(REDUCE, 338);
   _actionMap[654][WHEN] = ActionEntry(REDUCE, 319);
   _actionMap[654][ELSE] = ActionEntry(REDUCE, 319);
   _actionMap[654][LEFT] = ActionEntry(REDUCE, 319);
   _actionMap[654][RIGHT] = ActionEntry(REDUCE, 319);
   _actionMap[654][INNER] = ActionEntry(REDUCE, 319);
   _actionMap[654][JOIN] = ActionEntry(REDUCE, 319);
   _actionMap[654][RETURNTOKEN] = ActionEntry(REDUCE, 319);
   _actionMap[654][ORDER] = ActionEntry(REDUCE, 319);
   _actionMap[654][GROUP] = ActionEntry(REDUCE, 319);
   _actionMap[654][WHERE] = ActionEntry(REDUCE, 319);
   _actionMap[654][FROM] = ActionEntry(REDUCE, 319);
   _actionMap[654][AS] = ActionEntry(REDUCE, 319);
   _actionMap[654][END_TOKEN] = ActionEntry(REDUCE, 319);
   _actionMap[654][BEGIN] = ActionEntry(REDUCE, 319);
   _actionMap[654][THEN] = ActionEntry(REDUCE, 319);
   _actionMap[654][OR] = ActionEntry(REDUCE, 319);
   _actionMap[654][AND] = ActionEntry(REDUCE, 319);
   _actionMap[654][INTOK] = ActionEntry(REDUCE, 319);
   _actionMap[654][NOT] = ActionEntry(REDUCE, 319);
   _actionMap[654][BETWEEN] = ActionEntry(REDUCE, 319);
   _actionMap[654][IS] = ActionEntry(REDUCE, 319);
   _actionMap[654][LIKE] = ActionEntry(REDUCE, 319);
   _actionMap[654][MT] = ActionEntry(REDUCE, 319);
   _actionMap[654][LT] = ActionEntry(REDUCE, 319);
   _actionMap[654][NEGATION] = ActionEntry(REDUCE, 319);
   _actionMap[654][EQU] = ActionEntry(REDUCE, 319);
   _actionMap[654][RB] = ActionEntry(REDUCE, 319);
   _actionMap[654][ENDTOKEN] = ActionEntry(REDUCE, 319);
   _actionMap[654][UNION] = ActionEntry(REDUCE, 319);
   _actionMap[654][ROWLIMIT] = ActionEntry(REDUCE, 319);
   _actionMap[654][KSEP] = ActionEntry(REDUCE, 319);
   _actionMap[654][ASC] = ActionEntry(REDUCE, 319);
   _actionMap[654][DESC] = ActionEntry(REDUCE, 319);
   _actionMap[654][SEMICOLON] = ActionEntry(REDUCE, 319);
   _actionMap[654][PLUS] = ActionEntry(REDUCE, 319);
   _actionMap[654][MINUS] = ActionEntry(REDUCE, 319);
   _actionMap[654][DIVISION] = ActionEntry(REDUCE, 319);
   _actionMap[654][STAR] = ActionEntry(REDUCE, 319);
   _actionMap[654][CONCAT] = ActionEntry(REDUCE, 319);
   _actionMap[655][WHEN] = ActionEntry(REDUCE, 335);
   _actionMap[655][ELSE] = ActionEntry(REDUCE, 335);
   _actionMap[655][LEFT] = ActionEntry(REDUCE, 335);
   _actionMap[655][RIGHT] = ActionEntry(REDUCE, 335);
   _actionMap[655][INNER] = ActionEntry(REDUCE, 335);
   _actionMap[655][JOIN] = ActionEntry(REDUCE, 335);
}
void Cego::loadParser134()
{
   _actionMap[655][RETURNTOKEN] = ActionEntry(REDUCE, 335);
   _actionMap[655][ORDER] = ActionEntry(REDUCE, 335);
   _actionMap[655][GROUP] = ActionEntry(REDUCE, 335);
   _actionMap[655][WHERE] = ActionEntry(REDUCE, 335);
   _actionMap[655][FROM] = ActionEntry(REDUCE, 335);
   _actionMap[655][AS] = ActionEntry(REDUCE, 335);
   _actionMap[655][END_TOKEN] = ActionEntry(REDUCE, 335);
   _actionMap[655][BEGIN] = ActionEntry(REDUCE, 335);
   _actionMap[655][THEN] = ActionEntry(REDUCE, 335);
   _actionMap[655][OR] = ActionEntry(REDUCE, 335);
   _actionMap[655][AND] = ActionEntry(REDUCE, 335);
   _actionMap[655][INTOK] = ActionEntry(REDUCE, 335);
   _actionMap[655][NOT] = ActionEntry(REDUCE, 335);
   _actionMap[655][BETWEEN] = ActionEntry(REDUCE, 335);
   _actionMap[655][IS] = ActionEntry(REDUCE, 335);
   _actionMap[655][LIKE] = ActionEntry(REDUCE, 335);
   _actionMap[655][MT] = ActionEntry(REDUCE, 335);
   _actionMap[655][LT] = ActionEntry(REDUCE, 335);
   _actionMap[655][NEGATION] = ActionEntry(REDUCE, 335);
   _actionMap[655][EQU] = ActionEntry(REDUCE, 335);
   _actionMap[655][RB] = ActionEntry(REDUCE, 335);
   _actionMap[655][ENDTOKEN] = ActionEntry(REDUCE, 335);
   _actionMap[655][UNION] = ActionEntry(REDUCE, 335);
   _actionMap[655][ROWLIMIT] = ActionEntry(REDUCE, 335);
   _actionMap[655][KSEP] = ActionEntry(REDUCE, 335);
   _actionMap[655][ASC] = ActionEntry(REDUCE, 335);
   _actionMap[655][DESC] = ActionEntry(REDUCE, 335);
   _actionMap[655][SEMICOLON] = ActionEntry(REDUCE, 335);
   _actionMap[655][PLUS] = ActionEntry(REDUCE, 335);
   _actionMap[655][MINUS] = ActionEntry(REDUCE, 335);
   _actionMap[655][DIVISION] = ActionEntry(REDUCE, 335);
   _actionMap[655][STAR] = ActionEntry(REDUCE, 335);
   _actionMap[655][CONCAT] = ActionEntry(REDUCE, 335);
   _actionMap[656][WHEN] = ActionEntry(REDUCE, 328);
   _actionMap[656][ELSE] = ActionEntry(REDUCE, 328);
   _actionMap[656][LEFT] = ActionEntry(REDUCE, 328);
   _actionMap[656][RIGHT] = ActionEntry(REDUCE, 328);
   _actionMap[656][INNER] = ActionEntry(REDUCE, 328);
   _actionMap[656][JOIN] = ActionEntry(REDUCE, 328);
   _actionMap[656][RETURNTOKEN] = ActionEntry(REDUCE, 328);
   _actionMap[656][ORDER] = ActionEntry(REDUCE, 328);
   _actionMap[656][GROUP] = ActionEntry(REDUCE, 328);
   _actionMap[656][WHERE] = ActionEntry(REDUCE, 328);
   _actionMap[656][FROM] = ActionEntry(REDUCE, 328);
   _actionMap[656][AS] = ActionEntry(REDUCE, 328);
   _actionMap[656][END_TOKEN] = ActionEntry(REDUCE, 328);
   _actionMap[656][BEGIN] = ActionEntry(REDUCE, 328);
   _actionMap[656][THEN] = ActionEntry(REDUCE, 328);
   _actionMap[656][OR] = ActionEntry(REDUCE, 328);
   _actionMap[656][AND] = ActionEntry(REDUCE, 328);
}
void Cego::loadParser135()
{
   _actionMap[656][INTOK] = ActionEntry(REDUCE, 328);
   _actionMap[656][NOT] = ActionEntry(REDUCE, 328);
   _actionMap[656][BETWEEN] = ActionEntry(REDUCE, 328);
   _actionMap[656][IS] = ActionEntry(REDUCE, 328);
   _actionMap[656][LIKE] = ActionEntry(REDUCE, 328);
   _actionMap[656][MT] = ActionEntry(REDUCE, 328);
   _actionMap[656][LT] = ActionEntry(REDUCE, 328);
   _actionMap[656][NEGATION] = ActionEntry(REDUCE, 328);
   _actionMap[656][EQU] = ActionEntry(REDUCE, 328);
   _actionMap[656][RB] = ActionEntry(REDUCE, 328);
   _actionMap[656][ENDTOKEN] = ActionEntry(REDUCE, 328);
   _actionMap[656][UNION] = ActionEntry(REDUCE, 328);
   _actionMap[656][ROWLIMIT] = ActionEntry(REDUCE, 328);
   _actionMap[656][KSEP] = ActionEntry(REDUCE, 328);
   _actionMap[656][ASC] = ActionEntry(REDUCE, 328);
   _actionMap[656][DESC] = ActionEntry(REDUCE, 328);
   _actionMap[656][SEMICOLON] = ActionEntry(REDUCE, 328);
   _actionMap[656][PLUS] = ActionEntry(REDUCE, 328);
   _actionMap[656][MINUS] = ActionEntry(REDUCE, 328);
   _actionMap[656][DIVISION] = ActionEntry(REDUCE, 328);
   _actionMap[656][STAR] = ActionEntry(REDUCE, 328);
   _actionMap[656][CONCAT] = ActionEntry(REDUCE, 328);
   _actionMap[657][WHEN] = ActionEntry(REDUCE, 410);
   _actionMap[657][ELSE] = ActionEntry(REDUCE, 410);
   _actionMap[657][LEFT] = ActionEntry(REDUCE, 410);
   _actionMap[657][RIGHT] = ActionEntry(REDUCE, 410);
   _actionMap[657][INNER] = ActionEntry(REDUCE, 410);
   _actionMap[657][JOIN] = ActionEntry(REDUCE, 410);
   _actionMap[657][RETURNTOKEN] = ActionEntry(REDUCE, 410);
   _actionMap[657][ORDER] = ActionEntry(REDUCE, 410);
   _actionMap[657][GROUP] = ActionEntry(REDUCE, 410);
   _actionMap[657][WHERE] = ActionEntry(REDUCE, 410);
   _actionMap[657][FROM] = ActionEntry(REDUCE, 410);
   _actionMap[657][AS] = ActionEntry(REDUCE, 410);
   _actionMap[657][END_TOKEN] = ActionEntry(REDUCE, 410);
   _actionMap[657][BEGIN] = ActionEntry(REDUCE, 410);
   _actionMap[657][THEN] = ActionEntry(REDUCE, 410);
   _actionMap[657][OR] = ActionEntry(REDUCE, 410);
   _actionMap[657][AND] = ActionEntry(REDUCE, 410);
   _actionMap[657][ENDTOKEN] = ActionEntry(REDUCE, 410);
   _actionMap[657][UNION] = ActionEntry(REDUCE, 410);
   _actionMap[657][ROWLIMIT] = ActionEntry(REDUCE, 410);
   _actionMap[657][ASC] = ActionEntry(REDUCE, 410);
   _actionMap[657][DESC] = ActionEntry(REDUCE, 410);
   _actionMap[657][INTOK] = ActionEntry(REDUCE, 410);
   _actionMap[657][BETWEEN] = ActionEntry(REDUCE, 410);
   _actionMap[657][LIKE] = ActionEntry(REDUCE, 410);
   _actionMap[657][PLUS] = ActionEntry(REDUCE, 410);
   _actionMap[657][MINUS] = ActionEntry(REDUCE, 410);
   _actionMap[657][CONCAT] = ActionEntry(REDUCE, 410);
}
void Cego::loadParser136()
{
   _actionMap[657][DIVISION] = ActionEntry(REDUCE, 410);
   _actionMap[657][STAR] = ActionEntry(REDUCE, 410);
   _actionMap[657][MT] = ActionEntry(REDUCE, 410);
   _actionMap[657][LT] = ActionEntry(REDUCE, 410);
   _actionMap[657][NEGATION] = ActionEntry(REDUCE, 410);
   _actionMap[657][EQU] = ActionEntry(REDUCE, 410);
   _actionMap[657][IS] = ActionEntry(REDUCE, 410);
   _actionMap[657][NULLTOKEN] = ActionEntry(REDUCE, 410);
   _actionMap[657][NOT] = ActionEntry(REDUCE, 410);
   _actionMap[657][KSEP] = ActionEntry(REDUCE, 410);
   _actionMap[657][SEMICOLON] = ActionEntry(REDUCE, 410);
   _actionMap[657][RB] = ActionEntry(REDUCE, 410);
   _actionMap[658][INTVAL] = ActionEntry(SHIFT, 339);
   _actionMap[659][WHEN] = ActionEntry(REDUCE, 416);
   _actionMap[659][ELSE] = ActionEntry(REDUCE, 416);
   _actionMap[659][LEFT] = ActionEntry(REDUCE, 416);
   _actionMap[659][RIGHT] = ActionEntry(REDUCE, 416);
   _actionMap[659][INNER] = ActionEntry(REDUCE, 416);
   _actionMap[659][JOIN] = ActionEntry(REDUCE, 416);
   _actionMap[659][RETURNTOKEN] = ActionEntry(REDUCE, 416);
   _actionMap[659][ORDER] = ActionEntry(REDUCE, 416);
   _actionMap[659][GROUP] = ActionEntry(REDUCE, 416);
   _actionMap[659][WHERE] = ActionEntry(REDUCE, 416);
   _actionMap[659][FROM] = ActionEntry(REDUCE, 416);
   _actionMap[659][AS] = ActionEntry(REDUCE, 416);
   _actionMap[659][END_TOKEN] = ActionEntry(REDUCE, 416);
   _actionMap[659][BEGIN] = ActionEntry(REDUCE, 416);
   _actionMap[659][THEN] = ActionEntry(REDUCE, 416);
   _actionMap[659][OR] = ActionEntry(REDUCE, 416);
   _actionMap[659][AND] = ActionEntry(REDUCE, 416);
   _actionMap[659][ENDTOKEN] = ActionEntry(REDUCE, 416);
   _actionMap[659][UNION] = ActionEntry(REDUCE, 416);
   _actionMap[659][ROWLIMIT] = ActionEntry(REDUCE, 416);
   _actionMap[659][ASC] = ActionEntry(REDUCE, 416);
   _actionMap[659][DESC] = ActionEntry(REDUCE, 416);
   _actionMap[659][INTOK] = ActionEntry(REDUCE, 416);
   _actionMap[659][BETWEEN] = ActionEntry(REDUCE, 416);
   _actionMap[659][LIKE] = ActionEntry(REDUCE, 416);
   _actionMap[659][PLUS] = ActionEntry(REDUCE, 416);
   _actionMap[659][MINUS] = ActionEntry(REDUCE, 416);
   _actionMap[659][CONCAT] = ActionEntry(REDUCE, 416);
   _actionMap[659][DIVISION] = ActionEntry(REDUCE, 416);
   _actionMap[659][STAR] = ActionEntry(REDUCE, 416);
   _actionMap[659][MT] = ActionEntry(REDUCE, 416);
   _actionMap[659][LT] = ActionEntry(REDUCE, 416);
   _actionMap[659][NEGATION] = ActionEntry(REDUCE, 416);
   _actionMap[659][EQU] = ActionEntry(REDUCE, 416);
   _actionMap[659][IS] = ActionEntry(REDUCE, 416);
   _actionMap[659][NULLTOKEN] = ActionEntry(REDUCE, 416);
   _actionMap[659][NOT] = ActionEntry(REDUCE, 416);
}
void Cego::loadParser137()
{
   _actionMap[659][KSEP] = ActionEntry(REDUCE, 416);
   _actionMap[659][SEMICOLON] = ActionEntry(REDUCE, 416);
   _actionMap[659][RB] = ActionEntry(REDUCE, 416);
   _actionMap[660][FLOATVAL] = ActionEntry(SHIFT, 340);
   _actionMap[661][WHEN] = ActionEntry(REDUCE, 415);
   _actionMap[661][ELSE] = ActionEntry(REDUCE, 415);
   _actionMap[661][LEFT] = ActionEntry(REDUCE, 415);
   _actionMap[661][RIGHT] = ActionEntry(REDUCE, 415);
   _actionMap[661][INNER] = ActionEntry(REDUCE, 415);
   _actionMap[661][JOIN] = ActionEntry(REDUCE, 415);
   _actionMap[661][RETURNTOKEN] = ActionEntry(REDUCE, 415);
   _actionMap[661][ORDER] = ActionEntry(REDUCE, 415);
   _actionMap[661][GROUP] = ActionEntry(REDUCE, 415);
   _actionMap[661][WHERE] = ActionEntry(REDUCE, 415);
   _actionMap[661][FROM] = ActionEntry(REDUCE, 415);
   _actionMap[661][AS] = ActionEntry(REDUCE, 415);
   _actionMap[661][END_TOKEN] = ActionEntry(REDUCE, 415);
   _actionMap[661][BEGIN] = ActionEntry(REDUCE, 415);
   _actionMap[661][THEN] = ActionEntry(REDUCE, 415);
   _actionMap[661][OR] = ActionEntry(REDUCE, 415);
   _actionMap[661][AND] = ActionEntry(REDUCE, 415);
   _actionMap[661][ENDTOKEN] = ActionEntry(REDUCE, 415);
   _actionMap[661][UNION] = ActionEntry(REDUCE, 415);
   _actionMap[661][ROWLIMIT] = ActionEntry(REDUCE, 415);
   _actionMap[661][ASC] = ActionEntry(REDUCE, 415);
   _actionMap[661][DESC] = ActionEntry(REDUCE, 415);
   _actionMap[661][INTOK] = ActionEntry(REDUCE, 415);
   _actionMap[661][BETWEEN] = ActionEntry(REDUCE, 415);
   _actionMap[661][LIKE] = ActionEntry(REDUCE, 415);
   _actionMap[661][PLUS] = ActionEntry(REDUCE, 415);
   _actionMap[661][MINUS] = ActionEntry(REDUCE, 415);
   _actionMap[661][CONCAT] = ActionEntry(REDUCE, 415);
   _actionMap[661][DIVISION] = ActionEntry(REDUCE, 415);
   _actionMap[661][STAR] = ActionEntry(REDUCE, 415);
   _actionMap[661][MT] = ActionEntry(REDUCE, 415);
   _actionMap[661][LT] = ActionEntry(REDUCE, 415);
   _actionMap[661][NEGATION] = ActionEntry(REDUCE, 415);
   _actionMap[661][EQU] = ActionEntry(REDUCE, 415);
   _actionMap[661][IS] = ActionEntry(REDUCE, 415);
   _actionMap[661][NULLTOKEN] = ActionEntry(REDUCE, 415);
   _actionMap[661][NOT] = ActionEntry(REDUCE, 415);
   _actionMap[661][KSEP] = ActionEntry(REDUCE, 415);
   _actionMap[661][SEMICOLON] = ActionEntry(REDUCE, 415);
   _actionMap[661][RB] = ActionEntry(REDUCE, 415);
   _actionMap[662][WHEN] = ActionEntry(REDUCE, 417);
   _actionMap[662][ELSE] = ActionEntry(REDUCE, 417);
   _actionMap[662][LEFT] = ActionEntry(REDUCE, 417);
   _actionMap[662][RIGHT] = ActionEntry(REDUCE, 417);
   _actionMap[662][INNER] = ActionEntry(REDUCE, 417);
   _actionMap[662][JOIN] = ActionEntry(REDUCE, 417);
}
void Cego::loadParser138()
{
   _actionMap[662][RETURNTOKEN] = ActionEntry(REDUCE, 417);
   _actionMap[662][ORDER] = ActionEntry(REDUCE, 417);
   _actionMap[662][GROUP] = ActionEntry(REDUCE, 417);
   _actionMap[662][WHERE] = ActionEntry(REDUCE, 417);
   _actionMap[662][FROM] = ActionEntry(REDUCE, 417);
   _actionMap[662][AS] = ActionEntry(REDUCE, 417);
   _actionMap[662][END_TOKEN] = ActionEntry(REDUCE, 417);
   _actionMap[662][BEGIN] = ActionEntry(REDUCE, 417);
   _actionMap[662][THEN] = ActionEntry(REDUCE, 417);
   _actionMap[662][OR] = ActionEntry(REDUCE, 417);
   _actionMap[662][AND] = ActionEntry(REDUCE, 417);
   _actionMap[662][ENDTOKEN] = ActionEntry(REDUCE, 417);
   _actionMap[662][UNION] = ActionEntry(REDUCE, 417);
   _actionMap[662][ROWLIMIT] = ActionEntry(REDUCE, 417);
   _actionMap[662][ASC] = ActionEntry(REDUCE, 417);
   _actionMap[662][DESC] = ActionEntry(REDUCE, 417);
   _actionMap[662][INTOK] = ActionEntry(REDUCE, 417);
   _actionMap[662][BETWEEN] = ActionEntry(REDUCE, 417);
   _actionMap[662][LIKE] = ActionEntry(REDUCE, 417);
   _actionMap[662][PLUS] = ActionEntry(REDUCE, 417);
   _actionMap[662][MINUS] = ActionEntry(REDUCE, 417);
   _actionMap[662][CONCAT] = ActionEntry(REDUCE, 417);
   _actionMap[662][DIVISION] = ActionEntry(REDUCE, 417);
   _actionMap[662][STAR] = ActionEntry(REDUCE, 417);
   _actionMap[662][MT] = ActionEntry(REDUCE, 417);
   _actionMap[662][LT] = ActionEntry(REDUCE, 417);
   _actionMap[662][NEGATION] = ActionEntry(REDUCE, 417);
   _actionMap[662][EQU] = ActionEntry(REDUCE, 417);
   _actionMap[662][IS] = ActionEntry(REDUCE, 417);
   _actionMap[662][NULLTOKEN] = ActionEntry(REDUCE, 417);
   _actionMap[662][NOT] = ActionEntry(REDUCE, 417);
   _actionMap[662][KSEP] = ActionEntry(REDUCE, 417);
   _actionMap[662][SEMICOLON] = ActionEntry(REDUCE, 417);
   _actionMap[662][RB] = ActionEntry(REDUCE, 417);
   _actionMap[663][WHEN] = ActionEntry(REDUCE, 409);
   _actionMap[663][ELSE] = ActionEntry(REDUCE, 409);
   _actionMap[663][LEFT] = ActionEntry(REDUCE, 409);
   _actionMap[663][RIGHT] = ActionEntry(REDUCE, 409);
   _actionMap[663][INNER] = ActionEntry(REDUCE, 409);
   _actionMap[663][JOIN] = ActionEntry(REDUCE, 409);
   _actionMap[663][RETURNTOKEN] = ActionEntry(REDUCE, 409);
   _actionMap[663][ORDER] = ActionEntry(REDUCE, 409);
   _actionMap[663][GROUP] = ActionEntry(REDUCE, 409);
   _actionMap[663][WHERE] = ActionEntry(REDUCE, 409);
   _actionMap[663][FROM] = ActionEntry(REDUCE, 409);
   _actionMap[663][AS] = ActionEntry(REDUCE, 409);
   _actionMap[663][END_TOKEN] = ActionEntry(REDUCE, 409);
   _actionMap[663][BEGIN] = ActionEntry(REDUCE, 409);
   _actionMap[663][THEN] = ActionEntry(REDUCE, 409);
   _actionMap[663][OR] = ActionEntry(REDUCE, 409);
}
void Cego::loadParser139()
{
   _actionMap[663][AND] = ActionEntry(REDUCE, 409);
   _actionMap[663][ENDTOKEN] = ActionEntry(REDUCE, 409);
   _actionMap[663][UNION] = ActionEntry(REDUCE, 409);
   _actionMap[663][ROWLIMIT] = ActionEntry(REDUCE, 409);
   _actionMap[663][ASC] = ActionEntry(REDUCE, 409);
   _actionMap[663][DESC] = ActionEntry(REDUCE, 409);
   _actionMap[663][INTOK] = ActionEntry(REDUCE, 409);
   _actionMap[663][BETWEEN] = ActionEntry(REDUCE, 409);
   _actionMap[663][LIKE] = ActionEntry(REDUCE, 409);
   _actionMap[663][PLUS] = ActionEntry(REDUCE, 409);
   _actionMap[663][MINUS] = ActionEntry(REDUCE, 409);
   _actionMap[663][CONCAT] = ActionEntry(REDUCE, 409);
   _actionMap[663][DIVISION] = ActionEntry(REDUCE, 409);
   _actionMap[663][STAR] = ActionEntry(REDUCE, 409);
   _actionMap[663][MT] = ActionEntry(REDUCE, 409);
   _actionMap[663][LT] = ActionEntry(REDUCE, 409);
   _actionMap[663][NEGATION] = ActionEntry(REDUCE, 409);
   _actionMap[663][EQU] = ActionEntry(REDUCE, 409);
   _actionMap[663][IS] = ActionEntry(REDUCE, 409);
   _actionMap[663][NULLTOKEN] = ActionEntry(REDUCE, 409);
   _actionMap[663][NOT] = ActionEntry(REDUCE, 409);
   _actionMap[663][KSEP] = ActionEntry(REDUCE, 409);
   _actionMap[663][SEMICOLON] = ActionEntry(REDUCE, 409);
   _actionMap[663][RB] = ActionEntry(REDUCE, 409);
   _actionMap[664][WHEN] = ActionEntry(REDUCE, 411);
   _actionMap[664][ELSE] = ActionEntry(REDUCE, 411);
   _actionMap[664][LEFT] = ActionEntry(REDUCE, 411);
   _actionMap[664][RIGHT] = ActionEntry(REDUCE, 411);
   _actionMap[664][INNER] = ActionEntry(REDUCE, 411);
   _actionMap[664][JOIN] = ActionEntry(REDUCE, 411);
   _actionMap[664][RETURNTOKEN] = ActionEntry(REDUCE, 411);
   _actionMap[664][ORDER] = ActionEntry(REDUCE, 411);
   _actionMap[664][GROUP] = ActionEntry(REDUCE, 411);
   _actionMap[664][WHERE] = ActionEntry(REDUCE, 411);
   _actionMap[664][FROM] = ActionEntry(REDUCE, 411);
   _actionMap[664][AS] = ActionEntry(REDUCE, 411);
   _actionMap[664][END_TOKEN] = ActionEntry(REDUCE, 411);
   _actionMap[664][BEGIN] = ActionEntry(REDUCE, 411);
   _actionMap[664][THEN] = ActionEntry(REDUCE, 411);
   _actionMap[664][OR] = ActionEntry(REDUCE, 411);
   _actionMap[664][AND] = ActionEntry(REDUCE, 411);
   _actionMap[664][ENDTOKEN] = ActionEntry(REDUCE, 411);
   _actionMap[664][UNION] = ActionEntry(REDUCE, 411);
   _actionMap[664][ROWLIMIT] = ActionEntry(REDUCE, 411);
   _actionMap[664][ASC] = ActionEntry(REDUCE, 411);
   _actionMap[664][DESC] = ActionEntry(REDUCE, 411);
   _actionMap[664][INTOK] = ActionEntry(REDUCE, 411);
   _actionMap[664][BETWEEN] = ActionEntry(REDUCE, 411);
   _actionMap[664][LIKE] = ActionEntry(REDUCE, 411);
   _actionMap[664][PLUS] = ActionEntry(REDUCE, 411);
}
void Cego::loadParser140()
{
   _actionMap[664][MINUS] = ActionEntry(REDUCE, 411);
   _actionMap[664][CONCAT] = ActionEntry(REDUCE, 411);
   _actionMap[664][DIVISION] = ActionEntry(REDUCE, 411);
   _actionMap[664][STAR] = ActionEntry(REDUCE, 411);
   _actionMap[664][MT] = ActionEntry(REDUCE, 411);
   _actionMap[664][LT] = ActionEntry(REDUCE, 411);
   _actionMap[664][NEGATION] = ActionEntry(REDUCE, 411);
   _actionMap[664][EQU] = ActionEntry(REDUCE, 411);
   _actionMap[664][IS] = ActionEntry(REDUCE, 411);
   _actionMap[664][NULLTOKEN] = ActionEntry(REDUCE, 411);
   _actionMap[664][NOT] = ActionEntry(REDUCE, 411);
   _actionMap[664][KSEP] = ActionEntry(REDUCE, 411);
   _actionMap[664][SEMICOLON] = ActionEntry(REDUCE, 411);
   _actionMap[664][RB] = ActionEntry(REDUCE, 411);
   _actionMap[665][WHEN] = ActionEntry(REDUCE, 412);
   _actionMap[665][ELSE] = ActionEntry(REDUCE, 412);
   _actionMap[665][LEFT] = ActionEntry(REDUCE, 412);
   _actionMap[665][RIGHT] = ActionEntry(REDUCE, 412);
   _actionMap[665][INNER] = ActionEntry(REDUCE, 412);
   _actionMap[665][JOIN] = ActionEntry(REDUCE, 412);
   _actionMap[665][RETURNTOKEN] = ActionEntry(REDUCE, 412);
   _actionMap[665][ORDER] = ActionEntry(REDUCE, 412);
   _actionMap[665][GROUP] = ActionEntry(REDUCE, 412);
   _actionMap[665][WHERE] = ActionEntry(REDUCE, 412);
   _actionMap[665][FROM] = ActionEntry(REDUCE, 412);
   _actionMap[665][AS] = ActionEntry(REDUCE, 412);
   _actionMap[665][END_TOKEN] = ActionEntry(REDUCE, 412);
   _actionMap[665][BEGIN] = ActionEntry(REDUCE, 412);
   _actionMap[665][THEN] = ActionEntry(REDUCE, 412);
   _actionMap[665][OR] = ActionEntry(REDUCE, 412);
   _actionMap[665][AND] = ActionEntry(REDUCE, 412);
   _actionMap[665][ENDTOKEN] = ActionEntry(REDUCE, 412);
   _actionMap[665][UNION] = ActionEntry(REDUCE, 412);
   _actionMap[665][ROWLIMIT] = ActionEntry(REDUCE, 412);
   _actionMap[665][ASC] = ActionEntry(REDUCE, 412);
   _actionMap[665][DESC] = ActionEntry(REDUCE, 412);
   _actionMap[665][INTOK] = ActionEntry(REDUCE, 412);
   _actionMap[665][BETWEEN] = ActionEntry(REDUCE, 412);
   _actionMap[665][LIKE] = ActionEntry(REDUCE, 412);
   _actionMap[665][PLUS] = ActionEntry(REDUCE, 412);
   _actionMap[665][MINUS] = ActionEntry(REDUCE, 412);
   _actionMap[665][CONCAT] = ActionEntry(REDUCE, 412);
   _actionMap[665][DIVISION] = ActionEntry(REDUCE, 412);
   _actionMap[665][STAR] = ActionEntry(REDUCE, 412);
   _actionMap[665][MT] = ActionEntry(REDUCE, 412);
   _actionMap[665][LT] = ActionEntry(REDUCE, 412);
   _actionMap[665][NEGATION] = ActionEntry(REDUCE, 412);
   _actionMap[665][EQU] = ActionEntry(REDUCE, 412);
   _actionMap[665][IS] = ActionEntry(REDUCE, 412);
   _actionMap[665][NULLTOKEN] = ActionEntry(REDUCE, 412);
}
void Cego::loadParser141()
{
   _actionMap[665][NOT] = ActionEntry(REDUCE, 412);
   _actionMap[665][KSEP] = ActionEntry(REDUCE, 412);
   _actionMap[665][SEMICOLON] = ActionEntry(REDUCE, 412);
   _actionMap[665][RB] = ActionEntry(REDUCE, 412);
   _actionMap[666][SEMICOLON] = ActionEntry(REDUCE, 311);
   _actionMap[667][SEMICOLON] = ActionEntry(REDUCE, 310);
   _actionMap[668][SEMICOLON] = ActionEntry(REDUCE, 315);
   _actionMap[669][SEMICOLON] = ActionEntry(REDUCE, 312);
   _actionMap[670][SEMICOLON] = ActionEntry(REDUCE, 313);
   _actionMap[671][SEMICOLON] = ActionEntry(REDUCE, 309);
   _actionMap[672][SEMICOLON] = ActionEntry(REDUCE, 316);
   _actionMap[673][SEMICOLON] = ActionEntry(REDUCE, 314);
   _actionMap[674][SEMICOLON] = ActionEntry(REDUCE, 267);
   _actionMap[674][RB] = ActionEntry(REDUCE, 267);
   _actionMap[674][ENDTOKEN] = ActionEntry(REDUCE, 267);
   _actionMap[674][UNION] = ActionEntry(REDUCE, 267);
   _actionMap[674][ROWLIMIT] = ActionEntry(REDUCE, 267);
   _actionMap[674][ORDER] = ActionEntry(REDUCE, 267);
   _actionMap[674][GROUP] = ActionEntry(SHIFT, 782);
   _jumpMap[674][NoGroup] = 781;
   _jumpMap[674][GroupClause] = 780;
   _actionMap[675][LEFT] = ActionEntry(REDUCE, 247);
   _actionMap[675][RIGHT] = ActionEntry(REDUCE, 247);
   _actionMap[675][INNER] = ActionEntry(REDUCE, 247);
   _actionMap[675][JOIN] = ActionEntry(REDUCE, 247);
   _actionMap[675][RETURNTOKEN] = ActionEntry(REDUCE, 247);
   _actionMap[675][SEMICOLON] = ActionEntry(REDUCE, 247);
   _actionMap[675][RB] = ActionEntry(REDUCE, 247);
   _actionMap[675][ENDTOKEN] = ActionEntry(REDUCE, 247);
   _actionMap[675][UNION] = ActionEntry(REDUCE, 247);
   _actionMap[675][ROWLIMIT] = ActionEntry(REDUCE, 247);
   _actionMap[675][ORDER] = ActionEntry(REDUCE, 247);
   _actionMap[675][GROUP] = ActionEntry(REDUCE, 247);
   _actionMap[675][WHERE] = ActionEntry(REDUCE, 247);
   _actionMap[676][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[676][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[676][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[676][ObjSpec] = 520;
   _jumpMap[676][JoinTable] = 784;
   _jumpMap[676][Table] = 783;
   _actionMap[677][JOIN] = ActionEntry(SHIFT, 785);
   _actionMap[678][IDENTIFIER] = ActionEntry(REDUCE, 256);
   _actionMap[678][QUALIFIEDOBJ] = ActionEntry(REDUCE, 256);
   _actionMap[678][QUALIFIEDTS] = ActionEntry(REDUCE, 256);
   _actionMap[679][OUTER] = ActionEntry(SHIFT, 786);
   _actionMap[680][OUTER] = ActionEntry(SHIFT, 787);
   _actionMap[681][LEFT] = ActionEntry(REDUCE, 248);
   _actionMap[681][RIGHT] = ActionEntry(REDUCE, 248);
   _actionMap[681][INNER] = ActionEntry(REDUCE, 248);
   _actionMap[681][JOIN] = ActionEntry(REDUCE, 248);
}
void Cego::loadParser142()
{
   _actionMap[681][RETURNTOKEN] = ActionEntry(REDUCE, 248);
   _actionMap[681][SEMICOLON] = ActionEntry(REDUCE, 248);
   _actionMap[681][RB] = ActionEntry(REDUCE, 248);
   _actionMap[681][ENDTOKEN] = ActionEntry(REDUCE, 248);
   _actionMap[681][UNION] = ActionEntry(REDUCE, 248);
   _actionMap[681][ROWLIMIT] = ActionEntry(REDUCE, 248);
   _actionMap[681][ORDER] = ActionEntry(REDUCE, 248);
   _actionMap[681][GROUP] = ActionEntry(REDUCE, 248);
   _actionMap[681][WHERE] = ActionEntry(REDUCE, 248);
   _actionMap[682][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[682][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[682][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[682][ObjSpec] = 520;
   _jumpMap[682][Table] = 789;
   _jumpMap[682][TableList] = 788;
   _actionMap[683][KSEP] = ActionEntry(REDUCE, 260);
   _actionMap[683][LEFT] = ActionEntry(REDUCE, 260);
   _actionMap[683][RIGHT] = ActionEntry(REDUCE, 260);
   _actionMap[683][INNER] = ActionEntry(REDUCE, 260);
   _actionMap[683][JOIN] = ActionEntry(REDUCE, 260);
   _actionMap[683][RETURNTOKEN] = ActionEntry(REDUCE, 260);
   _actionMap[683][SEMICOLON] = ActionEntry(REDUCE, 260);
   _actionMap[683][RB] = ActionEntry(REDUCE, 260);
   _actionMap[683][ENDTOKEN] = ActionEntry(REDUCE, 260);
   _actionMap[683][UNION] = ActionEntry(REDUCE, 260);
   _actionMap[683][ROWLIMIT] = ActionEntry(REDUCE, 260);
   _actionMap[683][ORDER] = ActionEntry(REDUCE, 260);
   _actionMap[683][GROUP] = ActionEntry(REDUCE, 260);
   _actionMap[683][WHERE] = ActionEntry(REDUCE, 260);
   _actionMap[683][ON] = ActionEntry(REDUCE, 260);
   _actionMap[684][FROM] = ActionEntry(REDUCE, 262);
   _actionMap[684][RB] = ActionEntry(REDUCE, 262);
   _actionMap[684][SEMICOLON] = ActionEntry(REDUCE, 262);
   _actionMap[684][ENDTOKEN] = ActionEntry(REDUCE, 262);
   _actionMap[684][KSEP] = ActionEntry(REDUCE, 262);
   _actionMap[685][FROM] = ActionEntry(REDUCE, 242);
   _actionMap[685][RB] = ActionEntry(REDUCE, 242);
   _actionMap[685][SEMICOLON] = ActionEntry(REDUCE, 242);
   _actionMap[685][ENDTOKEN] = ActionEntry(REDUCE, 242);
   _actionMap[685][KSEP] = ActionEntry(REDUCE, 242);
   _actionMap[686][PLUS] = ActionEntry(SHIFT, 275);
   _actionMap[686][MINUS] = ActionEntry(SHIFT, 274);
   _actionMap[686][CONCAT] = ActionEntry(SHIFT, 273);
   _actionMap[686][SEMICOLON] = ActionEntry(REDUCE, 92);
   _actionMap[687][RETURNTOKEN] = ActionEntry(SHIFT, 791);
   _actionMap[687][SEMICOLON] = ActionEntry(REDUCE, 294);
   _jumpMap[687][UpdReturnOpt] = 790;
   _actionMap[688][IDENTIFIER] = ActionEntry(SHIFT, 529);
   _jumpMap[688][Assignment] = 792;
   _actionMap[689][FLOATVAL] = ActionEntry(SHIFT, 179);
}
void Cego::loadParser143()
{
   _actionMap[689][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[689][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[689][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[689][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[689][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[689][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[689][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[689][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[689][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[689][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[689][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[689][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[689][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[689][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[689][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[689][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[689][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[689][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[689][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[689][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[689][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[689][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[689][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[689][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[689][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[689][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[689][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[689][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[689][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[689][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[689][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[689][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[689][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[689][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[689][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[689][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[689][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[689][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[689][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[689][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[689][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[689][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[689][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[689][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[689][LB] = ActionEntry(SHIFT, 176);
   _actionMap[689][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[689][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[689][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[689][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[689][TRUEVAL] = ActionEntry(SHIFT, 173);
}
void Cego::loadParser144()
{
   _actionMap[689][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[689][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[689][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[689][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[689][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[689][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[689][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[689][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[689][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[689][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[689][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[689][MAX] = ActionEntry(SHIFT, 154);
   _jumpMap[689][ObjSpec] = 121;
   _jumpMap[689][Constant] = 120;
   _jumpMap[689][SignedFloat] = 119;
   _jumpMap[689][SignedInt] = 118;
   _jumpMap[689][Attribute] = 117;
   _jumpMap[689][Function] = 116;
   _jumpMap[689][CasePrepare] = 115;
   _jumpMap[689][CaseClause] = 114;
   _jumpMap[689][Factor] = 113;
   _jumpMap[689][Term] = 112;
   _jumpMap[689][Expr] = 793;
   _actionMap[690][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[690][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[690][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[690][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[690][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[690][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[690][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[690][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[690][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[690][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[690][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[690][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[690][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[690][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[690][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[690][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[690][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[690][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[690][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[690][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[690][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[690][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[690][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[690][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[690][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[690][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[690][RANDINT] = ActionEntry(SHIFT, 160);
}
void Cego::loadParser145()
{
   _actionMap[690][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[690][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[690][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[690][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[690][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[690][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[690][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[690][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[690][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[690][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[690][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[690][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[690][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[690][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[690][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[690][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[690][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[690][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[690][LB] = ActionEntry(SHIFT, 176);
   _actionMap[690][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[690][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[690][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[690][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[690][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[690][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[690][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[690][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[690][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[690][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[690][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[690][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[690][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[690][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[690][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[690][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[690][MAX] = ActionEntry(SHIFT, 154);
   _actionMap[690][RB] = ActionEntry(REDUCE, 147);
   _jumpMap[690][ObjSpec] = 121;
   _jumpMap[690][Constant] = 120;
   _jumpMap[690][SignedFloat] = 119;
   _jumpMap[690][SignedInt] = 118;
   _jumpMap[690][Attribute] = 117;
   _jumpMap[690][Function] = 116;
   _jumpMap[690][CasePrepare] = 115;
   _jumpMap[690][CaseClause] = 114;
   _jumpMap[690][Factor] = 113;
   _jumpMap[690][Term] = 112;
   _jumpMap[690][Expr] = 385;
   _jumpMap[690][ProcValueList] = 384;
   _jumpMap[690][ProcValueListOpt] = 794;
}
void Cego::loadParser146()
{
   _actionMap[375][SEMICOLON] = ActionEntry(REDUCE, 78);
   _actionMap[376][SEMICOLON] = ActionEntry(REDUCE, 301);
   _actionMap[377][KSEP] = ActionEntry(SHIFT, 531);
   _actionMap[377][SEMICOLON] = ActionEntry(REDUCE, 303);
   _actionMap[378][CHECK] = ActionEntry(SHIFT, 532);
   _actionMap[378][FOREIGN] = ActionEntry(SHIFT, 534);
   _actionMap[378][COLUMN] = ActionEntry(SHIFT, 533);
   _actionMap[379][COLUMN] = ActionEntry(SHIFT, 535);
   _actionMap[380][COLUMN] = ActionEntry(SHIFT, 536);
   _actionMap[381][COLUMN] = ActionEntry(SHIFT, 537);
   _actionMap[382][STRINGVAL] = ActionEntry(SHIFT, 538);
   _actionMap[383][RB] = ActionEntry(SHIFT, 386);
   _actionMap[384][KSEP] = ActionEntry(SHIFT, 539);
   _actionMap[384][RB] = ActionEntry(REDUCE, 146);
   _actionMap[385][PLUS] = ActionEntry(SHIFT, 275);
   _actionMap[385][MINUS] = ActionEntry(SHIFT, 274);
   _actionMap[385][CONCAT] = ActionEntry(SHIFT, 273);
   _actionMap[385][KSEP] = ActionEntry(REDUCE, 149);
   _actionMap[385][RB] = ActionEntry(REDUCE, 149);
   _actionMap[386][SEMICOLON] = ActionEntry(REDUCE, 60);
   _actionMap[387][END_TOKEN] = ActionEntry(SHIFT, 540);
   _actionMap[388][EXCEPTION] = ActionEntry(REDUCE, 144);
   _actionMap[388][ELSE] = ActionEntry(REDUCE, 144);
   _actionMap[388][ELSIF] = ActionEntry(REDUCE, 144);
   _actionMap[388][END_TOKEN] = ActionEntry(REDUCE, 144);
   _actionMap[388][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[388][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[388][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[388][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[388][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[388][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[388][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[388][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[388][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[388][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[388][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[388][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[388][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[388][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[388][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[388][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[388][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[388][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[388][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[388][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[388][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[388][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[388][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[388][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[388][STR2DATE] = ActionEntry(SHIFT, 171);
}
void Cego::loadParser147()
{
   _actionMap[388][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[388][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[388][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[388][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[388][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[388][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[388][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[388][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[388][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[388][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[388][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[388][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[388][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[388][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[388][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[388][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[388][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[388][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[388][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[388][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[388][LB] = ActionEntry(SHIFT, 176);
   _actionMap[388][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[388][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[388][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[388][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[388][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[388][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[388][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[388][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[388][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[388][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[388][VARREF] = ActionEntry(SHIFT, 410);
   _actionMap[388][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[388][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[388][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[388][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[388][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[388][MAX] = ActionEntry(SHIFT, 154);
   _actionMap[388][IF] = ActionEntry(SHIFT, 404);
   _actionMap[388][BEGIN] = ActionEntry(SHIFT, 401);
   _actionMap[388][UNLOCK] = ActionEntry(SHIFT, 28);
   _actionMap[388][LOCK] = ActionEntry(SHIFT, 27);
   _actionMap[388][ROLLBACK] = ActionEntry(SHIFT, 33);
   _actionMap[388][COMMIT] = ActionEntry(SHIFT, 18);
   _actionMap[388][START_TOKEN] = ActionEntry(SHIFT, 37);
   _actionMap[388][UPDATE] = ActionEntry(SHIFT, 43);
   _actionMap[388][DELETETOK] = ActionEntry(SHIFT, 20);
   _actionMap[388][INSERT] = ActionEntry(SHIFT, 23);
   _actionMap[388][VAR] = ActionEntry(SHIFT, 408);
   _actionMap[388][CURSOR] = ActionEntry(SHIFT, 403);
}
void Cego::loadParser148()
{
   _actionMap[388][CLOSE] = ActionEntry(SHIFT, 402);
   _actionMap[388][NOOP] = ActionEntry(SHIFT, 405);
   _actionMap[388][THROW] = ActionEntry(SHIFT, 407);
   _actionMap[388][RETURNTOKEN] = ActionEntry(SHIFT, 406);
   _actionMap[388][WHILE] = ActionEntry(SHIFT, 409);
   _jumpMap[388][ObjSpec] = 121;
   _jumpMap[388][Constant] = 120;
   _jumpMap[388][SignedFloat] = 119;
   _jumpMap[388][SignedInt] = 118;
   _jumpMap[388][Attribute] = 117;
   _jumpMap[388][Function] = 116;
   _jumpMap[388][DeleteStatement] = 400;
   _jumpMap[388][UpdateStatement] = 399;
   _jumpMap[388][InsertStatement] = 398;
   _jumpMap[388][UnlockStatement] = 397;
   _jumpMap[388][LockStatement] = 396;
   _jumpMap[388][RollbackStatement] = 395;
   _jumpMap[388][CommitStatement] = 394;
   _jumpMap[388][StartStatement] = 393;
   _jumpMap[388][CasePrepare] = 115;
   _jumpMap[388][CaseClause] = 114;
   _jumpMap[388][Factor] = 113;
   _jumpMap[388][Term] = 112;
   _jumpMap[388][Expr] = 392;
   _jumpMap[388][ProcStatement] = 542;
   _jumpMap[388][ProcIfPart] = 390;
   _jumpMap[388][ProcExceptionList] = 541;
   _jumpMap[388][ProcBlockStart] = 389;
   _actionMap[389][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[389][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[389][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[389][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[389][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[389][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[389][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[389][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[389][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[389][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[389][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[389][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[389][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[389][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[389][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[389][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[389][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[389][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[389][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[389][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[389][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[389][TRUNC] = ActionEntry(SHIFT, 174);
}
void Cego::loadParser149()
{
   _actionMap[389][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[389][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[389][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[389][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[389][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[389][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[389][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[389][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[389][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[389][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[389][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[389][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[389][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[389][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[389][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[389][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[389][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[389][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[389][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[389][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[389][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[389][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[389][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[389][LB] = ActionEntry(SHIFT, 176);
   _actionMap[389][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[389][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[389][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[389][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[389][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[389][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[389][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[389][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[389][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[389][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[389][VARREF] = ActionEntry(SHIFT, 410);
   _actionMap[389][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[389][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[389][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[389][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[389][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[389][MAX] = ActionEntry(SHIFT, 154);
   _actionMap[389][IF] = ActionEntry(SHIFT, 404);
   _actionMap[389][BEGIN] = ActionEntry(SHIFT, 401);
   _actionMap[389][UNLOCK] = ActionEntry(SHIFT, 28);
   _actionMap[389][LOCK] = ActionEntry(SHIFT, 27);
   _actionMap[389][ROLLBACK] = ActionEntry(SHIFT, 33);
   _actionMap[389][COMMIT] = ActionEntry(SHIFT, 18);
   _actionMap[389][START_TOKEN] = ActionEntry(SHIFT, 37);
   _actionMap[389][UPDATE] = ActionEntry(SHIFT, 43);
   _actionMap[389][DELETETOK] = ActionEntry(SHIFT, 20);
}
void Cego::loadParser150()
{
   _actionMap[389][INSERT] = ActionEntry(SHIFT, 23);
   _actionMap[389][VAR] = ActionEntry(SHIFT, 408);
   _actionMap[389][CURSOR] = ActionEntry(SHIFT, 403);
   _actionMap[389][CLOSE] = ActionEntry(SHIFT, 402);
   _actionMap[389][NOOP] = ActionEntry(SHIFT, 405);
   _actionMap[389][THROW] = ActionEntry(SHIFT, 407);
   _actionMap[389][RETURNTOKEN] = ActionEntry(SHIFT, 406);
   _actionMap[389][WHILE] = ActionEntry(SHIFT, 409);
   _jumpMap[389][ObjSpec] = 121;
   _jumpMap[389][Constant] = 120;
   _jumpMap[389][SignedFloat] = 119;
   _jumpMap[389][SignedInt] = 118;
   _jumpMap[389][Attribute] = 117;
   _jumpMap[389][Function] = 116;
   _jumpMap[389][DeleteStatement] = 400;
   _jumpMap[389][UpdateStatement] = 399;
   _jumpMap[389][InsertStatement] = 398;
   _jumpMap[389][UnlockStatement] = 397;
   _jumpMap[389][LockStatement] = 396;
   _jumpMap[389][RollbackStatement] = 395;
   _jumpMap[389][CommitStatement] = 394;
   _jumpMap[389][StartStatement] = 393;
   _jumpMap[389][CasePrepare] = 115;
   _jumpMap[389][CaseClause] = 114;
   _jumpMap[389][Factor] = 113;
   _jumpMap[389][Term] = 112;
   _jumpMap[389][Expr] = 392;
   _jumpMap[389][ProcStatement] = 391;
   _jumpMap[389][ProcIfPart] = 390;
   _jumpMap[389][ProcBlockStart] = 389;
   _jumpMap[389][ProcStatementList] = 388;
   _jumpMap[389][ProcStmtBlock] = 543;
   _actionMap[390][ELSIF] = ActionEntry(SHIFT, 546);
   _actionMap[390][END_TOKEN] = ActionEntry(REDUCE, 154);
   _actionMap[390][ELSE] = ActionEntry(REDUCE, 154);
   _jumpMap[390][ProcElsIfOpt] = 545;
   _jumpMap[390][ProcElsIfList] = 544;
   _actionMap[391][SEMICOLON] = ActionEntry(SHIFT, 547);
   _actionMap[392][PLUS] = ActionEntry(SHIFT, 275);
   _actionMap[392][MINUS] = ActionEntry(SHIFT, 274);
   _actionMap[392][CONCAT] = ActionEntry(SHIFT, 273);
   _actionMap[392][SEMICOLON] = ActionEntry(REDUCE, 125);
   _actionMap[393][SEMICOLON] = ActionEntry(REDUCE, 134);
   _actionMap[394][SEMICOLON] = ActionEntry(REDUCE, 135);
   _actionMap[395][SEMICOLON] = ActionEntry(REDUCE, 136);
   _actionMap[396][SEMICOLON] = ActionEntry(REDUCE, 137);
   _actionMap[397][SEMICOLON] = ActionEntry(REDUCE, 138);
   _actionMap[398][SEMICOLON] = ActionEntry(REDUCE, 131);
   _actionMap[399][SEMICOLON] = ActionEntry(REDUCE, 133);
   _actionMap[400][SEMICOLON] = ActionEntry(REDUCE, 132);
}
void Cego::loadParser151()
{
   _actionMap[401][VAR] = ActionEntry(REDUCE, 142);
   _actionMap[401][CURSOR] = ActionEntry(REDUCE, 142);
   _actionMap[401][CLOSE] = ActionEntry(REDUCE, 142);
   _actionMap[401][VARREF] = ActionEntry(REDUCE, 142);
   _actionMap[401][NOOP] = ActionEntry(REDUCE, 142);
   _actionMap[401][THROW] = ActionEntry(REDUCE, 142);
   _actionMap[401][RETURNTOKEN] = ActionEntry(REDUCE, 142);
   _actionMap[401][WHILE] = ActionEntry(REDUCE, 142);
   _actionMap[401][IF] = ActionEntry(REDUCE, 142);
   _actionMap[401][BEGIN] = ActionEntry(REDUCE, 142);
   _actionMap[401][UNLOCK] = ActionEntry(REDUCE, 142);
   _actionMap[401][LOCK] = ActionEntry(REDUCE, 142);
   _actionMap[401][ROLLBACK] = ActionEntry(REDUCE, 142);
   _actionMap[401][COMMIT] = ActionEntry(REDUCE, 142);
   _actionMap[401][START_TOKEN] = ActionEntry(REDUCE, 142);
   _actionMap[401][UPDATE] = ActionEntry(REDUCE, 142);
   _actionMap[401][DELETETOK] = ActionEntry(REDUCE, 142);
   _actionMap[401][INSERT] = ActionEntry(REDUCE, 142);
   _actionMap[401][FETCH] = ActionEntry(REDUCE, 142);
   _actionMap[401][LB] = ActionEntry(REDUCE, 142);
   _actionMap[401][COUNT] = ActionEntry(REDUCE, 142);
   _actionMap[401][SUM] = ActionEntry(REDUCE, 142);
   _actionMap[401][AVG] = ActionEntry(REDUCE, 142);
   _actionMap[401][MIN] = ActionEntry(REDUCE, 142);
   _actionMap[401][MAX] = ActionEntry(REDUCE, 142);
   _actionMap[401][CASE] = ActionEntry(REDUCE, 142);
   _actionMap[401][INT2ASC] = ActionEntry(REDUCE, 142);
   _actionMap[401][ASC2INT] = ActionEntry(REDUCE, 142);
   _actionMap[401][TRIM] = ActionEntry(REDUCE, 142);
   _actionMap[401][RTRIM] = ActionEntry(REDUCE, 142);
   _actionMap[401][LTRIM] = ActionEntry(REDUCE, 142);
   _actionMap[401][ROUND] = ActionEntry(REDUCE, 142);
   _actionMap[401][DATE2STR] = ActionEntry(REDUCE, 142);
   _actionMap[401][DATE2LONG] = ActionEntry(REDUCE, 142);
   _actionMap[401][LONG2DATE] = ActionEntry(REDUCE, 142);
   _actionMap[401][NEWDATE] = ActionEntry(REDUCE, 142);
   _actionMap[401][LOWER] = ActionEntry(REDUCE, 142);
   _actionMap[401][UPPER] = ActionEntry(REDUCE, 142);
   _actionMap[401][LEFT] = ActionEntry(REDUCE, 142);
   _actionMap[401][RIGHT] = ActionEntry(REDUCE, 142);
   _actionMap[401][GETPOS] = ActionEntry(REDUCE, 142);
   _actionMap[401][SUBSTR] = ActionEntry(REDUCE, 142);
   _actionMap[401][REPLACE] = ActionEntry(REDUCE, 142);
   _actionMap[401][LENGTH] = ActionEntry(REDUCE, 142);
   _actionMap[401][TRUNC] = ActionEntry(REDUCE, 142);
   _actionMap[401][STR2INT] = ActionEntry(REDUCE, 142);
   _actionMap[401][STR2LONG] = ActionEntry(REDUCE, 142);
   _actionMap[401][STR2DATE] = ActionEntry(REDUCE, 142);
   _actionMap[401][RANDSTR] = ActionEntry(REDUCE, 142);
   _actionMap[401][RANDINT] = ActionEntry(REDUCE, 142);
}
void Cego::loadParser152()
{
   _actionMap[401][MOD] = ActionEntry(REDUCE, 142);
   _actionMap[401][DIV] = ActionEntry(REDUCE, 142);
   _actionMap[401][LMOD] = ActionEntry(REDUCE, 142);
   _actionMap[401][LDIV] = ActionEntry(REDUCE, 142);
   _actionMap[401][POWER] = ActionEntry(REDUCE, 142);
   _actionMap[401][BITAND] = ActionEntry(REDUCE, 142);
   _actionMap[401][BITOR] = ActionEntry(REDUCE, 142);
   _actionMap[401][BITXOR] = ActionEntry(REDUCE, 142);
   _actionMap[401][BLOBSIZE] = ActionEntry(REDUCE, 142);
   _actionMap[401][BLOBREF] = ActionEntry(REDUCE, 142);
   _actionMap[401][CLOBSIZE] = ActionEntry(REDUCE, 142);
   _actionMap[401][CLOBREF] = ActionEntry(REDUCE, 142);
   _actionMap[401][CLOB2STR] = ActionEntry(REDUCE, 142);
   _actionMap[401][NEXTCOUNT] = ActionEntry(REDUCE, 142);
   _actionMap[401][SETCOUNT] = ActionEntry(REDUCE, 142);
   _actionMap[401][IDENTIFIER] = ActionEntry(REDUCE, 142);
   _actionMap[401][QUALIFIEDOBJ] = ActionEntry(REDUCE, 142);
   _actionMap[401][QUALIFIEDTS] = ActionEntry(REDUCE, 142);
   _actionMap[401][QUALIFIEDPRE] = ActionEntry(REDUCE, 142);
   _actionMap[401][STRINGVAL] = ActionEntry(REDUCE, 142);
   _actionMap[401][DATE] = ActionEntry(REDUCE, 142);
   _actionMap[401][SYSDATE] = ActionEntry(REDUCE, 142);
   _actionMap[401][NULLTOKEN] = ActionEntry(REDUCE, 142);
   _actionMap[401][TRUEVAL] = ActionEntry(REDUCE, 142);
   _actionMap[401][FALSEVAL] = ActionEntry(REDUCE, 142);
   _actionMap[401][BLOB] = ActionEntry(REDUCE, 142);
   _actionMap[401][CLOB] = ActionEntry(REDUCE, 142);
   _actionMap[401][FLOATVAL] = ActionEntry(REDUCE, 142);
   _actionMap[401][MINUS] = ActionEntry(REDUCE, 142);
   _actionMap[401][INTVAL] = ActionEntry(REDUCE, 142);
   _actionMap[402][IDENTIFIER] = ActionEntry(SHIFT, 548);
   _actionMap[403][IDENTIFIER] = ActionEntry(SHIFT, 549);
   _actionMap[404][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[404][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[404][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[404][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[404][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[404][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[404][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[404][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[404][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[404][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[404][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[404][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[404][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[404][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[404][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[404][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[404][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[404][GETPOS] = ActionEntry(SHIFT, 143);
}
void Cego::loadParser153()
{
   _actionMap[404][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[404][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[404][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[404][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[404][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[404][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[404][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[404][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[404][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[404][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[404][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[404][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[404][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[404][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[404][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[404][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[404][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[404][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[404][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[404][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[404][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[404][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[404][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[404][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[404][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[404][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[404][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[404][LB] = ActionEntry(SHIFT, 554);
   _actionMap[404][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[404][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[404][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[404][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[404][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[404][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[404][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[404][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[404][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[404][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[404][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[404][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[404][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[404][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[404][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[404][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[404][MAX] = ActionEntry(SHIFT, 154);
   _jumpMap[404][ObjSpec] = 121;
   _jumpMap[404][Constant] = 120;
   _jumpMap[404][SignedFloat] = 119;
   _jumpMap[404][SignedInt] = 118;
   _jumpMap[404][Attribute] = 117;
}
void Cego::loadParser154()
{
   _jumpMap[404][Function] = 116;
   _jumpMap[404][CasePrepare] = 115;
   _jumpMap[404][CaseClause] = 114;
   _jumpMap[404][Factor] = 113;
   _jumpMap[404][Term] = 112;
   _jumpMap[404][Expr] = 553;
   _jumpMap[404][ProcPredicate] = 552;
   _jumpMap[404][ProcCondition] = 551;
   _jumpMap[404][ProcIfCondition] = 550;
   _actionMap[405][SEMICOLON] = ActionEntry(REDUCE, 126);
   _actionMap[406][SEMICOLON] = ActionEntry(REDUCE, 139);
   _actionMap[406][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[406][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[406][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[406][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[406][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[406][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[406][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[406][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[406][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[406][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[406][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[406][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[406][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[406][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[406][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[406][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[406][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[406][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[406][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[406][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[406][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[406][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[406][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[406][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[406][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[406][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[406][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[406][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[406][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[406][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[406][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[406][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[406][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[406][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[406][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[406][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[406][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[406][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[406][CLOBREF] = ActionEntry(SHIFT, 134);
}
void Cego::loadParser155()
{
   _actionMap[406][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[406][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[406][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[406][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[406][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[406][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[406][LB] = ActionEntry(SHIFT, 176);
   _actionMap[406][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[406][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[406][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[406][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[406][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[406][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[406][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[406][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[406][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[406][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[406][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[406][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[406][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[406][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[406][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[406][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[406][MAX] = ActionEntry(SHIFT, 154);
   _jumpMap[406][ObjSpec] = 121;
   _jumpMap[406][Constant] = 120;
   _jumpMap[406][SignedFloat] = 119;
   _jumpMap[406][SignedInt] = 118;
   _jumpMap[406][Attribute] = 117;
   _jumpMap[406][Function] = 116;
   _jumpMap[406][CasePrepare] = 115;
   _jumpMap[406][CaseClause] = 114;
   _jumpMap[406][Factor] = 113;
   _jumpMap[406][Term] = 112;
   _jumpMap[406][Expr] = 555;
   _actionMap[407][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[407][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[407][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[407][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[407][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[407][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[407][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[407][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[407][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[407][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[407][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[407][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[407][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[407][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[407][UPPER] = ActionEntry(SHIFT, 175);
}
void Cego::loadParser156()
{
   _actionMap[407][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[407][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[407][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[407][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[407][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[407][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[407][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[407][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[407][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[407][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[407][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[407][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[407][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[407][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[407][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[407][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[407][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[407][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[407][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[407][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[407][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[407][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[407][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[407][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[407][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[407][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[407][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[407][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[407][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[407][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[407][LB] = ActionEntry(SHIFT, 176);
   _actionMap[407][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[407][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[407][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[407][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[407][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[407][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[407][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[407][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[407][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[407][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[407][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[407][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[407][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[407][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[407][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[407][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[407][MAX] = ActionEntry(SHIFT, 154);
   _jumpMap[407][ObjSpec] = 121;
   _jumpMap[407][Constant] = 120;
}
void Cego::loadParser157()
{
   _jumpMap[407][SignedFloat] = 119;
   _jumpMap[407][SignedInt] = 118;
   _jumpMap[407][Attribute] = 117;
   _jumpMap[407][Function] = 116;
   _jumpMap[407][CasePrepare] = 115;
   _jumpMap[407][CaseClause] = 114;
   _jumpMap[407][Factor] = 113;
   _jumpMap[407][Term] = 112;
   _jumpMap[407][Expr] = 556;
   _actionMap[408][IDENTIFIER] = ActionEntry(SHIFT, 557);
   _actionMap[409][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[409][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[409][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[409][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[409][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[409][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[409][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[409][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[409][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[409][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[409][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[409][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[409][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[409][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[409][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[409][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[409][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[409][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[409][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[409][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[409][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[409][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[409][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[409][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[409][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[409][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[409][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[409][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[409][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[409][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[409][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[409][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[409][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[409][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[409][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[409][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[409][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[409][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[409][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[409][CLOB2STR] = ActionEntry(SHIFT, 135);
}
void Cego::loadParser158()
{
   _actionMap[409][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[409][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[409][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[409][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[409][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[409][LB] = ActionEntry(SHIFT, 554);
   _actionMap[409][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[409][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[409][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[409][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[409][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[409][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[409][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[409][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[409][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[409][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[409][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[409][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[409][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[409][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[409][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[409][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[409][MAX] = ActionEntry(SHIFT, 154);
   _jumpMap[409][ObjSpec] = 121;
   _jumpMap[409][Constant] = 120;
   _jumpMap[409][SignedFloat] = 119;
   _jumpMap[409][SignedInt] = 118;
   _jumpMap[409][Attribute] = 117;
   _jumpMap[409][Function] = 116;
   _jumpMap[409][CasePrepare] = 115;
   _jumpMap[409][CaseClause] = 114;
   _jumpMap[409][Factor] = 113;
   _jumpMap[409][Term] = 112;
   _jumpMap[409][Expr] = 553;
   _jumpMap[409][ProcPredicate] = 552;
   _jumpMap[409][ProcCondition] = 559;
   _jumpMap[409][ProcWhileCondition] = 558;
   _actionMap[410][CONCAT] = ActionEntry(REDUCE, 177);
   _actionMap[410][STAR] = ActionEntry(REDUCE, 177);
   _actionMap[410][DIVISION] = ActionEntry(REDUCE, 177);
   _actionMap[410][MINUS] = ActionEntry(REDUCE, 177);
   _actionMap[410][PLUS] = ActionEntry(REDUCE, 177);
   _actionMap[410][SEMICOLON] = ActionEntry(REDUCE, 177);
   _actionMap[410][EQU] = ActionEntry(SHIFT, 560);
   _actionMap[411][END_TOKEN] = ActionEntry(SHIFT, 561);
   _actionMap[412][ON] = ActionEntry(SHIFT, 562);
   _actionMap[413][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[413][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[413][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[413][ObjSpec] = 563;
}
void Cego::loadParser159()
{
   _actionMap[414][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[414][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[414][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[414][ObjSpec] = 564;
   _actionMap[415][IDENTIFIER] = ActionEntry(SHIFT, 569);
   _actionMap[415][RB] = ActionEntry(REDUCE, 113);
   _jumpMap[415][ProcArg] = 567;
   _jumpMap[415][ProcArgList] = 566;
   _jumpMap[415][ProcArgOpt] = 565;
   _actionMap[416][IDENTIFIER] = ActionEntry(SHIFT, 574);
   _actionMap[416][PRIMARY] = ActionEntry(SHIFT, 573);
   _jumpMap[416][ColumnDesc] = 572;
   _jumpMap[416][KeyColumn] = 571;
   _jumpMap[416][ColumnList] = 570;
   _actionMap[417][INSERT] = ActionEntry(SHIFT, 578);
   _actionMap[417][UPDATE] = ActionEntry(SHIFT, 579);
   _actionMap[417][DELETETOK] = ActionEntry(SHIFT, 577);
   _jumpMap[417][TriggerOp] = 576;
   _jumpMap[417][TriggerCondition] = 575;
   _actionMap[418][INSERT] = ActionEntry(REDUCE, 102);
   _actionMap[418][UPDATE] = ActionEntry(REDUCE, 102);
   _actionMap[418][DELETETOK] = ActionEntry(REDUCE, 102);
   _actionMap[419][INSERT] = ActionEntry(REDUCE, 101);
   _actionMap[419][UPDATE] = ActionEntry(REDUCE, 101);
   _actionMap[419][DELETETOK] = ActionEntry(REDUCE, 101);
   _actionMap[420][SELECT] = ActionEntry(SHIFT, 34);
   _jumpMap[420][SelectStatement] = 580;
   _actionMap[421][SEMICOLON] = ActionEntry(REDUCE, 362);
   _actionMap[421][WHERE] = ActionEntry(SHIFT, 424);
   _jumpMap[421][NoWhere] = 423;
   _jumpMap[421][WhereClause] = 422;
   _actionMap[422][SEMICOLON] = ActionEntry(REDUCE, 298);
   _actionMap[423][RETURNTOKEN] = ActionEntry(REDUCE, 361);
   _actionMap[423][GROUP] = ActionEntry(REDUCE, 361);
   _actionMap[423][ORDER] = ActionEntry(REDUCE, 361);
   _actionMap[423][ROWLIMIT] = ActionEntry(REDUCE, 361);
   _actionMap[423][UNION] = ActionEntry(REDUCE, 361);
   _actionMap[423][ENDTOKEN] = ActionEntry(REDUCE, 361);
   _actionMap[423][RB] = ActionEntry(REDUCE, 361);
   _actionMap[423][SEMICOLON] = ActionEntry(REDUCE, 361);
   _actionMap[424][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[424][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[424][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[424][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[424][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[424][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[424][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[424][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[424][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[424][DATE2STR] = ActionEntry(SHIFT, 138);
}
void Cego::loadParser160()
{
   _actionMap[424][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[424][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[424][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[424][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[424][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[424][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[424][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[424][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[424][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[424][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[424][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[424][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[424][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[424][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[424][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[424][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[424][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[424][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[424][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[424][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[424][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[424][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[424][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[424][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[424][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[424][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[424][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[424][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[424][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[424][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[424][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[424][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[424][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[424][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[424][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[424][LB] = ActionEntry(SHIFT, 445);
   _actionMap[424][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[424][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[424][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[424][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[424][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[424][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[424][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[424][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[424][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[424][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[424][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[424][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[424][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[424][SUM] = ActionEntry(SHIFT, 167);
}
void Cego::loadParser161()
{
   _actionMap[424][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[424][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[424][MAX] = ActionEntry(SHIFT, 154);
   _actionMap[424][EXISTS] = ActionEntry(SHIFT, 443);
   _actionMap[424][NOT] = ActionEntry(SHIFT, 444);
   _jumpMap[424][ObjSpec] = 121;
   _jumpMap[424][Constant] = 120;
   _jumpMap[424][SignedFloat] = 119;
   _jumpMap[424][SignedInt] = 118;
   _jumpMap[424][Attribute] = 117;
   _jumpMap[424][QueryPredicate] = 442;
   _jumpMap[424][QueryCondition] = 581;
   _jumpMap[424][Function] = 116;
   _jumpMap[424][CasePrepare] = 115;
   _jumpMap[424][CaseClause] = 114;
   _jumpMap[424][Factor] = 113;
   _jumpMap[424][Term] = 112;
   _jumpMap[424][Expr] = 440;
   _actionMap[425][SEMICOLON] = ActionEntry(REDUCE, 27);
   _actionMap[426][SELECT] = ActionEntry(SHIFT, 34);
   _actionMap[426][VALUES] = ActionEntry(SHIFT, 429);
   _jumpMap[426][SelectStatement] = 428;
   _jumpMap[426][InsertPrepare] = 427;
   _actionMap[427][LB] = ActionEntry(SHIFT, 584);
   _jumpMap[427][InsertValueSpec] = 583;
   _jumpMap[427][InsertValueSpecList] = 582;
   _actionMap[428][SEMICOLON] = ActionEntry(REDUCE, 225);
   _actionMap[429][LB] = ActionEntry(REDUCE, 228);
   _actionMap[430][IDENTIFIER] = ActionEntry(SHIFT, 586);
   _jumpMap[430][InsertArgList] = 585;
   _actionMap[431][SEMICOLON] = ActionEntry(REDUCE, 15);
   _actionMap[432][SELECT] = ActionEntry(SHIFT, 34);
   _jumpMap[432][SelectStatement] = 587;
   _actionMap[433][STAR] = ActionEntry(SHIFT, 276);
   _actionMap[433][DIVISION] = ActionEntry(SHIFT, 277);
   _actionMap[433][WHEN] = ActionEntry(REDUCE, 173);
   _actionMap[433][ELSE] = ActionEntry(REDUCE, 173);
   _actionMap[433][LEFT] = ActionEntry(REDUCE, 173);
   _actionMap[433][RIGHT] = ActionEntry(REDUCE, 173);
   _actionMap[433][INNER] = ActionEntry(REDUCE, 173);
   _actionMap[433][JOIN] = ActionEntry(REDUCE, 173);
   _actionMap[433][RETURNTOKEN] = ActionEntry(REDUCE, 173);
   _actionMap[433][ORDER] = ActionEntry(REDUCE, 173);
   _actionMap[433][GROUP] = ActionEntry(REDUCE, 173);
   _actionMap[433][WHERE] = ActionEntry(REDUCE, 173);
   _actionMap[433][BEGIN] = ActionEntry(REDUCE, 173);
   _actionMap[433][THEN] = ActionEntry(REDUCE, 173);
   _actionMap[433][OR] = ActionEntry(REDUCE, 173);
   _actionMap[433][AS] = ActionEntry(REDUCE, 173);
   _actionMap[433][FROM] = ActionEntry(REDUCE, 173);
}
void Cego::loadParser162()
{
   _actionMap[433][LIKE] = ActionEntry(REDUCE, 173);
   _actionMap[433][BETWEEN] = ActionEntry(REDUCE, 173);
   _actionMap[433][NOT] = ActionEntry(REDUCE, 173);
   _actionMap[433][INTOK] = ActionEntry(REDUCE, 173);
   _actionMap[433][END_TOKEN] = ActionEntry(REDUCE, 173);
   _actionMap[433][AND] = ActionEntry(REDUCE, 173);
   _actionMap[433][IS] = ActionEntry(REDUCE, 173);
   _actionMap[433][EQU] = ActionEntry(REDUCE, 173);
   _actionMap[433][NEGATION] = ActionEntry(REDUCE, 173);
   _actionMap[433][LT] = ActionEntry(REDUCE, 173);
   _actionMap[433][MT] = ActionEntry(REDUCE, 173);
   _actionMap[433][DESC] = ActionEntry(REDUCE, 173);
   _actionMap[433][ASC] = ActionEntry(REDUCE, 173);
   _actionMap[433][KSEP] = ActionEntry(REDUCE, 173);
   _actionMap[433][ROWLIMIT] = ActionEntry(REDUCE, 173);
   _actionMap[433][UNION] = ActionEntry(REDUCE, 173);
   _actionMap[433][ENDTOKEN] = ActionEntry(REDUCE, 173);
   _actionMap[433][RB] = ActionEntry(REDUCE, 173);
   _actionMap[433][SEMICOLON] = ActionEntry(REDUCE, 173);
   _actionMap[433][CONCAT] = ActionEntry(REDUCE, 173);
   _actionMap[433][MINUS] = ActionEntry(REDUCE, 173);
   _actionMap[433][PLUS] = ActionEntry(REDUCE, 173);
   _actionMap[434][STAR] = ActionEntry(SHIFT, 276);
   _actionMap[434][DIVISION] = ActionEntry(SHIFT, 277);
   _actionMap[434][WHEN] = ActionEntry(REDUCE, 171);
   _actionMap[434][ELSE] = ActionEntry(REDUCE, 171);
   _actionMap[434][LEFT] = ActionEntry(REDUCE, 171);
   _actionMap[434][RIGHT] = ActionEntry(REDUCE, 171);
   _actionMap[434][INNER] = ActionEntry(REDUCE, 171);
   _actionMap[434][JOIN] = ActionEntry(REDUCE, 171);
   _actionMap[434][RETURNTOKEN] = ActionEntry(REDUCE, 171);
   _actionMap[434][ORDER] = ActionEntry(REDUCE, 171);
   _actionMap[434][GROUP] = ActionEntry(REDUCE, 171);
   _actionMap[434][WHERE] = ActionEntry(REDUCE, 171);
   _actionMap[434][BEGIN] = ActionEntry(REDUCE, 171);
   _actionMap[434][THEN] = ActionEntry(REDUCE, 171);
   _actionMap[434][OR] = ActionEntry(REDUCE, 171);
   _actionMap[434][AS] = ActionEntry(REDUCE, 171);
   _actionMap[434][FROM] = ActionEntry(REDUCE, 171);
   _actionMap[434][LIKE] = ActionEntry(REDUCE, 171);
   _actionMap[434][BETWEEN] = ActionEntry(REDUCE, 171);
   _actionMap[434][NOT] = ActionEntry(REDUCE, 171);
   _actionMap[434][INTOK] = ActionEntry(REDUCE, 171);
   _actionMap[434][END_TOKEN] = ActionEntry(REDUCE, 171);
   _actionMap[434][AND] = ActionEntry(REDUCE, 171);
   _actionMap[434][IS] = ActionEntry(REDUCE, 171);
   _actionMap[434][EQU] = ActionEntry(REDUCE, 171);
   _actionMap[434][NEGATION] = ActionEntry(REDUCE, 171);
   _actionMap[434][LT] = ActionEntry(REDUCE, 171);
   _actionMap[434][MT] = ActionEntry(REDUCE, 171);
}
void Cego::loadParser163()
{
   _actionMap[434][DESC] = ActionEntry(REDUCE, 171);
   _actionMap[434][ASC] = ActionEntry(REDUCE, 171);
   _actionMap[434][KSEP] = ActionEntry(REDUCE, 171);
   _actionMap[434][ROWLIMIT] = ActionEntry(REDUCE, 171);
   _actionMap[434][UNION] = ActionEntry(REDUCE, 171);
   _actionMap[434][ENDTOKEN] = ActionEntry(REDUCE, 171);
   _actionMap[434][RB] = ActionEntry(REDUCE, 171);
   _actionMap[434][SEMICOLON] = ActionEntry(REDUCE, 171);
   _actionMap[434][CONCAT] = ActionEntry(REDUCE, 171);
   _actionMap[434][MINUS] = ActionEntry(REDUCE, 171);
   _actionMap[434][PLUS] = ActionEntry(REDUCE, 171);
   _actionMap[435][STAR] = ActionEntry(SHIFT, 276);
   _actionMap[435][DIVISION] = ActionEntry(SHIFT, 277);
   _actionMap[435][WHEN] = ActionEntry(REDUCE, 170);
   _actionMap[435][ELSE] = ActionEntry(REDUCE, 170);
   _actionMap[435][LEFT] = ActionEntry(REDUCE, 170);
   _actionMap[435][RIGHT] = ActionEntry(REDUCE, 170);
   _actionMap[435][INNER] = ActionEntry(REDUCE, 170);
   _actionMap[435][JOIN] = ActionEntry(REDUCE, 170);
   _actionMap[435][RETURNTOKEN] = ActionEntry(REDUCE, 170);
   _actionMap[435][ORDER] = ActionEntry(REDUCE, 170);
   _actionMap[435][GROUP] = ActionEntry(REDUCE, 170);
   _actionMap[435][WHERE] = ActionEntry(REDUCE, 170);
   _actionMap[435][BEGIN] = ActionEntry(REDUCE, 170);
   _actionMap[435][THEN] = ActionEntry(REDUCE, 170);
   _actionMap[435][OR] = ActionEntry(REDUCE, 170);
   _actionMap[435][AS] = ActionEntry(REDUCE, 170);
   _actionMap[435][FROM] = ActionEntry(REDUCE, 170);
   _actionMap[435][LIKE] = ActionEntry(REDUCE, 170);
   _actionMap[435][BETWEEN] = ActionEntry(REDUCE, 170);
   _actionMap[435][NOT] = ActionEntry(REDUCE, 170);
   _actionMap[435][INTOK] = ActionEntry(REDUCE, 170);
   _actionMap[435][END_TOKEN] = ActionEntry(REDUCE, 170);
   _actionMap[435][AND] = ActionEntry(REDUCE, 170);
   _actionMap[435][IS] = ActionEntry(REDUCE, 170);
   _actionMap[435][EQU] = ActionEntry(REDUCE, 170);
   _actionMap[435][NEGATION] = ActionEntry(REDUCE, 170);
   _actionMap[435][LT] = ActionEntry(REDUCE, 170);
   _actionMap[435][MT] = ActionEntry(REDUCE, 170);
   _actionMap[435][DESC] = ActionEntry(REDUCE, 170);
   _actionMap[435][ASC] = ActionEntry(REDUCE, 170);
   _actionMap[435][KSEP] = ActionEntry(REDUCE, 170);
   _actionMap[435][ROWLIMIT] = ActionEntry(REDUCE, 170);
   _actionMap[435][UNION] = ActionEntry(REDUCE, 170);
   _actionMap[435][ENDTOKEN] = ActionEntry(REDUCE, 170);
   _actionMap[435][RB] = ActionEntry(REDUCE, 170);
   _actionMap[435][SEMICOLON] = ActionEntry(REDUCE, 170);
   _actionMap[435][CONCAT] = ActionEntry(REDUCE, 170);
   _actionMap[435][MINUS] = ActionEntry(REDUCE, 170);
   _actionMap[435][PLUS] = ActionEntry(REDUCE, 170);
}
void Cego::loadParser164()
{
   _actionMap[436][WHEN] = ActionEntry(REDUCE, 174);
   _actionMap[436][ELSE] = ActionEntry(REDUCE, 174);
   _actionMap[436][LEFT] = ActionEntry(REDUCE, 174);
   _actionMap[436][RIGHT] = ActionEntry(REDUCE, 174);
   _actionMap[436][INNER] = ActionEntry(REDUCE, 174);
   _actionMap[436][JOIN] = ActionEntry(REDUCE, 174);
   _actionMap[436][RETURNTOKEN] = ActionEntry(REDUCE, 174);
   _actionMap[436][ORDER] = ActionEntry(REDUCE, 174);
   _actionMap[436][GROUP] = ActionEntry(REDUCE, 174);
   _actionMap[436][WHERE] = ActionEntry(REDUCE, 174);
   _actionMap[436][BEGIN] = ActionEntry(REDUCE, 174);
   _actionMap[436][THEN] = ActionEntry(REDUCE, 174);
   _actionMap[436][OR] = ActionEntry(REDUCE, 174);
   _actionMap[436][FROM] = ActionEntry(REDUCE, 174);
   _actionMap[436][AS] = ActionEntry(REDUCE, 174);
   _actionMap[436][END_TOKEN] = ActionEntry(REDUCE, 174);
   _actionMap[436][AND] = ActionEntry(REDUCE, 174);
   _actionMap[436][INTOK] = ActionEntry(REDUCE, 174);
   _actionMap[436][NOT] = ActionEntry(REDUCE, 174);
   _actionMap[436][BETWEEN] = ActionEntry(REDUCE, 174);
   _actionMap[436][IS] = ActionEntry(REDUCE, 174);
   _actionMap[436][LIKE] = ActionEntry(REDUCE, 174);
   _actionMap[436][MT] = ActionEntry(REDUCE, 174);
   _actionMap[436][LT] = ActionEntry(REDUCE, 174);
   _actionMap[436][NEGATION] = ActionEntry(REDUCE, 174);
   _actionMap[436][EQU] = ActionEntry(REDUCE, 174);
   _actionMap[436][RB] = ActionEntry(REDUCE, 174);
   _actionMap[436][ENDTOKEN] = ActionEntry(REDUCE, 174);
   _actionMap[436][UNION] = ActionEntry(REDUCE, 174);
   _actionMap[436][ROWLIMIT] = ActionEntry(REDUCE, 174);
   _actionMap[436][KSEP] = ActionEntry(REDUCE, 174);
   _actionMap[436][ASC] = ActionEntry(REDUCE, 174);
   _actionMap[436][DESC] = ActionEntry(REDUCE, 174);
   _actionMap[436][SEMICOLON] = ActionEntry(REDUCE, 174);
   _actionMap[436][PLUS] = ActionEntry(REDUCE, 174);
   _actionMap[436][MINUS] = ActionEntry(REDUCE, 174);
   _actionMap[436][CONCAT] = ActionEntry(REDUCE, 174);
   _actionMap[436][DIVISION] = ActionEntry(REDUCE, 174);
   _actionMap[436][STAR] = ActionEntry(REDUCE, 174);
   _actionMap[437][WHEN] = ActionEntry(REDUCE, 175);
   _actionMap[437][ELSE] = ActionEntry(REDUCE, 175);
   _actionMap[437][LEFT] = ActionEntry(REDUCE, 175);
   _actionMap[437][RIGHT] = ActionEntry(REDUCE, 175);
   _actionMap[437][INNER] = ActionEntry(REDUCE, 175);
   _actionMap[437][JOIN] = ActionEntry(REDUCE, 175);
   _actionMap[437][RETURNTOKEN] = ActionEntry(REDUCE, 175);
   _actionMap[437][ORDER] = ActionEntry(REDUCE, 175);
   _actionMap[437][GROUP] = ActionEntry(REDUCE, 175);
   _actionMap[437][WHERE] = ActionEntry(REDUCE, 175);
   _actionMap[437][BEGIN] = ActionEntry(REDUCE, 175);
}
void Cego::loadParser165()
{
   _actionMap[437][THEN] = ActionEntry(REDUCE, 175);
   _actionMap[437][OR] = ActionEntry(REDUCE, 175);
   _actionMap[437][FROM] = ActionEntry(REDUCE, 175);
   _actionMap[437][AS] = ActionEntry(REDUCE, 175);
   _actionMap[437][END_TOKEN] = ActionEntry(REDUCE, 175);
   _actionMap[437][AND] = ActionEntry(REDUCE, 175);
   _actionMap[437][INTOK] = ActionEntry(REDUCE, 175);
   _actionMap[437][NOT] = ActionEntry(REDUCE, 175);
   _actionMap[437][BETWEEN] = ActionEntry(REDUCE, 175);
   _actionMap[437][IS] = ActionEntry(REDUCE, 175);
   _actionMap[437][LIKE] = ActionEntry(REDUCE, 175);
   _actionMap[437][MT] = ActionEntry(REDUCE, 175);
   _actionMap[437][LT] = ActionEntry(REDUCE, 175);
   _actionMap[437][NEGATION] = ActionEntry(REDUCE, 175);
   _actionMap[437][EQU] = ActionEntry(REDUCE, 175);
   _actionMap[437][RB] = ActionEntry(REDUCE, 175);
   _actionMap[437][ENDTOKEN] = ActionEntry(REDUCE, 175);
   _actionMap[437][UNION] = ActionEntry(REDUCE, 175);
   _actionMap[437][ROWLIMIT] = ActionEntry(REDUCE, 175);
   _actionMap[437][KSEP] = ActionEntry(REDUCE, 175);
   _actionMap[437][ASC] = ActionEntry(REDUCE, 175);
   _actionMap[437][DESC] = ActionEntry(REDUCE, 175);
   _actionMap[437][SEMICOLON] = ActionEntry(REDUCE, 175);
   _actionMap[437][PLUS] = ActionEntry(REDUCE, 175);
   _actionMap[437][MINUS] = ActionEntry(REDUCE, 175);
   _actionMap[437][CONCAT] = ActionEntry(REDUCE, 175);
   _actionMap[437][DIVISION] = ActionEntry(REDUCE, 175);
   _actionMap[437][STAR] = ActionEntry(REDUCE, 175);
   _actionMap[438][WHEN] = ActionEntry(REDUCE, 192);
   _actionMap[438][ELSE] = ActionEntry(REDUCE, 192);
   _actionMap[439][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[439][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[439][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[439][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[439][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[439][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[439][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[439][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[439][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[439][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[439][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[439][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[439][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[439][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[439][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[439][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[439][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[439][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[439][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[439][REPLACE] = ActionEntry(SHIFT, 161);
}
void Cego::loadParser166()
{
   _actionMap[439][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[439][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[439][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[439][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[439][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[439][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[439][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[439][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[439][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[439][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[439][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[439][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[439][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[439][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[439][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[439][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[439][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[439][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[439][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[439][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[439][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[439][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[439][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[439][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[439][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[439][LB] = ActionEntry(SHIFT, 176);
   _actionMap[439][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[439][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[439][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[439][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[439][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[439][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[439][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[439][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[439][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[439][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[439][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[439][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[439][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[439][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[439][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[439][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[439][MAX] = ActionEntry(SHIFT, 154);
   _jumpMap[439][ObjSpec] = 121;
   _jumpMap[439][Constant] = 120;
   _jumpMap[439][SignedFloat] = 119;
   _jumpMap[439][SignedInt] = 118;
   _jumpMap[439][Attribute] = 117;
   _jumpMap[439][Function] = 116;
   _jumpMap[439][CasePrepare] = 115;
}
void Cego::loadParser167()
{
   _jumpMap[439][CaseClause] = 114;
   _jumpMap[439][Factor] = 113;
   _jumpMap[439][Term] = 112;
   _jumpMap[439][Expr] = 588;
   _actionMap[440][INTOK] = ActionEntry(SHIFT, 591);
   _actionMap[440][NOT] = ActionEntry(SHIFT, 594);
   _actionMap[440][BETWEEN] = ActionEntry(SHIFT, 590);
   _actionMap[440][IS] = ActionEntry(SHIFT, 592);
   _actionMap[440][LIKE] = ActionEntry(SHIFT, 593);
   _actionMap[440][PLUS] = ActionEntry(SHIFT, 275);
   _actionMap[440][MINUS] = ActionEntry(SHIFT, 274);
   _actionMap[440][CONCAT] = ActionEntry(SHIFT, 273);
   _actionMap[440][EQU] = ActionEntry(SHIFT, 595);
   _actionMap[440][NEGATION] = ActionEntry(SHIFT, 598);
   _actionMap[440][LT] = ActionEntry(SHIFT, 596);
   _actionMap[440][MT] = ActionEntry(SHIFT, 597);
   _jumpMap[440][Comparison] = 589;
   _actionMap[441][THEN] = ActionEntry(SHIFT, 601);
   _actionMap[441][AND] = ActionEntry(SHIFT, 599);
   _actionMap[441][OR] = ActionEntry(SHIFT, 600);
   _actionMap[442][LEFT] = ActionEntry(REDUCE, 365);
   _actionMap[442][RIGHT] = ActionEntry(REDUCE, 365);
   _actionMap[442][INNER] = ActionEntry(REDUCE, 365);
   _actionMap[442][JOIN] = ActionEntry(REDUCE, 365);
   _actionMap[442][RETURNTOKEN] = ActionEntry(REDUCE, 365);
   _actionMap[442][SEMICOLON] = ActionEntry(REDUCE, 365);
   _actionMap[442][ENDTOKEN] = ActionEntry(REDUCE, 365);
   _actionMap[442][UNION] = ActionEntry(REDUCE, 365);
   _actionMap[442][ROWLIMIT] = ActionEntry(REDUCE, 365);
   _actionMap[442][ORDER] = ActionEntry(REDUCE, 365);
   _actionMap[442][GROUP] = ActionEntry(REDUCE, 365);
   _actionMap[442][WHERE] = ActionEntry(REDUCE, 365);
   _actionMap[442][THEN] = ActionEntry(REDUCE, 365);
   _actionMap[442][RB] = ActionEntry(REDUCE, 365);
   _actionMap[442][OR] = ActionEntry(REDUCE, 365);
   _actionMap[442][AND] = ActionEntry(REDUCE, 365);
   _actionMap[443][LB] = ActionEntry(SHIFT, 602);
   _actionMap[444][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[444][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[444][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[444][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[444][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[444][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[444][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[444][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[444][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[444][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[444][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[444][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[444][NEWDATE] = ActionEntry(SHIFT, 145);
}
void Cego::loadParser168()
{
   _actionMap[444][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[444][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[444][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[444][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[444][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[444][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[444][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[444][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[444][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[444][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[444][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[444][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[444][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[444][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[444][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[444][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[444][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[444][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[444][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[444][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[444][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[444][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[444][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[444][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[444][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[444][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[444][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[444][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[444][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[444][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[444][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[444][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[444][LB] = ActionEntry(SHIFT, 445);
   _actionMap[444][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[444][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[444][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[444][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[444][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[444][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[444][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[444][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[444][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[444][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[444][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[444][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[444][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[444][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[444][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[444][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[444][MAX] = ActionEntry(SHIFT, 154);
}
void Cego::loadParser169()
{
   _actionMap[444][EXISTS] = ActionEntry(SHIFT, 443);
   _actionMap[444][NOT] = ActionEntry(SHIFT, 444);
   _jumpMap[444][ObjSpec] = 121;
   _jumpMap[444][Constant] = 120;
   _jumpMap[444][SignedFloat] = 119;
   _jumpMap[444][SignedInt] = 118;
   _jumpMap[444][Attribute] = 117;
   _jumpMap[444][QueryPredicate] = 603;
   _jumpMap[444][Function] = 116;
   _jumpMap[444][CasePrepare] = 115;
   _jumpMap[444][CaseClause] = 114;
   _jumpMap[444][Factor] = 113;
   _jumpMap[444][Term] = 112;
   _jumpMap[444][Expr] = 440;
   _actionMap[445][LONG] = ActionEntry(SHIFT, 336);
   _actionMap[445][BIGINT] = ActionEntry(SHIFT, 332);
   _actionMap[445][SMALLINT] = ActionEntry(SHIFT, 337);
   _actionMap[445][TINYINT] = ActionEntry(SHIFT, 338);
   _actionMap[445][DOUBLE] = ActionEntry(SHIFT, 334);
   _actionMap[445][DECIMAL] = ActionEntry(SHIFT, 333);
   _actionMap[445][FIXED] = ActionEntry(SHIFT, 335);
   _actionMap[445][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[445][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[445][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[445][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[445][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[445][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[445][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[445][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[445][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[445][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[445][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[445][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[445][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[445][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[445][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[445][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[445][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[445][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[445][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[445][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[445][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[445][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[445][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[445][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[445][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[445][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[445][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[445][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[445][DIV] = ActionEntry(SHIFT, 140);
}
void Cego::loadParser170()
{
   _actionMap[445][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[445][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[445][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[445][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[445][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[445][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[445][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[445][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[445][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[445][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[445][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[445][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[445][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[445][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[445][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[445][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[445][LB] = ActionEntry(SHIFT, 445);
   _actionMap[445][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[445][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[445][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[445][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[445][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[445][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[445][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[445][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[445][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[445][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[445][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[445][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[445][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[445][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[445][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[445][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[445][MAX] = ActionEntry(SHIFT, 154);
   _actionMap[445][SELECT] = ActionEntry(SHIFT, 34);
   _actionMap[445][EXISTS] = ActionEntry(SHIFT, 443);
   _actionMap[445][NOT] = ActionEntry(SHIFT, 444);
   _jumpMap[445][ObjSpec] = 121;
   _jumpMap[445][Constant] = 120;
   _jumpMap[445][SignedFloat] = 119;
   _jumpMap[445][SignedInt] = 118;
   _jumpMap[445][Attribute] = 117;
   _jumpMap[445][QueryPredicate] = 442;
   _jumpMap[445][QueryCondition] = 605;
   _jumpMap[445][Function] = 116;
   _jumpMap[445][SelectStatement] = 331;
   _jumpMap[445][CasePrepare] = 115;
   _jumpMap[445][CaseClause] = 114;
   _jumpMap[445][Factor] = 113;
   _jumpMap[445][Term] = 112;
}
void Cego::loadParser171()
{
   _jumpMap[445][Expr] = 604;
   _actionMap[446][PLUS] = ActionEntry(SHIFT, 275);
   _actionMap[446][MINUS] = ActionEntry(SHIFT, 274);
   _actionMap[446][CONCAT] = ActionEntry(SHIFT, 273);
   _actionMap[446][KSEP] = ActionEntry(REDUCE, 359);
   _actionMap[446][RB] = ActionEntry(REDUCE, 359);
   _actionMap[447][RB] = ActionEntry(SHIFT, 607);
   _actionMap[447][KSEP] = ActionEntry(SHIFT, 606);
   _actionMap[448][WHEN] = ActionEntry(REDUCE, 357);
   _actionMap[448][ELSE] = ActionEntry(REDUCE, 357);
   _actionMap[448][LEFT] = ActionEntry(REDUCE, 357);
   _actionMap[448][RIGHT] = ActionEntry(REDUCE, 357);
   _actionMap[448][INNER] = ActionEntry(REDUCE, 357);
   _actionMap[448][JOIN] = ActionEntry(REDUCE, 357);
   _actionMap[448][RETURNTOKEN] = ActionEntry(REDUCE, 357);
   _actionMap[448][ORDER] = ActionEntry(REDUCE, 357);
   _actionMap[448][GROUP] = ActionEntry(REDUCE, 357);
   _actionMap[448][WHERE] = ActionEntry(REDUCE, 357);
   _actionMap[448][FROM] = ActionEntry(REDUCE, 357);
   _actionMap[448][AS] = ActionEntry(REDUCE, 357);
   _actionMap[448][END_TOKEN] = ActionEntry(REDUCE, 357);
   _actionMap[448][BEGIN] = ActionEntry(REDUCE, 357);
   _actionMap[448][THEN] = ActionEntry(REDUCE, 357);
   _actionMap[448][OR] = ActionEntry(REDUCE, 357);
   _actionMap[448][AND] = ActionEntry(REDUCE, 357);
   _actionMap[448][INTOK] = ActionEntry(REDUCE, 357);
   _actionMap[448][NOT] = ActionEntry(REDUCE, 357);
   _actionMap[448][BETWEEN] = ActionEntry(REDUCE, 357);
   _actionMap[448][IS] = ActionEntry(REDUCE, 357);
   _actionMap[448][LIKE] = ActionEntry(REDUCE, 357);
   _actionMap[448][MT] = ActionEntry(REDUCE, 357);
   _actionMap[448][LT] = ActionEntry(REDUCE, 357);
   _actionMap[448][NEGATION] = ActionEntry(REDUCE, 357);
   _actionMap[448][EQU] = ActionEntry(REDUCE, 357);
   _actionMap[448][RB] = ActionEntry(REDUCE, 357);
   _actionMap[448][ENDTOKEN] = ActionEntry(REDUCE, 357);
   _actionMap[448][UNION] = ActionEntry(REDUCE, 357);
   _actionMap[448][ROWLIMIT] = ActionEntry(REDUCE, 357);
   _actionMap[448][KSEP] = ActionEntry(REDUCE, 357);
   _actionMap[448][ASC] = ActionEntry(REDUCE, 357);
   _actionMap[448][DESC] = ActionEntry(REDUCE, 357);
   _actionMap[448][SEMICOLON] = ActionEntry(REDUCE, 357);
   _actionMap[448][PLUS] = ActionEntry(REDUCE, 357);
   _actionMap[448][MINUS] = ActionEntry(REDUCE, 357);
   _actionMap[448][DIVISION] = ActionEntry(REDUCE, 357);
   _actionMap[448][STAR] = ActionEntry(REDUCE, 357);
   _actionMap[448][CONCAT] = ActionEntry(REDUCE, 357);
   _actionMap[449][RB] = ActionEntry(SHIFT, 608);
   _actionMap[449][KSEP] = ActionEntry(SHIFT, 606);
   _actionMap[450][RB] = ActionEntry(SHIFT, 609);
}
void Cego::loadParser172()
{
   _actionMap[450][PLUS] = ActionEntry(SHIFT, 275);
   _actionMap[450][MINUS] = ActionEntry(SHIFT, 274);
   _actionMap[450][CONCAT] = ActionEntry(SHIFT, 273);
   _actionMap[451][RB] = ActionEntry(SHIFT, 610);
   _actionMap[451][KSEP] = ActionEntry(SHIFT, 606);
   _actionMap[452][RB] = ActionEntry(SHIFT, 611);
   _actionMap[452][KSEP] = ActionEntry(SHIFT, 606);
   _actionMap[453][RB] = ActionEntry(SHIFT, 612);
   _actionMap[453][KSEP] = ActionEntry(SHIFT, 606);
   _actionMap[454][RAB] = ActionEntry(SHIFT, 613);
   _actionMap[455][RB] = ActionEntry(SHIFT, 614);
   _actionMap[455][KSEP] = ActionEntry(SHIFT, 606);
   _actionMap[456][RB] = ActionEntry(SHIFT, 615);
   _actionMap[456][KSEP] = ActionEntry(SHIFT, 606);
   _actionMap[457][RAB] = ActionEntry(SHIFT, 616);
   _actionMap[458][RB] = ActionEntry(SHIFT, 617);
   _actionMap[458][KSEP] = ActionEntry(SHIFT, 606);
   _actionMap[459][RB] = ActionEntry(SHIFT, 618);
   _actionMap[459][KSEP] = ActionEntry(SHIFT, 606);
   _actionMap[460][RB] = ActionEntry(SHIFT, 619);
   _actionMap[460][KSEP] = ActionEntry(SHIFT, 606);
   _actionMap[461][RB] = ActionEntry(SHIFT, 620);
   _actionMap[461][PLUS] = ActionEntry(SHIFT, 275);
   _actionMap[461][MINUS] = ActionEntry(SHIFT, 274);
   _actionMap[461][CONCAT] = ActionEntry(SHIFT, 273);
   _actionMap[462][RB] = ActionEntry(SHIFT, 621);
   _actionMap[463][KSEP] = ActionEntry(SHIFT, 622);
   _actionMap[464][KSEP] = ActionEntry(REDUCE, 425);
   _actionMap[465][RB] = ActionEntry(SHIFT, 623);
   _actionMap[465][KSEP] = ActionEntry(SHIFT, 606);
   _actionMap[466][RB] = ActionEntry(SHIFT, 624);
   _actionMap[466][KSEP] = ActionEntry(SHIFT, 606);
   _actionMap[467][RB] = ActionEntry(SHIFT, 625);
   _actionMap[467][KSEP] = ActionEntry(SHIFT, 606);
   _actionMap[468][LB] = ActionEntry(SHIFT, 626);
   _actionMap[469][RB] = ActionEntry(SHIFT, 627);
   _actionMap[469][KSEP] = ActionEntry(SHIFT, 606);
   _actionMap[470][RB] = ActionEntry(SHIFT, 628);
   _actionMap[470][KSEP] = ActionEntry(SHIFT, 606);
   _actionMap[471][RB] = ActionEntry(SHIFT, 629);
   _actionMap[471][KSEP] = ActionEntry(SHIFT, 606);
   _actionMap[472][RB] = ActionEntry(SHIFT, 630);
   _actionMap[472][KSEP] = ActionEntry(SHIFT, 606);
   _actionMap[473][RB] = ActionEntry(SHIFT, 631);
   _actionMap[473][KSEP] = ActionEntry(SHIFT, 606);
   _actionMap[474][RB] = ActionEntry(SHIFT, 632);
   _actionMap[474][KSEP] = ActionEntry(SHIFT, 606);
   _actionMap[475][RB] = ActionEntry(SHIFT, 633);
   _actionMap[475][KSEP] = ActionEntry(SHIFT, 606);
   _actionMap[476][RB] = ActionEntry(SHIFT, 634);
}
void Cego::loadParser173()
{
   _actionMap[476][KSEP] = ActionEntry(SHIFT, 606);
   _actionMap[477][RB] = ActionEntry(SHIFT, 635);
   _actionMap[477][KSEP] = ActionEntry(SHIFT, 606);
   _actionMap[478][RB] = ActionEntry(SHIFT, 636);
   _actionMap[478][KSEP] = ActionEntry(SHIFT, 606);
   _actionMap[479][RB] = ActionEntry(SHIFT, 637);
   _actionMap[479][PLUS] = ActionEntry(SHIFT, 275);
   _actionMap[479][MINUS] = ActionEntry(SHIFT, 274);
   _actionMap[479][CONCAT] = ActionEntry(SHIFT, 273);
   _actionMap[480][RB] = ActionEntry(SHIFT, 638);
   _actionMap[480][PLUS] = ActionEntry(SHIFT, 275);
   _actionMap[480][MINUS] = ActionEntry(SHIFT, 274);
   _actionMap[480][CONCAT] = ActionEntry(SHIFT, 273);
   _actionMap[481][RB] = ActionEntry(SHIFT, 639);
   _actionMap[481][KSEP] = ActionEntry(SHIFT, 606);
   _actionMap[482][RB] = ActionEntry(SHIFT, 640);
   _actionMap[483][RB] = ActionEntry(SHIFT, 641);
   _actionMap[483][KSEP] = ActionEntry(SHIFT, 606);
   _actionMap[484][RB] = ActionEntry(SHIFT, 642);
   _actionMap[484][KSEP] = ActionEntry(SHIFT, 606);
   _actionMap[485][RB] = ActionEntry(SHIFT, 643);
   _actionMap[485][KSEP] = ActionEntry(SHIFT, 606);
   _actionMap[486][RB] = ActionEntry(SHIFT, 644);
   _actionMap[486][KSEP] = ActionEntry(SHIFT, 606);
   _actionMap[487][RB] = ActionEntry(SHIFT, 645);
   _actionMap[487][KSEP] = ActionEntry(SHIFT, 606);
   _actionMap[488][RB] = ActionEntry(SHIFT, 646);
   _actionMap[488][KSEP] = ActionEntry(SHIFT, 606);
   _actionMap[489][RB] = ActionEntry(SHIFT, 647);
   _actionMap[489][KSEP] = ActionEntry(SHIFT, 606);
   _actionMap[490][KSEP] = ActionEntry(SHIFT, 648);
   _actionMap[491][RB] = ActionEntry(SHIFT, 649);
   _actionMap[491][KSEP] = ActionEntry(SHIFT, 606);
   _actionMap[492][RB] = ActionEntry(SHIFT, 650);
   _actionMap[492][PLUS] = ActionEntry(SHIFT, 275);
   _actionMap[492][MINUS] = ActionEntry(SHIFT, 274);
   _actionMap[492][CONCAT] = ActionEntry(SHIFT, 273);
   _actionMap[493][RB] = ActionEntry(SHIFT, 651);
   _actionMap[493][KSEP] = ActionEntry(SHIFT, 606);
   _actionMap[494][RB] = ActionEntry(SHIFT, 652);
   _actionMap[494][KSEP] = ActionEntry(SHIFT, 606);
   _actionMap[495][RB] = ActionEntry(SHIFT, 653);
   _actionMap[495][KSEP] = ActionEntry(SHIFT, 606);
   _actionMap[496][RB] = ActionEntry(SHIFT, 654);
   _actionMap[496][KSEP] = ActionEntry(SHIFT, 606);
   _actionMap[497][RB] = ActionEntry(SHIFT, 655);
   _actionMap[497][KSEP] = ActionEntry(SHIFT, 606);
   _actionMap[498][RB] = ActionEntry(SHIFT, 656);
   _actionMap[498][KSEP] = ActionEntry(SHIFT, 606);
   _actionMap[499][WHEN] = ActionEntry(REDUCE, 182);
}
void Cego::loadParser174()
{
   _actionMap[499][ELSE] = ActionEntry(REDUCE, 182);
   _actionMap[499][LEFT] = ActionEntry(REDUCE, 182);
   _actionMap[499][RIGHT] = ActionEntry(REDUCE, 182);
   _actionMap[499][INNER] = ActionEntry(REDUCE, 182);
   _actionMap[499][JOIN] = ActionEntry(REDUCE, 182);
   _actionMap[499][RETURNTOKEN] = ActionEntry(REDUCE, 182);
   _actionMap[499][ORDER] = ActionEntry(REDUCE, 182);
   _actionMap[499][GROUP] = ActionEntry(REDUCE, 182);
   _actionMap[499][WHERE] = ActionEntry(REDUCE, 182);
   _actionMap[499][AS] = ActionEntry(REDUCE, 182);
   _actionMap[499][FROM] = ActionEntry(REDUCE, 182);
   _actionMap[499][END_TOKEN] = ActionEntry(REDUCE, 182);
   _actionMap[499][BEGIN] = ActionEntry(REDUCE, 182);
   _actionMap[499][THEN] = ActionEntry(REDUCE, 182);
   _actionMap[499][OR] = ActionEntry(REDUCE, 182);
   _actionMap[499][AND] = ActionEntry(REDUCE, 182);
   _actionMap[499][DESC] = ActionEntry(REDUCE, 182);
   _actionMap[499][ASC] = ActionEntry(REDUCE, 182);
   _actionMap[499][KSEP] = ActionEntry(REDUCE, 182);
   _actionMap[499][ROWLIMIT] = ActionEntry(REDUCE, 182);
   _actionMap[499][UNION] = ActionEntry(REDUCE, 182);
   _actionMap[499][ENDTOKEN] = ActionEntry(REDUCE, 182);
   _actionMap[499][SEMICOLON] = ActionEntry(REDUCE, 182);
   _actionMap[499][LIKE] = ActionEntry(REDUCE, 182);
   _actionMap[499][BETWEEN] = ActionEntry(REDUCE, 182);
   _actionMap[499][NOT] = ActionEntry(REDUCE, 182);
   _actionMap[499][INTOK] = ActionEntry(REDUCE, 182);
   _actionMap[499][RB] = ActionEntry(REDUCE, 182);
   _actionMap[499][STAR] = ActionEntry(REDUCE, 182);
   _actionMap[499][DIVISION] = ActionEntry(REDUCE, 182);
   _actionMap[499][CONCAT] = ActionEntry(REDUCE, 182);
   _actionMap[499][MINUS] = ActionEntry(REDUCE, 182);
   _actionMap[499][PLUS] = ActionEntry(REDUCE, 182);
   _actionMap[499][IS] = ActionEntry(REDUCE, 182);
   _actionMap[499][EQU] = ActionEntry(REDUCE, 182);
   _actionMap[499][NEGATION] = ActionEntry(REDUCE, 182);
   _actionMap[499][LT] = ActionEntry(REDUCE, 182);
   _actionMap[499][MT] = ActionEntry(REDUCE, 182);
   _actionMap[500][WHEN] = ActionEntry(REDUCE, 183);
   _actionMap[500][ELSE] = ActionEntry(REDUCE, 183);
   _actionMap[500][LEFT] = ActionEntry(REDUCE, 183);
   _actionMap[500][RIGHT] = ActionEntry(REDUCE, 183);
   _actionMap[500][INNER] = ActionEntry(REDUCE, 183);
   _actionMap[500][JOIN] = ActionEntry(REDUCE, 183);
   _actionMap[500][RETURNTOKEN] = ActionEntry(REDUCE, 183);
   _actionMap[500][ORDER] = ActionEntry(REDUCE, 183);
   _actionMap[500][GROUP] = ActionEntry(REDUCE, 183);
   _actionMap[500][WHERE] = ActionEntry(REDUCE, 183);
   _actionMap[500][AS] = ActionEntry(REDUCE, 183);
   _actionMap[500][FROM] = ActionEntry(REDUCE, 183);
}
void Cego::loadParser175()
{
   _actionMap[500][END_TOKEN] = ActionEntry(REDUCE, 183);
   _actionMap[500][BEGIN] = ActionEntry(REDUCE, 183);
   _actionMap[500][THEN] = ActionEntry(REDUCE, 183);
   _actionMap[500][OR] = ActionEntry(REDUCE, 183);
   _actionMap[500][AND] = ActionEntry(REDUCE, 183);
   _actionMap[500][DESC] = ActionEntry(REDUCE, 183);
   _actionMap[500][ASC] = ActionEntry(REDUCE, 183);
   _actionMap[500][KSEP] = ActionEntry(REDUCE, 183);
   _actionMap[500][ROWLIMIT] = ActionEntry(REDUCE, 183);
   _actionMap[500][UNION] = ActionEntry(REDUCE, 183);
   _actionMap[500][ENDTOKEN] = ActionEntry(REDUCE, 183);
   _actionMap[500][SEMICOLON] = ActionEntry(REDUCE, 183);
   _actionMap[500][LIKE] = ActionEntry(REDUCE, 183);
   _actionMap[500][BETWEEN] = ActionEntry(REDUCE, 183);
   _actionMap[500][NOT] = ActionEntry(REDUCE, 183);
   _actionMap[500][INTOK] = ActionEntry(REDUCE, 183);
   _actionMap[500][RB] = ActionEntry(REDUCE, 183);
   _actionMap[500][STAR] = ActionEntry(REDUCE, 183);
   _actionMap[500][DIVISION] = ActionEntry(REDUCE, 183);
   _actionMap[500][CONCAT] = ActionEntry(REDUCE, 183);
   _actionMap[500][MINUS] = ActionEntry(REDUCE, 183);
   _actionMap[500][PLUS] = ActionEntry(REDUCE, 183);
   _actionMap[500][IS] = ActionEntry(REDUCE, 183);
   _actionMap[500][EQU] = ActionEntry(REDUCE, 183);
   _actionMap[500][NEGATION] = ActionEntry(REDUCE, 183);
   _actionMap[500][LT] = ActionEntry(REDUCE, 183);
   _actionMap[500][MT] = ActionEntry(REDUCE, 183);
   _actionMap[501][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[501][MINUS] = ActionEntry(SHIFT, 658);
   _jumpMap[501][SignedInt] = 657;
   _actionMap[502][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[502][MINUS] = ActionEntry(SHIFT, 660);
   _jumpMap[502][SignedFloat] = 659;
   _actionMap[503][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[503][MINUS] = ActionEntry(SHIFT, 660);
   _jumpMap[503][SignedFloat] = 661;
   _actionMap[504][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[504][MINUS] = ActionEntry(SHIFT, 660);
   _jumpMap[504][SignedFloat] = 662;
   _actionMap[505][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[505][MINUS] = ActionEntry(SHIFT, 658);
   _jumpMap[505][SignedInt] = 663;
   _actionMap[506][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[506][MINUS] = ActionEntry(SHIFT, 658);
   _jumpMap[506][SignedInt] = 664;
   _actionMap[507][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[507][MINUS] = ActionEntry(SHIFT, 658);
   _jumpMap[507][SignedInt] = 665;
   _actionMap[508][IDENTIFIER] = ActionEntry(SHIFT, 666);
   _actionMap[509][IDENTIFIER] = ActionEntry(SHIFT, 667);
}
void Cego::loadParser176()
{
   _actionMap[510][IDENTIFIER] = ActionEntry(SHIFT, 668);
   _actionMap[511][IDENTIFIER] = ActionEntry(SHIFT, 669);
   _actionMap[512][IDENTIFIER] = ActionEntry(SHIFT, 670);
   _actionMap[513][IDENTIFIER] = ActionEntry(SHIFT, 671);
   _actionMap[514][IDENTIFIER] = ActionEntry(SHIFT, 672);
   _actionMap[515][IDENTIFIER] = ActionEntry(SHIFT, 673);
   _actionMap[516][SEMICOLON] = ActionEntry(REDUCE, 362);
   _actionMap[516][RB] = ActionEntry(REDUCE, 362);
   _actionMap[516][ENDTOKEN] = ActionEntry(REDUCE, 362);
   _actionMap[516][UNION] = ActionEntry(REDUCE, 362);
   _actionMap[516][ROWLIMIT] = ActionEntry(REDUCE, 362);
   _actionMap[516][ORDER] = ActionEntry(REDUCE, 362);
   _actionMap[516][GROUP] = ActionEntry(REDUCE, 362);
   _actionMap[516][WHERE] = ActionEntry(SHIFT, 424);
   _jumpMap[516][NoWhere] = 423;
   _jumpMap[516][WhereClause] = 674;
   _actionMap[517][WHERE] = ActionEntry(REDUCE, 246);
   _actionMap[517][GROUP] = ActionEntry(REDUCE, 246);
   _actionMap[517][ORDER] = ActionEntry(REDUCE, 246);
   _actionMap[517][ROWLIMIT] = ActionEntry(REDUCE, 246);
   _actionMap[517][UNION] = ActionEntry(REDUCE, 246);
   _actionMap[517][ENDTOKEN] = ActionEntry(REDUCE, 246);
   _actionMap[517][RB] = ActionEntry(REDUCE, 246);
   _actionMap[517][SEMICOLON] = ActionEntry(REDUCE, 246);
   _actionMap[517][RETURNTOKEN] = ActionEntry(REDUCE, 246);
   _actionMap[517][INNER] = ActionEntry(SHIFT, 677);
   _actionMap[517][JOIN] = ActionEntry(SHIFT, 678);
   _actionMap[517][LEFT] = ActionEntry(SHIFT, 679);
   _actionMap[517][RIGHT] = ActionEntry(SHIFT, 680);
   _jumpMap[517][InnerJoin] = 676;
   _jumpMap[517][JoinSpec] = 675;
   _actionMap[518][WHERE] = ActionEntry(REDUCE, 245);
   _actionMap[518][GROUP] = ActionEntry(REDUCE, 245);
   _actionMap[518][ORDER] = ActionEntry(REDUCE, 245);
   _actionMap[518][ROWLIMIT] = ActionEntry(REDUCE, 245);
   _actionMap[518][UNION] = ActionEntry(REDUCE, 245);
   _actionMap[518][ENDTOKEN] = ActionEntry(REDUCE, 245);
   _actionMap[518][RB] = ActionEntry(REDUCE, 245);
   _actionMap[518][SEMICOLON] = ActionEntry(REDUCE, 245);
   _actionMap[518][RETURNTOKEN] = ActionEntry(REDUCE, 245);
   _actionMap[519][KSEP] = ActionEntry(SHIFT, 682);
   _actionMap[519][RETURNTOKEN] = ActionEntry(REDUCE, 258);
   _actionMap[519][SEMICOLON] = ActionEntry(REDUCE, 258);
   _actionMap[519][RB] = ActionEntry(REDUCE, 258);
   _actionMap[519][ENDTOKEN] = ActionEntry(REDUCE, 258);
   _actionMap[519][UNION] = ActionEntry(REDUCE, 258);
   _actionMap[519][ROWLIMIT] = ActionEntry(REDUCE, 258);
   _actionMap[519][ORDER] = ActionEntry(REDUCE, 258);
   _actionMap[519][GROUP] = ActionEntry(REDUCE, 258);
   _actionMap[519][WHERE] = ActionEntry(REDUCE, 258);
}
void Cego::loadParser177()
{
   _actionMap[519][INNER] = ActionEntry(SHIFT, 677);
   _actionMap[519][JOIN] = ActionEntry(SHIFT, 678);
   _actionMap[519][LEFT] = ActionEntry(SHIFT, 679);
   _actionMap[519][RIGHT] = ActionEntry(SHIFT, 680);
   _jumpMap[519][InnerJoin] = 676;
   _jumpMap[519][JoinSpec] = 681;
   _actionMap[520][KSEP] = ActionEntry(REDUCE, 259);
   _actionMap[520][IDENTIFIER] = ActionEntry(SHIFT, 683);
   _actionMap[520][LEFT] = ActionEntry(REDUCE, 259);
   _actionMap[520][RIGHT] = ActionEntry(REDUCE, 259);
   _actionMap[520][INNER] = ActionEntry(REDUCE, 259);
   _actionMap[520][JOIN] = ActionEntry(REDUCE, 259);
   _actionMap[520][RETURNTOKEN] = ActionEntry(REDUCE, 259);
   _actionMap[520][SEMICOLON] = ActionEntry(REDUCE, 259);
   _actionMap[520][RB] = ActionEntry(REDUCE, 259);
   _actionMap[520][ENDTOKEN] = ActionEntry(REDUCE, 259);
   _actionMap[520][UNION] = ActionEntry(REDUCE, 259);
   _actionMap[520][ROWLIMIT] = ActionEntry(REDUCE, 259);
   _actionMap[520][ORDER] = ActionEntry(REDUCE, 259);
   _actionMap[520][GROUP] = ActionEntry(REDUCE, 259);
   _actionMap[520][WHERE] = ActionEntry(REDUCE, 259);
   _actionMap[520][ON] = ActionEntry(REDUCE, 259);
   _actionMap[521][FROM] = ActionEntry(REDUCE, 244);
   _actionMap[521][RB] = ActionEntry(REDUCE, 244);
   _actionMap[521][SEMICOLON] = ActionEntry(REDUCE, 244);
   _actionMap[521][ENDTOKEN] = ActionEntry(REDUCE, 244);
   _actionMap[521][KSEP] = ActionEntry(REDUCE, 244);
   _actionMap[522][FROM] = ActionEntry(REDUCE, 263);
   _actionMap[522][RB] = ActionEntry(REDUCE, 263);
   _actionMap[522][SEMICOLON] = ActionEntry(REDUCE, 263);
   _actionMap[522][ENDTOKEN] = ActionEntry(REDUCE, 263);
   _actionMap[522][KSEP] = ActionEntry(REDUCE, 263);
   _actionMap[523][IDENTIFIER] = ActionEntry(SHIFT, 684);
   _actionMap[524][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[524][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[524][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[524][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[524][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[524][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[524][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[524][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[524][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[524][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[524][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[524][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[524][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[524][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[524][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[524][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[524][RIGHT] = ActionEntry(SHIFT, 162);
}
void Cego::loadParser178()
{
   _actionMap[524][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[524][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[524][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[524][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[524][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[524][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[524][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[524][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[524][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[524][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[524][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[524][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[524][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[524][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[524][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[524][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[524][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[524][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[524][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[524][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[524][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[524][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[524][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[524][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[524][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[524][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[524][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[524][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[524][LB] = ActionEntry(SHIFT, 176);
   _actionMap[524][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[524][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[524][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[524][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[524][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[524][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[524][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[524][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[524][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[524][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[524][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[524][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[524][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[524][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[524][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[524][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[524][MAX] = ActionEntry(SHIFT, 154);
   _jumpMap[524][ObjSpec] = 121;
   _jumpMap[524][Constant] = 120;
   _jumpMap[524][SignedFloat] = 119;
   _jumpMap[524][SignedInt] = 118;
}
void Cego::loadParser179()
{
   _jumpMap[524][Attribute] = 117;
   _jumpMap[524][Function] = 116;
   _jumpMap[524][SelectItem] = 685;
   _jumpMap[524][CasePrepare] = 115;
   _jumpMap[524][CaseClause] = 114;
   _jumpMap[524][Factor] = 113;
   _jumpMap[524][Term] = 112;
   _jumpMap[524][Expr] = 355;
   _actionMap[525][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[525][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[525][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[525][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[525][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[525][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[525][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[525][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[525][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[525][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[525][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[525][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[525][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[525][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[525][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[525][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[525][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[525][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[525][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[525][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[525][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[525][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[525][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[525][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[525][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[525][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[525][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[525][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[525][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[525][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[525][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[525][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[525][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[525][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[525][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[525][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[525][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[525][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[525][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[525][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[525][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[525][SETCOUNT] = ActionEntry(SHIFT, 165);
}
void Cego::loadParser180()
{
   _actionMap[525][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[525][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[525][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[525][LB] = ActionEntry(SHIFT, 176);
   _actionMap[525][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[525][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[525][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[525][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[525][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[525][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[525][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[525][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[525][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[525][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[525][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[525][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[525][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[525][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[525][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[525][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[525][MAX] = ActionEntry(SHIFT, 154);
   _jumpMap[525][ObjSpec] = 121;
   _jumpMap[525][Constant] = 120;
   _jumpMap[525][SignedFloat] = 119;
   _jumpMap[525][SignedInt] = 118;
   _jumpMap[525][Attribute] = 117;
   _jumpMap[525][Function] = 116;
   _jumpMap[525][CasePrepare] = 115;
   _jumpMap[525][CaseClause] = 114;
   _jumpMap[525][Factor] = 113;
   _jumpMap[525][Term] = 112;
   _jumpMap[525][Expr] = 686;
   _actionMap[526][PLUS] = ActionEntry(SHIFT, 275);
   _actionMap[526][MINUS] = ActionEntry(SHIFT, 274);
   _actionMap[526][CONCAT] = ActionEntry(SHIFT, 273);
   _actionMap[526][SEMICOLON] = ActionEntry(REDUCE, 87);
   _actionMap[527][KSEP] = ActionEntry(SHIFT, 688);
   _actionMap[527][SEMICOLON] = ActionEntry(REDUCE, 362);
   _actionMap[527][RETURNTOKEN] = ActionEntry(REDUCE, 362);
   _actionMap[527][WHERE] = ActionEntry(SHIFT, 424);
   _jumpMap[527][NoWhere] = 423;
   _jumpMap[527][WhereClause] = 687;
   _actionMap[528][KSEP] = ActionEntry(REDUCE, 290);
   _actionMap[528][WHERE] = ActionEntry(REDUCE, 290);
   _actionMap[528][GROUP] = ActionEntry(REDUCE, 290);
   _actionMap[528][ORDER] = ActionEntry(REDUCE, 290);
   _actionMap[528][ROWLIMIT] = ActionEntry(REDUCE, 290);
   _actionMap[528][UNION] = ActionEntry(REDUCE, 290);
   _actionMap[528][ENDTOKEN] = ActionEntry(REDUCE, 290);
   _actionMap[528][RB] = ActionEntry(REDUCE, 290);
}
void Cego::loadParser181()
{
   _actionMap[528][SEMICOLON] = ActionEntry(REDUCE, 290);
   _actionMap[528][RETURNTOKEN] = ActionEntry(REDUCE, 290);
   _actionMap[529][EQU] = ActionEntry(SHIFT, 689);
   _actionMap[530][LB] = ActionEntry(SHIFT, 690);
   _actionMap[218][SEMICOLON] = ActionEntry(REDUCE, 81);
   _actionMap[219][SEMICOLON] = ActionEntry(REDUCE, 82);
   _actionMap[220][SEMICOLON] = ActionEntry(REDUCE, 75);
   _actionMap[221][SEMICOLON] = ActionEntry(REDUCE, 79);
   _actionMap[222][SEMICOLON] = ActionEntry(REDUCE, 91);
   _actionMap[223][TO] = ActionEntry(REDUCE, 93);
   _actionMap[223][SEMICOLON] = ActionEntry(REDUCE, 93);
   _actionMap[224][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[224][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[224][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[224][ObjSpec] = 375;
   _actionMap[225][SEMICOLON] = ActionEntry(REDUCE, 77);
   _actionMap[226][SEMICOLON] = ActionEntry(REDUCE, 74);
   _actionMap[227][SEMICOLON] = ActionEntry(REDUCE, 80);
   _actionMap[228][SEMICOLON] = ActionEntry(REDUCE, 76);
   _actionMap[229][ADD] = ActionEntry(SHIFT, 378);
   _actionMap[229][DROP] = ActionEntry(SHIFT, 379);
   _actionMap[229][MODIFY] = ActionEntry(SHIFT, 380);
   _actionMap[229][RENAME] = ActionEntry(SHIFT, 381);
   _jumpMap[229][AlterOption] = 377;
   _jumpMap[229][AlterList] = 376;
   _actionMap[230][BY] = ActionEntry(SHIFT, 382);
   _actionMap[231][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[231][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[231][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[231][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[231][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[231][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[231][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[231][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[231][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[231][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[231][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[231][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[231][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[231][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[231][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[231][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[231][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[231][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[231][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[231][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[231][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[231][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[231][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[231][STR2LONG] = ActionEntry(SHIFT, 170);
}
void Cego::loadParser182()
{
   _actionMap[231][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[231][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[231][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[231][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[231][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[231][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[231][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[231][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[231][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[231][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[231][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[231][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[231][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[231][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[231][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[231][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[231][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[231][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[231][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[231][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[231][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[231][LB] = ActionEntry(SHIFT, 176);
   _actionMap[231][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[231][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[231][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[231][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[231][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[231][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[231][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[231][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[231][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[231][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[231][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[231][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[231][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[231][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[231][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[231][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[231][MAX] = ActionEntry(SHIFT, 154);
   _actionMap[231][RB] = ActionEntry(REDUCE, 147);
   _jumpMap[231][ObjSpec] = 121;
   _jumpMap[231][Constant] = 120;
   _jumpMap[231][SignedFloat] = 119;
   _jumpMap[231][SignedInt] = 118;
   _jumpMap[231][Attribute] = 117;
   _jumpMap[231][Function] = 116;
   _jumpMap[231][CasePrepare] = 115;
   _jumpMap[231][CaseClause] = 114;
   _jumpMap[231][Factor] = 113;
   _jumpMap[231][Term] = 112;
}
void Cego::loadParser183()
{
   _jumpMap[231][Expr] = 385;
   _jumpMap[231][ProcValueList] = 384;
   _jumpMap[231][ProcValueListOpt] = 383;
   _actionMap[232][SEMICOLON] = ActionEntry(REDUCE, 89);
   _actionMap[233][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[233][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[233][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[233][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[233][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[233][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[233][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[233][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[233][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[233][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[233][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[233][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[233][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[233][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[233][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[233][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[233][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[233][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[233][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[233][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[233][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[233][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[233][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[233][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[233][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[233][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[233][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[233][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[233][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[233][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[233][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[233][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[233][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[233][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[233][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[233][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[233][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[233][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[233][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[233][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[233][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[233][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[233][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[233][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[233][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[233][LB] = ActionEntry(SHIFT, 176);
}
void Cego::loadParser184()
{
   _actionMap[233][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[233][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[233][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[233][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[233][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[233][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[233][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[233][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[233][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[233][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[233][VARREF] = ActionEntry(SHIFT, 410);
   _actionMap[233][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[233][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[233][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[233][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[233][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[233][MAX] = ActionEntry(SHIFT, 154);
   _actionMap[233][IF] = ActionEntry(SHIFT, 404);
   _actionMap[233][BEGIN] = ActionEntry(SHIFT, 401);
   _actionMap[233][UNLOCK] = ActionEntry(SHIFT, 28);
   _actionMap[233][LOCK] = ActionEntry(SHIFT, 27);
   _actionMap[233][ROLLBACK] = ActionEntry(SHIFT, 33);
   _actionMap[233][COMMIT] = ActionEntry(SHIFT, 18);
   _actionMap[233][START_TOKEN] = ActionEntry(SHIFT, 37);
   _actionMap[233][UPDATE] = ActionEntry(SHIFT, 43);
   _actionMap[233][DELETETOK] = ActionEntry(SHIFT, 20);
   _actionMap[233][INSERT] = ActionEntry(SHIFT, 23);
   _actionMap[233][VAR] = ActionEntry(SHIFT, 408);
   _actionMap[233][CURSOR] = ActionEntry(SHIFT, 403);
   _actionMap[233][CLOSE] = ActionEntry(SHIFT, 402);
   _actionMap[233][NOOP] = ActionEntry(SHIFT, 405);
   _actionMap[233][THROW] = ActionEntry(SHIFT, 407);
   _actionMap[233][RETURNTOKEN] = ActionEntry(SHIFT, 406);
   _actionMap[233][WHILE] = ActionEntry(SHIFT, 409);
   _jumpMap[233][ObjSpec] = 121;
   _jumpMap[233][Constant] = 120;
   _jumpMap[233][SignedFloat] = 119;
   _jumpMap[233][SignedInt] = 118;
   _jumpMap[233][Attribute] = 117;
   _jumpMap[233][Function] = 116;
   _jumpMap[233][DeleteStatement] = 400;
   _jumpMap[233][UpdateStatement] = 399;
   _jumpMap[233][InsertStatement] = 398;
   _jumpMap[233][UnlockStatement] = 397;
   _jumpMap[233][LockStatement] = 396;
   _jumpMap[233][RollbackStatement] = 395;
   _jumpMap[233][CommitStatement] = 394;
   _jumpMap[233][StartStatement] = 393;
   _jumpMap[233][CasePrepare] = 115;
   _jumpMap[233][CaseClause] = 114;
}
void Cego::loadParser185()
{
   _jumpMap[233][Factor] = 113;
   _jumpMap[233][Term] = 112;
   _jumpMap[233][Expr] = 392;
   _jumpMap[233][ProcStatement] = 391;
   _jumpMap[233][ProcIfPart] = 390;
   _jumpMap[233][ProcBlockStart] = 389;
   _jumpMap[233][ProcStatementList] = 388;
   _jumpMap[233][ProcStmtBlock] = 387;
   _actionMap[234][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[234][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[234][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[234][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[234][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[234][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[234][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[234][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[234][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[234][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[234][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[234][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[234][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[234][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[234][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[234][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[234][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[234][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[234][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[234][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[234][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[234][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[234][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[234][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[234][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[234][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[234][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[234][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[234][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[234][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[234][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[234][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[234][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[234][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[234][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[234][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[234][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[234][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[234][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[234][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[234][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[234][SETCOUNT] = ActionEntry(SHIFT, 165);
}
void Cego::loadParser186()
{
   _actionMap[234][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[234][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[234][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[234][LB] = ActionEntry(SHIFT, 176);
   _actionMap[234][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[234][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[234][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[234][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[234][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[234][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[234][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[234][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[234][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[234][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[234][VARREF] = ActionEntry(SHIFT, 410);
   _actionMap[234][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[234][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[234][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[234][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[234][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[234][MAX] = ActionEntry(SHIFT, 154);
   _actionMap[234][IF] = ActionEntry(SHIFT, 404);
   _actionMap[234][BEGIN] = ActionEntry(SHIFT, 401);
   _actionMap[234][UNLOCK] = ActionEntry(SHIFT, 28);
   _actionMap[234][LOCK] = ActionEntry(SHIFT, 27);
   _actionMap[234][ROLLBACK] = ActionEntry(SHIFT, 33);
   _actionMap[234][COMMIT] = ActionEntry(SHIFT, 18);
   _actionMap[234][START_TOKEN] = ActionEntry(SHIFT, 37);
   _actionMap[234][UPDATE] = ActionEntry(SHIFT, 43);
   _actionMap[234][DELETETOK] = ActionEntry(SHIFT, 20);
   _actionMap[234][INSERT] = ActionEntry(SHIFT, 23);
   _actionMap[234][VAR] = ActionEntry(SHIFT, 408);
   _actionMap[234][CURSOR] = ActionEntry(SHIFT, 403);
   _actionMap[234][CLOSE] = ActionEntry(SHIFT, 402);
   _actionMap[234][NOOP] = ActionEntry(SHIFT, 405);
   _actionMap[234][THROW] = ActionEntry(SHIFT, 407);
   _actionMap[234][RETURNTOKEN] = ActionEntry(SHIFT, 406);
   _actionMap[234][WHILE] = ActionEntry(SHIFT, 409);
   _jumpMap[234][ObjSpec] = 121;
   _jumpMap[234][Constant] = 120;
   _jumpMap[234][SignedFloat] = 119;
   _jumpMap[234][SignedInt] = 118;
   _jumpMap[234][Attribute] = 117;
   _jumpMap[234][Function] = 116;
   _jumpMap[234][DeleteStatement] = 400;
   _jumpMap[234][UpdateStatement] = 399;
   _jumpMap[234][InsertStatement] = 398;
   _jumpMap[234][UnlockStatement] = 397;
   _jumpMap[234][LockStatement] = 396;
   _jumpMap[234][RollbackStatement] = 395;
}
void Cego::loadParser187()
{
   _jumpMap[234][CommitStatement] = 394;
   _jumpMap[234][StartStatement] = 393;
   _jumpMap[234][CasePrepare] = 115;
   _jumpMap[234][CaseClause] = 114;
   _jumpMap[234][Factor] = 113;
   _jumpMap[234][Term] = 112;
   _jumpMap[234][Expr] = 392;
   _jumpMap[234][ProcStatement] = 391;
   _jumpMap[234][ProcIfPart] = 390;
   _jumpMap[234][ProcBlockStart] = 389;
   _jumpMap[234][ProcStatementList] = 388;
   _jumpMap[234][ProcStmtBlock] = 411;
   _actionMap[235][IDENTIFIER] = ActionEntry(SHIFT, 412);
   _actionMap[236][ON] = ActionEntry(REDUCE, 216);
   _actionMap[236][IDENTIFIER] = ActionEntry(REDUCE, 216);
   _actionMap[237][ON] = ActionEntry(REDUCE, 215);
   _actionMap[237][IDENTIFIER] = ActionEntry(REDUCE, 215);
   _actionMap[238][ON] = ActionEntry(SHIFT, 413);
   _actionMap[239][SEMICOLON] = ActionEntry(REDUCE, 90);
   _actionMap[240][ON] = ActionEntry(SHIFT, 414);
   _actionMap[241][LB] = ActionEntry(SHIFT, 415);
   _actionMap[242][LB] = ActionEntry(SHIFT, 416);
   _actionMap[243][BEFORE] = ActionEntry(SHIFT, 419);
   _actionMap[243][AFTER] = ActionEntry(SHIFT, 418);
   _jumpMap[243][TriggerEvent] = 417;
   _actionMap[244][AS] = ActionEntry(SHIFT, 420);
   _actionMap[245][IDENTIFIER] = ActionEntry(SHIFT, 373);
   _actionMap[245][WHERE] = ActionEntry(REDUCE, 300);
   _actionMap[245][GROUP] = ActionEntry(REDUCE, 300);
   _actionMap[245][ORDER] = ActionEntry(REDUCE, 300);
   _actionMap[245][ROWLIMIT] = ActionEntry(REDUCE, 300);
   _actionMap[245][UNION] = ActionEntry(REDUCE, 300);
   _actionMap[245][ENDTOKEN] = ActionEntry(REDUCE, 300);
   _actionMap[245][RB] = ActionEntry(REDUCE, 300);
   _actionMap[245][SEMICOLON] = ActionEntry(REDUCE, 300);
   _actionMap[245][RETURNTOKEN] = ActionEntry(REDUCE, 300);
   _jumpMap[245][NoWhere] = 423;
   _jumpMap[245][WhereClause] = 422;
   _jumpMap[245][UpdDelAlias] = 421;
   _actionMap[246][SEMICOLON] = ActionEntry(REDUCE, 25);
   _actionMap[247][SEMICOLON] = ActionEntry(REDUCE, 29);
   _actionMap[248][SEMICOLON] = ActionEntry(REDUCE, 24);
   _actionMap[249][SEMICOLON] = ActionEntry(REDUCE, 28);
   _actionMap[250][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[250][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[250][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[250][ObjSpec] = 425;
   _actionMap[251][SEMICOLON] = ActionEntry(REDUCE, 30);
   _actionMap[252][SEMICOLON] = ActionEntry(REDUCE, 23);
   _actionMap[253][SEMICOLON] = ActionEntry(REDUCE, 26);
}
void Cego::loadParser188()
{
   _actionMap[254][COUNTER] = ActionEntry(REDUCE, 84);
   _actionMap[254][ALIAS] = ActionEntry(REDUCE, 84);
   _actionMap[254][BTREE] = ActionEntry(REDUCE, 84);
   _actionMap[254][INDEX] = ActionEntry(REDUCE, 84);
   _actionMap[254][TRIGGER] = ActionEntry(REDUCE, 84);
   _actionMap[254][CHECK] = ActionEntry(REDUCE, 84);
   _actionMap[254][FOREIGN] = ActionEntry(REDUCE, 84);
   _actionMap[254][PROCEDURE] = ActionEntry(REDUCE, 84);
   _actionMap[254][VIEW] = ActionEntry(REDUCE, 84);
   _actionMap[254][AVLTREE] = ActionEntry(REDUCE, 84);
   _actionMap[254][TABLE] = ActionEntry(REDUCE, 84);
   _actionMap[255][LB] = ActionEntry(SHIFT, 430);
   _actionMap[255][VALUES] = ActionEntry(REDUCE, 227);
   _actionMap[255][SELECT] = ActionEntry(REDUCE, 227);
   _jumpMap[255][SelectStatement] = 428;
   _jumpMap[255][InsertPrepare] = 427;
   _jumpMap[255][InsertArgSpec] = 426;
   _actionMap[256][SEMICOLON] = ActionEntry(REDUCE, 95);
   _actionMap[256][IDENTIFIER] = ActionEntry(REDUCE, 95);
   _actionMap[257][SEMICOLON] = ActionEntry(REDUCE, 7);
   _actionMap[258][IDENTIFIER] = ActionEntry(SHIFT, 431);
   _actionMap[259][SEMICOLON] = ActionEntry(REDUCE, 14);
   _actionMap[260][SEMICOLON] = ActionEntry(REDUCE, 6);
   _actionMap[261][SEMICOLON] = ActionEntry(REDUCE, 12);
   _actionMap[262][SEMICOLON] = ActionEntry(REDUCE, 9);
   _actionMap[263][SEMICOLON] = ActionEntry(REDUCE, 8);
   _actionMap[264][SEMICOLON] = ActionEntry(REDUCE, 4);
   _actionMap[265][SEMICOLON] = ActionEntry(REDUCE, 10);
   _actionMap[266][SEMICOLON] = ActionEntry(REDUCE, 3);
   _actionMap[267][SEMICOLON] = ActionEntry(REDUCE, 11);
   _actionMap[268][SEMICOLON] = ActionEntry(REDUCE, 13);
   _actionMap[269][SEMICOLON] = ActionEntry(REDUCE, 5);
   _actionMap[270][AS] = ActionEntry(SHIFT, 432);
   _actionMap[271][SEMICOLON] = ActionEntry(REDUCE, 222);
   _actionMap[272][SEMICOLON] = ActionEntry(REDUCE, 223);
   _actionMap[273][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[273][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[273][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[273][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[273][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[273][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[273][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[273][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[273][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[273][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[273][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[273][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[273][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[273][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[273][DATE2LONG] = ActionEntry(SHIFT, 139);
}
void Cego::loadParser189()
{
   _actionMap[273][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[273][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[273][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[273][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[273][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[273][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[273][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[273][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[273][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[273][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[273][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[273][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[273][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[273][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[273][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[273][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[273][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[273][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[273][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[273][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[273][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[273][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[273][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[273][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[273][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[273][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[273][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[273][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[273][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[273][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[273][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[273][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[273][LB] = ActionEntry(SHIFT, 176);
   _actionMap[273][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[273][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[273][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[273][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[273][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[273][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[273][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[273][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[273][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[273][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[273][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[273][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[273][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[273][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[273][MAX] = ActionEntry(SHIFT, 154);
   _jumpMap[273][ObjSpec] = 121;
   _jumpMap[273][Constant] = 120;
}
void Cego::loadParser190()
{
   _jumpMap[273][SignedFloat] = 119;
   _jumpMap[273][SignedInt] = 118;
   _jumpMap[273][Attribute] = 117;
   _jumpMap[273][Function] = 116;
   _jumpMap[273][CasePrepare] = 115;
   _jumpMap[273][CaseClause] = 114;
   _jumpMap[273][Factor] = 113;
   _jumpMap[273][Term] = 433;
   _actionMap[274][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[274][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[274][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[274][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[274][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[274][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[274][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[274][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[274][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[274][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[274][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[274][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[274][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[274][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[274][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[274][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[274][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[274][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[274][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[274][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[274][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[274][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[274][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[274][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[274][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[274][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[274][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[274][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[274][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[274][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[274][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[274][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[274][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[274][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[274][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[274][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[274][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[274][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[274][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[274][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[274][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[274][CLOBSIZE] = ActionEntry(SHIFT, 133);
}
void Cego::loadParser191()
{
   _actionMap[274][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[274][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[274][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[274][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[274][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[274][LB] = ActionEntry(SHIFT, 176);
   _actionMap[274][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[274][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[274][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[274][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[274][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[274][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[274][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[274][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[274][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[274][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[274][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[274][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[274][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[274][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[274][MAX] = ActionEntry(SHIFT, 154);
   _jumpMap[274][ObjSpec] = 121;
   _jumpMap[274][Constant] = 120;
   _jumpMap[274][SignedFloat] = 119;
   _jumpMap[274][SignedInt] = 118;
   _jumpMap[274][Attribute] = 117;
   _jumpMap[274][Function] = 116;
   _jumpMap[274][CasePrepare] = 115;
   _jumpMap[274][CaseClause] = 114;
   _jumpMap[274][Factor] = 113;
   _jumpMap[274][Term] = 434;
   _actionMap[275][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[275][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[275][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[275][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[275][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[275][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[275][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[275][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[275][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[275][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[275][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[275][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[275][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[275][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[275][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[275][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[275][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[275][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[275][UPPER] = ActionEntry(SHIFT, 175);
}
void Cego::loadParser192()
{
   _actionMap[275][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[275][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[275][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[275][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[275][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[275][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[275][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[275][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[275][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[275][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[275][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[275][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[275][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[275][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[275][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[275][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[275][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[275][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[275][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[275][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[275][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[275][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[275][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[275][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[275][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[275][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[275][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[275][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[275][LB] = ActionEntry(SHIFT, 176);
   _actionMap[275][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[275][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[275][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[275][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[275][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[275][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[275][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[275][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[275][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[275][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[275][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[275][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[275][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[275][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[275][MAX] = ActionEntry(SHIFT, 154);
   _jumpMap[275][ObjSpec] = 121;
   _jumpMap[275][Constant] = 120;
   _jumpMap[275][SignedFloat] = 119;
   _jumpMap[275][SignedInt] = 118;
   _jumpMap[275][Attribute] = 117;
   _jumpMap[275][Function] = 116;
}
void Cego::loadParser193()
{
   _jumpMap[275][CasePrepare] = 115;
   _jumpMap[275][CaseClause] = 114;
   _jumpMap[275][Factor] = 113;
   _jumpMap[275][Term] = 435;
   _actionMap[276][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[276][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[276][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[276][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[276][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[276][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[276][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[276][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[276][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[276][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[276][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[276][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[276][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[276][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[276][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[276][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[276][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[276][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[276][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[276][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[276][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[276][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[276][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[276][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[276][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[276][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[276][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[276][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[276][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[276][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[276][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[276][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[276][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[276][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[276][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[276][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[276][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[276][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[276][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[276][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[276][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[276][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[276][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[276][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[276][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[276][SETCOUNT] = ActionEntry(SHIFT, 165);
}
void Cego::loadParser194()
{
   _actionMap[276][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[276][LB] = ActionEntry(SHIFT, 176);
   _actionMap[276][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[276][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[276][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[276][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[276][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[276][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[276][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[276][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[276][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[276][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[276][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[276][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[276][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[276][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[276][MAX] = ActionEntry(SHIFT, 154);
   _jumpMap[276][ObjSpec] = 121;
   _jumpMap[276][Constant] = 120;
   _jumpMap[276][SignedFloat] = 119;
   _jumpMap[276][SignedInt] = 118;
   _jumpMap[276][Attribute] = 117;
   _jumpMap[276][Function] = 116;
   _jumpMap[276][CasePrepare] = 115;
   _jumpMap[276][CaseClause] = 114;
   _jumpMap[276][Factor] = 436;
   _actionMap[277][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[277][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[277][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[277][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[277][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[277][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[277][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[277][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[277][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[277][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[277][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[277][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[277][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[277][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[277][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[277][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[277][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[277][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[277][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[277][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[277][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[277][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[277][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[277][REPLACE] = ActionEntry(SHIFT, 161);
}
void Cego::loadParser195()
{
   _actionMap[277][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[277][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[277][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[277][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[277][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[277][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[277][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[277][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[277][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[277][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[277][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[277][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[277][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[277][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[277][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[277][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[277][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[277][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[277][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[277][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[277][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[277][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[277][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[277][LB] = ActionEntry(SHIFT, 176);
   _actionMap[277][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[277][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[277][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[277][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[277][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[277][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[277][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[277][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[277][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[277][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[277][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[277][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[277][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[277][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[277][MAX] = ActionEntry(SHIFT, 154);
   _jumpMap[277][ObjSpec] = 121;
   _jumpMap[277][Constant] = 120;
   _jumpMap[277][SignedFloat] = 119;
   _jumpMap[277][SignedInt] = 118;
   _jumpMap[277][Attribute] = 117;
   _jumpMap[277][Function] = 116;
   _jumpMap[277][CasePrepare] = 115;
   _jumpMap[277][CaseClause] = 114;
   _jumpMap[277][Factor] = 437;
   _actionMap[278][ELSE] = ActionEntry(SHIFT, 439);
   _actionMap[278][WHEN] = ActionEntry(SHIFT, 280);
}
void Cego::loadParser196()
{
   _jumpMap[278][CaseCondition] = 438;
   _actionMap[279][WHEN] = ActionEntry(REDUCE, 193);
   _actionMap[279][ELSE] = ActionEntry(REDUCE, 193);
   _actionMap[280][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[280][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[280][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[280][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[280][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[280][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[280][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[280][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[280][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[280][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[280][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[280][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[280][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[280][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[280][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[280][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[280][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[280][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[280][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[280][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[280][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[280][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[280][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[280][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[280][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[280][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[280][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[280][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[280][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[280][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[280][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[280][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[280][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[280][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[280][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[280][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[280][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[280][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[280][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[280][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[280][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[280][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[280][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[280][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[280][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[280][LB] = ActionEntry(SHIFT, 445);
   _actionMap[280][STRINGVAL] = ActionEntry(SHIFT, 122);
}
void Cego::loadParser197()
{
   _actionMap[280][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[280][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[280][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[280][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[280][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[280][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[280][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[280][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[280][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[280][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[280][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[280][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[280][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[280][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[280][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[280][MAX] = ActionEntry(SHIFT, 154);
   _actionMap[280][EXISTS] = ActionEntry(SHIFT, 443);
   _actionMap[280][NOT] = ActionEntry(SHIFT, 444);
   _jumpMap[280][ObjSpec] = 121;
   _jumpMap[280][Constant] = 120;
   _jumpMap[280][SignedFloat] = 119;
   _jumpMap[280][SignedInt] = 118;
   _jumpMap[280][Attribute] = 117;
   _jumpMap[280][QueryPredicate] = 442;
   _jumpMap[280][QueryCondition] = 441;
   _jumpMap[280][Function] = 116;
   _jumpMap[280][CasePrepare] = 115;
   _jumpMap[280][CaseClause] = 114;
   _jumpMap[280][Factor] = 113;
   _jumpMap[280][Term] = 112;
   _jumpMap[280][Expr] = 440;
   _actionMap[281][RB] = ActionEntry(SHIFT, 448);
   _actionMap[281][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[281][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[281][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[281][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[281][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[281][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[281][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[281][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[281][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[281][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[281][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[281][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[281][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[281][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[281][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[281][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[281][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[281][GETPOS] = ActionEntry(SHIFT, 143);
}
void Cego::loadParser198()
{
   _actionMap[281][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[281][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[281][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[281][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[281][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[281][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[281][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[281][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[281][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[281][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[281][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[281][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[281][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[281][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[281][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[281][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[281][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[281][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[281][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[281][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[281][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[281][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[281][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[281][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[281][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[281][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[281][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[281][LB] = ActionEntry(SHIFT, 176);
   _actionMap[281][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[281][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[281][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[281][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[281][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[281][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[281][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[281][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[281][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[281][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[281][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[281][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[281][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[281][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[281][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[281][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[281][MAX] = ActionEntry(SHIFT, 154);
   _jumpMap[281][ObjSpec] = 121;
   _jumpMap[281][Constant] = 120;
   _jumpMap[281][SignedFloat] = 119;
   _jumpMap[281][SignedInt] = 118;
   _jumpMap[281][Attribute] = 117;
}
void Cego::loadParser199()
{
   _jumpMap[281][ExpressionList] = 447;
   _jumpMap[281][Function] = 116;
   _jumpMap[281][CasePrepare] = 115;
   _jumpMap[281][CaseClause] = 114;
   _jumpMap[281][Factor] = 113;
   _jumpMap[281][Term] = 112;
   _jumpMap[281][Expr] = 446;
   _actionMap[282][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[282][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[282][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[282][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[282][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[282][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[282][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[282][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[282][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[282][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[282][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[282][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[282][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[282][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[282][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[282][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[282][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[282][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[282][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[282][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[282][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[282][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[282][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[282][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[282][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[282][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[282][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[282][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[282][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[282][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[282][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[282][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[282][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[282][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[282][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[282][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[282][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[282][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[282][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[282][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[282][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[282][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[282][IDENTIFIER] = ActionEntry(SHIFT, 180);
}
void Cego::loadParser200()
{
   _actionMap[282][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[282][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[282][LB] = ActionEntry(SHIFT, 176);
   _actionMap[282][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[282][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[282][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[282][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[282][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[282][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[282][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[282][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[282][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[282][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[282][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[282][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[282][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[282][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[282][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[282][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[282][MAX] = ActionEntry(SHIFT, 154);
   _jumpMap[282][ObjSpec] = 121;
   _jumpMap[282][Constant] = 120;
   _jumpMap[282][SignedFloat] = 119;
   _jumpMap[282][SignedInt] = 118;
   _jumpMap[282][Attribute] = 117;
   _jumpMap[282][ExpressionList] = 449;
   _jumpMap[282][Function] = 116;
   _jumpMap[282][CasePrepare] = 115;
   _jumpMap[282][CaseClause] = 114;
   _jumpMap[282][Factor] = 113;
   _jumpMap[282][Term] = 112;
   _jumpMap[282][Expr] = 446;
   _actionMap[283][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[283][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[283][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[283][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[283][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[283][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[283][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[283][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[283][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[283][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[283][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[283][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[283][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[283][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[283][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[283][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[283][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[283][GETPOS] = ActionEntry(SHIFT, 143);
}
void Cego::loadParser201()
{
   _actionMap[283][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[283][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[283][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[283][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[283][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[283][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[283][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[283][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[283][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[283][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[283][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[283][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[283][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[283][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[283][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[283][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[283][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[283][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[283][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[283][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[283][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[283][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[283][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[283][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[283][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[283][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[283][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[283][LB] = ActionEntry(SHIFT, 176);
   _actionMap[283][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[283][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[283][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[283][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[283][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[283][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[283][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[283][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[283][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[283][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[283][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[283][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[283][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[283][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[283][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[283][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[283][MAX] = ActionEntry(SHIFT, 154);
   _jumpMap[283][ObjSpec] = 121;
   _jumpMap[283][Constant] = 120;
   _jumpMap[283][SignedFloat] = 119;
   _jumpMap[283][SignedInt] = 118;
   _jumpMap[283][Attribute] = 117;
}
void Cego::loadParser202()
{
   _jumpMap[283][Function] = 116;
   _jumpMap[283][CasePrepare] = 115;
   _jumpMap[283][CaseClause] = 114;
   _jumpMap[283][Factor] = 113;
   _jumpMap[283][Term] = 112;
   _jumpMap[283][Expr] = 450;
   _actionMap[284][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[284][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[284][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[284][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[284][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[284][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[284][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[284][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[284][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[284][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[284][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[284][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[284][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[284][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[284][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[284][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[284][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[284][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[284][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[284][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[284][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[284][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[284][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[284][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[284][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[284][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[284][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[284][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[284][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[284][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[284][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[284][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[284][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[284][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[284][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[284][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[284][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[284][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[284][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[284][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[284][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[284][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[284][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[284][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
}
void Cego::loadParser203()
{
   _actionMap[284][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[284][LB] = ActionEntry(SHIFT, 176);
   _actionMap[284][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[284][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[284][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[284][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[284][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[284][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[284][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[284][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[284][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[284][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[284][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[284][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[284][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[284][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[284][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[284][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[284][MAX] = ActionEntry(SHIFT, 154);
   _jumpMap[284][ObjSpec] = 121;
   _jumpMap[284][Constant] = 120;
   _jumpMap[284][SignedFloat] = 119;
   _jumpMap[284][SignedInt] = 118;
   _jumpMap[284][Attribute] = 117;
   _jumpMap[284][ExpressionList] = 451;
   _jumpMap[284][Function] = 116;
   _jumpMap[284][CasePrepare] = 115;
   _jumpMap[284][CaseClause] = 114;
   _jumpMap[284][Factor] = 113;
   _jumpMap[284][Term] = 112;
   _jumpMap[284][Expr] = 446;
   _actionMap[285][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[285][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[285][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[285][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[285][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[285][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[285][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[285][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[285][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[285][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[285][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[285][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[285][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[285][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[285][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[285][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[285][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[285][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[285][SUBSTR] = ActionEntry(SHIFT, 166);
}
void Cego::loadParser204()
{
   _actionMap[285][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[285][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[285][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[285][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[285][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[285][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[285][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[285][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[285][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[285][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[285][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[285][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[285][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[285][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[285][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[285][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[285][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[285][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[285][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[285][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[285][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[285][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[285][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[285][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[285][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[285][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[285][LB] = ActionEntry(SHIFT, 176);
   _actionMap[285][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[285][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[285][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[285][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[285][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[285][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[285][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[285][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[285][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[285][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[285][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[285][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[285][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[285][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[285][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[285][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[285][MAX] = ActionEntry(SHIFT, 154);
   _jumpMap[285][ObjSpec] = 121;
   _jumpMap[285][Constant] = 120;
   _jumpMap[285][SignedFloat] = 119;
   _jumpMap[285][SignedInt] = 118;
   _jumpMap[285][Attribute] = 117;
   _jumpMap[285][ExpressionList] = 452;
}
void Cego::loadParser205()
{
   _jumpMap[285][Function] = 116;
   _jumpMap[285][CasePrepare] = 115;
   _jumpMap[285][CaseClause] = 114;
   _jumpMap[285][Factor] = 113;
   _jumpMap[285][Term] = 112;
   _jumpMap[285][Expr] = 446;
   _actionMap[286][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[286][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[286][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[286][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[286][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[286][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[286][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[286][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[286][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[286][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[286][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[286][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[286][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[286][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[286][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[286][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[286][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[286][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[286][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[286][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[286][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[286][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[286][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[286][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[286][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[286][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[286][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[286][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[286][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[286][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[286][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[286][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[286][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[286][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[286][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[286][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[286][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[286][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[286][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[286][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[286][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[286][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[286][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[286][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
}
void Cego::loadParser206()
{
   _actionMap[286][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[286][LB] = ActionEntry(SHIFT, 176);
   _actionMap[286][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[286][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[286][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[286][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[286][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[286][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[286][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[286][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[286][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[286][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[286][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[286][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[286][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[286][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[286][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[286][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[286][MAX] = ActionEntry(SHIFT, 154);
   _jumpMap[286][ObjSpec] = 121;
   _jumpMap[286][Constant] = 120;
   _jumpMap[286][SignedFloat] = 119;
   _jumpMap[286][SignedInt] = 118;
   _jumpMap[286][Attribute] = 117;
   _jumpMap[286][ExpressionList] = 453;
   _jumpMap[286][Function] = 116;
   _jumpMap[286][CasePrepare] = 115;
   _jumpMap[286][CaseClause] = 114;
   _jumpMap[286][Factor] = 113;
   _jumpMap[286][Term] = 112;
   _jumpMap[286][Expr] = 446;
   _actionMap[287][INTVAL] = ActionEntry(SHIFT, 454);
   _actionMap[288][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[288][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[288][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[288][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[288][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[288][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[288][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[288][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[288][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[288][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[288][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[288][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[288][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[288][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[288][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[288][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[288][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[288][GETPOS] = ActionEntry(SHIFT, 143);
}
void Cego::loadParser207()
{
   _actionMap[288][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[288][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[288][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[288][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[288][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[288][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[288][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[288][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[288][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[288][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[288][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[288][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[288][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[288][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[288][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[288][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[288][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[288][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[288][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[288][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[288][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[288][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[288][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[288][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[288][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[288][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[288][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[288][LB] = ActionEntry(SHIFT, 176);
   _actionMap[288][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[288][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[288][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[288][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[288][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[288][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[288][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[288][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[288][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[288][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[288][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[288][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[288][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[288][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[288][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[288][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[288][MAX] = ActionEntry(SHIFT, 154);
   _jumpMap[288][ObjSpec] = 121;
   _jumpMap[288][Constant] = 120;
   _jumpMap[288][SignedFloat] = 119;
   _jumpMap[288][SignedInt] = 118;
   _jumpMap[288][Attribute] = 117;
}
void Cego::loadParser208()
{
   _jumpMap[288][ExpressionList] = 455;
   _jumpMap[288][Function] = 116;
   _jumpMap[288][CasePrepare] = 115;
   _jumpMap[288][CaseClause] = 114;
   _jumpMap[288][Factor] = 113;
   _jumpMap[288][Term] = 112;
   _jumpMap[288][Expr] = 446;
   _actionMap[289][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[289][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[289][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[289][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[289][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[289][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[289][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[289][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[289][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[289][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[289][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[289][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[289][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[289][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[289][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[289][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[289][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[289][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[289][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[289][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[289][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[289][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[289][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[289][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[289][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[289][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[289][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[289][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[289][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[289][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[289][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[289][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[289][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[289][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[289][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[289][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[289][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[289][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[289][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[289][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[289][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[289][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[289][IDENTIFIER] = ActionEntry(SHIFT, 180);
}
void Cego::loadParser209()
{
   _actionMap[289][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[289][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[289][LB] = ActionEntry(SHIFT, 176);
   _actionMap[289][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[289][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[289][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[289][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[289][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[289][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[289][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[289][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[289][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[289][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[289][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[289][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[289][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[289][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[289][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[289][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[289][MAX] = ActionEntry(SHIFT, 154);
   _jumpMap[289][ObjSpec] = 121;
   _jumpMap[289][Constant] = 120;
   _jumpMap[289][SignedFloat] = 119;
   _jumpMap[289][SignedInt] = 118;
   _jumpMap[289][Attribute] = 117;
   _jumpMap[289][ExpressionList] = 456;
   _jumpMap[289][Function] = 116;
   _jumpMap[289][CasePrepare] = 115;
   _jumpMap[289][CaseClause] = 114;
   _jumpMap[289][Factor] = 113;
   _jumpMap[289][Term] = 112;
   _jumpMap[289][Expr] = 446;
   _actionMap[290][INTVAL] = ActionEntry(SHIFT, 457);
   _actionMap[291][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[291][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[291][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[291][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[291][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[291][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[291][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[291][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[291][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[291][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[291][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[291][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[291][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[291][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[291][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[291][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[291][RIGHT] = ActionEntry(SHIFT, 162);
}
void Cego::loadParser210()
{
   _actionMap[291][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[291][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[291][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[291][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[291][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[291][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[291][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[291][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[291][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[291][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[291][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[291][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[291][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[291][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[291][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[291][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[291][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[291][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[291][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[291][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[291][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[291][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[291][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[291][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[291][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[291][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[291][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[291][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[291][LB] = ActionEntry(SHIFT, 176);
   _actionMap[291][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[291][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[291][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[291][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[291][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[291][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[291][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[291][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[291][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[291][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[291][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[291][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[291][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[291][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[291][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[291][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[291][MAX] = ActionEntry(SHIFT, 154);
   _jumpMap[291][ObjSpec] = 121;
   _jumpMap[291][Constant] = 120;
   _jumpMap[291][SignedFloat] = 119;
   _jumpMap[291][SignedInt] = 118;
}
void Cego::loadParser211()
{
   _jumpMap[291][Attribute] = 117;
   _jumpMap[291][ExpressionList] = 458;
   _jumpMap[291][Function] = 116;
   _jumpMap[291][CasePrepare] = 115;
   _jumpMap[291][CaseClause] = 114;
   _jumpMap[291][Factor] = 113;
   _jumpMap[291][Term] = 112;
   _jumpMap[291][Expr] = 446;
   _actionMap[292][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[292][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[292][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[292][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[292][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[292][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[292][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[292][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[292][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[292][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[292][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[292][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[292][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[292][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[292][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[292][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[292][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[292][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[292][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[292][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[292][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[292][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[292][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[292][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[292][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[292][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[292][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[292][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[292][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[292][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[292][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[292][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[292][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[292][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[292][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[292][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[292][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[292][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[292][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[292][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[292][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[292][SETCOUNT] = ActionEntry(SHIFT, 165);
}
void Cego::loadParser212()
{
   _actionMap[292][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[292][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[292][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[292][LB] = ActionEntry(SHIFT, 176);
   _actionMap[292][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[292][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[292][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[292][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[292][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[292][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[292][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[292][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[292][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[292][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[292][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[292][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[292][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[292][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[292][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[292][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[292][MAX] = ActionEntry(SHIFT, 154);
   _jumpMap[292][ObjSpec] = 121;
   _jumpMap[292][Constant] = 120;
   _jumpMap[292][SignedFloat] = 119;
   _jumpMap[292][SignedInt] = 118;
   _jumpMap[292][Attribute] = 117;
   _jumpMap[292][ExpressionList] = 459;
   _jumpMap[292][Function] = 116;
   _jumpMap[292][CasePrepare] = 115;
   _jumpMap[292][CaseClause] = 114;
   _jumpMap[292][Factor] = 113;
   _jumpMap[292][Term] = 112;
   _jumpMap[292][Expr] = 446;
   _actionMap[293][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[293][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[293][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[293][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[293][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[293][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[293][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[293][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[293][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[293][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[293][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[293][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[293][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[293][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[293][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[293][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[293][RIGHT] = ActionEntry(SHIFT, 162);
}
void Cego::loadParser213()
{
   _actionMap[293][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[293][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[293][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[293][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[293][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[293][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[293][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[293][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[293][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[293][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[293][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[293][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[293][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[293][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[293][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[293][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[293][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[293][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[293][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[293][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[293][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[293][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[293][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[293][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[293][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[293][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[293][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[293][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[293][LB] = ActionEntry(SHIFT, 176);
   _actionMap[293][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[293][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[293][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[293][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[293][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[293][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[293][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[293][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[293][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[293][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[293][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[293][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[293][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[293][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[293][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[293][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[293][MAX] = ActionEntry(SHIFT, 154);
   _jumpMap[293][ObjSpec] = 121;
   _jumpMap[293][Constant] = 120;
   _jumpMap[293][SignedFloat] = 119;
   _jumpMap[293][SignedInt] = 118;
}
void Cego::loadParser214()
{
   _jumpMap[293][Attribute] = 117;
   _jumpMap[293][ExpressionList] = 460;
   _jumpMap[293][Function] = 116;
   _jumpMap[293][CasePrepare] = 115;
   _jumpMap[293][CaseClause] = 114;
   _jumpMap[293][Factor] = 113;
   _jumpMap[293][Term] = 112;
   _jumpMap[293][Expr] = 446;
   _actionMap[294][STAR] = ActionEntry(SHIFT, 462);
   _actionMap[294][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[294][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[294][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[294][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[294][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[294][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[294][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[294][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[294][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[294][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[294][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[294][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[294][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[294][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[294][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[294][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[294][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[294][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[294][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[294][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[294][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[294][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[294][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[294][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[294][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[294][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[294][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[294][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[294][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[294][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[294][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[294][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[294][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[294][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[294][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[294][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[294][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[294][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[294][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[294][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[294][NEXTCOUNT] = ActionEntry(SHIFT, 156);
}
void Cego::loadParser215()
{
   _actionMap[294][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[294][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[294][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[294][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[294][LB] = ActionEntry(SHIFT, 176);
   _actionMap[294][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[294][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[294][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[294][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[294][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[294][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[294][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[294][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[294][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[294][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[294][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[294][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[294][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[294][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[294][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[294][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[294][MAX] = ActionEntry(SHIFT, 154);
   _jumpMap[294][ObjSpec] = 121;
   _jumpMap[294][Constant] = 120;
   _jumpMap[294][SignedFloat] = 119;
   _jumpMap[294][SignedInt] = 118;
   _jumpMap[294][Attribute] = 117;
   _jumpMap[294][Function] = 116;
   _jumpMap[294][CasePrepare] = 115;
   _jumpMap[294][CaseClause] = 114;
   _jumpMap[294][Factor] = 113;
   _jumpMap[294][Term] = 112;
   _jumpMap[294][Expr] = 461;
   _actionMap[295][STRINGVAL] = ActionEntry(SHIFT, 464);
   _jumpMap[295][DateFormat] = 463;
   _actionMap[296][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[296][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[296][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[296][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[296][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[296][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[296][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[296][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[296][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[296][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[296][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[296][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[296][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[296][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[296][UPPER] = ActionEntry(SHIFT, 175);
}
void Cego::loadParser216()
{
   _actionMap[296][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[296][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[296][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[296][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[296][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[296][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[296][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[296][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[296][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[296][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[296][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[296][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[296][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[296][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[296][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[296][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[296][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[296][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[296][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[296][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[296][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[296][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[296][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[296][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[296][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[296][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[296][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[296][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[296][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[296][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[296][LB] = ActionEntry(SHIFT, 176);
   _actionMap[296][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[296][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[296][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[296][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[296][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[296][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[296][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[296][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[296][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[296][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[296][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[296][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[296][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[296][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[296][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[296][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[296][MAX] = ActionEntry(SHIFT, 154);
   _jumpMap[296][ObjSpec] = 121;
   _jumpMap[296][Constant] = 120;
}
void Cego::loadParser217()
{
   _jumpMap[296][SignedFloat] = 119;
   _jumpMap[296][SignedInt] = 118;
   _jumpMap[296][Attribute] = 117;
   _jumpMap[296][ExpressionList] = 465;
   _jumpMap[296][Function] = 116;
   _jumpMap[296][CasePrepare] = 115;
   _jumpMap[296][CaseClause] = 114;
   _jumpMap[296][Factor] = 113;
   _jumpMap[296][Term] = 112;
   _jumpMap[296][Expr] = 446;
   _actionMap[297][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[297][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[297][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[297][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[297][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[297][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[297][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[297][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[297][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[297][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[297][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[297][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[297][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[297][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[297][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[297][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[297][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[297][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[297][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[297][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[297][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[297][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[297][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[297][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[297][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[297][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[297][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[297][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[297][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[297][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[297][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[297][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[297][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[297][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[297][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[297][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[297][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[297][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[297][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[297][CLOB2STR] = ActionEntry(SHIFT, 135);
}
void Cego::loadParser218()
{
   _actionMap[297][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[297][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[297][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[297][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[297][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[297][LB] = ActionEntry(SHIFT, 176);
   _actionMap[297][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[297][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[297][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[297][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[297][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[297][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[297][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[297][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[297][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[297][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[297][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[297][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[297][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[297][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[297][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[297][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[297][MAX] = ActionEntry(SHIFT, 154);
   _jumpMap[297][ObjSpec] = 121;
   _jumpMap[297][Constant] = 120;
   _jumpMap[297][SignedFloat] = 119;
   _jumpMap[297][SignedInt] = 118;
   _jumpMap[297][Attribute] = 117;
   _jumpMap[297][ExpressionList] = 466;
   _jumpMap[297][Function] = 116;
   _jumpMap[297][CasePrepare] = 115;
   _jumpMap[297][CaseClause] = 114;
   _jumpMap[297][Factor] = 113;
   _jumpMap[297][Term] = 112;
   _jumpMap[297][Expr] = 446;
   _actionMap[298][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[298][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[298][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[298][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[298][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[298][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[298][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[298][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[298][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[298][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[298][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[298][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[298][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[298][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[298][UPPER] = ActionEntry(SHIFT, 175);
}
void Cego::loadParser219()
{
   _actionMap[298][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[298][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[298][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[298][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[298][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[298][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[298][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[298][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[298][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[298][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[298][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[298][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[298][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[298][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[298][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[298][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[298][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[298][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[298][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[298][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[298][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[298][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[298][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[298][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[298][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[298][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[298][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[298][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[298][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[298][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[298][LB] = ActionEntry(SHIFT, 176);
   _actionMap[298][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[298][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[298][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[298][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[298][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[298][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[298][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[298][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[298][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[298][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[298][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[298][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[298][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[298][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[298][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[298][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[298][MAX] = ActionEntry(SHIFT, 154);
   _jumpMap[298][ObjSpec] = 121;
   _jumpMap[298][Constant] = 120;
}
void Cego::loadParser220()
{
   _jumpMap[298][SignedFloat] = 119;
   _jumpMap[298][SignedInt] = 118;
   _jumpMap[298][Attribute] = 117;
   _jumpMap[298][ExpressionList] = 467;
   _jumpMap[298][Function] = 116;
   _jumpMap[298][CasePrepare] = 115;
   _jumpMap[298][CaseClause] = 114;
   _jumpMap[298][Factor] = 113;
   _jumpMap[298][Term] = 112;
   _jumpMap[298][Expr] = 446;
   _actionMap[299][INTO] = ActionEntry(SHIFT, 468);
   _actionMap[300][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[300][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[300][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[300][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[300][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[300][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[300][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[300][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[300][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[300][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[300][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[300][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[300][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[300][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[300][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[300][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[300][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[300][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[300][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[300][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[300][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[300][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[300][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[300][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[300][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[300][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[300][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[300][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[300][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[300][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[300][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[300][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[300][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[300][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[300][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[300][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[300][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[300][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[300][CLOBREF] = ActionEntry(SHIFT, 134);
}
void Cego::loadParser221()
{
   _actionMap[300][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[300][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[300][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[300][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[300][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[300][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[300][LB] = ActionEntry(SHIFT, 176);
   _actionMap[300][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[300][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[300][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[300][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[300][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[300][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[300][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[300][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[300][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[300][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[300][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[300][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[300][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[300][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[300][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[300][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[300][MAX] = ActionEntry(SHIFT, 154);
   _jumpMap[300][ObjSpec] = 121;
   _jumpMap[300][Constant] = 120;
   _jumpMap[300][SignedFloat] = 119;
   _jumpMap[300][SignedInt] = 118;
   _jumpMap[300][Attribute] = 117;
   _jumpMap[300][ExpressionList] = 469;
   _jumpMap[300][Function] = 116;
   _jumpMap[300][CasePrepare] = 115;
   _jumpMap[300][CaseClause] = 114;
   _jumpMap[300][Factor] = 113;
   _jumpMap[300][Term] = 112;
   _jumpMap[300][Expr] = 446;
   _actionMap[301][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[301][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[301][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[301][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[301][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[301][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[301][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[301][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[301][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[301][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[301][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[301][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[301][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[301][LOWER] = ActionEntry(SHIFT, 151);
}
void Cego::loadParser222()
{
   _actionMap[301][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[301][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[301][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[301][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[301][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[301][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[301][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[301][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[301][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[301][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[301][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[301][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[301][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[301][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[301][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[301][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[301][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[301][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[301][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[301][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[301][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[301][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[301][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[301][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[301][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[301][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[301][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[301][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[301][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[301][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[301][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[301][LB] = ActionEntry(SHIFT, 176);
   _actionMap[301][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[301][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[301][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[301][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[301][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[301][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[301][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[301][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[301][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[301][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[301][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[301][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[301][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[301][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[301][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[301][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[301][MAX] = ActionEntry(SHIFT, 154);
   _jumpMap[301][ObjSpec] = 121;
}
void Cego::loadParser223()
{
   _jumpMap[301][Constant] = 120;
   _jumpMap[301][SignedFloat] = 119;
   _jumpMap[301][SignedInt] = 118;
   _jumpMap[301][Attribute] = 117;
   _jumpMap[301][ExpressionList] = 470;
   _jumpMap[301][Function] = 116;
   _jumpMap[301][CasePrepare] = 115;
   _jumpMap[301][CaseClause] = 114;
   _jumpMap[301][Factor] = 113;
   _jumpMap[301][Term] = 112;
   _jumpMap[301][Expr] = 446;
   _actionMap[302][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[302][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[302][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[302][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[302][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[302][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[302][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[302][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[302][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[302][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[302][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[302][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[302][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[302][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[302][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[302][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[302][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[302][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[302][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[302][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[302][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[302][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[302][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[302][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[302][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[302][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[302][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[302][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[302][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[302][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[302][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[302][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[302][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[302][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[302][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[302][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[302][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[302][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[302][CLOBREF] = ActionEntry(SHIFT, 134);
}
void Cego::loadParser224()
{
   _actionMap[302][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[302][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[302][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[302][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[302][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[302][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[302][LB] = ActionEntry(SHIFT, 176);
   _actionMap[302][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[302][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[302][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[302][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[302][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[302][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[302][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[302][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[302][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[302][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[302][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[302][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[302][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[302][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[302][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[302][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[302][MAX] = ActionEntry(SHIFT, 154);
   _jumpMap[302][ObjSpec] = 121;
   _jumpMap[302][Constant] = 120;
   _jumpMap[302][SignedFloat] = 119;
   _jumpMap[302][SignedInt] = 118;
   _jumpMap[302][Attribute] = 117;
   _jumpMap[302][ExpressionList] = 471;
   _jumpMap[302][Function] = 116;
   _jumpMap[302][CasePrepare] = 115;
   _jumpMap[302][CaseClause] = 114;
   _jumpMap[302][Factor] = 113;
   _jumpMap[302][Term] = 112;
   _jumpMap[302][Expr] = 446;
   _actionMap[303][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[303][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[303][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[303][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[303][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[303][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[303][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[303][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[303][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[303][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[303][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[303][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[303][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[303][LOWER] = ActionEntry(SHIFT, 151);
}
void Cego::loadParser225()
{
   _actionMap[303][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[303][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[303][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[303][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[303][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[303][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[303][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[303][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[303][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[303][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[303][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[303][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[303][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[303][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[303][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[303][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[303][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[303][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[303][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[303][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[303][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[303][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[303][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[303][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[303][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[303][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[303][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[303][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[303][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[303][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[303][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[303][LB] = ActionEntry(SHIFT, 176);
   _actionMap[303][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[303][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[303][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[303][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[303][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[303][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[303][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[303][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[303][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[303][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[303][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[303][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[303][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[303][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[303][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[303][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[303][MAX] = ActionEntry(SHIFT, 154);
   _jumpMap[303][ObjSpec] = 121;
}
void Cego::loadParser226()
{
   _jumpMap[303][Constant] = 120;
   _jumpMap[303][SignedFloat] = 119;
   _jumpMap[303][SignedInt] = 118;
   _jumpMap[303][Attribute] = 117;
   _jumpMap[303][ExpressionList] = 472;
   _jumpMap[303][Function] = 116;
   _jumpMap[303][CasePrepare] = 115;
   _jumpMap[303][CaseClause] = 114;
   _jumpMap[303][Factor] = 113;
   _jumpMap[303][Term] = 112;
   _jumpMap[303][Expr] = 446;
   _actionMap[304][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[304][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[304][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[304][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[304][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[304][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[304][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[304][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[304][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[304][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[304][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[304][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[304][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[304][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[304][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[304][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[304][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[304][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[304][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[304][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[304][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[304][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[304][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[304][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[304][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[304][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[304][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[304][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[304][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[304][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[304][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[304][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[304][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[304][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[304][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[304][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[304][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[304][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[304][CLOBREF] = ActionEntry(SHIFT, 134);
}
void Cego::loadParser227()
{
   _actionMap[304][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[304][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[304][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[304][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[304][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[304][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[304][LB] = ActionEntry(SHIFT, 176);
   _actionMap[304][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[304][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[304][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[304][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[304][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[304][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[304][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[304][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[304][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[304][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[304][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[304][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[304][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[304][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[304][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[304][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[304][MAX] = ActionEntry(SHIFT, 154);
   _jumpMap[304][ObjSpec] = 121;
   _jumpMap[304][Constant] = 120;
   _jumpMap[304][SignedFloat] = 119;
   _jumpMap[304][SignedInt] = 118;
   _jumpMap[304][Attribute] = 117;
   _jumpMap[304][ExpressionList] = 473;
   _jumpMap[304][Function] = 116;
   _jumpMap[304][CasePrepare] = 115;
   _jumpMap[304][CaseClause] = 114;
   _jumpMap[304][Factor] = 113;
   _jumpMap[304][Term] = 112;
   _jumpMap[304][Expr] = 446;
   _actionMap[305][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[305][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[305][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[305][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[305][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[305][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[305][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[305][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[305][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[305][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[305][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[305][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[305][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[305][LOWER] = ActionEntry(SHIFT, 151);
}
void Cego::loadParser228()
{
   _actionMap[305][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[305][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[305][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[305][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[305][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[305][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[305][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[305][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[305][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[305][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[305][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[305][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[305][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[305][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[305][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[305][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[305][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[305][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[305][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[305][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[305][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[305][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[305][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[305][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[305][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[305][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[305][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[305][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[305][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[305][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[305][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[305][LB] = ActionEntry(SHIFT, 176);
   _actionMap[305][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[305][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[305][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[305][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[305][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[305][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[305][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[305][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[305][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[305][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[305][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[305][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[305][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[305][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[305][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[305][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[305][MAX] = ActionEntry(SHIFT, 154);
   _jumpMap[305][ObjSpec] = 121;
}
void Cego::loadParser229()
{
   _jumpMap[305][Constant] = 120;
   _jumpMap[305][SignedFloat] = 119;
   _jumpMap[305][SignedInt] = 118;
   _jumpMap[305][Attribute] = 117;
   _jumpMap[305][ExpressionList] = 474;
   _jumpMap[305][Function] = 116;
   _jumpMap[305][CasePrepare] = 115;
   _jumpMap[305][CaseClause] = 114;
   _jumpMap[305][Factor] = 113;
   _jumpMap[305][Term] = 112;
   _jumpMap[305][Expr] = 446;
   _actionMap[306][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[306][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[306][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[306][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[306][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[306][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[306][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[306][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[306][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[306][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[306][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[306][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[306][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[306][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[306][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[306][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[306][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[306][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[306][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[306][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[306][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[306][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[306][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[306][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[306][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[306][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[306][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[306][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[306][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[306][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[306][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[306][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[306][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[306][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[306][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[306][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[306][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[306][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[306][CLOBREF] = ActionEntry(SHIFT, 134);
}
void Cego::loadParser230()
{
   _actionMap[306][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[306][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[306][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[306][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[306][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[306][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[306][LB] = ActionEntry(SHIFT, 176);
   _actionMap[306][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[306][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[306][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[306][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[306][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[306][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[306][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[306][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[306][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[306][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[306][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[306][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[306][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[306][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[306][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[306][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[306][MAX] = ActionEntry(SHIFT, 154);
   _jumpMap[306][ObjSpec] = 121;
   _jumpMap[306][Constant] = 120;
   _jumpMap[306][SignedFloat] = 119;
   _jumpMap[306][SignedInt] = 118;
   _jumpMap[306][Attribute] = 117;
   _jumpMap[306][ExpressionList] = 475;
   _jumpMap[306][Function] = 116;
   _jumpMap[306][CasePrepare] = 115;
   _jumpMap[306][CaseClause] = 114;
   _jumpMap[306][Factor] = 113;
   _jumpMap[306][Term] = 112;
   _jumpMap[306][Expr] = 446;
   _actionMap[307][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[307][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[307][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[307][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[307][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[307][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[307][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[307][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[307][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[307][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[307][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[307][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[307][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[307][LOWER] = ActionEntry(SHIFT, 151);
}
void Cego::loadParser231()
{
   _actionMap[307][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[307][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[307][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[307][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[307][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[307][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[307][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[307][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[307][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[307][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[307][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[307][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[307][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[307][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[307][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[307][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[307][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[307][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[307][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[307][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[307][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[307][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[307][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[307][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[307][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[307][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[307][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[307][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[307][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[307][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[307][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[307][LB] = ActionEntry(SHIFT, 176);
   _actionMap[307][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[307][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[307][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[307][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[307][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[307][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[307][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[307][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[307][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[307][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[307][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[307][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[307][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[307][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[307][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[307][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[307][MAX] = ActionEntry(SHIFT, 154);
   _jumpMap[307][ObjSpec] = 121;
}
void Cego::loadParser232()
{
   _jumpMap[307][Constant] = 120;
   _jumpMap[307][SignedFloat] = 119;
   _jumpMap[307][SignedInt] = 118;
   _jumpMap[307][Attribute] = 117;
   _jumpMap[307][ExpressionList] = 476;
   _jumpMap[307][Function] = 116;
   _jumpMap[307][CasePrepare] = 115;
   _jumpMap[307][CaseClause] = 114;
   _jumpMap[307][Factor] = 113;
   _jumpMap[307][Term] = 112;
   _jumpMap[307][Expr] = 446;
   _actionMap[308][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[308][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[308][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[308][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[308][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[308][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[308][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[308][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[308][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[308][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[308][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[308][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[308][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[308][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[308][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[308][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[308][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[308][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[308][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[308][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[308][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[308][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[308][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[308][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[308][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[308][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[308][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[308][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[308][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[308][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[308][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[308][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[308][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[308][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[308][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[308][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[308][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[308][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[308][CLOBREF] = ActionEntry(SHIFT, 134);
}
void Cego::loadParser233()
{
   _actionMap[308][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[308][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[308][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[308][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[308][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[308][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[308][LB] = ActionEntry(SHIFT, 176);
   _actionMap[308][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[308][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[308][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[308][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[308][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[308][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[308][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[308][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[308][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[308][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[308][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[308][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[308][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[308][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[308][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[308][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[308][MAX] = ActionEntry(SHIFT, 154);
   _jumpMap[308][ObjSpec] = 121;
   _jumpMap[308][Constant] = 120;
   _jumpMap[308][SignedFloat] = 119;
   _jumpMap[308][SignedInt] = 118;
   _jumpMap[308][Attribute] = 117;
   _jumpMap[308][ExpressionList] = 477;
   _jumpMap[308][Function] = 116;
   _jumpMap[308][CasePrepare] = 115;
   _jumpMap[308][CaseClause] = 114;
   _jumpMap[308][Factor] = 113;
   _jumpMap[308][Term] = 112;
   _jumpMap[308][Expr] = 446;
   _actionMap[309][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[309][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[309][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[309][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[309][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[309][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[309][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[309][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[309][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[309][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[309][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[309][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[309][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[309][LOWER] = ActionEntry(SHIFT, 151);
}
void Cego::loadParser234()
{
   _actionMap[309][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[309][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[309][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[309][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[309][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[309][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[309][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[309][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[309][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[309][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[309][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[309][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[309][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[309][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[309][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[309][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[309][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[309][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[309][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[309][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[309][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[309][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[309][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[309][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[309][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[309][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[309][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[309][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[309][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[309][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[309][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[309][LB] = ActionEntry(SHIFT, 176);
   _actionMap[309][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[309][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[309][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[309][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[309][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[309][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[309][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[309][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[309][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[309][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[309][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[309][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[309][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[309][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[309][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[309][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[309][MAX] = ActionEntry(SHIFT, 154);
   _jumpMap[309][ObjSpec] = 121;
}
void Cego::loadParser235()
{
   _jumpMap[309][Constant] = 120;
   _jumpMap[309][SignedFloat] = 119;
   _jumpMap[309][SignedInt] = 118;
   _jumpMap[309][Attribute] = 117;
   _jumpMap[309][ExpressionList] = 478;
   _jumpMap[309][Function] = 116;
   _jumpMap[309][CasePrepare] = 115;
   _jumpMap[309][CaseClause] = 114;
   _jumpMap[309][Factor] = 113;
   _jumpMap[309][Term] = 112;
   _jumpMap[309][Expr] = 446;
   _actionMap[310][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[310][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[310][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[310][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[310][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[310][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[310][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[310][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[310][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[310][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[310][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[310][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[310][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[310][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[310][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[310][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[310][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[310][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[310][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[310][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[310][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[310][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[310][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[310][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[310][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[310][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[310][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[310][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[310][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[310][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[310][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[310][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[310][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[310][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[310][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[310][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[310][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[310][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[310][CLOBREF] = ActionEntry(SHIFT, 134);
}
void Cego::loadParser236()
{
   _actionMap[310][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[310][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[310][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[310][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[310][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[310][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[310][LB] = ActionEntry(SHIFT, 176);
   _actionMap[310][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[310][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[310][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[310][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[310][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[310][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[310][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[310][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[310][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[310][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[310][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[310][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[310][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[310][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[310][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[310][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[310][MAX] = ActionEntry(SHIFT, 154);
   _jumpMap[310][ObjSpec] = 121;
   _jumpMap[310][Constant] = 120;
   _jumpMap[310][SignedFloat] = 119;
   _jumpMap[310][SignedInt] = 118;
   _jumpMap[310][Attribute] = 117;
   _jumpMap[310][Function] = 116;
   _jumpMap[310][CasePrepare] = 115;
   _jumpMap[310][CaseClause] = 114;
   _jumpMap[310][Factor] = 113;
   _jumpMap[310][Term] = 112;
   _jumpMap[310][Expr] = 479;
   _actionMap[311][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[311][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[311][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[311][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[311][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[311][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[311][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[311][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[311][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[311][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[311][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[311][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[311][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[311][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[311][UPPER] = ActionEntry(SHIFT, 175);
}
void Cego::loadParser237()
{
   _actionMap[311][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[311][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[311][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[311][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[311][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[311][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[311][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[311][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[311][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[311][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[311][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[311][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[311][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[311][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[311][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[311][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[311][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[311][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[311][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[311][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[311][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[311][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[311][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[311][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[311][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[311][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[311][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[311][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[311][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[311][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[311][LB] = ActionEntry(SHIFT, 176);
   _actionMap[311][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[311][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[311][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[311][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[311][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[311][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[311][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[311][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[311][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[311][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[311][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[311][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[311][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[311][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[311][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[311][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[311][MAX] = ActionEntry(SHIFT, 154);
   _jumpMap[311][ObjSpec] = 121;
   _jumpMap[311][Constant] = 120;
}
void Cego::loadParser238()
{
   _jumpMap[311][SignedFloat] = 119;
   _jumpMap[311][SignedInt] = 118;
   _jumpMap[311][Attribute] = 117;
   _jumpMap[311][Function] = 116;
   _jumpMap[311][CasePrepare] = 115;
   _jumpMap[311][CaseClause] = 114;
   _jumpMap[311][Factor] = 113;
   _jumpMap[311][Term] = 112;
   _jumpMap[311][Expr] = 480;
   _actionMap[312][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[312][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[312][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[312][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[312][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[312][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[312][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[312][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[312][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[312][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[312][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[312][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[312][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[312][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[312][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[312][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[312][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[312][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[312][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[312][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[312][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[312][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[312][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[312][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[312][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[312][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[312][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[312][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[312][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[312][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[312][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[312][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[312][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[312][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[312][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[312][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[312][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[312][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[312][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[312][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[312][NEXTCOUNT] = ActionEntry(SHIFT, 156);
}
void Cego::loadParser239()
{
   _actionMap[312][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[312][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[312][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[312][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[312][LB] = ActionEntry(SHIFT, 176);
   _actionMap[312][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[312][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[312][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[312][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[312][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[312][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[312][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[312][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[312][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[312][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[312][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[312][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[312][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[312][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[312][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[312][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[312][MAX] = ActionEntry(SHIFT, 154);
   _jumpMap[312][ObjSpec] = 121;
   _jumpMap[312][Constant] = 120;
   _jumpMap[312][SignedFloat] = 119;
   _jumpMap[312][SignedInt] = 118;
   _jumpMap[312][Attribute] = 117;
   _jumpMap[312][ExpressionList] = 481;
   _jumpMap[312][Function] = 116;
   _jumpMap[312][CasePrepare] = 115;
   _jumpMap[312][CaseClause] = 114;
   _jumpMap[312][Factor] = 113;
   _jumpMap[312][Term] = 112;
   _jumpMap[312][Expr] = 446;
   _actionMap[313][IDENTIFIER] = ActionEntry(SHIFT, 482);
   _actionMap[314][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[314][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[314][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[314][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[314][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[314][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[314][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[314][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[314][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[314][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[314][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[314][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[314][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[314][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[314][UPPER] = ActionEntry(SHIFT, 175);
}
void Cego::loadParser240()
{
   _actionMap[314][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[314][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[314][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[314][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[314][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[314][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[314][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[314][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[314][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[314][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[314][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[314][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[314][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[314][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[314][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[314][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[314][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[314][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[314][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[314][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[314][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[314][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[314][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[314][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[314][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[314][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[314][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[314][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[314][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[314][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[314][LB] = ActionEntry(SHIFT, 176);
   _actionMap[314][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[314][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[314][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[314][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[314][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[314][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[314][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[314][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[314][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[314][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[314][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[314][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[314][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[314][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[314][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[314][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[314][MAX] = ActionEntry(SHIFT, 154);
   _jumpMap[314][ObjSpec] = 121;
   _jumpMap[314][Constant] = 120;
}
void Cego::loadParser241()
{
   _jumpMap[314][SignedFloat] = 119;
   _jumpMap[314][SignedInt] = 118;
   _jumpMap[314][Attribute] = 117;
   _jumpMap[314][ExpressionList] = 483;
   _jumpMap[314][Function] = 116;
   _jumpMap[314][CasePrepare] = 115;
   _jumpMap[314][CaseClause] = 114;
   _jumpMap[314][Factor] = 113;
   _jumpMap[314][Term] = 112;
   _jumpMap[314][Expr] = 446;
   _actionMap[315][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[315][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[315][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[315][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[315][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[315][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[315][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[315][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[315][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[315][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[315][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[315][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[315][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[315][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[315][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[315][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[315][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[315][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[315][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[315][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[315][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[315][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[315][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[315][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[315][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[315][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[315][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[315][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[315][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[315][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[315][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[315][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[315][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[315][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[315][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[315][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[315][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[315][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[315][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[315][CLOB2STR] = ActionEntry(SHIFT, 135);
}
void Cego::loadParser242()
{
   _actionMap[315][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[315][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[315][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[315][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[315][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[315][LB] = ActionEntry(SHIFT, 176);
   _actionMap[315][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[315][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[315][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[315][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[315][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[315][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[315][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[315][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[315][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[315][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[315][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[315][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[315][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[315][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[315][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[315][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[315][MAX] = ActionEntry(SHIFT, 154);
   _jumpMap[315][ObjSpec] = 121;
   _jumpMap[315][Constant] = 120;
   _jumpMap[315][SignedFloat] = 119;
   _jumpMap[315][SignedInt] = 118;
   _jumpMap[315][Attribute] = 117;
   _jumpMap[315][ExpressionList] = 484;
   _jumpMap[315][Function] = 116;
   _jumpMap[315][CasePrepare] = 115;
   _jumpMap[315][CaseClause] = 114;
   _jumpMap[315][Factor] = 113;
   _jumpMap[315][Term] = 112;
   _jumpMap[315][Expr] = 446;
   _actionMap[316][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[316][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[316][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[316][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[316][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[316][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[316][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[316][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[316][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[316][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[316][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[316][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[316][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[316][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[316][UPPER] = ActionEntry(SHIFT, 175);
}
void Cego::loadParser243()
{
   _actionMap[316][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[316][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[316][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[316][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[316][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[316][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[316][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[316][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[316][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[316][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[316][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[316][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[316][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[316][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[316][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[316][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[316][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[316][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[316][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[316][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[316][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[316][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[316][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[316][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[316][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[316][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[316][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[316][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[316][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[316][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[316][LB] = ActionEntry(SHIFT, 176);
   _actionMap[316][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[316][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[316][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[316][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[316][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[316][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[316][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[316][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[316][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[316][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[316][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[316][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[316][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[316][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[316][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[316][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[316][MAX] = ActionEntry(SHIFT, 154);
   _jumpMap[316][ObjSpec] = 121;
   _jumpMap[316][Constant] = 120;
}
void Cego::loadParser244()
{
   _jumpMap[316][SignedFloat] = 119;
   _jumpMap[316][SignedInt] = 118;
   _jumpMap[316][Attribute] = 117;
   _jumpMap[316][ExpressionList] = 485;
   _jumpMap[316][Function] = 116;
   _jumpMap[316][CasePrepare] = 115;
   _jumpMap[316][CaseClause] = 114;
   _jumpMap[316][Factor] = 113;
   _jumpMap[316][Term] = 112;
   _jumpMap[316][Expr] = 446;
   _actionMap[317][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[317][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[317][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[317][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[317][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[317][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[317][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[317][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[317][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[317][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[317][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[317][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[317][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[317][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[317][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[317][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[317][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[317][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[317][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[317][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[317][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[317][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[317][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[317][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[317][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[317][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[317][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[317][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[317][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[317][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[317][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[317][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[317][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[317][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[317][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[317][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[317][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[317][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[317][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[317][CLOB2STR] = ActionEntry(SHIFT, 135);
}
void Cego::loadParser245()
{
   _actionMap[317][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[317][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[317][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[317][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[317][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[317][LB] = ActionEntry(SHIFT, 176);
   _actionMap[317][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[317][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[317][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[317][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[317][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[317][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[317][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[317][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[317][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[317][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[317][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[317][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[317][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[317][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[317][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[317][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[317][MAX] = ActionEntry(SHIFT, 154);
   _jumpMap[317][ObjSpec] = 121;
   _jumpMap[317][Constant] = 120;
   _jumpMap[317][SignedFloat] = 119;
   _jumpMap[317][SignedInt] = 118;
   _jumpMap[317][Attribute] = 117;
   _jumpMap[317][ExpressionList] = 486;
   _jumpMap[317][Function] = 116;
   _jumpMap[317][CasePrepare] = 115;
   _jumpMap[317][CaseClause] = 114;
   _jumpMap[317][Factor] = 113;
   _jumpMap[317][Term] = 112;
   _jumpMap[317][Expr] = 446;
   _actionMap[318][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[318][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[318][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[318][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[318][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[318][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[318][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[318][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[318][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[318][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[318][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[318][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[318][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[318][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[318][UPPER] = ActionEntry(SHIFT, 175);
}
void Cego::loadParser246()
{
   _actionMap[318][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[318][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[318][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[318][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[318][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[318][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[318][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[318][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[318][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[318][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[318][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[318][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[318][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[318][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[318][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[318][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[318][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[318][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[318][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[318][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[318][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[318][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[318][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[318][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[318][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[318][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[318][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[318][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[318][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[318][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[318][LB] = ActionEntry(SHIFT, 176);
   _actionMap[318][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[318][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[318][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[318][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[318][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[318][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[318][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[318][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[318][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[318][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[318][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[318][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[318][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[318][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[318][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[318][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[318][MAX] = ActionEntry(SHIFT, 154);
   _jumpMap[318][ObjSpec] = 121;
   _jumpMap[318][Constant] = 120;
}
void Cego::loadParser247()
{
   _jumpMap[318][SignedFloat] = 119;
   _jumpMap[318][SignedInt] = 118;
   _jumpMap[318][Attribute] = 117;
   _jumpMap[318][ExpressionList] = 487;
   _jumpMap[318][Function] = 116;
   _jumpMap[318][CasePrepare] = 115;
   _jumpMap[318][CaseClause] = 114;
   _jumpMap[318][Factor] = 113;
   _jumpMap[318][Term] = 112;
   _jumpMap[318][Expr] = 446;
   _actionMap[319][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[319][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[319][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[319][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[319][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[319][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[319][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[319][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[319][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[319][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[319][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[319][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[319][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[319][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[319][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[319][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[319][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[319][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[319][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[319][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[319][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[319][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[319][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[319][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[319][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[319][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[319][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[319][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[319][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[319][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[319][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[319][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[319][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[319][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[319][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[319][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[319][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[319][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[319][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[319][CLOB2STR] = ActionEntry(SHIFT, 135);
}
void Cego::loadParser248()
{
   _actionMap[319][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[319][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[319][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[319][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[319][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[319][LB] = ActionEntry(SHIFT, 176);
   _actionMap[319][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[319][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[319][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[319][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[319][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[319][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[319][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[319][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[319][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[319][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[319][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[319][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[319][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[319][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[319][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[319][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[319][MAX] = ActionEntry(SHIFT, 154);
   _jumpMap[319][ObjSpec] = 121;
   _jumpMap[319][Constant] = 120;
   _jumpMap[319][SignedFloat] = 119;
   _jumpMap[319][SignedInt] = 118;
   _jumpMap[319][Attribute] = 117;
   _jumpMap[319][ExpressionList] = 488;
   _jumpMap[319][Function] = 116;
   _jumpMap[319][CasePrepare] = 115;
   _jumpMap[319][CaseClause] = 114;
   _jumpMap[319][Factor] = 113;
   _jumpMap[319][Term] = 112;
   _jumpMap[319][Expr] = 446;
   _actionMap[320][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[320][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[320][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[320][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[320][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[320][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[320][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[320][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[320][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[320][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[320][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[320][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[320][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[320][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[320][UPPER] = ActionEntry(SHIFT, 175);
}
void Cego::loadParser249()
{
   _actionMap[320][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[320][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[320][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[320][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[320][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[320][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[320][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[320][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[320][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[320][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[320][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[320][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[320][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[320][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[320][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[320][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[320][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[320][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[320][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[320][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[320][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[320][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[320][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[320][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[320][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[320][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[320][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[320][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[320][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[320][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[320][LB] = ActionEntry(SHIFT, 176);
   _actionMap[320][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[320][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[320][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[320][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[320][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[320][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[320][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[320][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[320][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[320][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[320][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[320][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[320][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[320][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[320][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[320][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[320][MAX] = ActionEntry(SHIFT, 154);
   _jumpMap[320][ObjSpec] = 121;
   _jumpMap[320][Constant] = 120;
}
void Cego::loadParser250()
{
   _jumpMap[320][SignedFloat] = 119;
   _jumpMap[320][SignedInt] = 118;
   _jumpMap[320][Attribute] = 117;
   _jumpMap[320][ExpressionList] = 489;
   _jumpMap[320][Function] = 116;
   _jumpMap[320][CasePrepare] = 115;
   _jumpMap[320][CaseClause] = 114;
   _jumpMap[320][Factor] = 113;
   _jumpMap[320][Term] = 112;
   _jumpMap[320][Expr] = 446;
   _actionMap[321][IDENTIFIER] = ActionEntry(SHIFT, 490);
   _actionMap[322][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[322][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[322][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[322][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[322][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[322][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[322][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[322][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[322][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[322][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[322][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[322][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[322][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[322][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[322][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[322][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[322][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[322][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[322][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[322][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[322][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[322][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[322][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[322][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[322][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[322][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[322][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[322][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[322][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[322][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[322][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[322][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[322][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[322][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[322][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[322][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[322][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[322][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[322][CLOBREF] = ActionEntry(SHIFT, 134);
}
void Cego::loadParser251()
{
   _actionMap[322][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[322][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[322][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[322][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[322][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[322][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[322][LB] = ActionEntry(SHIFT, 176);
   _actionMap[322][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[322][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[322][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[322][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[322][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[322][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[322][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[322][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[322][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[322][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[322][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[322][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[322][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[322][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[322][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[322][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[322][MAX] = ActionEntry(SHIFT, 154);
   _jumpMap[322][ObjSpec] = 121;
   _jumpMap[322][Constant] = 120;
   _jumpMap[322][SignedFloat] = 119;
   _jumpMap[322][SignedInt] = 118;
   _jumpMap[322][Attribute] = 117;
   _jumpMap[322][ExpressionList] = 491;
   _jumpMap[322][Function] = 116;
   _jumpMap[322][CasePrepare] = 115;
   _jumpMap[322][CaseClause] = 114;
   _jumpMap[322][Factor] = 113;
   _jumpMap[322][Term] = 112;
   _jumpMap[322][Expr] = 446;
   _actionMap[323][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[323][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[323][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[323][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[323][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[323][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[323][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[323][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[323][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[323][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[323][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[323][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[323][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[323][LOWER] = ActionEntry(SHIFT, 151);
}
void Cego::loadParser252()
{
   _actionMap[323][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[323][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[323][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[323][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[323][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[323][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[323][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[323][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[323][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[323][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[323][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[323][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[323][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[323][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[323][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[323][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[323][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[323][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[323][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[323][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[323][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[323][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[323][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[323][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[323][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[323][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[323][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[323][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[323][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[323][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[323][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[323][LB] = ActionEntry(SHIFT, 176);
   _actionMap[323][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[323][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[323][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[323][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[323][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[323][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[323][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[323][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[323][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[323][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[323][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[323][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[323][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[323][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[323][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[323][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[323][MAX] = ActionEntry(SHIFT, 154);
   _jumpMap[323][ObjSpec] = 121;
}
void Cego::loadParser253()
{
   _jumpMap[323][Constant] = 120;
   _jumpMap[323][SignedFloat] = 119;
   _jumpMap[323][SignedInt] = 118;
   _jumpMap[323][Attribute] = 117;
   _jumpMap[323][Function] = 116;
   _jumpMap[323][CasePrepare] = 115;
   _jumpMap[323][CaseClause] = 114;
   _jumpMap[323][Factor] = 113;
   _jumpMap[323][Term] = 112;
   _jumpMap[323][Expr] = 492;
   _actionMap[324][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[324][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[324][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[324][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[324][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[324][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[324][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[324][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[324][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[324][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[324][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[324][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[324][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[324][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[324][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[324][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[324][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[324][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[324][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[324][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[324][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[324][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[324][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[324][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[324][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[324][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[324][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[324][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[324][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[324][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[324][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[324][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[324][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[324][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[324][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[324][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[324][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[324][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[324][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[324][CLOB2STR] = ActionEntry(SHIFT, 135);
}
void Cego::loadParser254()
{
   _actionMap[324][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[324][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[324][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[324][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[324][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[324][LB] = ActionEntry(SHIFT, 176);
   _actionMap[324][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[324][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[324][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[324][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[324][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[324][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[324][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[324][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[324][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[324][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[324][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[324][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[324][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[324][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[324][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[324][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[324][MAX] = ActionEntry(SHIFT, 154);
   _jumpMap[324][ObjSpec] = 121;
   _jumpMap[324][Constant] = 120;
   _jumpMap[324][SignedFloat] = 119;
   _jumpMap[324][SignedInt] = 118;
   _jumpMap[324][Attribute] = 117;
   _jumpMap[324][ExpressionList] = 493;
   _jumpMap[324][Function] = 116;
   _jumpMap[324][CasePrepare] = 115;
   _jumpMap[324][CaseClause] = 114;
   _jumpMap[324][Factor] = 113;
   _jumpMap[324][Term] = 112;
   _jumpMap[324][Expr] = 446;
   _actionMap[325][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[325][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[325][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[325][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[325][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[325][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[325][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[325][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[325][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[325][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[325][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[325][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[325][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[325][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[325][UPPER] = ActionEntry(SHIFT, 175);
}
void Cego::loadParser255()
{
   _actionMap[325][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[325][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[325][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[325][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[325][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[325][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[325][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[325][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[325][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[325][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[325][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[325][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[325][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[325][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[325][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[325][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[325][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[325][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[325][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[325][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[325][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[325][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[325][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[325][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[325][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[325][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[325][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[325][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[325][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[325][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[325][LB] = ActionEntry(SHIFT, 176);
   _actionMap[325][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[325][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[325][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[325][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[325][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[325][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[325][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[325][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[325][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[325][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[325][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[325][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[325][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[325][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[325][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[325][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[325][MAX] = ActionEntry(SHIFT, 154);
   _jumpMap[325][ObjSpec] = 121;
   _jumpMap[325][Constant] = 120;
}
void Cego::loadParser256()
{
   _jumpMap[325][SignedFloat] = 119;
   _jumpMap[325][SignedInt] = 118;
   _jumpMap[325][Attribute] = 117;
   _jumpMap[325][ExpressionList] = 494;
   _jumpMap[325][Function] = 116;
   _jumpMap[325][CasePrepare] = 115;
   _jumpMap[325][CaseClause] = 114;
   _jumpMap[325][Factor] = 113;
   _jumpMap[325][Term] = 112;
   _jumpMap[325][Expr] = 446;
   _actionMap[326][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[326][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[326][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[326][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[326][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[326][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[326][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[326][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[326][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[326][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[326][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[326][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[326][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[326][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[326][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[326][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[326][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[326][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[326][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[326][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[326][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[326][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[326][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[326][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[326][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[326][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[326][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[326][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[326][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[326][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[326][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[326][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[326][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[326][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[326][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[326][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[326][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[326][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[326][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[326][CLOB2STR] = ActionEntry(SHIFT, 135);
}
void Cego::loadParser257()
{
   _actionMap[326][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[326][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[326][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[326][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[326][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[326][LB] = ActionEntry(SHIFT, 176);
   _actionMap[326][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[326][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[326][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[326][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[326][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[326][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[326][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[326][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[326][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[326][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[326][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[326][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[326][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[326][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[326][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[326][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[326][MAX] = ActionEntry(SHIFT, 154);
   _jumpMap[326][ObjSpec] = 121;
   _jumpMap[326][Constant] = 120;
   _jumpMap[326][SignedFloat] = 119;
   _jumpMap[326][SignedInt] = 118;
   _jumpMap[326][Attribute] = 117;
   _jumpMap[326][ExpressionList] = 495;
   _jumpMap[326][Function] = 116;
   _jumpMap[326][CasePrepare] = 115;
   _jumpMap[326][CaseClause] = 114;
   _jumpMap[326][Factor] = 113;
   _jumpMap[326][Term] = 112;
   _jumpMap[326][Expr] = 446;
   _actionMap[327][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[327][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[327][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[327][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[327][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[327][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[327][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[327][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[327][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[327][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[327][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[327][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[327][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[327][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[327][UPPER] = ActionEntry(SHIFT, 175);
}
void Cego::loadParser258()
{
   _actionMap[327][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[327][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[327][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[327][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[327][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[327][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[327][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[327][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[327][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[327][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[327][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[327][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[327][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[327][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[327][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[327][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[327][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[327][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[327][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[327][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[327][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[327][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[327][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[327][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[327][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[327][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[327][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[327][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[327][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[327][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[327][LB] = ActionEntry(SHIFT, 176);
   _actionMap[327][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[327][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[327][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[327][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[327][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[327][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[327][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[327][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[327][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[327][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[327][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[327][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[327][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[327][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[327][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[327][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[327][MAX] = ActionEntry(SHIFT, 154);
   _jumpMap[327][ObjSpec] = 121;
   _jumpMap[327][Constant] = 120;
}
void Cego::loadParser259()
{
   _jumpMap[327][SignedFloat] = 119;
   _jumpMap[327][SignedInt] = 118;
   _jumpMap[327][Attribute] = 117;
   _jumpMap[327][ExpressionList] = 496;
   _jumpMap[327][Function] = 116;
   _jumpMap[327][CasePrepare] = 115;
   _jumpMap[327][CaseClause] = 114;
   _jumpMap[327][Factor] = 113;
   _jumpMap[327][Term] = 112;
   _jumpMap[327][Expr] = 446;
   _actionMap[328][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[328][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[328][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[328][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[328][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[328][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[328][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[328][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[328][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[328][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[328][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[328][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[328][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[328][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[328][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[328][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[328][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[328][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[328][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[328][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[328][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[328][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[328][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[328][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[328][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[328][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[328][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[328][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[328][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[328][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[328][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[328][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[328][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[328][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[328][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[328][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[328][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[328][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[328][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[328][CLOB2STR] = ActionEntry(SHIFT, 135);
}
void Cego::loadParser260()
{
   _actionMap[328][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[328][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[328][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[328][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[328][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[328][LB] = ActionEntry(SHIFT, 176);
   _actionMap[328][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[328][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[328][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[328][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[328][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[328][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[328][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[328][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[328][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[328][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[328][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[328][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[328][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[328][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[328][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[328][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[328][MAX] = ActionEntry(SHIFT, 154);
   _jumpMap[328][ObjSpec] = 121;
   _jumpMap[328][Constant] = 120;
   _jumpMap[328][SignedFloat] = 119;
   _jumpMap[328][SignedInt] = 118;
   _jumpMap[328][Attribute] = 117;
   _jumpMap[328][ExpressionList] = 497;
   _jumpMap[328][Function] = 116;
   _jumpMap[328][CasePrepare] = 115;
   _jumpMap[328][CaseClause] = 114;
   _jumpMap[328][Factor] = 113;
   _jumpMap[328][Term] = 112;
   _jumpMap[328][Expr] = 446;
   _actionMap[329][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[329][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[329][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[329][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[329][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[329][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[329][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[329][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[329][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[329][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[329][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[329][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[329][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[329][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[329][UPPER] = ActionEntry(SHIFT, 175);
}
void Cego::loadParser261()
{
   _actionMap[329][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[329][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[329][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[329][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[329][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[329][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[329][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[329][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[329][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[329][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[329][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[329][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[329][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[329][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[329][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[329][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[329][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[329][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[329][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[329][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[329][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[329][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[329][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[329][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[329][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[329][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[329][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[329][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[329][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[329][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[329][LB] = ActionEntry(SHIFT, 176);
   _actionMap[329][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[329][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[329][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[329][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[329][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[329][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[329][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[329][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[329][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[329][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[329][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[329][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[329][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[329][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[329][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[329][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[329][MAX] = ActionEntry(SHIFT, 154);
   _jumpMap[329][ObjSpec] = 121;
   _jumpMap[329][Constant] = 120;
}
void Cego::loadParser262()
{
   _jumpMap[329][SignedFloat] = 119;
   _jumpMap[329][SignedInt] = 118;
   _jumpMap[329][Attribute] = 117;
   _jumpMap[329][ExpressionList] = 498;
   _jumpMap[329][Function] = 116;
   _jumpMap[329][CasePrepare] = 115;
   _jumpMap[329][CaseClause] = 114;
   _jumpMap[329][Factor] = 113;
   _jumpMap[329][Term] = 112;
   _jumpMap[329][Expr] = 446;
   _actionMap[330][RB] = ActionEntry(SHIFT, 499);
   _actionMap[330][PLUS] = ActionEntry(SHIFT, 275);
   _actionMap[330][MINUS] = ActionEntry(SHIFT, 274);
   _actionMap[330][CONCAT] = ActionEntry(SHIFT, 273);
   _actionMap[331][RB] = ActionEntry(SHIFT, 500);
   _actionMap[332][RB] = ActionEntry(SHIFT, 501);
   _actionMap[333][RB] = ActionEntry(SHIFT, 502);
   _actionMap[334][RB] = ActionEntry(SHIFT, 503);
   _actionMap[335][RB] = ActionEntry(SHIFT, 504);
   _actionMap[336][RB] = ActionEntry(SHIFT, 505);
   _actionMap[337][RB] = ActionEntry(SHIFT, 506);
   _actionMap[338][RB] = ActionEntry(SHIFT, 507);
   _actionMap[339][WHEN] = ActionEntry(REDUCE, 405);
   _actionMap[339][ELSE] = ActionEntry(REDUCE, 405);
   _actionMap[339][LEFT] = ActionEntry(REDUCE, 405);
   _actionMap[339][RIGHT] = ActionEntry(REDUCE, 405);
   _actionMap[339][INNER] = ActionEntry(REDUCE, 405);
   _actionMap[339][JOIN] = ActionEntry(REDUCE, 405);
   _actionMap[339][RETURNTOKEN] = ActionEntry(REDUCE, 405);
   _actionMap[339][ORDER] = ActionEntry(REDUCE, 405);
   _actionMap[339][GROUP] = ActionEntry(REDUCE, 405);
   _actionMap[339][WHERE] = ActionEntry(REDUCE, 405);
   _actionMap[339][AS] = ActionEntry(REDUCE, 405);
   _actionMap[339][FROM] = ActionEntry(REDUCE, 405);
   _actionMap[339][END_TOKEN] = ActionEntry(REDUCE, 405);
   _actionMap[339][BEGIN] = ActionEntry(REDUCE, 405);
   _actionMap[339][THEN] = ActionEntry(REDUCE, 405);
   _actionMap[339][OR] = ActionEntry(REDUCE, 405);
   _actionMap[339][AND] = ActionEntry(REDUCE, 405);
   _actionMap[339][NULLTOKEN] = ActionEntry(REDUCE, 405);
   _actionMap[339][LIKE] = ActionEntry(REDUCE, 405);
   _actionMap[339][IS] = ActionEntry(REDUCE, 405);
   _actionMap[339][BETWEEN] = ActionEntry(REDUCE, 405);
   _actionMap[339][NOT] = ActionEntry(REDUCE, 405);
   _actionMap[339][INTOK] = ActionEntry(REDUCE, 405);
   _actionMap[339][EQU] = ActionEntry(REDUCE, 405);
   _actionMap[339][NEGATION] = ActionEntry(REDUCE, 405);
   _actionMap[339][LT] = ActionEntry(REDUCE, 405);
   _actionMap[339][MT] = ActionEntry(REDUCE, 405);
   _actionMap[339][DESC] = ActionEntry(REDUCE, 405);
}
void Cego::loadParser263()
{
   _actionMap[339][ASC] = ActionEntry(REDUCE, 405);
   _actionMap[339][KSEP] = ActionEntry(REDUCE, 405);
   _actionMap[339][ROWLIMIT] = ActionEntry(REDUCE, 405);
   _actionMap[339][UNION] = ActionEntry(REDUCE, 405);
   _actionMap[339][ENDTOKEN] = ActionEntry(REDUCE, 405);
   _actionMap[339][RB] = ActionEntry(REDUCE, 405);
   _actionMap[339][SEMICOLON] = ActionEntry(REDUCE, 405);
   _actionMap[339][CONCAT] = ActionEntry(REDUCE, 405);
   _actionMap[339][STAR] = ActionEntry(REDUCE, 405);
   _actionMap[339][DIVISION] = ActionEntry(REDUCE, 405);
   _actionMap[339][MINUS] = ActionEntry(REDUCE, 405);
   _actionMap[339][PLUS] = ActionEntry(REDUCE, 405);
   _actionMap[340][WHEN] = ActionEntry(REDUCE, 407);
   _actionMap[340][ELSE] = ActionEntry(REDUCE, 407);
   _actionMap[340][LEFT] = ActionEntry(REDUCE, 407);
   _actionMap[340][RIGHT] = ActionEntry(REDUCE, 407);
   _actionMap[340][INNER] = ActionEntry(REDUCE, 407);
   _actionMap[340][JOIN] = ActionEntry(REDUCE, 407);
   _actionMap[340][RETURNTOKEN] = ActionEntry(REDUCE, 407);
   _actionMap[340][ORDER] = ActionEntry(REDUCE, 407);
   _actionMap[340][GROUP] = ActionEntry(REDUCE, 407);
   _actionMap[340][WHERE] = ActionEntry(REDUCE, 407);
   _actionMap[340][AS] = ActionEntry(REDUCE, 407);
   _actionMap[340][FROM] = ActionEntry(REDUCE, 407);
   _actionMap[340][END_TOKEN] = ActionEntry(REDUCE, 407);
   _actionMap[340][BEGIN] = ActionEntry(REDUCE, 407);
   _actionMap[340][THEN] = ActionEntry(REDUCE, 407);
   _actionMap[340][OR] = ActionEntry(REDUCE, 407);
   _actionMap[340][AND] = ActionEntry(REDUCE, 407);
   _actionMap[340][NULLTOKEN] = ActionEntry(REDUCE, 407);
   _actionMap[340][LIKE] = ActionEntry(REDUCE, 407);
   _actionMap[340][IS] = ActionEntry(REDUCE, 407);
   _actionMap[340][BETWEEN] = ActionEntry(REDUCE, 407);
   _actionMap[340][NOT] = ActionEntry(REDUCE, 407);
   _actionMap[340][INTOK] = ActionEntry(REDUCE, 407);
   _actionMap[340][EQU] = ActionEntry(REDUCE, 407);
   _actionMap[340][NEGATION] = ActionEntry(REDUCE, 407);
   _actionMap[340][LT] = ActionEntry(REDUCE, 407);
   _actionMap[340][MT] = ActionEntry(REDUCE, 407);
   _actionMap[340][DESC] = ActionEntry(REDUCE, 407);
   _actionMap[340][ASC] = ActionEntry(REDUCE, 407);
   _actionMap[340][KSEP] = ActionEntry(REDUCE, 407);
   _actionMap[340][ROWLIMIT] = ActionEntry(REDUCE, 407);
   _actionMap[340][UNION] = ActionEntry(REDUCE, 407);
   _actionMap[340][ENDTOKEN] = ActionEntry(REDUCE, 407);
   _actionMap[340][RB] = ActionEntry(REDUCE, 407);
   _actionMap[340][SEMICOLON] = ActionEntry(REDUCE, 407);
   _actionMap[340][CONCAT] = ActionEntry(REDUCE, 407);
   _actionMap[340][STAR] = ActionEntry(REDUCE, 407);
   _actionMap[340][DIVISION] = ActionEntry(REDUCE, 407);
}
void Cego::loadParser264()
{
   _actionMap[340][MINUS] = ActionEntry(REDUCE, 407);
   _actionMap[340][PLUS] = ActionEntry(REDUCE, 407);
   _actionMap[341][WHEN] = ActionEntry(REDUCE, 403);
   _actionMap[341][ELSE] = ActionEntry(REDUCE, 403);
   _actionMap[341][LEFT] = ActionEntry(REDUCE, 403);
   _actionMap[341][RIGHT] = ActionEntry(REDUCE, 403);
   _actionMap[341][INNER] = ActionEntry(REDUCE, 403);
   _actionMap[341][JOIN] = ActionEntry(REDUCE, 403);
   _actionMap[341][RETURNTOKEN] = ActionEntry(REDUCE, 403);
   _actionMap[341][GROUP] = ActionEntry(REDUCE, 403);
   _actionMap[341][WHERE] = ActionEntry(REDUCE, 403);
   _actionMap[341][FROM] = ActionEntry(REDUCE, 403);
   _actionMap[341][AS] = ActionEntry(REDUCE, 403);
   _actionMap[341][END_TOKEN] = ActionEntry(REDUCE, 403);
   _actionMap[341][BEGIN] = ActionEntry(REDUCE, 403);
   _actionMap[341][THEN] = ActionEntry(REDUCE, 403);
   _actionMap[341][OR] = ActionEntry(REDUCE, 403);
   _actionMap[341][AND] = ActionEntry(REDUCE, 403);
   _actionMap[341][INTOK] = ActionEntry(REDUCE, 403);
   _actionMap[341][NOT] = ActionEntry(REDUCE, 403);
   _actionMap[341][BETWEEN] = ActionEntry(REDUCE, 403);
   _actionMap[341][IS] = ActionEntry(REDUCE, 403);
   _actionMap[341][LIKE] = ActionEntry(REDUCE, 403);
   _actionMap[341][HAVING] = ActionEntry(REDUCE, 403);
   _actionMap[341][ORDER] = ActionEntry(REDUCE, 403);
   _actionMap[341][MT] = ActionEntry(REDUCE, 403);
   _actionMap[341][LT] = ActionEntry(REDUCE, 403);
   _actionMap[341][NEGATION] = ActionEntry(REDUCE, 403);
   _actionMap[341][EQU] = ActionEntry(REDUCE, 403);
   _actionMap[341][RB] = ActionEntry(REDUCE, 403);
   _actionMap[341][ENDTOKEN] = ActionEntry(REDUCE, 403);
   _actionMap[341][UNION] = ActionEntry(REDUCE, 403);
   _actionMap[341][ROWLIMIT] = ActionEntry(REDUCE, 403);
   _actionMap[341][KSEP] = ActionEntry(REDUCE, 403);
   _actionMap[341][ASC] = ActionEntry(REDUCE, 403);
   _actionMap[341][DESC] = ActionEntry(REDUCE, 403);
   _actionMap[341][SEMICOLON] = ActionEntry(REDUCE, 403);
   _actionMap[341][PLUS] = ActionEntry(REDUCE, 403);
   _actionMap[341][MINUS] = ActionEntry(REDUCE, 403);
   _actionMap[341][DIVISION] = ActionEntry(REDUCE, 403);
   _actionMap[341][STAR] = ActionEntry(REDUCE, 403);
   _actionMap[341][CONCAT] = ActionEntry(REDUCE, 403);
   _actionMap[342][TO] = ActionEntry(SHIFT, 508);
   _actionMap[343][TO] = ActionEntry(SHIFT, 509);
   _actionMap[344][TO] = ActionEntry(SHIFT, 510);
   _actionMap[345][TO] = ActionEntry(SHIFT, 511);
   _actionMap[346][TO] = ActionEntry(SHIFT, 512);
   _actionMap[347][TO] = ActionEntry(SHIFT, 513);
   _actionMap[348][TO] = ActionEntry(SHIFT, 514);
   _actionMap[349][TO] = ActionEntry(SHIFT, 515);
}
void Cego::loadParser265()
{
   _actionMap[350][SEMICOLON] = ActionEntry(REDUCE, 48);
   _actionMap[351][SEMICOLON] = ActionEntry(REDUCE, 47);
   _actionMap[352][SEMICOLON] = ActionEntry(REDUCE, 236);
   _actionMap[352][RB] = ActionEntry(REDUCE, 236);
   _actionMap[353][SEMICOLON] = ActionEntry(REDUCE, 238);
   _actionMap[353][RB] = ActionEntry(REDUCE, 238);
   _actionMap[354][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[354][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[354][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[354][ObjSpec] = 520;
   _jumpMap[354][Table] = 519;
   _jumpMap[354][TableList] = 518;
   _jumpMap[354][JoinSpecList] = 517;
   _jumpMap[354][TableSource] = 516;
   _actionMap[355][PLUS] = ActionEntry(SHIFT, 275);
   _actionMap[355][MINUS] = ActionEntry(SHIFT, 274);
   _actionMap[355][CONCAT] = ActionEntry(SHIFT, 273);
   _actionMap[355][FROM] = ActionEntry(REDUCE, 264);
   _actionMap[355][AS] = ActionEntry(SHIFT, 523);
   _actionMap[355][RB] = ActionEntry(REDUCE, 264);
   _actionMap[355][SEMICOLON] = ActionEntry(REDUCE, 264);
   _actionMap[355][ENDTOKEN] = ActionEntry(REDUCE, 264);
   _actionMap[355][KSEP] = ActionEntry(REDUCE, 264);
   _jumpMap[355][NoAliasOpt] = 522;
   _jumpMap[355][AliasOpt] = 521;
   _actionMap[356][KSEP] = ActionEntry(SHIFT, 524);
   _actionMap[356][FROM] = ActionEntry(REDUCE, 240);
   _actionMap[356][RB] = ActionEntry(REDUCE, 240);
   _actionMap[356][SEMICOLON] = ActionEntry(REDUCE, 240);
   _actionMap[356][ENDTOKEN] = ActionEntry(REDUCE, 240);
   _actionMap[357][FROM] = ActionEntry(REDUCE, 243);
   _actionMap[357][RB] = ActionEntry(REDUCE, 243);
   _actionMap[357][SEMICOLON] = ActionEntry(REDUCE, 243);
   _actionMap[357][ENDTOKEN] = ActionEntry(REDUCE, 243);
   _actionMap[357][KSEP] = ActionEntry(REDUCE, 243);
   _actionMap[358][SEMICOLON] = ActionEntry(REDUCE, 43);
   _actionMap[359][SEMICOLON] = ActionEntry(REDUCE, 42);
   _actionMap[360][SEMICOLON] = ActionEntry(REDUCE, 45);
   _actionMap[361][SEMICOLON] = ActionEntry(REDUCE, 44);
   _actionMap[362][TO] = ActionEntry(SHIFT, 525);
   _actionMap[363][SEMICOLON] = ActionEntry(REDUCE, 46);
   _actionMap[364][SEMICOLON] = ActionEntry(REDUCE, 35);
   _actionMap[365][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[365][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[365][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[365][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[365][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[365][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[365][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[365][LTRIM] = ActionEntry(SHIFT, 152);
}
void Cego::loadParser266()
{
   _actionMap[365][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[365][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[365][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[365][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[365][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[365][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[365][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[365][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[365][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[365][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[365][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[365][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[365][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[365][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[365][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[365][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[365][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[365][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[365][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[365][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[365][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[365][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[365][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[365][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[365][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[365][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[365][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[365][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[365][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[365][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[365][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[365][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[365][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[365][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[365][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[365][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[365][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[365][LB] = ActionEntry(SHIFT, 176);
   _actionMap[365][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[365][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[365][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[365][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[365][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[365][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[365][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[365][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[365][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[365][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[365][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[365][FETCH] = ActionEntry(SHIFT, 142);
}
void Cego::loadParser267()
{
   _actionMap[365][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[365][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[365][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[365][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[365][MAX] = ActionEntry(SHIFT, 154);
   _jumpMap[365][ObjSpec] = 121;
   _jumpMap[365][Constant] = 120;
   _jumpMap[365][SignedFloat] = 119;
   _jumpMap[365][SignedInt] = 118;
   _jumpMap[365][Attribute] = 117;
   _jumpMap[365][Function] = 116;
   _jumpMap[365][CasePrepare] = 115;
   _jumpMap[365][CaseClause] = 114;
   _jumpMap[365][Factor] = 113;
   _jumpMap[365][Term] = 112;
   _jumpMap[365][Expr] = 526;
   _actionMap[366][SEMICOLON] = ActionEntry(REDUCE, 33);
   _actionMap[367][SEMICOLON] = ActionEntry(REDUCE, 31);
   _actionMap[368][SEMICOLON] = ActionEntry(REDUCE, 34);
   _actionMap[369][SEMICOLON] = ActionEntry(REDUCE, 32);
   _actionMap[370][SEMICOLON] = ActionEntry(REDUCE, 73);
   _actionMap[371][SET] = ActionEntry(SHIFT, 372);
   _actionMap[372][IDENTIFIER] = ActionEntry(SHIFT, 529);
   _jumpMap[372][Assignment] = 528;
   _jumpMap[372][UpdateList] = 527;
   _actionMap[373][SET] = ActionEntry(REDUCE, 299);
   _actionMap[373][WHERE] = ActionEntry(REDUCE, 299);
   _actionMap[373][GROUP] = ActionEntry(REDUCE, 299);
   _actionMap[373][ORDER] = ActionEntry(REDUCE, 299);
   _actionMap[373][ROWLIMIT] = ActionEntry(REDUCE, 299);
   _actionMap[373][UNION] = ActionEntry(REDUCE, 299);
   _actionMap[373][ENDTOKEN] = ActionEntry(REDUCE, 299);
   _actionMap[373][RB] = ActionEntry(REDUCE, 299);
   _actionMap[373][SEMICOLON] = ActionEntry(REDUCE, 299);
   _actionMap[373][RETURNTOKEN] = ActionEntry(REDUCE, 299);
   _actionMap[374][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[374][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[374][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[374][ObjSpec] = 530;
   _actionMap[46][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[46][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[46][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[46][ObjSpec] = 218;
   _actionMap[47][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[47][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[47][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[47][ObjSpec] = 219;
   _actionMap[48][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[48][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[48][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
}
void Cego::loadParser268()
{
   _jumpMap[48][ObjSpec] = 220;
   _actionMap[49][FOR] = ActionEntry(REDUCE, 217);
   _actionMap[49][SEMICOLON] = ActionEntry(REDUCE, 217);
   _actionMap[49][QUALIFIEDOBJ] = ActionEntry(REDUCE, 217);
   _actionMap[49][QUALIFIEDTS] = ActionEntry(REDUCE, 217);
   _actionMap[49][ON] = ActionEntry(REDUCE, 217);
   _actionMap[49][IDENTIFIER] = ActionEntry(REDUCE, 217);
   _actionMap[50][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[50][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[50][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[50][ObjSpec] = 221;
   _actionMap[51][IDENTIFIER] = ActionEntry(SHIFT, 223);
   _jumpMap[51][CounterId] = 222;
   _actionMap[52][KEY] = ActionEntry(SHIFT, 224);
   _actionMap[53][FOR] = ActionEntry(REDUCE, 218);
   _actionMap[53][SEMICOLON] = ActionEntry(REDUCE, 218);
   _actionMap[53][QUALIFIEDOBJ] = ActionEntry(REDUCE, 218);
   _actionMap[53][QUALIFIEDTS] = ActionEntry(REDUCE, 218);
   _actionMap[53][ON] = ActionEntry(REDUCE, 218);
   _actionMap[53][IDENTIFIER] = ActionEntry(REDUCE, 218);
   _actionMap[54][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[54][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[54][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[54][ObjSpec] = 225;
   _actionMap[55][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[55][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[55][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[55][ObjSpec] = 226;
   _actionMap[56][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[56][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[56][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[56][ObjSpec] = 227;
   _actionMap[57][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[57][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[57][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[57][ObjSpec] = 228;
   _actionMap[58][ENDTOKEN] = ActionEntry(ACCEPT, 0);
   _actionMap[59][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[59][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[59][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[59][ObjSpec] = 229;
   _actionMap[60][IDENTIFIED] = ActionEntry(SHIFT, 230);
   _actionMap[61][LB] = ActionEntry(SHIFT, 231);
   _actionMap[62][BEGIN] = ActionEntry(REDUCE, 427);
   _actionMap[62][TO] = ActionEntry(REDUCE, 427);
   _actionMap[62][VALUES] = ActionEntry(REDUCE, 427);
   _actionMap[62][SELECT] = ActionEntry(REDUCE, 427);
   _actionMap[62][SET] = ActionEntry(REDUCE, 427);
   _actionMap[62][AS] = ActionEntry(REDUCE, 427);
   _actionMap[62][BEFORE] = ActionEntry(REDUCE, 427);
}
void Cego::loadParser269()
{
   _actionMap[62][AFTER] = ActionEntry(REDUCE, 427);
   _actionMap[62][DROP] = ActionEntry(REDUCE, 427);
   _actionMap[62][MODIFY] = ActionEntry(REDUCE, 427);
   _actionMap[62][RENAME] = ActionEntry(REDUCE, 427);
   _actionMap[62][ADD] = ActionEntry(REDUCE, 427);
   _actionMap[62][KSEP] = ActionEntry(REDUCE, 427);
   _actionMap[62][LEFT] = ActionEntry(REDUCE, 427);
   _actionMap[62][RIGHT] = ActionEntry(REDUCE, 427);
   _actionMap[62][INNER] = ActionEntry(REDUCE, 427);
   _actionMap[62][JOIN] = ActionEntry(REDUCE, 427);
   _actionMap[62][RETURNTOKEN] = ActionEntry(REDUCE, 427);
   _actionMap[62][SEMICOLON] = ActionEntry(REDUCE, 427);
   _actionMap[62][RB] = ActionEntry(REDUCE, 427);
   _actionMap[62][ENDTOKEN] = ActionEntry(REDUCE, 427);
   _actionMap[62][UNION] = ActionEntry(REDUCE, 427);
   _actionMap[62][ROWLIMIT] = ActionEntry(REDUCE, 427);
   _actionMap[62][ORDER] = ActionEntry(REDUCE, 427);
   _actionMap[62][GROUP] = ActionEntry(REDUCE, 427);
   _actionMap[62][WHERE] = ActionEntry(REDUCE, 427);
   _actionMap[62][LB] = ActionEntry(REDUCE, 427);
   _actionMap[62][ON] = ActionEntry(REDUCE, 427);
   _actionMap[62][IDENTIFIER] = ActionEntry(REDUCE, 427);
   _actionMap[63][BEGIN] = ActionEntry(REDUCE, 428);
   _actionMap[63][TO] = ActionEntry(REDUCE, 428);
   _actionMap[63][VALUES] = ActionEntry(REDUCE, 428);
   _actionMap[63][SELECT] = ActionEntry(REDUCE, 428);
   _actionMap[63][SET] = ActionEntry(REDUCE, 428);
   _actionMap[63][AS] = ActionEntry(REDUCE, 428);
   _actionMap[63][BEFORE] = ActionEntry(REDUCE, 428);
   _actionMap[63][AFTER] = ActionEntry(REDUCE, 428);
   _actionMap[63][DROP] = ActionEntry(REDUCE, 428);
   _actionMap[63][MODIFY] = ActionEntry(REDUCE, 428);
   _actionMap[63][RENAME] = ActionEntry(REDUCE, 428);
   _actionMap[63][ADD] = ActionEntry(REDUCE, 428);
   _actionMap[63][KSEP] = ActionEntry(REDUCE, 428);
   _actionMap[63][LEFT] = ActionEntry(REDUCE, 428);
   _actionMap[63][RIGHT] = ActionEntry(REDUCE, 428);
   _actionMap[63][INNER] = ActionEntry(REDUCE, 428);
   _actionMap[63][JOIN] = ActionEntry(REDUCE, 428);
   _actionMap[63][RETURNTOKEN] = ActionEntry(REDUCE, 428);
   _actionMap[63][SEMICOLON] = ActionEntry(REDUCE, 428);
   _actionMap[63][RB] = ActionEntry(REDUCE, 428);
   _actionMap[63][ENDTOKEN] = ActionEntry(REDUCE, 428);
   _actionMap[63][UNION] = ActionEntry(REDUCE, 428);
   _actionMap[63][ROWLIMIT] = ActionEntry(REDUCE, 428);
   _actionMap[63][ORDER] = ActionEntry(REDUCE, 428);
   _actionMap[63][GROUP] = ActionEntry(REDUCE, 428);
   _actionMap[63][WHERE] = ActionEntry(REDUCE, 428);
   _actionMap[63][LB] = ActionEntry(REDUCE, 428);
   _actionMap[63][ON] = ActionEntry(REDUCE, 428);
}
void Cego::loadParser270()
{
   _actionMap[63][IDENTIFIER] = ActionEntry(REDUCE, 428);
   _actionMap[64][BEGIN] = ActionEntry(REDUCE, 429);
   _actionMap[64][TO] = ActionEntry(REDUCE, 429);
   _actionMap[64][VALUES] = ActionEntry(REDUCE, 429);
   _actionMap[64][SELECT] = ActionEntry(REDUCE, 429);
   _actionMap[64][SET] = ActionEntry(REDUCE, 429);
   _actionMap[64][AS] = ActionEntry(REDUCE, 429);
   _actionMap[64][BEFORE] = ActionEntry(REDUCE, 429);
   _actionMap[64][AFTER] = ActionEntry(REDUCE, 429);
   _actionMap[64][DROP] = ActionEntry(REDUCE, 429);
   _actionMap[64][MODIFY] = ActionEntry(REDUCE, 429);
   _actionMap[64][RENAME] = ActionEntry(REDUCE, 429);
   _actionMap[64][ADD] = ActionEntry(REDUCE, 429);
   _actionMap[64][KSEP] = ActionEntry(REDUCE, 429);
   _actionMap[64][LEFT] = ActionEntry(REDUCE, 429);
   _actionMap[64][RIGHT] = ActionEntry(REDUCE, 429);
   _actionMap[64][INNER] = ActionEntry(REDUCE, 429);
   _actionMap[64][JOIN] = ActionEntry(REDUCE, 429);
   _actionMap[64][RETURNTOKEN] = ActionEntry(REDUCE, 429);
   _actionMap[64][SEMICOLON] = ActionEntry(REDUCE, 429);
   _actionMap[64][RB] = ActionEntry(REDUCE, 429);
   _actionMap[64][ENDTOKEN] = ActionEntry(REDUCE, 429);
   _actionMap[64][UNION] = ActionEntry(REDUCE, 429);
   _actionMap[64][ROWLIMIT] = ActionEntry(REDUCE, 429);
   _actionMap[64][ORDER] = ActionEntry(REDUCE, 429);
   _actionMap[64][GROUP] = ActionEntry(REDUCE, 429);
   _actionMap[64][WHERE] = ActionEntry(REDUCE, 429);
   _actionMap[64][ON] = ActionEntry(REDUCE, 429);
   _actionMap[64][IDENTIFIER] = ActionEntry(REDUCE, 429);
   _actionMap[64][LB] = ActionEntry(REDUCE, 429);
   _actionMap[65][IDENTIFIER] = ActionEntry(SHIFT, 232);
   _actionMap[66][SEMICOLON] = ActionEntry(REDUCE, 71);
   _actionMap[67][BEGIN] = ActionEntry(SHIFT, 233);
   _actionMap[68][BEGIN] = ActionEntry(SHIFT, 234);
   _actionMap[69][SEMICOLON] = ActionEntry(REDUCE, 58);
   _actionMap[70][BTREE] = ActionEntry(SHIFT, 49);
   _actionMap[70][INDEX] = ActionEntry(SHIFT, 53);
   _actionMap[70][AVLTREE] = ActionEntry(SHIFT, 237);
   _jumpMap[70][BtreeType] = 236;
   _jumpMap[70][IndexType] = 235;
   _actionMap[71][IDENTIFIER] = ActionEntry(SHIFT, 238);
   _actionMap[72][IDENTIFIER] = ActionEntry(SHIFT, 223);
   _jumpMap[72][CounterId] = 239;
   _actionMap[73][BTREE] = ActionEntry(SHIFT, 49);
   _actionMap[73][INDEX] = ActionEntry(SHIFT, 53);
   _actionMap[73][AVLTREE] = ActionEntry(SHIFT, 237);
   _jumpMap[73][BtreeType] = 236;
   _jumpMap[73][IndexType] = 240;
   _actionMap[74][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[74][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
}
void Cego::loadParser271()
{
   _actionMap[74][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[74][ObjSpec] = 241;
   _actionMap[75][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[75][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[75][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[75][ObjSpec] = 242;
   _actionMap[76][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[76][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[76][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[76][ObjSpec] = 243;
   _actionMap[77][AVLTREE] = ActionEntry(REDUCE, 213);
   _actionMap[77][BTREE] = ActionEntry(REDUCE, 213);
   _actionMap[77][INDEX] = ActionEntry(REDUCE, 213);
   _actionMap[78][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[78][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[78][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[78][ObjSpec] = 244;
   _actionMap[79][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[79][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[79][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[79][ObjSpec] = 245;
   _actionMap[80][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[80][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[80][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[80][ObjSpec] = 246;
   _actionMap[81][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[81][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[81][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[81][ObjSpec] = 247;
   _actionMap[82][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[82][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[82][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[82][ObjSpec] = 248;
   _actionMap[83][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[83][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[83][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[83][ObjSpec] = 249;
   _actionMap[84][KEY] = ActionEntry(SHIFT, 250);
   _actionMap[85][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[85][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[85][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[85][ObjSpec] = 251;
   _actionMap[86][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[86][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[86][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[86][ObjSpec] = 252;
   _actionMap[87][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[87][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[87][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[87][ObjSpec] = 253;
}
void Cego::loadParser272()
{
   _actionMap[88][EXISTS] = ActionEntry(SHIFT, 254);
   _actionMap[89][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[89][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[89][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[89][ObjSpec] = 255;
   _actionMap[90][IDENTIFIER] = ActionEntry(SHIFT, 256);
   _actionMap[90][SEMICOLON] = ActionEntry(REDUCE, 94);
   _actionMap[91][IDENTIFIER] = ActionEntry(REDUCE, 96);
   _actionMap[91][SEMICOLON] = ActionEntry(REDUCE, 96);
   _actionMap[92][FOR] = ActionEntry(SHIFT, 258);
   _actionMap[92][SEMICOLON] = ActionEntry(REDUCE, 16);
   _jumpMap[92][TableSetOpt] = 257;
   _actionMap[93][FOR] = ActionEntry(SHIFT, 258);
   _actionMap[93][SEMICOLON] = ActionEntry(REDUCE, 16);
   _jumpMap[93][TableSetOpt] = 259;
   _actionMap[94][FOR] = ActionEntry(SHIFT, 258);
   _actionMap[94][SEMICOLON] = ActionEntry(REDUCE, 16);
   _jumpMap[94][TableSetOpt] = 260;
   _actionMap[95][FOR] = ActionEntry(SHIFT, 258);
   _actionMap[95][SEMICOLON] = ActionEntry(REDUCE, 16);
   _jumpMap[95][TableSetOpt] = 261;
   _actionMap[96][FOR] = ActionEntry(SHIFT, 258);
   _actionMap[96][SEMICOLON] = ActionEntry(REDUCE, 16);
   _jumpMap[96][TableSetOpt] = 262;
   _actionMap[97][FOR] = ActionEntry(SHIFT, 258);
   _actionMap[97][SEMICOLON] = ActionEntry(REDUCE, 16);
   _jumpMap[97][TableSetOpt] = 263;
   _actionMap[98][FOR] = ActionEntry(SHIFT, 258);
   _actionMap[98][SEMICOLON] = ActionEntry(REDUCE, 16);
   _jumpMap[98][TableSetOpt] = 264;
   _actionMap[99][FOR] = ActionEntry(SHIFT, 258);
   _actionMap[99][SEMICOLON] = ActionEntry(REDUCE, 16);
   _jumpMap[99][TableSetOpt] = 265;
   _actionMap[100][FOR] = ActionEntry(SHIFT, 258);
   _actionMap[100][SEMICOLON] = ActionEntry(REDUCE, 16);
   _jumpMap[100][TableSetOpt] = 266;
   _actionMap[101][SEMICOLON] = ActionEntry(REDUCE, 2);
   _actionMap[102][FOR] = ActionEntry(SHIFT, 258);
   _actionMap[102][SEMICOLON] = ActionEntry(REDUCE, 16);
   _jumpMap[102][TableSetOpt] = 267;
   _actionMap[103][FOR] = ActionEntry(SHIFT, 258);
   _actionMap[103][SEMICOLON] = ActionEntry(REDUCE, 16);
   _jumpMap[103][TableSetOpt] = 268;
   _actionMap[104][FOR] = ActionEntry(SHIFT, 258);
   _actionMap[104][SEMICOLON] = ActionEntry(REDUCE, 16);
   _jumpMap[104][TableSetOpt] = 269;
   _actionMap[105][SEMICOLON] = ActionEntry(REDUCE, 72);
   _actionMap[106][SEMICOLON] = ActionEntry(REDUCE, 59);
   _actionMap[107][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[107][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
}
void Cego::loadParser273()
{
   _actionMap[107][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[107][ObjSpec] = 270;
   _actionMap[108][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[108][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[108][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[108][ObjSpec] = 271;
   _actionMap[109][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[109][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[109][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[109][ObjSpec] = 272;
   _actionMap[110][SEMICOLON] = ActionEntry(REDUCE, 50);
   _actionMap[111][PLUS] = ActionEntry(SHIFT, 275);
   _actionMap[111][MINUS] = ActionEntry(SHIFT, 274);
   _actionMap[111][CONCAT] = ActionEntry(SHIFT, 273);
   _actionMap[111][SEMICOLON] = ActionEntry(REDUCE, 88);
   _actionMap[112][STAR] = ActionEntry(SHIFT, 276);
   _actionMap[112][DIVISION] = ActionEntry(SHIFT, 277);
   _actionMap[112][WHEN] = ActionEntry(REDUCE, 172);
   _actionMap[112][ELSE] = ActionEntry(REDUCE, 172);
   _actionMap[112][LEFT] = ActionEntry(REDUCE, 172);
   _actionMap[112][RIGHT] = ActionEntry(REDUCE, 172);
   _actionMap[112][INNER] = ActionEntry(REDUCE, 172);
   _actionMap[112][JOIN] = ActionEntry(REDUCE, 172);
   _actionMap[112][RETURNTOKEN] = ActionEntry(REDUCE, 172);
   _actionMap[112][ORDER] = ActionEntry(REDUCE, 172);
   _actionMap[112][GROUP] = ActionEntry(REDUCE, 172);
   _actionMap[112][WHERE] = ActionEntry(REDUCE, 172);
   _actionMap[112][BEGIN] = ActionEntry(REDUCE, 172);
   _actionMap[112][THEN] = ActionEntry(REDUCE, 172);
   _actionMap[112][OR] = ActionEntry(REDUCE, 172);
   _actionMap[112][AS] = ActionEntry(REDUCE, 172);
   _actionMap[112][FROM] = ActionEntry(REDUCE, 172);
   _actionMap[112][END_TOKEN] = ActionEntry(REDUCE, 172);
   _actionMap[112][AND] = ActionEntry(REDUCE, 172);
   _actionMap[112][LIKE] = ActionEntry(REDUCE, 172);
   _actionMap[112][IS] = ActionEntry(REDUCE, 172);
   _actionMap[112][BETWEEN] = ActionEntry(REDUCE, 172);
   _actionMap[112][NOT] = ActionEntry(REDUCE, 172);
   _actionMap[112][INTOK] = ActionEntry(REDUCE, 172);
   _actionMap[112][EQU] = ActionEntry(REDUCE, 172);
   _actionMap[112][NEGATION] = ActionEntry(REDUCE, 172);
   _actionMap[112][LT] = ActionEntry(REDUCE, 172);
   _actionMap[112][MT] = ActionEntry(REDUCE, 172);
   _actionMap[112][DESC] = ActionEntry(REDUCE, 172);
   _actionMap[112][ASC] = ActionEntry(REDUCE, 172);
   _actionMap[112][KSEP] = ActionEntry(REDUCE, 172);
   _actionMap[112][ROWLIMIT] = ActionEntry(REDUCE, 172);
   _actionMap[112][UNION] = ActionEntry(REDUCE, 172);
   _actionMap[112][ENDTOKEN] = ActionEntry(REDUCE, 172);
   _actionMap[112][RB] = ActionEntry(REDUCE, 172);
}
void Cego::loadParser274()
{
   _actionMap[112][SEMICOLON] = ActionEntry(REDUCE, 172);
   _actionMap[112][CONCAT] = ActionEntry(REDUCE, 172);
   _actionMap[112][MINUS] = ActionEntry(REDUCE, 172);
   _actionMap[112][PLUS] = ActionEntry(REDUCE, 172);
   _actionMap[113][WHEN] = ActionEntry(REDUCE, 176);
   _actionMap[113][ELSE] = ActionEntry(REDUCE, 176);
   _actionMap[113][LEFT] = ActionEntry(REDUCE, 176);
   _actionMap[113][RIGHT] = ActionEntry(REDUCE, 176);
   _actionMap[113][INNER] = ActionEntry(REDUCE, 176);
   _actionMap[113][JOIN] = ActionEntry(REDUCE, 176);
   _actionMap[113][RETURNTOKEN] = ActionEntry(REDUCE, 176);
   _actionMap[113][ORDER] = ActionEntry(REDUCE, 176);
   _actionMap[113][GROUP] = ActionEntry(REDUCE, 176);
   _actionMap[113][WHERE] = ActionEntry(REDUCE, 176);
   _actionMap[113][BEGIN] = ActionEntry(REDUCE, 176);
   _actionMap[113][THEN] = ActionEntry(REDUCE, 176);
   _actionMap[113][OR] = ActionEntry(REDUCE, 176);
   _actionMap[113][FROM] = ActionEntry(REDUCE, 176);
   _actionMap[113][AS] = ActionEntry(REDUCE, 176);
   _actionMap[113][END_TOKEN] = ActionEntry(REDUCE, 176);
   _actionMap[113][AND] = ActionEntry(REDUCE, 176);
   _actionMap[113][INTOK] = ActionEntry(REDUCE, 176);
   _actionMap[113][NOT] = ActionEntry(REDUCE, 176);
   _actionMap[113][BETWEEN] = ActionEntry(REDUCE, 176);
   _actionMap[113][IS] = ActionEntry(REDUCE, 176);
   _actionMap[113][LIKE] = ActionEntry(REDUCE, 176);
   _actionMap[113][MT] = ActionEntry(REDUCE, 176);
   _actionMap[113][LT] = ActionEntry(REDUCE, 176);
   _actionMap[113][NEGATION] = ActionEntry(REDUCE, 176);
   _actionMap[113][EQU] = ActionEntry(REDUCE, 176);
   _actionMap[113][RB] = ActionEntry(REDUCE, 176);
   _actionMap[113][ENDTOKEN] = ActionEntry(REDUCE, 176);
   _actionMap[113][UNION] = ActionEntry(REDUCE, 176);
   _actionMap[113][ROWLIMIT] = ActionEntry(REDUCE, 176);
   _actionMap[113][KSEP] = ActionEntry(REDUCE, 176);
   _actionMap[113][ASC] = ActionEntry(REDUCE, 176);
   _actionMap[113][DESC] = ActionEntry(REDUCE, 176);
   _actionMap[113][SEMICOLON] = ActionEntry(REDUCE, 176);
   _actionMap[113][PLUS] = ActionEntry(REDUCE, 176);
   _actionMap[113][MINUS] = ActionEntry(REDUCE, 176);
   _actionMap[113][DIVISION] = ActionEntry(REDUCE, 176);
   _actionMap[113][STAR] = ActionEntry(REDUCE, 176);
   _actionMap[113][CONCAT] = ActionEntry(REDUCE, 176);
   _actionMap[114][WHEN] = ActionEntry(REDUCE, 184);
   _actionMap[114][ELSE] = ActionEntry(REDUCE, 184);
   _actionMap[114][LEFT] = ActionEntry(REDUCE, 184);
   _actionMap[114][RIGHT] = ActionEntry(REDUCE, 184);
   _actionMap[114][INNER] = ActionEntry(REDUCE, 184);
   _actionMap[114][JOIN] = ActionEntry(REDUCE, 184);
   _actionMap[114][RETURNTOKEN] = ActionEntry(REDUCE, 184);
}
void Cego::loadParser275()
{
   _actionMap[114][ORDER] = ActionEntry(REDUCE, 184);
   _actionMap[114][GROUP] = ActionEntry(REDUCE, 184);
   _actionMap[114][WHERE] = ActionEntry(REDUCE, 184);
   _actionMap[114][BEGIN] = ActionEntry(REDUCE, 184);
   _actionMap[114][THEN] = ActionEntry(REDUCE, 184);
   _actionMap[114][OR] = ActionEntry(REDUCE, 184);
   _actionMap[114][AS] = ActionEntry(REDUCE, 184);
   _actionMap[114][FROM] = ActionEntry(REDUCE, 184);
   _actionMap[114][END_TOKEN] = ActionEntry(REDUCE, 184);
   _actionMap[114][AND] = ActionEntry(REDUCE, 184);
   _actionMap[114][LIKE] = ActionEntry(REDUCE, 184);
   _actionMap[114][IS] = ActionEntry(REDUCE, 184);
   _actionMap[114][BETWEEN] = ActionEntry(REDUCE, 184);
   _actionMap[114][NOT] = ActionEntry(REDUCE, 184);
   _actionMap[114][INTOK] = ActionEntry(REDUCE, 184);
   _actionMap[114][EQU] = ActionEntry(REDUCE, 184);
   _actionMap[114][NEGATION] = ActionEntry(REDUCE, 184);
   _actionMap[114][LT] = ActionEntry(REDUCE, 184);
   _actionMap[114][MT] = ActionEntry(REDUCE, 184);
   _actionMap[114][DESC] = ActionEntry(REDUCE, 184);
   _actionMap[114][ASC] = ActionEntry(REDUCE, 184);
   _actionMap[114][KSEP] = ActionEntry(REDUCE, 184);
   _actionMap[114][ROWLIMIT] = ActionEntry(REDUCE, 184);
   _actionMap[114][UNION] = ActionEntry(REDUCE, 184);
   _actionMap[114][ENDTOKEN] = ActionEntry(REDUCE, 184);
   _actionMap[114][RB] = ActionEntry(REDUCE, 184);
   _actionMap[114][SEMICOLON] = ActionEntry(REDUCE, 184);
   _actionMap[114][CONCAT] = ActionEntry(REDUCE, 184);
   _actionMap[114][STAR] = ActionEntry(REDUCE, 184);
   _actionMap[114][DIVISION] = ActionEntry(REDUCE, 184);
   _actionMap[114][MINUS] = ActionEntry(REDUCE, 184);
   _actionMap[114][PLUS] = ActionEntry(REDUCE, 184);
   _actionMap[115][WHEN] = ActionEntry(SHIFT, 280);
   _jumpMap[115][CaseCondition] = 279;
   _jumpMap[115][CaseConditionList] = 278;
   _actionMap[116][WHEN] = ActionEntry(REDUCE, 181);
   _actionMap[116][ELSE] = ActionEntry(REDUCE, 181);
   _actionMap[116][LEFT] = ActionEntry(REDUCE, 181);
   _actionMap[116][RIGHT] = ActionEntry(REDUCE, 181);
   _actionMap[116][INNER] = ActionEntry(REDUCE, 181);
   _actionMap[116][JOIN] = ActionEntry(REDUCE, 181);
   _actionMap[116][RETURNTOKEN] = ActionEntry(REDUCE, 181);
   _actionMap[116][ORDER] = ActionEntry(REDUCE, 181);
   _actionMap[116][GROUP] = ActionEntry(REDUCE, 181);
   _actionMap[116][WHERE] = ActionEntry(REDUCE, 181);
   _actionMap[116][BEGIN] = ActionEntry(REDUCE, 181);
   _actionMap[116][THEN] = ActionEntry(REDUCE, 181);
   _actionMap[116][OR] = ActionEntry(REDUCE, 181);
   _actionMap[116][AS] = ActionEntry(REDUCE, 181);
   _actionMap[116][FROM] = ActionEntry(REDUCE, 181);
}
void Cego::loadParser276()
{
   _actionMap[116][END_TOKEN] = ActionEntry(REDUCE, 181);
   _actionMap[116][AND] = ActionEntry(REDUCE, 181);
   _actionMap[116][LIKE] = ActionEntry(REDUCE, 181);
   _actionMap[116][IS] = ActionEntry(REDUCE, 181);
   _actionMap[116][BETWEEN] = ActionEntry(REDUCE, 181);
   _actionMap[116][NOT] = ActionEntry(REDUCE, 181);
   _actionMap[116][INTOK] = ActionEntry(REDUCE, 181);
   _actionMap[116][EQU] = ActionEntry(REDUCE, 181);
   _actionMap[116][NEGATION] = ActionEntry(REDUCE, 181);
   _actionMap[116][LT] = ActionEntry(REDUCE, 181);
   _actionMap[116][MT] = ActionEntry(REDUCE, 181);
   _actionMap[116][DESC] = ActionEntry(REDUCE, 181);
   _actionMap[116][ASC] = ActionEntry(REDUCE, 181);
   _actionMap[116][KSEP] = ActionEntry(REDUCE, 181);
   _actionMap[116][ROWLIMIT] = ActionEntry(REDUCE, 181);
   _actionMap[116][UNION] = ActionEntry(REDUCE, 181);
   _actionMap[116][ENDTOKEN] = ActionEntry(REDUCE, 181);
   _actionMap[116][RB] = ActionEntry(REDUCE, 181);
   _actionMap[116][SEMICOLON] = ActionEntry(REDUCE, 181);
   _actionMap[116][CONCAT] = ActionEntry(REDUCE, 181);
   _actionMap[116][STAR] = ActionEntry(REDUCE, 181);
   _actionMap[116][DIVISION] = ActionEntry(REDUCE, 181);
   _actionMap[116][MINUS] = ActionEntry(REDUCE, 181);
   _actionMap[116][PLUS] = ActionEntry(REDUCE, 181);
   _actionMap[117][WHEN] = ActionEntry(REDUCE, 180);
   _actionMap[117][ELSE] = ActionEntry(REDUCE, 180);
   _actionMap[117][LEFT] = ActionEntry(REDUCE, 180);
   _actionMap[117][RIGHT] = ActionEntry(REDUCE, 180);
   _actionMap[117][INNER] = ActionEntry(REDUCE, 180);
   _actionMap[117][JOIN] = ActionEntry(REDUCE, 180);
   _actionMap[117][RETURNTOKEN] = ActionEntry(REDUCE, 180);
   _actionMap[117][ORDER] = ActionEntry(REDUCE, 180);
   _actionMap[117][GROUP] = ActionEntry(REDUCE, 180);
   _actionMap[117][WHERE] = ActionEntry(REDUCE, 180);
   _actionMap[117][AS] = ActionEntry(REDUCE, 180);
   _actionMap[117][FROM] = ActionEntry(REDUCE, 180);
   _actionMap[117][END_TOKEN] = ActionEntry(REDUCE, 180);
   _actionMap[117][BEGIN] = ActionEntry(REDUCE, 180);
   _actionMap[117][THEN] = ActionEntry(REDUCE, 180);
   _actionMap[117][OR] = ActionEntry(REDUCE, 180);
   _actionMap[117][AND] = ActionEntry(REDUCE, 180);
   _actionMap[117][LIKE] = ActionEntry(REDUCE, 180);
   _actionMap[117][IS] = ActionEntry(REDUCE, 180);
   _actionMap[117][BETWEEN] = ActionEntry(REDUCE, 180);
   _actionMap[117][NOT] = ActionEntry(REDUCE, 180);
   _actionMap[117][INTOK] = ActionEntry(REDUCE, 180);
   _actionMap[117][EQU] = ActionEntry(REDUCE, 180);
   _actionMap[117][NEGATION] = ActionEntry(REDUCE, 180);
   _actionMap[117][LT] = ActionEntry(REDUCE, 180);
   _actionMap[117][MT] = ActionEntry(REDUCE, 180);
}
void Cego::loadParser277()
{
   _actionMap[117][DESC] = ActionEntry(REDUCE, 180);
   _actionMap[117][ASC] = ActionEntry(REDUCE, 180);
   _actionMap[117][KSEP] = ActionEntry(REDUCE, 180);
   _actionMap[117][ROWLIMIT] = ActionEntry(REDUCE, 180);
   _actionMap[117][UNION] = ActionEntry(REDUCE, 180);
   _actionMap[117][ENDTOKEN] = ActionEntry(REDUCE, 180);
   _actionMap[117][RB] = ActionEntry(REDUCE, 180);
   _actionMap[117][SEMICOLON] = ActionEntry(REDUCE, 180);
   _actionMap[117][CONCAT] = ActionEntry(REDUCE, 180);
   _actionMap[117][STAR] = ActionEntry(REDUCE, 180);
   _actionMap[117][DIVISION] = ActionEntry(REDUCE, 180);
   _actionMap[117][MINUS] = ActionEntry(REDUCE, 180);
   _actionMap[117][PLUS] = ActionEntry(REDUCE, 180);
   _actionMap[118][WHEN] = ActionEntry(REDUCE, 408);
   _actionMap[118][ELSE] = ActionEntry(REDUCE, 408);
   _actionMap[118][LEFT] = ActionEntry(REDUCE, 408);
   _actionMap[118][RIGHT] = ActionEntry(REDUCE, 408);
   _actionMap[118][INNER] = ActionEntry(REDUCE, 408);
   _actionMap[118][JOIN] = ActionEntry(REDUCE, 408);
   _actionMap[118][RETURNTOKEN] = ActionEntry(REDUCE, 408);
   _actionMap[118][ORDER] = ActionEntry(REDUCE, 408);
   _actionMap[118][GROUP] = ActionEntry(REDUCE, 408);
   _actionMap[118][WHERE] = ActionEntry(REDUCE, 408);
   _actionMap[118][NULLTOKEN] = ActionEntry(REDUCE, 408);
   _actionMap[118][FROM] = ActionEntry(REDUCE, 408);
   _actionMap[118][AS] = ActionEntry(REDUCE, 408);
   _actionMap[118][END_TOKEN] = ActionEntry(REDUCE, 408);
   _actionMap[118][BEGIN] = ActionEntry(REDUCE, 408);
   _actionMap[118][THEN] = ActionEntry(REDUCE, 408);
   _actionMap[118][OR] = ActionEntry(REDUCE, 408);
   _actionMap[118][AND] = ActionEntry(REDUCE, 408);
   _actionMap[118][INTOK] = ActionEntry(REDUCE, 408);
   _actionMap[118][NOT] = ActionEntry(REDUCE, 408);
   _actionMap[118][BETWEEN] = ActionEntry(REDUCE, 408);
   _actionMap[118][IS] = ActionEntry(REDUCE, 408);
   _actionMap[118][LIKE] = ActionEntry(REDUCE, 408);
   _actionMap[118][MT] = ActionEntry(REDUCE, 408);
   _actionMap[118][LT] = ActionEntry(REDUCE, 408);
   _actionMap[118][NEGATION] = ActionEntry(REDUCE, 408);
   _actionMap[118][EQU] = ActionEntry(REDUCE, 408);
   _actionMap[118][RB] = ActionEntry(REDUCE, 408);
   _actionMap[118][ENDTOKEN] = ActionEntry(REDUCE, 408);
   _actionMap[118][UNION] = ActionEntry(REDUCE, 408);
   _actionMap[118][ROWLIMIT] = ActionEntry(REDUCE, 408);
   _actionMap[118][KSEP] = ActionEntry(REDUCE, 408);
   _actionMap[118][ASC] = ActionEntry(REDUCE, 408);
   _actionMap[118][DESC] = ActionEntry(REDUCE, 408);
   _actionMap[118][SEMICOLON] = ActionEntry(REDUCE, 408);
   _actionMap[118][PLUS] = ActionEntry(REDUCE, 408);
   _actionMap[118][MINUS] = ActionEntry(REDUCE, 408);
}
void Cego::loadParser278()
{
   _actionMap[118][DIVISION] = ActionEntry(REDUCE, 408);
   _actionMap[118][STAR] = ActionEntry(REDUCE, 408);
   _actionMap[118][CONCAT] = ActionEntry(REDUCE, 408);
   _actionMap[119][WHEN] = ActionEntry(REDUCE, 414);
   _actionMap[119][ELSE] = ActionEntry(REDUCE, 414);
   _actionMap[119][LEFT] = ActionEntry(REDUCE, 414);
   _actionMap[119][RIGHT] = ActionEntry(REDUCE, 414);
   _actionMap[119][INNER] = ActionEntry(REDUCE, 414);
   _actionMap[119][JOIN] = ActionEntry(REDUCE, 414);
   _actionMap[119][RETURNTOKEN] = ActionEntry(REDUCE, 414);
   _actionMap[119][ORDER] = ActionEntry(REDUCE, 414);
   _actionMap[119][GROUP] = ActionEntry(REDUCE, 414);
   _actionMap[119][WHERE] = ActionEntry(REDUCE, 414);
   _actionMap[119][NULLTOKEN] = ActionEntry(REDUCE, 414);
   _actionMap[119][FROM] = ActionEntry(REDUCE, 414);
   _actionMap[119][AS] = ActionEntry(REDUCE, 414);
   _actionMap[119][END_TOKEN] = ActionEntry(REDUCE, 414);
   _actionMap[119][BEGIN] = ActionEntry(REDUCE, 414);
   _actionMap[119][THEN] = ActionEntry(REDUCE, 414);
   _actionMap[119][OR] = ActionEntry(REDUCE, 414);
   _actionMap[119][AND] = ActionEntry(REDUCE, 414);
   _actionMap[119][INTOK] = ActionEntry(REDUCE, 414);
   _actionMap[119][NOT] = ActionEntry(REDUCE, 414);
   _actionMap[119][BETWEEN] = ActionEntry(REDUCE, 414);
   _actionMap[119][IS] = ActionEntry(REDUCE, 414);
   _actionMap[119][LIKE] = ActionEntry(REDUCE, 414);
   _actionMap[119][MT] = ActionEntry(REDUCE, 414);
   _actionMap[119][LT] = ActionEntry(REDUCE, 414);
   _actionMap[119][NEGATION] = ActionEntry(REDUCE, 414);
   _actionMap[119][EQU] = ActionEntry(REDUCE, 414);
   _actionMap[119][RB] = ActionEntry(REDUCE, 414);
   _actionMap[119][ENDTOKEN] = ActionEntry(REDUCE, 414);
   _actionMap[119][UNION] = ActionEntry(REDUCE, 414);
   _actionMap[119][ROWLIMIT] = ActionEntry(REDUCE, 414);
   _actionMap[119][KSEP] = ActionEntry(REDUCE, 414);
   _actionMap[119][ASC] = ActionEntry(REDUCE, 414);
   _actionMap[119][DESC] = ActionEntry(REDUCE, 414);
   _actionMap[119][SEMICOLON] = ActionEntry(REDUCE, 414);
   _actionMap[119][PLUS] = ActionEntry(REDUCE, 414);
   _actionMap[119][MINUS] = ActionEntry(REDUCE, 414);
   _actionMap[119][DIVISION] = ActionEntry(REDUCE, 414);
   _actionMap[119][STAR] = ActionEntry(REDUCE, 414);
   _actionMap[119][CONCAT] = ActionEntry(REDUCE, 414);
   _actionMap[120][WHEN] = ActionEntry(REDUCE, 178);
   _actionMap[120][ELSE] = ActionEntry(REDUCE, 178);
   _actionMap[120][LEFT] = ActionEntry(REDUCE, 178);
   _actionMap[120][RIGHT] = ActionEntry(REDUCE, 178);
   _actionMap[120][INNER] = ActionEntry(REDUCE, 178);
   _actionMap[120][JOIN] = ActionEntry(REDUCE, 178);
   _actionMap[120][RETURNTOKEN] = ActionEntry(REDUCE, 178);
}
void Cego::loadParser279()
{
   _actionMap[120][ORDER] = ActionEntry(REDUCE, 178);
   _actionMap[120][GROUP] = ActionEntry(REDUCE, 178);
   _actionMap[120][WHERE] = ActionEntry(REDUCE, 178);
   _actionMap[120][AS] = ActionEntry(REDUCE, 178);
   _actionMap[120][FROM] = ActionEntry(REDUCE, 178);
   _actionMap[120][END_TOKEN] = ActionEntry(REDUCE, 178);
   _actionMap[120][BEGIN] = ActionEntry(REDUCE, 178);
   _actionMap[120][THEN] = ActionEntry(REDUCE, 178);
   _actionMap[120][OR] = ActionEntry(REDUCE, 178);
   _actionMap[120][AND] = ActionEntry(REDUCE, 178);
   _actionMap[120][LIKE] = ActionEntry(REDUCE, 178);
   _actionMap[120][IS] = ActionEntry(REDUCE, 178);
   _actionMap[120][BETWEEN] = ActionEntry(REDUCE, 178);
   _actionMap[120][NOT] = ActionEntry(REDUCE, 178);
   _actionMap[120][INTOK] = ActionEntry(REDUCE, 178);
   _actionMap[120][EQU] = ActionEntry(REDUCE, 178);
   _actionMap[120][NEGATION] = ActionEntry(REDUCE, 178);
   _actionMap[120][LT] = ActionEntry(REDUCE, 178);
   _actionMap[120][MT] = ActionEntry(REDUCE, 178);
   _actionMap[120][DESC] = ActionEntry(REDUCE, 178);
   _actionMap[120][ASC] = ActionEntry(REDUCE, 178);
   _actionMap[120][KSEP] = ActionEntry(REDUCE, 178);
   _actionMap[120][ROWLIMIT] = ActionEntry(REDUCE, 178);
   _actionMap[120][UNION] = ActionEntry(REDUCE, 178);
   _actionMap[120][ENDTOKEN] = ActionEntry(REDUCE, 178);
   _actionMap[120][RB] = ActionEntry(REDUCE, 178);
   _actionMap[120][SEMICOLON] = ActionEntry(REDUCE, 178);
   _actionMap[120][CONCAT] = ActionEntry(REDUCE, 178);
   _actionMap[120][STAR] = ActionEntry(REDUCE, 178);
   _actionMap[120][DIVISION] = ActionEntry(REDUCE, 178);
   _actionMap[120][MINUS] = ActionEntry(REDUCE, 178);
   _actionMap[120][PLUS] = ActionEntry(REDUCE, 178);
   _actionMap[121][LB] = ActionEntry(SHIFT, 281);
   _actionMap[122][WHEN] = ActionEntry(REDUCE, 413);
   _actionMap[122][ELSE] = ActionEntry(REDUCE, 413);
   _actionMap[122][LEFT] = ActionEntry(REDUCE, 413);
   _actionMap[122][RIGHT] = ActionEntry(REDUCE, 413);
   _actionMap[122][INNER] = ActionEntry(REDUCE, 413);
   _actionMap[122][JOIN] = ActionEntry(REDUCE, 413);
   _actionMap[122][RETURNTOKEN] = ActionEntry(REDUCE, 413);
   _actionMap[122][ORDER] = ActionEntry(REDUCE, 413);
   _actionMap[122][GROUP] = ActionEntry(REDUCE, 413);
   _actionMap[122][WHERE] = ActionEntry(REDUCE, 413);
   _actionMap[122][NULLTOKEN] = ActionEntry(REDUCE, 413);
   _actionMap[122][FROM] = ActionEntry(REDUCE, 413);
   _actionMap[122][AS] = ActionEntry(REDUCE, 413);
   _actionMap[122][END_TOKEN] = ActionEntry(REDUCE, 413);
   _actionMap[122][BEGIN] = ActionEntry(REDUCE, 413);
   _actionMap[122][THEN] = ActionEntry(REDUCE, 413);
   _actionMap[122][OR] = ActionEntry(REDUCE, 413);
}
void Cego::loadParser280()
{
   _actionMap[122][AND] = ActionEntry(REDUCE, 413);
   _actionMap[122][INTOK] = ActionEntry(REDUCE, 413);
   _actionMap[122][NOT] = ActionEntry(REDUCE, 413);
   _actionMap[122][BETWEEN] = ActionEntry(REDUCE, 413);
   _actionMap[122][IS] = ActionEntry(REDUCE, 413);
   _actionMap[122][LIKE] = ActionEntry(REDUCE, 413);
   _actionMap[122][MT] = ActionEntry(REDUCE, 413);
   _actionMap[122][LT] = ActionEntry(REDUCE, 413);
   _actionMap[122][NEGATION] = ActionEntry(REDUCE, 413);
   _actionMap[122][EQU] = ActionEntry(REDUCE, 413);
   _actionMap[122][RB] = ActionEntry(REDUCE, 413);
   _actionMap[122][ENDTOKEN] = ActionEntry(REDUCE, 413);
   _actionMap[122][UNION] = ActionEntry(REDUCE, 413);
   _actionMap[122][ROWLIMIT] = ActionEntry(REDUCE, 413);
   _actionMap[122][KSEP] = ActionEntry(REDUCE, 413);
   _actionMap[122][ASC] = ActionEntry(REDUCE, 413);
   _actionMap[122][DESC] = ActionEntry(REDUCE, 413);
   _actionMap[122][SEMICOLON] = ActionEntry(REDUCE, 413);
   _actionMap[122][PLUS] = ActionEntry(REDUCE, 413);
   _actionMap[122][MINUS] = ActionEntry(REDUCE, 413);
   _actionMap[122][DIVISION] = ActionEntry(REDUCE, 413);
   _actionMap[122][STAR] = ActionEntry(REDUCE, 413);
   _actionMap[122][CONCAT] = ActionEntry(REDUCE, 413);
   _actionMap[123][LB] = ActionEntry(SHIFT, 282);
   _actionMap[124][LB] = ActionEntry(SHIFT, 283);
   _actionMap[125][LB] = ActionEntry(SHIFT, 284);
   _actionMap[126][LB] = ActionEntry(SHIFT, 285);
   _actionMap[127][LB] = ActionEntry(SHIFT, 286);
   _actionMap[128][LAB] = ActionEntry(SHIFT, 287);
   _actionMap[129][LB] = ActionEntry(SHIFT, 288);
   _actionMap[130][LB] = ActionEntry(SHIFT, 289);
   _actionMap[131][WHEN] = ActionEntry(REDUCE, 195);
   _actionMap[132][LAB] = ActionEntry(SHIFT, 290);
   _actionMap[133][LB] = ActionEntry(SHIFT, 291);
   _actionMap[134][LB] = ActionEntry(SHIFT, 292);
   _actionMap[135][LB] = ActionEntry(SHIFT, 293);
   _actionMap[136][LB] = ActionEntry(SHIFT, 294);
   _actionMap[137][LB] = ActionEntry(SHIFT, 295);
   _actionMap[138][LB] = ActionEntry(SHIFT, 296);
   _actionMap[139][LB] = ActionEntry(SHIFT, 297);
   _actionMap[140][LB] = ActionEntry(SHIFT, 298);
   _actionMap[141][WHEN] = ActionEntry(REDUCE, 422);
   _actionMap[141][ELSE] = ActionEntry(REDUCE, 422);
   _actionMap[141][LEFT] = ActionEntry(REDUCE, 422);
   _actionMap[141][RIGHT] = ActionEntry(REDUCE, 422);
   _actionMap[141][INNER] = ActionEntry(REDUCE, 422);
   _actionMap[141][JOIN] = ActionEntry(REDUCE, 422);
   _actionMap[141][RETURNTOKEN] = ActionEntry(REDUCE, 422);
   _actionMap[141][ORDER] = ActionEntry(REDUCE, 422);
   _actionMap[141][GROUP] = ActionEntry(REDUCE, 422);
}
void Cego::loadParser281()
{
   _actionMap[141][WHERE] = ActionEntry(REDUCE, 422);
   _actionMap[141][FROM] = ActionEntry(REDUCE, 422);
   _actionMap[141][AS] = ActionEntry(REDUCE, 422);
   _actionMap[141][END_TOKEN] = ActionEntry(REDUCE, 422);
   _actionMap[141][BEGIN] = ActionEntry(REDUCE, 422);
   _actionMap[141][THEN] = ActionEntry(REDUCE, 422);
   _actionMap[141][OR] = ActionEntry(REDUCE, 422);
   _actionMap[141][AND] = ActionEntry(REDUCE, 422);
   _actionMap[141][NULLTOKEN] = ActionEntry(REDUCE, 422);
   _actionMap[141][INTOK] = ActionEntry(REDUCE, 422);
   _actionMap[141][NOT] = ActionEntry(REDUCE, 422);
   _actionMap[141][BETWEEN] = ActionEntry(REDUCE, 422);
   _actionMap[141][IS] = ActionEntry(REDUCE, 422);
   _actionMap[141][LIKE] = ActionEntry(REDUCE, 422);
   _actionMap[141][MT] = ActionEntry(REDUCE, 422);
   _actionMap[141][LT] = ActionEntry(REDUCE, 422);
   _actionMap[141][NEGATION] = ActionEntry(REDUCE, 422);
   _actionMap[141][EQU] = ActionEntry(REDUCE, 422);
   _actionMap[141][RB] = ActionEntry(REDUCE, 422);
   _actionMap[141][ENDTOKEN] = ActionEntry(REDUCE, 422);
   _actionMap[141][UNION] = ActionEntry(REDUCE, 422);
   _actionMap[141][ROWLIMIT] = ActionEntry(REDUCE, 422);
   _actionMap[141][KSEP] = ActionEntry(REDUCE, 422);
   _actionMap[141][ASC] = ActionEntry(REDUCE, 422);
   _actionMap[141][DESC] = ActionEntry(REDUCE, 422);
   _actionMap[141][SEMICOLON] = ActionEntry(REDUCE, 422);
   _actionMap[141][PLUS] = ActionEntry(REDUCE, 422);
   _actionMap[141][MINUS] = ActionEntry(REDUCE, 422);
   _actionMap[141][DIVISION] = ActionEntry(REDUCE, 422);
   _actionMap[141][STAR] = ActionEntry(REDUCE, 422);
   _actionMap[141][CONCAT] = ActionEntry(REDUCE, 422);
   _actionMap[142][IDENTIFIER] = ActionEntry(SHIFT, 299);
   _actionMap[143][LB] = ActionEntry(SHIFT, 300);
   _actionMap[144][LB] = ActionEntry(SHIFT, 301);
   _actionMap[145][LB] = ActionEntry(SHIFT, 302);
   _actionMap[146][LB] = ActionEntry(SHIFT, 303);
   _actionMap[147][LB] = ActionEntry(SHIFT, 304);
   _actionMap[148][LB] = ActionEntry(SHIFT, 305);
   _actionMap[149][LB] = ActionEntry(SHIFT, 306);
   _actionMap[150][LB] = ActionEntry(SHIFT, 307);
   _actionMap[151][LB] = ActionEntry(SHIFT, 308);
   _actionMap[152][LB] = ActionEntry(SHIFT, 309);
   _actionMap[153][LB] = ActionEntry(SHIFT, 310);
   _actionMap[154][LB] = ActionEntry(SHIFT, 311);
   _actionMap[155][LB] = ActionEntry(SHIFT, 312);
   _actionMap[156][LB] = ActionEntry(SHIFT, 313);
   _actionMap[157][WHEN] = ActionEntry(REDUCE, 420);
   _actionMap[157][ELSE] = ActionEntry(REDUCE, 420);
   _actionMap[157][LEFT] = ActionEntry(REDUCE, 420);
   _actionMap[157][RIGHT] = ActionEntry(REDUCE, 420);
}
void Cego::loadParser282()
{
   _actionMap[157][INNER] = ActionEntry(REDUCE, 420);
   _actionMap[157][JOIN] = ActionEntry(REDUCE, 420);
   _actionMap[157][RETURNTOKEN] = ActionEntry(REDUCE, 420);
   _actionMap[157][ORDER] = ActionEntry(REDUCE, 420);
   _actionMap[157][GROUP] = ActionEntry(REDUCE, 420);
   _actionMap[157][WHERE] = ActionEntry(REDUCE, 420);
   _actionMap[157][FROM] = ActionEntry(REDUCE, 420);
   _actionMap[157][AS] = ActionEntry(REDUCE, 420);
   _actionMap[157][END_TOKEN] = ActionEntry(REDUCE, 420);
   _actionMap[157][BEGIN] = ActionEntry(REDUCE, 420);
   _actionMap[157][THEN] = ActionEntry(REDUCE, 420);
   _actionMap[157][OR] = ActionEntry(REDUCE, 420);
   _actionMap[157][AND] = ActionEntry(REDUCE, 420);
   _actionMap[157][NULLTOKEN] = ActionEntry(REDUCE, 420);
   _actionMap[157][INTOK] = ActionEntry(REDUCE, 420);
   _actionMap[157][NOT] = ActionEntry(REDUCE, 420);
   _actionMap[157][BETWEEN] = ActionEntry(REDUCE, 420);
   _actionMap[157][IS] = ActionEntry(REDUCE, 420);
   _actionMap[157][LIKE] = ActionEntry(REDUCE, 420);
   _actionMap[157][MT] = ActionEntry(REDUCE, 420);
   _actionMap[157][LT] = ActionEntry(REDUCE, 420);
   _actionMap[157][NEGATION] = ActionEntry(REDUCE, 420);
   _actionMap[157][EQU] = ActionEntry(REDUCE, 420);
   _actionMap[157][RB] = ActionEntry(REDUCE, 420);
   _actionMap[157][ENDTOKEN] = ActionEntry(REDUCE, 420);
   _actionMap[157][UNION] = ActionEntry(REDUCE, 420);
   _actionMap[157][ROWLIMIT] = ActionEntry(REDUCE, 420);
   _actionMap[157][KSEP] = ActionEntry(REDUCE, 420);
   _actionMap[157][ASC] = ActionEntry(REDUCE, 420);
   _actionMap[157][DESC] = ActionEntry(REDUCE, 420);
   _actionMap[157][SEMICOLON] = ActionEntry(REDUCE, 420);
   _actionMap[157][PLUS] = ActionEntry(REDUCE, 420);
   _actionMap[157][MINUS] = ActionEntry(REDUCE, 420);
   _actionMap[157][DIVISION] = ActionEntry(REDUCE, 420);
   _actionMap[157][STAR] = ActionEntry(REDUCE, 420);
   _actionMap[157][CONCAT] = ActionEntry(REDUCE, 420);
   _actionMap[158][LB] = ActionEntry(SHIFT, 314);
   _actionMap[159][LB] = ActionEntry(SHIFT, 315);
   _actionMap[160][LB] = ActionEntry(SHIFT, 316);
   _actionMap[161][LB] = ActionEntry(SHIFT, 317);
   _actionMap[162][LB] = ActionEntry(SHIFT, 318);
   _actionMap[163][LB] = ActionEntry(SHIFT, 319);
   _actionMap[164][LB] = ActionEntry(SHIFT, 320);
   _actionMap[165][LB] = ActionEntry(SHIFT, 321);
   _actionMap[166][LB] = ActionEntry(SHIFT, 322);
   _actionMap[167][LB] = ActionEntry(SHIFT, 323);
   _actionMap[168][WHEN] = ActionEntry(REDUCE, 419);
   _actionMap[168][ELSE] = ActionEntry(REDUCE, 419);
   _actionMap[168][LEFT] = ActionEntry(REDUCE, 419);
   _actionMap[168][RIGHT] = ActionEntry(REDUCE, 419);
}
void Cego::loadParser283()
{
   _actionMap[168][INNER] = ActionEntry(REDUCE, 419);
   _actionMap[168][JOIN] = ActionEntry(REDUCE, 419);
   _actionMap[168][RETURNTOKEN] = ActionEntry(REDUCE, 419);
   _actionMap[168][ORDER] = ActionEntry(REDUCE, 419);
   _actionMap[168][GROUP] = ActionEntry(REDUCE, 419);
   _actionMap[168][WHERE] = ActionEntry(REDUCE, 419);
   _actionMap[168][FROM] = ActionEntry(REDUCE, 419);
   _actionMap[168][AS] = ActionEntry(REDUCE, 419);
   _actionMap[168][END_TOKEN] = ActionEntry(REDUCE, 419);
   _actionMap[168][BEGIN] = ActionEntry(REDUCE, 419);
   _actionMap[168][THEN] = ActionEntry(REDUCE, 419);
   _actionMap[168][OR] = ActionEntry(REDUCE, 419);
   _actionMap[168][AND] = ActionEntry(REDUCE, 419);
   _actionMap[168][NULLTOKEN] = ActionEntry(REDUCE, 419);
   _actionMap[168][INTOK] = ActionEntry(REDUCE, 419);
   _actionMap[168][NOT] = ActionEntry(REDUCE, 419);
   _actionMap[168][BETWEEN] = ActionEntry(REDUCE, 419);
   _actionMap[168][IS] = ActionEntry(REDUCE, 419);
   _actionMap[168][LIKE] = ActionEntry(REDUCE, 419);
   _actionMap[168][MT] = ActionEntry(REDUCE, 419);
   _actionMap[168][LT] = ActionEntry(REDUCE, 419);
   _actionMap[168][NEGATION] = ActionEntry(REDUCE, 419);
   _actionMap[168][EQU] = ActionEntry(REDUCE, 419);
   _actionMap[168][RB] = ActionEntry(REDUCE, 419);
   _actionMap[168][ENDTOKEN] = ActionEntry(REDUCE, 419);
   _actionMap[168][UNION] = ActionEntry(REDUCE, 419);
   _actionMap[168][ROWLIMIT] = ActionEntry(REDUCE, 419);
   _actionMap[168][KSEP] = ActionEntry(REDUCE, 419);
   _actionMap[168][ASC] = ActionEntry(REDUCE, 419);
   _actionMap[168][DESC] = ActionEntry(REDUCE, 419);
   _actionMap[168][SEMICOLON] = ActionEntry(REDUCE, 419);
   _actionMap[168][PLUS] = ActionEntry(REDUCE, 419);
   _actionMap[168][MINUS] = ActionEntry(REDUCE, 419);
   _actionMap[168][DIVISION] = ActionEntry(REDUCE, 419);
   _actionMap[168][STAR] = ActionEntry(REDUCE, 419);
   _actionMap[168][CONCAT] = ActionEntry(REDUCE, 419);
   _actionMap[169][LB] = ActionEntry(SHIFT, 324);
   _actionMap[170][LB] = ActionEntry(SHIFT, 325);
   _actionMap[171][LB] = ActionEntry(SHIFT, 326);
   _actionMap[172][LB] = ActionEntry(SHIFT, 327);
   _actionMap[173][WHEN] = ActionEntry(REDUCE, 421);
   _actionMap[173][ELSE] = ActionEntry(REDUCE, 421);
   _actionMap[173][LEFT] = ActionEntry(REDUCE, 421);
   _actionMap[173][RIGHT] = ActionEntry(REDUCE, 421);
   _actionMap[173][INNER] = ActionEntry(REDUCE, 421);
   _actionMap[173][JOIN] = ActionEntry(REDUCE, 421);
   _actionMap[173][RETURNTOKEN] = ActionEntry(REDUCE, 421);
   _actionMap[173][ORDER] = ActionEntry(REDUCE, 421);
   _actionMap[173][GROUP] = ActionEntry(REDUCE, 421);
   _actionMap[173][WHERE] = ActionEntry(REDUCE, 421);
}
void Cego::loadParser284()
{
   _actionMap[173][FROM] = ActionEntry(REDUCE, 421);
   _actionMap[173][AS] = ActionEntry(REDUCE, 421);
   _actionMap[173][END_TOKEN] = ActionEntry(REDUCE, 421);
   _actionMap[173][BEGIN] = ActionEntry(REDUCE, 421);
   _actionMap[173][THEN] = ActionEntry(REDUCE, 421);
   _actionMap[173][OR] = ActionEntry(REDUCE, 421);
   _actionMap[173][AND] = ActionEntry(REDUCE, 421);
   _actionMap[173][NULLTOKEN] = ActionEntry(REDUCE, 421);
   _actionMap[173][INTOK] = ActionEntry(REDUCE, 421);
   _actionMap[173][NOT] = ActionEntry(REDUCE, 421);
   _actionMap[173][BETWEEN] = ActionEntry(REDUCE, 421);
   _actionMap[173][IS] = ActionEntry(REDUCE, 421);
   _actionMap[173][LIKE] = ActionEntry(REDUCE, 421);
   _actionMap[173][MT] = ActionEntry(REDUCE, 421);
   _actionMap[173][LT] = ActionEntry(REDUCE, 421);
   _actionMap[173][NEGATION] = ActionEntry(REDUCE, 421);
   _actionMap[173][EQU] = ActionEntry(REDUCE, 421);
   _actionMap[173][RB] = ActionEntry(REDUCE, 421);
   _actionMap[173][ENDTOKEN] = ActionEntry(REDUCE, 421);
   _actionMap[173][UNION] = ActionEntry(REDUCE, 421);
   _actionMap[173][ROWLIMIT] = ActionEntry(REDUCE, 421);
   _actionMap[173][KSEP] = ActionEntry(REDUCE, 421);
   _actionMap[173][ASC] = ActionEntry(REDUCE, 421);
   _actionMap[173][DESC] = ActionEntry(REDUCE, 421);
   _actionMap[173][SEMICOLON] = ActionEntry(REDUCE, 421);
   _actionMap[173][PLUS] = ActionEntry(REDUCE, 421);
   _actionMap[173][MINUS] = ActionEntry(REDUCE, 421);
   _actionMap[173][DIVISION] = ActionEntry(REDUCE, 421);
   _actionMap[173][STAR] = ActionEntry(REDUCE, 421);
   _actionMap[173][CONCAT] = ActionEntry(REDUCE, 421);
   _actionMap[174][LB] = ActionEntry(SHIFT, 328);
   _actionMap[175][LB] = ActionEntry(SHIFT, 329);
   _actionMap[176][LONG] = ActionEntry(SHIFT, 336);
   _actionMap[176][BIGINT] = ActionEntry(SHIFT, 332);
   _actionMap[176][SMALLINT] = ActionEntry(SHIFT, 337);
   _actionMap[176][TINYINT] = ActionEntry(SHIFT, 338);
   _actionMap[176][DOUBLE] = ActionEntry(SHIFT, 334);
   _actionMap[176][DECIMAL] = ActionEntry(SHIFT, 333);
   _actionMap[176][FIXED] = ActionEntry(SHIFT, 335);
   _actionMap[176][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[176][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[176][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[176][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[176][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[176][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[176][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[176][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[176][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[176][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[176][DATE2LONG] = ActionEntry(SHIFT, 139);
}
void Cego::loadParser285()
{
   _actionMap[176][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[176][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[176][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[176][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[176][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[176][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[176][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[176][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[176][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[176][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[176][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[176][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[176][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[176][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[176][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[176][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[176][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[176][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[176][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[176][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[176][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[176][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[176][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[176][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[176][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[176][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[176][CLOBSIZE] = ActionEntry(SHIFT, 133);
   _actionMap[176][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[176][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[176][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[176][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[176][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[176][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[176][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[176][LB] = ActionEntry(SHIFT, 176);
   _actionMap[176][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[176][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[176][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[176][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[176][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[176][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[176][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[176][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[176][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[176][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[176][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[176][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[176][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[176][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[176][AVG] = ActionEntry(SHIFT, 124);
}
void Cego::loadParser286()
{
   _actionMap[176][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[176][MAX] = ActionEntry(SHIFT, 154);
   _actionMap[176][SELECT] = ActionEntry(SHIFT, 34);
   _jumpMap[176][ObjSpec] = 121;
   _jumpMap[176][Constant] = 120;
   _jumpMap[176][SignedFloat] = 119;
   _jumpMap[176][SignedInt] = 118;
   _jumpMap[176][Attribute] = 117;
   _jumpMap[176][Function] = 116;
   _jumpMap[176][SelectStatement] = 331;
   _jumpMap[176][CasePrepare] = 115;
   _jumpMap[176][CaseClause] = 114;
   _jumpMap[176][Factor] = 113;
   _jumpMap[176][Term] = 112;
   _jumpMap[176][Expr] = 330;
   _actionMap[177][FLOATVAL] = ActionEntry(SHIFT, 340);
   _actionMap[177][INTVAL] = ActionEntry(SHIFT, 339);
   _actionMap[178][WHEN] = ActionEntry(REDUCE, 404);
   _actionMap[178][ELSE] = ActionEntry(REDUCE, 404);
   _actionMap[178][LEFT] = ActionEntry(REDUCE, 404);
   _actionMap[178][RIGHT] = ActionEntry(REDUCE, 404);
   _actionMap[178][INNER] = ActionEntry(REDUCE, 404);
   _actionMap[178][JOIN] = ActionEntry(REDUCE, 404);
   _actionMap[178][RETURNTOKEN] = ActionEntry(REDUCE, 404);
   _actionMap[178][ORDER] = ActionEntry(REDUCE, 404);
   _actionMap[178][GROUP] = ActionEntry(REDUCE, 404);
   _actionMap[178][WHERE] = ActionEntry(REDUCE, 404);
   _actionMap[178][AS] = ActionEntry(REDUCE, 404);
   _actionMap[178][FROM] = ActionEntry(REDUCE, 404);
   _actionMap[178][END_TOKEN] = ActionEntry(REDUCE, 404);
   _actionMap[178][BEGIN] = ActionEntry(REDUCE, 404);
   _actionMap[178][THEN] = ActionEntry(REDUCE, 404);
   _actionMap[178][OR] = ActionEntry(REDUCE, 404);
   _actionMap[178][AND] = ActionEntry(REDUCE, 404);
   _actionMap[178][NULLTOKEN] = ActionEntry(REDUCE, 404);
   _actionMap[178][LIKE] = ActionEntry(REDUCE, 404);
   _actionMap[178][IS] = ActionEntry(REDUCE, 404);
   _actionMap[178][BETWEEN] = ActionEntry(REDUCE, 404);
   _actionMap[178][NOT] = ActionEntry(REDUCE, 404);
   _actionMap[178][INTOK] = ActionEntry(REDUCE, 404);
   _actionMap[178][EQU] = ActionEntry(REDUCE, 404);
   _actionMap[178][NEGATION] = ActionEntry(REDUCE, 404);
   _actionMap[178][LT] = ActionEntry(REDUCE, 404);
   _actionMap[178][MT] = ActionEntry(REDUCE, 404);
   _actionMap[178][DESC] = ActionEntry(REDUCE, 404);
   _actionMap[178][ASC] = ActionEntry(REDUCE, 404);
   _actionMap[178][KSEP] = ActionEntry(REDUCE, 404);
   _actionMap[178][ROWLIMIT] = ActionEntry(REDUCE, 404);
   _actionMap[178][UNION] = ActionEntry(REDUCE, 404);
   _actionMap[178][ENDTOKEN] = ActionEntry(REDUCE, 404);
}
void Cego::loadParser287()
{
   _actionMap[178][RB] = ActionEntry(REDUCE, 404);
   _actionMap[178][SEMICOLON] = ActionEntry(REDUCE, 404);
   _actionMap[178][CONCAT] = ActionEntry(REDUCE, 404);
   _actionMap[178][STAR] = ActionEntry(REDUCE, 404);
   _actionMap[178][DIVISION] = ActionEntry(REDUCE, 404);
   _actionMap[178][MINUS] = ActionEntry(REDUCE, 404);
   _actionMap[178][PLUS] = ActionEntry(REDUCE, 404);
   _actionMap[179][WHEN] = ActionEntry(REDUCE, 406);
   _actionMap[179][ELSE] = ActionEntry(REDUCE, 406);
   _actionMap[179][LEFT] = ActionEntry(REDUCE, 406);
   _actionMap[179][RIGHT] = ActionEntry(REDUCE, 406);
   _actionMap[179][INNER] = ActionEntry(REDUCE, 406);
   _actionMap[179][JOIN] = ActionEntry(REDUCE, 406);
   _actionMap[179][RETURNTOKEN] = ActionEntry(REDUCE, 406);
   _actionMap[179][ORDER] = ActionEntry(REDUCE, 406);
   _actionMap[179][GROUP] = ActionEntry(REDUCE, 406);
   _actionMap[179][WHERE] = ActionEntry(REDUCE, 406);
   _actionMap[179][AS] = ActionEntry(REDUCE, 406);
   _actionMap[179][FROM] = ActionEntry(REDUCE, 406);
   _actionMap[179][END_TOKEN] = ActionEntry(REDUCE, 406);
   _actionMap[179][BEGIN] = ActionEntry(REDUCE, 406);
   _actionMap[179][THEN] = ActionEntry(REDUCE, 406);
   _actionMap[179][OR] = ActionEntry(REDUCE, 406);
   _actionMap[179][AND] = ActionEntry(REDUCE, 406);
   _actionMap[179][NULLTOKEN] = ActionEntry(REDUCE, 406);
   _actionMap[179][LIKE] = ActionEntry(REDUCE, 406);
   _actionMap[179][IS] = ActionEntry(REDUCE, 406);
   _actionMap[179][BETWEEN] = ActionEntry(REDUCE, 406);
   _actionMap[179][NOT] = ActionEntry(REDUCE, 406);
   _actionMap[179][INTOK] = ActionEntry(REDUCE, 406);
   _actionMap[179][EQU] = ActionEntry(REDUCE, 406);
   _actionMap[179][NEGATION] = ActionEntry(REDUCE, 406);
   _actionMap[179][LT] = ActionEntry(REDUCE, 406);
   _actionMap[179][MT] = ActionEntry(REDUCE, 406);
   _actionMap[179][DESC] = ActionEntry(REDUCE, 406);
   _actionMap[179][ASC] = ActionEntry(REDUCE, 406);
   _actionMap[179][KSEP] = ActionEntry(REDUCE, 406);
   _actionMap[179][ROWLIMIT] = ActionEntry(REDUCE, 406);
   _actionMap[179][UNION] = ActionEntry(REDUCE, 406);
   _actionMap[179][ENDTOKEN] = ActionEntry(REDUCE, 406);
   _actionMap[179][RB] = ActionEntry(REDUCE, 406);
   _actionMap[179][SEMICOLON] = ActionEntry(REDUCE, 406);
   _actionMap[179][CONCAT] = ActionEntry(REDUCE, 406);
   _actionMap[179][STAR] = ActionEntry(REDUCE, 406);
   _actionMap[179][DIVISION] = ActionEntry(REDUCE, 406);
   _actionMap[179][MINUS] = ActionEntry(REDUCE, 406);
   _actionMap[179][PLUS] = ActionEntry(REDUCE, 406);
   _actionMap[180][WHEN] = ActionEntry(REDUCE, 401);
   _actionMap[180][ELSE] = ActionEntry(REDUCE, 401);
   _actionMap[180][LEFT] = ActionEntry(REDUCE, 401);
}
void Cego::loadParser288()
{
   _actionMap[180][RIGHT] = ActionEntry(REDUCE, 401);
   _actionMap[180][INNER] = ActionEntry(REDUCE, 401);
   _actionMap[180][JOIN] = ActionEntry(REDUCE, 401);
   _actionMap[180][RETURNTOKEN] = ActionEntry(REDUCE, 401);
   _actionMap[180][ORDER] = ActionEntry(REDUCE, 401);
   _actionMap[180][GROUP] = ActionEntry(REDUCE, 401);
   _actionMap[180][WHERE] = ActionEntry(REDUCE, 401);
   _actionMap[180][FROM] = ActionEntry(REDUCE, 401);
   _actionMap[180][AS] = ActionEntry(REDUCE, 401);
   _actionMap[180][END_TOKEN] = ActionEntry(REDUCE, 401);
   _actionMap[180][BEGIN] = ActionEntry(REDUCE, 401);
   _actionMap[180][THEN] = ActionEntry(REDUCE, 401);
   _actionMap[180][OR] = ActionEntry(REDUCE, 401);
   _actionMap[180][AND] = ActionEntry(REDUCE, 401);
   _actionMap[180][INTOK] = ActionEntry(REDUCE, 401);
   _actionMap[180][NOT] = ActionEntry(REDUCE, 401);
   _actionMap[180][BETWEEN] = ActionEntry(REDUCE, 401);
   _actionMap[180][IS] = ActionEntry(REDUCE, 401);
   _actionMap[180][LIKE] = ActionEntry(REDUCE, 401);
   _actionMap[180][MT] = ActionEntry(REDUCE, 401);
   _actionMap[180][LT] = ActionEntry(REDUCE, 401);
   _actionMap[180][NEGATION] = ActionEntry(REDUCE, 401);
   _actionMap[180][EQU] = ActionEntry(REDUCE, 401);
   _actionMap[180][RB] = ActionEntry(REDUCE, 401);
   _actionMap[180][ENDTOKEN] = ActionEntry(REDUCE, 401);
   _actionMap[180][UNION] = ActionEntry(REDUCE, 401);
   _actionMap[180][ROWLIMIT] = ActionEntry(REDUCE, 401);
   _actionMap[180][KSEP] = ActionEntry(REDUCE, 401);
   _actionMap[180][ASC] = ActionEntry(REDUCE, 401);
   _actionMap[180][DESC] = ActionEntry(REDUCE, 401);
   _actionMap[180][SEMICOLON] = ActionEntry(REDUCE, 401);
   _actionMap[180][PLUS] = ActionEntry(REDUCE, 401);
   _actionMap[180][MINUS] = ActionEntry(REDUCE, 401);
   _actionMap[180][LB] = ActionEntry(REDUCE, 427);
   _actionMap[180][DIVISION] = ActionEntry(REDUCE, 401);
   _actionMap[180][STAR] = ActionEntry(REDUCE, 401);
   _actionMap[180][CONCAT] = ActionEntry(REDUCE, 401);
   _actionMap[181][WHEN] = ActionEntry(REDUCE, 177);
   _actionMap[181][ELSE] = ActionEntry(REDUCE, 177);
   _actionMap[181][LEFT] = ActionEntry(REDUCE, 177);
   _actionMap[181][RIGHT] = ActionEntry(REDUCE, 177);
   _actionMap[181][INNER] = ActionEntry(REDUCE, 177);
   _actionMap[181][JOIN] = ActionEntry(REDUCE, 177);
   _actionMap[181][RETURNTOKEN] = ActionEntry(REDUCE, 177);
   _actionMap[181][ORDER] = ActionEntry(REDUCE, 177);
   _actionMap[181][GROUP] = ActionEntry(REDUCE, 177);
   _actionMap[181][WHERE] = ActionEntry(REDUCE, 177);
   _actionMap[181][AS] = ActionEntry(REDUCE, 177);
   _actionMap[181][FROM] = ActionEntry(REDUCE, 177);
   _actionMap[181][END_TOKEN] = ActionEntry(REDUCE, 177);
}
void Cego::loadParser289()
{
   _actionMap[181][BEGIN] = ActionEntry(REDUCE, 177);
   _actionMap[181][THEN] = ActionEntry(REDUCE, 177);
   _actionMap[181][OR] = ActionEntry(REDUCE, 177);
   _actionMap[181][AND] = ActionEntry(REDUCE, 177);
   _actionMap[181][LIKE] = ActionEntry(REDUCE, 177);
   _actionMap[181][IS] = ActionEntry(REDUCE, 177);
   _actionMap[181][BETWEEN] = ActionEntry(REDUCE, 177);
   _actionMap[181][NOT] = ActionEntry(REDUCE, 177);
   _actionMap[181][INTOK] = ActionEntry(REDUCE, 177);
   _actionMap[181][EQU] = ActionEntry(REDUCE, 177);
   _actionMap[181][NEGATION] = ActionEntry(REDUCE, 177);
   _actionMap[181][LT] = ActionEntry(REDUCE, 177);
   _actionMap[181][MT] = ActionEntry(REDUCE, 177);
   _actionMap[181][DESC] = ActionEntry(REDUCE, 177);
   _actionMap[181][ASC] = ActionEntry(REDUCE, 177);
   _actionMap[181][KSEP] = ActionEntry(REDUCE, 177);
   _actionMap[181][ROWLIMIT] = ActionEntry(REDUCE, 177);
   _actionMap[181][UNION] = ActionEntry(REDUCE, 177);
   _actionMap[181][ENDTOKEN] = ActionEntry(REDUCE, 177);
   _actionMap[181][RB] = ActionEntry(REDUCE, 177);
   _actionMap[181][SEMICOLON] = ActionEntry(REDUCE, 177);
   _actionMap[181][CONCAT] = ActionEntry(REDUCE, 177);
   _actionMap[181][STAR] = ActionEntry(REDUCE, 177);
   _actionMap[181][DIVISION] = ActionEntry(REDUCE, 177);
   _actionMap[181][MINUS] = ActionEntry(REDUCE, 177);
   _actionMap[181][PLUS] = ActionEntry(REDUCE, 177);
   _actionMap[182][WHEN] = ActionEntry(REDUCE, 402);
   _actionMap[182][ELSE] = ActionEntry(REDUCE, 402);
   _actionMap[182][LEFT] = ActionEntry(REDUCE, 402);
   _actionMap[182][RIGHT] = ActionEntry(REDUCE, 402);
   _actionMap[182][INNER] = ActionEntry(REDUCE, 402);
   _actionMap[182][JOIN] = ActionEntry(REDUCE, 402);
   _actionMap[182][RETURNTOKEN] = ActionEntry(REDUCE, 402);
   _actionMap[182][ORDER] = ActionEntry(REDUCE, 402);
   _actionMap[182][GROUP] = ActionEntry(REDUCE, 402);
   _actionMap[182][WHERE] = ActionEntry(REDUCE, 402);
   _actionMap[182][FROM] = ActionEntry(REDUCE, 402);
   _actionMap[182][AS] = ActionEntry(REDUCE, 402);
   _actionMap[182][END_TOKEN] = ActionEntry(REDUCE, 402);
   _actionMap[182][BEGIN] = ActionEntry(REDUCE, 402);
   _actionMap[182][THEN] = ActionEntry(REDUCE, 402);
   _actionMap[182][OR] = ActionEntry(REDUCE, 402);
   _actionMap[182][AND] = ActionEntry(REDUCE, 402);
   _actionMap[182][INTOK] = ActionEntry(REDUCE, 402);
   _actionMap[182][NOT] = ActionEntry(REDUCE, 402);
   _actionMap[182][BETWEEN] = ActionEntry(REDUCE, 402);
   _actionMap[182][IS] = ActionEntry(REDUCE, 402);
   _actionMap[182][LIKE] = ActionEntry(REDUCE, 402);
   _actionMap[182][MT] = ActionEntry(REDUCE, 402);
   _actionMap[182][LT] = ActionEntry(REDUCE, 402);
}
void Cego::loadParser290()
{
   _actionMap[182][NEGATION] = ActionEntry(REDUCE, 402);
   _actionMap[182][EQU] = ActionEntry(REDUCE, 402);
   _actionMap[182][RB] = ActionEntry(REDUCE, 402);
   _actionMap[182][ENDTOKEN] = ActionEntry(REDUCE, 402);
   _actionMap[182][UNION] = ActionEntry(REDUCE, 402);
   _actionMap[182][ROWLIMIT] = ActionEntry(REDUCE, 402);
   _actionMap[182][KSEP] = ActionEntry(REDUCE, 402);
   _actionMap[182][ASC] = ActionEntry(REDUCE, 402);
   _actionMap[182][DESC] = ActionEntry(REDUCE, 402);
   _actionMap[182][SEMICOLON] = ActionEntry(REDUCE, 402);
   _actionMap[182][PLUS] = ActionEntry(REDUCE, 402);
   _actionMap[182][MINUS] = ActionEntry(REDUCE, 402);
   _actionMap[182][LB] = ActionEntry(REDUCE, 428);
   _actionMap[182][DIVISION] = ActionEntry(REDUCE, 402);
   _actionMap[182][STAR] = ActionEntry(REDUCE, 402);
   _actionMap[182][CONCAT] = ActionEntry(REDUCE, 402);
   _actionMap[183][STAR] = ActionEntry(SHIFT, 341);
   _actionMap[184][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[184][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[184][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[184][ObjSpec] = 342;
   _actionMap[185][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[185][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[185][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[185][ObjSpec] = 343;
   _actionMap[186][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[186][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[186][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[186][ObjSpec] = 344;
   _actionMap[187][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[187][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[187][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[187][ObjSpec] = 345;
   _actionMap[188][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[188][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[188][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[188][ObjSpec] = 346;
   _actionMap[189][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[189][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[189][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[189][ObjSpec] = 347;
   _actionMap[190][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[190][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[190][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[190][ObjSpec] = 348;
   _actionMap[191][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[191][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[191][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[191][ObjSpec] = 349;
   _actionMap[192][IDENTIFIER] = ActionEntry(SHIFT, 62);
}
void Cego::loadParser291()
{
   _actionMap[192][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[192][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[192][ObjSpec] = 350;
   _actionMap[193][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[193][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[193][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[193][ObjSpec] = 351;
   _actionMap[194][SEMICOLON] = ActionEntry(REDUCE, 239);
   _actionMap[194][FROM] = ActionEntry(SHIFT, 354);
   _actionMap[194][RB] = ActionEntry(REDUCE, 239);
   _jumpMap[194][NoFromOption] = 353;
   _jumpMap[194][FromOption] = 352;
   _actionMap[195][FLOATVAL] = ActionEntry(SHIFT, 179);
   _actionMap[195][MINUS] = ActionEntry(SHIFT, 177);
   _actionMap[195][INTVAL] = ActionEntry(SHIFT, 178);
   _actionMap[195][INT2ASC] = ActionEntry(SHIFT, 146);
   _actionMap[195][ASC2INT] = ActionEntry(SHIFT, 123);
   _actionMap[195][TRIM] = ActionEntry(SHIFT, 172);
   _actionMap[195][RTRIM] = ActionEntry(SHIFT, 164);
   _actionMap[195][LTRIM] = ActionEntry(SHIFT, 152);
   _actionMap[195][ROUND] = ActionEntry(SHIFT, 163);
   _actionMap[195][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[195][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[195][LONG2DATE] = ActionEntry(SHIFT, 144);
   _actionMap[195][NEWDATE] = ActionEntry(SHIFT, 145);
   _actionMap[195][LOWER] = ActionEntry(SHIFT, 151);
   _actionMap[195][UPPER] = ActionEntry(SHIFT, 175);
   _actionMap[195][LEFT] = ActionEntry(SHIFT, 147);
   _actionMap[195][RIGHT] = ActionEntry(SHIFT, 162);
   _actionMap[195][GETPOS] = ActionEntry(SHIFT, 143);
   _actionMap[195][SUBSTR] = ActionEntry(SHIFT, 166);
   _actionMap[195][REPLACE] = ActionEntry(SHIFT, 161);
   _actionMap[195][LENGTH] = ActionEntry(SHIFT, 148);
   _actionMap[195][TRUNC] = ActionEntry(SHIFT, 174);
   _actionMap[195][STR2INT] = ActionEntry(SHIFT, 169);
   _actionMap[195][STR2LONG] = ActionEntry(SHIFT, 170);
   _actionMap[195][STR2DATE] = ActionEntry(SHIFT, 171);
   _actionMap[195][RANDSTR] = ActionEntry(SHIFT, 159);
   _actionMap[195][RANDINT] = ActionEntry(SHIFT, 160);
   _actionMap[195][MOD] = ActionEntry(SHIFT, 155);
   _actionMap[195][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[195][LMOD] = ActionEntry(SHIFT, 150);
   _actionMap[195][LDIV] = ActionEntry(SHIFT, 149);
   _actionMap[195][POWER] = ActionEntry(SHIFT, 158);
   _actionMap[195][BITAND] = ActionEntry(SHIFT, 125);
   _actionMap[195][BITOR] = ActionEntry(SHIFT, 126);
   _actionMap[195][BITXOR] = ActionEntry(SHIFT, 127);
   _actionMap[195][BLOBSIZE] = ActionEntry(SHIFT, 129);
   _actionMap[195][BLOBREF] = ActionEntry(SHIFT, 130);
   _actionMap[195][CLOBSIZE] = ActionEntry(SHIFT, 133);
}
void Cego::loadParser292()
{
   _actionMap[195][CLOBREF] = ActionEntry(SHIFT, 134);
   _actionMap[195][CLOB2STR] = ActionEntry(SHIFT, 135);
   _actionMap[195][NEXTCOUNT] = ActionEntry(SHIFT, 156);
   _actionMap[195][SETCOUNT] = ActionEntry(SHIFT, 165);
   _actionMap[195][IDENTIFIER] = ActionEntry(SHIFT, 180);
   _actionMap[195][QUALIFIEDOBJ] = ActionEntry(SHIFT, 182);
   _actionMap[195][QUALIFIEDPRE] = ActionEntry(SHIFT, 183);
   _actionMap[195][LB] = ActionEntry(SHIFT, 176);
   _actionMap[195][STRINGVAL] = ActionEntry(SHIFT, 122);
   _actionMap[195][DATE] = ActionEntry(SHIFT, 137);
   _actionMap[195][SYSDATE] = ActionEntry(SHIFT, 168);
   _actionMap[195][NULLTOKEN] = ActionEntry(SHIFT, 157);
   _actionMap[195][TRUEVAL] = ActionEntry(SHIFT, 173);
   _actionMap[195][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[195][BLOB] = ActionEntry(SHIFT, 128);
   _actionMap[195][CLOB] = ActionEntry(SHIFT, 132);
   _actionMap[195][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[195][CASE] = ActionEntry(SHIFT, 131);
   _actionMap[195][VARREF] = ActionEntry(SHIFT, 181);
   _actionMap[195][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[195][COUNT] = ActionEntry(SHIFT, 136);
   _actionMap[195][SUM] = ActionEntry(SHIFT, 167);
   _actionMap[195][AVG] = ActionEntry(SHIFT, 124);
   _actionMap[195][MIN] = ActionEntry(SHIFT, 153);
   _actionMap[195][MAX] = ActionEntry(SHIFT, 154);
   _jumpMap[195][ObjSpec] = 121;
   _jumpMap[195][Constant] = 120;
   _jumpMap[195][SignedFloat] = 119;
   _jumpMap[195][SignedInt] = 118;
   _jumpMap[195][Attribute] = 117;
   _jumpMap[195][Function] = 116;
   _jumpMap[195][SelectItem] = 357;
   _jumpMap[195][SelectionList] = 356;
   _jumpMap[195][CasePrepare] = 115;
   _jumpMap[195][CaseClause] = 114;
   _jumpMap[195][Factor] = 113;
   _jumpMap[195][Term] = 112;
   _jumpMap[195][Expr] = 355;
   _actionMap[196][VARREF] = ActionEntry(REDUCE, 283);
   _actionMap[196][FETCH] = ActionEntry(REDUCE, 283);
   _actionMap[196][LB] = ActionEntry(REDUCE, 283);
   _actionMap[196][COUNT] = ActionEntry(REDUCE, 283);
   _actionMap[196][SUM] = ActionEntry(REDUCE, 283);
   _actionMap[196][AVG] = ActionEntry(REDUCE, 283);
   _actionMap[196][MIN] = ActionEntry(REDUCE, 283);
   _actionMap[196][MAX] = ActionEntry(REDUCE, 283);
   _actionMap[196][CASE] = ActionEntry(REDUCE, 283);
   _actionMap[196][INT2ASC] = ActionEntry(REDUCE, 283);
   _actionMap[196][ASC2INT] = ActionEntry(REDUCE, 283);
   _actionMap[196][TRIM] = ActionEntry(REDUCE, 283);
}
void Cego::loadParser293()
{
   _actionMap[196][RTRIM] = ActionEntry(REDUCE, 283);
   _actionMap[196][LTRIM] = ActionEntry(REDUCE, 283);
   _actionMap[196][ROUND] = ActionEntry(REDUCE, 283);
   _actionMap[196][DATE2STR] = ActionEntry(REDUCE, 283);
   _actionMap[196][DATE2LONG] = ActionEntry(REDUCE, 283);
   _actionMap[196][LONG2DATE] = ActionEntry(REDUCE, 283);
   _actionMap[196][NEWDATE] = ActionEntry(REDUCE, 283);
   _actionMap[196][LOWER] = ActionEntry(REDUCE, 283);
   _actionMap[196][UPPER] = ActionEntry(REDUCE, 283);
   _actionMap[196][LEFT] = ActionEntry(REDUCE, 283);
   _actionMap[196][RIGHT] = ActionEntry(REDUCE, 283);
   _actionMap[196][GETPOS] = ActionEntry(REDUCE, 283);
   _actionMap[196][SUBSTR] = ActionEntry(REDUCE, 283);
   _actionMap[196][REPLACE] = ActionEntry(REDUCE, 283);
   _actionMap[196][LENGTH] = ActionEntry(REDUCE, 283);
   _actionMap[196][TRUNC] = ActionEntry(REDUCE, 283);
   _actionMap[196][STR2INT] = ActionEntry(REDUCE, 283);
   _actionMap[196][STR2LONG] = ActionEntry(REDUCE, 283);
   _actionMap[196][STR2DATE] = ActionEntry(REDUCE, 283);
   _actionMap[196][RANDSTR] = ActionEntry(REDUCE, 283);
   _actionMap[196][RANDINT] = ActionEntry(REDUCE, 283);
   _actionMap[196][MOD] = ActionEntry(REDUCE, 283);
   _actionMap[196][DIV] = ActionEntry(REDUCE, 283);
   _actionMap[196][LMOD] = ActionEntry(REDUCE, 283);
   _actionMap[196][LDIV] = ActionEntry(REDUCE, 283);
   _actionMap[196][POWER] = ActionEntry(REDUCE, 283);
   _actionMap[196][BITAND] = ActionEntry(REDUCE, 283);
   _actionMap[196][BITOR] = ActionEntry(REDUCE, 283);
   _actionMap[196][BITXOR] = ActionEntry(REDUCE, 283);
   _actionMap[196][BLOBSIZE] = ActionEntry(REDUCE, 283);
   _actionMap[196][BLOBREF] = ActionEntry(REDUCE, 283);
   _actionMap[196][CLOBSIZE] = ActionEntry(REDUCE, 283);
   _actionMap[196][CLOBREF] = ActionEntry(REDUCE