--
-- ### Cursor & Query Cache
-- 
-- 
--

drop if exists table sysmt_mtapproval;
create table sysmt_mtapproval ( mid int, bgid int, status string(100));

drop if exists table sysmt_srv2approval;
create table sysmt_srv2approval ( srvid int, bgid int);

insert into sysmt_srv2approval values ( 42, 1 );
insert into sysmt_srv2approval values ( 42, 2 );
insert into sysmt_srv2approval values ( 42, 3 );


drop if exists procedure resetApproval;
@
create procedure resetApproval(mid in int)
begin

   var bgid int;

   delete from sysmt_mtapproval where mid = :mid;

   cursor agCur as select bgid as bgid from sysmt_srv2approval
                     where srvid = 42;
   while fetch agCur into (:bgid) = true
   begin
         insert into sysmt_mtapproval ( mid, bgid, status ) values (:mid, :bgid, 'Requested');
   end;
   close agCur;

end;
@

call resetApproval(1);

drop if exists table bgidcheck;
create table bgidcheck ( bgid int not null );
insert into bgidcheck select bgid as bgid from sysmt_srv2approval where srvid = 42;
