﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/cloudformation/CloudFormation_EXPORTS.h>
#include <aws/cloudformation/CloudFormationRequest.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
namespace CloudFormation
{
namespace Model
{

  /**
   */
  class DescribeTypeRegistrationRequest : public CloudFormationRequest
  {
  public:
    AWS_CLOUDFORMATION_API DescribeTypeRegistrationRequest();

    // Service request name is the Operation name which will send this request out,
    // each operation should has unique request name, so that we can get operation's name from this request.
    // Note: this is not true for response, multiple operations may have the same response name,
    // so we can not get operation's name from response.
    inline virtual const char* GetServiceRequestName() const override { return "DescribeTypeRegistration"; }

    AWS_CLOUDFORMATION_API Aws::String SerializePayload() const override;

  protected:
    AWS_CLOUDFORMATION_API void DumpBodyToUrl(Aws::Http::URI& uri ) const override;

  public:

    ///@{
    /**
     * <p>The identifier for this registration request.</p> <p>This registration token
     * is generated by CloudFormation when you initiate a registration request using
     * <a>RegisterType</a>.</p>
     */
    inline const Aws::String& GetRegistrationToken() const{ return m_registrationToken; }
    inline bool RegistrationTokenHasBeenSet() const { return m_registrationTokenHasBeenSet; }
    inline void SetRegistrationToken(const Aws::String& value) { m_registrationTokenHasBeenSet = true; m_registrationToken = value; }
    inline void SetRegistrationToken(Aws::String&& value) { m_registrationTokenHasBeenSet = true; m_registrationToken = std::move(value); }
    inline void SetRegistrationToken(const char* value) { m_registrationTokenHasBeenSet = true; m_registrationToken.assign(value); }
    inline DescribeTypeRegistrationRequest& WithRegistrationToken(const Aws::String& value) { SetRegistrationToken(value); return *this;}
    inline DescribeTypeRegistrationRequest& WithRegistrationToken(Aws::String&& value) { SetRegistrationToken(std::move(value)); return *this;}
    inline DescribeTypeRegistrationRequest& WithRegistrationToken(const char* value) { SetRegistrationToken(value); return *this;}
    ///@}
  private:

    Aws::String m_registrationToken;
    bool m_registrationTokenHasBeenSet = false;
  };

} // namespace Model
} // namespace CloudFormation
} // namespace Aws
