﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/chime/Chime_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/chime/model/InviteStatus.h>
#include <aws/chime/model/EmailStatus.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace Chime
{
namespace Model
{

  /**
   * <p>Invitation object returned after emailing users to invite them to join the
   * Amazon Chime <code>Team</code> account.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/Invite">AWS API
   * Reference</a></p>
   */
  class Invite
  {
  public:
    AWS_CHIME_API Invite();
    AWS_CHIME_API Invite(Aws::Utils::Json::JsonView jsonValue);
    AWS_CHIME_API Invite& operator=(Aws::Utils::Json::JsonView jsonValue);
    AWS_CHIME_API Aws::Utils::Json::JsonValue Jsonize() const;


    ///@{
    /**
     * <p>The invite ID.</p>
     */
    inline const Aws::String& GetInviteId() const{ return m_inviteId; }
    inline bool InviteIdHasBeenSet() const { return m_inviteIdHasBeenSet; }
    inline void SetInviteId(const Aws::String& value) { m_inviteIdHasBeenSet = true; m_inviteId = value; }
    inline void SetInviteId(Aws::String&& value) { m_inviteIdHasBeenSet = true; m_inviteId = std::move(value); }
    inline void SetInviteId(const char* value) { m_inviteIdHasBeenSet = true; m_inviteId.assign(value); }
    inline Invite& WithInviteId(const Aws::String& value) { SetInviteId(value); return *this;}
    inline Invite& WithInviteId(Aws::String&& value) { SetInviteId(std::move(value)); return *this;}
    inline Invite& WithInviteId(const char* value) { SetInviteId(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The status of the invite.</p>
     */
    inline const InviteStatus& GetStatus() const{ return m_status; }
    inline bool StatusHasBeenSet() const { return m_statusHasBeenSet; }
    inline void SetStatus(const InviteStatus& value) { m_statusHasBeenSet = true; m_status = value; }
    inline void SetStatus(InviteStatus&& value) { m_statusHasBeenSet = true; m_status = std::move(value); }
    inline Invite& WithStatus(const InviteStatus& value) { SetStatus(value); return *this;}
    inline Invite& WithStatus(InviteStatus&& value) { SetStatus(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The email address to which the invite is sent.</p>
     */
    inline const Aws::String& GetEmailAddress() const{ return m_emailAddress; }
    inline bool EmailAddressHasBeenSet() const { return m_emailAddressHasBeenSet; }
    inline void SetEmailAddress(const Aws::String& value) { m_emailAddressHasBeenSet = true; m_emailAddress = value; }
    inline void SetEmailAddress(Aws::String&& value) { m_emailAddressHasBeenSet = true; m_emailAddress = std::move(value); }
    inline void SetEmailAddress(const char* value) { m_emailAddressHasBeenSet = true; m_emailAddress.assign(value); }
    inline Invite& WithEmailAddress(const Aws::String& value) { SetEmailAddress(value); return *this;}
    inline Invite& WithEmailAddress(Aws::String&& value) { SetEmailAddress(std::move(value)); return *this;}
    inline Invite& WithEmailAddress(const char* value) { SetEmailAddress(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The status of the invite email.</p>
     */
    inline const EmailStatus& GetEmailStatus() const{ return m_emailStatus; }
    inline bool EmailStatusHasBeenSet() const { return m_emailStatusHasBeenSet; }
    inline void SetEmailStatus(const EmailStatus& value) { m_emailStatusHasBeenSet = true; m_emailStatus = value; }
    inline void SetEmailStatus(EmailStatus&& value) { m_emailStatusHasBeenSet = true; m_emailStatus = std::move(value); }
    inline Invite& WithEmailStatus(const EmailStatus& value) { SetEmailStatus(value); return *this;}
    inline Invite& WithEmailStatus(EmailStatus&& value) { SetEmailStatus(std::move(value)); return *this;}
    ///@}
  private:

    Aws::String m_inviteId;
    bool m_inviteIdHasBeenSet = false;

    InviteStatus m_status;
    bool m_statusHasBeenSet = false;

    Aws::String m_emailAddress;
    bool m_emailAddressHasBeenSet = false;

    EmailStatus m_emailStatus;
    bool m_emailStatusHasBeenSet = false;
  };

} // namespace Model
} // namespace Chime
} // namespace Aws
