#pragma once

/* <editor-fold desc="MIT License">

Copyright(c) 2018 Robert Osfield

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

</editor-fold> */

#include <vsg/core/Data.h>
#include <vsg/state/StateCommand.h>
#include <vsg/vk/Device.h>

namespace vsg
{

    /// PushConstants state command encapsulates vkCmdPushConstants functionality
    class VSG_DECLSPEC PushConstants : public Inherit<StateCommand, PushConstants>
    {
    public:
        PushConstants();
        PushConstants(VkShaderStageFlags in_shaderFlags, uint32_t in_offset, Data* in_data);

        VkShaderStageFlags stageFlags = 0;
        uint32_t offset = 0;
        ref_ptr<Data> data;

        void record(CommandBuffer& commandBuffer) const override;

    public:
        void read(Input& input) override;
        void write(Output& output) const override;

    protected:
        virtual ~PushConstants();
    };
    VSG_type_name(vsg::PushConstants);

} // namespace vsg
