﻿!mod$ v1 sum:703c1f3e4ae4e73a
!need$ f1b4423f2906c0b3 n kinds
module dvscf_interpolate
use kinds,only:dp
logical(4),save::ldvscf_interpolate
logical(4),save::do_long_range
logical(4),save::do_charge_neutral
character(256_4,1),save::wpot_dir
logical(4),save::shift_half(1_8:3_8)
logical(4),save::qrpl
integer(4),save::nrtot
integer(4),save::nrlocal
integer(4),save::nrbase
integer(4),save::lrwpot
integer(4),allocatable,save::iunwpot(:)
integer(4),allocatable,save::rlatt(:,:)
real(8),save::epsilon_r2q(1_8:3_8,1_8:3_8)
real(8),allocatable,save::zeu_r2q(:,:,:)
real(8),allocatable,save::qmat(:,:,:,:)
contains
subroutine read_quadrupole_fmt(filename,nat,qrpl,qmat,verbose)
character(*,1),intent(in)::filename
integer(4),intent(in)::nat
logical(4),intent(inout)::qrpl
real(8),allocatable,intent(inout)::qmat(:,:,:,:)
logical(4),intent(in)::verbose
end
subroutine write_quadrupole_fmt(filename,nat,qmat)
character(*,1),intent(in)::filename
integer(4),intent(in)::nat
real(8),intent(in)::qmat(1_8:int(nat,kind=8),1_8:3_8,1_8:3_8,1_8:3_8)
end
subroutine dvscf_interpol_setup()
end
subroutine dvscf_r2q(xq,u_in,dvscf)
use modes,only:nmodes
use fft_base,only:dfftp
use noncollin_module,only:nspin_mag
real(8),intent(in)::xq(1_8:3_8)
complex(8),intent(in)::u_in(1_8:int(nmodes,kind=8),1_8:int(nmodes,kind=8))
complex(8)::dvscf(1_8:int(dfftp%nnr,kind=8),1_8:int(nspin_mag,kind=8),1_8:int(nmodes,kind=8))
end
subroutine dvscf_interpol_close()
end
subroutine dvscf_shift_center(dvscf_q,xq,shift_half,sign)
use fft_base,only:dfftp
use noncollin_module,only:nspin_mag
use ions_base,only:nat
complex(8),intent(inout)::dvscf_q(1_8:int(dfftp%nnr,kind=8),1_8:int(nspin_mag,kind=8),1_8:int(3_4*nat,kind=8))
real(8),intent(in)::xq(1_8:3_8)
logical(4),intent(in)::shift_half(1_8:3_8)
integer(4),intent(in)::sign
end
subroutine dvscf_long_range(xq,zeu,epsilon,dvscf_long,qmat)
use ions_base,only:nat
use fft_base,only:dfftp
use noncollin_module,only:nspin_mag
real(8),intent(in)::xq(1_8:3_8)
real(8),intent(in)::zeu(1_8:3_8,1_8:3_8,1_8:int(nat,kind=8))
real(8),intent(in)::epsilon(1_8:3_8,1_8:3_8)
complex(8)::dvscf_long(1_8:int(dfftp%nnr,kind=8),1_8:int(nspin_mag,kind=8),1_8:int(3_4*nat,kind=8))
real(8),intent(in),optional::qmat(1_8:int(nat,kind=8),1_8:3_8,1_8:3_8,1_8:3_8)
end
subroutine dvscf_bare_calc(xq,dvscf_bare,addnlcc)
use fft_base,only:dfftp
use noncollin_module,only:nspin_mag
use ions_base,only:nat
real(8),intent(in)::xq(1_8:3_8)
complex(8)::dvscf_bare(1_8:int(dfftp%nnr,kind=8),1_8:int(nspin_mag,kind=8),1_8:int(3_4*nat,kind=8))
logical(4),intent(in)::addnlcc
end
subroutine multiply_iqr(dfft,xq,func)
use fft_types,only:fft_type_descriptor
type(fft_type_descriptor),intent(in)::dfft
real(8),intent(in)::xq(1_8:3_8)
complex(8)::func(1_8:int(dfft%nnr,kind=8))
end
end
