﻿!mod$ v1 sum:0f879fe5d35c0099
!need$ f1b4423f2906c0b3 n kinds
module bspline
use kinds,only:dp
private::dp
character(80_4,1),private::routine
character(256_4,1),private::errmsg
private::dbsdca
private::spli2d
private::spli3d
private::bsplvb
private::banfac
private::banslv
private::huntn
contains
subroutine dbsnak(nx,xvec,kxord,xknot,ierr)
integer(4),intent(in)::nx
real(8),intent(in)::xvec(1_8:int(nx,kind=8))
integer(4),intent(in)::kxord
real(8),intent(out)::xknot(1_8:int(nx+kxord,kind=8))
integer(4),intent(out)::ierr
end
subroutine dbsint(nx,xvec,xdata,kx,xknot,bcoef,ierr)
integer(4),intent(in)::nx
real(8),intent(in)::xvec(1_8:int(nx,kind=8))
real(8),intent(in)::xdata(1_8:int(nx,kind=8))
integer(4),intent(in)::kx
real(8),intent(in)::xknot(1_8:int(nx+kx,kind=8))
real(8),intent(out)::bcoef(1_8:int(nx,kind=8))
integer(4),intent(out)::ierr
end
function dbsval(x,kx,xknot,nx,bcoef,ierr)
real(8)::x
integer(4),intent(in)::kx
integer(4),intent(in)::nx
real(8),intent(in)::xknot(1_8:int(nx+kx,kind=8))
real(8),intent(in)::bcoef(1_8:int(nx,kind=8))
integer(4),intent(out)::ierr
real(8)::dbsval
end
function dbsder(iderx,x,kx,xknot,nx,bcoef,ierr)
integer(4),intent(in)::iderx
real(8),intent(in)::x
integer(4),intent(in)::kx
integer(4),intent(in)::nx
real(8),intent(in)::xknot(1_8:int(nx+kx,kind=8))
real(8),intent(in)::bcoef(1_8:int(nx,kind=8))
integer(4),intent(out)::ierr
real(8)::dbsder
end
subroutine dbs1gd(iderx,nxvec,xvec,kx,xknot,nx,bcoef,val,ierr)
integer(4),intent(in)::iderx
integer(4),intent(in)::nxvec
real(8),intent(in)::xvec(1_8:int(nxvec,kind=8))
integer(4),intent(in)::kx
integer(4),intent(in)::nx
real(8),intent(in)::xknot(1_8:int(nx+kx,kind=8))
real(8),intent(in)::bcoef(1_8:int(nx,kind=8))
real(8),intent(out)::val(1_8:int(nxvec,kind=8))
integer(4),intent(out)::ierr
end
function dbsdca(iderx,x,kx,xknot,nx,bcoef,leftx)
integer(4),intent(in)::iderx
real(8),intent(in)::x
integer(4),intent(in)::kx
integer(4),intent(in)::nx
real(8),intent(in)::xknot(1_8:int(nx+kx,kind=8))
real(8),intent(in)::bcoef(1_8:int(nx,kind=8))
integer(4)::leftx
real(8)::dbsdca
end
subroutine dbs2in(nx,xvec,ny,yvec,xydata,ldf,kx,ky,xknot,yknot,bcoef,ierr)
integer(4),intent(in)::nx
real(8),intent(in)::xvec(1_8:int(nx,kind=8))
integer(4),intent(in)::ny
real(8),intent(in)::yvec(1_8:int(ny,kind=8))
integer(4),intent(in)::ldf
real(8),intent(in)::xydata(1_8:int(ldf,kind=8),1_8:*)
integer(4),intent(in)::kx
integer(4),intent(in)::ky
real(8),intent(in)::xknot(1_8:int(nx+kx,kind=8))
real(8),intent(in)::yknot(1_8:int(ny+ky,kind=8))
real(8),intent(out)::bcoef(1_8:int(nx,kind=8),1_8:int(ny,kind=8))
integer(4),intent(out)::ierr
end
subroutine spli2d(xyvec,ld,xydata,xyknot,n,k,m,work2,work3,bcoef,ierr)
integer(4),intent(in)::n
real(8),intent(in)::xyvec(1_8:int(n,kind=8))
integer(4),intent(in)::ld
integer(4),intent(in)::m
real(8),intent(in)::xydata(1_8:int(ld,kind=8),1_8:int(m,kind=8))
integer(4),intent(in)::k
real(8),intent(in)::xyknot(1_8:int(n+k,kind=8))
real(8),intent(out)::work2(1_8:int(n,kind=8))
real(8),intent(out)::work3(1_8:int((2_4*k-1_4)*n,kind=8))
real(8),intent(out)::bcoef(1_8:int(m,kind=8),1_8:int(n,kind=8))
integer(4),intent(out)::ierr
end
function dbs2vl(x,y,kx,ky,xknot,yknot,nx,ny,bcoef,ierr)
real(8),intent(in)::x
real(8),intent(in)::y
integer(4),intent(in)::kx
integer(4),intent(in)::ky
integer(4),intent(in)::nx
real(8),intent(in)::xknot(1_8:int(nx+kx,kind=8))
integer(4),intent(in)::ny
real(8),intent(in)::yknot(1_8:int(ny+ky,kind=8))
real(8),intent(in)::bcoef(1_8:int(nx,kind=8),1_8:int(ny,kind=8))
integer(4),intent(out)::ierr
real(8)::dbs2vl
end
function dbs2dr(iderx,idery,x,y,kx,ky,xknot,yknot,nx,ny,bcoef,ierr)
integer(4),intent(in)::iderx
integer(4),intent(in)::idery
real(8),intent(in)::x
real(8),intent(in)::y
integer(4),intent(in)::kx
integer(4),intent(in)::ky
integer(4),intent(in)::nx
real(8),intent(in)::xknot(1_8:int(nx+kx,kind=8))
integer(4),intent(in)::ny
real(8),intent(in)::yknot(1_8:int(ny+ky,kind=8))
real(8),intent(in)::bcoef(1_8:int(nx,kind=8),1_8:int(ny,kind=8))
integer(4),intent(out)::ierr
real(8)::dbs2dr
end
subroutine dbs2gd(iderx,idery,nxvec,xvec,nyvec,yvec,kx,ky,xknot,yknot,nx,ny,bcoef,val,ldf,ierr)
integer(4),intent(in)::iderx
integer(4),intent(in)::idery
integer(4),intent(in)::nxvec
real(8),intent(in)::xvec(1_8:int(nxvec,kind=8))
integer(4),intent(in)::nyvec
real(8),intent(in)::yvec(1_8:int(nyvec,kind=8))
integer(4),intent(in)::kx
integer(4),intent(in)::ky
integer(4),intent(in)::nx
real(8),intent(in)::xknot(1_8:int(nx+kx,kind=8))
integer(4),intent(in)::ny
real(8),intent(in)::yknot(1_8:int(ny+ky,kind=8))
real(8),intent(in)::bcoef(1_8:int(nx,kind=8),1_8:int(ny,kind=8))
integer(4),intent(in)::ldf
real(8),intent(out)::val(1_8:int(ldf,kind=8),1_8:*)
integer(4),intent(out)::ierr
end
subroutine dbs3in(nx,xvec,ny,yvec,nz,zvec,xyzdata,ldf,mdf,kx,ky,kz,xknot,yknot,zknot,bcoef,ierr)
integer(4),intent(in)::nx
real(8),intent(in)::xvec(1_8:int(nx,kind=8))
integer(4),intent(in)::ny
real(8),intent(in)::yvec(1_8:int(ny,kind=8))
integer(4),intent(in)::nz
real(8),intent(in)::zvec(1_8:int(nz,kind=8))
integer(4),intent(in)::ldf
integer(4),intent(in)::mdf
real(8),intent(in)::xyzdata(1_8:int(ldf,kind=8),1_8:int(mdf,kind=8),1_8:int(nz,kind=8))
integer(4),intent(in)::kx
integer(4),intent(in)::ky
integer(4),intent(in)::kz
real(8),intent(in)::xknot(1_8:int(nx+kx,kind=8))
real(8),intent(in)::yknot(1_8:int(ny+ky,kind=8))
real(8),intent(in)::zknot(1_8:int(nz+kz,kind=8))
real(8),intent(out)::bcoef(1_8:int(nx,kind=8),1_8:int(ny,kind=8),1_8:int(nz,kind=8))
integer(4),intent(out)::ierr
end
subroutine spli3d(xyzvec,ldf,mdf,xyzdata,xyzknot,n,k,m,l,work2,work3,bcoef,nx,ny,nz,ierr)
integer(4),intent(in)::n
real(8),intent(in)::xyzvec(1_8:int(n,kind=8))
integer(4),intent(in)::ldf
integer(4),intent(in)::mdf
real(8),intent(in)::xyzdata(1_8:int(ldf,kind=8),1_8:int(mdf,kind=8),1_8:*)
integer(4),intent(in)::k
real(8),intent(in)::xyzknot(1_8:int(n+k,kind=8))
integer(4),intent(in)::m
integer(4),intent(in)::l
real(8),intent(out)::work2(1_8:int(n,kind=8))
real(8),intent(out)::work3(1_8:int((2_4*k-1_4)*n,kind=8))
integer(4),intent(in)::nx
integer(4),intent(in)::ny
integer(4),intent(in)::nz
real(8),intent(out)::bcoef(1_8:int(nx,kind=8),1_8:int(ny,kind=8),1_8:int(nz,kind=8))
integer(4),intent(out)::ierr
end
function dbs3vl(x,y,z,kx,ky,kz,xknot,yknot,zknot,nx,ny,nz,bcoef,ierr)
real(8),intent(in)::x
real(8),intent(in)::y
real(8),intent(in)::z
integer(4),intent(in)::kx
integer(4),intent(in)::ky
integer(4),intent(in)::kz
integer(4),intent(in)::nx
real(8),intent(in)::xknot(1_8:int(nx+kx,kind=8))
integer(4),intent(in)::ny
real(8),intent(in)::yknot(1_8:int(ny+ky,kind=8))
integer(4),intent(in)::nz
real(8),intent(in)::zknot(1_8:int(nz+kz,kind=8))
real(8),intent(in)::bcoef(1_8:int(nx,kind=8),1_8:int(ny,kind=8),1_8:int(nz,kind=8))
integer(4),intent(out)::ierr
real(8)::dbs3vl
end
function dbs3dr(iderx,idery,iderz,x,y,z,kx,ky,kz,xknot,yknot,zknot,nx,ny,nz,bcoef,ierr)
integer(4),intent(in)::iderx
integer(4),intent(in)::idery
integer(4),intent(in)::iderz
real(8),intent(in)::x
real(8),intent(in)::y
real(8),intent(in)::z
integer(4),intent(in)::kx
integer(4),intent(in)::ky
integer(4),intent(in)::kz
integer(4),intent(in)::nx
real(8),intent(in)::xknot(1_8:int(nx+kx,kind=8))
integer(4),intent(in)::ny
real(8),intent(in)::yknot(1_8:int(ny+ky,kind=8))
integer(4),intent(in)::nz
real(8),intent(in)::zknot(1_8:int(nz+kz,kind=8))
real(8),intent(in)::bcoef(1_8:int(nx,kind=8),1_8:int(ny,kind=8),1_8:int(nz,kind=8))
integer(4),intent(out)::ierr
real(8)::dbs3dr
end
subroutine dbs3gd(iderx,idery,iderz,nxvec,xvec,nyvec,yvec,nzvec,zvec,kx,ky,kz,xknot,yknot,zknot,nx,ny,nz,bcoef,val,ldf,mdf,ierr)
integer(4),intent(in)::iderx
integer(4),intent(in)::idery
integer(4),intent(in)::iderz
integer(4),intent(in)::nxvec
real(8),intent(in)::xvec(1_8:int(nxvec,kind=8))
integer(4),intent(in)::nyvec
real(8),intent(in)::yvec(1_8:int(nyvec,kind=8))
integer(4),intent(in)::nzvec
real(8),intent(in)::zvec(1_8:int(nzvec,kind=8))
integer(4),intent(in)::kx
integer(4),intent(in)::ky
integer(4),intent(in)::kz
integer(4),intent(in)::nx
real(8),intent(in)::xknot(1_8:int(nx+kx,kind=8))
integer(4),intent(in)::ny
real(8),intent(in)::yknot(1_8:int(ny+ky,kind=8))
integer(4),intent(in)::nz
real(8),intent(in)::zknot(1_8:int(nz+kz,kind=8))
real(8),intent(in)::bcoef(1_8:int(nx,kind=8),1_8:int(ny,kind=8),1_8:int(nz,kind=8))
integer(4),intent(in)::ldf
integer(4),intent(in)::mdf
real(8),intent(out)::val(1_8:int(ldf,kind=8),1_8:int(mdf,kind=8),1_8:*)
integer(4),intent(out)::ierr
end
subroutine bsplvb(t,n,jhigh,idx,x,left,biatx)
integer(4),intent(in)::n
real(8),intent(in)::t(1_8:int(n,kind=8))
integer(4),intent(in)::jhigh
integer(4),intent(in)::idx
real(8),intent(in)::x
integer(4),intent(in)::left
real(8),intent(out)::biatx(1_8:int(jhigh,kind=8))
end
subroutine banfac(w,nroww,nrow,nbandl,nbandu,iflag)
integer(4),intent(in)::nroww
integer(4),intent(in)::nrow
real(8),intent(inout)::w(1_8:int(nroww,kind=8),1_8:int(nrow,kind=8))
integer(4),intent(in)::nbandl
integer(4),intent(in)::nbandu
integer(4),intent(out)::iflag
end
subroutine banslv(w,nroww,nrow,nbandl,nbandu,b)
integer(4),intent(in)::nroww
integer(4),intent(in)::nrow
real(8),intent(in)::w(1_8:int(nroww,kind=8),1_8:int(nrow,kind=8))
integer(4),intent(in)::nbandl
integer(4),intent(in)::nbandu
real(8),intent(inout)::b(1_8:int(nrow,kind=8))
end
subroutine huntn(xx,n,kord,x,jlo)
integer(4),intent(in)::n
real(8),intent(in)::xx(1_8:int(n,kind=8))
integer(4),intent(in)::kord
real(8),intent(in)::x
integer(4),intent(inout)::jlo
end
function get_error_routine()
character(80_4,1)::get_error_routine
end
function get_error_message()
character(256_4,1)::get_error_message
end
end
