﻿!mod$ v1 sum:0fde2ed41bfa9386
!need$ f1b4423f2906c0b3 n kinds
module polarization
use kinds,only:dp
type::polaw
integer(4)::label
logical(4)::ontime
real(8)::time
integer(4)::numpw
real(8),pointer::pw(:,:)
complex(8)::factor
end type
contains
subroutine initialize_polaw(pw)
type(polaw)::pw
end
subroutine free_memory_polaw(pw)
type(polaw)::pw
end
subroutine conjugate_polaw(pw)
type(polaw)::pw
end
subroutine write_polaw(pw,debug)
type(polaw)::pw
logical(4)::debug
end
subroutine read_polaw(label,pw,debug,l_verbose)
integer(4)::label
type(polaw)::pw
logical(4)::debug
logical(4),intent(in)::l_verbose
end
subroutine read_polaw_global(label,pw)
integer(4)::label
type(polaw)::pw
end
subroutine write_polaw_range(pw,debug,range_min,range_max,full_range)
type(polaw)::pw
logical(4)::debug
integer(4),intent(in)::range_min
integer(4),intent(in)::range_max
logical(4),intent(in)::full_range
end
subroutine read_polaw_range(label,pw,debug,range_min,range_max,full_range)
integer(4)::label
type(polaw)::pw
logical(4)::debug
integer(4),intent(in)::range_min
integer(4),intent(in)::range_max
logical(4),intent(in)::full_range
end
subroutine create_polarization(time,pr,gf_p,gf_m,qm,debug)
use green_function,only:green
use basic_structures,only:q_mat
real(8)::time
type(polaw)::pr
type(green)::gf_p
type(green)::gf_m
type(q_mat)::qm
logical(4)::debug
end
subroutine calculate_w(vp,pp,ww,xc_together,l_symm_epsilon,l_head_epsilon,agz,head,l_divergence,inv_epsi,l_wing_epsilon,awing,l_verbose)
use basic_structures,only:v_pot
type(v_pot)::vp
type(polaw)::pp
type(polaw)::ww
logical(4)::xc_together
logical(4)::l_symm_epsilon
logical(4)::l_head_epsilon
real(8)::agz(:)
real(8)::head
logical(4),intent(in)::l_divergence
real(8),intent(out)::inv_epsi
logical(4),intent(in)::l_wing_epsilon
real(8)::awing(:)
logical(4),intent(in)::l_verbose
end
subroutine create_polarization_contraction(time,pr,cp,uu,l_hf_energies,ene_hf)
use compact_product,only:contraction_pola
use basic_structures,only:wannier_u
real(8)::time
type(polaw)::pr
type(contraction_pola)::cp
type(wannier_u)::uu
logical(4),intent(in)::l_hf_energies
real(8),intent(in)::ene_hf(:)
end
subroutine invert_ortho_polaw(op,opi)
use basic_structures,only:ortho_polaw
type(ortho_polaw),intent(in)::op
type(ortho_polaw),intent(out)::opi
end
subroutine distribute_ortho_polaw(op,opd)
use basic_structures,only:ortho_polaw
type(ortho_polaw),intent(in)::op
type(ortho_polaw),intent(out)::opd
end
subroutine collect_ortho_polaw(op,opd)
use basic_structures,only:ortho_polaw
type(ortho_polaw),intent(out)::op
type(ortho_polaw),intent(in)::opd
end
subroutine orthonormalize(op,pw)
use basic_structures,only:ortho_polaw
type(ortho_polaw),intent(in)::op
type(polaw),intent(inout)::pw
end
subroutine orthonormalize_inverse(op,pw)
use basic_structures,only:ortho_polaw
type(ortho_polaw),intent(in)::op
type(polaw),intent(inout)::pw
end
subroutine orthonormalize_vpot_inverse(op,vp)
use basic_structures,only:ortho_polaw
use basic_structures,only:v_pot
type(ortho_polaw),intent(in)::op
type(v_pot),intent(inout)::vp
end
subroutine orthonormalize_vpot(op,vp)
use basic_structures,only:ortho_polaw
use basic_structures,only:v_pot
type(ortho_polaw),intent(in)::op
type(v_pot),intent(inout)::vp
end
subroutine orthonormalize_vpot_para(op,vp)
use basic_structures,only:ortho_polaw
use basic_structures,only:v_pot
type(ortho_polaw),intent(in)::op
type(v_pot),intent(inout)::vp
end
subroutine invert_v_pot(vp,vpi)
use basic_structures,only:v_pot
type(v_pot),intent(in)::vp
type(v_pot),intent(inout)::vpi
end
subroutine fake_polarization_io(n)
integer(4)::n
end
subroutine orthonormalize_vpot_inverse_para(op,vp)
use basic_structures,only:ortho_polaw
use basic_structures,only:v_pot
type(ortho_polaw),intent(in)::op
type(v_pot),intent(inout)::vp
end
subroutine create_polarization_contraction_state(time,pr,uu,l_hf_energies,ene_hf,options)
use input_gw,only:input_options
use basic_structures,only:wannier_u
real(8)::time
type(polaw)::pr
type(wannier_u)::uu
logical(4),intent(in)::l_hf_energies
real(8),intent(in)::ene_hf(:)
type(input_options)::options
end
subroutine distribute_v_pot(vp,vpd)
use basic_structures,only:v_pot
type(v_pot),intent(in)::vp
type(v_pot),intent(out)::vpd
end
subroutine collect_v_pot(vp,vpd)
use basic_structures,only:v_pot
type(v_pot),intent(out)::vp
type(v_pot),intent(in)::vpd
end
subroutine calculate_w_g(vp,pp,ww,xc_together,l_symm_epsilon,l_head_epsilon,agz,head,l_divergence,inv_epsi,l_wing_epsilon,awing,awing_c)
use basic_structures,only:v_pot
type(v_pot)::vp
type(polaw)::pp
type(polaw)::ww
logical(4)::xc_together
logical(4)::l_symm_epsilon
logical(4)::l_head_epsilon
real(8)::agz(:)
real(8)::head
logical(4),intent(in)::l_divergence
real(8),intent(out)::inv_epsi
logical(4),intent(in)::l_wing_epsilon
real(8)::awing(:)
real(8)::awing_c(:)
end
subroutine create_polarization_file(uu,tf,prefix)
use times_gw,only:times_freqs
use basic_structures,only:wannier_u
type(wannier_u),intent(in)::uu
type(times_freqs)::tf
character(256_4,1),intent(in)::prefix
end
subroutine square_root_polaw(pw,numpw)
integer(4)::numpw
real(8)::pw(1_8:int(numpw,kind=8),1_8:int(numpw,kind=8))
end
subroutine create_polarization_beta(time,pr,uu,qm)
use basic_structures,only:q_mat
use basic_structures,only:wannier_u
real(8),intent(in)::time
type(polaw),intent(out)::pr
type(wannier_u),intent(in)::uu
type(q_mat),intent(in)::qm
end
subroutine create_polarization_upper(uu,tf,prefix)
use times_gw,only:times_freqs
use basic_structures,only:wannier_u
type(wannier_u),intent(in)::uu
type(times_freqs),intent(in)::tf
character(256_4,1),intent(in)::prefix
end
subroutine calculate_w_g_l(vp,pp,ww,xc_together,l_head_epsilon,head,inv_epsi,l_wing_epsilon,awing,awing_c,l_verbose)
use basic_structures,only:v_pot
type(v_pot)::vp
type(polaw)::pp
type(polaw)::ww
logical(4)::xc_together
logical(4)::l_head_epsilon
real(8)::head(1_8:3_8)
real(8),intent(out)::inv_epsi
logical(4),intent(in)::l_wing_epsilon
real(8)::awing(1_8:int(pp%numpw,kind=8),1_8:3_8)
real(8)::awing_c(1_8:int(pp%numpw,kind=8),1_8:3_8)
logical(4),intent(in)::l_verbose
end
end
