﻿!mod$ v1 sum:000bc2a35b26f19e
!need$ f1b4423f2906c0b3 n kinds
module convergence_gw
use kinds,only:dp
type::vpv
integer(4)::nr
integer(8),pointer::r(:)
real(8),pointer::vpvr(:,:)
real(8),pointer::vpvr_im(:,:)
real(8)::freq
real(8)::freq_im
end type
type::gzero
integer(4)::nr
integer(8),pointer::r(:)
real(8),pointer::gf(:,:,:)
real(8),pointer::gf_im(:,:,:)
real(8)::freq
real(8)::freq_im
end type
type::exchange
integer(4)::nr
integer(8),pointer::r(:)
real(8),pointer::x(:,:,:)
end type
type::hks
integer(4)::nr
integer(8),pointer::r(:)
real(8),pointer::h0(:,:)
real(8),pointer::vxc(:,:)
end type
type::convergence_tests
integer(4)::nr
integer(4)::iband
integer(4)::ispin
integer(4),pointer::r(:)
integer(4)::r_coord(1_8:3_8)
complex(8),pointer::freq(:)
integer(4)::nf
type(vpv),pointer::wapprox(:)
type(gzero),pointer::g0(:)
type(exchange)::xf
type(hks)::h0
real(8),pointer::energy(:)
end type
type::self_energy
integer(4)::s_first_state
integer(4)::s_last_state
integer(4)::s_first_spin
integer(4)::s_last_spin
integer(4)::ngrid
real(8),pointer::freq(:)
integer(4)::nr
real(8),pointer::psif(:,:,:)
complex(8),pointer::self(:,:,:,:)
logical(4)::l_first
real(8),pointer::ene_ks(:,:)
real(8),pointer::ene_xc(:,:)
real(8),pointer::ene_x(:,:)
end type
interface free_memory
procedure::free_vpv
procedure::free_convergence_tests
procedure::free_gzero
procedure::free_exchange
procedure::free_hks
procedure::free_self_energy
end interface
interface initialize_memory
procedure::initialize_memory_gzero
procedure::initialize_memory_vpv
procedure::initialize_memory_self_energy
end interface
contains
subroutine initialize_memory_self_energy(se)
type(self_energy)::se
end
subroutine free_self_energy(se)
type(self_energy)::se
end
subroutine initialize_memory_gzero(c)
type(gzero)::c
end
subroutine initialize_memory_vpv(c)
type(vpv)::c
end
subroutine free_hks(c)
type(hks)::c
end
subroutine free_exchange(c)
type(exchange)::c
end
subroutine free_gzero(c)
type(gzero)::c
end
subroutine set_se_energies(se,ene_ks,ene_xc,ene_x)
use wvfct,only:nbnd
use lsda_mod,only:nspin
type(self_energy),intent(out)::se
real(8),intent(in)::ene_ks(1_8:int(nbnd,kind=8),1_8:int(nspin,kind=8))
real(8),intent(in)::ene_xc(1_8:int(nbnd,kind=8),1_8:int(nspin,kind=8))
real(8),intent(in)::ene_x(1_8:int(nbnd,kind=8),1_8:int(nspin,kind=8))
end
subroutine write_self_energy(se,ix_start,iy_start,iz_start,nr_counter)
type(self_energy)::se
integer(4)::ix_start
integer(4)::iy_start
integer(4)::iz_start
integer(4)::nr_counter
end
subroutine read_self_energy(se,ix_start,iy_start,iz_start,nr_counter)
type(self_energy)::se
integer(4)::ix_start
integer(4)::iy_start
integer(4)::iz_start
integer(4)::nr_counter
end
subroutine check_normalisation(v_states,iband)
use fft_base,only:dffts
use wannier_gw,only:num_nbndv
real(8),intent(in)::v_states(1_8:int(dffts%nnr,kind=8),1_8:int(num_nbndv(1_8),kind=8))
integer(4)::iband
end
subroutine start_convergence(ct,iband,ispin,v_states,lmax,nx,ny,nz,nf,freq,ks_wfcs)
use fft_base,only:dffts
use wannier_gw,only:num_nbnds
use lsda_mod,only:nspin
use wvfct,only:npw
use wvfct,only:nbnd
type(convergence_tests)::ct
integer(4)::iband
integer(4)::ispin
real(8),intent(in)::v_states(1_8:int(dffts%nnr,kind=8),1_8:int(num_nbnds,kind=8),1_8:int(nspin,kind=8))
logical(4),intent(in)::lmax
integer(4),intent(in)::nx
integer(4),intent(in)::ny
integer(4),intent(in)::nz
integer(4),intent(in)::nf
complex(8),intent(in)::freq(1_8:int(nf,kind=8))
complex(8),intent(in)::ks_wfcs(1_8:int(npw,kind=8),1_8:int(nbnd,kind=8),1_8:int(nspin,kind=8))
end
subroutine calculate_convergence(ct,v_states,se,nr_counter)
use fft_base,only:dffts
use wannier_gw,only:num_nbnds
use lsda_mod,only:nspin
type(convergence_tests)::ct
real(8),intent(in)::v_states(1_8:int(dffts%nnr,kind=8),1_8:int(num_nbnds,kind=8),1_8:int(nspin,kind=8))
type(self_energy)::se
integer(4),intent(inout)::nr_counter
end
subroutine average_self_energy(se)
type(self_energy)::se
end
subroutine solve_off_diagonal(se)
type(self_energy),intent(inout)::se
end
subroutine free_convergence_tests(ct)
type(convergence_tests)::ct
end
subroutine free_vpv(c)
type(vpv)::c
end
subroutine calculate_gzero(g0,freq,r,nr)
type(gzero)::g0
real(8)::freq
integer(4)::nr
integer(4)::r(1_8:int(nr,kind=8))
end
subroutine calculate_gzero_complex(g0,freq,freq_im,r,nr,l_old,psi_old,l_lanczos,lc,ks_wfcs)
use wvfct,only:npw
use wvfct,only:nbnd
use lsda_mod,only:nspin
use lanczos,only:lanczos_chain
type(gzero)::g0
real(8)::freq
real(8)::freq_im
integer(4)::nr
integer(4)::r(1_8:int(nr,kind=8))
logical(4)::l_old
complex(8)::psi_old(1_8:int(npw,kind=8))
logical(4)::l_lanczos
type(lanczos_chain)::lc(1_8:2_8)
complex(8),intent(in)::ks_wfcs(1_8:int(npw,kind=8),1_8:int(nbnd,kind=8),1_8:int(nspin,kind=8))
end
subroutine calculate_vpv_complex(c,freq,freq_im,r,nr,v_states,l_w,thrs,lc,head,wing,alpha,ks_wfcs,l_save,phi_save)
use fft_base,only:dffts
use wannier_gw,only:num_nbnds
use lsda_mod,only:nspin
use wvfct,only:npw
use wvfct,only:nbnd
use lanczos,only:lanczos_chain
type(vpv)::c
real(8)::freq
real(8)::freq_im
integer(4)::nr
integer(4)::r(1_8:int(nr,kind=8))
real(8),intent(in)::v_states(1_8:int(dffts%nnr,kind=8),1_8:int(num_nbnds,kind=8),1_8:int(nspin,kind=8))
logical(4)::l_w
real(8)::thrs
type(lanczos_chain)::lc(1_8:2_8)
real(8)::head
complex(8)::wing(1_8:int(npw,kind=8))
real(8)::alpha
complex(8),intent(in)::ks_wfcs(1_8:int(npw,kind=8),1_8:int(nbnd,kind=8),1_8:int(nspin,kind=8))
logical(4),intent(in)::l_save
complex(8),intent(inout)::phi_save(1_8:int(npw,kind=8))
end
subroutine calculate_x(xf,r,nr,v_states)
use fft_base,only:dffts
use wannier_gw,only:num_nbnds
use lsda_mod,only:nspin
type(exchange)::xf
integer(4)::nr
integer(4)::r(1_8:int(nr,kind=8))
real(8),intent(in)::v_states(1_8:int(dffts%nnr,kind=8),1_8:int(num_nbnds,kind=8),1_8:int(nspin,kind=8))
end
subroutine calculate_hks(h0,r,nr,v_states)
use fft_base,only:dffts
use wannier_gw,only:num_nbndv
type(hks)::h0
integer(4)::nr
integer(4)::r(1_8:int(nr,kind=8))
real(8),intent(in)::v_states(1_8:int(dffts%nnr,kind=8),1_8:int(num_nbndv(1_8),kind=8))
end
subroutine pv_operator(state,ispin,ks_wfcs,l_all)
use wvfct,only:npw
use wvfct,only:nbnd
use lsda_mod,only:nspin
complex(8),intent(inout)::state(1_8:int(npw,kind=8))
integer(4),intent(in)::ispin
complex(8),intent(in)::ks_wfcs(1_8:int(npw,kind=8),1_8:int(nbnd,kind=8),1_8:int(nspin,kind=8))
logical(4),intent(in)::l_all
end
subroutine pc_operator2(state,ispin,ks_wfcs,l_all)
use wvfct,only:npw
use wvfct,only:nbnd
use lsda_mod,only:nspin
complex(8),intent(inout)::state(1_8:int(npw,kind=8))
integer(4),intent(in)::ispin
complex(8),intent(in)::ks_wfcs(1_8:int(npw,kind=8),1_8:int(nbnd,kind=8),1_8:int(nspin,kind=8))
logical(4),intent(in)::l_all
end
subroutine hpsi_pw4gww_krylov(ndim,psi,ppsi,et,is,numv,ks_wfcs)
use wvfct,only:npw
use wvfct,only:nbnd
use lsda_mod,only:nspin
integer(4),intent(in)::ndim
integer(4),intent(in)::numv
complex(8),intent(inout)::psi(1_8:int(ndim,kind=8),1_8:int(numv,kind=8))
complex(8),intent(out)::ppsi(1_8:int(ndim,kind=8),1_8:int(numv,kind=8))
real(8)::et(1_8:int(numv,kind=8))
integer(4),intent(in)::is
complex(8),intent(in)::ks_wfcs(1_8:int(npw,kind=8),1_8:int(nbnd,kind=8),1_8:int(nspin,kind=8))
end
end
