﻿!mod$ v1 sum:64dfa998a5ece449
!need$ 1a466716db68a1c0 n upf_params
!need$ 2ff0996d4eeece74 n constants
!need$ c9dd778377ad45c9 n paw_type
!need$ 3bc3e9b844ff876c n radial_grids
!need$ f1b4423f2906c0b3 n kinds
!need$ 7792b212ee60a9df n ld1_parameters
module atomic_paw
use kinds,only:dp
use ld1_parameters,only:nwfsx
use upf_params,only:lmaxx
use constants,only:pi
use constants,only:fpi
use constants,only:e2
use constants,only:eps8
use radial_grids,only:ndmx
use radial_grids,only:radial_grid_type
use paw_type,only:paw_t
use paw_type,only:nullify_pseudo_paw
use paw_type,only:allocate_pseudo_paw
private::dp
private::nwfsx
private::lmaxx
private::pi
private::fpi
private::e2
private::eps8
private::ndmx
private::radial_grid_type
private::nullify_pseudo_paw
private::allocate_pseudo_paw
real(8),parameter,private::zero=0._8
real(8),parameter,private::one=1._8
real(8),parameter,private::two=2._8
real(8),parameter,private::half=5.e-1_8
private::compute_charges
private::compute_onecenter_energy
private::compute_nonlocal_coeff
private::human_write_paw
private::compute_sumwfc2
private::compute_projsum
private::compute_augcharge
private::compute_onecenter_charge
contains
subroutine new_paw_hamiltonian(veffps_,ddd_,etot_,pawset_,nwfc_,l_,j_,nspin_,spin_,oc_,pswfc_,eig_,paw_energy,dddion_)
real(8),intent(out)::veffps_(1_8:3500_8,1_8:2_8)
real(8),intent(out)::ddd_(1_8:17_8,1_8:17_8,1_8:2_8)
real(8),intent(out)::etot_
type(paw_t),intent(in)::pawset_
integer(4),intent(in)::nwfc_
integer(4),intent(in)::l_(1_8:17_8)
real(8),intent(in)::j_(1_8:17_8)
integer(4),intent(in)::nspin_
integer(4),intent(in)::spin_(1_8:17_8)
real(8),intent(in)::oc_(1_8:17_8)
real(8),intent(in)::pswfc_(1_8:3500_8,1_8:17_8)
real(8),intent(in)::eig_(1_8:17_8)
real(8),intent(out),optional::paw_energy(1_8:5_8,1_8:3_8)
real(8),optional::dddion_(1_8:17_8,1_8:17_8)
end
subroutine us2paw(pawset_,zval,grid,rmatch_augfun,ikk,nbeta,lls,jjs,ocs,enls,els,rcutus,psipaw,psipaw_rel,phis,betas,qvan,kindiff,nlcc,aerhoc,psrhoc,aevtot,psvtot,which_paw_augfun,rel)
type(paw_t),intent(out)::pawset_
real(8),intent(in)::zval
type(radial_grid_type),intent(in)::grid
real(8),intent(in)::rmatch_augfun
integer(4),intent(in)::ikk(1_8:17_8)
integer(4),intent(in)::nbeta
integer(4),intent(in)::lls(1_8:17_8)
real(8),intent(in)::jjs(1_8:17_8)
real(8),intent(in)::ocs(1_8:17_8)
real(8),intent(in)::enls(1_8:17_8)
character(2_4,1),intent(in)::els(1_8:17_8)
real(8),intent(in)::rcutus(1_8:17_8)
real(8),intent(in)::psipaw(1_8:3500_8,1_8:17_8)
real(8),intent(in)::psipaw_rel(1_8:3500_8,1_8:17_8)
real(8),intent(in)::phis(1_8:3500_8,1_8:17_8)
real(8),intent(in)::betas(1_8:3500_8,1_8:17_8)
real(8),intent(in)::qvan(1_8:3500_8,1_8:17_8,1_8:17_8)
real(8),intent(in)::kindiff(1_8:17_8,1_8:17_8)
logical(4),intent(in)::nlcc
real(8),intent(in)::aerhoc(1_8:3500_8)
real(8),intent(in)::psrhoc(1_8:3500_8)
real(8),intent(in)::aevtot(1_8:3500_8)
real(8),intent(in)::psvtot(1_8:3500_8)
character(20_4,1),intent(in)::which_paw_augfun
integer(4),intent(in)::rel
end
subroutine paw2us(pawset_,zval,grid,nbeta,lls,jjs,ikk,betas,qq,qvan,vpsloc,bmat,rhos,els,rcutus,pseudotype,psipaw_rel)
use radial_grids,only:radial_grid_type
type(paw_t),intent(in)::pawset_
real(8),intent(out)::zval
type(radial_grid_type),intent(out)::grid
integer(4),intent(out)::nbeta
integer(4),intent(out)::lls(1_8:17_8)
real(8),intent(out)::jjs(1_8:17_8)
integer(4),intent(out)::ikk(1_8:17_8)
real(8),intent(out)::betas(1_8:3500_8,1_8:17_8)
real(8),intent(out)::qq(1_8:17_8,1_8:17_8)
real(8),intent(out)::qvan(1_8:3500_8,1_8:17_8,1_8:17_8)
real(8),intent(out)::vpsloc(1_8:3500_8)
real(8),intent(out)::bmat(1_8:17_8,1_8:17_8)
real(8),intent(out)::rhos(1_8:3500_8)
character(2_4,1),intent(out)::els(1_8:17_8)
real(8),intent(out)::rcutus(1_8:17_8)
integer(4),intent(out)::pseudotype
real(8),intent(out)::psipaw_rel(1_8:3500_8,1_8:17_8)
end
subroutine check_multipole(pawset_)
type(paw_t),intent(in)::pawset_
end
subroutine compute_charges(projsum_,chargeps_,charge1_,charge1ps_,pawset_,nwfc_,l_,j_,nspin_,spin_,oc_,pswfc_,iflag,unit_)
real(8),intent(out)::projsum_(1_8:17_8,1_8:17_8,1_8:2_8)
real(8),intent(out)::chargeps_(1_8:3500_8,1_8:2_8)
real(8),intent(out)::charge1_(1_8:3500_8,1_8:2_8)
real(8),intent(out)::charge1ps_(1_8:3500_8,1_8:2_8)
type(paw_t),intent(in)::pawset_
integer(4),intent(in)::nwfc_
integer(4),intent(in)::l_(1_8:17_8)
real(8),intent(in)::j_(1_8:17_8)
integer(4),intent(in)::nspin_
integer(4),intent(in)::spin_(1_8:17_8)
real(8),intent(in)::oc_(1_8:17_8)
real(8),intent(in)::pswfc_(1_8:3500_8,1_8:17_8)
integer(4),optional::iflag
integer(4),optional::unit_
end
subroutine compute_onecenter_energy(totenergy_,veff_,pawset_,vcharge_,nlcc_,ccharge_,nspin_,iint,vloc,energies_,unit_)
real(8),intent(out)::totenergy_
real(8),intent(out)::veff_(1_8:3500_8,1_8:2_8)
type(paw_t),intent(in)::pawset_
real(8),intent(in)::vcharge_(1_8:3500_8,1_8:2_8)
logical(4),intent(in)::nlcc_
real(8),intent(in)::ccharge_(1_8:3500_8)
integer(4),intent(in)::nspin_
integer(4),intent(in)::iint
real(8),intent(in),optional::vloc(1_8:3500_8)
real(8),intent(out),optional::energies_(1_8:5_8)
integer(4),optional::unit_
end
subroutine compute_nonlocal_coeff(ddd_,pawset_,nspin_,veffps_,veff1_,veff1ps_)
real(8),intent(out)::ddd_(1_8:17_8,1_8:17_8,1_8:2_8)
type(paw_t),intent(in)::pawset_
integer(4),intent(in)::nspin_
real(8),intent(in)::veffps_(1_8:3500_8,1_8:2_8)
real(8),intent(in)::veff1_(1_8:3500_8,1_8:2_8)
real(8),intent(in)::veff1ps_(1_8:3500_8,1_8:2_8)
end
subroutine compute_nonlocal_coeff_ion(ddd_,pawset_)
real(8),intent(out)::ddd_(1_8:17_8,1_8:17_8)
type(paw_t),intent(in)::pawset_
end
subroutine human_write_paw(pawset_)
type(paw_t),intent(in)::pawset_
end
subroutine compute_sumwfc2(charge_,pawset_,nwfc_,wfc_,oc_,spin_)
real(8),intent(out)::charge_(1_8:3500_8,1_8:2_8)
type(paw_t),intent(in)::pawset_
integer(4),intent(in)::nwfc_
real(8),intent(in)::wfc_(1_8:3500_8,1_8:17_8)
real(8),intent(in)::oc_(1_8:17_8)
integer(4),intent(in)::spin_(1_8:17_8)
end
subroutine compute_projsum(projsum_,pawset_,nwfc_,l_,j_,spin_,pswfc_,oc_)
real(8),intent(out)::projsum_(1_8:17_8,1_8:17_8,1_8:2_8)
type(paw_t),intent(in)::pawset_
integer(4),intent(in)::nwfc_
integer(4),intent(in)::l_(1_8:17_8)
real(8),intent(in)::j_(1_8:17_8)
integer(4),intent(in)::spin_(1_8:17_8)
real(8),intent(in)::pswfc_(1_8:3500_8,1_8:17_8)
real(8),intent(in)::oc_(1_8:17_8)
end
subroutine compute_augcharge(augcharge_,pawset_,projsum_,nspin_)
real(8),intent(out)::augcharge_(1_8:3500_8,1_8:2_8)
type(paw_t),intent(in)::pawset_
real(8),intent(in)::projsum_(1_8:17_8,1_8:17_8,1_8:2_8)
integer(4),intent(in)::nspin_
end
subroutine compute_onecenter_charge(charge1_,pawset_,projsum_,nspin_,which_wfc)
real(8),intent(out)::charge1_(1_8:3500_8,1_8:2_8)
type(paw_t),intent(in)::pawset_
real(8),intent(in)::projsum_(1_8:17_8,1_8:17_8,1_8:2_8)
integer(4),intent(in)::nspin_
character(2_4,1),intent(in)::which_wfc
end
subroutine find_bes_qi(qc,rmatch,lam,ncn,iok)
integer(4),intent(in)::ncn
real(8),intent(out)::qc(1_8:int(ncn,kind=8))
real(8),intent(in)::rmatch
integer(4),intent(in)::lam
integer(4),intent(inout)::iok
end
end
