%feature("docstring") OT::UniformOrderStatistics
"UniformOrderStatistics distribution.

.. warning::
    This class is experimental and likely to be modified in future releases.
    To use it, import the ``openturns.experimental`` submodule.

Parameters
----------
dimension : int
    The dimension of the distribution.

See also
--------
openturns.MaximumEntropyOrderStatisticsDistribution

Notes
-----
Let :math:`X` be a random variable and :math:`\\vect{X}_{(1:n)} = (X_{(1)},\\dots,X_{(n)})`
be the random vector of all its order statistics  of size :math:`n`.

This class implements the joint distribution of :math:`\\vect{X}_{(1:n)}` when :math:`X` is
distributed according to the Uniform distribution over :math:`[0,1]`. Its probability density
function is defined by (see [arnold2008]_ eq. 2.2.4 page 11):

.. math::

    f_{\\vect{X}_{(1:n)}}(\\vect{x}) = n!\\,\\mathbf{1}_{\\cS}(\\vect{x}) \\quad \\vect{x} \\in
    \\Rset^n

where :math:`\\cS\\subset\\Rset^n` is defined by:

.. math::
   \\cS=\\left\\{(x_1,\\dots,x_n)\\in[0,1]^n\\,|\\,0 \\leq x_1 \\leq \\dots \\leq x_n \\leq 1\\right\\}.

Let :math:`\\cV` be defined by:

.. math::
   \\cV=\\left\\{(\\underbrace{0,\\dots,0}_{k}, \\underbrace{1,\\dots,1}_{n-k}), \\; k\\in\\{0,\\dots,n\\}\\right\\},

then, :math:`\\cS` is the simplex with vertices :math:`\\cV`:

.. math::
   \\cS = \\left\\{\\sum_{k = 1}^{n + 1} \\lambda_k v_k \\, \\left|\\right.\\, v_k \\in \\cV, \\;
   \\lambda_k \\in [0,1], \\; \\sum_{k = 1}^{n + 1} \\lambda_k = 1\\right\\}.

If  :math:`X` is a random variable distributed according to
:math:`\\cL`, which PDF (if defined) is :math:`f` and CDF is :math:`F`, then the random vector
of its :math:`n`  order statistics is distributed as the random vector
:math:`(F^{-1}(U_{(1)}), \\dots, F^{-1}(U_{(n)}))` where the :math:`U_{(i)}`
are the order statistics of the Uniform distribution over :math:`[0,1]`:

.. math::
    (X_{(1)},\\dots,X_{(n)}) \\sim (F^{-1}(U_{(1)}), \\dots, F^{-1}(U_{(n)}))

Then the CDF of :math:`\\vect{X}_{(1:n)}` is defined for :math:`\\vect{x} \\in \\Rset^n` by:

.. math::
    F_{\\vect{X}_{(1:n)}}(\\vect{x}) = F_{\\vect{U}_{(1:n)}}(F(x_1), \\dots, F(x_n))

and its PDF (if defined) by:

.. math::

    f_{\\vect{X}_{(1:n)}}(\\vect{x}) = n!\\prod_{i=1}^n f(x_i) \\,\\mathbf{1}_{\\cS}(\\vect{x})

Thus, to get the joint distribution of :math:`\\vect{X}_{(1:n)}`, we use the
:class:`~openturns.JointDistribution` whose all marginals are  :math:`\\cL`
and whose core is a :class:`~openturns.experimental.UniformOrderStatistics`.

Examples
--------
Create  joint distribution of :math:`\\vect{U}_{(1:n)}` with :math:`n=10`:

>>> import openturns as ot
>>> import openturns.experimental as otexp
>>> n = 10
>>> unif_orderStat = otexp.UniformOrderStatistics(n)

Create the joint distribution of :math:`\\vect{X}_{(1:n)}` where
:math:`X` is distributed as a Normal distribution, with zero mean and unit standard
deviation:

>>> X_dist = ot.Normal()
>>> normal_orderStat = ot.JointDistribution([X_dist]*n, otexp.UniformOrderStatistics(n))"
