﻿!mod$ v1 sum:1e45e83fd9a13481
!need$ 4d3ad4f29fa4ff76 n mbd_utils
!need$ b30b6efa3a84bd58 n mbd_gradients
!need$ 58272acdba890bc4 n mbd_constants
module mbd_formulas
use mbd_gradients,only:grad_t
use mbd_gradients,only:grad_request_t
use mbd_utils,only:quad_pt_t
use mbd_utils,only:tostr
use mbd_constants,only:dp
use mbd_constants,only:kind
use mbd_constants,only:pi
use mbd_constants,only:acos
use mbd_constants,only:ang
use mbd_constants,only:mbd_exc_neg_eigvals
use mbd_constants,only:mbd_exc_neg_pol
use mbd_constants,only:mbd_exc_linalg
use mbd_constants,only:mbd_exc_unimpl
use mbd_constants,only:mbd_exc_damping
use mbd_constants,only:mbd_exc_input
use mbd_constants,only:mbd_log_lvl_debug
use mbd_constants,only:mbd_log_lvl_info
use mbd_constants,only:mbd_log_lvl_warn
use mbd_constants,only:mbd_log_lvl_error
use mbd_constants,only:zero_real
use mbd_constants,only:zero_complex
use mbd_constants,only:imi
private::grad_t
private::grad_request_t
private::quad_pt_t
private::tostr
private::dp
private::kind
private::pi
private::acos
private::ang
private::mbd_exc_neg_eigvals
private::mbd_exc_neg_pol
private::mbd_exc_linalg
private::mbd_exc_unimpl
private::mbd_exc_damping
private::mbd_exc_input
private::mbd_log_lvl_debug
private::mbd_log_lvl_info
private::mbd_log_lvl_warn
private::mbd_log_lvl_error
private::zero_real
private::zero_complex
private::imi
contains
function omega_qho(c6,alpha,domega,grad) result(omega)
real(8),intent(in)::c6(:)
real(8),intent(in)::alpha(:)
type(grad_t),intent(out),optional::domega
type(grad_request_t),intent(in),optional::grad
real(8)::omega(1_8:size(c6,dim=1,kind=8))
end
function alpha_dyn_qho(alpha_0,omega,freq,dalpha,grad) result(alpha)
real(8),intent(in)::alpha_0(:)
real(8),intent(in)::omega(:)
type(quad_pt_t),intent(in)::freq(0_8:)
type(grad_t),allocatable,intent(out)::dalpha(:)
type(grad_request_t),intent(in)::grad
real(8)::alpha(1_8:size(alpha_0,dim=1,kind=8),0_8:int(ubound(freq,1_4),kind=8))
end
function c6_from_alpha(alpha,freq,dc6_dalpha,grad) result(c6)
real(8),intent(in)::alpha(1_8:,0_8:)
type(quad_pt_t),intent(in)::freq(0_8:)
real(8),allocatable,intent(out),optional::dc6_dalpha(:,:)
logical(4),intent(in),optional::grad
real(8)::c6(1_8:size(alpha,dim=1,kind=8))
end
function sigma_selfint(alpha,dsigma_dalpha,grad) result(sigma)
real(8),intent(in)::alpha(:)
real(8),allocatable,intent(out),optional::dsigma_dalpha(:)
logical(4),intent(in),optional::grad
real(8)::sigma(1_8:size(alpha,dim=1,kind=8))
end
function scale_with_ratio(x,yp,y,q,dx,grad) result(xp)
real(8),intent(in)::x(:)
real(8),intent(in)::yp(:)
real(8),intent(in)::y(:)
real(8),intent(in)::q
type(grad_t),intent(out),optional::dx
type(grad_request_t),intent(in),optional::grad
real(8)::xp(1_8:size(x,dim=1,kind=8))
end
end
