﻿!mod$ v1 sum:4e39a04992119a3d
!need$ e30d66a195cd7129 n mbd_version
!need$ 8d0d9a9d4403ab4f n mbd_methods
!need$ 2d0818d03440aaca n mbd_ts
!need$ 4d3ad4f29fa4ff76 n mbd_utils
!need$ 5f01b4c9107c819a n mbd_vdw_param
!need$ d8633ef82d99928d n mbd_defaults
!need$ 1e45e83fd9a13481 n mbd_formulas
!need$ 8f2d951c784e2cd4 n mbd_damping
!need$ 0d5a1a6e26bb4dcb n mbd_geom
!need$ b30b6efa3a84bd58 n mbd_gradients
!need$ 58272acdba890bc4 n mbd_constants
module mbd
use mbd_damping,only:damping_t
use mbd_formulas,only:scale_with_ratio
use mbd_geom,only:geom_t
use mbd_gradients,only:grad_request_t
use mbd_gradients,only:grad_t
use mbd_methods,only:get_mbd_energy
use mbd_methods,only:get_mbd_scs_energy
use mbd_ts,only:get_ts_energy
use mbd_utils,only:result_t
use mbd_utils,only:exception_t
use mbd_utils,only:printer_i
use mbd_vdw_param,only:ts_vdw_params
use mbd_vdw_param,only:tssurf_vdw_params
use mbd_vdw_param,only:species_index
use mbd_constants,only:dp
use mbd_constants,only:kind
use mbd_constants,only:pi
use mbd_constants,only:acos
use mbd_constants,only:ang
use mbd_constants,only:mbd_exc_neg_eigvals
use mbd_constants,only:mbd_exc_neg_pol
use mbd_constants,only:mbd_exc_linalg
use mbd_constants,only:mbd_exc_unimpl
use mbd_constants,only:mbd_exc_damping
use mbd_constants,only:mbd_exc_input
use mbd_constants,only:mbd_log_lvl_debug
use mbd_constants,only:mbd_log_lvl_info
use mbd_constants,only:mbd_log_lvl_warn
use mbd_constants,only:mbd_log_lvl_error
use mbd_constants,only:zero_real
use mbd_constants,only:zero_complex
use mbd_constants,only:imi
use mbd_defaults,only:n_frequency_grid
use mbd_defaults,only:k_grid_shift
use mbd_defaults,only:ts_damping_d
use mbd_defaults,only:mbd_damping_a
use mbd_defaults,only:max_atoms_per_block
use mbd_version,only:mbd_version_major
use mbd_version,only:mbd_version_minor
use mbd_version,only:mbd_version_patch
use mbd_version,only:mbd_version_suffix
private::damping_t
private::scale_with_ratio
private::geom_t
private::grad_request_t
private::grad_t
private::get_mbd_energy
private::get_mbd_scs_energy
private::get_ts_energy
private::result_t
private::exception_t
private::printer_i
private::ts_vdw_params
private::tssurf_vdw_params
private::species_index
private::dp
private::kind
private::pi
private::acos
private::ang
private::mbd_log_lvl_debug
private::mbd_log_lvl_info
private::mbd_log_lvl_warn
private::mbd_log_lvl_error
private::zero_real
private::zero_complex
private::imi
private::n_frequency_grid
private::k_grid_shift
private::ts_damping_d
private::mbd_damping_a
private::max_atoms_per_block
type::mbd_input_t
character(30_4,1)::method="mbd-rsscs                     "
integer(4)::comm=-1_4
integer(4)::max_atoms_per_block=6_4
integer(4)::log_level=0_4
procedure(printer_i),nopass,pointer::printer
logical(4)::calculate_forces=.true._4
logical(4)::calculate_vdw_params_gradients=.false._4
logical(4)::calculate_spectrum=.false._4
logical(4)::do_rpa=.false._4
logical(4)::rpa_orders=.false._4
logical(4)::rpa_rescale_eigs=.false._4
integer(4)::n_omega_grid=15_4
real(8)::k_grid_shift=5.e-1_8
logical(4)::zero_negative_eigvals=.false._4
character(20_4,1)::xc="                    "
real(8)::ts_d=2.e1_8
real(8)::ts_sr=-1._8
real(8)::mbd_a=6._8
real(8)::mbd_beta=-1._8
character(10_4,1)::vdw_params_kind="ts        "
character(3_4,1),allocatable::atom_types(:)
real(8),allocatable::free_values(:,:)
real(8),allocatable::coords(:,:)
real(8),allocatable::lattice_vectors(:,:)
integer(4)::k_grid(1_8:3_8)=[INTEGER(4)::-1_4,-1_4,-1_4]
character(10_4,1)::parallel_mode="auto      "
end type
intrinsic::null
private::null
type::mbd_calc_t
type(geom_t),private::geom
type(damping_t),private::damp
real(8),allocatable,private::alpha_0(:)
real(8),allocatable,private::c6(:)
character(30_4,1),private::method
type(result_t),private::results
type(grad_t),private::dalpha_0
type(grad_t),private::dc6
type(grad_t),private::dr_vdw
logical(4),private::calculate_gradients
logical(4),private::calculate_vdw_params_gradients
real(8),allocatable,private::free_values(:,:)
character(30_4,1),private::vdw_params_update
contains
procedure::init=>mbd_calc_init
procedure::destroy=>mbd_calc_destroy
procedure::switch_forces=>mbd_calc_switch_forces
procedure::update_coords=>mbd_calc_update_coords
procedure::update_lattice_vectors=>mbd_calc_update_lattice_vectors
procedure::update_vdw_params_custom=>mbd_calc_update_vdw_params_custom
procedure::update_vdw_params_from_ratios=>mbd_calc_update_vdw_params_from_ratios
procedure::update_vdw_params_nl=>mbd_calc_update_vdw_params_nl
procedure::evaluate_vdw_method=>mbd_calc_evaluate_vdw_method
procedure::get_gradients=>mbd_calc_get_gradients
procedure::get_vdw_params_ratios_gradients=>mbd_calc_get_vdw_params_ratios_gradients
procedure::get_lattice_derivs=>mbd_calc_get_lattice_derivs
procedure::get_lattice_stress=>mbd_calc_get_lattice_stress
procedure::get_spectrum_modes=>mbd_calc_get_spectrum_modes
procedure::get_rpa_orders=>mbd_calc_get_rpa_orders
procedure::get_exception=>mbd_calc_get_exception
end type
private::mbd_calc_init
private::mbd_calc_destroy
private::mbd_calc_switch_forces
private::mbd_calc_update_coords
private::mbd_calc_update_lattice_vectors
private::mbd_calc_update_vdw_params_custom
private::mbd_calc_update_vdw_params_from_ratios
private::mbd_calc_get_vdw_params_ratios_gradients
private::mbd_calc_update_vdw_params_nl
private::mbd_calc_evaluate_vdw_method
private::mbd_calc_get_gradients
private::mbd_calc_get_lattice_derivs
private::mbd_calc_get_lattice_stress
private::mbd_calc_get_spectrum_modes
private::mbd_calc_get_rpa_orders
private::mbd_calc_get_exception
contains
subroutine mbd_calc_init(this,input)
class(mbd_calc_t),intent(inout),target::this
type(mbd_input_t),intent(in)::input
end
subroutine mbd_calc_destroy(this)
class(mbd_calc_t),intent(inout),target::this
end
subroutine mbd_calc_switch_forces(this,forces)
class(mbd_calc_t),intent(inout)::this
logical(4),intent(in)::forces
end
subroutine mbd_calc_update_coords(this,coords)
class(mbd_calc_t),intent(inout)::this
real(8),intent(in)::coords(:,:)
end
subroutine mbd_calc_update_lattice_vectors(this,latt_vecs)
class(mbd_calc_t),intent(inout)::this
real(8),intent(in)::latt_vecs(:,:)
end
subroutine mbd_calc_update_vdw_params_custom(this,alpha_0,c6,r_vdw)
class(mbd_calc_t),intent(inout)::this
real(8),intent(in)::alpha_0(:)
real(8),intent(in)::c6(:)
real(8),intent(in)::r_vdw(:)
end
subroutine mbd_calc_update_vdw_params_from_ratios(this,ratios)
class(mbd_calc_t),intent(inout)::this
real(8),intent(in)::ratios(:)
end
subroutine mbd_calc_get_vdw_params_ratios_gradients(this,de_dratios)
class(mbd_calc_t),intent(inout)::this
real(8),intent(out)::de_dratios(:)
end
subroutine mbd_calc_update_vdw_params_nl(this,alpha_0_ratios,c6_ratios)
class(mbd_calc_t),intent(inout)::this
real(8),intent(in)::alpha_0_ratios(:)
real(8),intent(in)::c6_ratios(:)
end
subroutine mbd_calc_evaluate_vdw_method(this,energy)
class(mbd_calc_t),intent(inout)::this
real(8),intent(out)::energy
end
subroutine mbd_calc_get_gradients(this,gradients)
class(mbd_calc_t),intent(in)::this
real(8),intent(out)::gradients(:,:)
end
subroutine mbd_calc_get_lattice_derivs(this,latt_derivs)
class(mbd_calc_t),intent(in)::this
real(8),intent(out)::latt_derivs(:,:)
end
subroutine mbd_calc_get_lattice_stress(this,stress)
class(mbd_calc_t),intent(in)::this
real(8),intent(out)::stress(:,:)
end
subroutine mbd_calc_get_spectrum_modes(this,spectrum,modes)
class(mbd_calc_t),intent(inout)::this
real(8),intent(out)::spectrum(:)
real(8),allocatable,intent(out),optional::modes(:,:)
end
subroutine mbd_calc_get_rpa_orders(this,rpa_orders)
class(mbd_calc_t),intent(inout)::this
real(8),allocatable,intent(out)::rpa_orders(:)
end
subroutine mbd_calc_get_exception(this,code,origin,msg)
class(mbd_calc_t),intent(inout)::this
integer(4),intent(out)::code
character(*,1),intent(out)::origin
character(*,1),intent(out)::msg
end
end
