﻿!mod$ v1 sum:10e1ac988db5e48c
!need$ 420c68d95a2dace6 n tblite_disp
!need$ dde600d55a5736db n tblite_integral_type
!need$ 6ce8da455f737480 n tblite_wavefunction_fermi
!need$ a9f89a464b2b4271 n tblite_wavefunction_mulliken
!need$ cc5a78110955c5d4 n tblite_xtb_coulomb
!need$ c348d486ad820221 n tblite_scf_mixer
!need$ 4ba9281d3cab36d6 n tblite_scf_potential
!need$ e96b11aedf1c65fa n tblite_scf_solver
!need$ 6e82d3989f57b438 n tblite_scf_info
!need$ e2ec289836760e68 n tblite_basis_type
!need$ d6bdee47f6502f3f n tblite_container
!need$ 86e45708dff95640 n tblite_wavefunction_type
!need$ 1f6fcd35e7441abe n mctc_io
!need$ ae78003ee30bd742 n mctc_env
module tblite_scf_iterator
use mctc_env,only:wp
use mctc_env,only:error_type
use mctc_io,only:structure_type
use tblite_basis_type,only:basis_type
use tblite_container,only:container_cache
use tblite_container,only:container_list
use tblite_disp,only:dispersion_type
use tblite_integral_type,only:integral_type
use tblite_wavefunction_type,only:wavefunction_type
use tblite_wavefunction_fermi,only:get_fermi_filling
use tblite_wavefunction_mulliken,only:get_mulliken_shell_charges
use tblite_wavefunction_mulliken,only:get_mulliken_atomic_multipoles
use tblite_xtb_coulomb,only:tb_coulomb
use tblite_scf_mixer,only:mixer_type
use tblite_scf_info,only:scf_info
use tblite_scf_potential,only:potential_type
use tblite_scf_potential,only:add_pot_to_h1
use tblite_scf_solver,only:solver_type
private::wp
private::error_type
private::structure_type
private::basis_type
private::container_cache
private::container_list
private::dispersion_type
private::integral_type
private::wavefunction_type
private::get_fermi_filling
private::get_mulliken_shell_charges
private::get_mulliken_atomic_multipoles
private::tb_coulomb
private::mixer_type
private::scf_info
private::potential_type
private::add_pot_to_h1
private::solver_type
private::set_mixer
private::diff_mixer
private::get_mixer
private::get_electronic_entropy
contains
subroutine next_scf(iscf,mol,bas,wfn,solver,mixer,info,coulomb,dispersion,interactions,ints,pot,ccache,dcache,icache,energies,error)
integer(4),intent(inout)::iscf
type(structure_type),intent(in)::mol
type(basis_type),intent(in)::bas
type(wavefunction_type),intent(inout)::wfn
class(solver_type),intent(inout)::solver
class(mixer_type),intent(inout)::mixer
type(scf_info),intent(in)::info
type(tb_coulomb),intent(in),optional::coulomb
class(dispersion_type),intent(in),optional::dispersion
type(container_list),intent(in),optional::interactions
type(integral_type),intent(in)::ints
type(potential_type),intent(inout)::pot
type(container_cache),intent(inout),optional::ccache
type(container_cache),intent(inout),optional::dcache
type(container_cache),intent(inout),optional::icache
real(8),intent(inout)::energies(:)
type(error_type),allocatable,intent(out)::error
end
subroutine get_electronic_energy(h0,density,energies)
real(8),intent(in)::h0(:,:)
real(8),intent(in)::density(:,:,:)
real(8),intent(inout)::energies(:)
end
subroutine reduce(reduced,full,map)
real(8),intent(inout)::reduced(:)
real(8),intent(in)::full(:)
integer(4),intent(in)::map(:)
end
subroutine get_qat_from_qsh(bas,qsh,qat)
type(basis_type),intent(in)::bas
real(8),intent(in)::qsh(:,:)
real(8),intent(out)::qat(:,:)
end
function get_mixer_dimension(mol,bas,info) result(ndim)
type(structure_type),intent(in)::mol
type(basis_type),intent(in)::bas
type(scf_info),intent(in)::info
integer(4)::ndim
end
subroutine set_mixer(mixer,wfn,info)
class(mixer_type),intent(inout)::mixer
type(wavefunction_type),intent(in)::wfn
type(scf_info),intent(in)::info
end
subroutine diff_mixer(mixer,wfn,info)
class(mixer_type),intent(inout)::mixer
type(wavefunction_type),intent(in)::wfn
type(scf_info),intent(in)::info
end
subroutine get_mixer(mixer,bas,wfn,info)
class(mixer_type),intent(inout)::mixer
type(basis_type),intent(in)::bas
type(wavefunction_type),intent(inout)::wfn
type(scf_info),intent(in)::info
end
subroutine next_density(wfn,solver,ints,ts,error)
type(wavefunction_type),intent(inout)::wfn
class(solver_type),intent(inout)::solver
type(integral_type),intent(in)::ints
real(8),intent(out)::ts
type(error_type),allocatable,intent(out)::error
end
subroutine get_electronic_entropy(occ,kt,s)
real(8),intent(in)::occ(:)
real(8),intent(in)::kt
real(8),intent(out)::s
end
end
