﻿!mod$ v1 sum:45dcdb6491c02418
!need$ f19d606d1dded2bc n tblite_coulomb_ewald
!need$ d9702214a8e500a8 n tblite_coulomb_charge_type
!need$ a53d5fe901b7082c n tblite_cutoff
!need$ 4ba9281d3cab36d6 n tblite_scf_potential
!need$ 86e45708dff95640 n tblite_wavefunction_type
!need$ d19067f21a7bc614 n tblite_wignerseitz
!need$ d6b91e53bed6f38f n mctc_io_constants
!need$ c301c17a17af4c8a n mctc_io_math
!need$ 518a13cedaeb9881 n tblite_coulomb_cache
!need$ 1f6fcd35e7441abe n mctc_io
!need$ ae78003ee30bd742 n mctc_env
!need$ 976c2c61ee34ace3 n tblite_blas
module tblite_coulomb_charge_effective
use mctc_env,only:wp
use mctc_io,only:structure_type
use mctc_io_math,only:matdet_3x3
use mctc_io_math,only:matinv_3x3
use mctc_io_constants,only:pi
use tblite_blas,only:dot
use tblite_blas,only:gemv
use tblite_blas,only:symv
use tblite_blas,only:gemm
use tblite_coulomb_cache,only:coulomb_cache
use tblite_coulomb_ewald,only:get_dir_cutoff
use tblite_coulomb_ewald,only:get_rec_cutoff
use tblite_coulomb_charge_type,only:coulomb_charge_type
use tblite_cutoff,only:get_lattice_points
use tblite_scf_potential,only:potential_type
use tblite_wavefunction_type,only:wavefunction_type
use tblite_wignerseitz,only:wignerseitz_cell
use tblite_cutoff,only:tblite_cutoff$tblite_cutoff$get_lattice_points_cutoff=>get_lattice_points_cutoff
private::wp
private::structure_type
private::matdet_3x3
private::matinv_3x3
private::pi
private::dot
private::gemv
private::symv
private::gemm
private::coulomb_cache
private::get_dir_cutoff
private::get_rec_cutoff
private::coulomb_charge_type
private::get_lattice_points
private::potential_type
private::wavefunction_type
private::wignerseitz_cell
private::tblite_cutoff$tblite_cutoff$get_lattice_points_cutoff
type,extends(coulomb_charge_type)::effective_coulomb
real(8),allocatable::hubbard(:,:,:,:)
real(8)::gexp
real(8)::rcut
contains
procedure::get_coulomb_matrix
procedure::get_coulomb_derivs
end type
abstract interface
pure function average_interface(gi,gj) result(gij)
real(8),intent(in)::gi
real(8),intent(in)::gj
real(8)::gij
end
end interface
real(8),parameter,private::twopi=6.28318530717958623199592693708837032318115234375_8
real(8),parameter,private::sqrtpi=1.772453850905515881919427556567825376987457275390625_8
intrinsic::sqrt
private::sqrt
real(8),parameter,private::eps=1.490116119384765625e-8_8
intrinsic::epsilon
private::epsilon
real(8),parameter,private::conv=1.490116119384765625e-8_8
character(*,1),parameter,private::label="isotropic Klopman-Ohno-Mataga-Nishimoto electrostatics"
private::get_coulomb_matrix
private::get_dir_trans
private::get_rec_trans
private::get_amat_0d
private::get_amat_3d
private::get_amat_dir_3d
private::get_amat_rec_3d
private::fsmooth
private::dsmooth
private::get_coulomb_derivs
private::get_damat_0d
private::get_damat_3d
private::get_damat_dir_3d
private::get_damat_rec_3d
contains
subroutine new_effective_coulomb(self,mol,gexp,hubbard,average,nshell)
type(effective_coulomb),intent(out)::self
type(structure_type),intent(in)::mol
real(8),intent(in)::gexp
real(8),intent(in)::hubbard(:,:)
procedure(average_interface)::average
integer(4),intent(in),optional::nshell(:)
end
pure function harmonic_average(gi,gj) result(gij)
real(8),intent(in)::gi
real(8),intent(in)::gj
real(8)::gij
end
pure function arithmetic_average(gi,gj) result(gij)
real(8),intent(in)::gi
real(8),intent(in)::gj
real(8)::gij
end
pure function geometric_average(gi,gj) result(gij)
real(8),intent(in)::gi
real(8),intent(in)::gj
real(8)::gij
end
subroutine get_coulomb_matrix(self,mol,cache,amat)
class(effective_coulomb),intent(in)::self
type(structure_type),intent(in)::mol
type(coulomb_cache),intent(inout)::cache
real(8),contiguous,intent(out)::amat(:,:)
end
subroutine get_dir_trans(lattice,alpha,conv,trans)
real(8),intent(in)::lattice(:,:)
real(8),intent(in)::alpha
real(8),intent(in)::conv
real(8),allocatable,intent(out)::trans(:,:)
end
subroutine get_rec_trans(lattice,alpha,volume,conv,trans)
real(8),intent(in)::lattice(:,:)
real(8),intent(in)::alpha
real(8),intent(in)::volume
real(8),intent(in)::conv
real(8),allocatable,intent(out)::trans(:,:)
end
subroutine get_amat_0d(mol,nshell,offset,hubbard,gexp,amat)
type(structure_type),intent(in)::mol
integer(4),intent(in)::nshell(:)
integer(4),intent(in)::offset(:)
real(8),intent(in)::hubbard(:,:,:,:)
real(8),intent(in)::gexp
real(8),intent(inout)::amat(:,:)
end
subroutine get_amat_3d(mol,nshell,offset,hubbard,gexp,rcut,wsc,alpha,amat)
type(structure_type),intent(in)::mol
integer(4),intent(in)::nshell(:)
integer(4),intent(in)::offset(:)
real(8),intent(in)::hubbard(:,:,:,:)
real(8),intent(in)::gexp
real(8),intent(in)::rcut
type(wignerseitz_cell),intent(in)::wsc
real(8),intent(in)::alpha
real(8),intent(inout)::amat(:,:)
end
subroutine get_amat_dir_3d(rij,gam,gexp,rcut,alp,trans,amat)
real(8),intent(in)::rij(1_8:3_8)
real(8),intent(in)::gam
real(8),intent(in)::gexp
real(8),intent(in)::rcut
real(8),intent(in)::alp
real(8),intent(in)::trans(:,:)
real(8),intent(out)::amat
end
subroutine get_amat_rec_3d(rij,vol,alp,qpc,trans,amat)
real(8),intent(in)::rij(1_8:3_8)
real(8),intent(in)::vol
real(8),intent(in)::alp
real(8),intent(in)::qpc
real(8),intent(in)::trans(:,:)
real(8),intent(out)::amat
end
function fsmooth(r1,rcut) result(fcut)
real(8),intent(in)::r1
real(8),intent(in)::rcut
real(8)::fcut
end
function dsmooth(r1,rcut) result(dcut)
real(8),intent(in)::r1
real(8),intent(in)::rcut
real(8)::dcut
end
subroutine get_coulomb_derivs(self,mol,cache,qat,qsh,dadr,dadl,atrace)
class(effective_coulomb),intent(in)::self
type(structure_type),intent(in)::mol
type(coulomb_cache),intent(inout)::cache
real(8),intent(in)::qat(:)
real(8),intent(in)::qsh(:)
real(8),contiguous,intent(out)::dadr(:,:,:)
real(8),contiguous,intent(out)::dadl(:,:,:)
real(8),contiguous,intent(out)::atrace(:,:)
end
subroutine get_damat_0d(mol,nshell,offset,hubbard,gexp,qvec,dadr,dadl,atrace)
type(structure_type),intent(in)::mol
integer(4),intent(in)::nshell(:)
integer(4),intent(in)::offset(:)
real(8),intent(in)::hubbard(:,:,:,:)
real(8),intent(in)::gexp
real(8),intent(in)::qvec(:)
real(8),intent(out)::dadr(:,:,:)
real(8),intent(out)::dadl(:,:,:)
real(8),intent(out)::atrace(:,:)
end
subroutine get_damat_3d(mol,nshell,offset,hubbard,gexp,rcut,wsc,alpha,qvec,dadr,dadl,atrace)
type(structure_type),intent(in)::mol
integer(4),intent(in)::nshell(:)
integer(4),intent(in)::offset(:)
real(8),intent(in)::hubbard(:,:,:,:)
real(8),intent(in)::gexp
real(8),intent(in)::rcut
type(wignerseitz_cell),intent(in)::wsc
real(8),intent(in)::alpha
real(8),intent(in)::qvec(:)
real(8),intent(out)::dadr(:,:,:)
real(8),intent(out)::dadl(:,:,:)
real(8),intent(out)::atrace(:,:)
end
subroutine get_damat_dir_3d(rij,gam,gexp,rcut,alp,trans,dg,ds)
real(8),intent(in)::rij(1_8:3_8)
real(8),intent(in)::gam
real(8),intent(in)::gexp
real(8),intent(in)::rcut
real(8),intent(in)::alp
real(8),intent(in)::trans(:,:)
real(8),intent(out)::dg(1_8:3_8)
real(8),intent(out)::ds(1_8:3_8,1_8:3_8)
end
subroutine get_damat_rec_3d(rij,vol,alp,qpc,trans,dg,ds)
real(8),intent(in)::rij(1_8:3_8)
real(8),intent(in)::vol
real(8),intent(in)::alp
real(8),intent(in)::qpc
real(8),intent(in)::trans(:,:)
real(8),intent(out)::dg(1_8:3_8)
real(8),intent(out)::ds(1_8:3_8,1_8:3_8)
end
end
