﻿!mod$ v1 sum:1f42a0f47678b1e2
!need$ 4edf22d48ee944f1 n dftd3_cutoff
!need$ 232b77ab29f7a52d n dftd3_damping
!need$ 7265c27815da5a05 n dftd3_model
!need$ 57b1632b89a4898d n dftd3_ncoord
!need$ ae78003ee30bd742 n mctc_env
!need$ 1f6fcd35e7441abe n mctc_io
!need$ 2f18d312ff6970f0 n mctc_io_convert
!need$ 96b9b8db6c36d455 n dftd3_data
module dftd3_disp
use dftd3_cutoff,only:realspace_cutoff
use dftd3_cutoff,only:get_lattice_points
use dftd3_damping,only:damping_param
use dftd3_data,only:get_covalent_rad
use dftd3_model,only:d3_model
use dftd3_ncoord,only:get_coordination_number
use dftd3_ncoord,only:add_coordination_number_derivs
use mctc_env,only:wp
use mctc_io,only:structure_type
use mctc_io_convert,only:autoaa
private::realspace_cutoff
private::get_lattice_points
private::damping_param
private::get_covalent_rad
private::d3_model
private::get_coordination_number
private::add_coordination_number_derivs
private::wp
private::structure_type
private::autoaa
private::get_dispersion_atomic
private::get_dispersion_scalar
interface get_dispersion
procedure::get_dispersion_atomic
procedure::get_dispersion_scalar
end interface
contains
subroutine get_dispersion_atomic(mol,disp,param,cutoff,energies,gradient,sigma)
class(structure_type),intent(in)::mol
class(d3_model),intent(in)::disp
class(damping_param),intent(in)::param
type(realspace_cutoff),intent(in)::cutoff
real(8),intent(out)::energies(:)
real(8),contiguous,intent(out),optional::gradient(:,:)
real(8),contiguous,intent(out),optional::sigma(:,:)
end
subroutine get_dispersion_scalar(mol,disp,param,cutoff,energy,gradient,sigma)
class(structure_type),intent(in)::mol
class(d3_model),intent(in)::disp
class(damping_param),intent(in)::param
type(realspace_cutoff),intent(in)::cutoff
real(8),intent(out)::energy
real(8),contiguous,intent(out),optional::gradient(:,:)
real(8),contiguous,intent(out),optional::sigma(:,:)
end
subroutine get_pairwise_dispersion(mol,disp,param,cutoff,energy2,energy3)
class(structure_type),intent(in)::mol
class(d3_model),intent(in)::disp
class(damping_param),intent(in)::param
type(realspace_cutoff),intent(in)::cutoff
real(8),intent(out)::energy2(:,:)
real(8),intent(out)::energy3(:,:)
end
end
