/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceGridGUI.Application;

import com.zeroc.IceGrid.BoxedString;
import com.zeroc.IceGrid.IceBoxDescriptor;
import com.zeroc.IceGrid.NodeDescriptor;
import com.zeroc.IceGrid.NodeUpdateDescriptor;
import com.zeroc.IceGrid.PropertyDescriptor;
import com.zeroc.IceGrid.PropertySetDescriptor;
import com.zeroc.IceGrid.ServerDescriptor;
import com.zeroc.IceGrid.ServerInstanceDescriptor;
import com.zeroc.IceGrid.TemplateDescriptor;
import com.zeroc.IceGridGUI.Application.Editable;
import com.zeroc.IceGridGUI.Application.Editor;
import com.zeroc.IceGridGUI.Application.NodeEditor;
import com.zeroc.IceGridGUI.Application.Nodes;
import com.zeroc.IceGridGUI.Application.PlainServer;
import com.zeroc.IceGridGUI.Application.PropertySet;
import com.zeroc.IceGridGUI.Application.PropertySetParent;
import com.zeroc.IceGridGUI.Application.PropertySets;
import com.zeroc.IceGridGUI.Application.Root;
import com.zeroc.IceGridGUI.Application.Server;
import com.zeroc.IceGridGUI.Application.ServerInstance;
import com.zeroc.IceGridGUI.Application.ServerTemplate;
import com.zeroc.IceGridGUI.Application.ServiceInstance;
import com.zeroc.IceGridGUI.Application.TreeNode;
import com.zeroc.IceGridGUI.Application.UpdateFailedException;
import com.zeroc.IceGridGUI.ApplicationActions;
import com.zeroc.IceGridGUI.Utils;
import com.zeroc.IceGridGUI.XMLWriter;
import java.awt.Component;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;

class Node
extends TreeNode
implements PropertySetParent {
    private NodeDescriptor _descriptor;
    private Utils.Resolver _resolver;
    private Map<String, String> _origVariables;
    private String _origDescription;
    private String _origLoadFactor;
    private final boolean _ephemeral;
    private NodeEditor _editor;
    private LinkedList<PropertySet> _propertySets = new LinkedList();
    private LinkedList<Server> _servers = new LinkedList();
    private Editable _editable;
    private static DefaultTreeCellRenderer _cellRenderer;
    private static JPopupMenu _popup;

    public static NodeDescriptor copyDescriptor(NodeDescriptor nd) {
        NodeDescriptor copy = nd.clone();
        copy.propertySets = PropertySets.copyDescriptors(copy.propertySets);
        copy.serverInstances = new LinkedList<ServerInstanceDescriptor>();
        for (ServerInstanceDescriptor serverInstanceDescriptor : nd.serverInstances) {
            copy.serverInstances.add(ServerInstance.copyDescriptor(serverInstanceDescriptor));
        }
        copy.servers = new LinkedList<ServerDescriptor>();
        for (ServerDescriptor serverDescriptor : nd.servers) {
            copy.servers.add(PlainServer.copyDescriptor(serverDescriptor));
        }
        return copy;
    }

    @Override
    public Enumeration<javax.swing.tree.TreeNode> children() {
        return new Enumeration<javax.swing.tree.TreeNode>(){
            private Iterator<PropertySet> _p;
            private Iterator<Server> _q;
            {
                this._p = Node.this._propertySets.iterator();
                this._q = Node.this._servers.iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this._p.hasNext() || this._q.hasNext();
            }

            @Override
            public javax.swing.tree.TreeNode nextElement() {
                if (this._p.hasNext()) {
                    return this._p.next();
                }
                return (javax.swing.tree.TreeNode)((Object)this._q.next());
            }
        };
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public javax.swing.tree.TreeNode getChildAt(int childIndex) {
        if (childIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(childIndex);
        }
        if (childIndex < this._propertySets.size()) {
            return this._propertySets.get(childIndex);
        }
        if (childIndex < this._propertySets.size() + this._servers.size()) {
            return (javax.swing.tree.TreeNode)((Object)this._servers.get(childIndex - this._propertySets.size()));
        }
        throw new ArrayIndexOutOfBoundsException(childIndex);
    }

    @Override
    public int getChildCount() {
        return this._propertySets.size() + this._servers.size();
    }

    @Override
    public int getIndex(javax.swing.tree.TreeNode node) {
        if (node instanceof PropertySet) {
            return this._propertySets.indexOf(node);
        }
        int index = this._servers.indexOf(node);
        if (index != -1) {
            index += this._propertySets.size();
        }
        return index;
    }

    @Override
    public boolean isLeaf() {
        return this._propertySets.isEmpty() && this._servers.isEmpty();
    }

    void removeServers(String[] childIds) {
        this.removeSortedChildren(childIds, this._servers, this.getRoot().getTreeModel());
    }

    void removePropertySets(String[] childIds) {
        this.removeSortedChildren(childIds, this._propertySets, this.getRoot().getTreeModel());
    }

    void childrenChanged(List children) {
        this.childrenChanged(children, this.getRoot().getTreeModel());
    }

    Server findServer(String id) {
        return (Server)((Object)this.find(id, this._servers));
    }

    PropertySet findPropertySet(String id) {
        return (PropertySet)this.find(id, this._propertySets);
    }

    void insertPropertySets(List<PropertySet> newChildren, boolean fireEvent) throws UpdateFailedException {
        DefaultTreeModel treeModel = fireEvent ? this.getRoot().getTreeModel() : null;
        String badChildId = this.insertSortedChildren(newChildren, this._propertySets, treeModel);
        if (badChildId != null) {
            throw new UpdateFailedException(this, badChildId);
        }
    }

    void insertServer(TreeNode child, boolean fireEvent) throws UpdateFailedException {
        DefaultTreeModel treeModel;
        DefaultTreeModel defaultTreeModel = treeModel = fireEvent ? this.getRoot().getTreeModel() : null;
        if (!this.insertSortedChild(child, this._servers, treeModel)) {
            throw new UpdateFailedException(this, child.getId());
        }
    }

    void insertServers(List<Server> newChildren, boolean fireEvent) throws UpdateFailedException {
        DefaultTreeModel treeModel = fireEvent ? this.getRoot().getTreeModel() : null;
        String badChildId = this.insertSortedChildren(newChildren, this._servers, treeModel);
        if (badChildId != null) {
            throw new UpdateFailedException(this, badChildId);
        }
    }

    void removeServer(TreeNode child) {
        int index = this.getIndex(child);
        this._servers.remove(child);
        this.getRoot().getTreeModel().nodesWereRemoved(this, new int[]{index}, new Object[]{child});
    }

    @Override
    public void insertPropertySet(PropertySet child, boolean fireEvent) throws UpdateFailedException {
        DefaultTreeModel treeModel;
        DefaultTreeModel defaultTreeModel = treeModel = fireEvent ? this.getRoot().getTreeModel() : null;
        if (!this.insertSortedChild(child, this._propertySets, treeModel)) {
            throw new UpdateFailedException(this, child.getId());
        }
    }

    @Override
    public void removePropertySet(PropertySet child) {
        int index = this.getIndex(child);
        this._propertySets.remove(child);
        this.getRoot().getTreeModel().nodesWereRemoved(this, new int[]{index}, new Object[]{child});
    }

    @Override
    public void removeDescriptor(String id) {
        this._descriptor.propertySets.remove(id);
    }

    @Override
    public Editable getEditable() {
        return this._editable;
    }

    @Override
    public boolean[] getAvailableActions() {
        boolean[] actions = new boolean[20];
        actions[13] = !this._ephemeral;
        actions[15] = true;
        Object descriptor = this.getCoordinator().getClipboard();
        if (descriptor != null) {
            boolean bl = actions[14] = descriptor instanceof NodeDescriptor || descriptor instanceof ServerInstanceDescriptor || descriptor instanceof ServerDescriptor || descriptor instanceof PropertySetDescriptor;
        }
        if (!this._ephemeral) {
            actions[16] = true;
            actions[17] = true;
            actions[3] = true;
            actions[5] = true;
            actions[6] = true;
            actions[7] = true;
        }
        return actions;
    }

    @Override
    public JPopupMenu getPopupMenu() {
        ApplicationActions actions = this.getCoordinator().getActionsForPopup();
        if (_popup == null) {
            _popup = new JPopupMenu();
            _popup.add(actions.get(3));
            _popup.addSeparator();
            _popup.add(actions.get(5));
            _popup.add(actions.get(6));
            _popup.add(actions.get(7));
        }
        actions.setTarget(this);
        return _popup;
    }

    @Override
    public void copy() {
        this.getCoordinator().setClipboard(Node.copyDescriptor(this._descriptor));
        this.getCoordinator().getActionsForMenu().get(14).setEnabled(true);
    }

    @Override
    public void paste() {
        Object descriptor = this.getCoordinator().getClipboard();
        if (descriptor instanceof NodeDescriptor) {
            ((TreeNode)this._parent).paste();
        } else if (descriptor instanceof PropertySetDescriptor) {
            this.newPropertySet(PropertySet.copyDescriptor((PropertySetDescriptor)descriptor));
        } else if (descriptor instanceof ServerInstanceDescriptor) {
            ServerInstanceDescriptor sid = ServerInstance.copyDescriptor((ServerInstanceDescriptor)descriptor);
            TemplateDescriptor td = this.getRoot().findServerTemplateDescriptor(sid.template);
            if (td != null) {
                sid.parameterValues.keySet().retainAll(td.parameters);
            }
            this.newServer(sid);
        } else {
            ServerDescriptor sd = PlainServer.copyDescriptor((ServerDescriptor)descriptor);
            if (sd instanceof IceBoxDescriptor && !this.getRoot().pasteIceBox((IceBoxDescriptor)sd)) {
                return;
            }
            this.newServer(sd);
        }
    }

    @Override
    public void newPropertySet() {
        this.newPropertySet(new PropertySetDescriptor(new String[0], new LinkedList<PropertyDescriptor>()));
    }

    @Override
    public void newServer() {
        this.newServer(PlainServer.newServerDescriptor());
    }

    @Override
    public void newServerIceBox() {
        this.newServer(PlainServer.newIceBoxDescriptor());
    }

    @Override
    public void newServerFromTemplate() {
        ServerInstanceDescriptor descriptor = new ServerInstanceDescriptor("", new HashMap<String, String>(), new PropertySetDescriptor(new String[0], new LinkedList<PropertyDescriptor>()), new HashMap<String, PropertySetDescriptor>());
        this.newServer(descriptor);
    }

    @Override
    public void destroy() {
        Nodes nodes = (Nodes)this._parent;
        if (this._ephemeral) {
            nodes.removeChild(this);
        } else {
            nodes.removeChild(this);
            nodes.removeDescriptor(this._id);
            nodes.getEditable().removeElement(this._id, this._editable, Node.class);
            this.getRoot().updated();
        }
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (_cellRenderer == null) {
            _cellRenderer = new DefaultTreeCellRenderer();
            ImageIcon nodeIcon = Utils.getIcon("/icons/16x16/node.png");
            _cellRenderer.setOpenIcon(nodeIcon);
            _cellRenderer.setClosedIcon(nodeIcon);
        }
        return _cellRenderer.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
    }

    @Override
    public Editor getEditor() {
        if (this._editor == null) {
            this._editor = (NodeEditor)this.getRoot().getEditor(NodeEditor.class, this);
        }
        this._editor.show(this);
        return this._editor;
    }

    @Override
    protected Editor createEditor() {
        return new NodeEditor();
    }

    @Override
    public boolean isEphemeral() {
        return this._ephemeral;
    }

    @Override
    Object getDescriptor() {
        return this._descriptor;
    }

    NodeDescriptor saveDescriptor() {
        return this._descriptor.clone();
    }

    void restoreDescriptor(NodeDescriptor copy) {
        this._descriptor.description = copy.description;
        this._descriptor.loadFactor = copy.loadFactor;
        this._descriptor.variables = copy.variables;
    }

    @Override
    void write(XMLWriter writer) throws IOException {
        if (!this._ephemeral) {
            LinkedList<String[]> attributes = new LinkedList<String[]>();
            attributes.add(Node.createAttribute("name", this._id));
            if (this._descriptor.loadFactor.length() > 0) {
                attributes.add(Node.createAttribute("load-factor", this._descriptor.loadFactor));
            }
            writer.writeStartTag("node", attributes);
            if (this._descriptor.description.length() > 0) {
                writer.writeElement("description", this._descriptor.description);
            }
            Node.writeVariables(writer, this._descriptor.variables);
            for (PropertySet propertySet : this._propertySets) {
                propertySet.write(writer);
            }
            for (Server server : this._servers) {
                TreeNode server2 = (TreeNode)((Object)server);
                server2.write(writer);
            }
            writer.writeEndTag("node");
        }
    }

    Backup rebuild(List<Editable> editables) throws UpdateFailedException {
        Utils.Resolver resolver;
        Root root = this.getRoot();
        Backup backup = new Backup();
        backup.resolver = this._resolver;
        this._resolver = resolver = new Utils.Resolver(new Map[]{this._descriptor.variables, root.getVariables()});
        this._resolver.put("application", root.getId());
        this._resolver.put("node", this._id);
        backup.backupList = new Vector<Object>();
        backup.servers = new LinkedList<Server>(this._servers);
        for (Server p : backup.servers) {
            try {
                backup.backupList.add(p.rebuild(editables));
            }
            catch (UpdateFailedException e) {
                this.restore(backup);
                throw e;
            }
        }
        return backup;
    }

    void commit() {
        this._editable.commit();
        this._origVariables = this._descriptor.variables;
        this._origDescription = this._descriptor.description;
        this._origLoadFactor = this._descriptor.loadFactor;
        for (PropertySet propertySet : this._propertySets) {
            propertySet.commit();
        }
        for (Server server : this._servers) {
            server.getEditable().commit();
        }
    }

    void restore(Backup backup) {
        for (int i = backup.backupList.size() - 1; i >= 0; --i) {
            backup.servers.get(i).restore(backup.backupList.get(i));
        }
        this._resolver = backup.resolver;
    }

    ServerInstance createServer(boolean brandNew, ServerInstanceDescriptor instanceDescriptor) throws UpdateFailedException {
        Root root = this.getRoot();
        TemplateDescriptor templateDescriptor = root.findServerTemplateDescriptor(instanceDescriptor.template);
        if (templateDescriptor == null) {
            throw new UpdateFailedException("Cannot find template descriptor '" + instanceDescriptor.template + "' referenced by server-instance");
        }
        ServerDescriptor serverDescriptor = (ServerDescriptor)templateDescriptor.descriptor;
        assert (serverDescriptor != null);
        boolean isIceBox = serverDescriptor instanceof IceBoxDescriptor;
        Utils.Resolver instanceResolver = new Utils.Resolver(this._resolver, instanceDescriptor.parameterValues, templateDescriptor.parameterDefaults);
        String serverId = instanceResolver.substitute(serverDescriptor.id);
        instanceResolver.put("server", serverId);
        return new ServerInstance(brandNew, this, serverId, instanceResolver, instanceDescriptor, isIceBox);
    }

    PlainServer createServer(boolean brandNew, ServerDescriptor serverDescriptor) throws UpdateFailedException {
        Utils.Resolver instanceResolver = new Utils.Resolver(this._resolver);
        String serverId = instanceResolver.substitute(serverDescriptor.id);
        instanceResolver.put("server", serverId);
        return new PlainServer(brandNew, this, serverId, instanceResolver, serverDescriptor);
    }

    NodeUpdateDescriptor getUpdate() {
        NodeUpdateDescriptor update = new NodeUpdateDescriptor();
        update.name = this._id;
        if (this._editable.isNew()) {
            update.removePropertySets = new String[0];
            update.propertySets = this._descriptor.propertySets;
        } else {
            update.removePropertySets = this._editable.removedElements(PropertySet.class);
            update.propertySets = new HashMap<String, PropertySetDescriptor>();
            for (PropertySet propertySet : this._propertySets) {
                if (!propertySet.getEditable().isNew() && !propertySet.getEditable().isModified()) continue;
                update.propertySets.put(propertySet.getId(), (PropertySetDescriptor)propertySet.getDescriptor());
            }
        }
        update.removeServers = this._editable.isNew() ? new String[0] : this._editable.removedElements(Server.class);
        update.serverInstances = new LinkedList<ServerInstanceDescriptor>();
        update.servers = new LinkedList<ServerDescriptor>();
        for (Server server : this._servers) {
            if (!this._editable.isNew() && !server.getEditable().isModified() && !server.getEditable().isNew()) continue;
            if (server instanceof PlainServer) {
                update.servers.add((ServerDescriptor)server.getDescriptor());
                continue;
            }
            update.serverInstances.add((ServerInstanceDescriptor)server.getDescriptor());
        }
        if (!this._editable.isNew() && !this._editable.isModified() && update.removePropertySets.length == 0 && update.propertySets.size() == 0 && update.removeServers.length == 0 && update.servers.size() == 0 && update.serverInstances.size() == 0) {
            return null;
        }
        if (this._editable.isNew()) {
            update.variables = this._descriptor.variables;
            update.removeVariables = new String[0];
            update.loadFactor = new BoxedString(this._descriptor.loadFactor);
            update.description = new BoxedString(this._descriptor.description);
        } else {
            if (!this._descriptor.description.equals(this._origDescription)) {
                update.description = new BoxedString(this._descriptor.description);
            }
            if (!this._descriptor.loadFactor.equals(this._origLoadFactor)) {
                update.loadFactor = new BoxedString(this._descriptor.loadFactor);
            }
            update.variables = new TreeMap<String, String>(this._descriptor.variables);
            LinkedList<String> removeVariables = new LinkedList<String>();
            for (Map.Entry<String, String> p : this._origVariables.entrySet()) {
                String key = p.getKey();
                String newValue = update.variables.get(key);
                if (newValue == null) {
                    removeVariables.add(key);
                    continue;
                }
                String value = p.getValue();
                if (!newValue.equals(value)) continue;
                update.variables.remove(key);
            }
            update.removeVariables = removeVariables.toArray(new String[0]);
        }
        return update;
    }

    /*
     * WARNING - void declaration
     */
    void update(NodeUpdateDescriptor update, Set<String> serverTemplates, Set<String> serviceTemplates) throws UpdateFailedException {
        Server server;
        Root root = this.getRoot();
        Vector<Server> newServers = new Vector<Server>();
        Vector<Server> updatedServers = new Vector<Server>();
        if (update != null) {
            void var9_13;
            void var9_11;
            if (update.description != null) {
                this._origDescription = this._descriptor.description = update.description.value;
            }
            if (update.loadFactor != null) {
                this._origLoadFactor = this._descriptor.loadFactor = update.loadFactor.value;
            }
            String[] stringArray = update.removeVariables;
            int n = stringArray.length;
            boolean bl = false;
            while (var9_11 < n) {
                String name = stringArray[var9_11];
                this._descriptor.variables.remove(name);
                ++var9_11;
            }
            this._descriptor.variables.putAll(update.variables);
            this.removePropertySets(update.removePropertySets);
            stringArray = update.removePropertySets;
            n = stringArray.length;
            boolean bl2 = false;
            while (var9_13 < n) {
                String id = stringArray[var9_13];
                this._descriptor.propertySets.remove(id);
                ++var9_13;
            }
            Vector<PropertySet> newPropertySets = new Vector<PropertySet>();
            Vector<PropertySet> updatedPropertySets = new Vector<PropertySet>();
            for (Map.Entry<String, PropertySetDescriptor> p : update.propertySets.entrySet()) {
                String id = p.getKey();
                PropertySetDescriptor propertySetDescriptor = p.getValue();
                PropertySet ps = this.findPropertySet(id);
                if (ps != null) {
                    ps.rebuild(propertySetDescriptor);
                    updatedPropertySets.add(ps);
                    continue;
                }
                ps = new PropertySet(false, this, id, id, propertySetDescriptor);
                newPropertySets.add(ps);
                this._descriptor.propertySets.put(id, propertySetDescriptor);
            }
            this.childrenChanged(updatedPropertySets);
            this.insertPropertySets(newPropertySets, true);
            for (String string : update.removeServers) {
                server = this.findServer(string);
                this.removeDescriptor(server);
            }
            this.removeServers(update.removeServers);
            for (ServerInstanceDescriptor p : update.serverInstances) {
                TemplateDescriptor templateDescriptor = root.findServerTemplateDescriptor(p.template);
                assert (templateDescriptor != null);
                ServerDescriptor serverDescriptor = (ServerDescriptor)templateDescriptor.descriptor;
                assert (serverDescriptor != null);
                Utils.Resolver instanceResolver = new Utils.Resolver(this._resolver, p.parameterValues, templateDescriptor.parameterDefaults);
                String serverId = instanceResolver.substitute(serverDescriptor.id);
                instanceResolver.put("server", serverId);
                ServerInstance server2 = (ServerInstance)this.findServer(serverId);
                if (server2 != null) {
                    this.removeDescriptor(server2);
                    server2.rebuild(instanceResolver, p, serverDescriptor instanceof IceBoxDescriptor);
                    updatedServers.add(server2);
                    this._descriptor.serverInstances.add(p);
                    continue;
                }
                server2 = new ServerInstance(false, this, serverId, instanceResolver, p, serverDescriptor instanceof IceBoxDescriptor);
                newServers.add(server2);
                this._descriptor.serverInstances.add(p);
            }
            for (ServerDescriptor p : update.servers) {
                Utils.Resolver instanceResolver = new Utils.Resolver(this._resolver);
                String string = instanceResolver.substitute(p.id);
                instanceResolver.put("server", string);
                server = (PlainServer)this.findServer(string);
                if (server != null) {
                    this.removeDescriptor(server);
                    ((PlainServer)server).rebuild(instanceResolver, p);
                    updatedServers.add(server);
                    this._descriptor.servers.add(p);
                    continue;
                }
                server = new PlainServer(false, this, string, instanceResolver, p);
                newServers.add(server);
                this._descriptor.servers.add(p);
            }
        }
        HashSet<Server> serverSet = new HashSet<Server>();
        for (String string : serverTemplates) {
            List<ServerInstance> serverInstances = this.findServerInstances(string);
            for (ServerInstance serverInstance : serverInstances) {
                if (updatedServers.contains(serverInstance) || newServers.contains(serverInstance)) continue;
                serverSet.add(serverInstance);
            }
        }
        for (String string : serviceTemplates) {
            List<ServiceInstance> serviceInstances = this.findServiceInstances(string);
            for (ServiceInstance serviceInstance : serviceInstances) {
                server = (Server)((Object)serviceInstance.getParent().getParent());
                if (updatedServers.contains(server) || newServers.contains(server)) continue;
                serverSet.add(server);
            }
        }
        for (Server server2 : serverSet) {
            if (server2 instanceof PlainServer) {
                PlainServer ps = (PlainServer)server2;
                ServerDescriptor serverDescriptor = (ServerDescriptor)ps.getDescriptor();
                Utils.Resolver resolver = new Utils.Resolver(this._resolver);
                String serverId = resolver.substitute(serverDescriptor.id);
                assert (serverId.equals(ps.getId()));
                ps.rebuild(resolver, serverDescriptor);
            } else {
                ServerInstance si = (ServerInstance)server2;
                ServerInstanceDescriptor instanceDescriptor = (ServerInstanceDescriptor)si.getDescriptor();
                TemplateDescriptor templateDescriptor = root.findServerTemplateDescriptor(instanceDescriptor.template);
                assert (templateDescriptor != null);
                ServerDescriptor serverDescriptor = (ServerDescriptor)templateDescriptor.descriptor;
                assert (serverDescriptor != null);
                Utils.Resolver instanceResolver = new Utils.Resolver(this._resolver, instanceDescriptor.parameterValues, templateDescriptor.parameterDefaults);
                String serverId = instanceResolver.substitute(serverDescriptor.id);
                assert (serverId.equals(si.getId()));
                si.rebuild(instanceResolver, instanceDescriptor, serverDescriptor instanceof IceBoxDescriptor);
            }
            updatedServers.add(server2);
        }
        this.childrenChanged(updatedServers);
        this.insertServers(newServers, true);
    }

    Node(boolean brandNew, TreeNode parent, String nodeName, NodeDescriptor descriptor) throws UpdateFailedException {
        super(parent, nodeName);
        Utils.Resolver resolver;
        this._editable = new Editable(brandNew);
        this._ephemeral = false;
        this._descriptor = descriptor;
        this._origVariables = this._descriptor.variables;
        this._origDescription = this._descriptor.description;
        this._origLoadFactor = this._descriptor.loadFactor;
        this._resolver = resolver = new Utils.Resolver(new Map[]{this._descriptor.variables, this.getRoot().getVariables()});
        this._resolver.put("application", this.getRoot().getId());
        this._resolver.put("node", this._id);
        for (Map.Entry<String, PropertySetDescriptor> entry : this._descriptor.propertySets.entrySet()) {
            String id = entry.getKey();
            this.insertPropertySet(new PropertySet(false, this, id, id, entry.getValue()), false);
        }
        for (ServerInstanceDescriptor serverInstanceDescriptor : this._descriptor.serverInstances) {
            this.insertServer(this.createServer(false, serverInstanceDescriptor), false);
        }
        for (ServerDescriptor serverDescriptor : this._descriptor.servers) {
            this.insertServer(this.createServer(false, serverDescriptor), false);
        }
    }

    Node(TreeNode parent, String nodeName, NodeDescriptor descriptor) {
        super(parent, nodeName);
        this._editable = new Editable(false);
        this._ephemeral = true;
        this._descriptor = descriptor;
    }

    List<ServerInstance> findServerInstances(String template) {
        LinkedList<ServerInstance> result = new LinkedList<ServerInstance>();
        for (Server p : this._servers) {
            if (!(p instanceof ServerInstance)) continue;
            ServerInstanceDescriptor instanceDescriptor = (ServerInstanceDescriptor)p.getDescriptor();
            if (!instanceDescriptor.template.equals(template)) continue;
            result.add((ServerInstance)p);
        }
        return result;
    }

    void removeServerInstances(String template) {
        LinkedList<String> toRemove = new LinkedList<String>();
        for (Server p : this._servers) {
            if (!(p instanceof ServerInstance)) continue;
            ServerInstanceDescriptor instanceDescriptor = (ServerInstanceDescriptor)p.getDescriptor();
            if (!instanceDescriptor.template.equals(template)) continue;
            this.removeDescriptor(instanceDescriptor);
            String id = ((TreeNode)((Object)p)).getId();
            this._editable.removeElement(id, p.getEditable(), Server.class);
            toRemove.add(id);
        }
        if (toRemove.size() > 0) {
            this.removeServers(toRemove.toArray(new String[0]));
        }
    }

    List<ServiceInstance> findServiceInstances(String template) {
        LinkedList<ServiceInstance> result = new LinkedList<ServiceInstance>();
        for (Server p : this._servers) {
            if (!(p instanceof PlainServer)) continue;
            result.addAll(((PlainServer)p).findServiceInstances(template));
        }
        return result;
    }

    void removeServiceInstances(String template) {
        for (Server p : this._servers) {
            if (!(p instanceof PlainServer)) continue;
            ((PlainServer)p).removeServiceInstances(template);
        }
    }

    @Override
    Utils.Resolver getResolver() {
        return this._resolver;
    }

    @Override
    public void tryAdd(String id, PropertySetDescriptor descriptor) throws UpdateFailedException {
        this.insertPropertySet(new PropertySet(true, this, id, id, descriptor), true);
        this._descriptor.propertySets.put(id, descriptor);
    }

    @Override
    public void tryRename(String oldId, String oldId2, String newId) throws UpdateFailedException {
        PropertySet oldChild = this.findPropertySet(oldId);
        assert (oldChild != null);
        this.removePropertySet(oldChild);
        PropertySetDescriptor descriptor = (PropertySetDescriptor)oldChild.getDescriptor();
        try {
            this.insertPropertySet(new PropertySet(true, this, newId, newId, descriptor), true);
        }
        catch (UpdateFailedException ex) {
            block5: {
                try {
                    this.insertPropertySet(oldChild, true);
                }
                catch (UpdateFailedException ufe) {
                    if ($assertionsDisabled) break block5;
                    throw new AssertionError();
                }
            }
            throw ex;
        }
        this._editable.removeElement(oldId, oldChild.getEditable(), PropertySet.class);
        this._descriptor.propertySets.remove(oldId);
        this._descriptor.propertySets.put(newId, descriptor);
    }

    void tryAdd(ServerInstanceDescriptor instanceDescriptor, boolean addDescriptor) throws UpdateFailedException {
        this.insertServer(this.createServer(true, instanceDescriptor), true);
        if (addDescriptor) {
            this._descriptor.serverInstances.add(instanceDescriptor);
        }
    }

    void tryAdd(ServerDescriptor serverDescriptor, boolean addDescriptor) throws UpdateFailedException {
        this.insertServer(this.createServer(true, serverDescriptor), true);
        if (addDescriptor) {
            this._descriptor.servers.add(serverDescriptor);
        }
    }

    void removeDescriptor(Server server) {
        if (server instanceof ServerInstance) {
            this.removeDescriptor((ServerInstanceDescriptor)server.getDescriptor());
        } else {
            this.removeDescriptor((ServerDescriptor)server.getDescriptor());
        }
    }

    void removeDescriptor(ServerDescriptor sd) {
        Iterator<ServerDescriptor> p = this._descriptor.servers.iterator();
        while (p.hasNext()) {
            if (sd != p.next()) continue;
            p.remove();
            break;
        }
    }

    void removeDescriptor(ServerInstanceDescriptor sd) {
        Iterator<ServerInstanceDescriptor> p = this._descriptor.serverInstances.iterator();
        while (p.hasNext()) {
            if (sd != p.next()) continue;
            p.remove();
            break;
        }
    }

    private void newPropertySet(PropertySetDescriptor descriptor) {
        PropertySet ps;
        block2: {
            String id = this.makeNewChildId("PropertySet");
            ps = new PropertySet(this, id, descriptor);
            try {
                this.insertPropertySet(ps, true);
            }
            catch (UpdateFailedException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        this.getRoot().setSelectedNode(ps);
    }

    private void newServer(ServerDescriptor descriptor) {
        PlainServer server;
        block2: {
            descriptor.id = this.makeNewChildId(descriptor.id);
            server = new PlainServer(this, descriptor.id, descriptor);
            try {
                this.insertServer(server, true);
            }
            catch (UpdateFailedException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        this.getRoot().setSelectedNode(server);
    }

    private void newServer(ServerInstanceDescriptor descriptor) {
        ServerInstance server;
        Root root;
        block4: {
            String id = this.makeNewChildId("NewServer");
            root = this.getRoot();
            ServerTemplate t = root.findServerTemplate(descriptor.template);
            if (t == null) {
                if (root.getServerTemplates().getChildCount() == 0) {
                    JOptionPane.showMessageDialog(this.getCoordinator().getMainFrame(), "You need to create a server template before you can create a server from a template.", "No Server Template", 1);
                    return;
                }
                t = (ServerTemplate)root.getServerTemplates().getChildAt(0);
                descriptor.template = t.getId();
                descriptor.parameterValues = new HashMap<String, String>();
            }
            server = new ServerInstance(this, id, descriptor);
            try {
                this.insertServer(server, true);
            }
            catch (UpdateFailedException e) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
        root.setSelectedNode(server);
    }

    static class Backup {
        Utils.Resolver resolver;
        List<Object> backupList;
        List<Server> servers;

        Backup() {
        }
    }
}

