\name{VectorIndexSelectionCastImageFilter}
\alias{VectorIndexSelectionCastImageFilter}
\title{VectorIndexSelectionCastImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Extracts the selected index of the vector that is the input pixel
type.
VectorIndexSelectionCastImageFilter}
\details{
This filter is templated over the input image type and output image
type.
The filter expect the input image pixel type to be a vector and the
output image pixel type to be a scalar. The only requirement on the
type used for representing the vector is that it must provide an
operator[].
See:
ComposeImageFilter
VectorIndexSelectionCast for the procedural interface
itk::VectorIndexSelectionCastImageFilter for the Doxygen on the original ITK class.
VectorIndexSelectionCastImageFilter}
%C++ includes: sitkVectorIndexSelectionCastImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1):}{}
\item{Image Execute(Image &&image1):}{
Execute the filter on the input image
}
\item{unsigned int GetIndex() const:}{
Get/Set methods for the index
}
\item{std::string GetName() const:}{
Name of this class
}
\item{PixelIDValueEnum GetOutputPixelType() const:}{
Get the ouput pixel type.
}
\item{Self SetIndex(unsigned int Index):}{
Get/Set methods for the index
}
\item{Self SetOutputPixelType(PixelIDValueEnum OutputPixelType):}{
Set the output pixel type of the scalar component to extract.
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ VectorIndexSelectionCastImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{ ~VectorIndexSelectionCastImageFilter():}{
Destructor
}
}
}
