/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.elk.alg.layered.options.CrossingMinimizationStrategy;
import org.eclipse.elk.alg.layered.options.CycleBreakingStrategy;
import org.eclipse.elk.alg.layered.options.LayerConstraint;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.alg.layered.options.LayeringStrategy;
import org.eclipse.elk.alg.layered.options.OrderingStrategy;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.options.Direction;
import org.eclipse.elk.core.util.IGraphElementVisitor;
import org.eclipse.elk.graph.ElkConnectableShape;
import org.eclipse.elk.graph.ElkEdge;
import org.eclipse.elk.graph.ElkGraphElement;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.elk.graph.ElkPort;
import org.eclipse.elk.graph.properties.IProperty;

public class InteractiveLayeredGraphVisitor
implements IGraphElementVisitor {
    public static final int PSEUDO_POSITION_SPACING = Integer.MAX_VALUE;
    public static final int LAST_LAYER_INDEX = Integer.MAX_VALUE;

    @Override
    public void visit(ElkGraphElement element) {
        if (element instanceof ElkNode) {
            ElkNode root = (ElkNode)element;
            this.setInteractiveOptionsAndPseudoPositions(root);
        }
    }

    private void setInteractiveOptionsAndPseudoPositions(ElkNode root) {
        String algorithm;
        if (!root.getChildren().isEmpty() && ((algorithm = root.getProperty(CoreOptions.ALGORITHM)) == null || "org.eclipse.elk.layered".endsWith(algorithm))) {
            for (ElkNode node : root.getChildren()) {
                if (node.hasProperty(LayeredOptions.LAYERING_LAYER_CONSTRAINT)) {
                    LayerConstraint constraint = node.getProperty(LayeredOptions.LAYERING_LAYER_CONSTRAINT);
                    node.setProperty(LayeredOptions.LAYERING_LAYER_CONSTRAINT, LayerConstraint.NONE);
                    switch (constraint) {
                        case FIRST: {
                            if (node.hasProperty(LayeredOptions.LAYERING_LAYER_CHOICE_CONSTRAINT)) break;
                            node.setProperty(LayeredOptions.LAYERING_LAYER_CHOICE_CONSTRAINT, 0);
                            break;
                        }
                        case LAST: {
                            if (node.hasProperty(LayeredOptions.LAYERING_LAYER_CHOICE_CONSTRAINT)) break;
                            node.setProperty(LayeredOptions.LAYERING_LAYER_CHOICE_CONSTRAINT, Integer.MAX_VALUE);
                        }
                    }
                }
                this.setCoordinates(root);
                this.setInteractiveStrategies(root);
            }
        }
    }

    private void setCoordinates(ElkNode root) {
        List<List<ElkNode>> layers = this.calcLayerNodes(root.getChildren());
        Direction direction = root.getProperty(LayeredOptions.DIRECTION);
        this.setCoordinateInLayoutDirection(layers, direction);
        int layerId = 0;
        for (List<ElkNode> layer : layers) {
            if (layer.size() <= 0) continue;
            this.setCoordinatesOrthogonalToLayoutDirection(layer, layerId, direction);
            ++layerId;
        }
    }

    private List<List<ElkNode>> calcLayerNodes(List<ElkNode> nodes) {
        ArrayList<ElkNode> nodesWithoutC = new ArrayList<ElkNode>();
        ArrayList<ElkNode> nodesWithLayerConstraint = new ArrayList<ElkNode>();
        List<ElkNode> nodesWithRC = new ArrayList<ElkNode>();
        ArrayList<ElkNode> nodesWithRCAndLC = new ArrayList<ElkNode>();
        for (ElkNode node : nodes) {
            if (node.hasProperty(LayeredOptions.LAYERING_LAYER_CHOICE_CONSTRAINT) && (node.hasProperty(LayeredOptions.CROSSING_MINIMIZATION_IN_LAYER_PRED_OF) || node.hasProperty(LayeredOptions.CROSSING_MINIMIZATION_IN_LAYER_SUCC_OF))) {
                nodesWithRCAndLC.add(node);
                continue;
            }
            if (node.hasProperty(LayeredOptions.LAYERING_LAYER_CHOICE_CONSTRAINT)) {
                nodesWithLayerConstraint.add(node);
                continue;
            }
            if (node.hasProperty(LayeredOptions.CROSSING_MINIMIZATION_IN_LAYER_PRED_OF) || node.hasProperty(LayeredOptions.CROSSING_MINIMIZATION_IN_LAYER_SUCC_OF)) {
                nodesWithRC.add(node);
                continue;
            }
            nodesWithoutC.add(node);
        }
        this.updateListsForLayerAssignment(nodesWithRCAndLC, nodes, nodesWithLayerConstraint, nodesWithRC, nodesWithoutC);
        nodesWithRC = this.sortRCNodes(nodesWithRC, nodes, nodesWithoutC);
        List<List<ElkNode>> layerNodes = this.initialLayers(nodesWithoutC);
        int diff = this.assignLayersToNodesWithProperty(nodesWithLayerConstraint, layerNodes);
        this.assignLayersToNodesWithRC(nodesWithRC, layerNodes, nodes, diff);
        return layerNodes;
    }

    private void updateListsForLayerAssignment(List<ElkNode> nodesWithRCAndLC, List<ElkNode> nodes, ArrayList<ElkNode> nodesWithLayerConstraint, List<ElkNode> nodesWithRC, ArrayList<ElkNode> nodesWithoutC) {
        int i = 0;
        while (i < nodesWithRCAndLC.size()) {
            ElkNode node = nodesWithRCAndLC.get(i);
            nodesWithLayerConstraint.add(node);
            ArrayList<ElkNode> targets = new ArrayList<ElkNode>();
            if (node.hasProperty(LayeredOptions.CROSSING_MINIMIZATION_IN_LAYER_PRED_OF)) {
                targets.add(this.getElkNode(nodes, node.getProperty(LayeredOptions.CROSSING_MINIMIZATION_IN_LAYER_PRED_OF)));
            }
            if (node.hasProperty(LayeredOptions.CROSSING_MINIMIZATION_IN_LAYER_SUCC_OF)) {
                targets.add(this.getElkNode(nodes, node.getProperty(LayeredOptions.CROSSING_MINIMIZATION_IN_LAYER_SUCC_OF)));
            }
            for (ElkNode target : targets) {
                if (target.hasProperty(LayeredOptions.LAYERING_LAYER_CHOICE_CONSTRAINT)) continue;
                int val = node.getProperty(LayeredOptions.LAYERING_LAYER_CHOICE_CONSTRAINT);
                target.setProperty(LayeredOptions.LAYERING_LAYER_CHOICE_CONSTRAINT, val);
                if (!nodesWithRC.contains(target)) {
                    nodesWithLayerConstraint.add(target);
                    nodesWithoutC.remove(target);
                    continue;
                }
                nodesWithRCAndLC.add(target);
                nodesWithRC.remove(target);
            }
            ++i;
        }
    }

    private void assignLayersToNodesWithRC(List<ElkNode> nodesWithRC, List<List<ElkNode>> layering, List<ElkNode> allNodes, int diff) {
        int i = 0;
        while (i < nodesWithRC.size()) {
            ElkNode node = nodesWithRC.get(i);
            ElkNode succNode = null;
            ElkNode predNode = null;
            String succName = node.getProperty(LayeredOptions.CROSSING_MINIMIZATION_IN_LAYER_PRED_OF);
            String predName = node.getProperty(LayeredOptions.CROSSING_MINIMIZATION_IN_LAYER_SUCC_OF);
            if (succName != null) {
                succNode = this.getElkNode(allNodes, succName);
            }
            if (predName != null) {
                predNode = this.getElkNode(allNodes, predName);
            }
            IProperty<Integer> layProp = LayeredOptions.LAYERING_LAYER_CHOICE_CONSTRAINT;
            if (succNode != null && predNode != null) {
                List<ElkNode> chain = this.getChainByAllNodes(node, allNodes);
                int succVal = succNode.hasProperty(layProp) ? succNode.getProperty(layProp).intValue() : succNode.getProperty(LayeredOptions.LAYERING_LAYER_ID).intValue();
                int predVal = predNode.hasProperty(layProp) ? predNode.getProperty(layProp).intValue() : predNode.getProperty(LayeredOptions.LAYERING_LAYER_ID).intValue();
                int val = succVal > predVal ? succVal : predVal;
                for (ElkNode n : chain) {
                    int oldVal = n.getProperty(LayeredOptions.LAYERING_LAYER_ID);
                    if (oldVal != val) {
                        n.setProperty(LayeredOptions.LAYERING_LAYER_ID, val);
                        this.shiftOtherNodes(n, val, layering, true);
                        this.shiftOtherNodes(n, val, layering, false);
                    }
                    layering.get(oldVal).remove(n);
                    layering.get(val).add(n);
                }
            } else {
                int succVal = -1;
                if (succNode != null) {
                    succVal = succNode.hasProperty(layProp) ? succNode.getProperty(layProp).intValue() : succNode.getProperty(LayeredOptions.LAYERING_LAYER_ID).intValue();
                }
                int predVal = -1;
                if (predNode != null) {
                    predVal = predNode.hasProperty(layProp) ? predNode.getProperty(layProp).intValue() : predNode.getProperty(LayeredOptions.LAYERING_LAYER_ID).intValue();
                }
                int val = succVal > predVal ? succVal : predVal;
                node.setProperty(LayeredOptions.LAYERING_LAYER_ID, val - diff);
                this.shiftOtherNodes(node, val - diff, layering, true);
                this.shiftOtherNodes(node, val - diff, layering, false);
                layering.get(val - diff).add(node);
            }
            ++i;
        }
    }

    private int assignLayersToNodesWithProperty(List<ElkNode> nodesWithLayerConstraint, List<List<ElkNode>> layering) {
        nodesWithLayerConstraint.sort((a, b) -> a.getProperty(LayeredOptions.LAYERING_LAYER_CHOICE_CONSTRAINT) - b.getProperty(LayeredOptions.LAYERING_LAYER_CHOICE_CONSTRAINT));
        int diff = 0;
        for (ElkNode node : nodesWithLayerConstraint) {
            int currentLayer = node.getProperty(LayeredOptions.LAYERING_LAYER_CHOICE_CONSTRAINT) - diff;
            if (currentLayer < layering.size() && currentLayer >= 0) {
                List<ElkNode> nodesOfLayer = layering.get(currentLayer);
                this.shiftOtherNodes(node, currentLayer, layering, true);
                this.shiftOtherNodes(node, currentLayer, layering, false);
                nodesOfLayer.add(node);
                continue;
            }
            if (currentLayer == -1) {
                layering.add(0, new ArrayList<ElkNode>(Arrays.asList(node)));
                continue;
            }
            diff = diff + currentLayer - layering.size();
            layering.add(new ArrayList<ElkNode>(Arrays.asList(node)));
        }
        return diff;
    }

    private void shiftOtherNodes(ElkNode movedNode, int layer, List<List<ElkNode>> layerNodes, boolean incoming) {
        List<ElkNode> nodesOfLayer = layerNodes.get(layer);
        ArrayList<ElkEdge> edges = new ArrayList<ElkEdge>();
        if (incoming) {
            root = movedNode.getParent();
            for (ElkEdge edge : root.getContainedEdges()) {
                for (ElkConnectableShape target : edge.getTargets()) {
                    if (!target.equals(movedNode) && (!(target instanceof ElkPort) || !target.eContainer().equals(movedNode))) continue;
                    edges.add(edge);
                }
            }
        } else {
            root = movedNode.getParent();
            for (ElkEdge edge : root.getContainedEdges()) {
                for (ElkConnectableShape target : edge.getSources()) {
                    if (!target.equals(movedNode) && (!(target instanceof ElkPort) || !target.eContainer().equals(movedNode))) continue;
                    edges.add(edge);
                }
            }
        }
        for (ElkEdge edge : edges) {
            ElkNode node = null;
            if (incoming) {
                if (edge.getSources().get(0) instanceof ElkPort) {
                    node = (ElkNode)((ElkConnectableShape)edge.getSources().get(0)).eContainer();
                } else if (edge.getSources().get(0) instanceof ElkNode) {
                    node = (ElkNode)edge.getSources().get(0);
                }
            } else if (edge.getTargets().get(0) instanceof ElkPort) {
                node = (ElkNode)((ElkConnectableShape)edge.getTargets().get(0)).eContainer();
            } else if (edge.getTargets().get(0) instanceof ElkNode) {
                node = (ElkNode)edge.getTargets().get(0);
            }
            if (!nodesOfLayer.contains(node)) continue;
            nodesOfLayer.remove(node);
            node.setProperty(LayeredOptions.LAYERING_LAYER_ID, layer + 1);
            if (layer + 1 < layerNodes.size()) {
                List<ElkNode> newLayer = layerNodes.get(layer + 1);
                newLayer.add(node);
                this.shiftOtherNodes(node, layer + 1, layerNodes, false);
                this.shiftOtherNodes(node, layer + 1, layerNodes, true);
                continue;
            }
            layerNodes.add(new ArrayList<ElkNode>(Arrays.asList(node)));
        }
    }

    private List<List<ElkNode>> initialLayers(ArrayList<ElkNode> nodes) {
        nodes.sort((a, b) -> a.getProperty(LayeredOptions.LAYERING_LAYER_ID) - b.getProperty(LayeredOptions.LAYERING_LAYER_ID));
        ArrayList<List<ElkNode>> layerNodes = new ArrayList<List<ElkNode>>();
        ArrayList<ElkNode> nodesOfLayer = new ArrayList<ElkNode>();
        int layerId = 0;
        int currentLayer = -1;
        for (ElkNode node : nodes) {
            int layer = node.getProperty(LayeredOptions.LAYERING_LAYER_ID);
            if (layer > currentLayer) {
                if (!nodesOfLayer.isEmpty()) {
                    layerNodes.add(nodesOfLayer);
                    ++layerId;
                }
                nodesOfLayer = new ArrayList();
                currentLayer = layer;
            }
            if (node.hasProperty(LayeredOptions.LAYERING_LAYER_CHOICE_CONSTRAINT)) continue;
            node.setProperty(LayeredOptions.LAYERING_LAYER_ID, layerId);
            nodesOfLayer.add(node);
        }
        if (!nodesOfLayer.isEmpty()) {
            layerNodes.add(nodesOfLayer);
        }
        return layerNodes;
    }

    private void setCoordinateInLayoutDirection(List<List<ElkNode>> layers, Direction direction) {
        double position = 0.0;
        double nextPosition = 0.0;
        for (List<ElkNode> nodesOfLayer : layers) {
            for (ElkNode node : nodesOfLayer) {
                switch (direction) {
                    case UNDEFINED: 
                    case RIGHT: {
                        node.setX(position);
                        if (!(position + node.getWidth() / 2.0 >= nextPosition)) break;
                        nextPosition = node.getX() + node.getWidth() + 2.147483647E9;
                        break;
                    }
                    case LEFT: {
                        node.setX(position);
                        if (!(node.getX() <= nextPosition)) break;
                        nextPosition = node.getX() - 2.147483647E9;
                        break;
                    }
                    case DOWN: {
                        node.setY(position);
                        if (!(position + node.getHeight() >= nextPosition)) break;
                        nextPosition = node.getY() + node.getHeight() + 2.147483647E9;
                        break;
                    }
                    case UP: {
                        node.setY(position);
                        if (!(node.getY() <= nextPosition)) break;
                        nextPosition = node.getY() - 2.147483647E9;
                    }
                }
            }
            position = nextPosition;
        }
    }

    private void setCoordinatesOrthogonalToLayoutDirection(List<ElkNode> nodesOfLayer, int layerId, Direction direction) {
        ArrayList<ElkNode> allNodes = new ArrayList<ElkNode>();
        ArrayList<ElkNode> nodesWithoutC = new ArrayList<ElkNode>();
        ArrayList<ElkNode> nodesWithPCAndRC = new ArrayList<ElkNode>();
        ArrayList<ElkNode> nodesWithPC = new ArrayList<ElkNode>();
        List<ElkNode> nodesWithOneRC = new ArrayList<ElkNode>();
        ArrayList<ElkNode> nodesWithBothRC = new ArrayList<ElkNode>();
        for (ElkNode node : nodesOfLayer) {
            allNodes.add(node);
            if (node.hasProperty(LayeredOptions.CROSSING_MINIMIZATION_POSITION_CHOICE_CONSTRAINT) && (node.hasProperty(LayeredOptions.CROSSING_MINIMIZATION_IN_LAYER_PRED_OF) || node.hasProperty(LayeredOptions.CROSSING_MINIMIZATION_IN_LAYER_SUCC_OF))) {
                nodesWithPCAndRC.add(node);
                continue;
            }
            if (node.hasProperty(LayeredOptions.CROSSING_MINIMIZATION_POSITION_CHOICE_CONSTRAINT)) {
                nodesWithPC.add(node);
                continue;
            }
            if (node.hasProperty(LayeredOptions.CROSSING_MINIMIZATION_IN_LAYER_PRED_OF) && node.hasProperty(LayeredOptions.CROSSING_MINIMIZATION_IN_LAYER_SUCC_OF)) {
                nodesWithBothRC.add(node);
                continue;
            }
            if (node.hasProperty(LayeredOptions.CROSSING_MINIMIZATION_IN_LAYER_PRED_OF) || node.hasProperty(LayeredOptions.CROSSING_MINIMIZATION_IN_LAYER_SUCC_OF)) {
                nodesWithOneRC.add(node);
                continue;
            }
            nodesWithoutC.add(node);
        }
        nodesWithPC.sort((a, b) -> a.getProperty(LayeredOptions.CROSSING_MINIMIZATION_POSITION_ID) - b.getProperty(LayeredOptions.CROSSING_MINIMIZATION_POSITION_ID));
        int n = 0;
        while (n < nodesWithBothRC.size()) {
            ElkNode node = (ElkNode)nodesWithBothRC.get(n);
            String t = node.getProperty(LayeredOptions.CROSSING_MINIMIZATION_IN_LAYER_PRED_OF);
            ElkNode target = this.getElkNode(allNodes, t);
            node.setProperty(LayeredOptions.CROSSING_MINIMIZATION_IN_LAYER_PRED_OF, null);
            if (target.hasProperty(LayeredOptions.CROSSING_MINIMIZATION_POSITION_CHOICE_CONSTRAINT)) {
                int posCosTarget = target.getProperty(LayeredOptions.CROSSING_MINIMIZATION_POSITION_CHOICE_CONSTRAINT);
                node.setProperty(LayeredOptions.CROSSING_MINIMIZATION_POSITION_CHOICE_CONSTRAINT, posCosTarget - 1);
                nodesWithPCAndRC.add(node);
            } else {
                target.setProperty(LayeredOptions.CROSSING_MINIMIZATION_IN_LAYER_SUCC_OF, node.getIdentifier());
                nodesWithOneRC.add(node);
                if (!target.hasProperty(LayeredOptions.CROSSING_MINIMIZATION_IN_LAYER_PRED_OF)) {
                    nodesWithoutC.remove(target);
                    nodesWithOneRC.add(target);
                } else {
                    nodesWithOneRC.remove(target);
                    nodesWithBothRC.add(n + 1, target);
                }
            }
            ++n;
        }
        this.handleNodesWithPCAndRC(allNodes, nodesWithoutC, nodesWithOneRC, nodesWithPC, nodesWithPCAndRC);
        nodesWithOneRC = this.sortRCNodes(nodesWithOneRC, allNodes, nodesWithoutC);
        this.sortNodesInLayer(nodesWithPC, nodesWithoutC, direction);
        for (ElkNode node : nodesWithOneRC) {
            ElkNode[] targets = new ElkNode[2];
            if (node.hasProperty(LayeredOptions.CROSSING_MINIMIZATION_IN_LAYER_PRED_OF)) {
                nodeProp = LayeredOptions.CROSSING_MINIMIZATION_IN_LAYER_PRED_OF;
                targets[0] = this.getElkNode(allNodes, node.getProperty(nodeProp));
            } else {
                nodeProp = LayeredOptions.CROSSING_MINIMIZATION_IN_LAYER_SUCC_OF;
                targets[1] = this.getElkNode(allNodes, node.getProperty(nodeProp));
            }
            int t = 0;
            while (t < targets.length) {
                if (targets[t] != null) {
                    if (!targets[t].hasProperty(LayeredOptions.CROSSING_MINIMIZATION_POSITION_CHOICE_CONSTRAINT)) {
                        int index = t == 0 ? nodesWithoutC.indexOf(targets[t]) : nodesWithoutC.indexOf(targets[t]) + 1;
                        nodesWithoutC.add(index, node);
                    } else {
                        int val = targets[t].getProperty(LayeredOptions.CROSSING_MINIMIZATION_POSITION_CHOICE_CONSTRAINT);
                        int value = t == 0 ? val - 1 : val + 1;
                        IProperty<String> nodeProp = t == 0 ? LayeredOptions.CROSSING_MINIMIZATION_IN_LAYER_PRED_OF : LayeredOptions.CROSSING_MINIMIZATION_IN_LAYER_SUCC_OF;
                        node.setProperty(LayeredOptions.CROSSING_MINIMIZATION_POSITION_CHOICE_CONSTRAINT, value);
                        node.setProperty(nodeProp, null);
                        nodesWithPC.add(node);
                    }
                }
                ++t;
            }
        }
        nodesWithPC.sort((a, b) -> a.getProperty(LayeredOptions.CROSSING_MINIMIZATION_POSITION_CHOICE_CONSTRAINT) - b.getProperty(LayeredOptions.CROSSING_MINIMIZATION_POSITION_CHOICE_CONSTRAINT));
        for (ElkNode node : nodesWithPC) {
            int pos = node.getProperty(LayeredOptions.CROSSING_MINIMIZATION_POSITION_CHOICE_CONSTRAINT);
            if (pos < nodesWithoutC.size()) {
                if (pos > 0) {
                    this.swapNodes(nodesWithoutC, pos);
                }
                nodesWithoutC.add(pos, node);
                continue;
            }
            nodesWithoutC.add(node);
        }
        switch (direction) {
            case UNDEFINED: 
            case RIGHT: 
            case LEFT: {
                double yPos = ((ElkNode)nodesWithoutC.get(0)).getY();
                for (ElkNode node : nodesWithoutC) {
                    node.setProperty(LayeredOptions.POSITION, new KVector(node.getX(), yPos));
                    yPos += node.getHeight() + 2.147483647E9;
                }
                break;
            }
            case DOWN: 
            case UP: {
                double xPos = ((ElkNode)nodesWithoutC.get(0)).getX() + (double)(2 * layerId * Integer.MAX_VALUE);
                for (ElkNode node : nodesWithoutC) {
                    node.setProperty(LayeredOptions.POSITION, new KVector(xPos, node.getY()));
                    xPos += node.getWidth() + 2.147483647E9;
                }
                break;
            }
        }
    }

    private void handleNodesWithPCAndRC(List<ElkNode> allNodes, List<ElkNode> nodes, List<ElkNode> nodesWithRC, List<ElkNode> nodesWithPositionConstraint, List<ElkNode> nodesWithPCAndRC) {
        int i = 0;
        while (i < nodesWithPCAndRC.size()) {
            ElkNode node = nodesWithPCAndRC.get(i);
            nodesWithPositionConstraint.add(node);
            IProperty<String> nodeProp = null;
            ArrayList<ElkNode> targets = new ArrayList<ElkNode>();
            ArrayList<Integer> vals = new ArrayList<Integer>();
            int val = node.getProperty(LayeredOptions.CROSSING_MINIMIZATION_POSITION_CHOICE_CONSTRAINT);
            if (node.hasProperty(LayeredOptions.CROSSING_MINIMIZATION_IN_LAYER_PRED_OF)) {
                nodeProp = LayeredOptions.CROSSING_MINIMIZATION_IN_LAYER_PRED_OF;
                targets.add(this.getElkNode(allNodes, node.getProperty(nodeProp)));
                vals.add(val + 1);
                node.setProperty(nodeProp, null);
            }
            if (node.hasProperty(LayeredOptions.CROSSING_MINIMIZATION_IN_LAYER_SUCC_OF)) {
                nodeProp = LayeredOptions.CROSSING_MINIMIZATION_IN_LAYER_SUCC_OF;
                targets.add(this.getElkNode(allNodes, node.getProperty(nodeProp)));
                vals.add(val - 1);
                node.setProperty(nodeProp, null);
            }
            int t = 0;
            while (t < targets.size()) {
                ElkNode target = (ElkNode)targets.get(t);
                if (!nodesWithPositionConstraint.contains(target)) {
                    target.setProperty(LayeredOptions.CROSSING_MINIMIZATION_POSITION_CHOICE_CONSTRAINT, (Integer)vals.get(t));
                    if (!nodesWithRC.contains(target)) {
                        nodesWithPositionConstraint.add(target);
                        nodes.remove(target);
                    } else {
                        nodesWithPCAndRC.add(target);
                        nodesWithRC.remove(target);
                    }
                }
                ++t;
            }
            ++i;
        }
    }

    private void swapNodes(List<ElkNode> nodes, int position) {
        ElkNode pred = nodes.get(position - 1);
        ElkNode succ = nodes.get(position);
        List<ElkNode> chain = this.getChainByLayerNodes(pred, nodes);
        if (chain.contains(succ)) {
            int count = chain.indexOf(succ);
            int end = position + (chain.size() - count);
            ArrayList<ElkNode> swapNodes = new ArrayList<ElkNode>();
            int i = 0;
            while (i < count) {
                if (end >= nodes.size()) break;
                ElkNode currentNode = nodes.get(end);
                chain = this.getChainByLayerNodes(currentNode, nodes);
                if (chain.size() + i <= count) {
                    nodes.removeAll(chain);
                    swapNodes.addAll(chain);
                    i += chain.size() - 1;
                } else {
                    end += chain.size();
                }
                ++i;
            }
            nodes.addAll(position - count, swapNodes);
        }
    }

    private List<ElkNode> sortRCNodes(List<ElkNode> nodesWithRC, List<ElkNode> allNodes, List<ElkNode> nodesWithoutC) {
        ArrayList<ElkNode> nodes = new ArrayList<ElkNode>();
        while (!nodesWithRC.isEmpty()) {
            boolean circle = true;
            int i = 0;
            while (i < nodesWithRC.size()) {
                ElkNode cur = nodesWithRC.get(i);
                if (cur.hasProperty(LayeredOptions.CROSSING_MINIMIZATION_IN_LAYER_PRED_OF)) {
                    target = this.getElkNode(allNodes, cur.getProperty(LayeredOptions.CROSSING_MINIMIZATION_IN_LAYER_PRED_OF));
                    if (!nodesWithRC.contains(target)) {
                        nodes.add(cur);
                        nodesWithRC.remove(i);
                        --i;
                        circle = false;
                    }
                } else {
                    target = this.getElkNode(allNodes, cur.getProperty(LayeredOptions.CROSSING_MINIMIZATION_IN_LAYER_SUCC_OF));
                    if (!nodesWithRC.contains(target)) {
                        nodes.add(cur);
                        nodesWithRC.remove(i);
                        --i;
                        circle = false;
                    }
                }
                ++i;
            }
            if (!circle) continue;
            ElkNode cur = nodesWithRC.get(0);
            if (cur.hasProperty(LayeredOptions.CROSSING_MINIMIZATION_IN_LAYER_PRED_OF)) {
                cur.setProperty(LayeredOptions.CROSSING_MINIMIZATION_IN_LAYER_PRED_OF, null);
            } else {
                cur.setProperty(LayeredOptions.CROSSING_MINIMIZATION_IN_LAYER_SUCC_OF, null);
            }
            nodesWithRC.remove(0);
            nodesWithoutC.add(cur);
        }
        return nodes;
    }

    private void sortNodesInLayer(List<ElkNode> nodesWithPositionConstraint, List<ElkNode> nodes, Direction direction) {
        nodesWithPositionConstraint.sort((a, b) -> a.getProperty(LayeredOptions.CROSSING_MINIMIZATION_POSITION_CHOICE_CONSTRAINT) - b.getProperty(LayeredOptions.CROSSING_MINIMIZATION_POSITION_CHOICE_CONSTRAINT));
        nodes.sort((a, b) -> {
            switch (direction) {
                case UNDEFINED: 
                case RIGHT: 
                case LEFT: {
                    return (int)(a.getY() - b.getY());
                }
                case DOWN: 
                case UP: {
                    return (int)(a.getX() - b.getX());
                }
            }
            return 0;
        });
    }

    private void setInteractiveStrategies(ElkNode parent) {
        parent.setProperty(LayeredOptions.CROSSING_MINIMIZATION_SEMI_INTERACTIVE, true);
        parent.setProperty(LayeredOptions.LAYERING_STRATEGY, LayeringStrategy.INTERACTIVE);
        parent.setProperty(LayeredOptions.CYCLE_BREAKING_STRATEGY, CycleBreakingStrategy.INTERACTIVE);
        parent.setProperty(LayeredOptions.CONSIDER_MODEL_ORDER_STRATEGY, OrderingStrategy.NONE);
        parent.setProperty(LayeredOptions.CROSSING_MINIMIZATION_FORCE_NODE_MODEL_ORDER, false);
        parent.setProperty(LayeredOptions.CROSSING_MINIMIZATION_STRATEGY, CrossingMinimizationStrategy.LAYER_SWEEP);
    }

    private ElkNode getElkNode(List<ElkNode> nodes, String id) {
        for (ElkNode eN : nodes) {
            if (!id.equals(eN.getIdentifier())) continue;
            return eN;
        }
        return null;
    }

    private List<ElkNode> getChainByLayerNodes(ElkNode node, List<ElkNode> layerNodes) {
        int pos = layerNodes.indexOf(node);
        ArrayList<ElkNode> chainNodes = new ArrayList<ElkNode>();
        chainNodes.add(node);
        int i = pos - 1;
        while (i >= 0) {
            if (!layerNodes.get(i).hasProperty(LayeredOptions.CROSSING_MINIMIZATION_IN_LAYER_PRED_OF) && !layerNodes.get(i + 1).hasProperty(LayeredOptions.CROSSING_MINIMIZATION_IN_LAYER_SUCC_OF)) break;
            chainNodes.add(0, layerNodes.get(i));
            --i;
        }
        i = pos + 1;
        while (i < layerNodes.size()) {
            if (!layerNodes.get(i).hasProperty(LayeredOptions.CROSSING_MINIMIZATION_IN_LAYER_SUCC_OF) && !layerNodes.get(i - 1).hasProperty(LayeredOptions.CROSSING_MINIMIZATION_IN_LAYER_PRED_OF)) break;
            chainNodes.add(layerNodes.get(i));
            ++i;
        }
        return chainNodes;
    }

    private List<ElkNode> getChainByAllNodes(ElkNode node, List<ElkNode> allNodes) {
        ArrayList<ElkNode> chain = new ArrayList<ElkNode>();
        chain.add(node);
        ElkNode succNode = null;
        ElkNode predNode = null;
        String succName = node.getProperty(LayeredOptions.CROSSING_MINIMIZATION_IN_LAYER_PRED_OF);
        String predName = node.getProperty(LayeredOptions.CROSSING_MINIMIZATION_IN_LAYER_SUCC_OF);
        while (succName != null) {
            succNode = this.getElkNode(allNodes, succName);
            chain.add(succNode);
            succName = succNode.getProperty(LayeredOptions.CROSSING_MINIMIZATION_IN_LAYER_PRED_OF);
        }
        while (predName != null) {
            predNode = this.getElkNode(allNodes, predName);
            chain.add(predNode);
            predName = predNode.getProperty(LayeredOptions.CROSSING_MINIMIZATION_IN_LAYER_PRED_OF);
        }
        return chain;
    }
}

