/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.extremity;

import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.geom.XPoint2D;
import net.sourceforge.plantuml.klimt.shape.UEllipse;
import net.sourceforge.plantuml.klimt.shape.ULine;
import net.sourceforge.plantuml.svek.extremity.Extremity;

class MiddleSubset
extends Extremity {
    private final double radius = 6.0;
    private final double length = 10.0;
    private final double angle;
    private final boolean reverse;

    public MiddleSubset(double angle, boolean reverse) {
        this.angle = angle;
        this.reverse = reverse;
    }

    @Override
    public XPoint2D somePoint() {
        return null;
    }

    @Override
    public void drawU(UGraphic ug) {
        ug = ug.apply(UStroke.withThickness(1.5));
        double rotate = this.reverse ? -45.0 : 135.0;
        ug.apply(new UTranslate(-6.0, -6.0)).draw(new UEllipse(12.0, 12.0, this.angle + rotate, 180.0));
        double sin = Math.sin(Math.toRadians(this.angle + rotate));
        double cos = Math.cos(Math.toRadians(this.angle + rotate));
        ug.apply(new UTranslate(6.0 * cos, 6.0 * -sin)).draw(new ULine(10.0 * sin, 10.0 * cos));
        ug.apply(new UTranslate(6.0 * -cos, 6.0 * sin)).draw(new ULine(10.0 * sin, 10.0 * cos));
    }

    @Override
    public double getDecorationLength() {
        return 6.0;
    }
}

