/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect;

import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.JdbcMappingContainer;
import org.hibernate.query.common.FetchClauseType;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.spi.AbstractSqlAstTranslator;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.cte.CteMaterialization;
import org.hibernate.sql.ast.tree.cte.CteStatement;
import org.hibernate.sql.ast.tree.expression.BinaryArithmeticExpression;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.sql.ast.tree.expression.Summarization;
import org.hibernate.sql.ast.tree.from.FromClause;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.insert.ConflictClause;
import org.hibernate.sql.ast.tree.insert.InsertSelectStatement;
import org.hibernate.sql.ast.tree.predicate.BooleanExpressionPredicate;
import org.hibernate.sql.ast.tree.predicate.InArrayPredicate;
import org.hibernate.sql.ast.tree.predicate.LikePredicate;
import org.hibernate.sql.ast.tree.predicate.NullnessPredicate;
import org.hibernate.sql.ast.tree.select.QueryGroup;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.update.UpdateStatement;
import org.hibernate.sql.exec.internal.JdbcOperationQueryInsertImpl;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.sql.exec.spi.JdbcOperationQueryInsert;
import org.hibernate.sql.model.internal.TableInsertStandard;

public class PostgreSQLLegacySqlAstTranslator<T extends JdbcOperation>
extends AbstractSqlAstTranslator<T> {
    public PostgreSQLLegacySqlAstTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
        super(sessionFactory, statement);
    }

    public void visitInArrayPredicate(InArrayPredicate inArrayPredicate) {
        inArrayPredicate.getTestExpression().accept((SqlAstWalker)this);
        this.appendSql(" = any (");
        inArrayPredicate.getArrayParameter().accept((SqlAstWalker)this);
        this.appendSql(")");
    }

    protected void renderInsertIntoNoColumns(TableInsertStandard tableInsert) {
        this.renderIntoIntoAndTable(tableInsert);
        this.appendSql("default values");
    }

    protected JdbcOperationQueryInsert translateInsert(InsertSelectStatement sqlAst) {
        this.visitInsertStatement(sqlAst);
        return new JdbcOperationQueryInsertImpl(this.getSql(), this.getParameterBinders(), this.getAffectedTableNames(), null);
    }

    protected void renderTableReferenceIdentificationVariable(TableReference tableReference) {
        String identificationVariable = tableReference.getIdentificationVariable();
        if (identificationVariable != null) {
            Clause currentClause = (Clause)this.getClauseStack().getCurrent();
            if (currentClause == Clause.INSERT) {
                this.appendSql(" as ");
            } else {
                this.append(' ');
            }
            this.append(tableReference.getIdentificationVariable());
        }
    }

    protected void renderDmlTargetTableExpression(NamedTableReference tableReference) {
        super.renderDmlTargetTableExpression(tableReference);
        Statement currentStatement = (Statement)this.getStatementStack().getCurrent();
        if (!(currentStatement instanceof UpdateStatement) || !PostgreSQLLegacySqlAstTranslator.hasNonTrivialFromClause((FromClause)((UpdateStatement)currentStatement).getFromClause())) {
            this.renderTableReferenceIdentificationVariable((TableReference)tableReference);
        }
    }

    protected void renderFromClauseAfterUpdateSet(UpdateStatement statement) {
        this.renderFromClauseJoiningDmlTargetReference(statement);
    }

    protected void visitConflictClause(ConflictClause conflictClause) {
        this.visitStandardConflictClause(conflictClause);
    }

    protected void renderExpressionAsClauseItem(Expression expression) {
        expression.accept((SqlAstWalker)this);
    }

    protected void renderComparison(Expression lhs, ComparisonOperator operator, Expression rhs) {
        JdbcMappingContainer lhsExpressionType = lhs.getExpressionType();
        if (lhsExpressionType != null && lhsExpressionType.getJdbcTypeCount() == 1 && lhsExpressionType.getSingleJdbcMapping().getJdbcType().getDdlTypeCode() == 2009) {
            switch (operator) {
                case EQUAL: 
                case NOT_DISTINCT_FROM: 
                case NOT_EQUAL: 
                case DISTINCT_FROM: {
                    this.appendSql("cast(");
                    lhs.accept((SqlAstWalker)this);
                    this.appendSql(" as text)");
                    this.appendSql(operator.sqlText());
                    this.appendSql("cast(");
                    rhs.accept((SqlAstWalker)this);
                    this.appendSql(" as text)");
                    return;
                }
            }
        }
        this.renderComparisonStandard(lhs, operator, rhs);
    }

    public void visitBooleanExpressionPredicate(BooleanExpressionPredicate booleanExpressionPredicate) {
        boolean isNegated = booleanExpressionPredicate.isNegated();
        if (isNegated) {
            this.appendSql("not(");
        }
        booleanExpressionPredicate.getExpression().accept((SqlAstWalker)this);
        if (isNegated) {
            this.appendSql(')');
        }
    }

    public void visitNullnessPredicate(NullnessPredicate nullnessPredicate) {
        Expression expression = nullnessPredicate.getExpression();
        JdbcMappingContainer expressionType = expression.getExpressionType();
        if (this.isStruct(expressionType)) {
            expression.accept((SqlAstWalker)this);
            if (nullnessPredicate.isNegated()) {
                this.appendSql(" is distinct from null");
            } else {
                this.appendSql(" is not distinct from null");
            }
        } else {
            super.visitNullnessPredicate(nullnessPredicate);
        }
    }

    protected void renderMaterializationHint(CteMaterialization materialization) {
        if (this.getDialect().getVersion().isSameOrAfter(12)) {
            if (materialization == CteMaterialization.NOT_MATERIALIZED) {
                this.appendSql("not ");
            }
            this.appendSql("materialized ");
        }
    }

    protected boolean shouldEmulateFetchClause(QueryPart queryPart) {
        if (this.getQueryPartForRowNumbering() == queryPart || this.isRowsOnlyFetchClauseType(queryPart)) {
            return false;
        }
        return !this.getDialect().supportsFetchClause(queryPart.getFetchClauseType());
    }

    public void visitQueryGroup(QueryGroup queryGroup) {
        if (this.shouldEmulateFetchClause((QueryPart)queryGroup)) {
            this.emulateFetchOffsetWithWindowFunctions((QueryPart)queryGroup, true);
        } else {
            super.visitQueryGroup(queryGroup);
        }
    }

    public void visitQuerySpec(QuerySpec querySpec) {
        if (this.shouldEmulateFetchClause((QueryPart)querySpec)) {
            this.emulateFetchOffsetWithWindowFunctions((QueryPart)querySpec, true);
        } else {
            super.visitQuerySpec(querySpec);
        }
    }

    public void visitOffsetFetchClause(QueryPart queryPart) {
        if (!this.isRowNumberingCurrentQueryPart()) {
            if (this.getDialect().supportsFetchClause(FetchClauseType.ROWS_ONLY)) {
                this.renderOffsetFetchClause(queryPart, true);
            } else {
                this.renderLimitOffsetClause(queryPart);
            }
        }
    }

    protected void renderStandardCycleClause(CteStatement cte) {
        super.renderStandardCycleClause(cte);
        if (cte.getCycleMarkColumn() != null && cte.getCyclePathColumn() == null && this.getDialect().supportsRecursiveCycleUsingClause()) {
            this.appendSql(" using ");
            this.appendSql(this.determineCyclePathColumnName(cte));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void renderPartitionItem(Expression expression) {
        if (expression instanceof Literal) {
            if (this.getDialect().getVersion().isSameOrAfter(9, 5)) {
                this.appendSql("()");
                return;
            } else {
                this.appendSql("(select 1)");
            }
            return;
        } else if (expression instanceof Summarization) {
            Summarization summarization = (Summarization)expression;
            if (!this.getDialect().getVersion().isSameOrAfter(9, 5)) throw new UnsupportedOperationException("Summarization is not supported by DBMS");
            this.appendSql(summarization.getKind().sqlText());
            this.appendSql('(');
            this.renderCommaSeparated(summarization.getGroupings());
            this.appendSql(')');
            return;
        } else {
            expression.accept((SqlAstWalker)this);
        }
    }

    public void visitLikePredicate(LikePredicate likePredicate) {
        likePredicate.getMatchExpression().accept((SqlAstWalker)this);
        if (likePredicate.isNegated()) {
            this.appendSql(" not");
        }
        if (likePredicate.isCaseSensitive()) {
            this.appendSql(" like ");
        } else {
            this.appendSql(' ');
            this.appendSql(this.getDialect().getCaseInsensitiveLike());
            this.appendSql(' ');
        }
        likePredicate.getPattern().accept((SqlAstWalker)this);
        if (likePredicate.getEscapeCharacter() != null) {
            this.appendSql(" escape ");
            likePredicate.getEscapeCharacter().accept((SqlAstWalker)this);
        } else {
            this.appendSql(" escape ''");
        }
    }

    public void visitBinaryArithmeticExpression(BinaryArithmeticExpression arithmeticExpression) {
        this.appendSql('(');
        this.visitArithmeticOperand(arithmeticExpression.getLeftHandOperand());
        this.appendSql(arithmeticExpression.getOperator().getOperatorSqlTextString());
        this.visitArithmeticOperand(arithmeticExpression.getRightHandOperand());
        this.appendSql(')');
    }
}

