/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.timeline;

import java.awt.Component;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import org.gephi.desktop.timeline.TimelineTopComponent;
import org.gephi.timeline.api.TimelineController;
import org.gephi.timeline.api.TimelineModel;
import org.jdesktop.swingx.JXHeader;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class PlaySettingsDialog
extends JPanel {
    private TimelineModel model;
    private TimelineController controller;
    private JCheckBox backwardCheckbox;
    private JSpinner delaySpinner;
    private JXHeader headerTitle;
    private JLabel labelDelay;
    private JLabel labelMode;
    private JLabel labelMs;
    private JLabel labelPerc;
    private JLabel labelSpeed;
    private JLabel labelStepSize;
    private ButtonGroup modeButtonGroup;
    private JRadioButton oneBoundRadio;
    private JSpinner stepSizeSpinner;
    private JRadioButton twoBoundsRadio;

    public PlaySettingsDialog() {
        this.initComponents();
    }

    public void setup(TimelineModel model) {
        this.model = model;
        this.controller = (TimelineController)Lookup.getDefault().lookup(TimelineController.class);
        int delay = model.getPlayDelay();
        SpinnerNumberModel delayModel = new SpinnerNumberModel(delay, 10, Integer.MAX_VALUE, 50);
        this.delaySpinner.setModel(delayModel);
        double step = model.getPlayStep() * 100.0;
        SpinnerNumberModel stepModel = new SpinnerNumberModel(Math.abs(step), 1.0E-5, 100.0, 1.0);
        this.stepSizeSpinner.setModel(stepModel);
        if (model.getPlayMode().equals((Object)TimelineModel.PlayMode.ONE_BOUND)) {
            this.oneBoundRadio.setSelected(true);
        } else {
            this.twoBoundsRadio.setSelected(true);
        }
        if (step < 0.0) {
            this.backwardCheckbox.setSelected(true);
        }
    }

    public void unsetup() {
        double step = (Double)this.stepSizeSpinner.getValue() / 100.0;
        step = this.backwardCheckbox.isSelected() ? -step : step;
        this.controller.setPlayStep(step);
        int delay = (Integer)this.delaySpinner.getValue();
        this.controller.setPlaySpeed(delay);
        if (this.oneBoundRadio.isSelected()) {
            this.controller.setPlayMode(TimelineModel.PlayMode.ONE_BOUND);
        } else {
            this.controller.setPlayMode(TimelineModel.PlayMode.TWO_BOUNDS);
        }
    }

    private void initComponents() {
        this.modeButtonGroup = new ButtonGroup();
        this.headerTitle = new JXHeader();
        this.labelSpeed = new JLabel();
        this.delaySpinner = new JSpinner();
        this.labelDelay = new JLabel();
        this.labelMs = new JLabel();
        this.labelStepSize = new JLabel();
        this.stepSizeSpinner = new JSpinner();
        this.labelPerc = new JLabel();
        this.labelMode = new JLabel();
        this.oneBoundRadio = new JRadioButton();
        this.twoBoundsRadio = new JRadioButton();
        this.backwardCheckbox = new JCheckBox();
        this.headerTitle.setDescription(NbBundle.getMessage(TimelineTopComponent.class, (String)"PlaySettingsDialog.headerTitle.description"));
        this.headerTitle.setIcon((Icon)ImageUtilities.loadImageIcon((String)"DesktopTimeline/enabled.png", (boolean)false));
        this.headerTitle.setTitle(NbBundle.getMessage(TimelineTopComponent.class, (String)"PlaySettingsDialog.headerTitle.title"));
        this.labelSpeed.setFont(this.labelSpeed.getFont().deriveFont(this.labelSpeed.getFont().getStyle() | 1));
        this.labelSpeed.setText(NbBundle.getMessage(TimelineTopComponent.class, (String)"PlaySettingsDialog.labelSpeed.text"));
        this.labelDelay.setText(NbBundle.getMessage(TimelineTopComponent.class, (String)"PlaySettingsDialog.labelDelay.text"));
        this.labelMs.setText(NbBundle.getMessage(TimelineTopComponent.class, (String)"PlaySettingsDialog.labelMs.text"));
        this.labelStepSize.setText(NbBundle.getMessage(TimelineTopComponent.class, (String)"PlaySettingsDialog.labelStepSize.text"));
        this.labelPerc.setText(NbBundle.getMessage(TimelineTopComponent.class, (String)"PlaySettingsDialog.labelPerc.text"));
        this.labelMode.setFont(this.labelMode.getFont().deriveFont(this.labelMode.getFont().getStyle() | 1));
        this.labelMode.setText(NbBundle.getMessage(TimelineTopComponent.class, (String)"PlaySettingsDialog.labelMode.text"));
        this.modeButtonGroup.add(this.oneBoundRadio);
        this.oneBoundRadio.setText(NbBundle.getMessage(TimelineTopComponent.class, (String)"PlaySettingsDialog.oneBoundRadio.text"));
        this.modeButtonGroup.add(this.twoBoundsRadio);
        this.twoBoundsRadio.setText(NbBundle.getMessage(TimelineTopComponent.class, (String)"PlaySettingsDialog.twoBoundsRadio.text"));
        this.backwardCheckbox.setText(NbBundle.getMessage(TimelineTopComponent.class, (String)"PlaySettingsDialog.backwardCheckbox.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.headerTitle, -1, 436, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGap(35, 35, 35).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelMode).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backwardCheckbox).addGroup(layout.createSequentialGroup().addComponent(this.oneBoundRadio).addGap(18, 18, 18).addComponent(this.twoBoundsRadio)))).addComponent(this.labelSpeed).addGroup(layout.createSequentialGroup().addGap(39, 39, 39).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.labelDelay).addComponent(this.labelStepSize)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.stepSizeSpinner, -2, 81, -2).addComponent(this.delaySpinner, -2, 81, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelMs).addComponent(this.labelPerc)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent((Component)this.headerTitle, -2, 69, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.labelSpeed).addGap(14, 14, 14).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelDelay, -2, 31, -2).addComponent(this.labelMs, GroupLayout.Alignment.TRAILING, -2, 31, -2).addComponent(this.delaySpinner, -2, 31, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.labelPerc, -2, 31, -2).addComponent(this.labelStepSize, -2, 31, -2).addComponent(this.stepSizeSpinner, -2, 31, -2)).addGap(18, 18, 18).addComponent(this.labelMode).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.oneBoundRadio).addComponent(this.twoBoundsRadio)).addGap(18, 18, 18).addComponent(this.backwardCheckbox).addContainerGap(39, Short.MAX_VALUE)));
    }
}

