/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.netbeans.api.autoupdate.UpdateManager;
import org.netbeans.modules.autoupdate.ui.Unit;
import org.netbeans.modules.autoupdate.ui.UnitCategoryTableModel;
import org.netbeans.modules.autoupdate.ui.UnitTab;
import org.openide.util.NbBundle;

public final class UnitTable
extends JTable {
    private UnitCategoryTableModel model = null;
    private static final int DARKER_COLOR_COMPONENT = 10;
    private TableCellRenderer enableRenderer = null;

    public UnitTable(TableModel model) {
        super(model);
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(UnitTable.class, (String)"ACN_UnitTable"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(UnitTab.class, (String)"ACD_UnitTable"));
        this.model = (UnitCategoryTableModel)model;
        this.setShowGrid(false);
        this.setColumnsSize();
        if (UIManager.getLookAndFeel().getID().equals("Nimbus")) {
            this.setBackground(new Color(this.getBackground().getRGB(), false));
        }
        this.setIntercellSpacing(new Dimension(0, 0));
        this.setAutoCreateRowSorter(true);
        this.revalidate();
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        return this.model.isExpansionControlAtRow(row) ? new MoreRenderer() : super.getCellRenderer(row, column);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.getParent().setBackground(this.getBackground());
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.enableRenderer = null;
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        int realColumnIndex;
        Point p = e.getPoint();
        int rowIndex = this.rowAtPoint(p);
        int colIndex = this.columnAtPoint(p);
        int realRowIndex = this.convertRowIndexToModel(rowIndex);
        String tip = this.model.getToolTipText(realRowIndex, realColumnIndex = this.convertColumnIndexToModel(colIndex));
        return tip != null ? tip : super.getToolTipText(e);
    }

    void resetEnableRenderer() {
        if (this.enableRenderer != null) {
            this.setEnableRenderer(this.enableRenderer);
        }
    }

    void setEnableRenderer(TableCellRenderer renderer) {
        this.enableRenderer = renderer;
        this.columnModel.getColumn(this.columnModel.getColumnCount() - 1).setCellRenderer(renderer);
    }

    void resortByDefault() {
        RowSorter<? extends TableModel> sorter = this.getRowSorter();
        sorter.setSortKeys(Arrays.asList(new RowSorter.SortKey(2, SortOrder.ASCENDING)));
    }

    void setColumnsSize() {
        int columnCount = this.model.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            TableColumn activeColumn = this.getColumnModel().getColumn(i);
            activeColumn.setPreferredWidth(this.model.getPreferredWidth(this.getTableHeader(), i));
        }
    }

    @Override
    public Component prepareRenderer(TableCellRenderer renderer, int rowIndex, int vColIndex) {
        if (rowIndex < 0 || vColIndex < 0) {
            return null;
        }
        Component c = super.prepareRenderer(renderer, rowIndex, vColIndex);
        Color bgColor = this.getBackground();
        Color bgColorDarker = UnitTable.getDarkerColor(bgColor);
        Unit u = this.model.getUnitAtRow(this.convertRowIndexToModel(rowIndex));
        if (u != null && !u.canBeMarked()) {
            c.setForeground(Color.gray);
        } else {
            if (vColIndex == 1 && u != null && UpdateManager.TYPE.FEATURE.equals((Object)u.updateUnit.getType())) {
                c.setFont(this.getFont().deriveFont(1));
            } else {
                c.setFont(this.getFont());
            }
            if (this.isRowSelected(rowIndex)) {
                c.setForeground(this.getSelectionForeground());
            } else {
                c.setForeground(this.getForeground());
            }
        }
        if (!this.isCellSelected(rowIndex, vColIndex)) {
            if (rowIndex % 2 == 0 && !this.model.isExpansionControlAtRow(rowIndex)) {
                c.setBackground(bgColorDarker);
            } else {
                c.setBackground(bgColor);
            }
        } else if (this.model.isExpansionControlAtRow(rowIndex)) {
            c.setBackground(this.getBackground());
            c.setForeground(this.getForeground());
            JComponent jc = (JComponent)c;
            jc.setBorder(BorderFactory.createEmptyBorder());
        }
        int fontHeight = c.getFontMetrics(c.getFont()).getHeight();
        if (this.rowHeight < 0 || this.rowHeight < fontHeight) {
            int def = new JTable().getRowHeight();
            this.rowHeight = Math.max(def, fontHeight);
            this.setRowHeight(this.rowHeight);
        }
        return c;
    }

    static Color getDarkerColor(Color color) {
        return new Color(Math.abs(color.getRed() - 10), Math.abs(color.getGreen() - 10), Math.abs(color.getBlue() - 10));
    }

    @Override
    protected JTableHeader createDefaultTableHeader() {
        return new MyTableHeader(this.columnModel);
    }

    private class MoreRenderer
    extends DefaultTableCellRenderer {
        private MoreRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component res = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (res == null || value == null) {
                return res;
            }
            if (column == 1 && res instanceof JLabel) {
                JLabel original = (JLabel)res;
                StringBuilder text = new StringBuilder();
                if (isSelected || hasFocus) {
                    text.append("<b>").append(UnitTable.this.model.getExpansionControlText()).append("</b>");
                } else {
                    text.append(UnitTable.this.model.getExpansionControlText());
                }
                this.setEnabled(isSelected);
                original.setText("<html><a href=\"\">" + text.toString() + "</a></html>");
            } else if (column != 1) {
                res = new JLabel();
            }
            return res;
        }
    }

    private class MyTableHeader
    extends JTableHeader {
        public MyTableHeader(TableColumnModel model) {
            super(model);
            this.setReorderingAllowed(false);
        }

        @Override
        public void setDraggedColumn(TableColumn aColumn) {
            if (null != aColumn && aColumn.getModelIndex() == 0) {
                return;
            }
            super.setDraggedColumn(aColumn);
        }

        @Override
        public void setResizingColumn(TableColumn col) {
            if (null == this.getResizingColumn() || null == col) {
                // empty if block
            }
            super.setResizingColumn(col);
        }
    }
}

