/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.netbeans.ProxyClassLoader;

final class ProxyClassPackages {
    private static final Map<String, Set<ProxyClassLoader>> packageCoverage = new HashMap<String, Set<ProxyClassLoader>>();

    private ProxyClassPackages() {
    }

    static synchronized void addCoveredPackages(ProxyClassLoader loader, Iterable<String> coveredPackages) {
        for (String pkg : coveredPackages) {
            Set<ProxyClassLoader> delegates = packageCoverage.get(pkg);
            if (delegates == null) {
                delegates = Collections.singleton(loader);
                packageCoverage.put(pkg, delegates);
                continue;
            }
            if (delegates.size() == 1) {
                delegates = new HashSet<ProxyClassLoader>(delegates);
                packageCoverage.put(pkg, delegates);
                delegates.add(loader);
                continue;
            }
            delegates.add(loader);
        }
    }

    static synchronized void removeCoveredPakcages(ProxyClassLoader loader) {
        Iterator<String> it = packageCoverage.keySet().iterator();
        while (it.hasNext()) {
            String pkg = it.next();
            Set<ProxyClassLoader> set = packageCoverage.get(pkg);
            if (set.contains(loader) && set.size() == 1) {
                it.remove();
                continue;
            }
            set.remove(loader);
        }
    }

    static synchronized Set<ProxyClassLoader> findCoveredPkg(String pkg) {
        return packageCoverage.get(pkg);
    }
}

