gap> START_TEST("GBNP test11");
gap> ######################### BEGIN COPYRIGHT MESSAGE #########################
gap> # GBNP - computing Gröbner bases of noncommutative polynomials
gap> # Copyright 2001-2010 by Arjeh M. Cohen, Dié A.H. Gijsbers, Jan Willem
gap> # Knopper, Chris Krook. Address: Discrete Algebra and Geometry (DAM) group
gap> # at the Department of Mathematics and Computer Science of Eindhoven
gap> # University of Technology.
gap> #
gap> # For acknowledgements see the manual. The manual can be found in several
gap> # formats in the doc subdirectory of the GBNP distribution. The
gap> # acknowledgements formatted as text can be found in the file chap0.txt.
gap> #
gap> # GBNP is free software; you can redistribute it and/or modify it under
gap> # the terms of the Lesser GNU General Public License as published by the
gap> # Free Software Foundation (FSF); either version 2.1 of the License, or
gap> # (at your option) any later version. For details, see the file 'LGPL' in
gap> # the doc subdirectory of the GBNP distribution or see the FSF's own site:
gap> # https://www.gnu.org/licenses/lgpl.html
gap> ########################## END COPYRIGHT MESSAGE ##########################
gap> 
gap> ### filename = "example11.g"
gap> ### authors Cohen & Gijsbers
gap> 
gap> ### THIS IS A GAP PACKAGE FOR COMPUTING NON-COMMUTATIVE GROBNER BASES
gap> 
gap> # <#GAPDoc Label="Example11">
gap> # <Section Label="Example11"><Heading>The truncated variant on two weighted homogeneous polynomials</Heading>
gap> # Here we exhibit a truncated non-commutative homogeneous weighted Gröbner
gap> # basis computation. This example uses the functions from Section <Ref
gap> # Sect="truncfun"/>, the truncation variants (see also Section <Ref
gap> # Sect="trunc"/>).
gap> # <P/>
gap> # The input is a set of polynomials in <M>x</M> and <M>y</M>, which
gap> # are homogeneous when the weight of <M>x</M> is 2 and of <M>y</M> is 3.
gap> # The input is <M>\{x^3y^2-x^6+y^4,y^2x^3+xyxyx+x^2yxy\}</M>.
gap> # We truncate the computation at degree 16.
gap> # The truncated Gröbner basis is
gap> # <M>\{y^2x^3+xyxyx+x^2yxy,x^6-x^3y^2-y^4,x^3y^2x-x^4y^2-xy^4\}</M>
gap> # and the dimension of the quotient algebra is 134.
gap> # <P/>
gap> # First load the package and set the standard infolevel <Ref
gap> # InfoClass="InfoGBNP" Style="Text"/> to 1 and the time infolevel <Ref
gap> # Func="InfoGBNPTime" Style="Text"/> to 1 (for more information about the info
gap> # level, see Chapter <Ref Chap="Info"/>).
gap> 
gap> 
gap> # <L>
gap> LoadPackage("gbnp", false);
true
gap> SetInfoLevel(InfoGBNP,1);
gap> SetInfoLevel(InfoGBNPTime,0);
gap> # </L>
gap> 
gap> # The variables will be printed as <M>x</M> and <M>y</M>.
gap> # <L>
gap> GBNP.ConfigPrint("x","y");
gap> # </L>
gap> 
gap> # The level to truncate at is assigned to <M>n</M>.
gap> 
gap> # <L>
gap> n := 16;;
gap> # </L>
gap> 
gap> # Now enter the relations in NP form (see Section <Ref Sect="NP"/>) and the
gap> # weights.
gap> 
gap> # <L>
gap> s1 :=[[[1,1,1,2,2],[1,1,1,1,1,1],[2,2,2,2]],[1,-1,1]];;
gap> s2 :=[[[2,2,1,1,1],[1,2,1,2,1],[1,1,2,1,2]],[1,1,1]];;
gap> K := [s1,s2];;
gap> weights:=[2,3];;
gap> # </L>
gap> 
gap> # The input can be printed with <Ref Func="PrintNPList" Style="Text"/>
gap> 
gap> # <L>
gap> PrintNPList(K);
 x^3y^2 - x^6 + y^4
 y^2x^3 + xyxyx + x^2yxy
gap> # </L>
gap> 
gap> # Verify whether the list <C>K</C> consists only of polynomials that are
gap> # homogeneous with respect to <C>weights</C>
gap> # by means of  <Ref Func="CheckHomogeneousNPs" Style="Text"/>.
gap> 
gap> # <L>
gap> CheckHomogeneousNPs(K,weights);
#I  Input is homogeneous
[ 12, 12 ]
gap> # </L>
gap> 
gap> 
gap> # Now calculate the truncated Gröbner basis with <Ref Func="SGrobnerTrunc"
gap> # Style="Text"/>. The output will only contain homogeneous polynomials
gap> # of degree at most <C>n</C>.
gap> 
gap> # <L>
gap> G := SGrobnerTrunc(K,n,weights);;
#I  number of entered polynomials is 2
#I  number of polynomials after reduction is 2
#I  End of phase I
#I  Input is homogeneous
#I  Reached level 16
#I  end of the algorithm
gap> # </L>
gap> 
gap> # The Gröbner basis of the truncated quotient algebra can be printed with <Ref
gap> # Func="PrintNPList" Style="Text"/>:
gap> 
gap> # <L>
gap> PrintNPList(G);
 y^2x^3 + xyxyx + x^2yxy
 x^6 - x^3y^2 - y^4
 x^3y^2x - x^4y^2 + y^4x - xy^4
gap> # </L>
gap> 
gap> # The standard basis of the quotient of the free noncommutative algebra
gap> # on <M>n</M> variables, where
gap> # <M>n</M> is the length of the vector <C>weights</C>,
gap> # by the homogeneous ideal generated by <C>K</C>
gap> # up to degree <M>n</M>
gap> # is obtained by means of the function
gap> # <Ref Func="BaseQATrunc" Style="Text"/>
gap> # applied to <C>K</C>, <C>n</C>, and <C>weights</C>.
gap> 
gap> # <L>
gap> B := BaseQATrunc(K,n,weights);;
#I  number of entered polynomials is 2
#I  number of polynomials after reduction is 2
#I  End of phase I
#I  Input is homogeneous
#I  Reached level 16
#I  end of the algorithm
gap> i := Length(B);
17
gap> Print("at level ",i-1," the standard monomials are:\n");
at level 16 the standard monomials are:
gap> PrintNPList(List(B[i], qq -> [[qq],[1]]));
 yxyx^4
 yx^2yx^3
 xyxyx^3
 yx^3yx^2
 xyx^2yx^2
 x^2yxyx^2
 y^4x^2
 yx^4yx
 xyx^3yx
 x^2yx^2yx
 x^3yxyx
 y^3xyx
 y^2xy^2x
 yxy^3x
 xy^4x
 yx^5y
 xyx^4y
 x^2yx^3y
 x^3yx^2y
 y^3x^2y
 x^4yxy
 y^2xyxy
 yxy^2xy
 xy^3xy
 x^5y^2
 y^2x^2y^2
 yxyxy^2
 xy^2xy^2
 yx^2y^3
 xyxy^3
 x^2y^4
gap> # </L>
gap> 
gap> 
gap> # The same result can be obtained by using the truncated Gröbner basis
gap> # found for <C>G</C> instead of <C>K</C>.
gap> 
gap> # <L>
gap> B2 := BaseQATrunc(G,n,weights);;
#I  number of entered polynomials is 3
#I  number of polynomials after reduction is 3
#I  End of phase I
#I  Input is homogeneous
#I  Reached level 16
#I  end of the algorithm
gap> B = B2;
true
gap> # </L>
gap> 
gap> # Also, the same result can be obtained by using the
gap> # leading terms of the truncated Gröbner basis
gap> # found for <C>G</C> instead of <C>K</C>.
gap> 
gap> # <L>
gap> B3 := BaseQATrunc(List( LMonsNP(G), qq -> [[qq],[1]]),n,weights);;
#I  number of entered polynomials is 3
#I  number of polynomials after reduction is 3
#I  End of phase I
#I  Input is homogeneous
#I  Reached level 16
#I  end of the algorithm
gap> B = B3;
true
gap> # </L>
gap> 
gap> 
gap> 
gap> # A list of dimensions of the homogeneous parts of the quotient algebra
gap> # up to degree <M>n</M> is obtained by means of
gap> # <Ref Func="DimsQATrunc" Style="Text"/>
gap> # with arguments <C>G</C>, <C>n</C>, and <C>weights</C>.
gap> 
gap> # <L>
gap> DimsQATrunc(G,n,weights);
#I  number of entered polynomials is 3
#I  number of polynomials after reduction is 3
#I  End of phase I
#I  Input is homogeneous
#I  Reached level 16
#I  end of the algorithm
[ 1, 0, 1, 1, 1, 2, 2, 3, 4, 5, 7, 9, 10, 16, 17, 24, 31 ]
gap> # </L>
gap> 
gap> 
gap> 
gap> # Even more detailed information is given by the list of
gap> # frequencies up to degree <C>n</C>.
gap> # This is obtained by means of
gap> # <Ref Func="FreqsQATrunc" Style="Text"/>
gap> # with arguments <C>G</C>, <C>n</C>, and <C>weights</C>.
gap> 
gap> # <L>
gap> FreqsQATrunc(G,n,weights);
#I  number of entered polynomials is 3
#I  number of polynomials after reduction is 3
#I  End of phase I
#I  Input is homogeneous
#I  Reached level 16
#I  end of the algorithm
[ [ [ [  ], 1 ] ], [ [ [ 1, 0 ], 1 ] ], [ [ [ 0, 1 ], 1 ] ],
  [ [ [ 2, 0 ], 1 ] ], [ [ [ 1, 1 ], 2 ] ],
  [ [ [ 3, 0 ], 1 ], [ [ 0, 2 ], 1 ] ], [ [ [ 2, 1 ], 3 ] ],
  [ [ [ 4, 0 ], 1 ], [ [ 1, 2 ], 3 ] ], [ [ [ 3, 1 ], 4 ], [ [ 0, 3 ], 1 ] ],
  [ [ [ 5, 0 ], 1 ], [ [ 2, 2 ], 6 ] ], [ [ [ 4, 1 ], 5 ], [ [ 1, 3 ], 4 ] ],
  [ [ [ 3, 2 ], 9 ], [ [ 0, 4 ], 1 ] ], [ [ [ 5, 1 ], 6 ], [ [ 2, 3 ], 10 ] ],
  [ [ [ 4, 2 ], 12 ], [ [ 1, 4 ], 5 ] ],
  [ [ [ 6, 1 ], 5 ], [ [ 3, 3 ], 18 ], [ [ 0, 5 ], 1 ] ],
  [ [ [ 5, 2 ], 16 ], [ [ 2, 4 ], 15 ] ] ]
gap> # </L>
gap> 
gap> 
gap> # </Section>
gap> # <#/GAPDoc>
gap> 
gap> STOP_TEST("test11.g",10000);
