/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.jimage;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import jdk.internal.jimage.ImageReader;

public class ImageReaderFactory {
    private static final String JAVA_HOME;
    private static final Path BOOT_MODULES_JIMAGE;
    private static final Map<Path, ImageReader> readers;
    private static Function<Path, ImageReader> OPENER;

    private ImageReaderFactory() {
    }

    public static ImageReader get(Path jimage) throws IOException {
        Objects.requireNonNull(jimage);
        try {
            return readers.computeIfAbsent(jimage, OPENER);
        }
        catch (UncheckedIOException io) {
            throw io.getCause();
        }
    }

    public static ImageReader getImageReader() {
        try {
            return ImageReaderFactory.get(BOOT_MODULES_JIMAGE);
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(ioe);
        }
    }

    static {
        FileSystem fs;
        JAVA_HOME = System.getProperty("java.home");
        if (ImageReaderFactory.class.getClassLoader() == null) {
            try {
                fs = (FileSystem)Class.forName("sun.nio.fs.DefaultFileSystemProvider").getMethod("theFileSystem", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Exception e) {
                throw new ExceptionInInitializerError(e);
            }
        } else {
            fs = FileSystems.getDefault();
        }
        BOOT_MODULES_JIMAGE = fs.getPath(JAVA_HOME, "lib", "modules");
        readers = new ConcurrentHashMap<Path, ImageReader>();
        OPENER = new Function<Path, ImageReader>(){

            @Override
            public ImageReader apply(Path path) {
                try {
                    return ImageReader.open(path);
                }
                catch (IOException io) {
                    throw new UncheckedIOException(io);
                }
            }
        };
    }
}

