/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.datatool;

import com.dickimawbooks.texparserlib.Command;
import com.dickimawbooks.texparserlib.Group;
import com.dickimawbooks.texparserlib.TeXFloatingPoint;
import com.dickimawbooks.texparserlib.TeXLongNumber;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserListener;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import com.dickimawbooks.texparserlib.UserNumber;
import com.dickimawbooks.texparserlib.latex.datatool.DataCurrencyElement;
import com.dickimawbooks.texparserlib.latex.datatool.DataElement;
import com.dickimawbooks.texparserlib.latex.datatool.DataNumericElement;
import com.dickimawbooks.texparserlib.latex.datatool.DataToolBaseSty;
import com.dickimawbooks.texparserlib.latex.datatool.DataToolSty;
import com.dickimawbooks.texparserlib.latex.datatool.DatumElement;
import com.dickimawbooks.texparserlib.latex.datatool.DatumType;
import java.io.IOException;

public class DatumCommand
extends Command {
    protected TeXObject original;
    protected TeXObject currencySym;
    protected TeXObject objValue;
    protected Number numValue;
    protected DatumType type;

    public DatumCommand(String string, TeXObject teXObject, Number number, TeXObject teXObject2, DatumType datumType) {
        this(string, teXObject, number, null, teXObject2, datumType);
    }

    public DatumCommand(String string, TeXObject teXObject, Number number, TeXObject teXObject2, TeXObject teXObject3, DatumType datumType) {
        super(string);
        this.original = teXObject;
        this.numValue = number;
        if (teXObject2 == null && number != null) {
            switch (datumType) {
                case INTEGER: {
                    teXObject2 = new UserNumber(number.intValue());
                    break;
                }
                case DATE: {
                    teXObject2 = new TeXLongNumber(number.longValue());
                    break;
                }
                default: {
                    teXObject2 = new TeXFloatingPoint(number.doubleValue());
                    break;
                }
            }
        } else {
            this.objValue = teXObject2;
        }
        this.currencySym = teXObject3;
        this.type = datumType;
    }

    @Override
    public Object clone() {
        return new DatumCommand(this.getName(), (TeXObject)this.original.clone(), this.numValue, this.objValue == null ? null : (TeXObject)this.objValue.clone(), this.currencySym == null ? null : (TeXObject)this.currencySym.clone(), this.type);
    }

    public static DatumCommand createString(String string, TeXObject teXObject) {
        return new DatumCommand(string, teXObject, null, null, DatumType.STRING);
    }

    public static DatumCommand createInteger(String string, TeXObject teXObject, int n) {
        return new DatumCommand(string, teXObject, n, null, DatumType.INTEGER);
    }

    public static DatumCommand createDecimal(String string, TeXObject teXObject, double d) {
        return new DatumCommand(string, teXObject, d, null, DatumType.DECIMAL);
    }

    public static DatumCommand createCurrency(String string, TeXObject teXObject, double d, TeXObject teXObject2) {
        return new DatumCommand(string, teXObject, d, teXObject2, DatumType.CURRENCY);
    }

    public static DatumCommand createDateTime(String string, TeXObject teXObject, double d, TeXObject teXObject2) {
        return new DatumCommand(string, teXObject, d, teXObject2, DatumType.DATETIME);
    }

    public static DatumCommand createDate(String string, TeXObject teXObject, long l, TeXObject teXObject2) {
        return new DatumCommand(string, teXObject, l, teXObject2, DatumType.DATE);
    }

    public static DatumCommand createTime(String string, TeXObject teXObject, double d, TeXObject teXObject2) {
        return new DatumCommand(string, teXObject, d, teXObject2, DatumType.TIME);
    }

    public static DatumCommand create(TeXParser teXParser, String string, DataElement dataElement) {
        DatumType datumType = dataElement.getDatumType();
        if (dataElement instanceof DatumElement) {
            DatumElement datumElement = (DatumElement)dataElement;
            return new DatumCommand(string, dataElement, datumElement.getNumber(), datumElement.getTeXValue(teXParser), datumElement.getCurrencySymbol(), datumType);
        }
        switch (datumType) {
            case INTEGER: {
                return new DatumCommand(string, dataElement, ((DataNumericElement)dataElement).intValue(), dataElement.getTeXValue(teXParser), null, datumType);
            }
            case DECIMAL: {
                return new DatumCommand(string, dataElement, ((DataNumericElement)dataElement).doubleValue(), dataElement.getTeXValue(teXParser), null, datumType);
            }
            case CURRENCY: {
                DataCurrencyElement dataCurrencyElement = (DataCurrencyElement)dataElement;
                return new DatumCommand(string, dataElement, dataCurrencyElement.doubleValue(), dataElement.getTeXValue(teXParser), dataCurrencyElement.getSymbol(), datumType);
            }
            case DATETIME: {
                return new DatumCommand(string, dataElement, ((DataNumericElement)dataElement).doubleValue(), dataElement.getTeXValue(teXParser), datumType);
            }
            case DATE: {
                return new DatumCommand(string, dataElement, ((DataNumericElement)dataElement).longValue(), dataElement.getTeXValue(teXParser), datumType);
            }
            case TIME: {
                return new DatumCommand(string, dataElement, ((DataNumericElement)dataElement).doubleValue(), dataElement.getTeXValue(teXParser), datumType);
            }
        }
        return new DatumCommand(string, dataElement, null, null, datumType);
    }

    public static DatumCommand create(DataToolSty dataToolSty, String string, TeXObject teXObject) throws IOException {
        if (teXObject instanceof DataElement) {
            return DatumCommand.create(dataToolSty.getParser(), string, (DataElement)teXObject);
        }
        if (teXObject.isEmpty()) {
            return new DatumCommand(string, teXObject, null, null, DatumType.UNKNOWN);
        }
        return DatumCommand.create(dataToolSty.getParser(), string, dataToolSty.getElement(teXObject));
    }

    public static DatumCommand create(DataToolBaseSty dataToolBaseSty, String string, TeXObject teXObject) throws IOException {
        if (teXObject instanceof DataElement) {
            return DatumCommand.create(dataToolBaseSty.getParser(), string, (DataElement)teXObject);
        }
        if (teXObject.isEmpty()) {
            return new DatumCommand(string, teXObject, null, null, DatumType.UNKNOWN);
        }
        return DatumCommand.create(dataToolBaseSty.getParser(), string, dataToolBaseSty.getElement(teXObject));
    }

    public TeXObject getOriginal() {
        return this.original;
    }

    public TeXObject getCurrencySymbol() {
        return this.currencySym;
    }

    public Number getNumericValue() {
        return this.numValue;
    }

    public TeXObject getTeXValue() {
        return this.objValue;
    }

    public DatumType getType() {
        return this.type;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXParserListener teXParserListener = teXParser.getListener();
        TeXObjectList teXObjectList2 = teXParserListener.createStack();
        teXObjectList2.add(teXParserListener.getControlSequence("__datatool_datum:nnnn"));
        Group group = teXParserListener.createGroup();
        teXObjectList2.add(group);
        if (teXParser.isStack(this.original)) {
            group.addAll((TeXObjectList)this.original.clone());
        } else {
            group.add((TeXObject)this.original.clone());
        }
        group = teXParserListener.createGroup();
        if (this.objValue != null) {
            group.add((TeXObject)this.objValue.clone());
        }
        teXObjectList2.add(group);
        group = teXParserListener.createGroup();
        teXObjectList2.add(group);
        if (this.currencySym != null) {
            if (teXParser.isStack(this.currencySym)) {
                group.addAll((TeXObjectList)this.currencySym.clone());
            } else {
                group.add((TeXObject)this.currencySym.clone());
            }
        }
        teXObjectList2.add(this.type.getCs(teXParserListener));
        return teXObjectList2;
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return TeXParserUtils.toList((TeXObject)this.original.clone(), teXParser);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXParserUtils.process((TeXObject)this.original.clone(), teXParser, teXObjectList);
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.process(teXParser, teXParser);
    }

    @Override
    public String toString() {
        return String.format("%s[name=%s,original=%s,type=%s,currencySym=%s,number=%s,value=%s]", new Object[]{this.getClass().getSimpleName(), this.getName(), this.original, this.type, this.currencySym, this.numValue, this.objValue});
    }
}

