import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { de_ListContinuousDeploymentPoliciesCommand, se_ListContinuousDeploymentPoliciesCommand, } from "../protocols/Aws_restXml";
export { $Command };
export class ListContinuousDeploymentPoliciesCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("Cloudfront2020_05_31", "ListContinuousDeploymentPolicies", {})
    .n("CloudFrontClient", "ListContinuousDeploymentPoliciesCommand")
    .f(void 0, void 0)
    .ser(se_ListContinuousDeploymentPoliciesCommand)
    .de(de_ListContinuousDeploymentPoliciesCommand)
    .build() {
}
