/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.odf;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.tika.config.Field;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.odf.FlatOpenDocumentMacroHandler;
import org.apache.tika.parser.odf.NSNormalizerContentHandler;
import org.apache.tika.parser.odf.OpenDocumentBodyHandler;
import org.apache.tika.parser.odf.OpenDocumentMetaParser;
import org.apache.tika.sax.ContentHandlerDecorator;
import org.apache.tika.sax.EmbeddedContentHandler;
import org.apache.tika.sax.XHTMLContentHandler;
import org.apache.tika.utils.XMLReaderUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class FlatOpenDocumentParser
extends AbstractParser {
    static final MediaType FLAT_OD = MediaType.application((String)"vnd.oasis.opendocument.tika.flat.document");
    static final MediaType FLAT_ODT = MediaType.application((String)"vnd.oasis.opendocument.flat.text");
    static final MediaType FLAT_ODP = MediaType.application((String)"vnd.oasis.opendocument.flat.presentation");
    static final MediaType FLAT_ODS = MediaType.application((String)"vnd.oasis.opendocument.flat.spreadsheet");
    static final MediaType ODT = MediaType.application((String)"vnd.oasis.opendocument.text");
    static final MediaType ODP = MediaType.application((String)"vnd.oasis.opendocument.presentation");
    static final MediaType ODS = MediaType.application((String)"vnd.oasis.opendocument.spreadsheet");
    private static final long serialVersionUID = -8739250869531737584L;
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.unmodifiableSet(new HashSet<MediaType>(Arrays.asList(FLAT_OD, FLAT_ODT, FLAT_ODP, FLAT_ODS)));
    private boolean extractMacros = false;

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        try {
            ContentHandler fodHandler = this.getContentHandler((ContentHandler)xhtml, metadata, context);
            XMLReaderUtils.parseSAX((InputStream)new CloseShieldInputStream(stream), (ContentHandler)new EmbeddedContentHandler(fodHandler), (ParseContext)context);
            MediaType detected = ((FlatOpenDocumentParserHandler)((Object)fodHandler)).getDetectedType();
            if (detected != null) {
                metadata.set("Content-Type", detected.toString());
            }
        }
        finally {
            xhtml.endDocument();
        }
    }

    @Field
    public void setExtractMacros(boolean extractMacros) {
        this.extractMacros = extractMacros;
    }

    public boolean isExtractMacros() {
        return this.extractMacros;
    }

    private ContentHandler getContentHandler(ContentHandler handler, Metadata metadata, ParseContext context) {
        return new FlatOpenDocumentParserHandler(handler, metadata, context, this.extractMacros);
    }

    private static class FlatOpenDocumentParserHandler
    extends ContentHandlerDecorator {
        private static final String META = "meta";
        private static final String BODY = "body";
        private static final String SCRIPTS = "scripts";
        private static final String DOCUMENT = "document";
        private final ContentHandler defaultHandler;
        private final ContentHandler bodyHandler;
        private final ContentHandler metadataHandler;
        private final ContentHandler macroHandler;
        private final boolean extractMacros;
        private ContentHandler currentHandler;
        private MediaType detectedType;

        private FlatOpenDocumentParserHandler(ContentHandler baseHandler, Metadata metadata, ParseContext parseContext, boolean extractMacros) {
            this.currentHandler = this.defaultHandler = new DefaultHandler();
            this.detectedType = null;
            this.extractMacros = extractMacros;
            this.bodyHandler = new OpenDocumentBodyHandler((ContentHandler)((Object)new NSNormalizerContentHandler(baseHandler)), parseContext);
            this.metadataHandler = new NSNormalizerContentHandler(OpenDocumentMetaParser.getContentHandler(metadata, parseContext, new ContentHandler[0]));
            this.macroHandler = extractMacros ? new FlatOpenDocumentMacroHandler(baseHandler, parseContext) : null;
        }

        MediaType getDetectedType() {
            return this.detectedType;
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes attrs) throws SAXException {
            String mime;
            if (META.equals(localName)) {
                this.currentHandler = this.metadataHandler;
            } else if (BODY.equals(localName)) {
                this.currentHandler = this.bodyHandler;
            } else if (this.extractMacros && SCRIPTS.equals(localName)) {
                this.currentHandler = this.macroHandler;
            }
            if (DOCUMENT.equals(localName) && (mime = XMLReaderUtils.getAttrValue((String)"mimetype", (Attributes)attrs)) != null) {
                if (mime.equals(ODT.toString())) {
                    this.detectedType = FLAT_ODT;
                } else if (mime.equals(ODP.toString())) {
                    this.detectedType = FLAT_ODP;
                } else if (mime.equals(ODS.toString())) {
                    this.detectedType = FLAT_ODS;
                }
            }
            this.currentHandler.startElement(namespaceURI, localName, qName, attrs);
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            this.currentHandler.characters(ch, start, length);
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            if (META.equals(localName)) {
                this.currentHandler = this.defaultHandler;
            } else if (BODY.equals(localName)) {
                this.currentHandler = this.defaultHandler;
            } else if (this.extractMacros && SCRIPTS.equals(localName)) {
                this.currentHandler = this.defaultHandler;
            }
            this.currentHandler.endElement(namespaceURI, localName, qName);
        }
    }
}

