/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.script.rhino;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.mozilla.javascript.ClassShutter;

public class RhinoClassShutter
implements ClassShutter {
    private static final List<Pattern> whitelist = new ArrayList<Pattern>();

    public static void addToWhitelist(String string) throws PatternSyntaxException {
        if (string == null || (string = string.trim()).length() == 0) {
            return;
        }
        for (Pattern pattern : whitelist) {
            if (!string.equals(pattern.pattern())) continue;
            return;
        }
        Pattern pattern = Pattern.compile(string);
        whitelist.add(pattern);
    }

    public static void removeFromWhitelist(String string) throws PatternSyntaxException {
        if (string == null || (string = string.trim()).length() == 0) {
            return;
        }
        for (Pattern pattern : whitelist) {
            if (!string.equals(pattern.pattern())) continue;
            whitelist.remove(pattern);
            break;
        }
    }

    public static void loadWhitelist(Reader reader) throws IOException, PatternSyntaxException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(reader);
        while ((string = bufferedReader.readLine()) != null) {
            int n = string.length();
            if (n <= 0) continue;
            char c = string.charAt(0);
            if (c == '-') {
                RhinoClassShutter.removeFromWhitelist(string.substring(1, n));
                continue;
            }
            if (c == '+') {
                RhinoClassShutter.addToWhitelist(string.substring(1, n));
                continue;
            }
            if (c == '#') continue;
            RhinoClassShutter.addToWhitelist(string);
        }
    }

    public boolean visibleToScripts(String string) {
        if (string.startsWith("org.mozilla.javascript")) {
            return "org.mozilla.javascript.EcmaError".equals(string);
        }
        if (string.startsWith("io.sf.carte.echosvg.")) {
            String string2 = string.substring(20);
            if (string2.startsWith("script")) {
                return false;
            }
            if (string2.startsWith("apps")) {
                return false;
            }
            if (string2.startsWith("bridge.")) {
                String object = string2.substring(7);
                if (object.startsWith("ScriptingEnvironment")) {
                    String string3;
                    return object.startsWith("$Window$", 20) && ((string3 = object.substring(28)).equals("IntervalScriptTimerTask") || string3.equals("IntervalRunnableTimerTask") || string3.equals("TimeoutScriptTimerTask") || string3.equals("TimeoutRunnableTimerTask"));
                }
                if (object.startsWith("BaseScriptingEnvironment")) {
                    return false;
                }
            }
        }
        for (Pattern pattern : whitelist) {
            if (!pattern.matcher(string).matches()) continue;
            return true;
        }
        return false;
    }

    static {
        RhinoClassShutter.addToWhitelist("java.io.PrintStream");
        RhinoClassShutter.addToWhitelist("java.lang.System");
        RhinoClassShutter.addToWhitelist("java.net.URL");
        RhinoClassShutter.addToWhitelist(".*Permission");
        RhinoClassShutter.addToWhitelist("org.w3c.*");
        RhinoClassShutter.addToWhitelist("io.sf.carte.echosvg.w3c.*");
        RhinoClassShutter.addToWhitelist("io.sf.carte.echosvg.anim.*");
        RhinoClassShutter.addToWhitelist("io.sf.carte.echosvg.dom.*");
        RhinoClassShutter.addToWhitelist("io.sf.carte.echosvg.css.*");
        RhinoClassShutter.addToWhitelist("io.sf.carte.echosvg.util.*");
    }
}

