/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.AlgebraicExpression;
import io.sf.carte.doc.style.css.CSSExpression;
import io.sf.carte.doc.style.css.property.StyleExpression;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;

class ProductExpression
extends StyleExpression
implements AlgebraicExpression {
    private static final long serialVersionUID = 1L;
    private final LinkedList<CSSExpression> operands = new LinkedList();

    ProductExpression() {
    }

    ProductExpression(ProductExpression productExpression) {
        super(productExpression);
        Iterator iterator = productExpression.operands.iterator();
        while (iterator.hasNext()) {
            this.operands.add(((CSSExpression)iterator.next()).clone());
        }
    }

    @Override
    void addExpression(StyleExpression styleExpression) {
        StyleExpression styleExpression2 = styleExpression.getParentExpression();
        if (styleExpression2 != null && styleExpression2.getPartType() == CSSExpression.AlgebraicPart.SUM) {
            styleExpression2.replaceLastExpression(this);
        } else {
            this.operands.add(styleExpression);
            styleExpression.setParentExpression(this);
            if (this.nextOperandInverse) {
                styleExpression.setInverseOperation(true);
                this.nextOperandInverse = false;
            }
        }
    }

    @Override
    public CSSExpression item(int n) {
        try {
            return this.operands.get(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    @Override
    public int getLength() {
        return this.operands.size();
    }

    @Override
    public CSSExpression.AlgebraicPart getPartType() {
        return CSSExpression.AlgebraicPart.PRODUCT;
    }

    @Override
    public int hashCode() {
        int n = 211;
        int n2 = super.hashCode();
        n2 = 211 * n2 + (this.operands == null ? 0 : this.operands.hashCode());
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        ProductExpression productExpression = (ProductExpression)object;
        if (this.operands == null) {
            return productExpression.operands == null;
        }
        return this.operands.equals(productExpression.operands);
    }

    @Override
    public ProductExpression clone() {
        return new ProductExpression(this);
    }

    @Override
    public String getCssText() {
        if (this.operands.isEmpty()) {
            return "";
        }
        BufferSimpleWriter bufferSimpleWriter = new BufferSimpleWriter(32 + this.operands.size() * 16);
        try {
            this.writeCssText((SimpleWriter)bufferSimpleWriter);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bufferSimpleWriter.toString();
    }

    @Override
    public String getMinifiedCssText() {
        if (this.operands.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(32);
        Iterator iterator = this.operands.iterator();
        CSSExpression cSSExpression = (CSSExpression)iterator.next();
        if (cSSExpression.getPartType() == CSSExpression.AlgebraicPart.SUM) {
            stringBuilder.append('(').append(cSSExpression.getMinifiedCssText()).append(')');
        } else {
            stringBuilder.append(cSSExpression.getMinifiedCssText());
        }
        while (iterator.hasNext()) {
            cSSExpression = (CSSExpression)iterator.next();
            if (cSSExpression.isInverseOperation()) {
                stringBuilder.append('/');
            } else {
                stringBuilder.append('*');
            }
            if (cSSExpression.getPartType() == CSSExpression.AlgebraicPart.SUM) {
                stringBuilder.append('(').append(cSSExpression.getMinifiedCssText()).append(')');
                continue;
            }
            stringBuilder.append(cSSExpression.getMinifiedCssText());
        }
        return stringBuilder.toString();
    }

    @Override
    public void writeCssText(SimpleWriter simpleWriter) throws IOException {
        Iterator iterator = this.operands.iterator();
        if (!iterator.hasNext()) {
            return;
        }
        CSSExpression cSSExpression = (CSSExpression)iterator.next();
        if (cSSExpression.getPartType() == CSSExpression.AlgebraicPart.SUM) {
            simpleWriter.write('(');
            cSSExpression.writeCssText(simpleWriter);
            simpleWriter.write(')');
        } else {
            cSSExpression.writeCssText(simpleWriter);
        }
        while (iterator.hasNext()) {
            cSSExpression = (CSSExpression)iterator.next();
            if (cSSExpression.isInverseOperation()) {
                simpleWriter.write('/');
            } else {
                simpleWriter.write('*');
            }
            if (cSSExpression.getPartType() == CSSExpression.AlgebraicPart.SUM) {
                simpleWriter.write('(');
                cSSExpression.writeCssText(simpleWriter);
                simpleWriter.write(')');
                continue;
            }
            cSSExpression.writeCssText(simpleWriter);
        }
    }

    static AlgebraicExpression createProductExpression() {
        return new ProductExpression();
    }
}

