define(["exports","./../../emby-apiclient/events.js","./../../emby-apiclient/connectionmanager.js","./../textencoding.js","./../playback/playbackmanager.js","./../servicelocator.js","./../../approuter.js","./../inputmanager.js","./../../focusmanager.js"],function(_exports,_events,_connectionmanager,_textencoding,_playbackmanager,_servicelocator,_approuter,_inputmanager,_focusmanager){Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0;var serverNotifications={};function notifyApp(){_inputmanager.default.notify()}function encodeForDisplay(text){return _textencoding.default.htmlEncode(text)}function displayMessage(cmd){var options,cmd=cmd.Arguments,timeoutMs=(cmd.Header&&(cmd.Header=encodeForDisplay(cmd.Header)),cmd.Text&&(cmd.Text=encodeForDisplay(cmd.Text)),cmd.TimeoutMs?parseInt(cmd.TimeoutMs):0);timeoutMs?(options={title:cmd.Header,text:cmd.Text,timeoutMs:timeoutMs},Emby.importModule("./modules/toast/toast.js").then(function(toast){return toast(options)})):function(options){Emby.importModule("./modules/common/dialogs/alert.js").then(function(alert){return alert(options)})}({title:cmd.Header,text:cmd.Text})}function processGeneralCommand(cmd,apiClient){switch(cmd.Name){case"Select":return void _inputmanager.default.trigger("select");case"Back":return void _inputmanager.default.trigger("back");case"MoveUp":return void _inputmanager.default.trigger("up");case"MoveDown":return void _inputmanager.default.trigger("down");case"MoveLeft":return void _inputmanager.default.trigger("left");case"MoveRight":return void _inputmanager.default.trigger("right");case"PageUp":return void _inputmanager.default.trigger("pageup");case"PageDown":return void _inputmanager.default.trigger("pagedown");case"PlayTrailers":!function(apiClient,itemId){apiClient.getItem(apiClient.getCurrentUserId(),itemId,{ExcludeFields:"Chapters,MediaSources,MediaStreams,People,Overview"}).then(function(item){_playbackmanager.default.playTrailers(item)})}(apiClient,cmd.Arguments.ItemId);break;case"SetRepeatMode":_playbackmanager.default.setRepeatMode(cmd.Arguments.RepeatMode);break;case"SetShuffle":var shuffle=cmd.Arguments.Shuffle;_playbackmanager.default.setShuffle(!0===shuffle||"true"===(shuffle||"").toString().toLowerCase());break;case"SetSubtitleOffset":_playbackmanager.default.setSubtitleOffset(parseFloat(cmd.Arguments.SubtitleOffset));break;case"IncrementSubtitleOffset":_playbackmanager.default.incrementSubtitleOffset(parseFloat(cmd.Arguments.Increment));break;case"SetPlaybackRate":_playbackmanager.default.setPlaybackRate(parseFloat(cmd.Arguments.PlaybackRate));break;case"VolumeUp":return void _inputmanager.default.trigger("volumeup");case"VolumeDown":return void _inputmanager.default.trigger("volumedown");case"ChannelUp":return void _inputmanager.default.trigger("channelup");case"ChannelDown":return void _inputmanager.default.trigger("channeldown");case"Mute":return void _inputmanager.default.trigger("mute");case"Unmute":return void _inputmanager.default.trigger("unmute");case"ToggleMute":return void _inputmanager.default.trigger("togglemute");case"SetVolume":notifyApp(),_playbackmanager.default.setVolume(cmd.Arguments.Volume);break;case"SetAudioStreamIndex":notifyApp(),_playbackmanager.default.setAudioStreamIndex(parseInt(cmd.Arguments.Index));break;case"SetSubtitleStreamIndex":notifyApp(),_playbackmanager.default.setSubtitleStreamIndex(parseInt(cmd.Arguments.Index),null,"true"===cmd.Arguments.RefreshMediaSource);break;case"SetCurrentPlaylistItem":notifyApp(),_playbackmanager.default.setCurrentPlaylistItem(cmd.Arguments.PlaylistItemId);break;case"MovePlaylistItem":notifyApp(),_playbackmanager.default.movePlaylistItem(cmd.Arguments.PlaylistItemId,parseInt(cmd.Arguments.NewIndex));break;case"RemoveFromPlaylist":notifyApp(),_playbackmanager.default.removeFromPlaylist(cmd.Arguments.PlaylistItemIds.split(","));break;case"ToggleFullscreen":return void _inputmanager.default.trigger("togglefullscreen");case"GoHome":return void _inputmanager.default.trigger("home");case"GoToSettings":return void _inputmanager.default.trigger("settings");case"DisplayContent":!function(cmd,apiClient){_playbackmanager.default.isPlayingLocally(["Video","Book","Game"])||_approuter.default.showItem(cmd.Arguments.ItemId,apiClient.serverId())}(cmd,apiClient);break;case"GoToSearch":return void _inputmanager.default.trigger("search");case"DisplayMessage":displayMessage(cmd);break;case"ToggleOsd":case"ToggleContextMenu":case"TakeScreenShot":case"SendKey":break;case"SendString":_focusmanager.default.sendText(cmd.Arguments.String);break;default:console.log("processGeneralCommand does not recognize: "+cmd.Name)}notifyApp()}var appSupportsSync=_servicelocator.appHost.supports("sync");function onMessageReceived(e,msg){var messageType=msg.MessageType;switch(messageType){case"Play":notifyApp();var serverId=this.serverId();"PlayNext"===msg.Data.PlayCommand?_playbackmanager.default.queueNext({ids:msg.Data.ItemIds,serverId:serverId}):"PlayLast"===msg.Data.PlayCommand?_playbackmanager.default.queue({ids:msg.Data.ItemIds,serverId:serverId}):_playbackmanager.default.play({ids:msg.Data.ItemIds,startPositionTicks:msg.Data.StartPositionTicks,mediaSourceId:msg.Data.MediaSourceId,audioStreamIndex:msg.Data.AudioStreamIndex,subtitleStreamIndex:msg.Data.SubtitleStreamIndex,startIndex:msg.Data.StartIndex,serverId:serverId,shuffle:"PlayShuffle"===msg.Data.PlayCommand});break;case"Playstate":"Stop"===msg.Data.Command?_inputmanager.default.trigger("stop"):"Pause"===msg.Data.Command?_inputmanager.default.trigger("pause"):"Unpause"===msg.Data.Command?_inputmanager.default.trigger("play"):"PlayPause"===msg.Data.Command?_inputmanager.default.trigger("playpause"):"Seek"===msg.Data.Command?_playbackmanager.default.seek(msg.Data.SeekPositionTicks):"SeekRelative"===msg.Data.Command?_playbackmanager.default.seekRelative(msg.Data.SeekPositionTicks):"NextTrack"===msg.Data.Command?_inputmanager.default.trigger("next"):"PreviousTrack"===msg.Data.Command?_inputmanager.default.trigger("previous"):notifyApp();break;case"GeneralCommand":processGeneralCommand(msg.Data,this);break;case"UserDataChanged":if(msg.Data.UserId===this.getCurrentUserId())for(var userDataList=msg.Data.UserDataList,i=0,length=userDataList.length;i<length;i++)_events.default.trigger(serverNotifications,"UserDataChanged",[this,userDataList[i],msg.Data]);break;case"SyncJobItemReady":case"SyncJobItemsReady":appSupportsSync&&syncNow();break;case"SyncJobCancelled":case"SyncJobItemCancelled":appSupportsSync&&syncNow(),_events.default.trigger(serverNotifications,messageType,[this,msg.Data]);break;case"ServerShuttingDown":case"ServerRestarting":_servicelocator.appHost.supports("remotecontrol")&&_playbackmanager.default.setDefaultPlayerActive(),_events.default.trigger(serverNotifications,messageType,[this,msg.Data]);break;default:_events.default.trigger(serverNotifications,messageType,[this,msg.Data])}}function syncNow(){require(["localsync"],function(localSync){localSync.sync()})}function bindEvents(apiClient){_events.default.off(apiClient,"message",onMessageReceived),_events.default.on(apiClient,"message",onMessageReceived)}_connectionmanager.default.getApiClients().forEach(bindEvents),_events.default.on(_connectionmanager.default,"apiclientcreated",function(e,newApiClient){bindEvents(newApiClient)});_exports.default=serverNotifications});