define(["exports","./../dom.js","./../focusmanager.js","./../common/globalize.js","./../common/usersettings/usersettings.js","./../common/itemmanager/itemmanager.js","./../layoutmanager.js","./../cardbuilder/cardbuilder.js","./../listview/listview.js","./../loading/loading.js","./../alphapicker/alphapicker.js","./../common/playback/playbackmanager.js","./../emby-apiclient/connectionmanager.js","./../maintabsmanager.js","./../shortcuts.js"],function(_exports,_dom,_focusmanager,_globalize,_usersettings,_itemmanager,_layoutmanager,_cardbuilder,_listview,_loading,_alphapicker,_playbackmanager,_connectionmanager,_maintabsmanager,_shortcuts){Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0;var dataGrid,supportsCssVariables=CSS.supports("color","var(--fake-var)"),supportsCalc=CSS.supports("width","min(45.2%,calc(100% - .65em))"),supportsMin=CSS.supports("width","min(10em, 5vw)"),supportsCalcMin=supportsCalc&&supportsMin;function loadMultiSelect(){return _layoutmanager.default.tv?Promise.resolve(null):Emby.importModule("./modules/multiselect/multiselect.js")}function showActionSheet(options){return Emby.importModule("./modules/actionsheet/actionsheet.js").then(function(ActionSheet){return ActionSheet.show(options)})}function getApiClient(instance){return instance.getApiClient?instance.getApiClient():instance.apiClient||((instance=instance.params.serverId)?_connectionmanager.default.getApiClient(instance):_connectionmanager.default.currentApiClient())}function trySelectValue(instance,scroller,view,value,focus){var sortValues=instance.getSortValues();!value||"#"===value&&"Ascending"===sortValues.sortOrder?instance.itemsContainer.scrollToIndex(0,{forceInstantScroll:!1},focus):instance.getItems({Limit:0}).then(function(totalResult){var sortBy,query;totalResult.TotalRecordCount<=1?instance.itemsContainer.scrollToIndex(0,{forceInstantScroll:!1},focus):"#"===value&&"Descending"===sortValues.sortOrder?instance.itemsContainer.scrollToIndex(totalResult.TotalRecordCount-1,{forceInstantScroll:!1},focus):(query={Limit:0},(sortBy=sortValues.sortBy||"").startsWith("AlbumArtist")?query.AlbumArtistStartsWithOrGreater=value:sortBy.startsWith("Artist")?query.ArtistStartsWithOrGreater=value:query.NameStartsWithOrGreater=value,instance.getItems(query).then(function(result){result="Descending"===sortValues.sortOrder?result.TotalRecordCount:Math.max(totalResult.TotalRecordCount-result.TotalRecordCount,0);instance.itemsContainer.scrollToIndex(result,{forceInstantScroll:!1},focus)}))})}function refreshAfterSettingsChange(instance){instance.resetRandomSeed(),instance.itemsContainer.refreshItems()}function showViewSettingsMenu(e){var instance=this;Emby.importModule("./modules/viewsettings/viewsettings.js").then(function(ViewSettings){var isGrid="datagrid"===instance.getViewSettings().imageType;(new ViewSettings).show({settingsKey:instance.getSettingsKey(),settings:instance.getViewSettings(),visibleSettings:instance.getVisibleViewSettings(),availableFields:instance.getAvailableFields(),viewOptions:instance.getAvailableViewOptions(),positionTo:e.target.closest("button"),positionY:"bottom",onChange:function(){var defaultSortBy,sorting,viewSettings=instance.getViewSettings();isGrid&&"datagrid"!==viewSettings.imageType&&(defaultSortBy=null==(sorting=instance.getDefaultSorting())?void 0:sorting.sortBy,sorting=null==sorting?void 0:sorting.sortOrder,instance.setSortValueInternal(defaultSortBy,sorting)),isGrid="datagrid"===viewSettings.imageType,refreshAfterSettingsChange(instance)}})})}function showSortMenu(e){var instance=this,options=instance.getSortMenuOptions();!function(instance,options){for(var currentValues=instance.getSortValues(),i=0,length=options.length;i<length;i++){var opt=options[i];if(opt.selected=opt.value===currentValues.sortBy,opt.selected){var icon="Descending"===currentValues.sortOrder?"&#xe5DB;":"&#xe5D8;";opt.asideIcon=icon;break}}}(instance,options),showActionSheet({items:options,positionTo:e.target.closest("button"),positionY:"bottom",hideTitleWhenNotFullscreen:!0,title:_globalize.default.translate("HeaderSortBy"),offsetTop:2,hasItemAsideIcon:!0,hasItemSelectionState:!0}).then(function(value){instance.setSortValue(value)})}function ListController(view,params){this.view=view,(this.params=params).serverId&&(this.apiClient=_connectionmanager.default.getApiClient(params.serverId))}function onItemsContainerFocus(e){var alphaPicker=this.alphaPicker;alphaPicker&&(e=_shortcuts.default.getItemFromChildNode(e.target,null,this.itemsContainer))&&alphaPicker.setCurrentFromItem(e)}function onDataFetched(result){var values=this.getSortValues(),values=this.enableAlphaPicker(values.sortBy,values.sortOrder),values=(_dom.default.removeEventListener(this.itemsContainer,"focus",onItemsContainerFocus.bind(this),{capture:!0,passive:!0}),_layoutmanager.default.tv&&values&&_dom.default.addEventListener(this.itemsContainer,"focus",onItemsContainerFocus.bind(this),{capture:!0,passive:!0}),result.Items||result);return"datagrid"!==this.getViewSettings(values).imageType?Promise.resolve(result):(dataGrid?Promise.resolve(dataGrid):Emby.importModule("./modules/datagrid/datagrid.js").then(function(response){return dataGrid=response})).then(function(){return Promise.resolve(result)})}function bindAll(elems,eventName,fn){for(var i=0,length=elems.length;i<length;i++)elems[i].addEventListener(eventName,fn)}function mapPrefix(i){return i.Name}function isNotName(n){return"Name"!==n}function isNotAirTime(n){return"AirTime"!==n}function isNotParentName(n){return"ParentName"!==n}function adjustListOptionsForGroupingProgramsBySeries(instance,items,options){"search"!==instance.params.type&&items.length&&items[0].AsSeries&&(options.progress=!1,options.showAirDateTime=!1,options.fields=options.fields.filter(isNotName).filter(isNotAirTime).filter(isNotParentName),options.fields.push("ParentNameOrName"))}function modifyFieldsInListOptions(instance,items,options,settings){var itemType=instance.getDisplayPreset()||"",params=instance.params;switch(itemType){case"":settings.fields.includes("Name")&&options.fields.push("ParentName");break;case"Game":case"MusicVideo":case"MusicAlbum":case"Audio":settings.fields.includes("Name")&&options.fields.push("ParentName");break;case"Episode":settings.fields.includes("Name")&&options.fields.unshift("ParentName");break;case"TvChannel":"OnNow"===params.type&&(options.programsAsSeries=!0,options.action="programlink",options.showCurrentProgramImage=!0),settings.fields.includes("Name")&&("OnNow"===params.type?(options.fields.unshift("CurrentProgramName"),options.fields.unshift("CurrentProgramParentName")):options.fields.push("CurrentProgramParentName"),options.fields.push("CurrentProgramTime"));break;case"Program":options.showAirDateTime=!0,settings.fields.includes("Name")&&("true"!==params.IsMovie&&options.fields.push("ParentName"),"Recordings"!==params.type)&&options.fields.push("AirTime")}}function getAvailableFieldIdMap(instance){for(var fields=instance.getAvailableFields(),result={},i=0,length=fields.length;i<length;i++){var field=fields[i];result[field.id]=field}return result}function detectDefaultViewType(instance,defaults,items){var viewType=instance._defaultViewType;return viewType=!viewType&&(items=items||instance.itemsContainer.items||[]).length&&function(items){for(var hasIndexNumber,matches=0,i=0,length=items.length;i<length;i++){var item=items[i];if(item){if(item.IsFolder||"Audio"!==item.MediaType)return;matches++,item.IndexNumber&&(hasIndexNumber=!0)}}return hasIndexNumber&&0<matches}(items)?instance._defaultViewType="list":viewType}function hideOrShowAll(elems,hide){for(var i=0,length=elems.length;i<length;i++)hide?elems[i].classList.add("hide"):elems[i].classList.remove("hide")}function destroyHeader(instance){var elem=instance._headerElement;if(elem){try{elem.remove()}catch(err){}instance._headerElement=null}}function ensureHeader(instance){var itemsContainer,elem=instance._headerElement;return elem||(instance._headerElement=elem=document.createElement("div"),elem.className="itemsContainer_header",(itemsContainer=instance.itemsContainer).parentNode.insertBefore(elem,itemsContainer),elem.addEventListener("contextmenu",function(e){e.preventDefault(),this.showColumnSelector(e)}.bind(instance)),elem.addEventListener("click",function(e){e.target.closest(".btnConfigureGridColumns")?this.showColumnSelector(e):(e=e.target.closest(".btnGridHeaderColumnSort"))&&this.setSortValue(e.getAttribute("data-sortvalue"))}.bind(instance))),elem}function removeScrollListener(instance){var scroller;instance.boundOnScroll&&((scroller=instance.scroller)&&scroller.removeEventListener("scroll",instance.boundOnScroll),instance.boundOnScroll=null)}function getBaseDisplayPreset(instance){var types=instance.getItemTypes(),itemType=types.length?types[0]:null;return itemType=itemType||((types=instance.getQueryIncludeItemTypes()).length?types[0]:null)}ListController.prototype.initItemsContainer=function(){var view=this.view;this.itemsContainer=view.querySelector(".itemsContainer"),this.itemsContainer.setListClasses=!0,this.itemsContainer.fetchData=this.getItems.bind(this),this.itemsContainer.onGetItems=this.onGetItems.bind(this),this.itemsContainer.virtualChunkSize=this.virtualChunkSize(),this.itemsContainer.getListOptions=this.getListOptions.bind(this),this.itemsContainer.onDataFetched=onDataFetched.bind(this),this.itemsContainer.onRefreshing=this.onRefreshing.bind(this),this.itemsContainer.afterRefresh=this.afterItemsRefreshed.bind(this),this.itemsContainer.onGetItemsFailed=this.onGetItemsFailed.bind(this),this.itemsContainer.showColumnSelector=this.showColumnSelector.bind(this),this.itemsContainer.addEventListener("multiselectactive",function(e){var itemsContainer=this.itemsContainer,_itemsContainer$curre=null==(_itemsContainer$curre=itemsContainer.currentListOptions)?void 0:_itemsContainer$curre.renderer;_itemsContainer$curre&&_itemsContainer$curre.onMultiSelectActive&&_itemsContainer$curre.onMultiSelectActive(itemsContainer,this._headerElement)}.bind(this)),this.itemsContainer.addEventListener("multiselectinactive",function(e){var itemsContainer=this.itemsContainer,_itemsContainer$curre2=null==(_itemsContainer$curre2=itemsContainer.currentListOptions)?void 0:_itemsContainer$curre2.renderer;_itemsContainer$curre2&&_itemsContainer$curre2.onMultiSelectInactive&&_itemsContainer$curre2.onMultiSelectInactive(itemsContainer,this._headerElement)}.bind(this))},ListController.prototype.initButtons=function(){for(var hasAnyViewSettings,view=this.view,btnViewSettings=view.querySelectorAll(".btnViewSettings"),supportsViewSettings=!1!==this.supportsViewSettings,i=0,length=btnViewSettings.length;i<length;i++)btnViewSettings[i].addEventListener("click",showViewSettingsMenu.bind(this)),supportsViewSettings&&(hasAnyViewSettings=!0,btnViewSettings[i].classList.remove("hide"));var filterButtons=view.querySelectorAll(".btnFilter"),hasVisibleFilters=(this.filterButtons=filterButtons,this.getVisibleFilters().length);for(i=0,length=filterButtons.length;i<length;i++){var btnFilter=filterButtons[i];btnFilter.addEventListener("click",this.showFilterMenu.bind(this)),hasVisibleFilters?(hasAnyViewSettings=!0,btnFilter.classList.remove("hide")):btnFilter.classList.add("hide")}var sortButtons=view.querySelectorAll(".btnSort"),supportsSorting=(this.sortButtons=sortButtons,this.supportsSorting());for(i=0,length=sortButtons.length;i<length;i++){var sortButton=sortButtons[i];sortButton.addEventListener("click",showSortMenu.bind(this)),supportsSorting?(hasAnyViewSettings=!0,sortButton.classList.remove("hide")):sortButton.classList.add("hide")}this.btnSortText=view.querySelector(".btnSortText"),this.btnSortIcon=view.querySelector(".btnSortIcon"),null==this.enableAlphaNumericShortcuts&&(this.enableAlphaNumericShortcuts="true"===this.itemsContainer.getAttribute("data-alphanumericshortcuts")&&this.enableVirtualData());var btnPlay=view.querySelectorAll(".btnPlay"),btnShuffle=view.querySelectorAll(".btnShuffle"),btnQueue=view.querySelectorAll(".btnQueue"),btnPlay=(bindAll(btnPlay,"click",this.play.bind(this)),bindAll(btnShuffle,"click",this.shuffle.bind(this)),bindAll(btnQueue,"click",this.queue.bind(this)),this.supportsPlay()&&btnPlay.length&&(hasAnyViewSettings=!0),this.supportsShuffle()&&btnShuffle.length&&(hasAnyViewSettings=!0),this.supportsQueue()&&btnQueue.length&&(hasAnyViewSettings=!0),view.querySelector(".itemsViewSettingsContainer"));(this.itemsViewSettingsContainer=btnPlay)&&(hasAnyViewSettings||!1!==this.enableTotalRecordCountDisplay||this.hasOtherViewButtons?btnPlay.classList.remove("hide"):btnPlay.classList.add("hide"),hasAnyViewSettings||this.hasOtherViewButtons?(btnPlay.classList.add("focusable"),btnPlay.setAttribute("data-focusabletype","nearest")):(btnPlay.classList.remove("focusable"),btnPlay.removeAttribute("data-focusabletype")),"x"===this.scrollDirection())&&btnPlay.classList.add("hide")},ListController.prototype.saveSortingOnServer=function(){return!1},ListController.prototype.setSortValueInternal=function(value,sortOrder){sortOrder=sortOrder||"Ascending";var settingsKey=this.getSettingsKey(),saveSortingOnServer=this.saveSortingOnServer();_usersettings.default.setFilter(this.getSortBySettingsKey(),value,saveSortingOnServer),_usersettings.default.setFilter(settingsKey+"-sortorder",sortOrder,saveSortingOnServer),this.updateSortText()},ListController.prototype.getDefaultSortingForField=function(fieldId){var field=this.getAvailableField(fieldId);if(!field)return null;for(var sortOptions=this.getSortMenuOptions(),i=0,length=sortOptions.length;i<length;i++){var sortOption=sortOptions[i];if(sortOption.value===field.sortBy)return{sortBy:sortOption.value,sortOrder:sortOption.defaultSortOrder}}},ListController.prototype.setSortValue=function(value){var currentValues=this.getSortValues(),sortOrder=currentValues.sortOrder;if(currentValues.sortBy===value)sortOrder="Ascending"===sortOrder?"Descending":"Ascending";else for(var sortOptions=this.getSortMenuOptions(),i=0,length=sortOptions.length;i<length;i++){var sortOption=sortOptions[i];if(sortOption.value===value){sortOrder=sortOption.defaultSortOrder;break}}this.setSortValueInternal(value,sortOrder),refreshAfterSettingsChange(this)},ListController.prototype.refreshPrefixes=function(){var instance=this;this.getPrefixes().then(function(prefixes){instance.alphaPicker.setPrefixes(prefixes)})},ListController.prototype.getPrefixes=function(){var queryInfo,apiClient,methodName,query,sortBy;return"search"===this.params.type?Promise.resolve([]):(queryInfo=this.getQueryInfo(!1),apiClient=getApiClient(this),methodName=this.getPrefixesApiClientMethodName(),(sortBy=(query=queryInfo.query).SortBy||"").startsWith("AlbumArtist")?(methodName="getArtistPrefixes",query.ArtistType="AlbumArtist"):sortBy.startsWith("Artist")&&(methodName="getArtistPrefixes",query.ArtistType="Artist"),query.SortBy=null,query.StartIndex=null,query.Limit=null,query.Fields=null,query.EnableImageTypes=null,query.ImageTypeLimit=null,query.NameStartsWithOrGreater=null,query.ArtistStartsWithOrGreater=null,query.AlbumArtistStartsWithOrGreater=null,query.IncludeItemTypes=this.getPrefixQueryIncludeItemTypes().join(",")||null,("User"===this.getDisplayPreset()?apiClient.getUserPrefixes(queryInfo.query):"getLiveTvChannelTagPrefixes"===methodName?apiClient[methodName](query):apiClient[methodName](apiClient.getCurrentUserId(),query)).then(function(result){return result.map(mapPrefix)}))},ListController.prototype.getCommandOptions=function(item){var _this$itemsContainer;return(null==(_this$itemsContainer=this.itemsContainer)?void 0:_this$itemsContainer.getCommandOptions(item))||{}},ListController.prototype.getDataGridOptions=function(items,availableFields){items=Object.assign(this.getBaseListRendererOptions(items),{columns:availableFields});return _layoutmanager.default.tv||(items.action="none"),items.sortValues=this.getSortValues(),items},ListController.prototype.getAvailableViewOptions=function(){var list=[];return list.push("primary"),list.push("banner"),list.push("disc"),list.push("logo"),list.push("thumb"),list.push("list"),list.push("datagrid"),list.filter(this.supportsViewType.bind(this))},ListController.prototype.supportsViewType=function(viewType){return"datagrid"!==viewType||"TvChannel"!==(this.getDisplayPreset()||"")},ListController.prototype.getCardOptions=function(items,settings){var shape,preferThumb,preferDisc,preferLogo,defaultShape,params=this.params,itemType=this.getDisplayPreset()||"";if("banner"===settings.imageType)shape="banner";else if("disc"===settings.imageType)shape="square",preferDisc=!0;else if("logo"===settings.imageType)shape="backdrop",preferLogo=!0;else if("thumb"===settings.imageType)shape="backdrop",preferThumb=!0;else switch(itemType){case"Program":case"TvChannel":preferThumb=shape="auto",defaultShape="true"===params.IsMovie||"OnNow"===params.type?"portrait":"backdrop";break;default:"nextup"===params.type?(shape="backdrop",preferThumb="thumb"===settings.imageType):shape="auto"}var options=Object.assign(this.getBaseListRendererOptions(items),{shape:shape,preferThumb:preferThumb,preferDisc:preferDisc,preferLogo:preferLogo,fields:settings.fields,parentId:this.isGlobalQuery()?null:this.params.parentId,cardSize:this.getViewSettings().cardSize,defaultShape:defaultShape});switch(modifyFieldsInListOptions(this,0,options,settings),adjustListOptionsForGroupingProgramsBySeries(this,items,options),itemType){case"TvChannel":options.preferThumb||(options.preferThumb="auto"),options.defaultBackground=!0,options.showCurrentProgramImage||(options.paddedImage=!0);break;case"Audio":options.sideFooter=!0;break;case"SeriesTimer":settings.fields.includes("Name")&&(options.fields.push("SeriesTimerChannel"),options.fields.push("SeriesTimerTime")),options.preferThumb||(options.preferThumb="auto")}return"MusicArtist"===itemType&&(options.round=!0),options.overlayText=0===options.fields.length||"None"===options.fields[0],options.context=this.getContext(),options.typeIndicator="folders"===options.context,"x"===this.scrollDirection()&&(options.centerText=!1,options.horizontalGrid=!0,options.fields=[]),options},ListController.prototype.getListViewOptions=function(items,settings){var options=this.getBaseListRendererOptions(items),itemType=(options.fields=settings.fields||[],this.getDisplayPreset()||"");switch(modifyFieldsInListOptions(this,0,options,settings),adjustListOptionsForGroupingProgramsBySeries(this,items,options),itemType){case"":case"SyncJob":case"Playlist":options.imageSize="small";break;case"Audio":case"Log":options.imageSize="smaller";break;case"BoxSet":case"MusicAlbum":case"Trailer":case"Movie":case"Program":case"TvChannel":case"Genre":case"MusicGenre":case"GameGenre":case"Tag":case"Studio":case"MusicArtist":case"Person":case"Video":case"Episode":case"Series":case"Photo":case"PhotoAlbum":case"Game":case"GameSystem":options.imageSize="medium";break;default:options.imageSize="smallest"}return options},ListController.prototype.getBaseListRendererOptions=function(items,settings){var multiSelect,draggable=!0,itemType=this.getDisplayPreset()||"";switch(itemType){case"Program":draggable=multiSelect=!1;break;case"TvChannel":multiSelect=!1;break;default:multiSelect=!0}switch(itemType){case"Photo":case"Audio":playAction=action="playallfromhere";break;default:var isAllAudioOrPhoto=function(items){var i,length,matches=0;for(i=0,length=items.length;i<length;i++){var item=items[i];if(item){if(item.IsFolder||"Audio"!==item.MediaType&&"Photo"!==item.MediaType)return!1;matches++}}return 0<matches}(items),action=isAllAudioOrPhoto?"playallfromhere":null,playAction=isAllAudioOrPhoto?"playallfromhere":null}return"search"===this.params.type&&(playAction=null,"playallfromhere"===action)&&(action="play"),{context:this.getContext(),draggable:draggable,multiSelect:multiSelect,playAction:playAction,action:action}},ListController.prototype.getListOptions=function(items){var settings=this.getViewSettings(items);return"datagrid"===settings.imageType?{renderer:dataGrid,options:this.getDataGridOptions(items,function(availableFields,enabledFieldIds){for(var list=[],i=0,length=availableFields.length;i<length;i++){var field=availableFields[i];enabledFieldIds.includes(field.id)&&list.push(field)}return list}(this.getAvailableFields(),settings.fields)),virtualScrollLayout:"vertical",commandOptions:this.getCommandOptions()}:"list"===settings.imageType?{renderer:_listview.default,options:this.getListViewOptions(items,settings),virtualScrollLayout:"vertical",commandOptions:this.getCommandOptions()}:{renderer:_cardbuilder.default,options:this.getCardOptions(items,settings),virtualScrollLayout:this.getCardVirtualScrollLayout(),commandOptions:this.getCommandOptions()}},ListController.prototype.getCardVirtualScrollLayout=function(){return"x"===this.scrollDirection()?"horizontal-grid":"vertical-grid"},ListController.prototype.getAvailableField=function(id){return this.getAvailableFields()[id]},ListController.prototype.getAvailableFields=function(){var fields=this._availableFields;if(!fields){for(var fieldList=this.getAvailableFieldsInternal(),i=0,length=fieldList.length;i<length;i++){var field=fieldList[i];fieldList[field.id]=field}this._availableFields=fields=fieldList}return fields},ListController.prototype.getAvailableFieldsInternal=function(){var params=this.params;if("downloads"===params.parentId)return[];if("search"===params.type)return[];var fields=_itemmanager.default.getAvailableFields({itemType:this.getDisplayPreset(),apiClient:getApiClient(this),parentItem:this.getParentItem()});if("missingepisodes"===params.type)for(var i=0,length=fields.length;i<length;i++)fields[i].sortBy=null;return fields},ListController.prototype.getVisibleViewSettings=function(){var params=this.params;if("downloads"===params.parentId)return[];if("search"===params.type)return[];var settings=[],params=this.getDisplayPreset()||"";switch(params){case"Photo":case"Server":break;default:settings.push("imageType")}switch(params){case"":case"Audio":case"MusicAlbum":case"Game":case"Movie":case"MusicVideo":case"Video":case"Trailer":case"Episode":case"Series":settings.push("groupItemsIntoCollections")}return"TvChannel"===params&&settings.push("groupItemsIntoTags"),settings},ListController.prototype.showColumnSelector=function(originalEvent){var availableFields=this.getAvailableFields().filter(function(a){return!a.viewTypes||(a.viewTypes||"").includes("datagrid")}),instance=this;showActionSheet({items:availableFields,positionTo:originalEvent.target,positionX:"after",positionY:"bottom",positionClientY:originalEvent.clientY,positionClientX:originalEvent.clientX,offsetTop:2,hasItemSelectionState:!1,multiple:!0,emptyValueSetEqualsAll:!0,selectedValues:instance.getViewSettings([]).fields,onChange:function(fields){_usersettings.default.set(instance.getSettingsKey()+"-fields",fields.join(","),!1),refreshAfterSettingsChange(instance)}})},ListController.prototype.getViewSettingDefaults=function(parentItem,listItems,availableFields){var defaults={};return defaults.fields=availableFields.filter(function(a){return"*"===a.defaultVisible||(a.defaultVisible||"").includes("cards")}).map(function(a){return a.id}),this.params.defaultView?defaults.imageType=this.params.defaultView:"folders"===this.getContext()&&(defaults.imageType=detectDefaultViewType(this,0,listItems)),defaults.imageType||(availableFields=this.getDisplayPreset()||"",defaults.imageType="Audio"===availableFields?"list":"primary"),defaults},ListController.prototype.getViewSettings=function(items){items=items||this.itemsContainer.getItems();var basekey=this.getSettingsKey(),availableFieldIds=getAvailableFieldIdMap(this),availableFields=this.getAvailableFields(),item=this.getParentItem(),item=this.getViewSettingDefaults(item,items,availableFields),items=_usersettings.default.get(basekey+"-imageType",!1)||item.imageType,cardSize=_usersettings.default.get(basekey+"-cardSize",!1)||"default",userConfiguredFields=_usersettings.default.get(basekey+"-fields",!1),availableFieldIds=(userConfiguredFields=(userConfiguredFields="None"!==userConfiguredFields||"datagrid"!==items&&"list"!==items?userConfiguredFields:null)&&function(availableFieldIds,userConfiguredFields){for(var list=[],i=0,length=userConfiguredFields.length;i<length;i++)availableFieldIds[userConfiguredFields[i]]&&list.push(userConfiguredFields[i]);return list}(availableFieldIds,userConfiguredFields=userConfiguredFields.split(",")),item.fields.slice(0)),item=availableFields.filter(function(a){return"*"===a.defaultVisible||(a.defaultVisible||"").includes("datagrid")}).map(function(a){return a.id});return{fields:userConfiguredFields=userConfiguredFields&&(userConfiguredFields.length||"datagrid"!==items)?userConfiguredFields:("datagrid"===items?item:availableFieldIds).slice(0),groupItemsIntoTags:"true"===_usersettings.default.get(basekey+"-groupItemsIntoTags",!0),groupItemsIntoCollections:"true"===_usersettings.default.get(basekey+"-groupItemsIntoCollections",!0),imageType:items,cardSize:cardSize,defaultFields:availableFieldIds,tableDefaultFields:item}},ListController.prototype.autoFocus=function(options){options=Object.assign({skipIfNotEnabled:!0},options);var view,elem=_focusmanager.default.autoFocus(this.itemsContainer,options);return elem||(options.skipIfNotEnabled&&!_focusmanager.default.isAutoFocusEnabled()?null:(view=this.view)&&(elem=_focusmanager.default.autoFocus(view,options))?elem:(elem=_maintabsmanager.default.focus())||null)},ListController.prototype.getParentItem=function(){var _this$options;return this.currentItem||(null==(_this$options=this.options)?void 0:_this$options.item)},ListController.prototype.play=function(){var instance=this;return loadMultiSelect().then(function(MultiSelect){if(null==MultiSelect||!MultiSelect.canPlay()){var parentItem=instance.getParentItem(),params=instance.params;if(parentItem&&!instance.getQueryInfo(!0).hasFilters&&!params.type&&!_connectionmanager.default.getApiClient(parentItem).isMinServerVersion("4.8.0.30"))if("SortName"===instance.getSortValues().sortBy)return _playbackmanager.default.play({items:[parentItem],parentId:params.parentId,autoplay:!0});return instance.getItems({Limit:300,Recursive:!0,IsFolder:!1,ProjectToMedia:!0}).then(function(result){_playbackmanager.default.play({items:result.Items,autoplay:!0})})}MultiSelect.play()})},ListController.prototype.shuffle=function(){var instance=this;return loadMultiSelect().then(function(MultiSelect){if(null!=MultiSelect&&MultiSelect.canPlay())MultiSelect.shuffle();else{var MultiSelect=instance.getParentItem(),params=instance.params;if(!MultiSelect||instance.getQueryInfo(!0).hasFilters||_connectionmanager.default.getApiClient(MultiSelect).isMinServerVersion("4.8.0.30"))return instance.getItems({Limit:300,Recursive:!0,IsFolder:!1,ProjectToMedia:!0,SortBy:"Random"}).then(function(result){_playbackmanager.default.play({items:result.Items,autoplay:!0})});_playbackmanager.default.shuffle(MultiSelect,null,{parentId:params.parentId,autoplay:!0})}})},ListController.prototype.queue=function(){this.getItems({Limit:300,Recursive:!0,ProjectToMedia:!0,IsFolder:!1}).then(function(result){_playbackmanager.default.queue({items:result.Items})})},ListController.prototype.isGlobalQuery=function(){return!1},ListController.prototype.virtualChunkSize=function(){return null},ListController.prototype.enableVirtualData=function(){return this.itemsContainer.hasAttribute("data-virtualscrolllayout")},ListController.prototype.getItemCountText=function(numItems){return 1===numItems?_globalize.default.translate("ValueOneItem"):_globalize.default.translate("ItemCount",numItems)},ListController.prototype.getPrefixesApiClientMethodName=function(){return"getPrefixes"},ListController.prototype.getApiClientQueryMethodName=function(){return"getItems"},ListController.prototype.getPrefixQueryIncludeItemTypes=function(){return this.getQueryIncludeItemTypes()},ListController.prototype.getQueryIncludeItemTypes=function(){return this.getItemTypes()},ListController.prototype.getContext=function(){switch(getBaseDisplayPreset(this)||""){case"Program":case"TvChannel":case"Timer":case"SeriesTimer":case"Recording":return"livetv";case"Series":case"Episode":return"tvshows"}var parentItem=this.getParentItem();return null==parentItem?void 0:parentItem.CollectionType},ListController.prototype.getSortBySettingsKey=function(sortMenuOptions){return this.getSettingsKey()+"-sortby"},ListController.prototype.getSortByValue=function(){var saveSortingOnServer=this.saveSortingOnServer();return _usersettings.default.getFilter(this.getSortBySettingsKey(),saveSortingOnServer)},ListController.prototype.getVisibleFilters=function(){var list=[],fieldIds=getAvailableFieldIdMap(this),itemType=this.getDisplayPreset();if(fieldIds.Played)switch(list.push("IsUnplayed"),list.push("IsPlayed"),itemType){case"":case"Movie":case"Episode":case"Trailer":case"Audio":case"MusicVideo":case"Video":list.push("IsResumable")}switch(fieldIds.IsFavorite&&list.push("IsFavorite"),itemType){case"Movie":case"Episode":case"Trailer":case"MusicVideo":case"Video":list.push("AudioCodecs"),list.push("AudioLayouts"),list.push("VideoCodecs"),list.push("ExtendedVideoTypes"),list.push("SubtitleCodecs"),list.push("HasSubtitles"),list.push("VideoType")}switch("Audio"===itemType&&list.push("HasLyrics"),itemType){case"Movie":case"Series":case"Season":case"Episode":case"MusicVideo":case"Video":case"Trailer":case"Person":list.push("HasTmdbId")}switch(itemType){case"Movie":case"Series":case"Season":case"Episode":case"MusicVideo":case"Video":case"Trailer":case"BoxSet":case"Person":list.push("HasImdbId")}switch(itemType){case"Movie":case"Series":case"Season":case"Episode":case"MusicVideo":case"Video":case"Trailer":list.push("HasTvdbId")}switch(itemType){case"Movie":case"Series":case"Season":case"Episode":case"BoxSet":case"MusicVideo":case"Video":case"Game":list.push("HasTrailer"),list.push("HasSpecialFeature"),list.push("HasThemeSong"),list.push("HasThemeVideo")}switch(fieldIds.Video3DFormat&&list.push("Is3D"),fieldIds.Resolution&&list.push("Resolution"),fieldIds.Container&&list.push("Containers"),fieldIds.ProductionYear&&list.push("Years"),fieldIds.Genres&&list.push("Genres"),fieldIds.Studios&&list.push("Studios"),fieldIds.Tags&&list.push("Tags"),fieldIds.OfficialRating&&list.push("OfficialRatings"),itemType){case"Movie":case"Series":case"Season":case"Episode":case"BoxSet":case"Trailer":case"Audio":case"MusicAlbum":case"MusicArtist":case"Playlist":case"Video":case"Game":case"Book":case"Person":case"GameSystem":case"Photo":case"TvChannel":list.push("HasOverview"),list.push("IsLocked")}return"Series"===itemType&&list.push("SeriesStatus"),list},ListController.prototype.getDefaultSorting=function(){var _this$getParentItem;if("folders"===this.getContext())switch(null==(_this$getParentItem=this.getParentItem())?void 0:_this$getParentItem.Type){case"CollectionFolder":case"Folder":var field=this.getDefaultSortingForField("Filename");if(field)return field}return _itemmanager.default.getDefaultSorting({itemType:this.getDisplayPreset(),apiClient:getApiClient(this)})},ListController.prototype.getFilterMenuOptions=function(){var params=this.params,query={Recursive:this.getQueryInfo(!1).Recursive};return params.IsAiring&&(query.IsAiring="true"===params.IsAiring),params.IsMovie&&(query.IsMovie="true"===params.IsMovie),params.IsKids&&(query.IsKids="true"===params.IsKids),params.IsNews&&(query.IsNews="true"===params.IsNews),params.IsSeries&&(query.IsSeries="true"===params.IsSeries),params.IsSports&&(query.IsSports="true"===params.IsSports),query},ListController.prototype.getItemTypes=function(){return[]},ListController.prototype.supportsPlay=function(){switch(this.getDisplayPreset()||""){case"":case"Movie":case"Episode":case"Trailer":case"Audio":case"MusicAlbum":case"MusicArtist":case"MusicVideo":case"Video":case"Photo":return!0;default:return!1}},ListController.prototype.supportsShuffle=function(){return this.supportsPlay()},ListController.prototype.supportsQueue=function(){return this.supportsPlay()},ListController.prototype.supportsAlphaPicker=function(){switch(this.getDisplayPreset()){case"Episode":return"missingepisodes"===this.params.type?!1:!0;case"Movie":case"Series":case"Trailer":case"Audio":case"MusicAlbum":case"MusicArtist":case"MusicVideo":case"Video":case"Genre":case"MusicGenre":case"GameGenre":return!0}var item=this.getParentItem();if(item)switch(item.Type){case"PhotoAlbum":case"Log":return!1;default:return!0}return!1},ListController.prototype.enableAlphaPicker=function(sortBy,sortOrder){return!(!this.supportsAlphaPicker()||"x"===this.scrollDirection()||"search"===this.params.type||"SortName"!==(sortBy=sortBy||"")&&!sortBy.startsWith("AlbumArtist")&&!sortBy.startsWith("Artist"))},ListController.prototype.getInlinePaddingElement=function(){return this.itemsContainer.closest(".padded-left")},ListController.prototype.initAlphaPicker=function(){var alphaPickerElement,paddingElement;!this.alphaPicker&&(this.alphaPickerElement=this.view.querySelector(".alphaPicker"),alphaPickerElement=this.alphaPickerElement)&&(paddingElement=this.getInlinePaddingElement(),_layoutmanager.default.tv?(alphaPickerElement.classList.add("alphaPicker-fixed-left"),alphaPickerElement.classList.remove("alphaPicker-fixed-right"),paddingElement&&(paddingElement.classList.add("padded-left-withalphapicker"),paddingElement.classList.remove("padded-right-withalphapicker"))):(alphaPickerElement.classList.add("alphaPicker-fixed-right"),alphaPickerElement.classList.remove("alphaPicker-fixed-left"),paddingElement&&(paddingElement.classList.remove("padded-left-withalphapicker"),paddingElement.classList.add("padded-right-withalphapicker"))),this.alphaPicker=new _alphapicker.default({element:alphaPickerElement,itemsContainer:this.itemsContainer,prefixes:[],setValueOnFocus:!0}),this.alphaPicker.on("alphavaluechanged",function(e){e=e.detail.value,trySelectValue(this,this.scroller,this.itemsContainer,e,!!_layoutmanager.default.tv)}.bind(this)))},ListController.prototype.getBaseQuery=function(item){var params=this.params,parentId=params.parentId,sortValues=this.getSortValues(),fields=this.getRequestedItemFields(),settings=this.getViewSettings(),visibleFields=("primary"!==settings.imageType&&"list"!==settings.imageType&&"datagrid"!==settings.imageType||(fields+=",PrimaryImageAspectRatio","OnNow"===params.type&&(fields+=",ProgramPrimaryImageAspectRatio")),settings.fields),visibleFields=(!visibleFields.includes("ProductionYear")&&"list"!==settings.imageType||(fields+=",ProductionYear,Status,EndDate"),!visibleFields.includes("CommunityRating")&&"list"!==settings.imageType||(fields+=",CommunityRating"),!visibleFields.includes("OfficialRating")&&"list"!==settings.imageType||(fields+=",OfficialRating"),!visibleFields.includes("CriticRating")&&"list"!==settings.imageType||(fields+=",CriticRating"),visibleFields.includes("PremiereDate")&&(fields+=",PremiereDate"),visibleFields.includes("StartDate")&&(fields+=",StartDate"),visibleFields.includes("DateCreated")&&(fields+=",DateCreated"),visibleFields.includes("Resolution")&&(fields+=",Width,Height"),visibleFields.includes("Bitrate")&&(fields+=",Bitrate"),visibleFields.includes("Size")&&(fields+=",Size"),visibleFields.includes("Container")&&(fields+=",Container"),visibleFields.includes("Video3DFormat")&&(fields+=",Video3DFormat"),visibleFields.includes("Genres")&&(fields+=",Genres"),visibleFields.includes("Studios")&&(fields+=",Studios"),visibleFields.includes("Tags")&&(fields+=",Tags"),visibleFields.includes("Filename")&&(fields+=",Filename"),visibleFields.includes("Path")&&(fields+=",Path"),visibleFields.includes("Overview")&&(fields+=",Overview"),visibleFields.includes("OriginalTitle")&&(fields+=",OriginalTitle"),visibleFields.includes("SortName")&&(fields+=",SortName"),visibleFields.includes("PlayCount")&&(fields+=",UserDataPlayCount"),visibleFields.includes("DatePlayed")&&(fields+=",UserDataLastPlayedDate"),visibleFields.includes("Tagline")&&(fields+=",Taglines"),this.enableAlphaPicker(sortValues.sortBy,sortValues.sortOrder)&&_layoutmanager.default.tv&&(fields+=",Prefix"),this.getRequestedImageTypes()),fields=("banner"===settings.imageType?visibleFields+=",Banner":"disc"===settings.imageType?visibleFields+=",Disc":"logo"===settings.imageType&&(visibleFields+=",Logo"),{IncludeItemTypes:this.getQueryIncludeItemTypes().join(",")||null,Fields:fields,StartIndex:0});return this.addSortingToQuery(sortValues,fields),params.mediaTypes&&(fields.MediaTypes=params.mediaTypes),parentId&&!this.isGlobalQuery()&&(fields.ParentId=parentId),"datagrid"!==settings.imageType&&(fields.EnableImageTypes=visibleFields,fields.ImageTypeLimit=1),"OnNow"===params.type&&(fields.EnableUserData=!1),"Program"===params.type&&(fields.HasAired=!1),"true"===params.IsFavorite&&(fields.IsFavorite=!0),"true"===params.IsMovie?fields.IsMovie=!0:"false"===params.IsMovie&&(fields.IsMovie=!1),"true"===params.IsSeries?fields.IsSeries=!0:"false"===params.IsSeries&&(fields.IsSeries=!1),"true"===params.IsNewOrPremiere?fields.IsNewOrPremiere=!0:"false"===params.IsNewOrPremiere&&(fields.IsNewOrPremiere=!1),"true"===params.IsNews?fields.IsNews=!0:"false"===params.IsNews&&(fields.IsNews=!1),"true"===params.IsSports?fields.IsSports=!0:"false"===params.IsSports&&(fields.IsSports=!1),"true"===params.IsKids?fields.IsKids=!0:"false"===params.IsKids&&(fields.IsKids=!1),"OnNow"===params.type||"true"===params.IsAiring?fields.IsAiring=!0:"false"===params.IsAiring&&(fields.IsAiring=!1),params.genreId&&(fields.GenreIds=params.genreId),item&&("Studio"===item.Type?(fields.StudioIds=item.Id,fields.Recursive=!0):"Tag"===item.Type?(fields.TagIds=item.Id,fields.Recursive=!0):"Genre"===item.Type||"GameGenre"===item.Type||"MusicGenre"===item.Type?(fields.GenreIds=item.Id,fields.Recursive=!0):"Person"===item.Type&&(fields.PersonIds=item.Id,fields.Recursive=!0)),params.artistId&&(fields.ArtistIds=params.artistId),params.albumArtistId&&(fields.AlbumArtistIds=params.albumArtistId),this.isRecursiveQuery()&&(fields.Recursive=!0),params.mediaTypes&&(fields.IsFolder=!1,fields.IsVirtualItem=!1,fields.ExcludeItemTypes="Program"),fields},ListController.prototype.addSortingToQuery=function(sortValues,query){var sortMenuOption,sortOrder=sortValues.sortOrder;sortValues.sortBy&&sortOrder&&(sortMenuOption=function(sortMenuOptions,sortBy){for(var i=0,length=sortMenuOptions.length;i<length;i++){var option=sortMenuOptions[i];if(option.value===sortBy)return option}return null}(this.getSortMenuOptions(),sortValues.sortBy))&&sortMenuOption["sortOrder"+sortOrder]&&(sortOrder=sortMenuOption["sortOrder"+sortOrder]),query.SortBy=sortValues.sortBy,query.SortOrder=sortOrder},ListController.prototype.isRecursiveQuery=function(){var params=this.params;return params.type||params.mediaTypes||this.isGlobalQuery()},ListController.prototype.getQueryInfo=function(enableFilters){var hasFilters,_this$options2,query=this.getBaseQuery(this.getParentItem()),queryFilters=[],enableFilters=("favorites"===(null==(_this$options2=this.options)?void 0:_this$options2.mode)&&queryFilters.push("IsFavorite"),!1!==enableFilters&&((_this$options2=this.getFilters()).SeriesStatus&&(query.SeriesStatus=_this$options2.SeriesStatus,hasFilters=!0),_this$options2.IsPlayed&&(queryFilters.push("IsPlayed"),hasFilters=!0),_this$options2.IsUnplayed&&(queryFilters.push("IsUnplayed"),hasFilters=!0),_this$options2.IsFavorite&&(queryFilters.push("IsFavorite"),hasFilters=!0),_this$options2.IsResumable&&(queryFilters.push("IsResumable"),hasFilters=!0),_this$options2.Containers&&(hasFilters=!0,query.Containers=_this$options2.Containers),_this$options2.AudioCodecs&&(hasFilters=!0,query.AudioCodecs=_this$options2.AudioCodecs),_this$options2.AudioLayouts&&(hasFilters=!0,query.AudioLayouts=_this$options2.AudioLayouts),_this$options2.AudioLanguages&&(hasFilters=!0,query.AudioLanguages=_this$options2.AudioLanguages),_this$options2.VideoCodecs&&(hasFilters=!0,query.VideoCodecs=_this$options2.VideoCodecs),_this$options2.ExtendedVideoTypes&&(hasFilters=!0,query.ExtendedVideoTypes=_this$options2.ExtendedVideoTypes),_this$options2.SubtitleCodecs&&(hasFilters=!0,query.SubtitleCodecs=_this$options2.SubtitleCodecs),_this$options2.SubtitleLanguages&&(hasFilters=!0,query.SubtitleLanguages=_this$options2.SubtitleLanguages),_this$options2.GenreIds&&(hasFilters=!0,query.GenreIds=_this$options2.GenreIds),_this$options2.OfficialRatings&&(hasFilters=!0,query.OfficialRatings=_this$options2.OfficialRatings),_this$options2.StudioIds&&(hasFilters=!0,query.StudioIds=_this$options2.StudioIds),_this$options2.TagIds&&(hasFilters=!0,query.TagIds=_this$options2.TagIds),_this$options2.Years&&(hasFilters=!0,query.Years=_this$options2.Years),_this$options2.Is3D&&(hasFilters=query.Is3D=!0),_this$options2.Resolution&&(this.setResolutionIntoQuery(query,_this$options2.Resolution),hasFilters=!0),null!=_this$options2.HasSubtitles&&(query.HasSubtitles=_this$options2.HasSubtitles,hasFilters=!0),null!=_this$options2.HasLyrics&&(query.HasSubtitles=_this$options2.HasLyrics,hasFilters=!0),null!=_this$options2.ChannelMappingStatus&&(query.ChannelMappingStatus=_this$options2.ChannelMappingStatus,hasFilters=!0),null!=_this$options2.HasTrailer&&(query.HasTrailer=_this$options2.HasTrailer,hasFilters=!0),null!=_this$options2.HasSpecialFeature&&(query.HasSpecialFeature=_this$options2.HasSpecialFeature,hasFilters=!0),null!=_this$options2.HasThemeSong&&(query.HasThemeSong=_this$options2.HasThemeSong,hasFilters=!0),null!=_this$options2.HasThemeVideo&&(query.HasThemeVideo=_this$options2.HasThemeVideo,hasFilters=!0),null!=_this$options2.HasOverview&&(query.HasOverview=_this$options2.HasOverview,hasFilters=!0),null!=_this$options2.HasImdbId&&(query.HasImdbId=_this$options2.HasImdbId,hasFilters=!0),null!=_this$options2.HasTvdbId&&(query.HasTvdbId=_this$options2.HasTvdbId,hasFilters=!0),null!=_this$options2.HasTmdbId&&(query.HasTmdbId=_this$options2.HasTmdbId,hasFilters=!0),null!=_this$options2.IsLocked)&&(query.IsLocked=_this$options2.IsLocked,hasFilters=!0),query.Filters=queryFilters.length?queryFilters.join(","):null,this.getViewSettings());return enableFilters.groupItemsIntoCollections?query.GroupItemsIntoCollections=!0:enableFilters.groupItemsIntoTags&&(query.GroupItemsInto="Tags"),"search"===this.params.type&&(query.SearchTerm=this.lastSearchTerm=this.searchFields.getSearchTerm(),_this$options2=this.view.querySelector(".emby-searchable-tab-button.emby-tab-button-active"))&&(queryFilters=_this$options2.getAttribute("data-searchtype"),query.IncludeItemTypes="all"!==queryFilters?queryFilters:null),("Program"!==query.IncludeItemTypes||query.IsAiring||query.IsSports)&&(query.IncludeItemTypes||"search"!==this.params.type)||(query.GroupProgramsBySeries=!0),(this.getSortValues().sortBy||"").startsWith("Random")&&(query.RandomSeed=this.getRandomSeed()),{query:query,hasFilters:hasFilters}},ListController.prototype.getItems=function(initialQuery,signal){var apiClient=getApiClient(this),queryInfo=this.getQueryInfo(!0);switch(this.setFilterStatus(queryInfo.hasFilters),initialQuery&&(queryInfo.query=Object.assign(queryInfo.query,initialQuery)),this.getDisplayPreset()){case"User":return delete queryInfo.query.Fields,apiClient.getUsersQueryResult(queryInfo.query);case"Device":return delete queryInfo.query.Fields,apiClient.getDevices(queryInfo.query)}initialQuery=this.getApiClientQueryMethodName();return"getActivityLog"===initialQuery?(queryInfo.query.HasUserId=!1,apiClient.getActivityLog(queryInfo.query)):"getUserActivityLog"===initialQuery?(queryInfo.query.HasUserId=!0,apiClient.getActivityLog(queryInfo.query)):"getLogs"===initialQuery||"getLogLines"===initialQuery||"getApiKeys"===initialQuery||"getLiveTvChannelsForManagement"===initialQuery?apiClient[initialQuery](queryInfo.query):"getNextUpEpisodes"===initialQuery?(queryInfo.query.UserId=apiClient.getCurrentUserId(),queryInfo.query.EnableTotalRecordCount=!1,queryInfo.query.LegacyNextUp=!0,apiClient[initialQuery](queryInfo.query,signal)):"getMissingEpisodes"===initialQuery||"getLiveTvChannels"===initialQuery||"getLiveTvRecordings"===initialQuery||"getLiveTvChannelTags"===initialQuery?(queryInfo.query.UserId=apiClient.getCurrentUserId(),apiClient[initialQuery](queryInfo.query,signal)):"search"===this.params.type?(this.view.querySelector(".emby-searchable-tab-button.emby-tab-button-active")&&(queryInfo.query.IncludeSearchTypes=!1),apiClient.getSearchResults(queryInfo.query).then(function(result){return result.ItemTypes&&this.refreshSearchTabs(result.ItemTypes),result}.bind(this))):"getItems"===initialQuery?apiClient[initialQuery](apiClient.getCurrentUserId(),queryInfo.query,signal):apiClient[initialQuery](apiClient.getCurrentUserId(),queryInfo.query)},ListController.prototype.onRefreshing=function(result){var values,alphaPicker,listOptions=this.itemsContainer.currentListOptions,listOptions=(listOptions.renderer.renderHeader?listOptions.renderer.renderHeader(this,ensureHeader(this),listOptions.options):destroyHeader(this),this.getViewSettings()),items=(_cardbuilder.default.setUserPreferredSize(this.itemsContainer,listOptions.cardSize),this.configureScrollingForView(),result.Items||result),result=result.TotalRecordCount||items.length,items=(this.fillDisplayTotalRecordCount(result),items=result,values=(instance=this).getSortValues(),(values=instance.enableAlphaPicker(values.sortBy,values.sortOrder))?instance.initAlphaNumericShortcuts():instance.destroyAlphaNumericShortcuts(),instance.alphaPicker&&(alphaPicker=instance.alphaPickerElement)&&(values&&30<items?(alphaPicker.classList.remove("hide"),instance.refreshPrefixes()):(alphaPicker.classList.add("hide"),(values=instance.getInlinePaddingElement())&&values.classList.remove("padded-left-withalphapicker","padded-right-withalphapicker"))),this.getInlinePaddingElement()),instance=(items&&("datagrid"===(alphaPicker=listOptions.imageType)||"list"===alphaPicker?_layoutmanager.default.tv?items.classList.add("padded-left-withlist","padded-right-withlist","padded-left-withlist-tv","padded-right-withlist-tv"):(items.classList.add("padded-left-withlist","padded-right-withlist"),items.classList.remove("padded-left-withlist-tv","padded-right-withlist-tv")):items.classList.remove("padded-left-withlist","padded-right-withlist","padded-left-withlist-tv","padded-right-withlist-tv")),this.itemsViewSettingsContainer||this.view);hideOrShowAll(instance.querySelectorAll(".btnPlay"),!(result&&this.supportsPlay())),hideOrShowAll(instance.querySelectorAll(".btnShuffle"),!(result&&this.supportsShuffle())),hideOrShowAll(instance.querySelectorAll(".btnQueue"),!(result&&this.supportsQueue()))},ListController.prototype.afterItemsRefreshed=function(result){var items=result.Items||result;result.TotalRecordCount||items.length||this.setEmptyListState(),_loading.default.hide()},ListController.prototype.onGetItems=function(){_loading.default.show()},ListController.prototype.onGetItemsFailed=function(result){_loading.default.hide()},ListController.prototype.configureScrollingForView=function(){var scrollSliderY,itemsContainer=this.itemsContainer,headerElement=this._headerElement,currentListOptions=itemsContainer.currentListOptions,hasFixedPositionListHeader=null!=headerElement&&(null==currentListOptions?void 0:currentListOptions.options.enableFixedPositionHeader)&&supportsCssVariables&&supportsCalcMin,itemsViewSettingsContainer=this.itemsViewSettingsContainer,itemsViewSettingsContainer=(itemsViewSettingsContainer&&(null!=headerElement&&hasFixedPositionListHeader?itemsViewSettingsContainer.classList.add("itemsViewSettingsContainer-fixed","viewContent-fixed"):itemsViewSettingsContainer.classList.remove("itemsViewSettingsContainer-fixed","viewContent-fixed")),headerElement&&(hasFixedPositionListHeader?headerElement.classList.add("itemsContainer_header_fixed","viewContent-fixed"):headerElement.classList.remove("itemsContainer_header_fixed","viewContent-fixed")),this.scroller);itemsViewSettingsContainer&&(itemsViewSettingsContainer.setHeaderBindingEnabled(!hasFixedPositionListHeader),headerElement=(headerElement=this.paddedTopPageElem)||(this.paddedTopPageElem=itemsContainer.closest(".padded-top-page")),scrollSliderY=itemsViewSettingsContainer.querySelector(".scrollSliderY"),hasFixedPositionListHeader?(itemsViewSettingsContainer.classList.add("margin-top-page","margin-top-page-listheader","dataGrid-mainscroller-scrollX"),scrollSliderY&&scrollSliderY.classList.add("dataGrid-mainscroller-scrollX-scrollSliderY"),headerElement&&headerElement!==itemsViewSettingsContainer&&headerElement.classList.remove("padded-top-page"),this.boundOnScroll||(this.boundOnScroll=function(e){var headerElement,scroller=this.scroller;scroller&&(headerElement=this._headerElement)&&(headerElement.scrollLeft=scroller.scrollLeft)}.bind(this)),itemsViewSettingsContainer.addEventListener("scroll",this.boundOnScroll)):(removeScrollListener(this),itemsViewSettingsContainer.classList.remove("margin-top-page","margin-top-page-listheader","dataGrid-mainscroller-scrollX"),scrollSliderY&&scrollSliderY.classList.remove("dataGrid-mainscroller-scrollX-scrollSliderY"),headerElement&&headerElement!==itemsViewSettingsContainer&&headerElement.classList.add("padded-top-page")),hasFixedPositionListHeader=itemsContainer.closest(".scrollSlider"))&&(scrollSliderY=null==currentListOptions?void 0:currentListOptions.options.scrollXWidth,hasFixedPositionListHeader.style.width=scrollSliderY?scrollSliderY+"ch":null)},ListController.prototype.fillDisplayTotalRecordCount=function(totalRecordCount){var elem=this.view.querySelector(".listTotalRecordCount");elem&&(!1===this.enableTotalRecordCountDisplay?elem.classList.add("hide"):elem.innerHTML=this.getItemCountText(totalRecordCount))},ListController.prototype.getEmptyListMessage=function(){if("search"===this.params.type){if(this.searchFields){var searchTerm=this.lastSearchTerm;if(!searchTerm)return Promise.resolve("");if(searchTerm.length<2)return Promise.resolve(_globalize.default.translate("TwoSearchCharsRequired"))}return Promise.resolve(_globalize.default.translate("NoItemsMatchingFound"))}return this.getQueryInfo(!0).hasFilters?(searchTerm=(searchTerm="<div>"+_globalize.default.translate("NoItemsMatchingFound")+'</div><button style="margin-top:2em;" type="button" is="emby-button" class="raised btnClearFilters"><i class="md-icon button-icon button-icon-left">&#xe0b8;</i>')+"<span>"+_globalize.default.translate("HeaderClearFilters")+"</span></button>",Promise.resolve(searchTerm)):Promise.resolve(_globalize.default.translate("NoItemsFound"))},ListController.prototype.setEmptyListState=function(){this.getEmptyListMessage().then(function(html){html='<div class="flex padded-top align-items-center justify-content-center flex-grow flex-direction-column">'+html,this.itemsContainer.setOtherInnerHTML(html+="</div>"),destroyHeader(this),(html=this.itemsContainer.querySelector(".btnClearFilters"))&&_dom.default.addEventListener(html,"click",this.clearFilters.bind(this),{})}.bind(this))},ListController.prototype.initAlphaNumericShortcuts=function(){var instance;this.enableAlphaNumericShortcuts&&!this.alphaNumericShortcuts&&(instance=this,Emby.importModule("./modules/alphanumericshortcuts/alphanumericshortcuts.js").then(function(AlphaNumericShortcuts){instance.alphaNumericShortcuts=new AlphaNumericShortcuts({itemsContainer:instance.itemsContainer}),instance.alphaNumericShortcuts.onAlphaNumericValueEntered=function(value){trySelectValue(this,this.scroller,this.view,value,!0)}.bind(instance)}))},ListController.prototype.supportsSorting=function(){return 0<this.getSortMenuOptions().length},ListController.prototype.getSortValues=function(){var saveSortingOnServer,basekey=this.getSettingsKey(),sortBy=this.getSortByValue();return sortBy?(saveSortingOnServer=this.saveSortingOnServer(),saveSortingOnServer="Descending"===_usersettings.default.getFilter(basekey+"-sortorder",saveSortingOnServer)?"Descending":"Ascending"):(basekey=this.getDefaultSorting())&&(sortBy=basekey.sortBy,saveSortingOnServer=basekey.sortOrder),{sortBy:sortBy,sortOrder:saveSortingOnServer}},ListController.prototype.updateSortText=function(){var btnSortText=this.btnSortText;if(btnSortText){for(var options=this.getSortMenuOptions(),values=this.getSortValues(),sortBy=values.sortBy,i=0,length=options.length;i<length;i++)if(sortBy===options[i].value){btnSortText.innerHTML=options[i].name;break}var btnSortIcon=this.btnSortIcon;btnSortIcon&&(btnSortIcon.innerHTML="Descending"===values.sortOrder?"&#xe5DB;":"&#xe5D8;")}},ListController.prototype.showFilterMenu=function(e){var instance=this,params=instance.params,query={},item=(params.genreId&&(query.GenreIds=params.genreId),instance.getParentItem());item&&("Studio"===item.Type?query.StudioIds=item.Id:"Tag"===item.Type?query.TagIds=item.Id:"Genre"===item.Type||"GameGenre"===item.Type||"MusicGenre"===item.Type?query.GenreIds=item.Id:"Person"===item.Type&&(query.PersonIds=item.Id)),params.artistId&&(query.ArtistIds=params.artistId),params.albumArtistId&&(query.AlbumArtistIds=params.albumArtistId),Emby.importModule("./modules/filtermenu/filtermenu.js").then(function(FilterMenu){(new FilterMenu).show(Object.assign(query,{positionTo:e.target.closest("button"),positionY:"bottom",settings:instance.getFilters(),visibleSettings:instance.getVisibleFilters(),onChange:function(changes){for(var settingsKey=instance.getSettingsKey(),keys=Object.keys(changes),i=0,length=keys.length;i<length;i++){var key=keys[i];_usersettings.default.setFilter(settingsKey+"-filter-"+key,changes[key])}keys.length&&refreshAfterSettingsChange(instance)},parentId:instance.isGlobalQuery()?null:instance.params.parentId,itemTypes:instance.getItemTypes?instance.getItemTypes():[],serverId:getApiClient(instance).serverId(),filterMenuOptions:instance.getFilterMenuOptions()}))})},ListController.prototype.setFilterStatus=function(hasFilters){var filterButtons=this.filterButtons;if(filterButtons.length)for(var i=0,length=filterButtons.length;i<length;i++){var btnFilter=filterButtons[i];hasFilters?btnFilter.classList.add("filter-active"):btnFilter.classList.remove("filter-active")}},ListController.prototype.setResolutionIntoQuery=function(query,resolution){if(resolution)switch(resolution=resolution.toLowerCase()){case"4k":query.MinWidth=3800;break;case"1080p":query.MinWidth=1800,query.MaxWidth=2200;break;case"720p":query.MinWidth=1200,query.MaxWidth=1799;break;case"hd":query.MinWidth=1200,query.MaxWidth=2200;break;case"sd":query.MaxWidth=1199}},ListController.prototype.getFilters=function(){var basekey=this.getSettingsKey();return{IsPlayed:"true"===_usersettings.default.getFilter(basekey+"-filter-IsPlayed"),IsUnplayed:"true"===_usersettings.default.getFilter(basekey+"-filter-IsUnplayed"),IsFavorite:"true"===_usersettings.default.getFilter(basekey+"-filter-IsFavorite"),IsResumable:"true"===_usersettings.default.getFilter(basekey+"-filter-IsResumable"),Is3D:"true"===_usersettings.default.getFilter(basekey+"-filter-Is3D"),Resolution:_usersettings.default.getFilter(basekey+"-filter-Resolution"),VideoTypes:_usersettings.default.getFilter(basekey+"-filter-VideoTypes"),SeriesStatus:_usersettings.default.getFilter(basekey+"-filter-SeriesStatus"),HasSubtitles:_usersettings.default.getFilter(basekey+"-filter-HasSubtitles"),HasLyrics:_usersettings.default.getFilter(basekey+"-filter-HasLyrics"),ChannelMappingStatus:_usersettings.default.getFilter(basekey+"-filter-ChannelMappingStatus"),HasTrailer:_usersettings.default.getFilter(basekey+"-filter-HasTrailer"),HasSpecialFeature:_usersettings.default.getFilter(basekey+"-filter-HasSpecialFeature"),HasThemeSong:_usersettings.default.getFilter(basekey+"-filter-HasThemeSong"),HasThemeVideo:_usersettings.default.getFilter(basekey+"-filter-HasThemeVideo"),HasOverview:_usersettings.default.getFilter(basekey+"-filter-HasOverview"),HasImdbId:_usersettings.default.getFilter(basekey+"-filter-HasImdbId"),HasTvdbId:_usersettings.default.getFilter(basekey+"-filter-HasTvdbId"),HasTmdbId:_usersettings.default.getFilter(basekey+"-filter-HasTmdbId"),IsLocked:_usersettings.default.getFilter(basekey+"-filter-IsLocked"),GenreIds:_usersettings.default.getFilter(basekey+"-filter-GenreIds"),StudioIds:_usersettings.default.getFilter(basekey+"-filter-StudioIds"),TagIds:_usersettings.default.getFilter(basekey+"-filter-TagIds"),OfficialRatings:_usersettings.default.getFilter(basekey+"-filter-OfficialRatings"),Containers:_usersettings.default.getFilter(basekey+"-filter-Containers"),AudioCodecs:_usersettings.default.getFilter(basekey+"-filter-AudioCodecs"),AudioLayouts:_usersettings.default.getFilter(basekey+"-filter-AudioLayouts"),AudioLanguages:_usersettings.default.getFilter(basekey+"-filter-AudioLanguages"),SubtitleLanguages:_usersettings.default.getFilter(basekey+"-filter-SubtitleLanguages"),VideoCodecs:_usersettings.default.getFilter(basekey+"-filter-VideoCodecs"),ExtendedVideoTypes:_usersettings.default.getFilter(basekey+"-filter-ExtendedVideoTypes"),SubtitleCodecs:_usersettings.default.getFilter(basekey+"-filter-SubtitleCodecs"),Years:_usersettings.default.getFilter(basekey+"-filter-Years")}},ListController.prototype.getSortMenuOptions=function(){return _itemmanager.default.getSortMenuOptions({itemType:this.getDisplayPreset(),availableFieldIds:getAvailableFieldIdMap(this),apiClient:getApiClient(this)})},ListController.prototype.getRandomSeed=function(){return this.randomSeed||this.resetRandomSeed(),this.randomSeed},ListController.prototype.resetRandomSeed=function(){this.randomSeed=Math.floor(1e7*Math.random())+1},ListController.prototype.getDisplayPreset=function(){var itemType=getBaseDisplayPreset(this);if(!itemType)switch(this.getContext()){case"boxsets":return"BoxSet";case"playlists":return"Playlist"}return itemType},ListController.prototype.clearFilters=function(){var basekey=this.getSettingsKey();_usersettings.default.remove(basekey+"-filter-IsPlayed"),_usersettings.default.remove(basekey+"-filter-IsUnplayed"),_usersettings.default.remove(basekey+"-filter-IsFavorite"),_usersettings.default.remove(basekey+"-filter-IsResumable"),_usersettings.default.remove(basekey+"-filter-Is4K"),_usersettings.default.remove(basekey+"-filter-IsHD"),_usersettings.default.remove(basekey+"-filter-IsSD"),_usersettings.default.remove(basekey+"-filter-Is3D"),_usersettings.default.remove(basekey+"-filter-Resolution"),_usersettings.default.remove(basekey+"-filter-SeriesStatus"),_usersettings.default.remove(basekey+"-filter-HasSubtitles"),_usersettings.default.remove(basekey+"-filter-HasLyrics"),_usersettings.default.remove(basekey+"-filter-ChannelMappingStatus"),_usersettings.default.remove(basekey+"-filter-HasTrailer"),_usersettings.default.remove(basekey+"-filter-HasSpecialFeature"),_usersettings.default.remove(basekey+"-filter-HasThemeSong"),_usersettings.default.remove(basekey+"-filter-HasThemeVideo"),_usersettings.default.remove(basekey+"-filter-HasOverview"),_usersettings.default.remove(basekey+"-filter-HasImdbId"),_usersettings.default.remove(basekey+"-filter-HasTvdbId"),_usersettings.default.remove(basekey+"-filter-HasTmdbId"),_usersettings.default.remove(basekey+"-filter-IsLocked"),_usersettings.default.remove(basekey+"-filter-GenreIds"),_usersettings.default.remove(basekey+"-filter-StudioIds"),_usersettings.default.remove(basekey+"-filter-TagIds"),_usersettings.default.remove(basekey+"-filter-OfficialRatings"),_usersettings.default.remove(basekey+"-filter-Containers"),_usersettings.default.remove(basekey+"-filter-AudioCodecs"),_usersettings.default.remove(basekey+"-filter-AudioLayouts"),_usersettings.default.remove(basekey+"-filter-AudioLanguages"),_usersettings.default.remove(basekey+"-filter-SubtitleLanguages"),_usersettings.default.remove(basekey+"-filter-VideoCodecs"),_usersettings.default.remove(basekey+"-filter-ExtendedVideoTypes"),_usersettings.default.remove(basekey+"-filter-SubtitleCodecs"),_usersettings.default.remove(basekey+"-filter-Years"),this.itemsContainer.refreshItems()},ListController.prototype.destroyAlphaNumericShortcuts=function(){var alphaNumericShortcuts=this.alphaNumericShortcuts;alphaNumericShortcuts&&(alphaNumericShortcuts.destroy(),this.alphaNumericShortcuts=null)},ListController.prototype.resume=function(options){options.refresh||this.configureScrollingForView()},ListController.prototype.pause=function(){var itemsContainer=this.itemsContainer,itemsContainer=(itemsContainer&&itemsContainer.pause&&itemsContainer.pause(),this.alphaNumericShortcuts);itemsContainer&&itemsContainer.pause()},ListController.prototype.destroy=function(){this.destroyAlphaNumericShortcuts(),this.filterButtons=null,this.alphaPicker&&(this.alphaPicker.destroy(),this.alphaPicker=null),removeScrollListener(this),destroyHeader(this),this.sortButtons=null,this.btnSortText=null,this.btnSortIcon=null,this.alphaPickerElement=null,this.itemsViewSettingsContainer=null,this.paddedTopPageElem=null,this.view=null,this.itemsContainer=null,this.params=null};_exports.default=ListController});