/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.notifications;

import java.util.Date;
import org.eclipse.swt.graphics.Image;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPMessageType;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.notifications.AbstractUiNotification;

public class GeneralNotification
extends AbstractUiNotification {
    private final String label;
    private final String description;
    private final DBPMessageType messageType;
    private final Runnable feedback;
    private final Date date;

    public GeneralNotification(@NotNull String id, @NotNull String title, @NotNull String description, @Nullable DBPMessageType messageType, @Nullable Runnable feedback) {
        super("org.jkiss.dbeaver.notifications.event." + id);
        this.label = title;
        this.description = description;
        this.messageType = messageType;
        this.feedback = feedback;
        this.date = new Date();
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Date getDate() {
        return this.date;
    }

    public <T> T getAdapter(Class<T> adapter) {
        return null;
    }

    @Override
    public Image getNotificationImage() {
        return null;
    }

    @Override
    public Image getNotificationKindImage() {
        if (this.messageType == null) {
            return null;
        }
        switch (this.messageType) {
            case ERROR: {
                return DBeaverIcons.getImage((DBPImage)DBIcon.STATUS_ERROR);
            }
            case WARNING: {
                return DBeaverIcons.getImage((DBPImage)DBIcon.STATUS_WARNING);
            }
        }
        return DBeaverIcons.getImage((DBPImage)DBIcon.STATUS_INFO);
    }

    @Override
    public void open() {
        if (this.feedback != null) {
            this.feedback.run();
        }
    }
}

