/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.cubrid.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.cubrid.model.CubridDataSource;
import org.jkiss.dbeaver.ext.cubrid.model.CubridSynonym;
import org.jkiss.dbeaver.ext.cubrid.model.CubridUser;
import org.jkiss.dbeaver.ext.generic.model.GenericObjectContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericSynonym;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.utils.CommonUtils;

public class CubridSynonymManager
extends SQLObjectEditor<GenericSynonym, GenericStructContainer>
implements DBEObjectRenamer<GenericSynonym> {
    public static final String BASE_SYNONYM_NAME = "new_synonym";

    public long getMakerOptions(@NotNull DBPDataSource dataSource) {
        return 4L;
    }

    public DBSObjectCache<? extends DBSObject, GenericSynonym> getObjectsCache(GenericSynonym object) {
        GenericStructContainer parentObject = object.getParentObject();
        if (parentObject instanceof GenericObjectContainer) {
            GenericObjectContainer container = (GenericObjectContainer)parentObject;
            return container.getSynonymCache();
        }
        return null;
    }

    protected CubridSynonym createDatabaseObject(@NotNull DBRProgressMonitor monitor, @NotNull DBECommandContext context, @Nullable Object container, @Nullable Object copyFrom, @NotNull Map<String, Object> options) {
        return new CubridSynonym((GenericStructContainer)container, BASE_SYNONYM_NAME);
    }

    public String buildStatement(@NotNull SQLObjectEditor.NestedObjectCommand command, boolean isCreate) {
        StringBuilder query = new StringBuilder();
        CubridSynonym synonym = (CubridSynonym)command.getObject();
        query.append(isCreate ? "CREATE SYNONYM " : "ALTER SYNONYM ");
        query.append((Object)synonym.getOwner()).append(".").append(synonym.getName());
        query.append(" FOR ").append(synonym.getTargetObject());
        if (!synonym.isPersisted() && synonym.getDescription() != null || command.hasProperty((Object)"description")) {
            query.append(" COMMENT ").append(SQLUtils.quoteString((DBSObject)synonym, (String)CommonUtils.notEmpty((String)synonym.getDescription())));
        }
        return query.toString();
    }

    protected void addObjectCreateActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectCreateCommand command, @NotNull Map<String, Object> options) {
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create Synonym", this.buildStatement((SQLObjectEditor.NestedObjectCommand)command, true)));
    }

    protected void addObjectModifyActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectChangeCommand command, @NotNull Map<String, Object> options) {
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Modify Serial", this.buildStatement((SQLObjectEditor.NestedObjectCommand)command, false)));
    }

    protected void addObjectDeleteActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectDeleteCommand command, @NotNull Map<String, Object> options) {
        CubridSynonym synonym = (CubridSynonym)command.getObject();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Drop Synonym", "DROP SYNONYM " + String.valueOf((Object)synonym.getOwner()) + "." + synonym.getName()));
    }

    protected void addObjectRenameActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectRenameCommand command, @NotNull Map<String, Object> options) {
        CubridSynonym synonym = (CubridSynonym)command.getObject();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Rename Synonym", "RENAME SYNONYM " + String.valueOf((Object)synonym.getOwner()) + "." + command.getOldName() + " TO " + String.valueOf((Object)synonym.getOwner()) + "." + command.getNewName()));
    }

    public void renameObject(@NotNull DBECommandContext commandContext, @NotNull GenericSynonym object, @NotNull Map<String, Object> options, @NotNull String newName) throws DBException {
        if (!((CubridDataSource)object.getDataSource()).isShard()) {
            this.processObjectRename(commandContext, (DBSObject)object, options, newName);
        }
    }

    public boolean canCreateObject(@NotNull Object container) {
        CubridUser user = (CubridUser)((Object)container);
        CubridDataSource dataSource = (CubridDataSource)user.getDataSource();
        return dataSource.isShard();
    }

    public boolean canEditObject(GenericSynonym object) {
        return !((CubridDataSource)object.getDataSource()).isShard();
    }

    public boolean canDeleteObject(GenericSynonym object) {
        return !((CubridDataSource)object.getDataSource()).isShard();
    }

    public boolean canRenameObject(GenericSynonym object) {
        return !((CubridDataSource)object.getDataSource()).isShard();
    }
}

