/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.chart;

import com.ibm.icu.util.ULocale;
import com.nvidia.viper.birt.Activator;
import com.nvidia.viper.chart.BirtChartFactory;
import com.nvidia.viper.chart.IColorDefinitionsManager;
import com.nvidia.viper.chart.ui.IViperChart;
import com.nvidia.viper.chart.ui.ReportViperChartEventHandler;
import com.nvidia.viper.chart.ui.SWTColorsManager;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.GeneratedChartState;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.factory.RunTimeContext;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.script.AbstractScriptHandler;
import org.eclipse.birt.chart.script.IScriptClassLoader;
import org.eclipse.birt.chart.script.ScriptHandler;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.swt.widgets.Display;

public class BirtChartSVGUtil {
    public static boolean createChartSVG(final IViperChart viperChart, final String path, final int width, final int height) {
        final boolean[] success = new boolean[]{false};
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    IDeviceRenderer idr = PluginSettings.instance().getDevice("dv.SVG");
                    IColorDefinitionsManager colorDefManager = SWTColorsManager.forReport(Display.getDefault());
                    Chart birtChart = BirtChartFactory.createBirtChart(viperChart, colorDefManager);
                    RunTimeContext rtc = BirtChartSVGUtil.constructRunTimeContext();
                    Generator gr = Generator.instance();
                    GeneratedChartState gcs = null;
                    Bounds bo = BoundsImpl.create((double)0.0, (double)0.0, (double)width, (double)height);
                    gcs = gr.build(idr.getDisplayServer(), birtChart, bo, null, rtc, null);
                    idr.setProperty("device.file.identifier", (Object)path);
                    gr.render(idr, gcs);
                    success[0] = true;
                }
                catch (ChartException chartException) {}
            }
        });
        return success[0];
    }

    private static RunTimeContext constructRunTimeContext() throws ChartException {
        RunTimeContext rtc = new RunTimeContext();
        ScriptHandler handler = new ScriptHandler();
        handler.setScriptClassLoader(new IScriptClassLoader(){

            public Class<?> loadClass(String className, ClassLoader parentLoader) throws ClassNotFoundException {
                return BirtChartSVGUtil.class.getClassLoader().loadClass(className);
            }
        });
        try {
            handler.register("beforeDrawAxisLabel", ReportViperChartEventHandler.class.getName());
            rtc.setScriptHandler((AbstractScriptHandler)handler);
            rtc.setULocale(ULocale.getDefault());
        }
        catch (ChartException e) {
            Activator.log((Exception)((Object)e));
        }
        return rtc;
    }
}

