/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui.analysis;

import com.nvidia.viper.ViperExceptionHandler;
import com.nvidia.viper.analysis.AnalysisResult;
import com.nvidia.viper.analysis.AnalysisResultKernelMemory;
import com.nvidia.viper.ui.analysis.DataGrid;
import com.nvidia.viper.ui.analysis.DataGridAndLabelSVG;
import com.nvidia.viper.ui.analysis.KernelMemoryDataGrid;
import com.nvidia.viper.ui.analysis.MemoryDataTablePainter;
import com.nvidia.viper.ui.analysis.SVGGraphics2DUtils;
import org.apache.batik.svggen.SVGGraphics2D;

public class KernelMemoryResultSVG
extends DataGridAndLabelSVG {
    private DataGrid headerTable;
    private DataGrid tableL1Shared;
    private DataGrid tableShared;
    private DataGrid tableTex;
    private DataGrid tableL2;
    private DataGrid tableDram;
    private DataGrid tableSmem;
    private DataGrid tableUnified;
    private final AnalysisResult result;
    private boolean initialized = false;

    public KernelMemoryResultSVG(AnalysisResult result) {
        this.result = result;
    }

    @Override
    protected void initTables(SVGGraphics2D svg2d) {
        if (!this.initialized) {
            double avgWidth = SVGGraphics2DUtils.getAvgFontWidth(svg2d);
            int charWidth = (int)avgWidth;
            this.headerTable = this.setupTable(charWidth);
            this.components.add(this.headerTable);
            this.headerTable.setHeader(true);
            this.setInput(this.getResult(), charWidth);
            this.initialized = true;
        }
    }

    private DataGrid createDataTable(String label, String secondaryLabel, int charWidth) {
        this.components.add(label);
        if (secondaryLabel != null) {
            this.components.add(secondaryLabel);
        }
        DataGrid table = this.setupTable(charWidth);
        this.components.add(table);
        return table;
    }

    private DataGrid setupTable(int charWidth) {
        DataGrid table = new DataGrid(new MemoryDataTablePainter());
        table.addColumn(charWidth * 30, 16384);
        table.addColumn(charWidth * 16, 0);
        table.addColumn(charWidth * 16, 0);
        return table;
    }

    public void setInput(AnalysisResultKernelMemory result, int charWidth) {
        this.headerTable.addRow(null, "Transactions", "Bandwidth", "Utilization");
        for (AnalysisResultKernelMemory.MemoryUnit mu : result.getMemoryUnits()) {
            switch (mu) {
                case L1SHARED: {
                    this.tableL1Shared = this.createDataTable("L1/Shared Memory", null, charWidth);
                    KernelMemoryDataGrid.fillL1SharedMemoryTable(this.tableL1Shared, result);
                    break;
                }
                case SHARED: {
                    this.tableShared = this.createDataTable("Shared Memory", null, charWidth);
                    KernelMemoryDataGrid.fillSharedMemoryTable(this.tableShared, result);
                    break;
                }
                case TEX: {
                    this.tableTex = this.createDataTable("Texture Cache", null, charWidth);
                    KernelMemoryDataGrid.fillTexCacheTable(this.tableTex, result);
                    break;
                }
                case L2: {
                    this.tableL2 = this.createDataTable("L2 Cache", null, charWidth);
                    KernelMemoryDataGrid.fillL2CacheTable(this.tableL2, result);
                    break;
                }
                case DRAM: {
                    this.tableDram = this.createDataTable("Device Memory", null, charWidth);
                    KernelMemoryDataGrid.fillDramTable(this.tableDram, result);
                    break;
                }
                case SYSMEM: {
                    this.tableSmem = this.createDataTable("System Memory", this.getResult().getSystemMemoryLabel(), charWidth);
                    KernelMemoryDataGrid.fillSystemMemoryTable(this.tableSmem, result);
                    break;
                }
                case UNIFIED: {
                    this.tableUnified = this.createDataTable("Unified Cache", null, charWidth);
                    KernelMemoryDataGrid.fillUnifiedCacheTable(this.tableUnified, result);
                    break;
                }
                default: {
                    ViperExceptionHandler.logError("unexpected MemoryUnit: " + (Object)((Object)mu));
                }
            }
        }
    }

    private AnalysisResultKernelMemory getResult() {
        return (AnalysisResultKernelMemory)this.result;
    }
}

