/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.model;

import com.nvidia.viper.ViperException;
import com.nvidia.viper.model.IModel;
import com.nvidia.viper.model.ISessionSerializable;
import com.nvidia.viper.model.ModelWithProperties;
import com.nvidia.viper.model.RegionOfInterest;
import com.nvidia.viper.model.Session;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TimelineRuler
extends ModelWithProperties
implements IModel,
ISessionSerializable {
    public static final String PROPERTY_REGION_OF_INTEREST = "hruler:roi";
    private Session session;
    private List<RegionOfInterest> regionsOfInterest;
    private int roiNextUid;

    public TimelineRuler(Session session) {
        this.session = session;
        this.regionsOfInterest = new LinkedList<RegionOfInterest>();
        this.roiNextUid = 0;
    }

    public TimelineRuler(Session session, Element el) throws ViperException {
        this(session);
        this.read(el);
    }

    public Session getSession() {
        return this.session;
    }

    public List<RegionOfInterest> getRegionsOfInterest() {
        return Collections.unmodifiableList(this.regionsOfInterest);
    }

    public RegionOfInterest getRegionOfInterest(int uid) {
        for (RegionOfInterest roi : this.regionsOfInterest) {
            if (roi.getUid() != uid) continue;
            return roi;
        }
        return null;
    }

    public List<RegionOfInterest> getContainingRegionsOfInterest(long ns, int slop) {
        LinkedList<RegionOfInterest> rois = new LinkedList<RegionOfInterest>();
        for (RegionOfInterest roi : this.regionsOfInterest) {
            long low = Math.min(roi.getStart(), roi.getEnd()) - (long)slop;
            long high = Math.max(roi.getStart(), roi.getEnd()) + (long)slop;
            if (low > ns || high < ns) continue;
            rois.add(roi);
        }
        return rois;
    }

    public RegionOfInterest addRegionOfInterest(boolean selected, long start, long end) {
        RegionOfInterest roi = new RegionOfInterest(this.roiNextUid++, selected, start, end);
        this.regionsOfInterest.add(0, roi);
        this.firePropertyChange(PROPERTY_REGION_OF_INTEREST);
        return roi;
    }

    public void moveRegionOfInterest(RegionOfInterest roi, long startns, long endns) {
        if (startns != -1L && roi.getStart() != startns || endns != -1L && roi.getEnd() != endns) {
            if (startns != -1L) {
                roi.setStart(startns);
            }
            if (endns != -1L) {
                roi.setEnd(endns);
            }
            this.firePropertyChange(PROPERTY_REGION_OF_INTEREST);
        }
    }

    public RegionOfInterest removeRegionOfInterest(RegionOfInterest roi) {
        List<RegionOfInterest> removedRoi = this.removeRegionsOfInterest(Arrays.asList(roi));
        if (removedRoi.size() == 1) {
            return removedRoi.get(0);
        }
        return null;
    }

    public List<RegionOfInterest> removeRegionsOfInterest(Collection<RegionOfInterest> rois) {
        boolean change = false;
        ArrayList<RegionOfInterest> removedRois = new ArrayList<RegionOfInterest>(this.regionsOfInterest.size());
        ListIterator<RegionOfInterest> iter = this.regionsOfInterest.listIterator();
        while (iter.hasNext()) {
            RegionOfInterest roi = iter.next();
            if (!rois.contains(roi)) continue;
            removedRois.add(roi);
            iter.remove();
            change = true;
        }
        if (change) {
            this.firePropertyChange(PROPERTY_REGION_OF_INTEREST);
        }
        return removedRois;
    }

    public RegionOfInterest deselectRegionOfInterest(RegionOfInterest roi) {
        List<RegionOfInterest> deselectedRoi = this.deselectRegionsOfInterest(Arrays.asList(roi));
        if (deselectedRoi.size() == 1) {
            return deselectedRoi.get(0);
        }
        return null;
    }

    public List<RegionOfInterest> deselectRegionsOfInterest(Collection<RegionOfInterest> rois) {
        boolean change = false;
        ArrayList<RegionOfInterest> deselectedRois = new ArrayList<RegionOfInterest>(this.regionsOfInterest.size());
        ListIterator<RegionOfInterest> iter = this.regionsOfInterest.listIterator();
        while (iter.hasNext()) {
            RegionOfInterest roi = iter.next();
            if (!roi.isSelected() || !rois.contains(roi)) continue;
            deselectedRois.add(roi);
            roi.setSelected(false);
            change = true;
        }
        if (change) {
            this.firePropertyChange(PROPERTY_REGION_OF_INTEREST);
        }
        return deselectedRois;
    }

    public void prioritizeRegionOfInterest(int upUid, int downUid, boolean appendSelect) {
        RegionOfInterest up = null;
        RegionOfInterest down = null;
        int numRegions = this.regionsOfInterest.size();
        RegionOfInterest first = numRegions > 0 ? this.regionsOfInterest.get(0) : null;
        RegionOfInterest last = numRegions > 0 ? this.regionsOfInterest.get(numRegions - 1) : null;
        ListIterator<RegionOfInterest> iter = this.regionsOfInterest.listIterator();
        while (iter.hasNext()) {
            RegionOfInterest roi = iter.next();
            if (roi != first && roi.getUid() == upUid) {
                iter.remove();
                up = roi;
            } else if (roi != last && roi.getUid() == downUid) {
                iter.remove();
                down = roi;
            }
            if (appendSelect) continue;
            roi.setSelected(false);
        }
        if (up != null) {
            this.regionsOfInterest.add(0, up);
            up.setSelected(true);
        }
        if (down != null) {
            this.regionsOfInterest.add(down);
        }
        if (first.getUid() == upUid) {
            first.setSelected(true);
        }
        if (up != null || down != null || first.getUid() == upUid) {
            this.firePropertyChange(PROPERTY_REGION_OF_INTEREST);
        }
    }

    @Override
    public void write(Writer w) throws ViperException {
        try {
            w.write("<hruler>\n");
            for (RegionOfInterest roi : this.regionsOfInterest) {
                roi.write(w);
            }
            w.write("</hruler>\n");
        }
        catch (IOException e) {
            throw new ViperException(e);
        }
    }

    protected void read(Element el) throws ViperException {
        if (!"hruler".equals(el.getTagName())) {
            throw new ViperException("expected \"hruler\" tag, got " + el.getTagName());
        }
        this.roiNextUid = 0;
        try {
            NodeList roiList = el.getElementsByTagName("roi");
            int i = 0;
            while (i < roiList.getLength()) {
                Element roiElement = (Element)roiList.item(i);
                RegionOfInterest roi = new RegionOfInterest(roiElement);
                this.regionsOfInterest.add(roi);
                this.roiNextUid = Math.max(this.roiNextUid, roi.getUid() + 1);
                ++i;
            }
        }
        catch (NumberFormatException e) {
            throw new ViperException("unable to parse region-of-interest", e);
        }
    }
}

