/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.model;

import com.nvidia.viper.EventManager;
import com.nvidia.viper.MetricManager;
import com.nvidia.viper.ViperException;
import com.nvidia.viper.jni.CuptiEvent;
import com.nvidia.viper.jni.CuptiEventCategory;
import com.nvidia.viper.jni.CuptiMetric;
import com.nvidia.viper.jni.CuptiMetricCategory;
import com.nvidia.viper.model.Event;
import com.nvidia.viper.model.EventCategory;
import com.nvidia.viper.model.Metric;
import com.nvidia.viper.model.MetricCategory;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DeviceDescriptor {
    private final String name;
    private int computeCapabilityMajor;
    private int computeCapabilityMinor;
    private Set<Event> events;
    private Map<CuptiEventCategory, EventCategory> eventCategoryMap;
    private Set<Metric> metrics;
    private Map<CuptiMetricCategory, MetricCategory> metricCategoryMap;

    public DeviceDescriptor(String name, int computeCapabilityMajor, int computeCapabilityMinor, List<CuptiEvent> cuptiEvents, List<CuptiMetric> cuptiMetrics) throws ViperException {
        Comparable<EventCategory> cat;
        Enum category;
        this.name = name;
        this.computeCapabilityMajor = computeCapabilityMajor;
        this.computeCapabilityMinor = computeCapabilityMinor;
        this.events = new HashSet<Event>(cuptiEvents.size());
        this.eventCategoryMap = new HashMap<CuptiEventCategory, EventCategory>();
        this.metrics = new HashSet<Metric>(cuptiMetrics.size());
        this.metricCategoryMap = new HashMap<CuptiMetricCategory, MetricCategory>();
        for (CuptiEvent e : cuptiEvents) {
            Event event = EventManager.getEvent(e.domain, e.id);
            if (event == null) {
                throw new ViperException("unknown event " + e.name);
            }
            this.events.add(event);
            category = CuptiEventCategory.valueOf(e.category);
            if (category == null) {
                category = CuptiEventCategory.CUPTI_EVENT_CATEGORY_MISC;
            }
            if ((cat = this.eventCategoryMap.get(category)) == null) {
                cat = new EventCategory((CuptiEventCategory)category);
                this.eventCategoryMap.put((CuptiEventCategory)category, (EventCategory)cat);
            }
            ((EventCategory)cat).addEvent(event);
        }
        for (CuptiMetric m : cuptiMetrics) {
            Metric metric = MetricManager.getMetric(m.id);
            if (metric == null) {
                throw new ViperException("unknown metric " + m.name);
            }
            this.metrics.add(metric);
            category = CuptiMetricCategory.valueOf(m.category);
            if (category == null) {
                category = CuptiMetricCategory.CUPTI_METRIC_CATEGORY_MISC;
            }
            if ((cat = this.metricCategoryMap.get(category)) == null) {
                cat = new MetricCategory((CuptiMetricCategory)category);
                this.metricCategoryMap.put((CuptiMetricCategory)category, (MetricCategory)cat);
            }
            ((MetricCategory)cat).addMetric(metric);
        }
    }

    public String getName() {
        return this.name;
    }

    public int getComputeCapabilityMajor() {
        return this.computeCapabilityMajor;
    }

    public int getComputeCapabilityMinor() {
        return this.computeCapabilityMinor;
    }

    public boolean isSupportedEvent(Event event) {
        return this.events.contains(event);
    }

    public Collection<Event> getEvents() {
        return Collections.unmodifiableCollection(this.events);
    }

    public Collection<EventCategory> getEventCategories() {
        return Collections.unmodifiableCollection(this.eventCategoryMap.values());
    }

    public Event getEvent(String eventName) {
        Set<Event> fevents = EventManager.getEvents(eventName);
        HashSet<Event> rcc = new HashSet<Event>(fevents);
        rcc.retainAll(this.getEvents());
        if (rcc.isEmpty()) {
            return null;
        }
        return (Event)rcc.iterator().next();
    }

    public boolean isSupportedMetric(Metric metric) {
        return this.metrics.contains(metric);
    }

    public Collection<Metric> getMetrics() {
        return Collections.unmodifiableCollection(this.metrics);
    }

    public Collection<MetricCategory> getMetricCategories() {
        return Collections.unmodifiableCollection(this.metricCategoryMap.values());
    }

    public Metric getMetric(String metricName) {
        Set<Metric> fmetrics = MetricManager.getMetrics(metricName);
        HashSet<Metric> rcc = new HashSet<Metric>(fmetrics);
        rcc.retainAll(this.getMetrics());
        if (rcc.isEmpty()) {
            return null;
        }
        return (Metric)rcc.iterator().next();
    }

    public String toString() {
        return this.getName();
    }
}

