/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.analysis;

import com.nvidia.viper.ViperExceptionHandler;
import com.nvidia.viper.activity.CuptiActivitySourceLocator;
import com.nvidia.viper.activity.ICuptiActivitySourceLevelResult;
import com.nvidia.viper.analysis.AnalysisResult;
import com.nvidia.viper.analysis.AnalysisResultSourceLevel;
import com.nvidia.viper.birt.report.ReportTableData;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.ui.analysis.IAnalysisResultSVG;
import com.nvidia.viper.ui.analysis.SourceLevelLocatedResult;
import java.net.URI;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.swt.graphics.GC;

public class SourceLevelResultSVG
implements IAnalysisResultSVG {
    private final AnalysisResult result;
    private final Session session;
    private ReportTableData[] tableDataArr = null;

    public SourceLevelResultSVG(AnalysisResult result, Session session) {
        this.result = result;
        this.session = session;
    }

    @Override
    public boolean createSVG(String filePath, int width, int height, GC gc) {
        return false;
    }

    @Override
    public int getPreferredSVGHieght(GC gc) {
        return 0;
    }

    @Override
    public ReportTableData[] getTableElements() {
        ReportTableData[] tableDataSet = this.constructReportTableDataArr();
        return tableDataSet;
    }

    private ReportTableData[] constructReportTableDataArr() {
        if (this.tableDataArr == null) {
            AnalysisResultSourceLevel input = this.getSourceLevelResult();
            HashMap<URI, HashSet<SourceLevelLocatedResult>> locationsMap = new HashMap<URI, HashSet<SourceLevelLocatedResult>>();
            for (ICuptiActivitySourceLevelResult result : input.getSourceLevelResults()) {
                CuptiActivitySourceLocator locator = this.session.getSourceLocator().getLocation(result.getSourceLocatorId());
                if (locator == null) {
                    ViperExceptionHandler.logError("unable to get source location " + result.getSourceLocatorId());
                    continue;
                }
                HashSet<SourceLevelLocatedResult> results = (HashSet<SourceLevelLocatedResult>)locationsMap.get(locator.getFileUri());
                if (results == null) {
                    results = new HashSet<SourceLevelLocatedResult>();
                    locationsMap.put(locator.getFileUri(), results);
                }
                results.add(new SourceLevelLocatedResult(locator.getFileUri(), locator.lineNumber, result));
            }
            Object[] locationsArr = locationsMap.keySet().toArray(new URI[0]);
            Arrays.sort(locationsArr);
            this.tableDataArr = new ReportTableData[locationsArr.length];
            int tableNum = 0;
            while (tableNum < locationsArr.length) {
                Object location = locationsArr[tableNum];
                String caption = ((URI)location).toString();
                Set srcLevelResult = (Set)locationsMap.get(location);
                SourceLevelLocatedResult[] srcLvlResArr = srcLevelResult.toArray(new SourceLevelLocatedResult[0]);
                Arrays.sort(srcLvlResArr, new Comparator<SourceLevelLocatedResult>(){

                    @Override
                    public int compare(SourceLevelLocatedResult o1, SourceLevelLocatedResult o2) {
                        return o1.lineNumber - o2.lineNumber;
                    }
                });
                String[][] lineNoDescRow = new String[srcLvlResArr.length][2];
                int rowNum = 0;
                while (rowNum < srcLvlResArr.length) {
                    SourceLevelLocatedResult srcLvlRes = srcLvlResArr[rowNum];
                    int lineNum = srcLvlRes.lineNumber;
                    String description = this.getSourceLevelResult().getResultDescription(srcLvlRes.result);
                    lineNoDescRow[rowNum][0] = "Line " + lineNum;
                    lineNoDescRow[rowNum][1] = description;
                    ++rowNum;
                }
                this.tableDataArr[tableNum] = new ReportTableData(lineNoDescRow, caption, null, 0, lineNoDescRow.length, 0, 2);
                ++tableNum;
            }
        }
        return this.tableDataArr;
    }

    private AnalysisResultSourceLevel getSourceLevelResult() {
        return (AnalysisResultSourceLevel)this.result;
    }
}

