/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.db.paros;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.db.DbUtils;
import org.parosproxy.paros.db.paros.ParosAbstractTable;
import org.zaproxy.zap.db.RecordAlertTag;
import org.zaproxy.zap.db.TableAlertTag;

public class ParosTableAlertTag
extends ParosAbstractTable
implements TableAlertTag {
    private PreparedStatement psReadByTagId;
    private PreparedStatement psReadByAlertIdTagKey;
    private PreparedStatement psInsertOrUpdate;
    private PreparedStatement psGetAllTags;
    private PreparedStatement psGetTagsByAlertId;
    private PreparedStatement psGetAllRecords;
    private PreparedStatement psDeleteByTagId;
    private PreparedStatement psDeleteByAlertIdTagKey;
    private PreparedStatement psDeleteAllTagsForAlert;
    private PreparedStatement psDeleteAllTags;

    @Override
    protected void reconnect(Connection conn) throws DatabaseException {
        try {
            if (!DbUtils.hasTable(conn, "ALERT_TAG")) {
                DbUtils.execute(conn, "CREATE CACHED TABLE alert_tag (tag_id bigint generated by default as identity (start with 1) primary key,alert_id bigint not null,key varchar(1024) default '' not null,value nvarchar(4000) default '' not null,)");
            }
            if (!DbUtils.hasIndex(conn, "ALERT_TAG", "ALERT_ID_INDEX")) {
                DbUtils.execute(conn, "CREATE INDEX alert_id_index ON alert_tag (alert_id)");
            }
            this.psReadByTagId = conn.prepareStatement("SELECT * FROM alert_tag WHERE tag_id = ?");
            this.psReadByAlertIdTagKey = conn.prepareStatement("SELECT * FROM alert_tag WHERE alert_id = ? AND key = ?");
            this.psInsertOrUpdate = conn.prepareStatement("MERGE INTO alert_tag AS tag USING (VALUES(?, ?, ?)) AS v(aid, key, val) ON tag.alert_id = v.aid AND tag.key = v.key WHEN MATCHED AND tag.value <> v.val THEN UPDATE SET tag.value = v.val WHEN NOT MATCHED THEN INSERT (alert_id, key, value) VALUES (v.aid, v.key, v.val)");
            this.psGetTagsByAlertId = conn.prepareStatement("SELECT * FROM alert_tag WHERE alert_id = ?");
            this.psGetAllTags = conn.prepareStatement("SELECT DISTINCT key, value FROM alert_tag ORDER BY key");
            this.psGetAllRecords = conn.prepareStatement("SELECT * FROM alert_tag ORDER BY alert_id ASC");
            this.psDeleteByTagId = conn.prepareStatement("DELETE FROM alert_tag WHERE tag_id = ?");
            this.psDeleteByAlertIdTagKey = conn.prepareStatement("DELETE FROM alert_tag WHERE alert_id = ? AND key = ?");
            this.psDeleteAllTagsForAlert = conn.prepareStatement("DELETE FROM alert_tag WHERE alert_id = ?");
            this.psDeleteAllTags = conn.prepareStatement("DELETE FROM alert_tag");
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public synchronized RecordAlertTag read(long tagId) throws DatabaseException {
        RecordAlertTag recordAlertTag;
        block8: {
            this.psReadByTagId.setLong(1, tagId);
            ResultSet rs = this.psReadByTagId.executeQuery();
            try {
                recordAlertTag = this.build(rs);
                if (rs == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new DatabaseException(e);
                }
            }
            rs.close();
        }
        return recordAlertTag;
    }

    @Override
    public synchronized RecordAlertTag read(long alertId, String key) throws DatabaseException {
        RecordAlertTag recordAlertTag;
        block8: {
            this.psReadByAlertIdTagKey.setLong(1, alertId);
            this.psReadByAlertIdTagKey.setString(2, key);
            ResultSet rs = this.psReadByAlertIdTagKey.executeQuery();
            try {
                recordAlertTag = this.build(rs);
                if (rs == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new DatabaseException(e);
                }
            }
            rs.close();
        }
        return recordAlertTag;
    }

    @Override
    public synchronized RecordAlertTag insertOrUpdate(long alertId, String key, String value) throws DatabaseException {
        try {
            this.psInsertOrUpdate.setLong(1, alertId);
            this.psInsertOrUpdate.setString(2, key);
            this.psInsertOrUpdate.setString(3, value);
            this.psInsertOrUpdate.executeUpdate();
            return this.read(alertId, key);
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public synchronized void delete(long tagId) throws DatabaseException {
        try {
            this.psDeleteByTagId.setLong(1, tagId);
            this.psDeleteByTagId.executeUpdate();
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public synchronized void delete(long alertId, String key) throws DatabaseException {
        try {
            this.psDeleteByAlertIdTagKey.setLong(1, alertId);
            this.psDeleteByAlertIdTagKey.setString(2, key);
            this.psDeleteByAlertIdTagKey.executeUpdate();
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public synchronized void deleteAllTagsForAlert(long alertId) throws DatabaseException {
        try {
            this.psDeleteAllTagsForAlert.setLong(1, alertId);
            this.psDeleteAllTagsForAlert.executeUpdate();
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public synchronized int deleteAllTags() throws DatabaseException {
        try {
            return this.psDeleteAllTags.executeUpdate();
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public synchronized Map<String, String> getTagsByAlertId(long alertId) throws DatabaseException {
        try {
            HashMap<String, String> result = new HashMap<String, String>();
            this.psGetTagsByAlertId.setLong(1, alertId);
            try (ResultSet rs = this.psGetTagsByAlertId.executeQuery();){
                while (rs.next()) {
                    result.put(rs.getString("key"), rs.getString("value"));
                }
            }
            return result;
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public synchronized Map<String, String> getAllTags() throws DatabaseException {
        try {
            HashMap<String, String> result = new HashMap<String, String>();
            try (ResultSet rs = this.psGetAllTags.executeQuery();){
                while (rs.next()) {
                    result.put(rs.getString("key"), rs.getString("value"));
                }
            }
            return result;
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public synchronized List<RecordAlertTag> getAllRecords() throws DatabaseException {
        try {
            ArrayList<RecordAlertTag> result = new ArrayList<RecordAlertTag>();
            try (ResultSet rs = this.psGetAllRecords.executeQuery();){
                RecordAlertTag rat;
                while ((rat = this.build(rs)) != null) {
                    result.add(rat);
                }
            }
            return result;
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    private RecordAlertTag build(ResultSet rs) throws SQLException {
        RecordAlertTag rat = null;
        if (rs.next()) {
            rat = new RecordAlertTag(rs.getLong("tag_id"), rs.getLong("alert_id"), rs.getString("key"), rs.getString("value"));
        }
        return rat;
    }
}

