/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http2;

import java.nio.ByteBuffer;
import org.apache.coyote.http2.AbstractNonZeroStream;
import org.apache.coyote.http2.ConnectionException;
import org.apache.coyote.http2.Http2Exception;
import org.apache.coyote.http2.StreamStateMachine;

class RecycledStream
extends AbstractNonZeroStream {
    private final String connectionId;
    private int remainingFlowControlWindow;

    RecycledStream(String string, Integer n, StreamStateMachine streamStateMachine, int n2) {
        super(n, streamStateMachine);
        this.connectionId = string;
        this.remainingFlowControlWindow = n2;
    }

    @Override
    String getConnectionId() {
        return this.connectionId;
    }

    @Override
    void incrementWindowSize(int n) throws Http2Exception {
    }

    @Override
    void receivedData(int n) throws ConnectionException {
        this.remainingFlowControlWindow -= n;
    }

    @Override
    ByteBuffer getInputByteBuffer() {
        if (this.remainingFlowControlWindow < 0) {
            return ZERO_LENGTH_BYTEBUFFER;
        }
        return null;
    }
}

